<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Component\Core\Provider;

use Doctrine\Common\Collections\ArrayCollection;
use Sylius\Component\Core\Calculator\ProductVariantPriceCalculatorInterface;
use Sylius\Component\Core\Calculator\ProductVariantPricesCalculatorInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Core\Model\ProductInterface;
use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Core\Provider\ProductVariantMap\ProductVariantsMapProvider;
use Sylius\Component\Product\Model\ProductOptionValueInterface;

/** @deprecated since Sylius 1.13 and will be removed in Sylius 2.0. Use {@see ProductVariantsMapProvider} instead. */
final class ProductVariantsPricesProvider implements ProductVariantsPricesProviderInterface
{
    public function __construct(private ProductVariantPriceCalculatorInterface $productVariantPriceCalculator)
    {
        trigger_deprecation(
            'sylius/core-bundle',
            '1.13',
            'The "%s" class is deprecated and will be removed in Sylius 2.0. Use "%s" instead.',
            self::class,
            ProductVariantsMapProvider::class,
        );
    }

    public function provideVariantsPrices(ProductInterface $product, ChannelInterface $channel): array
    {
        $variantsPrices = [];

        /** @var ProductVariantInterface $variant */
        foreach ($product->getEnabledVariants() as $variant) {
            $variantsPrices[] = $this->constructOptionsMap($variant, $channel);
        }

        return $variantsPrices;
    }

    private function constructOptionsMap(ProductVariantInterface $variant, ChannelInterface $channel): array
    {
        $optionMap = [];

        /** @var ProductOptionValueInterface $option */
        foreach ($variant->getOptionValues() as $option) {
            /** @var string $optionCode */
            $optionCode = $option->getOptionCode();
            $optionMap[$optionCode] = $option->getCode();
        }

        $price = $this->productVariantPriceCalculator->calculate($variant, ['channel' => $channel]);
        $optionMap['value'] = $price;

        /** @var ArrayCollection $appliedPromotions */
        $appliedPromotions = $variant->getAppliedPromotionsForChannel($channel);
        if (!$appliedPromotions->isEmpty()) {
            $optionMap['applied_promotions'] = $appliedPromotions->toArray();
        }

        if (!$this->productVariantPriceCalculator instanceof ProductVariantPricesCalculatorInterface) {
            return $optionMap;
        }

        if (\method_exists($this->productVariantPriceCalculator, 'calculateLowestPriceBeforeDiscount')) {
            $lowestPriceBeforeDiscount = $this->productVariantPriceCalculator->calculateLowestPriceBeforeDiscount($variant, ['channel' => $channel]);

            if ($lowestPriceBeforeDiscount !== null) {
                $optionMap['lowest-price-before-discount'] = $lowestPriceBeforeDiscount;
            }
        } else {
            trigger_deprecation(
                'sylius/sylius',
                '1.13',
                'Not having `calculateLowestPriceBeforeDiscount` method on %s is deprecated since Sylius 1.13 and will be required in Sylius 2.0.',
                $this->productVariantPriceCalculator::class,
            );
        }

        $originalPrice = $this->productVariantPriceCalculator->calculateOriginal($variant, ['channel' => $channel]);

        if ($originalPrice > $price) {
            $optionMap['original-price'] = $originalPrice;
        }

        return $optionMap;
    }
}
