# CHANGELOG FOR `1.9.X`

## v1.9.10 (2022-03-14)

#### Details

- [#13275](https://github.com/Sylius/Sylius/issues/13275) [Maintenance] Add note about doctrine/dbal requirement ([@lchrusciel](https://github.com/lchrusciel))
- [#13282](https://github.com/Sylius/Sylius/issues/13282) [API] Revert changes of checked keys in cart and checkout responses to fix the build ([@GSadee](https://github.com/GSadee))
- [#13730](https://github.com/Sylius/Sylius/issues/13730) [Maintenance] Add conflict to symfony/framework-bundle to fix problem with solving path prefix in API scenarios ([@GSadee](https://github.com/GSadee))
- [#13750](https://github.com/Sylius/Sylius/issues/13750) [Admin][Shop] placehold.it replaced to local placeholders ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13765](https://github.com/Sylius/Sylius/issues/13765) [Security] Fixes for SVG XSS, wrong cache for logged in users and clickjacking ([@ernestWarwas](https://github.com/ernestWarwas), [@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee), [@Zales0123](https://github.com/Zales0123), [@Rafikooo](https://github.com/Rafikooo))

## v1.9.9 (2021-11-03)

- [#13165](https://github.com/Sylius/Sylius/issues/13165) [HotFix] Add conflict to doctrine/orm to fix the problem with creating taxons ([@GSadee](https://github.com/GSadee))
- [#13173](https://github.com/Sylius/Sylius/issues/13173) [HotFix] Update conflict to doctrine/orm to fix the problem with creating taxons ([@GSadee](https://github.com/GSadee))
- [#13215](https://github.com/Sylius/Sylius/issues/13215) Add conflict with doctrine/dbal ^3 to avoid missing `json_array` doctrine type error ([@Prometee](https://github.com/Prometee))
- [#13216](https://github.com/Sylius/Sylius/issues/13216) [Maintenance] Bump node version in CI ([@lchrusciel](https://github.com/lchrusciel))
- [#13243](https://github.com/Sylius/Sylius/issues/13243) BUGFIX: #12859 Fix link to ResourceController in documentation ([@Jashi](https://github.com/Jashi))
- [#13244](https://github.com/Sylius/Sylius/issues/13244) Fix builds ([@nedac-sorbo](https://github.com/nedac-sorbo))
- [#13252](https://github.com/Sylius/Sylius/issues/13252) [Maintenance] Replace dbal conflict with explicit requirement ([@lchrusciel](https://github.com/lchrusciel))
- [#13261](https://github.com/Sylius/Sylius/issues/13261) Conflict liip/imagine-bundle ^2.7 ([@Zales0123](https://github.com/Zales0123))
- [#13263](https://github.com/Sylius/Sylius/issues/13263) Remove undocumented conflict on laminas-code ^4.0 ([@4c0n](https://github.com/4c0n))

## v1.9.8 (2021-09-30)

- [#12222](https://github.com/Sylius/Sylius/issues/12222) logo path corrected ([@Snowbaha](https://github.com/Snowbaha), [@CoderMaggie](https://github.com/CoderMaggie))
- [#12452](https://github.com/Sylius/Sylius/issues/12452) [Doc] Customizing admin routes prefix ([@oallain](https://github.com/oallain), [@CoderMaggie](https://github.com/CoderMaggie))
- [#12637](https://github.com/Sylius/Sylius/issues/12637) Missing Behat directory on the path to be excluded ([@tonicospinelli](https://github.com/tonicospinelli))
- [#12824](https://github.com/Sylius/Sylius/issues/12824) [Documentation] Fixed logo customization  (, [@CoderMaggie](https://github.com/CoderMaggie))
- [#12849](https://github.com/Sylius/Sylius/issues/12849) [Docs] Webpack - Display logo on login page ([@Jibbarth](https://github.com/Jibbarth))
- [#12863](https://github.com/Sylius/Sylius/issues/12863) Add yaml configuration examples to the "Custom Payment Gateway" cookbook ([@DennisCodeBuds](https://github.com/DennisCodeBuds))
- [#12892](https://github.com/Sylius/Sylius/issues/12892) [DOCS] Add note about docker builder ([@arti0090](https://github.com/arti0090))
- [#13070](https://github.com/Sylius/Sylius/issues/13070) [Minor][DI] Add interface alias to UriBasedSectionProvider ([@lchrusciel](https://github.com/lchrusciel))
- [#13102](https://github.com/Sylius/Sylius/issues/13102) Check if the form is submitted before validation ([@jacquesbh](https://github.com/jacquesbh))
- [#13154](https://github.com/Sylius/Sylius/issues/13154) [API] Do not allow to address empty cart ([@Zales0123](https://github.com/Zales0123))

## v1.9.7 (2021-09-02)

#### Details

- [#11623](https://github.com/Sylius/Sylius/issues/11623) Fix #11603, Update documentation to replace use of removed function ([@CoderMaggie](https://github.com/CoderMaggie))
- [#12085](https://github.com/Sylius/Sylius/issues/12085) [Doc] Add contact email ([@MatthieuCutin](https://github.com/MatthieuCutin), [@CoderMaggie](https://github.com/CoderMaggie))
- [#12223](https://github.com/Sylius/Sylius/issues/12223) Remove security.yaml change when disabling localized URLs ([@maximehuran](https://github.com/maximehuran))
- [#12852](https://github.com/Sylius/Sylius/issues/12852) [API] Do not check command arguments if there is an object to populate ([@GSadee](https://github.com/GSadee))
- [#12873](https://github.com/Sylius/Sylius/issues/12873) [Docs] sylius performance boost ([@SirDomin](https://github.com/SirDomin), [@arti0090](https://github.com/arti0090))
- [#12875](https://github.com/Sylius/Sylius/issues/12875) [Admin] Fix shipping totals in order summary ([@aleho](https://github.com/aleho))
- [#12881](https://github.com/Sylius/Sylius/issues/12881) [Documentation] Note about changes related to upgrade to GridBundle 1.10 ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#12973](https://github.com/Sylius/Sylius/issues/12973) Fix borders in order - show - addresses ([@pavol-tk](https://github.com/pavol-tk))
- [#12975](https://github.com/Sylius/Sylius/issues/12975) [Docs] fix annotations ([@SirDomin](https://github.com/SirDomin))
- [#12976](https://github.com/Sylius/Sylius/issues/12976) [Documentation] Minor fix in grids docs ([@GSadee](https://github.com/GSadee))
- [#12977](https://github.com/Sylius/Sylius/issues/12977) [Docs] add prefix to sylius customer table ([@SirDomin](https://github.com/SirDomin))
- [#12984](https://github.com/Sylius/Sylius/issues/12984) [Documentation] Move invoice cookbooks to payments section ([@GSadee](https://github.com/GSadee))
- [#12993](https://github.com/Sylius/Sylius/issues/12993) [Build] Force symfony flex in github actions ([@SirDomin](https://github.com/SirDomin))
- [#13018](https://github.com/Sylius/Sylius/issues/13018) [Bug] Fix default sylius config file path in Sylius 1.8 ([@lchrusciel](https://github.com/lchrusciel))
- [#13019](https://github.com/Sylius/Sylius/issues/13019) [Bug] Fix default sylius config file path in Sylius 1.9 ([@lchrusciel](https://github.com/lchrusciel))
- [#13032](https://github.com/Sylius/Sylius/issues/13032) [Docs] Choosing the right branch - fix ([@CoderMaggie](https://github.com/CoderMaggie))

## v1.9.6 (2021-07-30)

#### Details

- [#12751](https://github.com/Sylius/Sylius/issues/12751) [Docs] Describe API customization requirement for SyliusPlus with Sylius 1.9 ([@Zales0123](https://github.com/Zales0123), [@Tomanhez](https://github.com/Tomanhez))
- [#12763](https://github.com/Sylius/Sylius/issues/12763) [Docs] Remove redundant refund interfaces ([@Tomanhez](https://github.com/Tomanhez))
- [#12764](https://github.com/Sylius/Sylius/issues/12764) [Taxon] Wrap resource deletion operation with a transaction to fix a problem with removing used taxon ([@GSadee](https://github.com/GSadee))
- [#12767](https://github.com/Sylius/Sylius/issues/12767) [Documentation] Fix warning about version of Sylius in Plus installation guide ([@GSadee](https://github.com/GSadee))
- [#12770](https://github.com/Sylius/Sylius/issues/12770) [Documentation] One more fix for warning about version of Sylius in Plus installation guide ([@GSadee](https://github.com/GSadee))
- [#12771](https://github.com/Sylius/Sylius/issues/12771) [API] Turn on/off api endpoints with parameter ([@SirDomin](https://github.com/SirDomin))
- [#12776](https://github.com/Sylius/Sylius/issues/12776) [Docs][Plus] Modify plus installation guide ([@Tomanhez](https://github.com/Tomanhez))
- [#12784](https://github.com/Sylius/Sylius/issues/12784) [Documentation][Cookbook] How to add another type of refund? ([@GSadee](https://github.com/GSadee))
- [#12789](https://github.com/Sylius/Sylius/issues/12789) [API] Disable API by default ([@GSadee](https://github.com/GSadee))
- [#12801](https://github.com/Sylius/Sylius/issues/12801) [Documentation] Update Plus installation guide for Sylius 1.9 ([@GSadee](https://github.com/GSadee))
- [#12804](https://github.com/Sylius/Sylius/issues/12804) Enable API by default in dev environment ([@Zales0123](https://github.com/Zales0123))
- [#12807](https://github.com/Sylius/Sylius/issues/12807) Optimizing the attribute loading in product edit ([@mamazu](https://github.com/mamazu))
- [#12811](https://github.com/Sylius/Sylius/issues/12811) [API] Test not providing required fields during registration ([@Zales0123](https://github.com/Zales0123))
- [#12816](https://github.com/Sylius/Sylius/issues/12816) [Maintenance] Fix 1.8 build ([@GSadee](https://github.com/GSadee), [@SirDomin](https://github.com/SirDomin))
- [#12817](https://github.com/Sylius/Sylius/issues/12817) [Taxation] Add scenarios for applying proper taxes for shipping ([@GSadee](https://github.com/GSadee))
- [#12818](https://github.com/Sylius/Sylius/issues/12818) [Core] Bring back String u function ([@GSadee](https://github.com/GSadee))
- [#12819](https://github.com/Sylius/Sylius/issues/12819) [API] 1.8 api as opt ([@SirDomin](https://github.com/SirDomin))
- [#12823](https://github.com/Sylius/Sylius/issues/12823) [API] Allow creation of commands with no arguments with a default value ([@GSadee](https://github.com/GSadee))
- [#12833](https://github.com/Sylius/Sylius/issues/12833) [API] Disable API by default ([@GSadee](https://github.com/GSadee))
- [#12837](https://github.com/Sylius/Sylius/issues/12837) [UPGRADE] Split API and non API upgrade files ([@lchrusciel](https://github.com/lchrusciel))
- [#12838](https://github.com/Sylius/Sylius/issues/12838) [UPGRADE] Split API and non API upgrade files ([@lchrusciel](https://github.com/lchrusciel))
- [#12839](https://github.com/Sylius/Sylius/issues/12839) [UI] Add bottom scroll to the order summary table ([@kulczy](https://github.com/kulczy))
- [#12843](https://github.com/Sylius/Sylius/issues/12843) [Documentation] Change version of Plus in installation guide ([@GSadee](https://github.com/GSadee))
- [#12845](https://github.com/Sylius/Sylius/issues/12845) Quick Typo update :) ([@FaithlessLooting](https://github.com/FaithlessLooting))

## v1.9.5 (2021-06-28)

#### TL;DR

**This is a security release!**

Fixes the follwing vulnerability:

- [List of order ids, number, items total and token value exposed for unauthorized uses via new API](https://github.com/Sylius/Sylius/security/advisories/GHSA-rpxh-vg2x-526v)

#### Details

- [#12596](https://github.com/Sylius/Sylius/issues/12596) Country api resource shouldn't have created/updated at ([@kayue](https://github.com/kayue))
- [#12618](https://github.com/Sylius/Sylius/issues/12618) [Docs] Fix cookbook for custom entity ([@Tomanhez](https://github.com/Tomanhez))
- [#12682](https://github.com/Sylius/Sylius/issues/12682) Use Symfony 5.2.* instead of ^5.2 for GitHub Actions ([@pamil](https://github.com/pamil))
- [#12686](https://github.com/Sylius/Sylius/issues/12686) [DOCS] Cookbook for customizing refund process ([@arti0090](https://github.com/arti0090))
- [#12687](https://github.com/Sylius/Sylius/issues/12687) Fix typo and imporve error message ([@dantleech](https://github.com/dantleech))
- [#12690](https://github.com/Sylius/Sylius/issues/12690) [Doctrine] Fix problem with explicitly defining entity managers ([@GSadee](https://github.com/GSadee))
- [#12698](https://github.com/Sylius/Sylius/issues/12698) Fix the build with Symfony 5.3 ([@pamil](https://github.com/pamil))
- [#12699](https://github.com/Sylius/Sylius/issues/12699) [Documentation] Update templates directory in Themes doc ([@CoderMaggie](https://github.com/CoderMaggie))
- [#12702](https://github.com/Sylius/Sylius/issues/12702) [Documentation] Fix Refund Process Cookbook ([@GSadee](https://github.com/GSadee))
- [#12706](https://github.com/Sylius/Sylius/issues/12706) [Documentation] Tweaks on the refunds process cookbook ([@CoderMaggie](https://github.com/CoderMaggie), [@GSadee](https://github.com/GSadee))
- [#12707](https://github.com/Sylius/Sylius/issues/12707) [Documentation] Fix links in the refunds process cookbook ([@GSadee](https://github.com/GSadee))
- [#12715](https://github.com/Sylius/Sylius/issues/12715) [Dql] Add parameter instead of hardcoding it in where statement ([@SirDomin](https://github.com/SirDomin))
- [#12720](https://github.com/Sylius/Sylius/issues/12720) [DQL] Change hardcoded enabled value to parameter in where statements ([@GSadee](https://github.com/GSadee))
- [#12726](https://github.com/Sylius/Sylius/issues/12726) [DQL] Change hardcoded tracked value to parameter in where statements ([@lchrusciel](https://github.com/lchrusciel))
- [#12731](https://github.com/Sylius/Sylius/issues/12731) Add cookbook with how to change tax address ([@arti0090](https://github.com/arti0090))
- [#12748](https://github.com/Sylius/Sylius/issues/12748) [Documentation][Refund] Add cookbook about refund customization with improvements ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))

## v1.9.4 (2021-05-27)

#### Details

- [#12557](https://github.com/Sylius/Sylius/issues/12557) update Plus installation guide ([@AdamKasp](https://github.com/AdamKasp))
- [#12558](https://github.com/Sylius/Sylius/issues/12558) [Order] Fix race condition problem with multiple order recalculations ([@GSadee](https://github.com/GSadee))
- [#12564](https://github.com/Sylius/Sylius/issues/12564) [Docs] add minor improvement to Plus installation guide ([@AdamKasp](https://github.com/AdamKasp))
- [#12565](https://github.com/Sylius/Sylius/issues/12565) [API][Order] Fix possibility to limit orders by refactoring from data provider to extension ([@GSadee](https://github.com/GSadee))
- [#12569](https://github.com/Sylius/Sylius/issues/12569) Bugfix | Filter out not enabled products in API collection ([@stloyd](https://github.com/stloyd), [@arti0090](https://github.com/arti0090))
- [#12604](https://github.com/Sylius/Sylius/issues/12604) [API] Cherry pick commits on 1.9 branch for validating if product is enabled during adding to cart ([@arti0090](https://github.com/arti0090), [@GSadee](https://github.com/GSadee))
- [#12609](https://github.com/Sylius/Sylius/issues/12609) Adding product from another channel bugfix ([@arti0090](https://github.com/arti0090))
- [#12612](https://github.com/Sylius/Sylius/issues/12612) [Documentation] Update cookbook about Facebook login ([@GSadee](https://github.com/GSadee))
- [#12613](https://github.com/Sylius/Sylius/issues/12613) [API] Adding inexistent variant ([@arti0090](https://github.com/arti0090), [@GSadee](https://github.com/GSadee))
- [#12619](https://github.com/Sylius/Sylius/issues/12619) [Docs] Add docs for custom entity with access per admin channel ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#12628](https://github.com/Sylius/Sylius/issues/12628) [API] Conflict with symfony/property-info due to problem with wrong namespaces of some translation entities ([@GSadee](https://github.com/GSadee))
- [#12632](https://github.com/Sylius/Sylius/issues/12632) [Docs] Mention localhost exposure for easier Facebook login ([@Zales0123](https://github.com/Zales0123))
- [#12633](https://github.com/Sylius/Sylius/issues/12633) [Bug] [Temporary solution] Comment out 2 behats steps for checking notifications ([@SirDomin](https://github.com/SirDomin))
- [#12643](https://github.com/Sylius/Sylius/issues/12643) [README] Fix link to plugin list ([@lchrusciel](https://github.com/lchrusciel))
- [#12650](https://github.com/Sylius/Sylius/issues/12650) [API][ProductVariant] Fix product variant response by using proper normalizer ([@GSadee](https://github.com/GSadee))
- [#12651](https://github.com/Sylius/Sylius/issues/12651) [API][ProductVariant] Add additional specs for product variant normalizer ([@GSadee](https://github.com/GSadee))
- [#12655](https://github.com/Sylius/Sylius/issues/12655) [Documentation][Plus] Minor improvements in cookbook for accessing to entities by channel admins ([@GSadee](https://github.com/GSadee))
- [#12667](https://github.com/Sylius/Sylius/issues/12667) [Documentation] Customizing CreditMemo entity by adding a new field ([@GSadee](https://github.com/GSadee))
- [#12668](https://github.com/Sylius/Sylius/issues/12668) [API] write order email send test in api bundle ([@pamil](https://github.com/pamil), [@SirDomin](https://github.com/SirDomin))
- [#12671](https://github.com/Sylius/Sylius/issues/12671) [Api] Tests adding incorrect county code to address order ([@Tomanhez](https://github.com/Tomanhez))
- [#12674](https://github.com/Sylius/Sylius/issues/12674) [Minor] Return shop user after registration command to improve extendibility ([@lchrusciel](https://github.com/lchrusciel))

## v1.9.3 (2021-04-22)

#### Details

- [#12458](https://github.com/Sylius/Sylius/issues/12458) [Locale] Current locale set on request ([@lchrusciel](https://github.com/lchrusciel), [@SirDomin](https://github.com/SirDomin))
- [#12469](https://github.com/Sylius/Sylius/issues/12469) Extract sylius/admin-api-bundle out of Sylius Core (but keep it installed by default in existing minor releases) ([@pamil](https://github.com/pamil))
- [#12475](https://github.com/Sylius/Sylius/issues/12475) [Taxation] Fix applying shipment taxes for multiple shipments ([@GSadee](https://github.com/GSadee))
- [#12489](https://github.com/Sylius/Sylius/issues/12489) Build fix Change int to string in GenerateCouponsCommand ([@Tomanhez](https://github.com/Tomanhez))
- [#12493](https://github.com/Sylius/Sylius/issues/12493) Update model.rst ([@mariogalan](https://github.com/mariogalan))
- [#12494](https://github.com/Sylius/Sylius/issues/12494) [Behat][Customer] Fix assertions ([@GSadee](https://github.com/GSadee))
- [#12500](https://github.com/Sylius/Sylius/issues/12500) [Documentation] Customizing credit memo ([@pamil](https://github.com/pamil))
- [#12501](https://github.com/Sylius/Sylius/issues/12501) [BUG] Product options null value returns 400 instead of 500 ([@lchrusciel](https://github.com/lchrusciel), [@SirDomin](https://github.com/SirDomin))
- [#12504](https://github.com/Sylius/Sylius/issues/12504) Change app.php to index.php ([@stefandoorn](https://github.com/stefandoorn))
- [#12508](https://github.com/Sylius/Sylius/issues/12508) Fix the build by solving errors reported by static analysis tools ([@pamil](https://github.com/pamil))
- [#12516](https://github.com/Sylius/Sylius/issues/12516) Fix CustomerComponent Typo ([@DennisdeBest](https://github.com/DennisdeBest))
- [#12522](https://github.com/Sylius/Sylius/issues/12522) Revert BC break in ProductVariantInterface ([@pamil](https://github.com/pamil))
- [#12523](https://github.com/Sylius/Sylius/issues/12523) Remove Admin API Bundle-related tests ([@pamil](https://github.com/pamil))
- [#12525](https://github.com/Sylius/Sylius/issues/12525) Move note from UPGRADE-1.8 to UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12535](https://github.com/Sylius/Sylius/issues/12535) [API] Add prefix to subresource endpoint of order item's adjustments ([@GSadee](https://github.com/GSadee))
- [#12546](https://github.com/Sylius/Sylius/issues/12546) [Minor] Use explicit bus instead of the default one ([@lchrusciel](https://github.com/lchrusciel))

## v1.9.2 (2021-03-23)

#### Details

- [#12439](https://github.com/Sylius/Sylius/issues/12439) Don't render _token field if it's already rendered ([@maximehuran](https://github.com/maximehuran))
- [#12454](https://github.com/Sylius/Sylius/issues/12454) Don't render _token field if it's already rendered in update template ([@pamil](https://github.com/pamil))
- [#12461](https://github.com/Sylius/Sylius/issues/12461) Fix packages builds: ResourceBundle v1.8 does not require StofDoctrineExtensionsBundle anymore ([@pamil](https://github.com/pamil))
- [#12468](https://github.com/Sylius/Sylius/issues/12468) Fix the build by conflicting with doctrine/doctrine-bundle 2.3.0 ([@pamil](https://github.com/pamil))
- [#12471](https://github.com/Sylius/Sylius/issues/12471) [Maintenance] Conflict with JMSSerializer 3.9.0 due to issues with mapping of persistent collection ([@lchrusciel](https://github.com/lchrusciel))

## v1.9.1 (2021-03-18)

#### Details

- [#12324](https://github.com/Sylius/Sylius/issues/12324) Removing hard timeout on edit while load selected values ([@christopherhero](https://github.com/christopherhero))
- [#12376](https://github.com/Sylius/Sylius/issues/12376) Pass path delimiter up to parent taxon ([@Jeroen-G](https://github.com/Jeroen-G), [@Jeroen](https://github.com/Jeroen), [@pamil](https://github.com/pamil))
- [#12384](https://github.com/Sylius/Sylius/issues/12384) Doc: Fix Doctrine project url ([@n3wborn](https://github.com/n3wborn))
- [#12393](https://github.com/Sylius/Sylius/issues/12393) [ApiBundle] Fixes in test application ([@GSadee](https://github.com/GSadee))
- [#12397](https://github.com/Sylius/Sylius/issues/12397) Do not fail when mb_detect_encoding returns false ([@stefandoorn](https://github.com/stefandoorn))
- [#12398](https://github.com/Sylius/Sylius/issues/12398) [API] add missing spec ([@AdamKasp](https://github.com/AdamKasp))
- [#12401](https://github.com/Sylius/Sylius/issues/12401) Use bold to alert on some changes in the README ([@jacquesbh](https://github.com/jacquesbh))
- [#12403](https://github.com/Sylius/Sylius/issues/12403) Minor fixes and CS ([@AdamKasp](https://github.com/AdamKasp))
- [#12404](https://github.com/Sylius/Sylius/issues/12404) Fix nested accordion initialisation ([@DjLeChuck](https://github.com/DjLeChuck))
- [#12407](https://github.com/Sylius/Sylius/issues/12407) [AttributeBundle] custom locale_code fixed ([@Mateuszry](https://github.com/Mateuszry))
- [#12410](https://github.com/Sylius/Sylius/issues/12410) [ApiBundle] Improve tests for custom Sylius resource in test application ([@GSadee](https://github.com/GSadee))
- [#12411](https://github.com/Sylius/Sylius/issues/12411) [API] improve tests for overwriting api configs ([@AdamKasp](https://github.com/AdamKasp))
- [#12412](https://github.com/Sylius/Sylius/issues/12412) [API][DOCS] custom path ([@AdamKasp](https://github.com/AdamKasp))
- [#12416](https://github.com/Sylius/Sylius/issues/12416) [ApiBundle] Improve tests for custom entity in test application ([@GSadee](https://github.com/GSadee))
- [#12417](https://github.com/Sylius/Sylius/issues/12417) [API][Documentation] Fix link to jwt documentation ([@GSadee](https://github.com/GSadee))
- [#12418](https://github.com/Sylius/Sylius/issues/12418) [API][Documentation] Fix path to security file ([@GSadee](https://github.com/GSadee))
- [#12423](https://github.com/Sylius/Sylius/issues/12423) Temporarily conflict to symfony/doctrine-bridge in Core and Api bundles ([@GSadee](https://github.com/GSadee))
- [#12427](https://github.com/Sylius/Sylius/issues/12427) [FOSOAuthServerBundle] Remove incompatible version ([@Prometee](https://github.com/Prometee))
- [#12447](https://github.com/Sylius/Sylius/issues/12447) Fix build for CoreBundle and ApiBundle packages ([@pamil](https://github.com/pamil))
- [#12448](https://github.com/Sylius/Sylius/issues/12448) [ApiBundle] Fix displaying testing section in README file ([@GSadee](https://github.com/GSadee))

## v1.9.0 (2021-03-01)

#### TL;DR

- Added support for Symfony 5
- Enhanced adjustment calculations to take shipping and promotions taxes into account while generating invoices and credit memos
- Added support for non-translatable product attributes
- Improved API v2 coverage up to 50% (customer account, orders, emails, products & product variants management) 

#### Details

- [#12126](https://github.com/Sylius/Sylius/issues/12126) Fix incorrect money format being used ([@kayue](https://github.com/kayue))
- [#12329](https://github.com/Sylius/Sylius/issues/12329) [Api] Add test app for ApiBundle ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee), [@lchrusciel](https://github.com/lchrusciel))
- [#12383](https://github.com/Sylius/Sylius/issues/12383) [API] ProductVariant serialization with new key "price" ([@SirDomin](https://github.com/SirDomin))

#### Full 1.9 changelog

- [#11370](https://github.com/Sylius/Sylius/issues/11370) Introduce limit parameter for quantity modifier ([@arti0090](https://github.com/arti0090))
- [#11478](https://github.com/Sylius/Sylius/issues/11478) [ADR] Custom operation in new Sylius API ([@lchrusciel](https://github.com/lchrusciel))
- [#11597](https://github.com/Sylius/Sylius/issues/11597) Update fixtures.rst ([@gabiudrescu](https://github.com/gabiudrescu))
- [#11752](https://github.com/Sylius/Sylius/issues/11752) [Minor] Sort checkout contexts ([@lchrusciel](https://github.com/lchrusciel))
- [#11754](https://github.com/Sylius/Sylius/issues/11754) [API] Order confirmation email sending ([@lchrusciel](https://github.com/lchrusciel), [@SirDomin](https://github.com/SirDomin))
- [#11758](https://github.com/Sylius/Sylius/issues/11758) Allow newer "doctrine/doctrine-bundle" to match upcoming ResourceBundle reqs ([@stloyd](https://github.com/stloyd))
- [#11762](https://github.com/Sylius/Sylius/issues/11762) add toogle button that verifies user account ([@arti0090](https://github.com/arti0090))
- [#11765](https://github.com/Sylius/Sylius/issues/11765) Making the error message on fixutre load helpful ([@mamazu](https://github.com/mamazu))
- [#11771](https://github.com/Sylius/Sylius/issues/11771) Reflect admin path change in UPGRADE-1.8 ([@jacquesbh](https://github.com/jacquesbh))
- [#11805](https://github.com/Sylius/Sylius/issues/11805) Redirect /.well-known/change-password to the right page ([@jacquesbh](https://github.com/jacquesbh))
- [#11811](https://github.com/Sylius/Sylius/issues/11811) [Maintenance] Remove dead part of travis installation script ([@lchrusciel](https://github.com/lchrusciel))
- [#11817](https://github.com/Sylius/Sylius/issues/11817) [Api][Checkout] Allowing access only for correctly logged in - minor fixes ([@Tomanhez](https://github.com/Tomanhez))
- [#11828](https://github.com/Sylius/Sylius/issues/11828) [API] add missing prefix to payments route ([@AdamKasp](https://github.com/AdamKasp))
- [#11834](https://github.com/Sylius/Sylius/issues/11834) Update symfony.lock with a few missing entries ([@jacquesbh](https://github.com/jacquesbh))
- [#11858](https://github.com/Sylius/Sylius/issues/11858) [API] Added behat tag for seeing shipping and payment methods on summary ([@arti0090](https://github.com/arti0090))
- [#11859](https://github.com/Sylius/Sylius/issues/11859) [API]Seeing shipping and billing addresses on order summary page ([@arti0090](https://github.com/arti0090))
- [#11860](https://github.com/Sylius/Sylius/issues/11860) [Api][Checkout][Shipping] Shipping method integrity validation ([@Tomanhez](https://github.com/Tomanhez))
- [#11863](https://github.com/Sylius/Sylius/issues/11863) [API]Payment Method integrity check ([@arti0090](https://github.com/arti0090))
- [#11874](https://github.com/Sylius/Sylius/issues/11874) [Api] restrict access to customer account editing ([@AdamKasp](https://github.com/AdamKasp))
- [#11875](https://github.com/Sylius/Sylius/issues/11875) [API] Not being able to modify cart after completed checkout ([@arti0090](https://github.com/arti0090))
- [#11877](https://github.com/Sylius/Sylius/issues/11877) [API] add payment method code to methods endpoint ([@arti0090](https://github.com/arti0090))
- [#11888](https://github.com/Sylius/Sylius/issues/11888) [Api][Shop][Order][Address] Viewing order ([@Tomanhez](https://github.com/Tomanhez))
- [#11889](https://github.com/Sylius/Sylius/issues/11889) [API] Implement choosing province during checkout ([@GSadee](https://github.com/GSadee))
- [#11891](https://github.com/Sylius/Sylius/issues/11891) [Api] orders index for customer's account ([@AdamKasp](https://github.com/AdamKasp))
- [#11896](https://github.com/Sylius/Sylius/issues/11896) [Api][Order]Viewing order details ([@Tomanhez](https://github.com/Tomanhez))
- [#11906](https://github.com/Sylius/Sylius/issues/11906) [Api] Add validation for add to cart command ([@AdamKasp](https://github.com/AdamKasp))
- [#11909](https://github.com/Sylius/Sylius/issues/11909) [Address] Improve province validation ([@GSadee](https://github.com/GSadee))
- [#11912](https://github.com/Sylius/Sylius/issues/11912) [Admin][API][Shipment] Add filtering shipments by a shipping method ([@GSadee](https://github.com/GSadee))
- [#11914](https://github.com/Sylius/Sylius/issues/11914) [Api][Address] Browsing AddressBook ([@Tomanhez](https://github.com/Tomanhez))
- [#11915](https://github.com/Sylius/Sylius/issues/11915) [API]delete address book ([@arti0090](https://github.com/arti0090))
- [#11916](https://github.com/Sylius/Sylius/issues/11916) End of maintenance date fixed ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11917](https://github.com/Sylius/Sylius/issues/11917) 1.5 version EoL update ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11923](https://github.com/Sylius/Sylius/issues/11923) Keep it consistent with simple quotes ([@jacquesbh](https://github.com/jacquesbh))
- [#11924](https://github.com/Sylius/Sylius/issues/11924) [Api] Change payment method after checkout ([@AdamKasp](https://github.com/AdamKasp))
- [#11925](https://github.com/Sylius/Sylius/issues/11925) [PoC][API] Resolve proper IRI in admin/shop contexts ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#11928](https://github.com/Sylius/Sylius/issues/11928) Adding select type to doc ([@moein](https://github.com/moein))
- [#11930](https://github.com/Sylius/Sylius/issues/11930) Branch update ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11933](https://github.com/Sylius/Sylius/issues/11933) Brunch update vol.2 ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11934](https://github.com/Sylius/Sylius/issues/11934) Update ChangeItemQuantityInCart ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11935](https://github.com/Sylius/Sylius/issues/11935) Updated Sylius description in documentation's README ([@ValentineJester](https://github.com/ValentineJester))
- [#11937](https://github.com/Sylius/Sylius/issues/11937) [Cart] Change logic for maintaining cart after logging in ([@GSadee](https://github.com/GSadee))
- [#11938](https://github.com/Sylius/Sylius/issues/11938) [API][AddressBook] Adding new address ([@SirDomin](https://github.com/SirDomin), [@GSadee](https://github.com/GSadee))
- [#11939](https://github.com/Sylius/Sylius/issues/11939) [API]Seeing shipping cost of order ([@arti0090](https://github.com/arti0090))
- [#11947](https://github.com/Sylius/Sylius/issues/11947) [API] Add removed feature ([@lchrusciel](https://github.com/lchrusciel))
- [#11950](https://github.com/Sylius/Sylius/issues/11950) [Core][Channel] Add contact phone number to channel ([@twojtylak](https://github.com/twojtylak))
- [#11951](https://github.com/Sylius/Sylius/issues/11951) [Api] Be able to change authorization header  ([@Tomanhez](https://github.com/Tomanhez))
- [#11952](https://github.com/Sylius/Sylius/issues/11952) [Fixture] Add getOneBy method to LazyOption ([@lchrusciel](https://github.com/lchrusciel))
- [#11953](https://github.com/Sylius/Sylius/issues/11953) [Docs] Announce 1.9 release period ([@lchrusciel](https://github.com/lchrusciel))
- [#11954](https://github.com/Sylius/Sylius/issues/11954) Delete redundant steps ([@AdamKasp](https://github.com/AdamKasp))
- [#11961](https://github.com/Sylius/Sylius/issues/11961) [API][AddressBook] Setting default address ([@AdamKasp](https://github.com/AdamKasp))
- [#11963](https://github.com/Sylius/Sylius/issues/11963) [API][AddressBook] Minor fixes to api behats ([@AdamKasp](https://github.com/AdamKasp))
- [#11964](https://github.com/Sylius/Sylius/issues/11964) [API][AddressBook] Protect addresses with new firewall ([@AdamKasp](https://github.com/AdamKasp))
- [#11971](https://github.com/Sylius/Sylius/issues/11971) [API] Seeing promotions total in cart ([@arti0090](https://github.com/arti0090))
- [#11973](https://github.com/Sylius/Sylius/issues/11973) [API] [My Account] Edit addressbook ([@SirDomin](https://github.com/SirDomin))
- [#11983](https://github.com/Sylius/Sylius/issues/11983) [Minor] Update service definition to not using depracated service ([@lchrusciel](https://github.com/lchrusciel))
- [#11984](https://github.com/Sylius/Sylius/issues/11984) [API]maintaining cart after login and registration ([@arti0090](https://github.com/arti0090))
- [#11989](https://github.com/Sylius/Sylius/issues/11989) [API]added missing serialization to address editing endpoint ([@arti0090](https://github.com/arti0090))
- [#11995](https://github.com/Sylius/Sylius/issues/11995) [Behat] Fix argument name after upgrade Behat to v3.8.0 ([@GSadee](https://github.com/GSadee))
- [#11997](https://github.com/Sylius/Sylius/issues/11997) Revert "[API]added missing serialization to address editing endpoint" ([@lchrusciel](https://github.com/lchrusciel))
- [#11998](https://github.com/Sylius/Sylius/issues/11998) [API][Shop] Logging in after changing password implementation ([@lchrusciel](https://github.com/lchrusciel), [@arti0090](https://github.com/arti0090))
- [#12001](https://github.com/Sylius/Sylius/issues/12001) [Maintenance] Fix naming issues after psalm bump ([@lchrusciel](https://github.com/lchrusciel))
- [#12002](https://github.com/Sylius/Sylius/issues/12002) [API]added missing serialization to address editing endpoint ([@arti0090](https://github.com/arti0090))
- [#12003](https://github.com/Sylius/Sylius/issues/12003) [API][Behat]refactor api admin context ([@arti0090](https://github.com/arti0090))
- [#12006](https://github.com/Sylius/Sylius/issues/12006) [API][Checkout] Implement scenarios for preventing checkout with an empty cart ([@GSadee](https://github.com/GSadee))
- [#12007](https://github.com/Sylius/Sylius/issues/12007) [API] Fix names in change password command ([@AdamKasp](https://github.com/AdamKasp))
- [#12008](https://github.com/Sylius/Sylius/issues/12008) Note about disabled product variants and taxons ([@jacquesbh](https://github.com/jacquesbh))
- [#12013](https://github.com/Sylius/Sylius/issues/12013) [API]adding promotions with expire date ([@arti0090](https://github.com/arti0090))
- [#12016](https://github.com/Sylius/Sylius/issues/12016) [Api] Changing orders payment methods on shop account ([@Tomanhez](https://github.com/Tomanhez))
- [#12021](https://github.com/Sylius/Sylius/issues/12021) Remove unnecessary conflicts ([@pamil](https://github.com/pamil))
- [#12025](https://github.com/Sylius/Sylius/issues/12025) [API]adding promotions with expire date  ([@arti0090](https://github.com/arti0090))
- [#12026](https://github.com/Sylius/Sylius/issues/12026) [Order] Change localisation of findCartByTokenValue function ([@AdamKasp](https://github.com/AdamKasp))
- [#12027](https://github.com/Sylius/Sylius/issues/12027) [FIXTURES] Use shopbillDataFactory in ChannelExampleFactory ([@lukasz](https://github.com/lukasz).[@wroblewski88](https://github.com/wroblewski88)@[@gmail](https://github.com/gmail).[@com](https://github.com/com))
- [#12032](https://github.com/Sylius/Sylius/issues/12032) [API] Move register operation below customers endpoint ([@lchrusciel](https://github.com/lchrusciel))
- [#12034](https://github.com/Sylius/Sylius/issues/12034) [API][Product] Change identifier for shop endpoint from slug to code ([@GSadee](https://github.com/GSadee))
- [#12035](https://github.com/Sylius/Sylius/issues/12035) info about JWT token generation required ([@rafbit](https://github.com/rafbit))
- [#12036](https://github.com/Sylius/Sylius/issues/12036) [API] Fix PHPSpec of order query extension after upmerge ([@GSadee](https://github.com/GSadee))
- [#12037](https://github.com/Sylius/Sylius/issues/12037) [API]fixes to `adding promotions with expire date` ([@arti0090](https://github.com/arti0090))
- [#12038](https://github.com/Sylius/Sylius/issues/12038) [Minor][ADR] Explicit bus declaration on handlers ([@lchrusciel](https://github.com/lchrusciel))
- [#12039](https://github.com/Sylius/Sylius/issues/12039) [Minor] Inject proper order processor ([@lchrusciel](https://github.com/lchrusciel))
- [#12041](https://github.com/Sylius/Sylius/issues/12041) [API] Fixes after PR with resolving proper iri in different contexts ([@GSadee](https://github.com/GSadee))
- [#12044](https://github.com/Sylius/Sylius/issues/12044) [API][Product] Add note in UPGRADE file about changing identifier for shop endpoint ([@GSadee](https://github.com/GSadee))
- [#12045](https://github.com/Sylius/Sylius/issues/12045) [API] Add missing endpoints for address and country resources ([@GSadee](https://github.com/GSadee))
- [#12050](https://github.com/Sylius/Sylius/issues/12050) Refactor mailing ([@lchrusciel](https://github.com/lchrusciel), [@SirDomin](https://github.com/SirDomin))
- [#12054](https://github.com/Sylius/Sylius/issues/12054) [ADR] Sending emails via api ([@SirDomin](https://github.com/SirDomin))
- [#12057](https://github.com/Sylius/Sylius/issues/12057) Switch to Psalm 4 ([@pamil](https://github.com/pamil))
- [#12058](https://github.com/Sylius/Sylius/issues/12058) Update PHPStan and its configuration ([@pamil](https://github.com/pamil))
- [#12059](https://github.com/Sylius/Sylius/issues/12059) Upgrade to PHPSpec 7 ([@pamil](https://github.com/pamil))
- [#12073](https://github.com/Sylius/Sylius/issues/12073) Replace fzaninotto/faker with fakerphp/faker ([@DieterHolvoet](https://github.com/DieterHolvoet))
- [#12074](https://github.com/Sylius/Sylius/issues/12074) [API] add api tag to applying promotions with expiration date ([@arti0090](https://github.com/arti0090))
- [#12075](https://github.com/Sylius/Sylius/issues/12075) [Behat]refactor of setup/PromotionContext class ([@arti0090](https://github.com/arti0090))
- [#12076](https://github.com/Sylius/Sylius/issues/12076) [API][Behat] fixed steps for quantity-change api test ([@arti0090](https://github.com/arti0090))
- [#12078](https://github.com/Sylius/Sylius/issues/12078) [Behat] refactor of cart and checkout contexts ([@arti0090](https://github.com/arti0090))
- [#12081](https://github.com/Sylius/Sylius/issues/12081) [Api] Receiving discount promotion ([@Tomanhez](https://github.com/Tomanhez))
- [#12082](https://github.com/Sylius/Sylius/issues/12082) [Promotions] Replace wrong names ([@Tomanhez](https://github.com/Tomanhez))
- [#12083](https://github.com/Sylius/Sylius/issues/12083) [Api] Receiving percentage discount ([@Tomanhez](https://github.com/Tomanhez))
- [#12084](https://github.com/Sylius/Sylius/issues/12084) Upgrade all dependencies to versions supporting Symfony 5 ([@pamil](https://github.com/pamil), [@Zales0123](https://github.com/Zales0123))
- [#12098](https://github.com/Sylius/Sylius/issues/12098) [Attributes][PoC] Attributes view reorganization ([@Tomanhez](https://github.com/Tomanhez), [@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp), [@SirDomin](https://github.com/SirDomin))
- [#12107](https://github.com/Sylius/Sylius/issues/12107) Api platform payment ([@SirDomin](https://github.com/SirDomin))
- [#12109](https://github.com/Sylius/Sylius/issues/12109) [API] placing order on multiple channels with api ([@arti0090](https://github.com/arti0090))
- [#12116](https://github.com/Sylius/Sylius/issues/12116) [Adjustment] Add more details to adjustment and make shipment adjustable ([@GSadee](https://github.com/GSadee), [@SirDomin](https://github.com/SirDomin), [@lchrusciel](https://github.com/lchrusciel))
- [#12128](https://github.com/Sylius/Sylius/issues/12128) [AdminApiBundle][CoreBundle] Update unit test versions ([@Tomanhez](https://github.com/Tomanhez))
- [#12139](https://github.com/Sylius/Sylius/issues/12139) [Api] Locale code on checkout ([@Tomanhez](https://github.com/Tomanhez))
- [#12148](https://github.com/Sylius/Sylius/issues/12148) Support for Symfony 5 ([@pamil](https://github.com/pamil))
- [#12153](https://github.com/Sylius/Sylius/issues/12153) [API] prevent checkout skipping shipping step ([@arti0090](https://github.com/arti0090))
- [#12154](https://github.com/Sylius/Sylius/issues/12154) [API] show possible shipping methods for order ([@arti0090](https://github.com/arti0090))
- [#12157](https://github.com/Sylius/Sylius/issues/12157) Bump ini from 1.3.5 to 1.3.7 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#12161](https://github.com/Sylius/Sylius/issues/12161) Add tag no-api to scenario ([@arti0090](https://github.com/arti0090))
- [#12162](https://github.com/Sylius/Sylius/issues/12162) [Api][Checkout] Shipping fees on multi-channel ([@Tomanhez](https://github.com/Tomanhez))
- [#12164](https://github.com/Sylius/Sylius/issues/12164) update upgrade file after changes with tax adjustment ([@arti0090](https://github.com/arti0090))
- [#12165](https://github.com/Sylius/Sylius/issues/12165) [Api] Check currency on channel ([@Tomanhez](https://github.com/Tomanhez))
- [#12178](https://github.com/Sylius/Sylius/issues/12178) [API] Browsing promotions ([@arti0090](https://github.com/arti0090))
- [#12179](https://github.com/Sylius/Sylius/issues/12179) [API] deleting promotions ([@arti0090](https://github.com/arti0090))
- [#12184](https://github.com/Sylius/Sylius/issues/12184) [BC BREAK] [Api][AdminUser][AvatarImage][Channel][Currency][Customer] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12188](https://github.com/Sylius/Sylius/issues/12188) [BC BREAK] [Api][Order] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12205](https://github.com/Sylius/Sylius/issues/12205) [BC BREAK] [Api][Product] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12206](https://github.com/Sylius/Sylius/issues/12206) [BC BREAK] [Api][OrderItem][OrderItemUnit] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12206](https://github.com/Sylius/Sylius/issues/12206) [BC BREAK] [Api][OrderItem][OrderItemUnit] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12212](https://github.com/Sylius/Sylius/issues/12212) [BC BREAK] [Api][Promotion][Province] Refactor api serialization groups ([@lchrusciel](https://github.com/lchrusciel))
- [#12213](https://github.com/Sylius/Sylius/issues/12213) Upgrade psalm ([@Tomanhez](https://github.com/Tomanhez))
- [#12214](https://github.com/Sylius/Sylius/issues/12214) Add conflict liminas/liminas-code 4.0.0 ([@Tomanhez](https://github.com/Tomanhez))
- [#12215](https://github.com/Sylius/Sylius/issues/12215) Update CONFLICTS.MD ([@Tomanhez](https://github.com/Tomanhez))
- [#12218](https://github.com/Sylius/Sylius/issues/12218) Remove laminas/laminas-code conflict ([@Tomanhez](https://github.com/Tomanhez))
- [#12220](https://github.com/Sylius/Sylius/issues/12220) Fix event deprecations ([@loic425](https://github.com/loic425))
- [#12228](https://github.com/Sylius/Sylius/issues/12228) [BC BREAK] [Api][Adjustment][CustomerGrouop][ExchangeRate][Locale][Payment][PaymentMethod] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12230](https://github.com/Sylius/Sylius/issues/12230) [BC BREAK] [Api][ShippingMethod][ShopBillingData][TaxCategory][Taxon][TaxonTranslation][Zone][ZoneMemberRefactor] serializations groups  ([@Tomanhez](https://github.com/Tomanhez))
- [#12231](https://github.com/Sylius/Sylius/issues/12231) Add conflict with polyfill-mbstring 1.22.0 ([@Tomanhez](https://github.com/Tomanhez))
- [#12233](https://github.com/Sylius/Sylius/issues/12233) [Bug] Add Twig verification to check is taxon is enabled ([@clem21](https://github.com/clem21))
- [#12239](https://github.com/Sylius/Sylius/issues/12239) Update phpstan/phpstan requirement from 0.12.64 to 0.12.66 ([@dependabot-preview](https://github.com/dependabot-preview)[[@bot](https://github.com/bot)])
- [#12246](https://github.com/Sylius/Sylius/issues/12246) [OrderProcessor] Fix clearing tax adjustments ([@GSadee](https://github.com/GSadee))
- [#12248](https://github.com/Sylius/Sylius/issues/12248) Make upgrade of serializations easier to read ([@Jeroen-G](https://github.com/Jeroen-G))
- [#12256](https://github.com/Sylius/Sylius/issues/12256) Ability to create non-translatable attributes fixtures + info about non-translatable attributes. ([@SirDomin](https://github.com/SirDomin))
- [#12257](https://github.com/Sylius/Sylius/issues/12257) [API] change new-api prefix to api ([@SirDomin](https://github.com/SirDomin))
- [#12258](https://github.com/Sylius/Sylius/issues/12258) [Docs] Add steps to upgrade jms configuration in UPGRADE-1.9 file ([@Tomanhez](https://github.com/Tomanhez))
- [#12260](https://github.com/Sylius/Sylius/issues/12260) [Minor][Documentation] Improve attribute documentation ([@lchrusciel](https://github.com/lchrusciel))
- [#12262](https://github.com/Sylius/Sylius/issues/12262) [Migrations] Use adding SQL instead of query execution ([@GSadee](https://github.com/GSadee))
- [#12270](https://github.com/Sylius/Sylius/issues/12270) [Cart] change remove order item from PATCH method to DELETE method ([@AdamKasp](https://github.com/AdamKasp))
- [#12278](https://github.com/Sylius/Sylius/issues/12278) [API] move security parameters to bundles ([@SirDomin](https://github.com/SirDomin), [@lchrusciel](https://github.com/lchrusciel))
- [#12279](https://github.com/Sylius/Sylius/issues/12279) [API] show product price ([@SirDomin](https://github.com/SirDomin))
- [#12282](https://github.com/Sylius/Sylius/issues/12282) [Shipment] Applying discounts and taxes for each shipment ([@GSadee](https://github.com/GSadee))
- [#12283](https://github.com/Sylius/Sylius/issues/12283) Getting back to customer details in admin panel. ([@mamazu](https://github.com/mamazu))
- [#12284](https://github.com/Sylius/Sylius/issues/12284) [Psalm] Fix build by casting to string in sprintf methods ([@GSadee](https://github.com/GSadee))
- [#12287](https://github.com/Sylius/Sylius/issues/12287) [API] Search products by name within specific taxon ([@pamil](https://github.com/pamil))
- [#12288](https://github.com/Sylius/Sylius/issues/12288) Add proper date in licenses ([@Tomanhez](https://github.com/Tomanhez))
- [#12290](https://github.com/Sylius/Sylius/issues/12290) [Docs] Upgrade sphinx installation guide ([@Tomanhez](https://github.com/Tomanhez), [@pamil](https://github.com/pamil))
- [#12291](https://github.com/Sylius/Sylius/issues/12291) Fix Taxon collection API name ([@kayue](https://github.com/kayue))
- [#12296](https://github.com/Sylius/Sylius/issues/12296) Typo fix ([@Xeriaz](https://github.com/Xeriaz))
- [#12301](https://github.com/Sylius/Sylius/issues/12301) [API] Add missing api and no-api tags ([@lchrusciel](https://github.com/lchrusciel))
- [#12311](https://github.com/Sylius/Sylius/issues/12311) [ADR] Unified API prefix ([@lchrusciel](https://github.com/lchrusciel))
- [#12319](https://github.com/Sylius/Sylius/issues/12319) Fix the appearance of the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12322](https://github.com/Sylius/Sylius/issues/12322) update documentation for creating custom model ([@arti0090](https://github.com/arti0090))
- [#12323](https://github.com/Sylius/Sylius/issues/12323) Change the order of sections in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12325](https://github.com/Sylius/Sylius/issues/12325) fix problem with registered service ([@AdamKasp](https://github.com/AdamKasp), [@pamil](https://github.com/pamil))
- [#12326](https://github.com/Sylius/Sylius/issues/12326) Fixes in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12328](https://github.com/Sylius/Sylius/issues/12328) update documentation for creating custom resource controller ([@arti0090](https://github.com/arti0090))
- [#12329](https://github.com/Sylius/Sylius/issues/12329) [Api] Add test app for ApiBundle ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee), [@lchrusciel](https://github.com/lchrusciel))
- [#12331](https://github.com/Sylius/Sylius/issues/12331) Add note about removing Twig route config in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12332](https://github.com/Sylius/Sylius/issues/12332) Reorganize UPGRADE-1.9 file to extract steps for Symfony v5.2 ([@GSadee](https://github.com/GSadee))
- [#12336](https://github.com/Sylius/Sylius/issues/12336) Fix timeout on 404 Not Found errors when using templating and Symfony 4.4 ([@pamil](https://github.com/pamil))
- [#12338](https://github.com/Sylius/Sylius/issues/12338) [DOCS] Updating the controller customization ([@Roshyo](https://github.com/Roshyo))
- [#12342](https://github.com/Sylius/Sylius/issues/12342) Fixes according to composer require commands in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12351](https://github.com/Sylius/Sylius/issues/12351) [Doc] remove generator bundle info (deprecated) ([@SirDomin](https://github.com/SirDomin))
- [#12355](https://github.com/Sylius/Sylius/issues/12355) Remove unneeded zendframework/zend-hydrator dependency ([@pamil](https://github.com/pamil))
- [#12364](https://github.com/Sylius/Sylius/issues/12364) [Adjustment] Update new migrations not to execute if the changes already exist in db ([@GSadee](https://github.com/GSadee))
- [#12365](https://github.com/Sylius/Sylius/issues/12365) [Adjustment] Update down methods of new migrations not to execute if the changes already exist in db ([@GSadee](https://github.com/GSadee))
- [#12373](https://github.com/Sylius/Sylius/issues/12373) Move some steps to different section in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12378](https://github.com/Sylius/Sylius/issues/12378) [Bug-fix] Fix default form problem with _token field ([@Zales0123](https://github.com/Zales0123))
- [#12383](https://github.com/Sylius/Sylius/issues/12383) [API] ProductVariant serialization with new key "price" ([@SirDomin](https://github.com/SirDomin))

## v1.9.0-RC.2 (2021-02-23)

#### Details

- [#12378](https://github.com/Sylius/Sylius/issues/12378) [Bug-fix] Fix default form problem with _token field ([@Zales0123](https://github.com/Zales0123))

## v1.9.0-RC.1 (2021-02-22)

#### Details

- [#12311](https://github.com/Sylius/Sylius/issues/12311) [ADR] Unified API prefix ([@lchrusciel](https://github.com/lchrusciel))
- [#12351](https://github.com/Sylius/Sylius/issues/12351) [Doc] remove generator bundle info (deprecated) ([@SirDomin](https://github.com/SirDomin))
- [#12352](https://github.com/Sylius/Sylius/issues/12352) [Frontend] add box with info about api identifiers ([@SirDomin](https://github.com/SirDomin))
- [#12355](https://github.com/Sylius/Sylius/issues/12355) Remove unneeded zendframework/zend-hydrator dependency ([@pamil](https://github.com/pamil))
- [#12363](https://github.com/Sylius/Sylius/issues/12363) [Maintenance] Run test suite for MySQL 8.0 ([@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee))
- [#12364](https://github.com/Sylius/Sylius/issues/12364) [Adjustment] Update new migrations not to execute if the changes already exist in db ([@GSadee](https://github.com/GSadee))
- [#12365](https://github.com/Sylius/Sylius/issues/12365) [Adjustment] Update down methods of new migrations not to execute if the changes already exist in db ([@GSadee](https://github.com/GSadee))
- [#12367](https://github.com/Sylius/Sylius/issues/12367) change swagger API info color to blue ([@SirDomin](https://github.com/SirDomin))
- [#12373](https://github.com/Sylius/Sylius/issues/12373) Move some steps to different section in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))

## v1.9.0-BETA.3 (2021-02-15)

#### Details

- [#12313](https://github.com/Sylius/Sylius/issues/12313) Change package type from "project" to "library" ([@vvasiloi](https://github.com/vvasiloi))
- [#12322](https://github.com/Sylius/Sylius/issues/12322) update documentation for creating custom model ([@arti0090](https://github.com/arti0090))
- [#12328](https://github.com/Sylius/Sylius/issues/12328) update documentation for creating custom resource controller ([@arti0090](https://github.com/arti0090))
- [#12331](https://github.com/Sylius/Sylius/issues/12331) Add note about removing Twig route config in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12332](https://github.com/Sylius/Sylius/issues/12332) Reorganize UPGRADE-1.9 file to extract steps for Symfony v5.2 ([@GSadee](https://github.com/GSadee))
- [#12336](https://github.com/Sylius/Sylius/issues/12336) Fix timeout on 404 Not Found errors when using templating and Symfony 4.4 ([@pamil](https://github.com/pamil))
- [#12338](https://github.com/Sylius/Sylius/issues/12338) [DOCS] Updating the controller customization ([@Roshyo](https://github.com/Roshyo))
- [#12342](https://github.com/Sylius/Sylius/issues/12342) Fixes according to composer require commands in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))

## v1.9.0-BETA.2 (2021-02-10)

#### Details

- [#12230](https://github.com/Sylius/Sylius/issues/12230) [BC BREAK] [Api] [ShippingMethod] [ShopBillingData] [TaxCategory] [Taxon][TaxonTranslation] [Zone] [ZoneMemberRefactor] serializations groups  ([@Tomanhez](https://github.com/Tomanhez))
- [#12278](https://github.com/Sylius/Sylius/issues/12278) [API] move security parameters to bundles ([@SirDomin](https://github.com/SirDomin), [@lchrusciel](https://github.com/lchrusciel))
- [#12289](https://github.com/Sylius/Sylius/issues/12289) [Docs] Add docs for LoyaltyRule ([@Tomanhez](https://github.com/Tomanhez))
- [#12301](https://github.com/Sylius/Sylius/issues/12301) [API] Add missing api and no-api tags ([@lchrusciel](https://github.com/lchrusciel))
- [#12312](https://github.com/Sylius/Sylius/issues/12312) [CI] Ignore changes in "adr" directory ([@pamil](https://github.com/pamil))
- [#12319](https://github.com/Sylius/Sylius/issues/12319) Fix the appearance of the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12323](https://github.com/Sylius/Sylius/issues/12323) Change the order of sections in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))
- [#12325](https://github.com/Sylius/Sylius/issues/12325) fix problem with registered service ([@AdamKasp](https://github.com/AdamKasp), [@pamil](https://github.com/pamil))
- [#12326](https://github.com/Sylius/Sylius/issues/12326) Fixes in the UPGRADE-1.9 file ([@GSadee](https://github.com/GSadee))

## v1.9.0-BETA.1 (2021-02-01)

#### Details

- [#12272](https://github.com/Sylius/Sylius/issues/12272) [Docs] fix for admin RBAC channels ([@AdamKasp](https://github.com/AdamKasp))
- [#12274](https://github.com/Sylius/Sylius/issues/12274) Fix no identifier defined error in ApiPlatform 2.6 ([@kayue](https://github.com/kayue))
- [#12279](https://github.com/Sylius/Sylius/issues/12279) [API] show product price ([@SirDomin](https://github.com/SirDomin))
- [#12281](https://github.com/Sylius/Sylius/issues/12281) Add conflict with api-platform/core:^2.6 ([@pamil](https://github.com/pamil))
- [#12282](https://github.com/Sylius/Sylius/issues/12282) [Shipment] Applying discounts and taxes for each shipment ([@GSadee](https://github.com/GSadee))
- [#12283](https://github.com/Sylius/Sylius/issues/12283) Getting back to customer details in admin panel. ([@mamazu](https://github.com/mamazu))
- [#12284](https://github.com/Sylius/Sylius/issues/12284) [Psalm] Fix build by casting to string in sprintf methods ([@GSadee](https://github.com/GSadee))
- [#12287](https://github.com/Sylius/Sylius/issues/12287) [API] Search products by name within specific taxon ([@pamil](https://github.com/pamil))
- [#12288](https://github.com/Sylius/Sylius/issues/12288) Add proper date in licenses ([@Tomanhez](https://github.com/Tomanhez))
- [#12290](https://github.com/Sylius/Sylius/issues/12290) [Docs] Upgrade sphinx installation guide ([@Tomanhez](https://github.com/Tomanhez), [@pamil](https://github.com/pamil))
- [#12291](https://github.com/Sylius/Sylius/issues/12291) Fix Taxon collection API name ([@kayue](https://github.com/kayue))
- [#12295](https://github.com/Sylius/Sylius/issues/12295) [Api] Fix CommandAwareInputDataTransformer ([@Tomanhez](https://github.com/Tomanhez))
- [#12296](https://github.com/Sylius/Sylius/issues/12296) Typo fix ([@Xeriaz](https://github.com/Xeriaz))

## v1.9.0-ALPHA.2 (2021-01-21)

#### TL;DR

- Added support for Symfony 5

#### Details

- [#12098](https://github.com/Sylius/Sylius/issues/12098) [Attributes][PoC] Attributes view reorganization ([@Tomanhez](https://github.com/Tomanhez), [@kulczy](https://github.com/kulczy), [@AdamKasp](https://github.com/AdamKasp), [@SirDomin](https://github.com/SirDomin))
- [#12148](https://github.com/Sylius/Sylius/issues/12148) Support for Symfony 5 ([@pamil](https://github.com/pamil))
- [#12220](https://github.com/Sylius/Sylius/issues/12220) Fix event deprecations ([@loic425](https://github.com/loic425))
- [#12233](https://github.com/Sylius/Sylius/issues/12233) [Bug] Add Twig verification to check is taxon is enabled ([@clem21](https://github.com/clem21))
- [#12234](https://github.com/Sylius/Sylius/issues/12234) Backport symfony/polyfill-mbstring:1.22.0 conflict to make the build passing on 1.8 ([@pamil](https://github.com/pamil))
- [#12246](https://github.com/Sylius/Sylius/issues/12246) [OrderProcessor] Fix clearing tax adjustments ([@GSadee](https://github.com/GSadee))
- [#12248](https://github.com/Sylius/Sylius/issues/12248) Make upgrade of serializations easier to read ([@Jeroen-G](https://github.com/Jeroen-G))
- [#12255](https://github.com/Sylius/Sylius/issues/12255) Auto-merge passing dependabot PRs ([@Zales0123](https://github.com/Zales0123))
- [#12256](https://github.com/Sylius/Sylius/issues/12256) Ability to create non-translatable attributes fixtures + info about non-translatable attributes. ([@SirDomin](https://github.com/SirDomin))
- [#12257](https://github.com/Sylius/Sylius/issues/12257) [API] change new-api prefix to api ([@SirDomin](https://github.com/SirDomin))
- [#12258](https://github.com/Sylius/Sylius/issues/12258) [Docs] Add steps to upgrade jms configuration in UPGRADE-1.9 file ([@Tomanhez](https://github.com/Tomanhez))
- [#12260](https://github.com/Sylius/Sylius/issues/12260) [Minor][Documentation] Improve attribute documentation ([@lchrusciel](https://github.com/lchrusciel))
- [#12262](https://github.com/Sylius/Sylius/issues/12262) [Migrations] Use adding SQL instead of query execution ([@GSadee](https://github.com/GSadee))
- [#12270](https://github.com/Sylius/Sylius/issues/12270) [Cart] change remove order item from PATCH method to DELETE method ([@AdamKasp](https://github.com/AdamKasp))

## v1.9.0-ALPHA.1 (2021-01-11)

#### Details

- [#11370](https://github.com/Sylius/Sylius/issues/11370) Introduce limit parameter for quantity modifier ([@arti0090](https://github.com/arti0090))
- [#11478](https://github.com/Sylius/Sylius/issues/11478) [ADR] Custom operation in new Sylius API ([@lchrusciel](https://github.com/lchrusciel))
- [#11597](https://github.com/Sylius/Sylius/issues/11597) Update fixtures.rst ([@gabiudrescu](https://github.com/gabiudrescu))
- [#11752](https://github.com/Sylius/Sylius/issues/11752) [Minor] Sort checkout contexts ([@lchrusciel](https://github.com/lchrusciel))
- [#11754](https://github.com/Sylius/Sylius/issues/11754) [API] Order confirmation email sending ([@lchrusciel](https://github.com/lchrusciel), [@SirDomin](https://github.com/SirDomin))
- [#11758](https://github.com/Sylius/Sylius/issues/11758) Allow newer "doctrine/doctrine-bundle" to match upcoming ResourceBundle reqs ([@stloyd](https://github.com/stloyd))
- [#11762](https://github.com/Sylius/Sylius/issues/11762) add toogle button that verifies user account ([@arti0090](https://github.com/arti0090))
- [#11765](https://github.com/Sylius/Sylius/issues/11765) Making the error message on fixutre load helpful ([@mamazu](https://github.com/mamazu))
- [#11771](https://github.com/Sylius/Sylius/issues/11771) Reflect admin path change in UPGRADE-1.8 ([@jacquesbh](https://github.com/jacquesbh))
- [#11805](https://github.com/Sylius/Sylius/issues/11805) Redirect /.well-known/change-password to the right page ([@jacquesbh](https://github.com/jacquesbh))
- [#11811](https://github.com/Sylius/Sylius/issues/11811) [Maintenance] Remove dead part of travis installation script ([@lchrusciel](https://github.com/lchrusciel))
- [#11817](https://github.com/Sylius/Sylius/issues/11817) [Api][Checkout] Allowing access only for correctly logged in - minor fixes ([@Tomanhez](https://github.com/Tomanhez))
- [#11828](https://github.com/Sylius/Sylius/issues/11828) [API] add missing prefix to payments route ([@AdamKasp](https://github.com/AdamKasp))
- [#11834](https://github.com/Sylius/Sylius/issues/11834) Update symfony.lock with a few missing entries ([@jacquesbh](https://github.com/jacquesbh))
- [#11858](https://github.com/Sylius/Sylius/issues/11858) [API] Added behat tag for seeing shipping and payment methods on summary ([@arti0090](https://github.com/arti0090))
- [#11859](https://github.com/Sylius/Sylius/issues/11859) [API]Seeing shipping and billing addresses on order summary page ([@arti0090](https://github.com/arti0090))
- [#11860](https://github.com/Sylius/Sylius/issues/11860) [Api][Checkout][Shipping] Shipping method integrity validation ([@Tomanhez](https://github.com/Tomanhez))
- [#11863](https://github.com/Sylius/Sylius/issues/11863) [API]Payment Method integrity check ([@arti0090](https://github.com/arti0090))
- [#11874](https://github.com/Sylius/Sylius/issues/11874) [Api] restrict access to customer account editing ([@AdamKasp](https://github.com/AdamKasp))
- [#11875](https://github.com/Sylius/Sylius/issues/11875) [API] Not being able to modify cart after completed checkout ([@arti0090](https://github.com/arti0090))
- [#11877](https://github.com/Sylius/Sylius/issues/11877) [API] add payment method code to methods endpoint ([@arti0090](https://github.com/arti0090))
- [#11888](https://github.com/Sylius/Sylius/issues/11888) [Api][Shop][Order][Address] Viewing order ([@Tomanhez](https://github.com/Tomanhez))
- [#11889](https://github.com/Sylius/Sylius/issues/11889) [API] Implement choosing province during checkout ([@GSadee](https://github.com/GSadee))
- [#11891](https://github.com/Sylius/Sylius/issues/11891) [Api] orders index for customer's account ([@AdamKasp](https://github.com/AdamKasp))
- [#11896](https://github.com/Sylius/Sylius/issues/11896) [Api][Order]Viewing order details ([@Tomanhez](https://github.com/Tomanhez))
- [#11906](https://github.com/Sylius/Sylius/issues/11906) [Api] Add validation for add to cart command ([@AdamKasp](https://github.com/AdamKasp))
- [#11909](https://github.com/Sylius/Sylius/issues/11909) [Address] Improve province validation ([@GSadee](https://github.com/GSadee))
- [#11912](https://github.com/Sylius/Sylius/issues/11912) [Admin][API][Shipment] Add filtering shipments by a shipping method ([@GSadee](https://github.com/GSadee))
- [#11914](https://github.com/Sylius/Sylius/issues/11914) [Api][Address] Browsing AddressBook ([@Tomanhez](https://github.com/Tomanhez))
- [#11915](https://github.com/Sylius/Sylius/issues/11915) [API]delete address book ([@arti0090](https://github.com/arti0090))
- [#11916](https://github.com/Sylius/Sylius/issues/11916) End of maintenance date fixed ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11917](https://github.com/Sylius/Sylius/issues/11917) 1.5 version EoL update ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11923](https://github.com/Sylius/Sylius/issues/11923) Keep it consistent with simple quotes ([@jacquesbh](https://github.com/jacquesbh))
- [#11924](https://github.com/Sylius/Sylius/issues/11924) [Api] Change payment method after checkout ([@AdamKasp](https://github.com/AdamKasp))
- [#11925](https://github.com/Sylius/Sylius/issues/11925) [PoC][API] Resolve proper IRI in admin/shop contexts ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#11928](https://github.com/Sylius/Sylius/issues/11928) Adding select type to doc ([@moein](https://github.com/moein))
- [#11930](https://github.com/Sylius/Sylius/issues/11930) Branch update ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11933](https://github.com/Sylius/Sylius/issues/11933) Brunch update vol.2 ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11934](https://github.com/Sylius/Sylius/issues/11934) Update ChangeItemQuantityInCart ([@leniwy-splendor](https://github.com/leniwy-splendor))
- [#11935](https://github.com/Sylius/Sylius/issues/11935) Updated Sylius description in documentation's README ([@ValentineJester](https://github.com/ValentineJester))
- [#11937](https://github.com/Sylius/Sylius/issues/11937) [Cart] Change logic for maintaining cart after logging in ([@GSadee](https://github.com/GSadee))
- [#11938](https://github.com/Sylius/Sylius/issues/11938) [API][AddressBook] Adding new address ([@SirDomin](https://github.com/SirDomin), [@GSadee](https://github.com/GSadee))
- [#11939](https://github.com/Sylius/Sylius/issues/11939) [API]Seeing shipping cost of order ([@arti0090](https://github.com/arti0090))
- [#11947](https://github.com/Sylius/Sylius/issues/11947) [API] Add removed feature ([@lchrusciel](https://github.com/lchrusciel))
- [#11950](https://github.com/Sylius/Sylius/issues/11950) [Core][Channel] Add contact phone number to channel ([@twojtylak](https://github.com/twojtylak))
- [#11951](https://github.com/Sylius/Sylius/issues/11951) [Api] Be able to change authorization header  ([@Tomanhez](https://github.com/Tomanhez))
- [#11952](https://github.com/Sylius/Sylius/issues/11952) [Fixture] Add getOneBy method to LazyOption ([@lchrusciel](https://github.com/lchrusciel))
- [#11953](https://github.com/Sylius/Sylius/issues/11953) [Docs] Announce 1.9 release period ([@lchrusciel](https://github.com/lchrusciel))
- [#11954](https://github.com/Sylius/Sylius/issues/11954) Delete redundant steps ([@AdamKasp](https://github.com/AdamKasp))
- [#11961](https://github.com/Sylius/Sylius/issues/11961) [API][AddressBook] Setting default address ([@AdamKasp](https://github.com/AdamKasp))
- [#11963](https://github.com/Sylius/Sylius/issues/11963) [API][AddressBook] Minor fixes to api behats ([@AdamKasp](https://github.com/AdamKasp))
- [#11964](https://github.com/Sylius/Sylius/issues/11964) [API][AddressBook] Protect addresses with new firewall ([@AdamKasp](https://github.com/AdamKasp))
- [#11971](https://github.com/Sylius/Sylius/issues/11971) [API] Seeing promotions total in cart ([@arti0090](https://github.com/arti0090))
- [#11973](https://github.com/Sylius/Sylius/issues/11973) [API] [My Account] Edit addressbook ([@SirDomin](https://github.com/SirDomin))
- [#11983](https://github.com/Sylius/Sylius/issues/11983) [Minor] Update service definition to not using depracated service ([@lchrusciel](https://github.com/lchrusciel))
- [#11984](https://github.com/Sylius/Sylius/issues/11984) [API]maintaining cart after login and registration ([@arti0090](https://github.com/arti0090))
- [#11989](https://github.com/Sylius/Sylius/issues/11989) [API]added missing serialization to address editing endpoint ([@arti0090](https://github.com/arti0090))
- [#11995](https://github.com/Sylius/Sylius/issues/11995) [Behat] Fix argument name after upgrade Behat to v3.8.0 ([@GSadee](https://github.com/GSadee))
- [#11997](https://github.com/Sylius/Sylius/issues/11997) Revert "[API]added missing serialization to address editing endpoint" ([@lchrusciel](https://github.com/lchrusciel))
- [#11998](https://github.com/Sylius/Sylius/issues/11998) [API][Shop] Logging in after changing password implementation ([@lchrusciel](https://github.com/lchrusciel), [@arti0090](https://github.com/arti0090))
- [#12001](https://github.com/Sylius/Sylius/issues/12001) [Maintenance] Fix naming issues after psalm bump ([@lchrusciel](https://github.com/lchrusciel))
- [#12002](https://github.com/Sylius/Sylius/issues/12002) [API]added missing serialization to address editing endpoint ([@arti0090](https://github.com/arti0090))
- [#12003](https://github.com/Sylius/Sylius/issues/12003) [API][Behat]refactor api admin context ([@arti0090](https://github.com/arti0090))
- [#12006](https://github.com/Sylius/Sylius/issues/12006) [API][Checkout] Implement scenarios for preventing checkout with an empty cart ([@GSadee](https://github.com/GSadee))
- [#12007](https://github.com/Sylius/Sylius/issues/12007) [API] Fix names in change password command ([@AdamKasp](https://github.com/AdamKasp))
- [#12008](https://github.com/Sylius/Sylius/issues/12008) Note about disabled product variants and taxons ([@jacquesbh](https://github.com/jacquesbh))
- [#12013](https://github.com/Sylius/Sylius/issues/12013) [API]adding promotions with expire date ([@arti0090](https://github.com/arti0090))
- [#12016](https://github.com/Sylius/Sylius/issues/12016) [Api] Changing orders payment methods on shop account ([@Tomanhez](https://github.com/Tomanhez))
- [#12021](https://github.com/Sylius/Sylius/issues/12021) Remove unnecessary conflicts ([@pamil](https://github.com/pamil))
- [#12025](https://github.com/Sylius/Sylius/issues/12025) [API]adding promotions with expire date  ([@arti0090](https://github.com/arti0090))
- [#12026](https://github.com/Sylius/Sylius/issues/12026) [Order] Change localisation of findCartByTokenValue function ([@AdamKasp](https://github.com/AdamKasp))
- [#12027](https://github.com/Sylius/Sylius/issues/12027) [FIXTURES] Use shopbillDataFactory in ChannelExampleFactory ([@lukasz](https://github.com/lukasz).[@wroblewski88](https://github.com/wroblewski88)@[@gmail](https://github.com/gmail).[@com](https://github.com/com))
- [#12032](https://github.com/Sylius/Sylius/issues/12032) [API] Move register operation below customers endpoint ([@lchrusciel](https://github.com/lchrusciel))
- [#12034](https://github.com/Sylius/Sylius/issues/12034) [API][Product] Change identifier for shop endpoint from slug to code ([@GSadee](https://github.com/GSadee))
- [#12035](https://github.com/Sylius/Sylius/issues/12035) info about JWT token generation required ([@rafbit](https://github.com/rafbit))
- [#12036](https://github.com/Sylius/Sylius/issues/12036) [API] Fix PHPSpec of order query extension after upmerge ([@GSadee](https://github.com/GSadee))
- [#12037](https://github.com/Sylius/Sylius/issues/12037) [API]fixes to `adding promotions with expire date` ([@arti0090](https://github.com/arti0090))
- [#12038](https://github.com/Sylius/Sylius/issues/12038) [Minor][ADR] Explicit bus declaration on handlers ([@lchrusciel](https://github.com/lchrusciel))
- [#12039](https://github.com/Sylius/Sylius/issues/12039) [Minor] Inject proper order processor ([@lchrusciel](https://github.com/lchrusciel))
- [#12041](https://github.com/Sylius/Sylius/issues/12041) [API] Fixes after PR with resolving proper iri in different contexts ([@GSadee](https://github.com/GSadee))
- [#12044](https://github.com/Sylius/Sylius/issues/12044) [API][Product] Add note in UPGRADE file about changing identifier for shop endpoint ([@GSadee](https://github.com/GSadee))
- [#12045](https://github.com/Sylius/Sylius/issues/12045) [API] Add missing endpoints for address and country resources ([@GSadee](https://github.com/GSadee))
- [#12050](https://github.com/Sylius/Sylius/issues/12050) Refactor mailing ([@lchrusciel](https://github.com/lchrusciel), [@SirDomin](https://github.com/SirDomin))
- [#12054](https://github.com/Sylius/Sylius/issues/12054) [ADR] Sending emails via api ([@SirDomin](https://github.com/SirDomin))
- [#12057](https://github.com/Sylius/Sylius/issues/12057) Switch to Psalm 4 ([@pamil](https://github.com/pamil))
- [#12058](https://github.com/Sylius/Sylius/issues/12058) Update PHPStan and its configuration ([@pamil](https://github.com/pamil))
- [#12059](https://github.com/Sylius/Sylius/issues/12059) Upgrade to PHPSpec 7 ([@pamil](https://github.com/pamil))
- [#12073](https://github.com/Sylius/Sylius/issues/12073) Replace fzaninotto/faker with fakerphp/faker ([@DieterHolvoet](https://github.com/DieterHolvoet))
- [#12074](https://github.com/Sylius/Sylius/issues/12074) [API] add api tag to applying promotions with expiration date ([@arti0090](https://github.com/arti0090))
- [#12075](https://github.com/Sylius/Sylius/issues/12075) [Behat]refactor of setup/PromotionContext class ([@arti0090](https://github.com/arti0090))
- [#12076](https://github.com/Sylius/Sylius/issues/12076) [API][Behat] fixed steps for quantity-change api test ([@arti0090](https://github.com/arti0090))
- [#12078](https://github.com/Sylius/Sylius/issues/12078) [Behat] refactor of cart and checkout contexts ([@arti0090](https://github.com/arti0090))
- [#12081](https://github.com/Sylius/Sylius/issues/12081) [Api] Receiving discount promotion ([@Tomanhez](https://github.com/Tomanhez))
- [#12082](https://github.com/Sylius/Sylius/issues/12082) [Promotions] Replace wrong names ([@Tomanhez](https://github.com/Tomanhez))
- [#12083](https://github.com/Sylius/Sylius/issues/12083) [Api] Receiving percentage discount ([@Tomanhez](https://github.com/Tomanhez))
- [#12084](https://github.com/Sylius/Sylius/issues/12084) Upgrade all dependencies to versions supporting Symfony 5 ([@pamil](https://github.com/pamil), [@Zales0123](https://github.com/Zales0123))
- [#12107](https://github.com/Sylius/Sylius/issues/12107) Api platform payment ([@SirDomin](https://github.com/SirDomin))
- [#12109](https://github.com/Sylius/Sylius/issues/12109) [API] placing order on multiple channels with api ([@arti0090](https://github.com/arti0090))
- [#12116](https://github.com/Sylius/Sylius/issues/12116) [Adjustment] Add more details to adjustment and make shipment adjustable ([@GSadee](https://github.com/GSadee), [@SirDomin](https://github.com/SirDomin), [@lchrusciel](https://github.com/lchrusciel))
- [#12128](https://github.com/Sylius/Sylius/issues/12128) [AdminApiBundle][CoreBundle] Update unit test versions ([@Tomanhez](https://github.com/Tomanhez))
- [#12139](https://github.com/Sylius/Sylius/issues/12139) [Api] Locale code on checkout ([@Tomanhez](https://github.com/Tomanhez))
- [#12153](https://github.com/Sylius/Sylius/issues/12153) [API] prevent checkout skipping shipping step ([@arti0090](https://github.com/arti0090))
- [#12154](https://github.com/Sylius/Sylius/issues/12154) [API] show possible shipping methods for order ([@arti0090](https://github.com/arti0090))
- [#12157](https://github.com/Sylius/Sylius/issues/12157) Bump ini from 1.3.5 to 1.3.7 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#12161](https://github.com/Sylius/Sylius/issues/12161) Add tag no-api to scenario ([@arti0090](https://github.com/arti0090))
- [#12162](https://github.com/Sylius/Sylius/issues/12162) [Api][Checkout] Shipping fees on multi-channel ([@Tomanhez](https://github.com/Tomanhez))
- [#12164](https://github.com/Sylius/Sylius/issues/12164) update upgrade file after changes with tax adjustment ([@arti0090](https://github.com/arti0090))
- [#12165](https://github.com/Sylius/Sylius/issues/12165) [Api] Check currency on channel ([@Tomanhez](https://github.com/Tomanhez))
- [#12178](https://github.com/Sylius/Sylius/issues/12178) [API] Browsing promotions ([@arti0090](https://github.com/arti0090))
- [#12179](https://github.com/Sylius/Sylius/issues/12179) [API] deleting promotions ([@arti0090](https://github.com/arti0090))
- [#12184](https://github.com/Sylius/Sylius/issues/12184) [BC BREAK] [Api][AdminUser][AvatarImage][Channel][Currency][Customer] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12188](https://github.com/Sylius/Sylius/issues/12188) [BC BREAK] [Api][Order] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12205](https://github.com/Sylius/Sylius/issues/12205) [BC BREAK] [Api][Product] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12206](https://github.com/Sylius/Sylius/issues/12206) [BC BREAK] [Api][OrderItem][OrderItemUnit] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12206](https://github.com/Sylius/Sylius/issues/12206) [BC BREAK] [Api][OrderItem][OrderItemUnit] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12212](https://github.com/Sylius/Sylius/issues/12212) [BC BREAK] [Api][Promotion][Province] Refactor api serialization groups ([@lchrusciel](https://github.com/lchrusciel))
- [#12213](https://github.com/Sylius/Sylius/issues/12213) Upgrade psalm ([@Tomanhez](https://github.com/Tomanhez))
- [#12214](https://github.com/Sylius/Sylius/issues/12214) Add conflict liminas/liminas-code 4.0.0 ([@Tomanhez](https://github.com/Tomanhez))
- [#12215](https://github.com/Sylius/Sylius/issues/12215) Update CONFLICTS.MD ([@Tomanhez](https://github.com/Tomanhez))
- [#12218](https://github.com/Sylius/Sylius/issues/12218) Remove laminas/laminas-code conflict ([@Tomanhez](https://github.com/Tomanhez))
- [#12228](https://github.com/Sylius/Sylius/issues/12228) [BC BREAK] [Api][Adjustment][CustomerGrouop][ExchangeRate][Locale][Payment][PaymentMethod] Refactor api serialization groups ([@Tomanhez](https://github.com/Tomanhez))
- [#12231](https://github.com/Sylius/Sylius/issues/12231) Add conflict with polyfill-mbstring 1.22.0 ([@Tomanhez](https://github.com/Tomanhez))
