# CHANGELOG FOR `1.13.X`

## v1.13.7 (2024-10-15)

#### Details

- [#17012](https://github.com/Sylius/Sylius/issues/17012) [CI] Remove unused social media notifications action +  improvements ([@GSadee](https://github.com/GSadee))
- [#17017](https://github.com/Sylius/Sylius/issues/17017) [API] Add missing endpoint for ShopUser in shop context ([@GSadee](https://github.com/GSadee))
- [#17044](https://github.com/Sylius/Sylius/issues/17044) [Docs] Add 2.0-dev installation instructions ([@CoderMaggie](https://github.com/CoderMaggie))
- [#17070](https://github.com/Sylius/Sylius/issues/17070) Fix comparison of order items ([@jaroslavtyc](https://github.com/jaroslavtyc))
- [#17120](https://github.com/Sylius/Sylius/issues/17120) Add gedmo/doctrine-extensions conflict ([@mpysiak](https://github.com/mpysiak))
- [#17138](https://github.com/Sylius/Sylius/issues/17138) Remove winzouStateMachineBundle from packages' test applications to support ResourceBundle 1.12 ([@GSadee](https://github.com/GSadee))
- [#17144](https://github.com/Sylius/Sylius/issues/17144) [Docs] Fix readthedocs configuration file ([@CoderMaggie](https://github.com/CoderMaggie))
- [#17148](https://github.com/Sylius/Sylius/issues/17148) [CI] Remove currently unneeded custom build ([@GSadee](https://github.com/GSadee))
- [#17139](https://github.com/Sylius/Sylius/issues/17139) [Composer] Remove conflict to doctrine/orm ([@GSadee](https://github.com/GSadee))
- [#17163](https://github.com/Sylius/Sylius/issues/17163) Add the packages that have become optional in version 1.12 of the ResourceBundle. ([@Wojdylak](https://github.com/Wojdylak))
- [#17169](https://github.com/Sylius/Sylius/issues/17169) Update README.md ([@kulczy](https://github.com/kulczy))
- [#17162](https://github.com/Sylius/Sylius/issues/17162) Fix session unavailable in locale context ([@NoResponseMate](https://github.com/NoResponseMate))
- [#17219](https://github.com/Sylius/Sylius/issues/17219) [Behat] Normalize whitespace characters in string ([@Wojdylak](https://github.com/Wojdylak))

## v1.13.6 (2024-09-24)

#### Details

- [#16753](https://github.com/Sylius/Sylius/issues/16753) [CS][DX] Refactor
- [#16794](https://github.com/Sylius/Sylius/issues/16794) [Core] Move validation of translation classes to Core ([@GSadee](https://github.com/GSadee))
- [#15706](https://github.com/Sylius/Sylius/issues/15706) Try SyliusResourceBundle 1.11 & SyliusGridBundle 1.13 ([@loic425](https://github.com/loic425))
- [#16819](https://github.com/Sylius/Sylius/issues/16819) Fix static analysis to support both sylius/resource-bundle 1.11 and older versions ([@Rafikooo](https://github.com/Rafikooo), [@GSadee](https://github.com/GSadee))
- [#16827](https://github.com/Sylius/Sylius/issues/16827) [Behat] Switch random JS failed scenarios to Chromedriver ([@GSadee](https://github.com/GSadee))
- [#16812](https://github.com/Sylius/Sylius/issues/16812) [CS][DX] Refactor
- [#16836](https://github.com/Sylius/Sylius/issues/16836) [CS][DX] Refactor
- [#16868](https://github.com/Sylius/Sylius/issues/16868) Cover the scenario for allowing access for only correctly logged in users ([@TheMilek](https://github.com/TheMilek))
- [#16885](https://github.com/Sylius/Sylius/issues/16885) [CS][DX] Refactor
- [#16897](https://github.com/Sylius/Sylius/issues/16897) [Docs] Fix link in grids customization guide ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16922](https://github.com/Sylius/Sylius/issues/16922) [CI] Split JS builds for Panther and Chromedriver + add additional rerun ([@GSadee](https://github.com/GSadee))
- [#16966](https://github.com/Sylius/Sylius/issues/16966) Update state_machine.rst ([@JakubCzech-pl](https://github.com/JakubCzech-pl))
- [#16891](https://github.com/Sylius/Sylius/issues/16891) [CI] Upgrade ResourceBundle in unstable custom build ([@GSadee](https://github.com/GSadee))
- [#16979](https://github.com/Sylius/Sylius/issues/16979) [CI] Add SyliusMailerBundle alpha version to custom build ([@GSadee](https://github.com/GSadee))
- [#16978](https://github.com/Sylius/Sylius/issues/16978) [CI] Bump up DB versions to current LTS ([@GSadee](https://github.com/GSadee))
- [#16981](https://github.com/Sylius/Sylius/issues/16981) [CI] Extract unstable build from full builds ([@GSadee](https://github.com/GSadee))
- [#16982](https://github.com/Sylius/Sylius/issues/16982) [CI] Adjust titles in custom build ([@GSadee](https://github.com/GSadee))
- [#16983](https://github.com/Sylius/Sylius/issues/16983) [CI] Minor refactor in full builds ([@GSadee](https://github.com/GSadee))
- [#16984](https://github.com/Sylius/Sylius/issues/16984) [CI] Add PHP 8.3 to builds ([@GSadee](https://github.com/GSadee))
- [#16985](https://github.com/Sylius/Sylius/issues/16985) [CI] Fix minimal builds ([@GSadee](https://github.com/GSadee))
- [#16997](https://github.com/Sylius/Sylius/issues/16997) [CI] Improve notification Slack message ([@GSadee](https://github.com/GSadee))

## v1.13.5 (2024-08-22)

#### Details

- [#16574](https://github.com/Sylius/Sylius/issues/16574) Use callback wrapper for LocaleChoiceType choices ([@wimulkeman](https://github.com/wimulkeman))
- [#16633](https://github.com/Sylius/Sylius/issues/16633) [ChannelsTest] Use inArray to check locales ([@Wojdylak](https://github.com/Wojdylak))
- [#16639](https://github.com/Sylius/Sylius/issues/16639) Fix PostgreSQL CI Full to run ([@Wojdylak](https://github.com/Wojdylak))
- [#16638](https://github.com/Sylius/Sylius/issues/16638) Refactor GUS info ([@Wojdylak](https://github.com/Wojdylak))
- [#16654](https://github.com/Sylius/Sylius/issues/16654) [API] Fix ShopUser docs example ([@mpysiak](https://github.com/mpysiak))
- [#16697](https://github.com/Sylius/Sylius/issues/16697) [API] Fix translation.name filters ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16699](https://github.com/Sylius/Sylius/issues/16699) Fixing configuration for customer order view ([@mamazu](https://github.com/mamazu))
- [#16645](https://github.com/Sylius/Sylius/issues/16645) [BC-Break Fix][1.13] Do not enforce soft method requirement on ProductVar… ([@lchrusciel](https://github.com/lchrusciel))

## v1.13.4 (2024-07-17)

#### Details

- [#16469](https://github.com/Sylius/Sylius/issues/16469) Use interface for a response checker dependency ([@jaroslavtyc](https://github.com/jaroslavtyc))
- [#16544](https://github.com/Sylius/Sylius/issues/16544) [Docs] Update Taxon-Menu Page To Reflect Current Fixtures Configuration ([@Rafikooo](https://github.com/Rafikooo))
- [#16550](https://github.com/Sylius/Sylius/issues/16550) [Behat] Enable Accessing The Product Edit Page From The Show Page Scenarios ([@Rafikooo](https://github.com/Rafikooo))
- [#16581](https://github.com/Sylius/Sylius/issues/16581) [CS][DX] Refactor
- [#16592](https://github.com/Sylius/Sylius/issues/16592) [API] Disable shop GET adjustment endpoint ([@mpysiak](https://github.com/mpysiak), [@GSadee](https://github.com/GSadee))

## v1.13.3 (2024-07-02)

#### Details

- [#16393](https://github.com/Sylius/Sylius/issues/16393) [User] Update the default tokens' length and the upper limit ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16392](https://github.com/Sylius/Sylius/issues/16392) [Core] Add order token length to configuration ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16410](https://github.com/Sylius/Sylius/issues/16410) [CS][DX] Refactor
- [#16419](https://github.com/Sylius/Sylius/issues/16419) [User] Reflect New Default Token Length in the Packages Tests ([@Rafikooo](https://github.com/Rafikooo))
- [#16431](https://github.com/Sylius/Sylius/issues/16431) [CI] Change the version of Chrome ([@GSadee](https://github.com/GSadee))
- [#16432](https://github.com/Sylius/Sylius/issues/16432) [CI] Change the version of Chrome from hardcoded one to stable ([@GSadee](https://github.com/GSadee))
- [#16439](https://github.com/Sylius/Sylius/issues/16439) Correct wrong command in the platform's cron example docs ([@TheMilek](https://github.com/TheMilek))
- [#16441](https://github.com/Sylius/Sylius/issues/16441) Update README.md ([@kulczy](https://github.com/kulczy))
- [#16436](https://github.com/Sylius/Sylius/issues/16436) Sylius Plus modular installation and upgrading ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16435](https://github.com/Sylius/Sylius/issues/16435) [CI] Update Upmerge Strategy ([@Rafikooo](https://github.com/Rafikooo))
- [#16452](https://github.com/Sylius/Sylius/issues/16452) [Docs] Add a link to the database schema ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16500](https://github.com/Sylius/Sylius/issues/16500) [Documentation] Update Sylius 1.12 version on the release cycle page + update PR template ([@GSadee](https://github.com/GSadee))
- [#16477](https://github.com/Sylius/Sylius/issues/16477) Fix ProductTaxons' positioning logic ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16380](https://github.com/Sylius/Sylius/issues/16380) Fix products grid for mobile ([@Yanick-K](https://github.com/Yanick-K))
- [#16474](https://github.com/Sylius/Sylius/issues/16474) Update model.rst ([@zairigimad](https://github.com/zairigimad))
- [#16475](https://github.com/Sylius/Sylius/issues/16475) Update repository.rst ([@zairigimad](https://github.com/zairigimad))

## v1.13.2 (2024-06-07)

#### Details

- [#16246](https://github.com/Sylius/Sylius/issues/16246) Add the "sylius/state-machine-abstraction" package to the replace section in the root composer.json ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16252](https://github.com/Sylius/Sylius/issues/16252) [AbstractStateMachine] Add twig extension ([@Wojdylak](https://github.com/Wojdylak))
- [#16290](https://github.com/Sylius/Sylius/issues/16290) Update bunnyshell.yaml, use network type volumes for mysql-data ([@mihaichitic](https://github.com/mihaichitic))
- [#16293](https://github.com/Sylius/Sylius/issues/16293) [Core] Add Sylius Plus info Command ([@mpysiak](https://github.com/mpysiak))
- [#16297](https://github.com/Sylius/Sylius/issues/16297) [Core] Change Show Plus Info command namespace ([@mpysiak](https://github.com/mpysiak))
- [#16279](https://github.com/Sylius/Sylius/issues/16279) [Docs] Sylius Cloud by Platform.sh ([@senghe](https://github.com/senghe), [@CoderMaggie](https://github.com/CoderMaggie))
- [#16310](https://github.com/Sylius/Sylius/issues/16310) [Behat] Allow to use ApiPlatformSecurityClient with another login endpoint ([@Prometee](https://github.com/Prometee))
- [#16322](https://github.com/Sylius/Sylius/issues/16322) Core ItemTotalRuleChecker is missing type constant ([@esserj](https://github.com/esserj))
- [#16323](https://github.com/Sylius/Sylius/issues/16323) Sylius Community Edition naming in docs ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16324](https://github.com/Sylius/Sylius/issues/16324) Mark `tracked` and `shippingRequired` as not required fields ([@loevgaard](https://github.com/loevgaard))
- [#16329](https://github.com/Sylius/Sylius/issues/16329) [PHPStan] `Negated Boolean Expression Is Always True` Issue Fix ([@Rafikooo](https://github.com/Rafikooo))
- [#16307](https://github.com/Sylius/Sylius/issues/16307) Fix wrong calculation of available stock during completing a payment ([@GSadee](https://github.com/GSadee))
- [#16335](https://github.com/Sylius/Sylius/issues/16335) [Inventory] Adjust OrderInventoryOperator spec for exceptions changes ([@GSadee](https://github.com/GSadee))
- [#16344](https://github.com/Sylius/Sylius/issues/16344) [Inventory] Extract service for checking reserved stock availability for given order item ([@GSadee](https://github.com/GSadee))
- [#16342](https://github.com/Sylius/Sylius/issues/16342) Resolve createdByGuest on order fixtures ([@TheMilek](https://github.com/TheMilek))
- [#16321](https://github.com/Sylius/Sylius/issues/16321) Improve Order get endpoints ([@TheMilek](https://github.com/TheMilek))
- [#16352](https://github.com/Sylius/Sylius/issues/16352) [CS][DX] Refactor
- [#16353](https://github.com/Sylius/Sylius/issues/16353) [CS][DX] Refactor
- [#16358](https://github.com/Sylius/Sylius/issues/16358) [API] Adjust adjustments contract tests after upmerge ([@GSadee](https://github.com/GSadee))
- [#16360](https://github.com/Sylius/Sylius/issues/16360) Add a note to UPGRADE file about changing PaymentPreCompleteListener's constructor ([@GSadee](https://github.com/GSadee))

## v1.13.1 (2024-05-10)

#### Details

- [#16176](https://github.com/Sylius/Sylius/issues/16176) [Maintenance][AbstractStateMachine] Add Sylius logo to readme ([@Wojdylak](https://github.com/Wojdylak))
- [#16190](https://github.com/Sylius/Sylius/issues/16190) Fix products grid ([@kulczy](https://github.com/kulczy))
- [#16196](https://github.com/Sylius/Sylius/issues/16196) Fix product review validation's notInRangeMessage ([@mpysiak](https://github.com/mpysiak))
- [#16241](https://github.com/Sylius/Sylius/issues/16241) [Security] Fixes for potential XSS in the Checkout, Address Book and Admin Panel ([@GSadee](https://github.com/GSadee))
- [#16232](https://github.com/Sylius/Sylius/issues/16232) [Maintenance] Update docker docs ([@Wojdylak](https://github.com/Wojdylak))
- [#16233](https://github.com/Sylius/Sylius/issues/16233) Add wider support for deprecation contract ([@Jibbarth](https://github.com/Jibbarth))

## v1.13.0 (2024-04-23)

#### Details

- [#16128](https://github.com/Sylius/Sylius/issues/16128) Add twig 3.9.0 conflict ([@mpysiak](https://github.com/mpysiak))
- [#16131](https://github.com/Sylius/Sylius/issues/16131) Revert conflict to twig/intl-extra ([@GSadee](https://github.com/GSadee))
- [#16135](https://github.com/Sylius/Sylius/issues/16135) Add empty array check in ZoneRepository ([@mpysiak](https://github.com/mpysiak))
- [#16143](https://github.com/Sylius/Sylius/issues/16143) [Maintenance] Add branch 2.0 to refactor build ([@Wojdylak](https://github.com/Wojdylak))
- [#16134](https://github.com/Sylius/Sylius/issues/16134) Fix Sylius logo in READMEs of Bundles & Components ([@mpysiak](https://github.com/mpysiak))
- [#16158](https://github.com/Sylius/Sylius/issues/16158) Update dead link in drivers.rst ([@binhuq](https://github.com/binhuq))
- [#16147](https://github.com/Sylius/Sylius/issues/16147) [Maintenance] Remove unused reviews listener ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15384](https://github.com/Sylius/Sylius/issues/15384) [DX] Dispatch ui event to allow customize every choice in payment method selection ([@Jibbarth](https://github.com/Jibbarth))
- [#15417](https://github.com/Sylius/Sylius/issues/15417) [DX][Checkout][ShippingMethod] Dispatch new ui events ([@Jibbarth](https://github.com/Jibbarth), [@GSadee](https://github.com/GSadee))
- [#16157](https://github.com/Sylius/Sylius/issues/16157) [Maintenance][Configuration] Deprecate unused `options` configuration nodes ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16168](https://github.com/Sylius/Sylius/issues/16168) Fix setup command locale parameter update ([@TheMilek](https://github.com/TheMilek))

## v1.13.0-RC.1 (2024-04-16)

#### Details

- [#16073](https://github.com/Sylius/Sylius/issues/16073) [API][Shop] Improve Order and Checkout tests ([@Wojdylak](https://github.com/Wojdylak))
- [#16076](https://github.com/Sylius/Sylius/issues/16076) BUGFIX: [AdminBundle] #16031 wrap long text in notes section ([@crydotsnake](https://github.com/crydotsnake))
- [#16086](https://github.com/Sylius/Sylius/issues/16086) [API][Maintenance] Remove unnecessary enabled option ([@Wojdylak](https://github.com/Wojdylak))
- [#16085](https://github.com/Sylius/Sylius/issues/16085) [CS][DX] Refactor
- [#16092](https://github.com/Sylius/Sylius/issues/16092) Minor correction of names ([@Wojdylak](https://github.com/Wojdylak))
- [#16099](https://github.com/Sylius/Sylius/issues/16099) BUGFIX: [ShopBundle] #16068 wrap long text in product description ([@crydotsnake](https://github.com/crydotsnake))
- [#16100](https://github.com/Sylius/Sylius/issues/16100) [Maintenance] Add firewall for image resolver ([@Wojdylak](https://github.com/Wojdylak))
- [#16103](https://github.com/Sylius/Sylius/issues/16103) [Maintenance] Deprecate `SyliusLocaleEvents` ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16105](https://github.com/Sylius/Sylius/issues/16105) [Maintenance] Update upgrade file ([@Wojdylak](https://github.com/Wojdylak))
- [#15510](https://github.com/Sylius/Sylius/issues/15510) [Documentation] Update docs/book/architecture/state_machine.rst ([@benbd5](https://github.com/benbd5), [@GSadee](https://github.com/GSadee))
- [#15443](https://github.com/Sylius/Sylius/issues/15443) Use SyliusShop macros instead of SyliusUi in shop templates ([@maximehuran](https://github.com/maximehuran))
- [#15876](https://github.com/Sylius/Sylius/issues/15876) [ECS] Add The Nullable Type Declaration For Default Null Value Fixer Rule ([@Rafikooo](https://github.com/Rafikooo))
- [#16125](https://github.com/Sylius/Sylius/issues/16125) [Documentation] Update release dates for 1.13 and 2.0 versions ([@GSadee](https://github.com/GSadee))

## v1.13.0-BETA.1 (2024-04-02)

#### Details

- [#15947](https://github.com/Sylius/Sylius/issues/15947) [Maintenance] Enhance and Reorganize Upgrade Files ([@Rafikooo](https://github.com/Rafikooo))
- [#15982](https://github.com/Sylius/Sylius/issues/15982) [Upgrade] Note about Command and Console namespaces ([@Rafikooo](https://github.com/Rafikooo))
- [#15949](https://github.com/Sylius/Sylius/issues/15949) [API] Administrator and Customer endpoints Reorganization ([@Rafikooo](https://github.com/Rafikooo))
- [#15988](https://github.com/Sylius/Sylius/issues/15988) Change the default NODE_VERSION to 18 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15989](https://github.com/Sylius/Sylius/issues/15989) [Maintenance] Revert deprecating and aliasing PaymentFixture ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15992](https://github.com/Sylius/Sylius/issues/15992) Provide some Bunnyshell images improvements ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15993](https://github.com/Sylius/Sylius/issues/15993) Bunnyshell improvements for 1.12 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15972](https://github.com/Sylius/Sylius/issues/15972) [API] Prevent documenation failing when some endpoints are disabled ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15997](https://github.com/Sylius/Sylius/issues/15997) [Upgrade] Fix State Machine Title Size ([@Rafikooo](https://github.com/Rafikooo))
- [#16000](https://github.com/Sylius/Sylius/issues/16000) Fix the CODEOWNERS file ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16003](https://github.com/Sylius/Sylius/issues/16003) Fix the CODEOWNERS file ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16011](https://github.com/Sylius/Sylius/issues/16011) [Maintenance] Add conflict with api-platform/core 2.7.17 ([@Wojdylak](https://github.com/Wojdylak))
- [#16014](https://github.com/Sylius/Sylius/issues/16014) [UPMERGE] 1.12 -> 1.13 ([@SyliusBot](https://github.com/SyliusBot))
- [#16007](https://github.com/Sylius/Sylius/issues/16007) [API][Address] Add missing validations and improve endpoints ([@GSadee](https://github.com/GSadee))
- [#16013](https://github.com/Sylius/Sylius/issues/16013) Prepare Sylius\Behat to be installed as a separate package ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16017](https://github.com/Sylius/Sylius/issues/16017) [Maintenance] Fix ci ([@Wojdylak](https://github.com/Wojdylak))
- [#16018](https://github.com/Sylius/Sylius/issues/16018) [UPMERGE] 1.12 -> 1.13 ([@SyliusBot](https://github.com/SyliusBot))
- [#16020](https://github.com/Sylius/Sylius/issues/16020) [ApiBundle] Allow override properties ([@Wojdylak](https://github.com/Wojdylak))
- [#16024](https://github.com/Sylius/Sylius/issues/16024) [Maintenance] Revert remove behat steps ([@Wojdylak](https://github.com/Wojdylak))
- [#16012](https://github.com/Sylius/Sylius/issues/16012) Fix finding json by choice in the Postgres ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16008](https://github.com/Sylius/Sylius/issues/16008) Replace DC2TYPE:array field types with JSON ([@TheMilek](https://github.com/TheMilek))
- [#16030](https://github.com/Sylius/Sylius/issues/16030) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#16028](https://github.com/Sylius/Sylius/issues/16028) [Currency][Locale][Country] Update intl-based validation and cleanup obsolete options ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16009](https://github.com/Sylius/Sylius/issues/16009) [API] Refactor images path resolving ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16037](https://github.com/Sylius/Sylius/issues/16037) [Maintenance][API] Inform about removed configuration node ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16026](https://github.com/Sylius/Sylius/issues/16026) [DOC] Update an access Denied link ([@lacpandore](https://github.com/lacpandore))
- [#16039](https://github.com/Sylius/Sylius/issues/16039) [README] Improve visibility of Sylius Plus ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16021](https://github.com/Sylius/Sylius/issues/16021) Revert "Prepare Sylius\Behat to be installed as a separate package" ([@Wojdylak](https://github.com/Wojdylak))
- [#16040](https://github.com/Sylius/Sylius/issues/16040) [Behat][Maintenance] Split suites ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16038](https://github.com/Sylius/Sylius/issues/16038) [Docs] Improve visibility of Sylius Plus ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16027](https://github.com/Sylius/Sylius/issues/16027) Validate Admin user ([@TheMilek](https://github.com/TheMilek))
- [#16042](https://github.com/Sylius/Sylius/issues/16042) [Admin] Improve channel fields validation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16022](https://github.com/Sylius/Sylius/issues/16022) Validate out of range for channelPricing prices ([@TheMilek](https://github.com/TheMilek))
- [#16050](https://github.com/Sylius/Sylius/issues/16050) [API][Shop][ProductReview] Remove status and embed customer's name ([@Wojdylak](https://github.com/Wojdylak), [@GSadee](https://github.com/GSadee))
- [#16055](https://github.com/Sylius/Sylius/issues/16055) SYL-3329 Fix behat test for SyliusPayPalPlugin ([@mpysiak](https://github.com/mpysiak))
- [#16057](https://github.com/Sylius/Sylius/issues/16057) [Api][ProductImage] Add https prefix check ([@Wojdylak](https://github.com/Wojdylak))
- [#16033](https://github.com/Sylius/Sylius/issues/16033) Cover the max code length validation in bundles ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16056](https://github.com/Sylius/Sylius/issues/16056) [Api][Admin] Allow using float for ratio in exchange rate ([@Wojdylak](https://github.com/Wojdylak))
- [#16044](https://github.com/Sylius/Sylius/issues/16044) [API] Expose TaxonImage resource in shop ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16058](https://github.com/Sylius/Sylius/issues/16058) Validate all translatable objects for choosing unexisiting locales in the database ([@TheMilek](https://github.com/TheMilek))
- [#16051](https://github.com/Sylius/Sylius/issues/16051) Use Sylius State Machine Abstraction inside the Resource Controller State Machine ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16052](https://github.com/Sylius/Sylius/issues/16052) Add missing customer validation  ([@TheMilek](https://github.com/TheMilek))
- [#16067](https://github.com/Sylius/Sylius/issues/16067) Add missing validation for the customers first and last name ([@TheMilek](https://github.com/TheMilek))
- [#16066](https://github.com/Sylius/Sylius/issues/16066) [CS][DX] Refactor
- [#16078](https://github.com/Sylius/Sylius/issues/16078) Update the Upmerge workflow ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16072](https://github.com/Sylius/Sylius/issues/16072) [CS][DX] Refactor
- [#16043](https://github.com/Sylius/Sylius/issues/16043) [Maintenance][API] Secure and cleanup openapi documentation modifiers ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15923](https://github.com/Sylius/Sylius/issues/15923) [FIX] Move a config to the Core  ([@Prometee](https://github.com/Prometee), [@GSadee](https://github.com/GSadee))
- [#16063](https://github.com/Sylius/Sylius/issues/16063) [Api][Checkout] Add validation for required address ([@Wojdylak](https://github.com/Wojdylak))
- [#16062](https://github.com/Sylius/Sylius/issues/16062) Using the service name for the availibilty checker ([@mamazu](https://github.com/mamazu))
- [#16082](https://github.com/Sylius/Sylius/issues/16082) [Inventory] Fix deprecation note of sylius_inventory.checker configuration ([@GSadee](https://github.com/GSadee))

## v1.13.0-ALPHA.2 (2024-03-11)

#### Details

- [#15818](https://github.com/Sylius/Sylius/issues/15818) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15803](https://github.com/Sylius/Sylius/issues/15803) Duplicate all serializer groups with sylius prefix ([@Rafikooo](https://github.com/Rafikooo))
- [#15824](https://github.com/Sylius/Sylius/issues/15824) Bump up symfony/flex version ([@GSadee](https://github.com/GSadee))
- [#15827](https://github.com/Sylius/Sylius/issues/15827) Bump up PHP to 8.1 ([@GSadee](https://github.com/GSadee))
- [#15829](https://github.com/Sylius/Sylius/issues/15829) [CI] Remove unsupported MySQL 5.7 from workflows ([@GSadee](https://github.com/GSadee))
- [#15828](https://github.com/Sylius/Sylius/issues/15828) Bump up Symfony 6 to 6.4 ([@GSadee](https://github.com/GSadee))
- [#15821](https://github.com/Sylius/Sylius/issues/15821) [ApiBundle][Statystics] Add validation ([@Wojdylak](https://github.com/Wojdylak))
- [#15830](https://github.com/Sylius/Sylius/issues/15830) Bump up Node.js only to supported LTS versions (18 and 20) ([@GSadee](https://github.com/GSadee))
- [#15788](https://github.com/Sylius/Sylius/issues/15788) Fix subresource and resource serialization groups and add missing contract tests ([@TheMilek](https://github.com/TheMilek))
- [#15844](https://github.com/Sylius/Sylius/issues/15844) Fix serialization groups config formatting ([@TheMilek](https://github.com/TheMilek))
- [#15794](https://github.com/Sylius/Sylius/issues/15794) Usage of E-Mail Managers within CommandHandlers ([@Rafikooo](https://github.com/Rafikooo))
- [#15836](https://github.com/Sylius/Sylius/issues/15836) Resolve contract tests catalogs ([@TheMilek](https://github.com/TheMilek))
- [#15843](https://github.com/Sylius/Sylius/issues/15843) Resolve comments ([@TheMilek](https://github.com/TheMilek))
- [#15839](https://github.com/Sylius/Sylius/issues/15839) [FLYSYSTEM] Add directory visibility as public to local storage ([@Wojdylak](https://github.com/Wojdylak))
- [#15842](https://github.com/Sylius/Sylius/issues/15842) [Promotion] Add form type option to AsPromotionAction attribute ([@Wojdylak](https://github.com/Wojdylak))
- [#15857](https://github.com/Sylius/Sylius/issues/15857) [Api][ProductTaxon] Disable the ability to update product and taxon fields on productTaxon ([@Wojdylak](https://github.com/Wojdylak))
- [#15853](https://github.com/Sylius/Sylius/issues/15853) [ProductAttribute] Use value of options when use "Apply to all" ([@Jibbarth](https://github.com/Jibbarth))
- [#15861](https://github.com/Sylius/Sylius/issues/15861) [API] Cover adjustments serialization on OrderItemUnit and Shipment resources ([@Wojdylak](https://github.com/Wojdylak))
- [#15864](https://github.com/Sylius/Sylius/issues/15864) [API][Admin][Shop] Fix returned adjustments for order item ([@Wojdylak](https://github.com/Wojdylak))
- [#15854](https://github.com/Sylius/Sylius/issues/15854) Archiving Cart Promotion ([@Wojdylak](https://github.com/Wojdylak))
- [#15865](https://github.com/Sylius/Sylius/issues/15865) [API][Shop] Minor clean up of address contract tests ([@GSadee](https://github.com/GSadee))
- [#15859](https://github.com/Sylius/Sylius/issues/15859) FIX zoneMembers not unique ID ([@TheMilek](https://github.com/TheMilek))
- [#15858](https://github.com/Sylius/Sylius/issues/15858) Remove missed sm.factory usages ([@Wojdylak](https://github.com/Wojdylak))
- [#15871](https://github.com/Sylius/Sylius/issues/15871) [API] Add missing shop GET endpoint for province ([@GSadee](https://github.com/GSadee))
- [#15870](https://github.com/Sylius/Sylius/issues/15870) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15874](https://github.com/Sylius/Sylius/issues/15874) Add missing price history suites ([@TheMilek](https://github.com/TheMilek))
- [#15850](https://github.com/Sylius/Sylius/issues/15850) [Behat] Order Token Generation ([@Rafikooo](https://github.com/Rafikooo))
- [#15877](https://github.com/Sylius/Sylius/issues/15877) [API][Shop] Minor improvements for contact request ([@GSadee](https://github.com/GSadee))
- [#15872](https://github.com/Sylius/Sylius/issues/15872) [API][Shop] Add missing contract test for getting only countries from current channel ([@GSadee](https://github.com/GSadee))
- [#15873](https://github.com/Sylius/Sylius/issues/15873) [API][Shop] Add missing contract test for getting only locales from current channel ([@GSadee](https://github.com/GSadee))
- [#15875](https://github.com/Sylius/Sylius/issues/15875) [API][Shop] Improvements for customer endpoints ([@GSadee](https://github.com/GSadee))
- [#15866](https://github.com/Sylius/Sylius/issues/15866) [API] Improve adjustment endpoints' responses ([@GSadee](https://github.com/GSadee))
- [#15878](https://github.com/Sylius/Sylius/issues/15878) [API][Shop] Improvements for customer account verification ([@GSadee](https://github.com/GSadee))
- [#15895](https://github.com/Sylius/Sylius/issues/15895) Split ci__full.yaml workflow into smaller ones ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15897](https://github.com/Sylius/Sylius/issues/15897) [Api][Shop][ProductAssociationType] Remove createdAt and updatedAt properties from response ([@Wojdylak](https://github.com/Wojdylak))
- [#15898](https://github.com/Sylius/Sylius/issues/15898) [Api][Shop][ProductReview] Add test to check email requirement ([@Wojdylak](https://github.com/Wojdylak))
- [#15899](https://github.com/Sylius/Sylius/issues/15899) [Api][Shop]Improve product taxon tests ([@Wojdylak](https://github.com/Wojdylak))
- [#15901](https://github.com/Sylius/Sylius/issues/15901) [Api][Shop] Improve product image tests ([@Wojdylak](https://github.com/Wojdylak))
- [#15902](https://github.com/Sylius/Sylius/issues/15902) [API][Shop] Improve product option tests ([@Wojdylak](https://github.com/Wojdylak))
- [#15894](https://github.com/Sylius/Sylius/issues/15894) [API][Shop] Improve product attribute tests ([@Wojdylak](https://github.com/Wojdylak))
- [#15905](https://github.com/Sylius/Sylius/issues/15905) [Api][Shop] Improve product variant tests ([@Wojdylak](https://github.com/Wojdylak))
- [#15906](https://github.com/Sylius/Sylius/issues/15906) [Api][Shop] Improve catalog promotion tests  ([@Wojdylak](https://github.com/Wojdylak))
- [#15879](https://github.com/Sylius/Sylius/issues/15879) [Api][Shop] Get only accepted review in product ([@Wojdylak](https://github.com/Wojdylak))
- [#15900](https://github.com/Sylius/Sylius/issues/15900) BUGFIX: #12681 add missing required class  to provincecode select input ([@crydotsnake](https://github.com/crydotsnake))
- [#15909](https://github.com/Sylius/Sylius/issues/15909) BUGFIX: #15908 [AdminBundle] missing br tag for spacing for product media tab button ([@crydotsnake](https://github.com/crydotsnake))
- [#15914](https://github.com/Sylius/Sylius/issues/15914) Add paths to promotion coupon ([@TheMilek](https://github.com/TheMilek))
- [#15916](https://github.com/Sylius/Sylius/issues/15916) Add paths to shipping category ([@TheMilek](https://github.com/TheMilek))
- [#15917](https://github.com/Sylius/Sylius/issues/15917) [Api][Admin] Add constraint to product review ([@Wojdylak](https://github.com/Wojdylak))
- [#15907](https://github.com/Sylius/Sylius/issues/15907) [API] Add missing Admin Orders API contract tests ([@Rafikooo](https://github.com/Rafikooo))
- [#15919](https://github.com/Sylius/Sylius/issues/15919) Add missing description to shipping method and make calculator serialization name more descriptive ([@TheMilek](https://github.com/TheMilek))
- [#15918](https://github.com/Sylius/Sylius/issues/15918) [Api][Admin] Improve product option  ([@Wojdylak](https://github.com/Wojdylak))
- [#15921](https://github.com/Sylius/Sylius/issues/15921) Add paths to tax category ([@TheMilek](https://github.com/TheMilek))
- [#15920](https://github.com/Sylius/Sylius/issues/15920) Add paths to tax rate ([@TheMilek](https://github.com/TheMilek))
- [#15925](https://github.com/Sylius/Sylius/issues/15925) [Unit][Admin] Missing Product Association Type Translations Test ([@Rafikooo](https://github.com/Rafikooo))
- [#15926](https://github.com/Sylius/Sylius/issues/15926) [Unit][Admin] Missing Product Attribute Translations Test ([@Rafikooo](https://github.com/Rafikooo))
- [#15931](https://github.com/Sylius/Sylius/issues/15931) [Unit][Admin] Catalog Promotion Removal Test ([@Rafikooo](https://github.com/Rafikooo))
- [#15922](https://github.com/Sylius/Sylius/issues/15922) [Unit][Admin] Missing Payments Tests ([@Rafikooo](https://github.com/Rafikooo))
- [#15927](https://github.com/Sylius/Sylius/issues/15927) [API] Missing AvatarImage Tests ([@Rafikooo](https://github.com/Rafikooo))
- [#15924](https://github.com/Sylius/Sylius/issues/15924) [Unit][Admin] Missing Payment Methods tests ([@Rafikooo](https://github.com/Rafikooo))
- [#15932](https://github.com/Sylius/Sylius/issues/15932) [Unit][API] Missing Customer Group Removal Test ([@Rafikooo](https://github.com/Rafikooo))
- [#15934](https://github.com/Sylius/Sylius/issues/15934) [API][Shop] Remove translations' endpoints ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15936](https://github.com/Sylius/Sylius/issues/15936) [Unit][Admin] Missing Exchange Rate Test ([@Rafikooo](https://github.com/Rafikooo))
- [#15935](https://github.com/Sylius/Sylius/issues/15935) [Unit][Admin] Missing Customer Tests ([@Rafikooo](https://github.com/Rafikooo))
- [#15937](https://github.com/Sylius/Sylius/issues/15937) [API][Maintenance] Fix field name in AddressLogEntry serialization ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15682](https://github.com/Sylius/Sylius/issues/15682) Improve Product's show page performance ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15956](https://github.com/Sylius/Sylius/issues/15956) Bye Sylius Forum ☠️ ([@CoderMaggie](https://github.com/CoderMaggie))
- [#15957](https://github.com/Sylius/Sylius/issues/15957) Update README.md remove info about forum ([@damonsson](https://github.com/damonsson))
- [#15963](https://github.com/Sylius/Sylius/issues/15963) [Maintenance] Update GHA ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15968](https://github.com/Sylius/Sylius/issues/15968) Remove info about forum from Admin panel and documentation ([@GSadee](https://github.com/GSadee))
- [#15969](https://github.com/Sylius/Sylius/issues/15969) [API] Remove experimental tag from ApiBundle ([@GSadee](https://github.com/GSadee))
- [#15970](https://github.com/Sylius/Sylius/issues/15970) [Order] Remove dead argument from OrderRepository::countByCustomerAndCoupon ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15971](https://github.com/Sylius/Sylius/issues/15971) [Docs] Refactor information about GUS ([@CoderMaggie](https://github.com/CoderMaggie))
- [#15939](https://github.com/Sylius/Sylius/issues/15939) BUGFIX: #15938 [AdminBundle] add spacing between choose file button and uploaded image in image_widget ([@crydotsnake](https://github.com/crydotsnake))
- [#15696](https://github.com/Sylius/Sylius/issues/15696) [Admin] Do not disable channel base currency when none set ([@NoResponseMate](https://github.com/NoResponseMate))

## v1.13.0-ALPHA.1 (2024-02-05)

#### Details

- [#14379](https://github.com/Sylius/Sylius/issues/14379) [Admin] Cart promotions translations for labels ([@ernestWarwas](https://github.com/ernestWarwas))
- [#14483](https://github.com/Sylius/Sylius/issues/14483) Updating the RemoveExpiredCartCommand ([@mamazu](https://github.com/mamazu))
- [#14502](https://github.com/Sylius/Sylius/issues/14502) [Maintenance] Improve deprecation notice ([@lchrusciel](https://github.com/lchrusciel))
- [#14519](https://github.com/Sylius/Sylius/issues/14519) Refresh readme banner ([@kulczy](https://github.com/kulczy))
- [#14478](https://github.com/Sylius/Sylius/issues/14478) Add PaymentFixture ([@TheMilek](https://github.com/TheMilek))
- [#14550](https://github.com/Sylius/Sylius/issues/14550) [Admin][Customer] Filtering customers by groups ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14565](https://github.com/Sylius/Sylius/issues/14565) [Order] Add cart summary event ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14485](https://github.com/Sylius/Sylius/issues/14485) Adding a filter for state in product review grid ([@mamazu](https://github.com/mamazu))
- [#14529](https://github.com/Sylius/Sylius/issues/14529) Prepare for releasing @sylius-ui/frontend npm package ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14607](https://github.com/Sylius/Sylius/issues/14607) [CS][DX] Refactor
- [#14571](https://github.com/Sylius/Sylius/issues/14571) Create admin user with CLI ([@johbuch](https://github.com/johbuch), [@ernestWarwas](https://github.com/ernestWarwas), [@Rafikooo](https://github.com/Rafikooo))
- [#14568](https://github.com/Sylius/Sylius/issues/14568) [Catalog Promotions] Put catalog promotions into the processing state right after the delete request and keep this state until being removed ([@coldic3](https://github.com/coldic3))
- [#14660](https://github.com/Sylius/Sylius/issues/14660) [Maintenance] PHPUnit upgrade to ^9.5 ([@Rafikooo](https://github.com/Rafikooo))
- [#14654](https://github.com/Sylius/Sylius/issues/14654) Add a cookbook about dealing with multiple channels in console commands ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14629](https://github.com/Sylius/Sylius/issues/14629) [DX] Store passwords in plaintext in test environment ([@coldic3](https://github.com/coldic3))
- [#14658](https://github.com/Sylius/Sylius/issues/14658) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14668](https://github.com/Sylius/Sylius/issues/14668) Improve "Handle multiple channels in CLI" cookbook ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14696](https://github.com/Sylius/Sylius/issues/14696) Remove yarn.lock file ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14708](https://github.com/Sylius/Sylius/issues/14708) Add missing final keywords to Spec tests ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14709](https://github.com/Sylius/Sylius/issues/14709) Drop unneeded @javascript tag ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14718](https://github.com/Sylius/Sylius/issues/14718) [CS][DX] Refactor
- [#14598](https://github.com/Sylius/Sylius/issues/14598) [API] Mapping/serialization cleanup ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14655](https://github.com/Sylius/Sylius/issues/14655) Improve error handling while password resetting ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14713](https://github.com/Sylius/Sylius/issues/14713) [Core] Optimize UnpaidOrdersStateUpdater ([@coldic3](https://github.com/coldic3))
- [#14693](https://github.com/Sylius/Sylius/issues/14693) [Feature] Allows `row_attr` on form rows ([@Prometee](https://github.com/Prometee))
- [#14724](https://github.com/Sylius/Sylius/issues/14724) As an Admin, I want to modify taxons of a product ([@everwhatever](https://github.com/everwhatever))
- [#14710](https://github.com/Sylius/Sylius/issues/14710) Refactor CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14732](https://github.com/Sylius/Sylius/issues/14732) [Fix] Mark PHPSpec class as final ([@Rafikooo](https://github.com/Rafikooo))
- [#13445](https://github.com/Sylius/Sylius/issues/13445) [Promotion] Add a label for filters ([@pjurasek](https://github.com/pjurasek))
- [#14581](https://github.com/Sylius/Sylius/issues/14581) Fix dev dockerfile: add curl ([@Nek-](https://github.com/Nek-))
- [#14734](https://github.com/Sylius/Sylius/issues/14734) Adjust GitHub Actions jobs' names ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14741](https://github.com/Sylius/Sylius/issues/14741) [CS][DX] Refactor
- [#14698](https://github.com/Sylius/Sylius/issues/14698) ApiBundle fixes in composer.js ([@dawkaa](https://github.com/dawkaa))
- [#14742](https://github.com/Sylius/Sylius/issues/14742) Refactor Workflows to use two type of builds ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14747](https://github.com/Sylius/Sylius/issues/14747) Make build notifier running always event on failed builds ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14665](https://github.com/Sylius/Sylius/issues/14665) [Feature][Command] CreateAdminUserCommand - add AdminUser entity validation ([@Rafikooo](https://github.com/Rafikooo))
- [#14737](https://github.com/Sylius/Sylius/issues/14737) Add a custom workflow for Symfony 6.3 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14470](https://github.com/Sylius/Sylius/issues/14470) Update doctrine/cache requirement from ^1.10 to ^2.2 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#14771](https://github.com/Sylius/Sylius/issues/14771) Change the scheduled hour for full workflow to be different than in 1.12 branch ([@GSadee](https://github.com/GSadee))
- [#14769](https://github.com/Sylius/Sylius/issues/14769) [CS][DX] Refactor
- [#14786](https://github.com/Sylius/Sylius/issues/14786) Fix CI Full to run both 1.12 and 1.13 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14756](https://github.com/Sylius/Sylius/issues/14756) [API] Get admin detail information ([@dawkaa](https://github.com/dawkaa))
- [#14754](https://github.com/Sylius/Sylius/issues/14754) Add PHP 8.2 to workflows ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14728](https://github.com/Sylius/Sylius/issues/14728) [API] Fix admin's side can't create new taxonomy ([@dawkaa](https://github.com/dawkaa))
- [#12556](https://github.com/Sylius/Sylius/issues/12556) Add an option to use icon-only buttons on grids ([@loic425](https://github.com/loic425))
- [#13440](https://github.com/Sylius/Sylius/issues/13440) Add documentation for non-labeled actions ([@loic425](https://github.com/loic425))
- [#14790](https://github.com/Sylius/Sylius/issues/14790) Update RequestBuilder.php to PHP 8 new features ([@dawkaa](https://github.com/dawkaa))
- [#14794](https://github.com/Sylius/Sylius/issues/14794) [CS][DX] Refactor
- [#13045](https://github.com/Sylius/Sylius/issues/13045) Association hydrator private in product repo should be protected ([@Nek-](https://github.com/Nek-))
- [#14821](https://github.com/Sylius/Sylius/issues/14821) [CS][DX] Refactor
- [#14822](https://github.com/Sylius/Sylius/issues/14822) [CI] Remove PHP 8.2 from packages tests of the unmaintained Swiftmailer ([@GSadee](https://github.com/GSadee))
- [#14798](https://github.com/Sylius/Sylius/issues/14798) Reorder order's sidebar in admin ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14811](https://github.com/Sylius/Sylius/issues/14811) Cover managing the tax rates in API ([@hatem20](https://github.com/hatem20), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14831](https://github.com/Sylius/Sylius/issues/14831) [CS][DX] Refactor
- [#14833](https://github.com/Sylius/Sylius/issues/14833) Allow to define a priority on autoconfigured order processors and cart contexts ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14840](https://github.com/Sylius/Sylius/issues/14840) [CS][DX] Refactor
- [#14843](https://github.com/Sylius/Sylius/issues/14843) Add a note about autoconfiguring order processor with an attribute ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14623](https://github.com/Sylius/Sylius/issues/14623) chore: tag OrderTaxesApplicatorInterface ([@Florian-Merle](https://github.com/Florian-Merle))
- [#14848](https://github.com/Sylius/Sylius/issues/14848) [Dependencies] Bump up API Platform to 2.7.10 ([@GSadee](https://github.com/GSadee))
- [#10690](https://github.com/Sylius/Sylius/issues/10690) [Attributes] Add FloatAttributeType Feature ([@panigrc](https://github.com/panigrc), [@TheMilek](https://github.com/TheMilek))
- [#14852](https://github.com/Sylius/Sylius/issues/14852) [PriceHistory] Behat scenarios ([@Rafikooo](https://github.com/Rafikooo))
- [#14860](https://github.com/Sylius/Sylius/issues/14860) [Behat][API] Common saving within contexts ([@Rafikooo](https://github.com/Rafikooo))
- [#14864](https://github.com/Sylius/Sylius/issues/14864) [TaxRate][UI] Add missing behat step implementation ([@Rafikooo](https://github.com/Rafikooo))
- [#14862](https://github.com/Sylius/Sylius/issues/14862) [Behat][PriceHistory] Adjust scenarios for displaying lowest price according to the excluded taxons ([@GSadee](https://github.com/GSadee))
- [#14854](https://github.com/Sylius/Sylius/issues/14854) [PriceHistory][API] ChannelPricingLogEntry implementation ([@Rafikooo](https://github.com/Rafikooo))
- [#14866](https://github.com/Sylius/Sylius/issues/14866) [PriceHistory][UI] ChannelPricingLogEntry implementation ([@Rafikooo](https://github.com/Rafikooo))
- [#14867](https://github.com/Sylius/Sylius/issues/14867) [Attributes] FloatType input type as a number instead of text ([@TheMilek](https://github.com/TheMilek))
- [#14846](https://github.com/Sylius/Sylius/issues/14846) [Shipment] Reduce amount of queries during shipping eligibility checking ([@lchrusciel](https://github.com/lchrusciel))
- [#12781](https://github.com/Sylius/Sylius/issues/12781) Add "enabled" property to API serialization ([@Nek-](https://github.com/Nek-))
- [#14676](https://github.com/Sylius/Sylius/issues/14676) Add EmailMessagesProvider ([@TheMilek](https://github.com/TheMilek))
- [#14890](https://github.com/Sylius/Sylius/issues/14890) [CS][DX] Refactor
- [#14872](https://github.com/Sylius/Sylius/issues/14872) Fix dependency security vulerability for enshrined/svg-sanitize package ([@cosminsandu](https://github.com/cosminsandu))
- [#14873](https://github.com/Sylius/Sylius/issues/14873) Improve displaying info about insufficient stock in the cart ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14882](https://github.com/Sylius/Sylius/issues/14882) [PriceHistory] Display of information about the lowest price before the discount & channel setup ([@Rafikooo](https://github.com/Rafikooo))
- [#14875](https://github.com/Sylius/Sylius/issues/14875) [PriceHistory] Add removing price history command feature ([@TheMilek](https://github.com/TheMilek))
- [#14893](https://github.com/Sylius/Sylius/issues/14893) [OAuth] Up access and refresh tokens' length ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14894](https://github.com/Sylius/Sylius/issues/14894) Avoid getting the theme if we have it already ([@jacquesbh](https://github.com/jacquesbh), [@NoResponseMate](https://github.com/NoResponseMate))
- [#14899](https://github.com/Sylius/Sylius/issues/14899) [PriceHistory] Extract config ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14903](https://github.com/Sylius/Sylius/issues/14903) [PriceHistory] Combine migrations into one ([@TheMilek](https://github.com/TheMilek))
- [#14904](https://github.com/Sylius/Sylius/issues/14904) [PriceHistory] Asynchronous lowest price processing ([@Rafikooo](https://github.com/Rafikooo))
- [#14909](https://github.com/Sylius/Sylius/issues/14909) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#14915](https://github.com/Sylius/Sylius/issues/14915) [Maintenance] Rename OnFlushEntityObserverListener service ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14916](https://github.com/Sylius/Sylius/issues/14916) [API][ProductTaxon] Add unique combination validation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14900](https://github.com/Sylius/Sylius/issues/14900) [UpgradeFile] Introduce upgrade from Sylius 1.12 with PriceHistoryPlugin to Sylius 1.13 ([@TheMilek](https://github.com/TheMilek))
- [#14911](https://github.com/Sylius/Sylius/issues/14911) [PriceHistory] Add Compiler Pass for upgrade between Sylius 1.12 and Sylius 1.13 version ([@TheMilek](https://github.com/TheMilek))
- [#14928](https://github.com/Sylius/Sylius/issues/14928) [Maintenance] Add missing Spec for HasEnabledEntityValidator ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14837](https://github.com/Sylius/Sylius/issues/14837) [ProductVariant][API] Resource improvements ([@Rafikooo](https://github.com/Rafikooo))
- [#14930](https://github.com/Sylius/Sylius/issues/14930) [Maintenance] Fix schema update with longer UserOAuth tokens ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14931](https://github.com/Sylius/Sylius/issues/14931) [Behat][API] Checking out as guest with a registered email ([@coldic3](https://github.com/coldic3))
- [#14934](https://github.com/Sylius/Sylius/issues/14934) Cover accessing non-existing product via API scenario ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14933](https://github.com/Sylius/Sylius/issues/14933) Allow to filter products via API only by enabled taxon ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14943](https://github.com/Sylius/Sylius/issues/14943) Cover handling different currencies on multiple channels via API scenarios ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14939](https://github.com/Sylius/Sylius/issues/14939) [Behat][API] Add "no-api" tag to the changing payment method page scenario ([@coldic3](https://github.com/coldic3))
- [#14937](https://github.com/Sylius/Sylius/issues/14937) Add calculating OrderItemsSubtotal to the Order model ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14936](https://github.com/Sylius/Sylius/issues/14936) Cover applying correct taxes for shipping scenarios ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14922](https://github.com/Sylius/Sylius/issues/14922) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#14942](https://github.com/Sylius/Sylius/issues/14942) Cover applying correct taxes for shipping with tax rate included in price scenarios ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14947](https://github.com/Sylius/Sylius/issues/14947) Cover reapplying promotion on cart changes scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14921](https://github.com/Sylius/Sylius/issues/14921) [Fixtures] add possibility to configure shipping_address_in_checkout_required ([@BastienGoze](https://github.com/BastienGoze))
- [#14924](https://github.com/Sylius/Sylius/issues/14924) Update sylius/calendar requirement from ^0.3 || ^0.4 to ^0.5.0 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)], [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14951](https://github.com/Sylius/Sylius/issues/14951) Cover Api steps in paying offline during checkout scenario ([@TheMilek](https://github.com/TheMilek))
- [#14960](https://github.com/Sylius/Sylius/issues/14960) Cover Api steps in paying offline during checkout as guest scenario ([@TheMilek](https://github.com/TheMilek))
- [#14959](https://github.com/Sylius/Sylius/issues/14959) [Behat][API] Retrying the payment with different Offline payment ([@coldic3](https://github.com/coldic3))
- [#14945](https://github.com/Sylius/Sylius/issues/14945) Add @no-api to redirecting_to_products_when_there_is_a_trailing_slash_in_path scenarios ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14948](https://github.com/Sylius/Sylius/issues/14948) Cover reverting previously applied discount on cart scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14885](https://github.com/Sylius/Sylius/issues/14885) [DX] Ease adding more data to variant options map ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14952](https://github.com/Sylius/Sylius/issues/14952) [DX] Improve ChannelCollector customizability and performance ([@coldic3](https://github.com/coldic3))
- [#14950](https://github.com/Sylius/Sylius/issues/14950) [Migrations] Support PostgreSQL migrations ([@Rafikooo](https://github.com/Rafikooo))
- [#14791](https://github.com/Sylius/Sylius/issues/14791) Add a taxon delete section ([@dawkaa](https://github.com/dawkaa))
- [#14964](https://github.com/Sylius/Sylius/issues/14964) Clean up conflicts for sylius/sylius ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14989](https://github.com/Sylius/Sylius/issues/14989) [ProductTaxon][Product] Improve validation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14975](https://github.com/Sylius/Sylius/issues/14975) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#14999](https://github.com/Sylius/Sylius/issues/14999) [CI] Change outdated GitHub action ([@Rafikooo](https://github.com/Rafikooo))
- [#14969](https://github.com/Sylius/Sylius/issues/14969) [DX] Removed obsolete templating helper ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14919](https://github.com/Sylius/Sylius/issues/14919) Use Symfony HTTP Client in place of Guzzle 6 by default and provide Guzzle 7 support ([@coldic3](https://github.com/coldic3))
- [#14584](https://github.com/Sylius/Sylius/issues/14584) Fix product review validation's notInRangeMessage ([@diimpp](https://github.com/diimpp))
- [#15004](https://github.com/Sylius/Sylius/issues/15004) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15003](https://github.com/Sylius/Sylius/issues/15003) Cover seeing default shipping method scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15002](https://github.com/Sylius/Sylius/issues/15002) Cover product integrity scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15001](https://github.com/Sylius/Sylius/issues/15001) Cover editing customer profile scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15020](https://github.com/Sylius/Sylius/issues/15020) Cover Viewing only enabled taxons in taxon menu scenarios ([@TheMilek](https://github.com/TheMilek))
- [#15023](https://github.com/Sylius/Sylius/issues/15023) [Api][Maintenance] Remove ChannelContext from ProductVariantNormalizer ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15009](https://github.com/Sylius/Sylius/issues/15009) Replace `payum/payum` dependency with `payum/core` ([@rimas-kudelis](https://github.com/rimas-kudelis))
- [#15019](https://github.com/Sylius/Sylius/issues/15019) Update rector/rector requirement from ^0.15.13 to ^0.16.0 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#14994](https://github.com/Sylius/Sylius/issues/14994) [Products][Taxon] Allowing deleting a taxon that is a main taxon of a product ([@Rafikooo](https://github.com/Rafikooo))
- [#15012](https://github.com/Sylius/Sylius/issues/15012) Update guzzlehttp/psr7 requirement from ^1.8 to ^2.5 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#14968](https://github.com/Sylius/Sylius/issues/14968) Bump Psalm to v5 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15036](https://github.com/Sylius/Sylius/issues/15036) Fix CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15035](https://github.com/Sylius/Sylius/issues/15035) Remove 1.11 from the refactor workflow ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15039](https://github.com/Sylius/Sylius/issues/15039) Fix CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15044](https://github.com/Sylius/Sylius/issues/15044) Add API tag to viewing products with disabled variants scenarios ([@TheMilek](https://github.com/TheMilek))
- [#15015](https://github.com/Sylius/Sylius/issues/15015) [API] Product variants with options ([@Rafikooo](https://github.com/Rafikooo))
- [#15046](https://github.com/Sylius/Sylius/issues/15046) [Maintenance] Removed autogenerated migration comments ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14480](https://github.com/Sylius/Sylius/issues/14480) Missing length validation for label in cart promotion translations ([@ernestWarwas](https://github.com/ernestWarwas))
- [#15045](https://github.com/Sylius/Sylius/issues/15045) Uncomment editing customer profile steps ([@TheMilek](https://github.com/TheMilek))
- [#14944](https://github.com/Sylius/Sylius/issues/14944) Cover inform customer about order total changes scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15042](https://github.com/Sylius/Sylius/issues/15042) View only enabled taxons ([@TheMilek](https://github.com/TheMilek))
- [#15028](https://github.com/Sylius/Sylius/issues/15028) Cover viewing product associations via API ([@TheMilek](https://github.com/TheMilek))
- [#15054](https://github.com/Sylius/Sylius/issues/15054) Cover viewing different price for different product variants API scenario ([@TheMilek](https://github.com/TheMilek))
- [#15047](https://github.com/Sylius/Sylius/issues/15047) Parametrize operations allowed to bypass filtering carts ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15043](https://github.com/Sylius/Sylius/issues/15043) [Maintenance] Add a note about PostgreSQL migrations support ([@Rafikooo](https://github.com/Rafikooo))
- [#15060](https://github.com/Sylius/Sylius/issues/15060) [Product] Add an alias to `ProductVariantResolverInterface` ([@coldic3](https://github.com/coldic3))
- [#15070](https://github.com/Sylius/Sylius/issues/15070) Upmerge 1.12 into 1.13 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15066](https://github.com/Sylius/Sylius/issues/15066) [CS][DX] Refactor
- [#15083](https://github.com/Sylius/Sylius/issues/15083) Remove deprecated EventSubscriberInterface ([@TheMilek](https://github.com/TheMilek))
- [#15063](https://github.com/Sylius/Sylius/issues/15063) [API] Allow overriding xml resource mapping ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14990](https://github.com/Sylius/Sylius/issues/14990) [API] Sorting user orders by order number ([@dawkaa](https://github.com/dawkaa))
- [#15096](https://github.com/Sylius/Sylius/issues/15096) [Fix] Remove redundant conflict entries ([@Rafikooo](https://github.com/Rafikooo))
- [#15071](https://github.com/Sylius/Sylius/issues/15071) Update vimeo/psalm requirement from 5.9.* to 5.12.* ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#15091](https://github.com/Sylius/Sylius/issues/15091) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15095](https://github.com/Sylius/Sylius/issues/15095) Viewing children taxons API scenario ceverage ([@TheMilek](https://github.com/TheMilek))
- [#15103](https://github.com/Sylius/Sylius/issues/15103) Seeing order locale API scenario coverage ([@TheMilek](https://github.com/TheMilek))
- [#15098](https://github.com/Sylius/Sylius/issues/15098) Add @no-api tag to preventing to pay for cancelled order scenario ([@TheMilek](https://github.com/TheMilek))
- [#15068](https://github.com/Sylius/Sylius/issues/15068) View only available associations for product ([@TheMilek](https://github.com/TheMilek))
- [#15092](https://github.com/Sylius/Sylius/issues/15092) Cover Seeing payment method instructions behat API scenario ([@TheMilek](https://github.com/TheMilek))
- [#15104](https://github.com/Sylius/Sylius/issues/15104) Fixes after reviews ([@TheMilek](https://github.com/TheMilek))
- [#15085](https://github.com/Sylius/Sylius/issues/15085) [API][Products] Viewing diagonal variants options ([@Rafikooo](https://github.com/Rafikooo))
- [#15105](https://github.com/Sylius/Sylius/issues/15105) [Maintenance] Update the remaining copyright blocks ([@Rafikooo](https://github.com/Rafikooo))
- [#15106](https://github.com/Sylius/Sylius/issues/15106) [Maintenance] Update the remaining copyright blocks ([@Rafikooo](https://github.com/Rafikooo))
- [#15109](https://github.com/Sylius/Sylius/issues/15109) Add workflow for automatic upmerge PR creating ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15113](https://github.com/Sylius/Sylius/issues/15113) Fix auto upmerge workflow ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15112](https://github.com/Sylius/Sylius/issues/15112) [Scenarios] Add @no-api tag for `Addressing an order and sign in scenario` ([@Rafikooo](https://github.com/Rafikooo))
- [#15087](https://github.com/Sylius/Sylius/issues/15087) [Maintenance][API] Fix ChangedItemQuantityInCart validator alias ([@NoResponseMate](https://github.com/NoResponseMate), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15084](https://github.com/Sylius/Sylius/issues/15084) Update  Sylius 1.12 with PriceHistoryPlugin to Sylius 1.13 upgrade file ([@TheMilek](https://github.com/TheMilek))
- [#15061](https://github.com/Sylius/Sylius/issues/15061) Performance improvement of SingleChannelContext ([@coldic3](https://github.com/coldic3))
- [#15099](https://github.com/Sylius/Sylius/issues/15099) [Product] Composite variant resolver ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15121](https://github.com/Sylius/Sylius/issues/15121) Fix CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15122](https://github.com/Sylius/Sylius/issues/15122) [API] Cover signing in validation ([@Rafikooo](https://github.com/Rafikooo))
- [#15026](https://github.com/Sylius/Sylius/issues/15026) Allow removing locales ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15135](https://github.com/Sylius/Sylius/issues/15135) Revert "Add support for Bunnyshell (#15134)" ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15108](https://github.com/Sylius/Sylius/issues/15108) Prevent changing payment method of cancelled order ([@TheMilek](https://github.com/TheMilek))
- [#15132](https://github.com/Sylius/Sylius/issues/15132) Add joins on the orders list query builder conditionally ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15072](https://github.com/Sylius/Sylius/issues/15072) [API] Validate endpoints that uses commands ([@Rafikooo](https://github.com/Rafikooo))
- [#15138](https://github.com/Sylius/Sylius/issues/15138) [Bunnyshell] Adjust the workflows for Fork PRs ([@aris-bunnyshell](https://github.com/aris-bunnyshell))
- [#15143](https://github.com/Sylius/Sylius/issues/15143) Upmerge adjustments ([@Rafikooo](https://github.com/Rafikooo))
- [#15111](https://github.com/Sylius/Sylius/issues/15111) [API] Allow command IRI denormalization in arrays ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15158](https://github.com/Sylius/Sylius/issues/15158) [API] Replace Swagger with OpenAPI ([@coldic3](https://github.com/coldic3))
- [#15188](https://github.com/Sylius/Sylius/issues/15188) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15190](https://github.com/Sylius/Sylius/issues/15190) Update vimeo/psalm requirement from 5.13.* to 5.14.* ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#15174](https://github.com/Sylius/Sylius/issues/15174) Update sonata-project/block-bundle requirement from ^4.2 to ^5.0 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#15209](https://github.com/Sylius/Sylius/issues/15209) [Maintenance] Trigger deprecations in OrderPaymentProcessor ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15208](https://github.com/Sylius/Sylius/issues/15208) [Maintenance] Trigger deprecations in taxes applicators ([@GSadee](https://github.com/GSadee))
- [#15221](https://github.com/Sylius/Sylius/issues/15221) Add explicit mapping between product and reviews, and between product and attributes ([@GSadee](https://github.com/GSadee))
- [#15220](https://github.com/Sylius/Sylius/issues/15220) [Taxonomy][Form] Taxon slug generator including parent slug also in update mode ([@nicolalazzaro](https://github.com/nicolalazzaro), [@NoResponseMate](https://github.com/NoResponseMate))
- [#15235](https://github.com/Sylius/Sylius/issues/15235) [Maintenance] Note deprecation in SelectAttributeChoicesCollectionType ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15244](https://github.com/Sylius/Sylius/issues/15244) Refresh README.md ([@kulczy](https://github.com/kulczy))
- [#15056](https://github.com/Sylius/Sylius/issues/15056) Improve registration workflow ([@fabianaromagnoli](https://github.com/fabianaromagnoli), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15254](https://github.com/Sylius/Sylius/issues/15254) Deprecate unused ProductOptionChoiceType ([@TheMilek](https://github.com/TheMilek))
- [#15259](https://github.com/Sylius/Sylius/issues/15259) [API][Admin] Taxons management ([@GSadee](https://github.com/GSadee))
- [#15292](https://github.com/Sylius/Sylius/issues/15292) Provide autoconfiguration with attributes for ApiBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15297](https://github.com/Sylius/Sylius/issues/15297) Provide autoconfiguration with attributes for PaymentBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15301](https://github.com/Sylius/Sylius/issues/15301) Provide autoconfiguration with attributes for PayumBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15293](https://github.com/Sylius/Sylius/issues/15293) Provide autoconfiguration with attributes for CoreBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15295](https://github.com/Sylius/Sylius/issues/15295) Provide autoconfiguration with attributes for LocaleBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15294](https://github.com/Sylius/Sylius/issues/15294) Provide autoconfiguration with attributes for CurrencyBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15296](https://github.com/Sylius/Sylius/issues/15296) Improve autoconfiguration with attributes for OrderBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15298](https://github.com/Sylius/Sylius/issues/15298) Improve autoconfiguration with attributes for ProductBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15304](https://github.com/Sylius/Sylius/issues/15304) Provide autoconfiguration with attributes for TaxationBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15303](https://github.com/Sylius/Sylius/issues/15303) Provide autoconfiguration with attributes for ShippingBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15302](https://github.com/Sylius/Sylius/issues/15302) Provide autoconfiguration with attributes for PromotionBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15299](https://github.com/Sylius/Sylius/issues/15299) Provide autoconfiguration with attributes for AttributeBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15300](https://github.com/Sylius/Sylius/issues/15300) Provide autoconfiguration with attributes for ChannelBundle ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15305](https://github.com/Sylius/Sylius/issues/15305) Add missing admin:taxon:update group to TaxonTranslation's locale field ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15307](https://github.com/Sylius/Sylius/issues/15307) Add a deprecation for the sylius_admin_ajax_taxon_move route ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15281](https://github.com/Sylius/Sylius/issues/15281) Only show "View More" button when there are accepted reviews ([@stefandoorn](https://github.com/stefandoorn), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15278](https://github.com/Sylius/Sylius/issues/15278) Deprecate ContainsProductRuleUpdater and TotalOfItemsFromTaxonRuleUpdater ([@TheMilek](https://github.com/TheMilek))
- [#15309](https://github.com/Sylius/Sylius/issues/15309) Update the banner in the README.md ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15317](https://github.com/Sylius/Sylius/issues/15317) [doc] plugin naming - new plugin structure ([@oallain](https://github.com/oallain))
- [#15322](https://github.com/Sylius/Sylius/issues/15322) Add optional message to API cannot be removed exceptions ([@Wojdylak](https://github.com/Wojdylak))
- [#15323](https://github.com/Sylius/Sylius/issues/15323) [Maintenance] Change `trigger_error` to `trigger_deprecation` ([@Rafikooo](https://github.com/Rafikooo))
- [#15324](https://github.com/Sylius/Sylius/issues/15324) Prevent from removing taxon that is in use by a promotion rule ([@TheMilek](https://github.com/TheMilek))
- [#15315](https://github.com/Sylius/Sylius/issues/15315) Provide the State Machine abstraction ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15335](https://github.com/Sylius/Sylius/issues/15335) Minor typo fix in deprecation message in ZoneChoiceType ([@GSadee](https://github.com/GSadee))
- [#15333](https://github.com/Sylius/Sylius/issues/15333) [CoreBundle] Add missed deprecation block ([@Rafikooo](https://github.com/Rafikooo))
- [#15346](https://github.com/Sylius/Sylius/issues/15346) [Maintenance] Deprecate `OrderItemsSubtotalCalculatorInterface` ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15351](https://github.com/Sylius/Sylius/issues/15351) [AdminBundle] Corrected deprecation messages ([@Rafikooo](https://github.com/Rafikooo))
- [#15338](https://github.com/Sylius/Sylius/issues/15338) [CoreBundle] Move the PaymentFixture class in a proper namespace and deprecate other code ([@Rafikooo](https://github.com/Rafikooo))
- [#15288](https://github.com/Sylius/Sylius/issues/15288) [Api][Admin] Product Attributes Management ([@NoResponseMate](https://github.com/NoResponseMate), [@GSadee](https://github.com/GSadee))
- [#15366](https://github.com/Sylius/Sylius/issues/15366) [Api][Attribute] Add types enum to product attribute schema ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15275](https://github.com/Sylius/Sylius/issues/15275) Optimize matching zones to a given address ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15373](https://github.com/Sylius/Sylius/issues/15373) [Api] Mark bulk delete scenarios as @no-api ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15362](https://github.com/Sylius/Sylius/issues/15362) Add OrderShipping Symfony Workflow configuration ([@TheMilek](https://github.com/TheMilek))
- [#15376](https://github.com/Sylius/Sylius/issues/15376) Component core deprecate order interface methods ([@Wojdylak](https://github.com/Wojdylak))
- [#15262](https://github.com/Sylius/Sylius/issues/15262) [Maintenance] Deprecate using `parentId` in TaxonSlugController ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15380](https://github.com/Sylius/Sylius/issues/15380) [ShippingBundle] Change deprecated Calendar class ([@Rafikooo](https://github.com/Rafikooo))
- [#15342](https://github.com/Sylius/Sylius/issues/15342) Add newline to align with other public method ([@stefandoorn](https://github.com/stefandoorn))
- [#15383](https://github.com/Sylius/Sylius/issues/15383) Fixes to order shipping workflow after review ([@TheMilek](https://github.com/TheMilek))
- [#15395](https://github.com/Sylius/Sylius/issues/15395) Fix failing phpspec scenario on Symfony 6.3.5 and above ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15397](https://github.com/Sylius/Sylius/issues/15397) Fix failing phpspec scenario on Symfony 6.3.5 and above ([@Wojdylak](https://github.com/Wojdylak))
- [#15406](https://github.com/Sylius/Sylius/issues/15406) Add Symfony workflow configuration for Shipment ([@TheMilek](https://github.com/TheMilek))
- [#15407](https://github.com/Sylius/Sylius/issues/15407) [API][Maintenance] Remove usage of deprecated IriConverter ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15422](https://github.com/Sylius/Sylius/issues/15422) [PaymentBundle] Rename void to unknown in sylius_payment state machine ([@Wojdylak](https://github.com/Wojdylak))
- [#15415](https://github.com/Sylius/Sylius/issues/15415) Add order payment workflow ([@Wojdylak](https://github.com/Wojdylak))
- [#15425](https://github.com/Sylius/Sylius/issues/15425) [PostgreSQL] Sylius installation fix ([@Rafikooo](https://github.com/Rafikooo))
- [#15423](https://github.com/Sylius/Sylius/issues/15423) [PaymentBundle] Add new state to sylius payment state machine ([@Wojdylak](https://github.com/Wojdylak))
- [#15411](https://github.com/Sylius/Sylius/issues/15411) [Workflow] Add payment state machine config ([@NoResponseMate](https://github.com/NoResponseMate), [@Wojdylak](https://github.com/Wojdylak))
- [#15408](https://github.com/Sylius/Sylius/issues/15408) [Documentation]Updated links that were redirecting to 404 ([@benbd5](https://github.com/benbd5))
- [#15427](https://github.com/Sylius/Sylius/issues/15427) [PostgreSQL] Sylius installation fix amend ([@Rafikooo](https://github.com/Rafikooo))
- [#13902](https://github.com/Sylius/Sylius/issues/13902) [API] Reset password : add validations to produce 422 instead of 500 status code ([@Prometee](https://github.com/Prometee), [@Wojdylak](https://github.com/Wojdylak))
- [#15429](https://github.com/Sylius/Sylius/issues/15429) [Maintenance][Core] Update payment state machine ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15399](https://github.com/Sylius/Sylius/issues/15399) [API][Admin] Managing products ([@GSadee](https://github.com/GSadee))
- [#15460](https://github.com/Sylius/Sylius/issues/15460) [API][Admin] Managing product variants ([@GSadee](https://github.com/GSadee))
- [#15457](https://github.com/Sylius/Sylius/issues/15457) [API] Add Customer resources ([@Wojdylak](https://github.com/Wojdylak))
- [#15466](https://github.com/Sylius/Sylius/issues/15466) Add symfony workflow configuration for order ([@TheMilek](https://github.com/TheMilek))
- [#15452](https://github.com/Sylius/Sylius/issues/15452) [API] Cover editing and deleting channels ([@TheMilek](https://github.com/TheMilek), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15501](https://github.com/Sylius/Sylius/issues/15501) [API] Automatically add a default translation to translatables ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15508](https://github.com/Sylius/Sylius/issues/15508) [ApiBundle] Validate locale field on translation object ([@Wojdylak](https://github.com/Wojdylak))
- [#15497](https://github.com/Sylius/Sylius/issues/15497) [UserBundle] Implement TTL validation for password reset tokens ([@Wojdylak](https://github.com/Wojdylak))
- [#15488](https://github.com/Sylius/Sylius/issues/15488) Making the verification and password reset token unqiue ([@mamazu](https://github.com/mamazu))
- [#15485](https://github.com/Sylius/Sylius/issues/15485) [FIX] Not using `payum/stripe` or `payum/paypal-express-checkout-nvp` ([@Prometee](https://github.com/Prometee))
- [#15480](https://github.com/Sylius/Sylius/issues/15480) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15517](https://github.com/Sylius/Sylius/issues/15517) [API] Disallow removing the translation in default locale ([@GSadee](https://github.com/GSadee))
- [#15535](https://github.com/Sylius/Sylius/issues/15535) [ApiBundle] Unification of locale in translations ([@Wojdylak](https://github.com/Wojdylak))
- [#15504](https://github.com/Sylius/Sylius/issues/15504) [API][Admin] Managing taxon images ([@GSadee](https://github.com/GSadee))
- [#15540](https://github.com/Sylius/Sylius/issues/15540) Add note to UPGRADE file about introducing TaxonImageRepository ([@GSadee](https://github.com/GSadee))
- [#15546](https://github.com/Sylius/Sylius/issues/15546) [API][Admin] Revert changing taxon image file ([@GSadee](https://github.com/GSadee))
- [#15542](https://github.com/Sylius/Sylius/issues/15542) Update README.md ([@adrian-olebinski](https://github.com/adrian-olebinski))
- [#15524](https://github.com/Sylius/Sylius/issues/15524) [ApiBundle] Added remaining APIs for the Promotion resource. ([@Wojdylak](https://github.com/Wojdylak))
- [#15530](https://github.com/Sylius/Sylius/issues/15530) [API] Cover payment method management ([@TheMilek](https://github.com/TheMilek))
- [#15532](https://github.com/Sylius/Sylius/issues/15532) [API] Modifying placed order billing & shipping addresses ([@Rafikooo](https://github.com/Rafikooo))
- [#15552](https://github.com/Sylius/Sylius/issues/15552) Cover "Browsing order" scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15518](https://github.com/Sylius/Sylius/issues/15518) Prevent division by zero ([@cbastienbaron](https://github.com/cbastienbaron))
- [#15525](https://github.com/Sylius/Sylius/issues/15525) [Maintenance] Add more separation rules to arkitect ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15472](https://github.com/Sylius/Sylius/issues/15472) [API][Addressing] Enhance Country code validation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15551](https://github.com/Sylius/Sylius/issues/15551) Resolve actions and rules configuration validation ([@Wojdylak](https://github.com/Wojdylak))
- [#15509](https://github.com/Sylius/Sylius/issues/15509) [API][Admin] Managing product images ([@GSadee](https://github.com/GSadee))
- [#15576](https://github.com/Sylius/Sylius/issues/15576) Resolve psalm issues ([@Wojdylak](https://github.com/Wojdylak))
- [#15566](https://github.com/Sylius/Sylius/issues/15566) Cover 'order filtration' scenarios in API ([@TheMilek](https://github.com/TheMilek))
- [#15579](https://github.com/Sylius/Sylius/issues/15579) [Behat] Unify the Currency Handling in Behat Scenarios ([@Rafikooo](https://github.com/Rafikooo))
- [#15568](https://github.com/Sylius/Sylius/issues/15568) [ApiBundle] Update validation message for command argument types. ([@Wojdylak](https://github.com/Wojdylak))
- [#15583](https://github.com/Sylius/Sylius/issues/15583) [Api][Test] Update promotion test response check ([@Wojdylak](https://github.com/Wojdylak))
- [#15539](https://github.com/Sylius/Sylius/issues/15539) [API][Admin] Promotion coupons management(CRUD) ([@NoResponseMate](https://github.com/NoResponseMate), [@Wojdylak](https://github.com/Wojdylak))
- [#15516](https://github.com/Sylius/Sylius/issues/15516) [Maintenance][Behat] Add suite isolation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15595](https://github.com/Sylius/Sylius/issues/15595) Remove redundant denormalization check ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15558](https://github.com/Sylius/Sylius/issues/15558) [ECS] Add Code Checking In the Tests Directory and Implement Fixes For the New Code ([@Rafikooo](https://github.com/Rafikooo))
- [#15604](https://github.com/Sylius/Sylius/issues/15604) [Composer] Fix Symfony dependencies after upmerge ([@GSadee](https://github.com/GSadee))
- [#15553](https://github.com/Sylius/Sylius/issues/15553) Cover "Order details" scenarios in API ([@jakubtobiasz](https://github.com/jakubtobiasz), [@Wojdylak](https://github.com/Wojdylak))
- [#15605](https://github.com/Sylius/Sylius/issues/15605) [Workflow] Add catalog promotion state machine config ([@Wojdylak](https://github.com/Wojdylak))
- [#15601](https://github.com/Sylius/Sylius/issues/15601) [PHPStan] Baseline File Regeneration ([@Rafikooo](https://github.com/Rafikooo))
- [#15385](https://github.com/Sylius/Sylius/issues/15385) [Maintenance] Add more deprecations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15561](https://github.com/Sylius/Sylius/issues/15561) [API]Cover generate promotion coupons ([@Wojdylak](https://github.com/Wojdylak))
- [#15549](https://github.com/Sylius/Sylius/issues/15549) Validate payment method's gateway configuration ([@TheMilek](https://github.com/TheMilek))
- [#15581](https://github.com/Sylius/Sylius/issues/15581) [API] Resolve update of translations ([@Wojdylak](https://github.com/Wojdylak))
- [#15611](https://github.com/Sylius/Sylius/issues/15611) Validate Paypal express checkout sandbox field type ([@TheMilek](https://github.com/TheMilek))
- [#15610](https://github.com/Sylius/Sylius/issues/15610) `JavaScriptTestHelper`: Interval Increase  ([@Rafikooo](https://github.com/Rafikooo))
- [#15614](https://github.com/Sylius/Sylius/issues/15614) [Admin][UI] Fix csrf error breaking admin form ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15609](https://github.com/Sylius/Sylius/issues/15609) [Maintenance][API] Marking more inapplicable scenarios with no-api ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15620](https://github.com/Sylius/Sylius/issues/15620) Fix CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15615](https://github.com/Sylius/Sylius/issues/15615) Use serialized name when displaying an error about a wrong request field type ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15616](https://github.com/Sylius/Sylius/issues/15616) [API] Finish covering taxation scenarios ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15623](https://github.com/Sylius/Sylius/issues/15623) [API][Admin] Cover inventory ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15435](https://github.com/Sylius/Sylius/issues/15435) [Checkout] Prevent extra fields when login in on addressing page ([@Jibbarth](https://github.com/Jibbarth))
- [#14286](https://github.com/Sylius/Sylius/issues/14286) Prevent eager loading hundreds of countries ([@kayue](https://github.com/kayue))
- [#15627](https://github.com/Sylius/Sylius/issues/15627) Add an endpoint exposing customer's statistics ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15635](https://github.com/Sylius/Sylius/issues/15635) [API][Behat] covering tests for managing promotions ([@Wojdylak](https://github.com/Wojdylak))
- [#15636](https://github.com/Sylius/Sylius/issues/15636) [ECS] Ordered Types Fixer ([@Rafikooo](https://github.com/Rafikooo))
- [#15642](https://github.com/Sylius/Sylius/issues/15642) [Admin] Add official support submenu in admin panel ([@GSadee](https://github.com/GSadee))
- [#15628](https://github.com/Sylius/Sylius/issues/15628) [PromotionBundle] Update validation process of promotion actions/rules ([@Wojdylak](https://github.com/Wojdylak))
- [#15646](https://github.com/Sylius/Sylius/issues/15646) [API][Admin] Allow using float for amount in tax rates ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15630](https://github.com/Sylius/Sylius/issues/15630) Finish covering managing product-related resources ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15650](https://github.com/Sylius/Sylius/issues/15650) Update the example response of the Customer's statistics endpoint ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15658](https://github.com/Sylius/Sylius/issues/15658) Improve error handling while sending malformed amount value in the tax rate api resource update operation ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15640](https://github.com/Sylius/Sylius/issues/15640) [PromotionBundle] Deprecate PromotionCouponGeneratorInstructionInterface ([@Wojdylak](https://github.com/Wojdylak))
- [#15655](https://github.com/Sylius/Sylius/issues/15655) [Unit] `OrderPlacerTrait` Refactor ([@Rafikooo](https://github.com/Rafikooo))
- [#15637](https://github.com/Sylius/Sylius/issues/15637) [Behat] Implementation Improvements of the `ResponseCheckerInterface` ([@Rafikooo](https://github.com/Rafikooo))
- [#15662](https://github.com/Sylius/Sylius/issues/15662) Add running "Refactor" workflow daily ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15656](https://github.com/Sylius/Sylius/issues/15656) [AUTO] Updated translations from Crowdin (1.12) ([@SyliusBot](https://github.com/SyliusBot))
- [#15652](https://github.com/Sylius/Sylius/issues/15652) [UI] Improved Statistics Scenarios ([@Rafikooo](https://github.com/Rafikooo))
- [#15663](https://github.com/Sylius/Sylius/issues/15663) [ApiBundle][Address] Add address log entries operation ([@Wojdylak](https://github.com/Wojdylak))
- [#15632](https://github.com/Sylius/Sylius/issues/15632) Cover shipping method management ([@TheMilek](https://github.com/TheMilek))
- [#15639](https://github.com/Sylius/Sylius/issues/15639) [API][Admin] Finish covering product scenarios ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15660](https://github.com/Sylius/Sylius/issues/15660) [API] Finish covering managing orders ([@TheMilek](https://github.com/TheMilek))
- [#15657](https://github.com/Sylius/Sylius/issues/15657) [AUTO] Updated translations from Crowdin (1.13) ([@SyliusBot](https://github.com/SyliusBot))
- [#15617](https://github.com/Sylius/Sylius/issues/15617) Switch JS session Behat driver to the Symfony Panther ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15672](https://github.com/Sylius/Sylius/issues/15672) Typo cart-flow.rst ([@zairigimad](https://github.com/zairigimad))
- [#15664](https://github.com/Sylius/Sylius/issues/15664) Move validation groups parameters to appropriate bundle configs ([@TheMilek](https://github.com/TheMilek))
- [#13777](https://github.com/Sylius/Sylius/issues/13777) [Locale] Change language negotiation to RFC 4647 based ([@gseric](https://github.com/gseric))
- [#15687](https://github.com/Sylius/Sylius/issues/15687) Fix Typo fixtures.rst ([@zairigimad](https://github.com/zairigimad))
- [#15690](https://github.com/Sylius/Sylius/issues/15690) [Behat] Update test steps to use dynamic date ([@Wojdylak](https://github.com/Wojdylak))
- [#15695](https://github.com/Sylius/Sylius/issues/15695) [TestApi] Add new way of assert violations ([@Wojdylak](https://github.com/Wojdylak))
- [#15698](https://github.com/Sylius/Sylius/issues/15698) New year 2024! 🥳 ([@TheMilek](https://github.com/TheMilek))
- [#15705](https://github.com/Sylius/Sylius/issues/15705) [ApiBundle][ProductVariant] Unification of channelCode in channelPricing ([@Wojdylak](https://github.com/Wojdylak))
- [#15697](https://github.com/Sylius/Sylius/issues/15697) [Maintenance] Remove obsolete extended type method from form extensions ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15718](https://github.com/Sylius/Sylius/issues/15718) [Documentation] Extend the maintenance date of 1.12 and update future releases ([@GSadee](https://github.com/GSadee))
- [#15693](https://github.com/Sylius/Sylius/issues/15693) Allow to reset admin user password via CLI ([@Wojdylak](https://github.com/Wojdylak))
- [#15724](https://github.com/Sylius/Sylius/issues/15724) [API] Add validation of option values for the product variant ([@GSadee](https://github.com/GSadee))
- [#15728](https://github.com/Sylius/Sylius/issues/15728) [ApiBundle] Move LocaleIsUsedException into ApiBundle ([@Wojdylak](https://github.com/Wojdylak))
- [#15729](https://github.com/Sylius/Sylius/issues/15729) Extract StateMachine abstraction into its own package ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15712](https://github.com/Sylius/Sylius/issues/15712) Refactor resending order confirmation email and cover it in API ([@TheMilek](https://github.com/TheMilek))
- [#15707](https://github.com/Sylius/Sylius/issues/15707) [ApiBundle][Admin] Implement Shop User Removal and Password Change ([@Wojdylak](https://github.com/Wojdylak))
- [#15739](https://github.com/Sylius/Sylius/issues/15739) Fix ZoneRepository BC-Break ([@Rafikooo](https://github.com/Rafikooo))
- [#15598](https://github.com/Sylius/Sylius/issues/15598) [API] Statistics ([@Rafikooo](https://github.com/Rafikooo), [@TheMilek](https://github.com/TheMilek), [@NoResponseMate](https://github.com/NoResponseMate))
- [#15730](https://github.com/Sylius/Sylius/issues/15730) Organization of  ConsoleCommands/Messages ([@Wojdylak](https://github.com/Wojdylak))
- [#15715](https://github.com/Sylius/Sylius/issues/15715) Refactor resending shipment confirmation email and cover it in API ([@TheMilek](https://github.com/TheMilek))
- [#15751](https://github.com/Sylius/Sylius/issues/15751) Adjust some wording in UPGRADE guide ([@stefandoorn](https://github.com/stefandoorn))
- [#15754](https://github.com/Sylius/Sylius/issues/15754) Update the branch-aliases and inter-dependencies versions ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15740](https://github.com/Sylius/Sylius/issues/15740) Improve setup command ([@TheMilek](https://github.com/TheMilek))
- [#15761](https://github.com/Sylius/Sylius/issues/15761) [Admin] Add Sylius certification to menu ([@Wojdylak](https://github.com/Wojdylak))
- [#15755](https://github.com/Sylius/Sylius/issues/15755) [ApiBundle] Refactor commands' constructors ([@Wojdylak](https://github.com/Wojdylak))
- [#15749](https://github.com/Sylius/Sylius/issues/15749) [AUTO] Updated translations from Crowdin (1.12)
- [#15750](https://github.com/Sylius/Sylius/issues/15750) [AUTO] Updated translations from Crowdin (1.13)
- [#15768](https://github.com/Sylius/Sylius/issues/15768) [Fix] Invalid RemoveShopUserHandlerSpec namespace ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15746](https://github.com/Sylius/Sylius/issues/15746) Add builds checking whether the frontend can be built with all supported nodejs versions ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15771](https://github.com/Sylius/Sylius/issues/15771) Add default locale paramter to core ([@TheMilek](https://github.com/TheMilek))
- [#15775](https://github.com/Sylius/Sylius/issues/15775) [Maintenance][API] Normalize command missing fields' names ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15777](https://github.com/Sylius/Sylius/issues/15777) Bump the @sylius-ui/frontend version ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15765](https://github.com/Sylius/Sylius/issues/15765) [Maintenance][Statistics] Bit of an overhaul ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15708](https://github.com/Sylius/Sylius/issues/15708) [Promotion] Switch catalog promotion validation from custom solution to symfony ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15770](https://github.com/Sylius/Sylius/issues/15770) [API] Split read serialization group ([@TheMilek](https://github.com/TheMilek))
- [#15780](https://github.com/Sylius/Sylius/issues/15780) [API] Add BC layer for transition from :read to :index and :show serialization groups ([@TheMilek](https://github.com/TheMilek))
- [#15738](https://github.com/Sylius/Sylius/issues/15738) Use the new State Machine abstraction ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15796](https://github.com/Sylius/Sylius/issues/15796) Update codeowners ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15798](https://github.com/Sylius/Sylius/issues/15798) Move CartQuantityRuleChecker to CoreBundle ([@Wojdylak](https://github.com/Wojdylak))
- [#15802](https://github.com/Sylius/Sylius/issues/15802) [Maintenance] Cleanup ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15804](https://github.com/Sylius/Sylius/issues/15804) [StateMachineAbstraction] Add missing LICENSE and README files ([@GSadee](https://github.com/GSadee))
- [#15805](https://github.com/Sylius/Sylius/issues/15805) Update the license years for the last time ([@GSadee](https://github.com/GSadee))
- [#15806](https://github.com/Sylius/Sylius/issues/15806) [Documentation] Fix table of supported versions ([@GSadee](https://github.com/GSadee))
- [#15774](https://github.com/Sylius/Sylius/issues/15774) [Emails] Move email managers from Admin and Shop bundles to CoreBundle ([@GSadee](https://github.com/GSadee))
- [#15799](https://github.com/Sylius/Sylius/issues/15799) Move ItemTotalRuleChecker to CoreBundle ([@Wojdylak](https://github.com/Wojdylak))
- [#15735](https://github.com/Sylius/Sylius/issues/15735) Validate resending order confirmation email ([@TheMilek](https://github.com/TheMilek))
- [#15808](https://github.com/Sylius/Sylius/issues/15808) [Maintenance] Update .gitattributes ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15809](https://github.com/Sylius/Sylius/issues/15809) [Maintenance][Behat] Autoload calendar contexts into container ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15815](https://github.com/Sylius/Sylius/issues/15815) Update the branch-aliases ([@Wojdylak](https://github.com/Wojdylak))
- [#15757](https://github.com/Sylius/Sylius/issues/15757) Missing typehint on processDistributionWithMinimumPrice ([@cbastienbaron](https://github.com/cbastienbaron))
- [#15814](https://github.com/Sylius/Sylius/issues/15814) [AUTO] Updated translations from Crowdin (1.13)
