# CHANGELOG FOR `1.12.X`

## v1.12.19 (2024-07-17)

#### Details

- [#16544](https://github.com/Sylius/Sylius/issues/16544) [Docs] Update Taxon-Menu Page To Reflect Current Fixtures Configuration ([@Rafikooo](https://github.com/Rafikooo))
- [#16592](https://github.com/Sylius/Sylius/issues/16592) [API] Disable shop GET adjustment endpoint ([@mpysiak](https://github.com/mpysiak), [@GSadee](https://github.com/GSadee))

## v1.12.18 (2024-07-02)

#### Details

- [#16393](https://github.com/Sylius/Sylius/issues/16393) [User] Update the default tokens' length and the upper limit ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16392](https://github.com/Sylius/Sylius/issues/16392) [Core] Add order token length to configuration ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16410](https://github.com/Sylius/Sylius/issues/16410) [CS][DX] Refactor
- [#16431](https://github.com/Sylius/Sylius/issues/16431) [CI] Change the version of Chrome ([@GSadee](https://github.com/GSadee))
- [#16432](https://github.com/Sylius/Sylius/issues/16432) [CI] Change the version of Chrome from hardcoded one to stable ([@GSadee](https://github.com/GSadee))
- [#16439](https://github.com/Sylius/Sylius/issues/16439) Correct wrong command in the platform's cron example docs ([@TheMilek](https://github.com/TheMilek))
- [#16436](https://github.com/Sylius/Sylius/issues/16436) Sylius Plus modular installation and upgrading ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16500](https://github.com/Sylius/Sylius/issues/16500) [Documentation] Update Sylius 1.12 version on the release cycle page + update PR template ([@GSadee](https://github.com/GSadee))
- [#16477](https://github.com/Sylius/Sylius/issues/16477) Fix ProductTaxons' positioning logic ([@NoResponseMate](https://github.com/NoResponseMate))
- [#16380](https://github.com/Sylius/Sylius/issues/16380) Fix products grid for mobile ([@Yanick-K](https://github.com/Yanick-K))

## v1.12.17 (2024-06-07)

#### Details

- [#16290](https://github.com/Sylius/Sylius/issues/16290) Update bunnyshell.yaml, use network type volumes for mysql-data ([@mihaichitic](https://github.com/mihaichitic))
- [#16293](https://github.com/Sylius/Sylius/issues/16293) [Core] Add Sylius Plus info Command ([@mpysiak](https://github.com/mpysiak))
- [#16297](https://github.com/Sylius/Sylius/issues/16297) [Core] Change Show Plus Info command namespace ([@mpysiak](https://github.com/mpysiak))
- [#16279](https://github.com/Sylius/Sylius/issues/16279) [Docs] Sylius Cloud by Platform.sh ([@senghe](https://github.com/senghe), [@CoderMaggie](https://github.com/CoderMaggie))
- [#16323](https://github.com/Sylius/Sylius/issues/16323) Sylius Community Edition naming in docs ([@CoderMaggie](https://github.com/CoderMaggie))
- [#16324](https://github.com/Sylius/Sylius/issues/16324) Mark `tracked` and `shippingRequired` as not required fields ([@loevgaard](https://github.com/loevgaard))
- [#16329](https://github.com/Sylius/Sylius/issues/16329) [PHPStan] `Negated Boolean Expression Is Always True` Issue Fix ([@Rafikooo](https://github.com/Rafikooo))
- [#16307](https://github.com/Sylius/Sylius/issues/16307) Fix wrong calculation of available stock during completing a payment ([@GSadee](https://github.com/GSadee))
- [#16335](https://github.com/Sylius/Sylius/issues/16335) [Inventory] Adjust OrderInventoryOperator spec for exceptions changes ([@GSadee](https://github.com/GSadee))
- [#16344](https://github.com/Sylius/Sylius/issues/16344) [Inventory] Extract service for checking reserved stock availability for given order item ([@GSadee](https://github.com/GSadee))
- [#16342](https://github.com/Sylius/Sylius/issues/16342) Resolve createdByGuest on order fixtures ([@TheMilek](https://github.com/TheMilek))
- [#16321](https://github.com/Sylius/Sylius/issues/16321) Improve Order get endpoints ([@TheMilek](https://github.com/TheMilek))
- [#16352](https://github.com/Sylius/Sylius/issues/16352) [CS][DX] Refactor

## v1.12.16 (2024-05-10)

#### Details

- [#16190](https://github.com/Sylius/Sylius/issues/16190) Fix products grid ([@kulczy](https://github.com/kulczy))
- [#16196](https://github.com/Sylius/Sylius/issues/16196) Fix product review validation's notInRangeMessage ([@mpysiak](https://github.com/mpysiak))
- [#16241](https://github.com/Sylius/Sylius/issues/16241) [Security] Fixes for potential XSS in the Checkout, Address Book and Admin Panel ([@GSadee](https://github.com/GSadee))
- [#16232](https://github.com/Sylius/Sylius/issues/16232) [Maintenance] Update docker docs ([@Wojdylak](https://github.com/Wojdylak))

## v1.12.15 (2024-04-23)

#### Details

- [#16076](https://github.com/Sylius/Sylius/issues/16076) BUGFIX: [AdminBundle] #16031 wrap long text in notes section ([@crydotsnake](https://github.com/crydotsnake))
- [#16099](https://github.com/Sylius/Sylius/issues/16099) BUGFIX: [ShopBundle] #16068 wrap long text in product description ([@crydotsnake](https://github.com/crydotsnake))
- [#15510](https://github.com/Sylius/Sylius/issues/15510) [Documentation] Update docs/book/architecture/state_machine.rst ([@benbd5](https://github.com/benbd5), [@GSadee](https://github.com/GSadee))
- [#16125](https://github.com/Sylius/Sylius/issues/16125) [Documentation] Update release dates for 1.13 and 2.0 versions ([@GSadee](https://github.com/GSadee))
- [#16128](https://github.com/Sylius/Sylius/issues/16128) Add twig 3.9.0 conflict ([@mpysiak](https://github.com/mpysiak))
- [#16131](https://github.com/Sylius/Sylius/issues/16131) Revert conflict to twig/intl-extra ([@GSadee](https://github.com/GSadee))
- [#16134](https://github.com/Sylius/Sylius/issues/16134) Fix Sylius logo in READMEs of Bundles & Components ([@mpysiak](https://github.com/mpysiak))
- [#16158](https://github.com/Sylius/Sylius/issues/16158) Update dead link in drivers.rst ([@binhuq](https://github.com/binhuq))

## v1.12.14 (2024-03-25)

#### Details

- [#13777](https://github.com/Sylius/Sylius/issues/13777) [Locale] Change language negotiation to RFC 4647 based ([@gseric](https://github.com/gseric))
- [#15435](https://github.com/Sylius/Sylius/issues/15435) [Checkout] Prevent extra fields when login in on addressing page ([@Jibbarth](https://github.com/Jibbarth))
- [#15614](https://github.com/Sylius/Sylius/issues/15614) [Admin][UI] Fix csrf error breaking admin form ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15617](https://github.com/Sylius/Sylius/issues/15617) Switch JS session Behat driver to the Symfony Panther ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15620](https://github.com/Sylius/Sylius/issues/15620) Fix CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15642](https://github.com/Sylius/Sylius/issues/15642) [Admin] Add official support submenu in admin panel ([@GSadee](https://github.com/GSadee))
- [#15656](https://github.com/Sylius/Sylius/issues/15656) [AUTO] Updated translations from Crowdin (1.12) ([@SyliusBot](https://github.com/SyliusBot))
- [#15672](https://github.com/Sylius/Sylius/issues/15672) Typo cart-flow.rst ([@zairigimad](https://github.com/zairigimad))
- [#15687](https://github.com/Sylius/Sylius/issues/15687) Fix Typo fixtures.rst ([@zairigimad](https://github.com/zairigimad))
- [#15696](https://github.com/Sylius/Sylius/issues/15696) [Admin] Do not disable channel base currency when none set ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15698](https://github.com/Sylius/Sylius/issues/15698) New year 2024! 🥳 ([@TheMilek](https://github.com/TheMilek))
- [#15718](https://github.com/Sylius/Sylius/issues/15718) [Documentation] Extend the maintenance date of 1.12 and update future releases ([@GSadee](https://github.com/GSadee))
- [#15746](https://github.com/Sylius/Sylius/issues/15746) Add builds checking whether the frontend can be built with all supported nodejs versions ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15749](https://github.com/Sylius/Sylius/issues/15749) [AUTO] Updated translations from Crowdin (1.12) ()
- [#15761](https://github.com/Sylius/Sylius/issues/15761) [Admin] Add Sylius certification to menu ([@Wojdylak](https://github.com/Wojdylak))
- [#15796](https://github.com/Sylius/Sylius/issues/15796) Update codeowners ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15805](https://github.com/Sylius/Sylius/issues/15805) Update the license years for the last time ([@GSadee](https://github.com/GSadee))
- [#15806](https://github.com/Sylius/Sylius/issues/15806) [Documentation] Fix table of supported versions ([@GSadee](https://github.com/GSadee))
- [#15815](https://github.com/Sylius/Sylius/issues/15815) Update the branch-aliases ([@Wojdylak](https://github.com/Wojdylak))
- [#15824](https://github.com/Sylius/Sylius/issues/15824) Bump up symfony/flex version ([@GSadee](https://github.com/GSadee))
- [#15839](https://github.com/Sylius/Sylius/issues/15839) [FLYSYSTEM] Add directory visibility as public to local storage ([@Wojdylak](https://github.com/Wojdylak))
- [#15853](https://github.com/Sylius/Sylius/issues/15853) [ProductAttribute] Use value of options when use "Apply to all" ([@Jibbarth](https://github.com/Jibbarth))
- [#15859](https://github.com/Sylius/Sylius/issues/15859) FIX zoneMembers not unique ID ([@TheMilek](https://github.com/TheMilek))
- [#15900](https://github.com/Sylius/Sylius/issues/15900) BUGFIX: #12681 add missing required class  to provincecode select input ([@crydotsnake](https://github.com/crydotsnake))
- [#15909](https://github.com/Sylius/Sylius/issues/15909) BUGFIX: #15908 [AdminBundle] missing br tag for spacing for product media tab button ([@crydotsnake](https://github.com/crydotsnake))
- [#15939](https://github.com/Sylius/Sylius/issues/15939) BUGFIX: #15938 [AdminBundle] add spacing between choose file button and uploaded image in image_widget ([@crydotsnake](https://github.com/crydotsnake))
- [#15956](https://github.com/Sylius/Sylius/issues/15956) Bye Sylius Forum ☠️ ([@CoderMaggie](https://github.com/CoderMaggie))
- [#15957](https://github.com/Sylius/Sylius/issues/15957) Update README.md remove info about forum ([@damonsson](https://github.com/damonsson))
- [#15968](https://github.com/Sylius/Sylius/issues/15968) Remove info about forum from Admin panel and documentation ([@GSadee](https://github.com/GSadee))
- [#15971](https://github.com/Sylius/Sylius/issues/15971) [Docs] Refactor information about GUS ([@CoderMaggie](https://github.com/CoderMaggie))
- [#15972](https://github.com/Sylius/Sylius/issues/15972) [API] Prevent documenation failing when some endpoints are disabled ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15993](https://github.com/Sylius/Sylius/issues/15993) Bunnyshell improvements for 1.12 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16000](https://github.com/Sylius/Sylius/issues/16000) Fix the CODEOWNERS file ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16003](https://github.com/Sylius/Sylius/issues/16003) Fix the CODEOWNERS file ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#16011](https://github.com/Sylius/Sylius/issues/16011) [Maintenance] Add conflict with api-platform/core 2.7.17 ([@Wojdylak](https://github.com/Wojdylak))
- [#16017](https://github.com/Sylius/Sylius/issues/16017) [Maintenance] Fix ci ([@Wojdylak](https://github.com/Wojdylak))
- [#16026](https://github.com/Sylius/Sylius/issues/16026) [DOC] Update an access Denied link ([@lacpandore](https://github.com/lacpandore))
- [#16038](https://github.com/Sylius/Sylius/issues/16038) [Docs] Improve visibility of Sylius Plus ([@CoderMaggie](https://github.com/CoderMaggie))

## v1.12.13 (2023-12-05)

#### Details

- [#15548](https://github.com/Sylius/Sylius/issues/15548) [FIX] Default variant ([@Prometee](https://github.com/Prometee))
- [#15565](https://github.com/Sylius/Sylius/issues/15565) [DOC] Fix display link in authorize page ([@Jibbarth](https://github.com/Jibbarth))
- [#15571](https://github.com/Sylius/Sylius/issues/15571) Resolve psalm issues ([@Wojdylak](https://github.com/Wojdylak))
- [#15580](https://github.com/Sylius/Sylius/issues/15580) [DX] Improve ChannelCollector customizability ([@coldic3](https://github.com/coldic3))
- [#15582](https://github.com/Sylius/Sylius/issues/15582) Bye Psalm 👋🏼 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15585](https://github.com/Sylius/Sylius/issues/15585) [Fix] Do not show cart id after saving ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15587](https://github.com/Sylius/Sylius/issues/15587) [CI] Update Symfony versions in builds ([@GSadee](https://github.com/GSadee))
- [#15602](https://github.com/Sylius/Sylius/issues/15602) Add the sylius-labs/suite-tags-extension package ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15603](https://github.com/Sylius/Sylius/issues/15603) Fix build ([@jakubtobiasz](https://github.com/jakubtobiasz))

## v1.12.12 (2023-11-17)

#### Details

- [#15176](https://github.com/Sylius/Sylius/issues/15176) Add if_array check in ProductAttributeValueNormalizer.php ([@sdrenth](https://github.com/sdrenth), [@GSadee](https://github.com/GSadee))
- [#15273](https://github.com/Sylius/Sylius/issues/15273) [Issue 15271] - Get product variant by id ([@ulinskas](https://github.com/ulinskas), [@GSadee](https://github.com/GSadee))
- [#15287](https://github.com/Sylius/Sylius/issues/15287) Make the User class compatible with Symfony 6 to use encoder_name ([@delyriand](https://github.com/delyriand), [@GSadee](https://github.com/GSadee))
- [#15389](https://github.com/Sylius/Sylius/issues/15389) [FIX] Restrict NonChannelLocaleListener to the routes having _locale attribut ([@Prometee](https://github.com/Prometee))
- [#15402](https://github.com/Sylius/Sylius/issues/15402) Fix failing phpspec scenario on Symfony 6.3.5 and above ([@GSadee](https://github.com/GSadee))
- [#15416](https://github.com/Sylius/Sylius/issues/15416) [FIX][EMAIL] Use raw filter to avoid html encoded chars ([@Prometee](https://github.com/Prometee))
- [#15430](https://github.com/Sylius/Sylius/issues/15430) [Fix] Early return in CartCollector on stateless requests ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15437](https://github.com/Sylius/Sylius/issues/15437) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#15449](https://github.com/Sylius/Sylius/issues/15449) [Behat] Set a LocaleCode via the HTTP Accept-Language header ([@Rafikooo](https://github.com/Rafikooo))
- [#15487](https://github.com/Sylius/Sylius/issues/15487) Update taxation.rst ([@zairigimad](https://github.com/zairigimad), [@GSadee](https://github.com/GSadee))
- [#15507](https://github.com/Sylius/Sylius/issues/15507) Fix cart styles after form submission (data-route="sylius_shop_cart_c… ([@dsbe-ak](https://github.com/dsbe-ak))
- [#15512](https://github.com/Sylius/Sylius/issues/15512) [Maintenance] Fix request parameters accessing ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15513](https://github.com/Sylius/Sylius/issues/15513) Update BootstrapTheme install doc ([@Florian-Merle](https://github.com/Florian-Merle))
- [#15515](https://github.com/Sylius/Sylius/issues/15515) Update catalog_promotions.rst, fix links to BatchedApplyCatalogPromotionsOnVariantsCommandDispatcher and ApplyCatalogPromotionsOnVariants ([@vldmr-k](https://github.com/vldmr-k))
- [#15527](https://github.com/Sylius/Sylius/issues/15527) Disable check for security vulnerabilites step ([@Wojdylak](https://github.com/Wojdylak))
- [#15531](https://github.com/Sylius/Sylius/issues/15531) Add ignore-parse-errors to composer require checker ([@Wojdylak](https://github.com/Wojdylak))

## v1.12.11 (2023-09-18)

#### Details

- [#12519](https://github.com/Sylius/Sylius/issues/12519) [ProductBundle] Add validation for product meta keywords & description ([@DieterHolvoet](https://github.com/DieterHolvoet), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#12894](https://github.com/Sylius/Sylius/issues/12894) Make CheckoutResolver fail safe ([@vvasiloi](https://github.com/vvasiloi), [@NoResponseMate](https://github.com/NoResponseMate))
- [#13334](https://github.com/Sylius/Sylius/issues/13334) [Admin] Display flag properly based on locale code on product and catalog promotion details ([@adpeyre](https://github.com/adpeyre))
- [#13954](https://github.com/Sylius/Sylius/issues/13954) [Docker] Add custom docker composer file to gitignore ([@lchrusciel](https://github.com/lchrusciel))
- [#14806](https://github.com/Sylius/Sylius/issues/14806) [Admin][ProductOptions] Changed form ProductOptionChoiceType to Produ… ([@ulinskas](https://github.com/ulinskas))
- [#15218](https://github.com/Sylius/Sylius/issues/15218) Fix attributes creation while the default locale is not available in our store ([@TheMilek](https://github.com/TheMilek), [@NoResponseMate](https://github.com/NoResponseMate))
- [#15219](https://github.com/Sylius/Sylius/issues/15219) [Admin] Fix inconsistent routing ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15225](https://github.com/Sylius/Sylius/issues/15225) Fix updating product taxons positions ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15226](https://github.com/Sylius/Sylius/issues/15226) Update checkout.rst ([@zairigimad](https://github.com/zairigimad))
- [#15227](https://github.com/Sylius/Sylius/issues/15227) CartBlamerListener not found , replace with ShopCartBlamerListener ([@zairigimad](https://github.com/zairigimad))
- [#15228](https://github.com/Sylius/Sylius/issues/15228) [Docs] Update UPGRADE-1.12.md ([@UlrichHP](https://github.com/UlrichHP))
- [#15229](https://github.com/Sylius/Sylius/issues/15229) Update symfony/service-contracts in composer.json to update Sylius to 1.12.10 ([@UlrichHP](https://github.com/UlrichHP))
- [#15231](https://github.com/Sylius/Sylius/issues/15231) Prevent skipping choosing payment step once skipping payment step allowed, but no payment method is available ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15232](https://github.com/Sylius/Sylius/issues/15232) [Documentation][Admin] Add notes about accessing guest orders ([@GSadee](https://github.com/GSadee))
- [#15234](https://github.com/Sylius/Sylius/issues/15234) Fix Sylius versions in UPGRADE file ([@GSadee](https://github.com/GSadee))
- [#15245](https://github.com/Sylius/Sylius/issues/15245) Fix CI 2023-08-21 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15250](https://github.com/Sylius/Sylius/issues/15250) [Admin][Country] Add violation for adding provinces with duplicated codes or names ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15251](https://github.com/Sylius/Sylius/issues/15251) Fix error with being unable to add product review while being logged in using remember me ([@TheMilek](https://github.com/TheMilek))
- [#15252](https://github.com/Sylius/Sylius/issues/15252) [Admin][Taxon] Fix slug generation to work based on the parent field ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15255](https://github.com/Sylius/Sylius/issues/15255) [Admin][Product] Add language names to attribute values ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15263](https://github.com/Sylius/Sylius/issues/15263) Update default Rules of cart promotion ([@zairigimad](https://github.com/zairigimad))
- [#15268](https://github.com/Sylius/Sylius/issues/15268) Fix configuring amount for cart promotions item percentage discount actions ([@TheMilek](https://github.com/TheMilek), [@NoResponseMate](https://github.com/NoResponseMate))
- [#15272](https://github.com/Sylius/Sylius/issues/15272) Fix "jumping" taxons while moving up or down ([@igormukhingmailcom](https://github.com/igormukhingmailcom), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15277](https://github.com/Sylius/Sylius/issues/15277) Prevent removing product/taxon if it is already used in promotion rule ([@TheMilek](https://github.com/TheMilek), [@NoResponseMate](https://github.com/NoResponseMate))
- [#15280](https://github.com/Sylius/Sylius/issues/15280) Prevent throwing 500 while finalizing an order when at least one item has become tracked ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15290](https://github.com/Sylius/Sylius/issues/15290) Add a note about payment-related events ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15311](https://github.com/Sylius/Sylius/issues/15311) [API] fix prefix url on locale api path ([@oallain](https://github.com/oallain))

## v1.12.10 (2023-08-11)

#### Details

- [#12502](https://github.com/Sylius/Sylius/issues/12502) Recalculate order adjustments total after adjustment is added or remo… ([@kayue](https://github.com/kayue), [@SirDomin](https://github.com/SirDomin), [@TheMilek](https://github.com/TheMilek))
- [#15128](https://github.com/Sylius/Sylius/issues/15128) [Docs] Sylius Plus installation guide update ([@Rafikooo](https://github.com/Rafikooo))
- [#15148](https://github.com/Sylius/Sylius/issues/15148) Fix rendering admin creation form with errors ([@jakubtobiasz](https://github.com/jakubtobiasz), [@NoResponseMate](https://github.com/NoResponseMate))
- [#15162](https://github.com/Sylius/Sylius/issues/15162) Abstracts out ShopBasedCartContext::reset to an interface ([@palttamas](https://github.com/palttamas), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15178](https://github.com/Sylius/Sylius/issues/15178) [CS][DX] Refactor ()
- [#15184](https://github.com/Sylius/Sylius/issues/15184) Cover the order item units based tax calculation strategy with scenarios ([@GSadee](https://github.com/GSadee))
- [#15185](https://github.com/Sylius/Sylius/issues/15185) Avoid displaying taxon names inside of autocomplete in different locales than the store ([@TheMilek](https://github.com/TheMilek))
- [#15186](https://github.com/Sylius/Sylius/issues/15186) Add a conflict for doctrine/orm:2.15.4 ([@GSadee](https://github.com/GSadee))
- [#15187](https://github.com/Sylius/Sylius/issues/15187) [Order] Extract payments removal from OrderPaymentProcessor ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15191](https://github.com/Sylius/Sylius/issues/15191) Readme banner refresh ([@kulczy](https://github.com/kulczy))
- [#15195](https://github.com/Sylius/Sylius/issues/15195) Fix percentage discount's decimal rounding issue  ([@TheMilek](https://github.com/TheMilek))
- [#15197](https://github.com/Sylius/Sylius/issues/15197) Add a conflict for doctrine/orm 2.15.2 and higher ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15200](https://github.com/Sylius/Sylius/issues/15200) [Docs] Update order processing info ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15202](https://github.com/Sylius/Sylius/issues/15202) Update catalog_promotions.rst ([@zairigimad](https://github.com/zairigimad))
- [#15204](https://github.com/Sylius/Sylius/issues/15204) Resolve comments from #15195 ([@TheMilek](https://github.com/TheMilek))
- [#15205](https://github.com/Sylius/Sylius/issues/15205) [Maintenance] Remove depractions from OrderPaymentProcessor ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15207](https://github.com/Sylius/Sylius/issues/15207) [Behat] Fix minor mistake in names of scenarios for receiving discount according to promotions priorities ([@GSadee](https://github.com/GSadee))
- [#15213](https://github.com/Sylius/Sylius/issues/15213) Allow installing doctrine/orm 2.15.* ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15214](https://github.com/Sylius/Sylius/issues/15214) Fix configuring amount for catalog promotions fixed discount actions ([@TheMilek](https://github.com/TheMilek))
- [#15217](https://github.com/Sylius/Sylius/issues/15217) Fix cart styles after coupon form submission failure ([@shochdoerfer](https://github.com/shochdoerfer))

## v1.12.9 (2023-07-21)

#### Details

- [#12555](https://github.com/Sylius/Sylius/issues/12555) Fix misleading signing in the admin panel feature description ([@Mateuszry](https://github.com/Mateuszry))
- [#13824](https://github.com/Sylius/Sylius/issues/13824) Calculate tax with decimal precision and distribute proportionally across order items ([@vvasiloi](https://github.com/vvasiloi), [@GSadee](https://github.com/GSadee), [@TheMilek](https://github.com/TheMilek))
- [#15014](https://github.com/Sylius/Sylius/issues/15014) Change prority for custom ChannelContext ([@l-vo](https://github.com/l-vo))
- [#15037](https://github.com/Sylius/Sylius/issues/15037) [Docs] add image to entity via one-to-one association ([@vvasiloi](https://github.com/vvasiloi))
- [#15059](https://github.com/Sylius/Sylius/issues/15059) Upgrade PHPStan to level 5 ([@lruozzi9](https://github.com/lruozzi9))
- [#15064](https://github.com/Sylius/Sylius/issues/15064) [Orders][API] Validate endpoints ([@Rafikooo](https://github.com/Rafikooo))
- [#15065](https://github.com/Sylius/Sylius/issues/15065) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15069](https://github.com/Sylius/Sylius/issues/15069) [Psalm] CacheableSupportsMethodInterface in the deprecation list ([@Rafikooo](https://github.com/Rafikooo))
- [#15075](https://github.com/Sylius/Sylius/issues/15075) Add a conflict for doctrine/orm:2.15.2 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15076](https://github.com/Sylius/Sylius/issues/15076) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15079](https://github.com/Sylius/Sylius/issues/15079) Upgrade PHPStan to level 6 ([@lruozzi9](https://github.com/lruozzi9))
- [#15086](https://github.com/Sylius/Sylius/issues/15086) [Fixture] Improve LazyOption performance ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15088](https://github.com/Sylius/Sylius/issues/15088) [Promotion] Ignore coupon based promotions when when processing an order with no coupon  ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15101](https://github.com/Sylius/Sylius/issues/15101) [Maintenance] Launch of `Sylius Sp. z o.o.` copyright owner across project files ([@Rafikooo](https://github.com/Rafikooo))
- [#15110](https://github.com/Sylius/Sylius/issues/15110) Include children taxons while executing InForTaxonsScopeVariantChecker ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15116](https://github.com/Sylius/Sylius/issues/15116) Ignore ApiPlatform\Core\Api\IriConverterInterface DeprecatedClass Psalm error ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15118](https://github.com/Sylius/Sylius/issues/15118) Fix CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15130](https://github.com/Sylius/Sylius/issues/15130) Add conflict to symfony/validator 5.4.25, 6.2.12 and 6.3.1 ([@TheMilek](https://github.com/TheMilek))
- [#15137](https://github.com/Sylius/Sylius/issues/15137) [Maintenance] Improve ProportionalIntegerDistributor to keep original index ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15139](https://github.com/Sylius/Sylius/issues/15139) Fix "Show product in the shop page" button ([@mamazu](https://github.com/mamazu), [@jakubtobiasz](https://github.com/jakubtobiasz), [@GSadee](https://github.com/GSadee))
- [#15145](https://github.com/Sylius/Sylius/issues/15145) [Bunnyshell] Adjust the workflows for Fork PRs ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15147](https://github.com/Sylius/Sylius/issues/15147) [Behat] Minor improvements for accessing shop product page scenarios ([@GSadee](https://github.com/GSadee))
- [#15154](https://github.com/Sylius/Sylius/issues/15154) Add a conflict for "stof/doctrine-extensions-bundle": "1.8.0" ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15157](https://github.com/Sylius/Sylius/issues/15157) [Issue 15151] - Check manager before refreshing object ([@ulinskas](https://github.com/ulinskas))
- [#15161](https://github.com/Sylius/Sylius/issues/15161) [API] Product filter no longer crashes when using multiple taxons ([@palttamas](https://github.com/palttamas))
- [#15165](https://github.com/Sylius/Sylius/issues/15165) [API] Fix CommandDenormalizer ignoring custom property names ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15170](https://github.com/Sylius/Sylius/issues/15170) Prevent placing an order with a disabled shipping method ([@jakubtobiasz](https://github.com/jakubtobiasz))

## v1.12.8 (2023-05-25)

#### Details

- [#12344](https://github.com/Sylius/Sylius/issues/12344) [Product][Association] Fix attaching association with numeric code ([@hatem20](https://github.com/hatem20))
- [#13438](https://github.com/Sylius/Sylius/issues/13438) Replace http with https in static URLs ([@vvasiloi](https://github.com/vvasiloi))
- [#13864](https://github.com/Sylius/Sylius/issues/13864) fix message of the length constraint on email ([@james2001](https://github.com/james2001))
- [#14918](https://github.com/Sylius/Sylius/issues/14918) [Tasks] Improve Robo task ([@Rafikooo](https://github.com/Rafikooo))
- [#14920](https://github.com/Sylius/Sylius/issues/14920) [Admin][Shipment] fix english word and add shipment state in admin show shipment ([@BastienGoze](https://github.com/BastienGoze))
- [#14923](https://github.com/Sylius/Sylius/issues/14923) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#14925](https://github.com/Sylius/Sylius/issues/14925) [Migrations] Sylius-Standard installation fix ([@Rafikooo](https://github.com/Rafikooo))
- [#14926](https://github.com/Sylius/Sylius/issues/14926) [API] API Platform's default exception mappings ([@Rafikooo](https://github.com/Rafikooo))
- [#14929](https://github.com/Sylius/Sylius/issues/14929) Add conflict for doctrine/orm:2.14.2 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14932](https://github.com/Sylius/Sylius/issues/14932) [Admin][Promotion] Remove leftover rules after their assigned product gets deleted ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14935](https://github.com/Sylius/Sylius/issues/14935) [DX] Do not hardcode order state in order processors ([@Zales0123](https://github.com/Zales0123))
- [#14938](https://github.com/Sylius/Sylius/issues/14938) Revert "Add conflict for doctrine/orm:2.14.2" ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14940](https://github.com/Sylius/Sylius/issues/14940) default shipping methods order by position ([@ehibes](https://github.com/ehibes))
- [#14941](https://github.com/Sylius/Sylius/issues/14941) Fix build ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14953](https://github.com/Sylius/Sylius/issues/14953) Update BuildTestApp actions within workflows ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14956](https://github.com/Sylius/Sylius/issues/14956) [Shop] Add request matching to LocaleStrippingRouter ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14957](https://github.com/Sylius/Sylius/issues/14957) Ignore push event on upmerge ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14961](https://github.com/Sylius/Sylius/issues/14961) [API] Remove invalid enum value from ProductImage resource ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14962](https://github.com/Sylius/Sylius/issues/14962) [ApiBundle][Maintenance] Remove conflict with `doctrine/dbal:3.*` ([@Rafikooo](https://github.com/Rafikooo))
- [#14967](https://github.com/Sylius/Sylius/issues/14967) [GRID] Avoid double label translation on date filter ([@Prometee](https://github.com/Prometee))
- [#14971](https://github.com/Sylius/Sylius/issues/14971) Fix the press enter cause attribute deletion ([@zangra-dev](https://github.com/zangra-dev))
- [#14973](https://github.com/Sylius/Sylius/issues/14973) [UI][Swagger] Update link to API Introduction section ([@coldic3](https://github.com/coldic3))
- [#14974](https://github.com/Sylius/Sylius/issues/14974) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#14977](https://github.com/Sylius/Sylius/issues/14977) [Promotion] Fix price range filter to also consider configuration with only max ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14991](https://github.com/Sylius/Sylius/issues/14991) [Unstable][Maintenance] Fix DisablingApiTest on unstable symfony ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15006](https://github.com/Sylius/Sylius/issues/15006) Fix adding more than one product attribute at once ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15010](https://github.com/Sylius/Sylius/issues/15010) Lower the sylius.context.locale tag priority on RequestHeaderBasedLocalContext ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15018](https://github.com/Sylius/Sylius/issues/15018) Upgrade PHPStan to level 4 ([@lruozzi9](https://github.com/lruozzi9))
- [#15022](https://github.com/Sylius/Sylius/issues/15022) [Admin] Fix inability of sorting promotion coupons and catalog promotions ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15024](https://github.com/Sylius/Sylius/issues/15024) [Behat][Api] Make sure taxon iri is in right section ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15025](https://github.com/Sylius/Sylius/issues/15025) Added: Implementation of getShippingUnitTotal ([@NoResponseMate](https://github.com/NoResponseMate))
- [#15031](https://github.com/Sylius/Sylius/issues/15031) [Behat] Minor fixes in scenarios and contexts ([@coldic3](https://github.com/coldic3))
- [#15034](https://github.com/Sylius/Sylius/issues/15034) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions)[[@bot](https://github.com/bot)])
- [#15038](https://github.com/Sylius/Sylius/issues/15038) [Fix][Migrations] Wrong abstract class extended ([@Rafikooo](https://github.com/Rafikooo))
- [#15048](https://github.com/Sylius/Sylius/issues/15048) Add php-http/message-factory as a dev dependency to fix tests ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#15050](https://github.com/Sylius/Sylius/issues/15050) [Fix][Installer] Install Sylius 1.12 with PostgreSQL ([@Rafikooo](https://github.com/Rafikooo))
- [#15052](https://github.com/Sylius/Sylius/issues/15052) Revert "[CS][DX] Refactor" ([@jakubtobiasz](https://github.com/jakubtobiasz))

## v1.12.7 (2023-04-06)

#### Details

- [#14825](https://github.com/Sylius/Sylius/issues/14825) Update sylius-chart.js ([@xXNoceboXx](https://github.com/xXNoceboXx))
- [#14892](https://github.com/Sylius/Sylius/issues/14892) Improve testing unstable dependencies in CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14897](https://github.com/Sylius/Sylius/issues/14897) [Channel] Add "order by" to the "find by" methods ([@coldic3](https://github.com/coldic3))
- [#14902](https://github.com/Sylius/Sylius/issues/14902) [Order] Prevent paying with a disabled method ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14905](https://github.com/Sylius/Sylius/issues/14905) [Conflict] Add conflict with symfony/framework-bundle:6.2.8 ([@Rafikooo](https://github.com/Rafikooo))
- [#14910](https://github.com/Sylius/Sylius/issues/14910) Change the ApiPlatform Mapping prepend path ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14912](https://github.com/Sylius/Sylius/issues/14912) [Maintenance][CI] Allow manually dispatching unstable workflow ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14914](https://github.com/Sylius/Sylius/issues/14914) [Orders][API]  OrderItem removal validation ([@Rafikooo](https://github.com/Rafikooo))

## v1.12.6 (2023-03-28)

#### Details

- [#11121](https://github.com/Sylius/Sylius/issues/11121) Fixed: Calculator at TaxRate fixtures ([@igormukhingmailcom](https://github.com/igormukhingmailcom))
- [#13582](https://github.com/Sylius/Sylius/issues/13582) [Documentation] Fix overwriting templates path ([@goncziakos](https://github.com/goncziakos))
- [#14763](https://github.com/Sylius/Sylius/issues/14763) [Documentation][Cookbook] Add Vue Storefront installation guide ([@bitbager](https://github.com/bitbager))
- [#14826](https://github.com/Sylius/Sylius/issues/14826) Fix order by composite keys in OrderByIdentifierSqlWalker ([@coldic3](https://github.com/coldic3))
- [#14835](https://github.com/Sylius/Sylius/issues/14835) [Docs] Add warning to skip redundant routes on Plus installation ([@coldic3](https://github.com/coldic3))
- [#14838](https://github.com/Sylius/Sylius/issues/14838) [Fix] Take care of no session available in cart storage ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14839](https://github.com/Sylius/Sylius/issues/14839) [Documentation][Plus] Update version of Plus ([@GSadee](https://github.com/GSadee))
- [#14841](https://github.com/Sylius/Sylius/issues/14841) [CS][DX] Refactor ()
- [#14842](https://github.com/Sylius/Sylius/issues/14842) Remove ApiPlatform 2.6.x from CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14847](https://github.com/Sylius/Sylius/issues/14847) Remove merge conflict comment ([@SebLours](https://github.com/SebLours))
- [#14849](https://github.com/Sylius/Sylius/issues/14849) Fix a wrong function name in the AuthenticationSuccessListenerSpec ([@dawkaa](https://github.com/dawkaa))
- [#14850](https://github.com/Sylius/Sylius/issues/14850) [Order] Fix partially refunded payement preventing order to still be … ([@BorbagUskada](https://github.com/BorbagUskada))
- [#14853](https://github.com/Sylius/Sylius/issues/14853) [Docs] Add guide on how to add another implementation of UnitRefundInterface ([@coldic3](https://github.com/coldic3))
- [#14855](https://github.com/Sylius/Sylius/issues/14855) Add selecting only Behat scenarios with @javascript tag for JS-based CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14857](https://github.com/Sylius/Sylius/issues/14857) Fix LogicException in form validation ([@jurv](https://github.com/jurv))
- [#14859](https://github.com/Sylius/Sylius/issues/14859) [Order] Ensure correct item in `post_add` event ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14865](https://github.com/Sylius/Sylius/issues/14865) Fix calculating cart after trying to add more product than in stock ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14869](https://github.com/Sylius/Sylius/issues/14869) Typo in fixtures.rst ([@alexandre-castelain](https://github.com/alexandre-castelain))
- [#14870](https://github.com/Sylius/Sylius/issues/14870) There's no canton in Belgium, it's provinces ([@alexandre-castelain](https://github.com/alexandre-castelain))
- [#14880](https://github.com/Sylius/Sylius/issues/14880) [Locale][API] Additional locale code validation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14884](https://github.com/Sylius/Sylius/issues/14884) fix: `encore prod` retrocompat ([@maxperei](https://github.com/maxperei))
- [#14886](https://github.com/Sylius/Sylius/issues/14886) Add var/log content to artifacts on pipeline fail ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14887](https://github.com/Sylius/Sylius/issues/14887) [Admin][ProductVariant] Switched list rendering from base locale to current ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14891](https://github.com/Sylius/Sylius/issues/14891) Fix dependency security vulerability for enshrined/svg-sanitize package ()

## v1.12.5 (2023-02-21)

#### Details

- [#12752](https://github.com/Sylius/Sylius/issues/12752) [ADR] Strategy for resource internationalization in API ([@lchrusciel](https://github.com/lchrusciel))
- [#13044](https://github.com/Sylius/Sylius/issues/13044) [Maintenance] Added promotion form theme override in UPGRADE-1.9.md ([@SVillette](https://github.com/SVillette))
- [#13313](https://github.com/Sylius/Sylius/issues/13313) [Behat] add scenario for disabled admin ([@SirDomin](https://github.com/SirDomin))
- [#13913](https://github.com/Sylius/Sylius/issues/13913) [Architecture] Ensure HTTP errors are not dispatched in command handlers ([@lchrusciel](https://github.com/lchrusciel))
- [#14026](https://github.com/Sylius/Sylius/issues/14026) [Minor] Typo fixes and small code improvement ([@lchrusciel](https://github.com/lchrusciel), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14055](https://github.com/Sylius/Sylius/issues/14055) Fix channel color in fixture ([@iKsSs](https://github.com/iKsSs))
- [#14531](https://github.com/Sylius/Sylius/issues/14531) Update sylius_plus_installation.rst ([@oallain](https://github.com/oallain))
- [#14561](https://github.com/Sylius/Sylius/issues/14561) [DOCS] Sylius components attribute ([@arti0090](https://github.com/arti0090))
- [#14758](https://github.com/Sylius/Sylius/issues/14758) [API] Priorities in data transformers ([@Zales0123](https://github.com/Zales0123))
- [#14761](https://github.com/Sylius/Sylius/issues/14761) fix(layout): removed admin-layout__topbar height ([@UlrichHP](https://github.com/UlrichHP))
- [#14784](https://github.com/Sylius/Sylius/issues/14784) [Documentation] Update Sylius versions in release cycle ([@GSadee](https://github.com/GSadee))
- [#14785](https://github.com/Sylius/Sylius/issues/14785) Remove scheduled full build ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14789](https://github.com/Sylius/Sylius/issues/14789) Fix product attribute value normalizer ([@loic425](https://github.com/loic425))
- [#14792](https://github.com/Sylius/Sylius/issues/14792) Add adjusting shop regex section to disabling-localised-urls.rst ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14797](https://github.com/Sylius/Sylius/issues/14797) [API] Prepend configuration with API Platform mapping ([@GSadee](https://github.com/GSadee))
- [#14800](https://github.com/Sylius/Sylius/issues/14800) Fix being unable to pick up latest non-empty cart started in shop and continued in API ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14801](https://github.com/Sylius/Sylius/issues/14801) Add a missing orders prefix to routes in Admin Panel ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14802](https://github.com/Sylius/Sylius/issues/14802) Update versions in the "Submitting a Patch" doc ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14803](https://github.com/Sylius/Sylius/issues/14803) Logout Admin User after being disabled ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14804](https://github.com/Sylius/Sylius/issues/14804) Fix CI ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14805](https://github.com/Sylius/Sylius/issues/14805) Remove possibility to add Stripe as a payment method when package is missing ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14808](https://github.com/Sylius/Sylius/issues/14808) Fix url in links ([@jaceksieja](https://github.com/jaceksieja))
- [#14813](https://github.com/Sylius/Sylius/issues/14813) [Shop] Fix displaying discount on list view when original price is lower than current ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14818](https://github.com/Sylius/Sylius/issues/14818) Improve SEO ()
- [#14820](https://github.com/Sylius/Sylius/issues/14820) [CS][DX] Refactor ()
- [#14824](https://github.com/Sylius/Sylius/issues/14824) [Orders][API] Change cart item delete HTTP response code to 204 ([@Rafikooo](https://github.com/Rafikooo))

## v1.12.4 (2023-02-02)

#### Details

- [#12996](https://github.com/Sylius/Sylius/issues/12996) Remove sylius.model.shop_billing_data.class ([@vvasiloi](https://github.com/vvasiloi))
- [#13448](https://github.com/Sylius/Sylius/issues/13448) Remove wrong trailing space in test attribute ([@mmenozzi](https://github.com/mmenozzi))
- [#13835](https://github.com/Sylius/Sylius/issues/13835) chore: Replace NBSP by Space in doc ([@sad270](https://github.com/sad270))
- [#14122](https://github.com/Sylius/Sylius/issues/14122) [AUTO] Updated translations from Crowdin (master) ([@SyliusBot](https://github.com/SyliusBot))
- [#14174](https://github.com/Sylius/Sylius/issues/14174) [Admin] Fix 500 error when showing cart in admin panel ([@lchrusciel](https://github.com/lchrusciel))
- [#14381](https://github.com/Sylius/Sylius/issues/14381) [Maintenance] Note behat changes due to Mailer usage ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14416](https://github.com/Sylius/Sylius/issues/14416) [Product] Fixed product attribute translations #11570 ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14556](https://github.com/Sylius/Sylius/issues/14556) Hide "View in your store" widget in case ShopBundle disabled ([@diimpp](https://github.com/diimpp))
- [#14562](https://github.com/Sylius/Sylius/issues/14562) Update embedding products snippet in documentation ([@qhayat](https://github.com/qhayat))
- [#14576](https://github.com/Sylius/Sylius/issues/14576) Fix notInRangeMessage usage for a few Range validations ([@diimpp](https://github.com/diimpp), [@GSadee](https://github.com/GSadee))
- [#14577](https://github.com/Sylius/Sylius/issues/14577) Product taxon position don't affect parent taxon - API ([@everwhatever](https://github.com/everwhatever))
- [#14667](https://github.com/Sylius/Sylius/issues/14667) [Maintenance][CI] Remove github actions deprecations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14716](https://github.com/Sylius/Sylius/issues/14716) [Messenger] Use parameters in the configuration ([@Rafikooo](https://github.com/Rafikooo))
- [#14717](https://github.com/Sylius/Sylius/issues/14717) [CS][DX] Refactor
- [#14719](https://github.com/Sylius/Sylius/issues/14719) [CS][DX] Refactor
- [#14721](https://github.com/Sylius/Sylius/issues/14721) Added forgotten import to docblock. ([@kkevindev](https://github.com/kkevindev))
- [#14722](https://github.com/Sylius/Sylius/issues/14722) [User] Allow configuring `lastLogin` tracking frequency ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14730](https://github.com/Sylius/Sylius/issues/14730) [UI][DX] Extract form collection event handlers to the separate module ([@coldic3](https://github.com/coldic3))
- [#14731](https://github.com/Sylius/Sylius/issues/14731) [Fix] Request stack with null request ([@Prometee](https://github.com/Prometee))
- [#14733](https://github.com/Sylius/Sylius/issues/14733) Update generating-invoice-after-payment.rst ([@cwa-cc](https://github.com/cwa-cc))
- [#14735](https://github.com/Sylius/Sylius/issues/14735) Refactor not to use RequestStack::getMasterRequest() ([@GSadee](https://github.com/GSadee))
- [#14736](https://github.com/Sylius/Sylius/issues/14736) Updated UPGRADE-1.11.md to add a BC Break on channel pricing ([@devantoine](https://github.com/devantoine))
- [#14739](https://github.com/Sylius/Sylius/issues/14739) [CS][DX] Refactor
- [#14740](https://github.com/Sylius/Sylius/issues/14740) [CS][DX] Refactor
- [#14745](https://github.com/Sylius/Sylius/issues/14745) Fix static analysis after upmerge ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14746](https://github.com/Sylius/Sylius/issues/14746) Optimize jeans_04.svg size ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14749](https://github.com/Sylius/Sylius/issues/14749) Port of Sylius 1.13 CI to Sylius 1.12 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14751](https://github.com/Sylius/Sylius/issues/14751) Fix applying catalog promotions when there is no applied promotions and price differ from original price ([@TheMilek](https://github.com/TheMilek))
- [#14752](https://github.com/Sylius/Sylius/issues/14752) Fix workflows file extensions after downmerge ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14753](https://github.com/Sylius/Sylius/issues/14753) Fix typo in notify-about-build-status workflow job ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14755](https://github.com/Sylius/Sylius/issues/14755) [Maintenance][ApiBundle] Move test app into `Tests` dir ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14762](https://github.com/Sylius/Sylius/issues/14762) Add missing interface to OrderIntegrityChecker ([@Zales0123](https://github.com/Zales0123))
- [#14767](https://github.com/Sylius/Sylius/issues/14767) [CS][DX] Refactor
- [#14768](https://github.com/Sylius/Sylius/issues/14768) [CS][DX] Refactor
- [#14770](https://github.com/Sylius/Sylius/issues/14770) Fix typo in notify-about-build-status workflow job ([@GSadee](https://github.com/GSadee))
- [#14772](https://github.com/Sylius/Sylius/issues/14772) [Maintenance][ApiBundle] Update test app config ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14773](https://github.com/Sylius/Sylius/issues/14773) [Maintenance][UserBundle] Fix UserLastLoginSubscriber arguments ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14779](https://github.com/Sylius/Sylius/issues/14779) [Admin] Change homepage path variable to use snake case ([@GSadee](https://github.com/GSadee))
- [#14780](https://github.com/Sylius/Sylius/issues/14780) [Product] Add missing LocaleContextInterface in ProductAttributeController after upmerge from 1.11 ([@GSadee](https://github.com/GSadee))
- [#14782](https://github.com/Sylius/Sylius/issues/14782) Fix the wrong DQL alias in OrderByIdentifierSqlWalker ([@coldic3](https://github.com/coldic3))
- [#14783](https://github.com/Sylius/Sylius/issues/14783) [Admin] Fix 500 when resending order confirmation email for a cart ([@NoResponseMate](https://github.com/NoResponseMate))

## v1.12.3 (2023-01-13)

#### Details

- [#14715](https://github.com/Sylius/Sylius/issues/14715) [Core] Fix default query hint config ([@coldic3](https://github.com/coldic3))

## v1.12.2 (2023-01-13)

#### Details

- [#12099](https://github.com/Sylius/Sylius/issues/12099) Make link buttons with confirmation modal work again ([@stefandoorn](https://github.com/stefandoorn))
- [#12712](https://github.com/Sylius/Sylius/issues/12712) Fix sprintf parameters order ([@Creeperface01](https://github.com/Creeperface01))
- [#13157](https://github.com/Sylius/Sylius/issues/13157) Add missing space to taxes <tr> ([@pavol-tuka](https://github.com/pavol-tuka))
- [#13207](https://github.com/Sylius/Sylius/issues/13207) Changing replacement interface as previous one does not exist ([@Roshyo](https://github.com/Roshyo))
- [#13689](https://github.com/Sylius/Sylius/issues/13689) Fix typo in sylius_order state machine callback ([@vvasiloi](https://github.com/vvasiloi), [@Rafikooo](https://github.com/Rafikooo), [@Zales0123](https://github.com/Zales0123))
- [#13820](https://github.com/Sylius/Sylius/issues/13820) [Doc] Add depth to theme configuration ([@Nek-](https://github.com/Nek-))
- [#14177](https://github.com/Sylius/Sylius/issues/14177) [Docs] Fix API docs for Shop User token response ([@loic425](https://github.com/loic425))
- [#14289](https://github.com/Sylius/Sylius/issues/14289) [Api] Change int to integer in ProductVariant and ShippingMethod documentation normalizers ([@EsamAl-Dabagh](https://github.com/EsamAl-Dabagh))
- [#14491](https://github.com/Sylius/Sylius/issues/14491) Upgrade PHPStan to level 3 ([@lruozzi9](https://github.com/lruozzi9))
- [#14525](https://github.com/Sylius/Sylius/issues/14525) Adding skipIf for migrations to allow future runs when they should apply ([@stefantalen](https://github.com/stefantalen))
- [#14575](https://github.com/Sylius/Sylius/issues/14575) [DX] Add EditorConfig for test API responses ([@coldic3](https://github.com/coldic3))
- [#14580](https://github.com/Sylius/Sylius/issues/14580) [Enchancement] Optimize memory usage by sylius:remove-expired-carts command ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14587](https://github.com/Sylius/Sylius/issues/14587) Add gitattributes on bundles ([@loic425](https://github.com/loic425))
- [#14594](https://github.com/Sylius/Sylius/issues/14594) Fix postgres builds ([@coldic3](https://github.com/coldic3))
- [#14605](https://github.com/Sylius/Sylius/issues/14605) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14606](https://github.com/Sylius/Sylius/issues/14606) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14608](https://github.com/Sylius/Sylius/issues/14608) [UI][Shop][Cart] Reset chosen options on refresh in firefox ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14619](https://github.com/Sylius/Sylius/issues/14619) Update catalog_promotions.rst ([@Xusifob](https://github.com/Xusifob))
- [#14625](https://github.com/Sylius/Sylius/issues/14625) [Fix][Shop] Conditional adding of logout listener ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14632](https://github.com/Sylius/Sylius/issues/14632) [Documentation] Extend the maintenance period of Sylius 1.11 by one month ([@GSadee](https://github.com/GSadee))
- [#14633](https://github.com/Sylius/Sylius/issues/14633) [Documentation] Remove Sylius 1.12 scope from the release cycle page ([@GSadee](https://github.com/GSadee))
- [#14634](https://github.com/Sylius/Sylius/issues/14634) [API] Fix ProductVariantNormalizer exception catching ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14641](https://github.com/Sylius/Sylius/issues/14641) Updated twig/intl-extra to allow v3 ([@UlrichHP](https://github.com/UlrichHP))
- [#14642](https://github.com/Sylius/Sylius/issues/14642) Fix invalid API errors normalization ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14643](https://github.com/Sylius/Sylius/issues/14643) [ProductAssociation] Fix empty product associations ([@coldic3](https://github.com/coldic3))
- [#14645](https://github.com/Sylius/Sylius/issues/14645) Move Upgrade API from 1.11.11 to 1.11.12 section to the top of file ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14646](https://github.com/Sylius/Sylius/issues/14646) Adjust FlattenException and HydraError normalizers to Symfony 5.4 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14650](https://github.com/Sylius/Sylius/issues/14650) Validate existence of coupon ([@bashilbers](https://github.com/bashilbers), [@everwhatever](https://github.com/everwhatever))
- [#14651](https://github.com/Sylius/Sylius/issues/14651) Remove unit from shipment ([@kayue](https://github.com/kayue), [@everwhatever](https://github.com/everwhatever))
- [#14657](https://github.com/Sylius/Sylius/issues/14657) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14659](https://github.com/Sylius/Sylius/issues/14659) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14661](https://github.com/Sylius/Sylius/issues/14661) [Maintenance][Psalm] Add LifecycleEventArgs to deprecated classes ([@Rafikooo](https://github.com/Rafikooo))
- [#14662](https://github.com/Sylius/Sylius/issues/14662) Improve loading taxons ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14669](https://github.com/Sylius/Sylius/issues/14669) Wrong Rounding of the prices in the percentage discount catalog promotions ([@maxmishyn](https://github.com/maxmishyn), [@everwhatever](https://github.com/everwhatever))
- [#14677](https://github.com/Sylius/Sylius/issues/14677) [Maintenance] Remove Doctrine's LifecycleEventArgs deprecations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14678](https://github.com/Sylius/Sylius/issues/14678) [UX] Fix cart button on small screens ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14682](https://github.com/Sylius/Sylius/issues/14682) It's 2023! 🎉 ([@coldic3](https://github.com/coldic3))
- [#14683](https://github.com/Sylius/Sylius/issues/14683) Extract authorized user assignment to separate method/ cp to 1.11 ([@everwhatever](https://github.com/everwhatever))
- [#14685](https://github.com/Sylius/Sylius/issues/14685) Default ORDER BY for all entities and their relationships ([@coldic3](https://github.com/coldic3))
- [#14689](https://github.com/Sylius/Sylius/issues/14689) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14691](https://github.com/Sylius/Sylius/issues/14691) [Fix] Symfony container reanimation after friendsofsymfony/rest-bundle: 3.5.0 release ([@Rafikooo](https://github.com/Rafikooo))
- [#14694](https://github.com/Sylius/Sylius/issues/14694) [Composer] Remove conflict with doctrine/annotations: ^2.0 ([@Rafikooo](https://github.com/Rafikooo))
- [#14697](https://github.com/Sylius/Sylius/issues/14697) Remove error suppression to fix unit tests ([@coldic3](https://github.com/coldic3))
- [#14700](https://github.com/Sylius/Sylius/issues/14700) Add a conflict for doctrine/migrations:3.5.3 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14701](https://github.com/Sylius/Sylius/issues/14701) [API] Fix IRI converter catching homepage ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14704](https://github.com/Sylius/Sylius/issues/14704) [Conflicts] Doctrine/annotations:^2.0 ([@Rafikooo](https://github.com/Rafikooo))
- [#14706](https://github.com/Sylius/Sylius/issues/14706) [Promotion][UI] Fix hardcoded "sylius_promotion" selector ([@coldic3](https://github.com/coldic3))
- [#14707](https://github.com/Sylius/Sylius/issues/14707) Add note to UPGRADE-1.12 file about default order by for all entities ([@GSadee](https://github.com/GSadee))

## v1.12.1 (2022-12-08)

#### Details

- [#12611](https://github.com/Sylius/Sylius/issues/12611) Change on from string to array, consistent with other definitions ([@stefandoorn](https://github.com/stefandoorn))
- [#13187](https://github.com/Sylius/Sylius/issues/13187) issue/12985-migration-in-corebundle ([@coldic3](https://github.com/coldic3))
- [#13202](https://github.com/Sylius/Sylius/issues/13202) [Core][Checkout] fixed #13201 ([@acornforth](https://github.com/acornforth), [@SirDomin](https://github.com/SirDomin))
- [#14036](https://github.com/Sylius/Sylius/issues/14036) [Docker] Allow overriding ports in docker-compose.yml ([@coldic3](https://github.com/coldic3))
- [#14435](https://github.com/Sylius/Sylius/issues/14435) Include 1.13 branch in the PR template ([@Zales0123](https://github.com/Zales0123))
- [#14474](https://github.com/Sylius/Sylius/issues/14474) :arrow_up: Upgrade gaufrette version (PHP 8+ compat) ([@Nek-](https://github.com/Nek-), [@coldic3](https://github.com/coldic3))
- [#14486](https://github.com/Sylius/Sylius/issues/14486) [Cart] Set the created_by_guest flag as false if the cart was created by a customer authenticated via access token ([@nicolalazzaro](https://github.com/nicolalazzaro))
- [#14488](https://github.com/Sylius/Sylius/issues/14488) [Maintenance][CI] Remove deprecations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14489](https://github.com/Sylius/Sylius/issues/14489) [Api] Sorting products by price should be per channel ([@j92](https://github.com/j92))
- [#14500](https://github.com/Sylius/Sylius/issues/14500) [Docs] Update inventory source resolving ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14501](https://github.com/Sylius/Sylius/issues/14501) [Maintenance] Removal of direct unneeded dependency on proxy manager LTS ([@lchrusciel](https://github.com/lchrusciel))
- [#14505](https://github.com/Sylius/Sylius/issues/14505) Fix password hasher version ([@loic425](https://github.com/loic425))
- [#14508](https://github.com/Sylius/Sylius/issues/14508) [Maintenance] Outdated Symfony 6 conflicts removed ([@Rafikooo](https://github.com/Rafikooo))
- [#14510](https://github.com/Sylius/Sylius/issues/14510) [maintenance] - Ignore more files that will not be used with installed sylius ([@Ferror](https://github.com/Ferror))
- [#14511](https://github.com/Sylius/Sylius/issues/14511) [maintenance] - Use symfony runtime component ([@Ferror](https://github.com/Ferror))
- [#14514](https://github.com/Sylius/Sylius/issues/14514) [Behat][API] Add missing channels suite to imports ([@GSadee](https://github.com/GSadee))
- [#14516](https://github.com/Sylius/Sylius/issues/14516) [Docs] Update release cycle with 1.12 and 1.13 info ([@Zales0123](https://github.com/Zales0123))
- [#14520](https://github.com/Sylius/Sylius/issues/14520) Refresh readme banner ([@kulczy](https://github.com/kulczy))
- [#14523](https://github.com/Sylius/Sylius/issues/14523) Product taxon position don't affect parent taxon ([@everwhatever](https://github.com/everwhatever))
- [#14526](https://github.com/Sylius/Sylius/issues/14526) [Maintenance] Exclude copied IRI converter in ECS config ([@coldic3](https://github.com/coldic3))
- [#14527](https://github.com/Sylius/Sylius/issues/14527) [GitHub Actions] Add 1.13 branch to "Refactor" workflow ([@coldic3](https://github.com/coldic3))
- [#14536](https://github.com/Sylius/Sylius/issues/14536) [Maintenance][Fixture] Allow using default values with optional array nodes ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14538](https://github.com/Sylius/Sylius/issues/14538) [Product] Fix product variant choice labels ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14543](https://github.com/Sylius/Sylius/issues/14543) [Maintenance] Fix type casting in migrations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14544](https://github.com/Sylius/Sylius/issues/14544) [Doc] Fix Supported versions table ([@oallain](https://github.com/oallain))
- [#14545](https://github.com/Sylius/Sylius/issues/14545) [Migrations] Remove usage of non existent AbstractMigration ([@GSadee](https://github.com/GSadee))
- [#14546](https://github.com/Sylius/Sylius/issues/14546) [Migrations] Use AbstractMigration from CoreBundle ([@coldic3](https://github.com/coldic3))
- [#14547](https://github.com/Sylius/Sylius/issues/14547) [Maintenance] Add Postgres 14 to test builds ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14548](https://github.com/Sylius/Sylius/issues/14548) Fix removing the root taxon, when the second one is Menu Taxon of the channel ([@TheMilek](https://github.com/TheMilek))
- [#14551](https://github.com/Sylius/Sylius/issues/14551) Precise symfony/framework-bundle conflict versions ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14554](https://github.com/Sylius/Sylius/issues/14554) Fix service definition at custom-payment-gateway ([@diimpp](https://github.com/diimpp))
- [#14563](https://github.com/Sylius/Sylius/issues/14563) Add repository option to product_image node ([@TheMilek](https://github.com/TheMilek))
- [#14567](https://github.com/Sylius/Sylius/issues/14567) [Core] Fix invalid catalog promotion repository service id ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14570](https://github.com/Sylius/Sylius/issues/14570) [CS][DX] Fix ECS refactoring ([@coldic3](https://github.com/coldic3))
- [#14573](https://github.com/Sylius/Sylius/issues/14573) [API] Fix ProductReview normalization context ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14574](https://github.com/Sylius/Sylius/issues/14574) [API] Fix missing address serialization for phone number and company name ([@andrehoffmann30](https://github.com/andrehoffmann30), [@coldic3](https://github.com/coldic3))
- [#14578](https://github.com/Sylius/Sylius/issues/14578) Require SyliusMailerBundle 1.8 for Swiftmailer + Sf 5.4 packages builds ([@Zales0123](https://github.com/Zales0123))
- [#14586](https://github.com/Sylius/Sylius/issues/14586) [DX] Unify default repo classes for resources ([@coldic3](https://github.com/coldic3))
- [#14595](https://github.com/Sylius/Sylius/issues/14595) [Fix] Filtering out disabled channel scenario ([@Rafikooo](https://github.com/Rafikooo))
- [#14596](https://github.com/Sylius/Sylius/issues/14596) [Orders] Cart not found for registered user ([@Rafikooo](https://github.com/Rafikooo))
- [#14600](https://github.com/Sylius/Sylius/issues/14600) [ProductAssociation] Show product associations within current channel only ([@coldic3](https://github.com/coldic3))
- [#14602](https://github.com/Sylius/Sylius/issues/14602) [GitHub Actions] Restrict "Refactor" workflow to Sylius/Sylius repo ([@coldic3](https://github.com/coldic3))
- [#14614](https://github.com/Sylius/Sylius/issues/14614) Run behat using dual session as javascript scenario ([@Rafikooo](https://github.com/Rafikooo))
- [#14616](https://github.com/Sylius/Sylius/issues/14616) [Psalm] Skip deprecated in Symfony 6.2 class and interface ([@Rafikooo](https://github.com/Rafikooo))
- [#14617](https://github.com/Sylius/Sylius/issues/14617) [maintenance] - remove docker pipelines ([@Ferror](https://github.com/Ferror))
- [#14618](https://github.com/Sylius/Sylius/issues/14618) Use MakerBundle instead of SensioGeneratorBundle ([@hmonglee](https://github.com/hmonglee))
- [#14621](https://github.com/Sylius/Sylius/issues/14621) [PHPUnit] Adjust contract tests after upmerge ([@coldic3](https://github.com/coldic3), [@Zales0123](https://github.com/Zales0123))

## v1.12.0 (2022-10-31)

#### Details

- [#14053](https://github.com/Sylius/Sylius/issues/14053) Upgrade phpstan to level 2 ([@lruozzi9](https://github.com/lruozzi9))
- [#14400](https://github.com/Sylius/Sylius/issues/14400) [Maintenance] `extra.symfony.require` configuration introduced ([@Rafikooo](https://github.com/Rafikooo))
- [#14402](https://github.com/Sylius/Sylius/issues/14402) [Api] fix order normalization groups ([@mtarld](https://github.com/mtarld))
- [#14454](https://github.com/Sylius/Sylius/issues/14454) [Behat] Move scenario from Plus ([@TheMilek](https://github.com/TheMilek))
- [#14461](https://github.com/Sylius/Sylius/issues/14461) Update documentation about migrating to Webpack ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14463](https://github.com/Sylius/Sylius/issues/14463) [maintenance] - Remove Staging configs ([@Ferror](https://github.com/Ferror))
- [#14465](https://github.com/Sylius/Sylius/issues/14465) [CI] Restrict APIP version in static checks ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14468](https://github.com/Sylius/Sylius/issues/14468) Lower hashing alogirthm memory cost in test ([@Zales0123](https://github.com/Zales0123))
- [#14471](https://github.com/Sylius/Sylius/issues/14471) [Api] fixed normalization/denormalization resources groups ([@mtarld](https://github.com/mtarld))
- [#14472](https://github.com/Sylius/Sylius/issues/14472) Bring back security.authentication_manager alias if needed ([@Zales0123](https://github.com/Zales0123))
- [#14473](https://github.com/Sylius/Sylius/issues/14473) Fixes in Order serialization after changes on 1.11 ([@Zales0123](https://github.com/Zales0123))
- [#14476](https://github.com/Sylius/Sylius/issues/14476) Delay 1.12 release for a few days ([@Zales0123](https://github.com/Zales0123))
- [#14477](https://github.com/Sylius/Sylius/issues/14477) [Docs] Add warning about restricting Symfony version before Sylius installation ([@coldic3](https://github.com/coldic3))
- [#14479](https://github.com/Sylius/Sylius/issues/14479) [Maintenance] Allow APIP 2.7.2 ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14481](https://github.com/Sylius/Sylius/issues/14481) Adding batching to the expired carts remover ([@mamazu](https://github.com/mamazu))
- [#14482](https://github.com/Sylius/Sylius/issues/14482) Adding batching to the expired carts remover v2 ([@mamazu](https://github.com/mamazu), [@lchrusciel](https://github.com/lchrusciel))
- [#14490](https://github.com/Sylius/Sylius/issues/14490) [Maintenance] Kernel cleanup ([@Rafikooo](https://github.com/Rafikooo))
- [#14496](https://github.com/Sylius/Sylius/issues/14496) [README] Switch Sylius naming from platform to framework ([@lchrusciel](https://github.com/lchrusciel))
- [#14498](https://github.com/Sylius/Sylius/issues/14498) Allow stable Resource (1.10), Grid (1.12) and Fixtures (1.8) ([@Zales0123](https://github.com/Zales0123))
- [#14499](https://github.com/Sylius/Sylius/issues/14499) Separate pipeline for non-JS tests on unstable Symfony version ([@Zales0123](https://github.com/Zales0123))

## v1.12.0-RC.1 (2022-10-19)

#### Details

- [#14188](https://github.com/Sylius/Sylius/issues/14188) [DOCS]  Disabling guest api checkout ([@arti0090](https://github.com/arti0090))
- [#14247](https://github.com/Sylius/Sylius/issues/14247) [DOCS] Add info about mailer in installation doc ([@arti0090](https://github.com/arti0090))
- [#14362](https://github.com/Sylius/Sylius/issues/14362) Using the new template namespace syntax in the doc ([@mamazu](https://github.com/mamazu))
- [#14382](https://github.com/Sylius/Sylius/issues/14382) [Maintenance] Out-of-date composer conflicts cleanup ([@Rafikooo](https://github.com/Rafikooo))
- [#14384](https://github.com/Sylius/Sylius/issues/14384) [API] Use tokenValue instead of id ([@Prometee](https://github.com/Prometee))
- [#14415](https://github.com/Sylius/Sylius/issues/14415) [Behat] Add calendar hook to suites using calendar ([@GSadee](https://github.com/GSadee))
- [#14421](https://github.com/Sylius/Sylius/issues/14421) [DOCS] Add info about supervisors ([@arti0090](https://github.com/arti0090))
- [#14426](https://github.com/Sylius/Sylius/issues/14426) [Docs][CatalogPromotions][Messenger] Failure transports ([@Rafikooo](https://github.com/Rafikooo))
- [#14430](https://github.com/Sylius/Sylius/issues/14430) [DX] Fix versions for triggered deprecations ([@coldic3](https://github.com/coldic3))
- [#14431](https://github.com/Sylius/Sylius/issues/14431) Fix reference to Admin bundle on ui bundle ([@loic425](https://github.com/loic425))
- [#14433](https://github.com/Sylius/Sylius/issues/14433) Fix - move RedirectPathExtension from Admin bundle to Ui bundle ([@loic425](https://github.com/loic425))
- [#14438](https://github.com/Sylius/Sylius/issues/14438) Coding style and configurations fixes and improvements after Symfony 6 support merge ([@Zales0123](https://github.com/Zales0123))
- [#14440](https://github.com/Sylius/Sylius/issues/14440) [Parameters] bin/console debug:container --env-vars command fixed ([@Rafikooo](https://github.com/Rafikooo))
- [#14442](https://github.com/Sylius/Sylius/issues/14442) [Hot-fix] Conflict with the newest AP that changes a Customer->User response ([@GSadee](https://github.com/GSadee))
- [#14443](https://github.com/Sylius/Sylius/issues/14443) [API][Behat] Add note about behat request changes ([@TheMilek](https://github.com/TheMilek))
- [#14444](https://github.com/Sylius/Sylius/issues/14444) Remove SymfonyMockerContainer fork ([@Zales0123](https://github.com/Zales0123))
- [#14445](https://github.com/Sylius/Sylius/issues/14445) [Hot-fix] Conflict with the SymfonyMockerContainer 1.0.6 due to incompatible version with Symfony 4.x ([@GSadee](https://github.com/GSadee))
- [#14458](https://github.com/Sylius/Sylius/issues/14458) Fix packages branch-aliases ([@Zales0123](https://github.com/Zales0123))
- [#14459](https://github.com/Sylius/Sylius/issues/14459) [Hot-fix] Do not fail scenario after 422 response page ([@Zales0123](https://github.com/Zales0123))
- [#14462](https://github.com/Sylius/Sylius/issues/14462) Open [CI] Tests for Symfony ~6.0.0 and static checks for APIP ~2.6.0 ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14464](https://github.com/Sylius/Sylius/issues/14464) Change all package versions to 1.12 ([@Zales0123](https://github.com/Zales0123))

## v1.12.0-BETA.1 (2022-10-11)

#### Details

- [#13969](https://github.com/Sylius/Sylius/issues/13969) Symfony 6 support ([@NoResponseMate](https://github.com/NoResponseMate), [@Zales0123](https://github.com/Zales0123), [@Rafikooo](https://github.com/Rafikooo), [@GSadee](https://github.com/GSadee), [@coldic3](https://github.com/coldic3))
- [#14144](https://github.com/Sylius/Sylius/issues/14144) [Documentation] Fix incorrect translation domain in implementation ([@anned20](https://github.com/anned20))
- [#14156](https://github.com/Sylius/Sylius/issues/14156) [DOCS] Cookbook of how to modify placed order ([@arti0090](https://github.com/arti0090))
- [#14197](https://github.com/Sylius/Sylius/issues/14197) [Docs] Describe Sylius architectural drivers ([@Zales0123](https://github.com/Zales0123))
- [#14246](https://github.com/Sylius/Sylius/issues/14246) [DOCS] Add note about min node version ([@arti0090](https://github.com/arti0090))
- [#14296](https://github.com/Sylius/Sylius/issues/14296) [Core] Create CustomerProvider ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#14337](https://github.com/Sylius/Sylius/issues/14337) [Maintenance] Mention Gaufrette filesystem adapter in the upgrade file ([@coldic3](https://github.com/coldic3))
- [#14338](https://github.com/Sylius/Sylius/issues/14338) Tax rates with dates ([@GSadee](https://github.com/GSadee), [@jakub](https://github.com/jakub)@[@Jakubs-MacBook-Pro](https://github.com/Jakubs-MacBook-Pro).[@local](https://github.com/local))
- [#14397](https://github.com/Sylius/Sylius/issues/14397) [Docs] Fix 1.12 release dates ([@Zales0123](https://github.com/Zales0123))
- [#14398](https://github.com/Sylius/Sylius/issues/14398) Allow ramsey/uuid ^4.0 to avoid PHP 8.1 warning ([@vasilvestre](https://github.com/vasilvestre))
- [#14406](https://github.com/Sylius/Sylius/issues/14406) [API][Behat] Add note about behat client changes ([@TheMilek](https://github.com/TheMilek))
- [#14407](https://github.com/Sylius/Sylius/issues/14407) [Symfony 6] Remove setting services for test as public ([@Zales0123](https://github.com/Zales0123))
- [#14410](https://github.com/Sylius/Sylius/issues/14410) [Documentation] Remove the tip about ShopApiPlugin from the architecture page ([@GSadee](https://github.com/GSadee))
- [#14414](https://github.com/Sylius/Sylius/issues/14414) [Github Actions] Make timeout for non-JS build longer ([@Zales0123](https://github.com/Zales0123))
- [#14420](https://github.com/Sylius/Sylius/issues/14420) [Hot-fix] Conflict with newest AP that changes a Customer->User response ([@Zales0123](https://github.com/Zales0123))
- [#14427](https://github.com/Sylius/Sylius/issues/14427) tax rates filter feature ([@everwhatever](https://github.com/everwhatever), [@GSadee](https://github.com/GSadee))

## v1.12.0-ALPHA.2 (2022-10-03)

#### Details

- [#13663](https://github.com/Sylius/Sylius/issues/13663) Admin update form action configurable ([@bigboss86](https://github.com/bigboss86))
- [#14243](https://github.com/Sylius/Sylius/issues/14243) Revert temporary build fix ([@TheMilek](https://github.com/TheMilek))
- [#14253](https://github.com/Sylius/Sylius/issues/14253) [Maintenance][Security] Update shop logout handling ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14302](https://github.com/Sylius/Sylius/issues/14302) [maintenance]Do not continue-on-error pipeline ([@Ferror](https://github.com/Ferror))
- [#14312](https://github.com/Sylius/Sylius/issues/14312) [maintenance]Unify very similar behat steps ([@Ferror](https://github.com/Ferror))
- [#14313](https://github.com/Sylius/Sylius/issues/14313) [docs]Mention to clone Sylius-Standard repository to start the project ([@Ferror](https://github.com/Ferror))
- [#14315](https://github.com/Sylius/Sylius/issues/14315) [Maintenance] Improve note in UPGRADE file about changes in security.yaml ([@GSadee](https://github.com/GSadee))
- [#14319](https://github.com/Sylius/Sylius/issues/14319) [Maintenance] Update JS dependencies
- [#14320](https://github.com/Sylius/Sylius/issues/14320) [CS][DX] Refactor ()
- [#14321](https://github.com/Sylius/Sylius/issues/14321) [CS][DX] Refactor ()
- [#14324](https://github.com/Sylius/Sylius/issues/14324) [Admin] Improve highlighting menu items ([@GSadee](https://github.com/GSadee))
- [#14325](https://github.com/Sylius/Sylius/issues/14325) [UI] removed important flag from the button class ([@Rafikooo](https://github.com/Rafikooo))
- [#14328](https://github.com/Sylius/Sylius/issues/14328) [Template][Events] Introduce Context Providers for Template Blocks ([@coldic3](https://github.com/coldic3))
- [#14330](https://github.com/Sylius/Sylius/issues/14330) [Maintenance] Allow to choose whether use Webpack or Gulp ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14331](https://github.com/Sylius/Sylius/issues/14331) [Docs] Add conventions for Template Events ([@coldic3](https://github.com/coldic3))
- [#14333](https://github.com/Sylius/Sylius/issues/14333) [Docs] Remove migrating to webpack page from docs ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14336](https://github.com/Sylius/Sylius/issues/14336) Enable Behat tests in PostgreSQL workflow ([@GSadee](https://github.com/GSadee))
- [#14339](https://github.com/Sylius/Sylius/issues/14339) [GitHub Actions] Bump up PostgreSQL version in workflow to the current one ([@GSadee](https://github.com/GSadee))
- [#14344](https://github.com/Sylius/Sylius/issues/14344) [Behat][PostgreSQL] Fix removing items from cart ([@GSadee](https://github.com/GSadee))
- [#14346](https://github.com/Sylius/Sylius/issues/14346) [Maintenance] Bump doctrine/orm minimal version to 2.13 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14349](https://github.com/Sylius/Sylius/issues/14349) [Admin][CatalogPromotion] Browsing affected product variants ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14351](https://github.com/Sylius/Sylius/issues/14351) [Catalog Promotions] Add `_sylius.alias` to the routings ([@coldic3](https://github.com/coldic3))
- [#14357](https://github.com/Sylius/Sylius/issues/14357) [Maintenance] Add missing images to the Webpack's build process ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14361](https://github.com/Sylius/Sylius/issues/14361) [Maintenance] Fix setting sylius_ui.use_webpack parameter ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14373](https://github.com/Sylius/Sylius/issues/14373) [Docs] Add Context Providers to the template customization guide ([@coldic3](https://github.com/coldic3))
- [#14374](https://github.com/Sylius/Sylius/issues/14374) [UI] Remove experimental tag from template events related services ([@GSadee](https://github.com/GSadee))
- [#14377](https://github.com/Sylius/Sylius/issues/14377) [Products][Admin][UI] Display the channel name instead of the channel code in the variant list ([@Rafikooo](https://github.com/Rafikooo))
- [#14378](https://github.com/Sylius/Sylius/issues/14378) [Products][CatalogPromotions] Catalog promotion details on both simple and configurable products ([@Rafikooo](https://github.com/Rafikooo))
- [#14385](https://github.com/Sylius/Sylius/issues/14385) [Docs] Refactor example Context Provider ([@coldic3](https://github.com/coldic3))
- [#14390](https://github.com/Sylius/Sylius/issues/14390) [GitHub Actions] Add builds for API Platform ~2.6.0 ([@GSadee](https://github.com/GSadee))
- [#14392](https://github.com/Sylius/Sylius/issues/14392) Fix build after API Platform 2.7.1 release ([@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee))
- [#14396](https://github.com/Sylius/Sylius/issues/14396) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))

## v1.12.0-ALPHA.1 (2022-09-19)

#### Details

- [#13163](https://github.com/Sylius/Sylius/issues/13163) [UX][Attribute] Use single_text widget for Date&DateTime attribute form type ([@Jibbarth](https://github.com/Jibbarth))
- [#13394](https://github.com/Sylius/Sylius/issues/13394) Use loadUserByIdentifier() since Symfony 5.3 ([@kayue](https://github.com/kayue))
- [#13406](https://github.com/Sylius/Sylius/issues/13406) [AUTO] Updated translations from Crowdin (master) ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#13417](https://github.com/Sylius/Sylius/issues/13417) feat: add support for OPcache class preloading ([@dunglas](https://github.com/dunglas))
- [#13419](https://github.com/Sylius/Sylius/issues/13419) Import lowercase chart.js/dist/chart.min ([@pavol-tuka](https://github.com/pavol-tuka), [@pavol](https://github.com/pavol)@[@bratia](https://github.com/bratia).[@sk](https://github.com/sk), [@lchrusciel](https://github.com/lchrusciel))
- [#13437](https://github.com/Sylius/Sylius/issues/13437) Make URLs secure by default and add parameter to make then unsecure ([@vvasiloi](https://github.com/vvasiloi))
- [#13488](https://github.com/Sylius/Sylius/issues/13488) feat: use sass instead of node-sass ([@Nek-](https://github.com/Nek-))
- [#13489](https://github.com/Sylius/Sylius/issues/13489) [Maintenance] Drop Sf 4.4 support
- [#13500](https://github.com/Sylius/Sylius/issues/13500) Deprecate unused ShimentUnitTransitions class ([@Zales0123](https://github.com/Zales0123))
- [#13507](https://github.com/Sylius/Sylius/issues/13507) Update security config to use the new authenticator-based system ([@rimas-kudelis](https://github.com/rimas-kudelis))
- [#13528](https://github.com/Sylius/Sylius/issues/13528) Remove Symfony 4 circular dependency exception listener fix ([@mmenozzi](https://github.com/mmenozzi))
- [#13529](https://github.com/Sylius/Sylius/issues/13529) Exclude PHP Arkitect rules files from autoloader ([@mmenozzi](https://github.com/mmenozzi))
- [#13531](https://github.com/Sylius/Sylius/issues/13531) Remove Sylius < 1.3 old Kernel class (#13524) ([@mmenozzi](https://github.com/mmenozzi), [@TheMilek](https://github.com/TheMilek))
- [#13610](https://github.com/Sylius/Sylius/issues/13610) minor fix to exclusive label ([@AdamKasp](https://github.com/AdamKasp))
- [#13622](https://github.com/Sylius/Sylius/issues/13622) Update ResourceBundle and GridBundle ([@Zales0123](https://github.com/Zales0123))
- [#13628](https://github.com/Sylius/Sylius/issues/13628) [API] Shipping methods resolution ([@lchrusciel](https://github.com/lchrusciel), [@TheMilek](https://github.com/TheMilek))
- [#13636](https://github.com/Sylius/Sylius/issues/13636) [Payment method] Listing payment method ([@AdamKasp](https://github.com/AdamKasp))
- [#13646](https://github.com/Sylius/Sylius/issues/13646) Update 1.11 image ([@kulczy](https://github.com/kulczy))
- [#13659](https://github.com/Sylius/Sylius/issues/13659) API Upgrade file updated after ShippingMethod endpoints changes  ([@TheMilek](https://github.com/TheMilek))
- [#13661](https://github.com/Sylius/Sylius/issues/13661) [DX] Adding a helpful error message to the ResetPasswordHandler ([@mamazu](https://github.com/mamazu))
- [#13680](https://github.com/Sylius/Sylius/issues/13680) [Maintenance] Move note about asset management changes from 1.11 to 1.12 UPGRADE file ([@GSadee](https://github.com/GSadee))
- [#13682](https://github.com/Sylius/Sylius/issues/13682) [Maintenance] Test Sylius with node 16.x ([@lchrusciel](https://github.com/lchrusciel))
- [#13696](https://github.com/Sylius/Sylius/issues/13696) [API] UPGRADE file parameter names fixed ([@TheMilek](https://github.com/TheMilek))
- [#13709](https://github.com/Sylius/Sylius/issues/13709) Fix fatal error when OPCache preloading is used ([@mmenozzi](https://github.com/mmenozzi))
- [#13710](https://github.com/Sylius/Sylius/issues/13710) [UI] Layout improvements and sticky columns ([@kulczy](https://github.com/kulczy))
- [#13778](https://github.com/Sylius/Sylius/issues/13778) [Maintenance][API] Decouple resource metadata from ResetPasswordHandler ([@coldic3](https://github.com/coldic3))
- [#13785](https://github.com/Sylius/Sylius/issues/13785) [Upgrade] Add more details to UPGRADE-API-1.12.md ([@coldic3](https://github.com/coldic3))
- [#13786](https://github.com/Sylius/Sylius/issues/13786) Prepare postgresql pipeline by making behat scenarios de-case-sensitive ([@Ferror](https://github.com/Ferror))
- [#13806](https://github.com/Sylius/Sylius/issues/13806) Refreshed shop theme ([@kulczy](https://github.com/kulczy))
- [#13814](https://github.com/Sylius/Sylius/issues/13814) Minor theme fixes ([@kulczy](https://github.com/kulczy))
- [#13822](https://github.com/Sylius/Sylius/issues/13822) Add images to the Readme file ([@kulczy](https://github.com/kulczy))
- [#13823](https://github.com/Sylius/Sylius/issues/13823) [Behat][API] Browsing channels using their default locales ([@coldic3](https://github.com/coldic3))
- [#13825](https://github.com/Sylius/Sylius/issues/13825) [API][Shop] Channel endpoint that returns current channel created ([@TheMilek](https://github.com/TheMilek))
- [#13830](https://github.com/Sylius/Sylius/issues/13830) [API] Use the Calendar component in command handlers ([@coldic3](https://github.com/coldic3))
- [#13832](https://github.com/Sylius/Sylius/issues/13832) [Behat] Refactor API clients ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#13843](https://github.com/Sylius/Sylius/issues/13843) [Cart] move locale from body to header ([@AdamKasp](https://github.com/AdamKasp))
- [#13850](https://github.com/Sylius/Sylius/issues/13850) [Maintenance][Docker]Create simple docker environment ([@Ferror](https://github.com/Ferror))
- [#13851](https://github.com/Sylius/Sylius/issues/13851) [Behat] Viewing product image - API scenario covered ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13855](https://github.com/Sylius/Sylius/issues/13855) [UI][Swagger] AutoAuthorize on sending admin credentials ([@SirDomin](https://github.com/SirDomin))
- [#13859](https://github.com/Sylius/Sylius/issues/13859) Fix mistake after rebase ([@AdamKasp](https://github.com/AdamKasp))
- [#13861](https://github.com/Sylius/Sylius/issues/13861) [API][Shop][Behat] Implement scenarios for switching and handling multiple locales ([@GSadee](https://github.com/GSadee))
- [#13862](https://github.com/Sylius/Sylius/issues/13862) [API] Sorting products by date ([@Rafikooo](https://github.com/Rafikooo))
- [#13863](https://github.com/Sylius/Sylius/issues/13863) [API][Shop] Viewing only the enabled variants of a product ([@TheMilek](https://github.com/TheMilek))
- [#13868](https://github.com/Sylius/Sylius/issues/13868) [API] Remove validation from locale, add step with wrong locale in header ([@SirDomin](https://github.com/SirDomin))
- [#13869](https://github.com/Sylius/Sylius/issues/13869) [Behat][API] Extract resources names from contexts to a separate class ([@GSadee](https://github.com/GSadee))
- [#13877](https://github.com/Sylius/Sylius/issues/13877) [API][Shop] Viewing only the enabled variants of a product fixes ([@TheMilek](https://github.com/TheMilek))
- [#13879](https://github.com/Sylius/Sylius/issues/13879) [HotFix][Behat][API] Fix suddenly failing tests ([@coldic3](https://github.com/coldic3))
- [#13881](https://github.com/Sylius/Sylius/issues/13881) Use api route prefix parameter instead of `/api/v2` ([@Prometee](https://github.com/Prometee))
- [#13882](https://github.com/Sylius/Sylius/issues/13882) [maintenance]Unify markdown tables ([@Ferror](https://github.com/Ferror))
- [#13893](https://github.com/Sylius/Sylius/issues/13893) [docker]Configure Blackfire service in dev environment ([@Ferror](https://github.com/Ferror))
- [#13896](https://github.com/Sylius/Sylius/issues/13896) [behat]Extract Request creation to separate service ([@Ferror](https://github.com/Ferror))
- [#13897](https://github.com/Sylius/Sylius/issues/13897) [docker]Run Catalog Promotion via SYNC messenger transport ([@Ferror](https://github.com/Ferror))
- [#13899](https://github.com/Sylius/Sylius/issues/13899) Behat use project api prefix ([@Prometee](https://github.com/Prometee))
- [#13901](https://github.com/Sylius/Sylius/issues/13901) Use API Url prefix on sylius.api.paths_to_hide ([@Prometee](https://github.com/Prometee))
- [#13906](https://github.com/Sylius/Sylius/issues/13906) [AUTO] Updated translations from Crowdin (master) ([@SyliusBot](https://github.com/SyliusBot))
- [#13912](https://github.com/Sylius/Sylius/issues/13912) Support Twig 3 ([@Zales0123](https://github.com/Zales0123))
- [#13914](https://github.com/Sylius/Sylius/issues/13914) Revert "[docker]Run Catalog Promotion via SYNC messenger transport" ([@lchrusciel](https://github.com/lchrusciel))
- [#13924](https://github.com/Sylius/Sylius/issues/13924) [maintenance][docker]Rerun behat pipelines ([@Ferror](https://github.com/Ferror))
- [#13925](https://github.com/Sylius/Sylius/issues/13925) [maintenance][docker]Increase opcache limits ([@Ferror](https://github.com/Ferror))
- [#13926](https://github.com/Sylius/Sylius/issues/13926) [maintenance][docker]Use synchronous messenger transport ([@Ferror](https://github.com/Ferror))
- [#13928](https://github.com/Sylius/Sylius/issues/13928) [API][Shop] Viewing product attributes ([@coldic3](https://github.com/coldic3))
- [#13930](https://github.com/Sylius/Sylius/issues/13930) [API][Behat] Cover scenarios for applying correct taxes ([@GSadee](https://github.com/GSadee))
- [#13935](https://github.com/Sylius/Sylius/issues/13935) [API][Behat] Cover scenarios for applying taxes included in price ([@GSadee](https://github.com/GSadee))
- [#13936](https://github.com/Sylius/Sylius/issues/13936) [API][Behat] Cover scenarios for receiving discount on shipping after changing product's quantity ([@GSadee](https://github.com/GSadee))
- [#13937](https://github.com/Sylius/Sylius/issues/13937) Define autolabeler for docker label ([@Ferror](https://github.com/Ferror))
- [#13939](https://github.com/Sylius/Sylius/issues/13939) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions))
- [#13941](https://github.com/Sylius/Sylius/issues/13941) [AUTO] Updated translations from Crowdin (master) ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#13942](https://github.com/Sylius/Sylius/issues/13942) [API] Add additional PHPSpec for PickupCartHandler when the logged in user has no default address + minor refactor ([@GSadee](https://github.com/GSadee))
- [#13943](https://github.com/Sylius/Sylius/issues/13943) [API][Behat] Cover scenarios for receiving fixed discount from specific taxon ([@GSadee](https://github.com/GSadee))
- [#13944](https://github.com/Sylius/Sylius/issues/13944) [Maintenance] Execute yarn build production like to avoid deps mismatch ([@lchrusciel](https://github.com/lchrusciel))
- [#13945](https://github.com/Sylius/Sylius/issues/13945) [API][Behat] Cover scenarios for receiving a discount from one promotion based on items total ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13946](https://github.com/Sylius/Sylius/issues/13946) [API] Discount for nth order ([@Rafikooo](https://github.com/Rafikooo))
- [#13947](https://github.com/Sylius/Sylius/issues/13947) [API] cover complex promotion with api ([@AdamKasp](https://github.com/AdamKasp))
- [#13949](https://github.com/Sylius/Sylius/issues/13949) [Shop][API] ProductAssociation endpoint created ([@TheMilek](https://github.com/TheMilek), [@GSadee](https://github.com/GSadee))
- [#13950](https://github.com/Sylius/Sylius/issues/13950) [API] Cover scenarios for receiving email after registration ([@GSadee](https://github.com/GSadee))
- [#13952](https://github.com/Sylius/Sylius/issues/13952) [docker]Run tests in test_cached environment ([@Ferror](https://github.com/Ferror))
- [#13953](https://github.com/Sylius/Sylius/issues/13953) [API] This same cart promotion discount in different channels ([@Rafikooo](https://github.com/Rafikooo))
- [#13955](https://github.com/Sylius/Sylius/issues/13955) [Behat][API] Cover api scenarios for order promotion integrity validation ([@ernestWarwas](https://github.com/ernestWarwas), [@GSadee](https://github.com/GSadee))
- [#13956](https://github.com/Sylius/Sylius/issues/13956) [maintenance][js]Specify engines dependencies ([@Ferror](https://github.com/Ferror))
- [#13957](https://github.com/Sylius/Sylius/issues/13957) [API][Shop] ProductAssociationType endpoint created ([@TheMilek](https://github.com/TheMilek))
- [#13958](https://github.com/Sylius/Sylius/issues/13958) [docker][maintenance]Extend Makefile possibilities and compose tests ([@Ferror](https://github.com/Ferror))
- [#13960](https://github.com/Sylius/Sylius/issues/13960) [API]Add contact request ([@AdamKasp](https://github.com/AdamKasp), [@TheMilek](https://github.com/TheMilek))
- [#13963](https://github.com/Sylius/Sylius/issues/13963) Update stripe/stripe-php requirement from ^6.43 to ^8.1 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#13968](https://github.com/Sylius/Sylius/issues/13968) [Customer] Extract authorized user assignment to separate method ([@lchrusciel](https://github.com/lchrusciel))
- [#13970](https://github.com/Sylius/Sylius/issues/13970) [Bug][GH] Remove auto commenting feature ([@lchrusciel](https://github.com/lchrusciel))
- [#13973](https://github.com/Sylius/Sylius/issues/13973) [docker]Install and configure xdebug ([@Ferror](https://github.com/Ferror))
- [#13984](https://github.com/Sylius/Sylius/issues/13984) [API] Extract user logic rules for orders to separate extension ([@lchrusciel](https://github.com/lchrusciel))
- [#13985](https://github.com/Sylius/Sylius/issues/13985) [CS][DX] Refactor ()
- [#13996](https://github.com/Sylius/Sylius/issues/13996) [API][Behat] Update cart promotions on checkout if the promotion is not eligible  ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13997](https://github.com/Sylius/Sylius/issues/13997) [API][Shop] Viewing exchange rates ([@coldic3](https://github.com/coldic3))
- [#14008](https://github.com/Sylius/Sylius/issues/14008) [Behat] Explicitly define channel base currency in viewing exchange rates scenario ([@coldic3](https://github.com/coldic3))
- [#14012](https://github.com/Sylius/Sylius/issues/14012) [Behat] no-api scenario marked ([@Rafikooo](https://github.com/Rafikooo))
- [#14013](https://github.com/Sylius/Sylius/issues/14013) [API] cover scenarios for non existing taxon filter ([@SirDomin](https://github.com/SirDomin))
- [#14028](https://github.com/Sylius/Sylius/issues/14028) [CS][DX] Refactor ()
- [#14040](https://github.com/Sylius/Sylius/issues/14040) [maintenance]Define charset in database url ([@Ferror](https://github.com/Ferror))
- [#14042](https://github.com/Sylius/Sylius/issues/14042) [Symfony 6] Fix command arguments denormalizer return typehint ([@loic425](https://github.com/loic425))
- [#14050](https://github.com/Sylius/Sylius/issues/14050) [docker][docs]Create Docker Compose configuration file for documentation ([@Ferror](https://github.com/Ferror))
- [#14051](https://github.com/Sylius/Sylius/issues/14051) [docker][docs]Deploy Sylius with Docker ([@Ferror](https://github.com/Ferror))
- [#14052](https://github.com/Sylius/Sylius/issues/14052) Fix bootstrap for Symfony 6 ([@loic425](https://github.com/loic425))
- [#14054](https://github.com/Sylius/Sylius/issues/14054) [Symfony 6] Replace encoders with password_hashers ([@loic425](https://github.com/loic425))
- [#14056](https://github.com/Sylius/Sylius/issues/14056) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14062](https://github.com/Sylius/Sylius/issues/14062) Fix ProductSlugDocumentationNormalizer ([@Zales0123](https://github.com/Zales0123))
- [#14076](https://github.com/Sylius/Sylius/issues/14076) Add missing  in Product fixtures ([@RadnoK](https://github.com/RadnoK))
- [#14080](https://github.com/Sylius/Sylius/issues/14080) [Symfony 6] Use Password hasher ([@loic425](https://github.com/loic425))
- [#14083](https://github.com/Sylius/Sylius/issues/14083) [idea]Ignore export of docker, docs, adr and github files ([@Ferror](https://github.com/Ferror))
- [#14117](https://github.com/Sylius/Sylius/issues/14117) [DX] Removing duplicate attribute iteration ([@mamazu](https://github.com/mamazu))
- [#14121](https://github.com/Sylius/Sylius/issues/14121) [docker]Define BLACKFIRE_DISABLE_LEGACY_PORT env as 1 instead of true ([@Ferror](https://github.com/Ferror))
- [#14124](https://github.com/Sylius/Sylius/issues/14124) [Admin][Behat] Cover scenarios for admin password reset ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14126](https://github.com/Sylius/Sylius/issues/14126) [API] Fix TaxonFilter default order behavior ([@coldic3](https://github.com/coldic3))
- [#14128](https://github.com/Sylius/Sylius/issues/14128) [Admin][API] Sending administrator's password reset email ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14135](https://github.com/Sylius/Sylius/issues/14135) Fix data transformers for SF6 ([@loic425](https://github.com/loic425))
- [#14136](https://github.com/Sylius/Sylius/issues/14136) [Symfony 6] Fix deletion listeners ([@loic425](https://github.com/loic425))
- [#14138](https://github.com/Sylius/Sylius/issues/14138) [Admin][UI] Sending administrator's password reset email ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14139](https://github.com/Sylius/Sylius/issues/14139) [Admin][API] Password reset ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14145](https://github.com/Sylius/Sylius/issues/14145) [Maintenance] Add support for doctrine/dbal:^3.0 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14149](https://github.com/Sylius/Sylius/issues/14149) [Upgrade] A note about changes to the `access_control` configuration of `security.yaml` ([@Rafikooo](https://github.com/Rafikooo))
- [#14151](https://github.com/Sylius/Sylius/issues/14151) Fixed the way an unknown email is treated when requesting a password reset  ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14152](https://github.com/Sylius/Sylius/issues/14152) [Admin][UI][API] Request password reset validation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14153](https://github.com/Sylius/Sylius/issues/14153) [Admin][UI][API] Reset password validation ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14157](https://github.com/Sylius/Sylius/issues/14157) [DX] Load test services in all envs starting with test keyword ([@lchrusciel](https://github.com/lchrusciel))
- [#14158](https://github.com/Sylius/Sylius/issues/14158) [Admin][UI] Unified ChannelCollection template ([@mamazu](https://github.com/mamazu), [@NoResponseMate](https://github.com/NoResponseMate))
- [#14159](https://github.com/Sylius/Sylius/issues/14159) [UI] Redirect to previous filtered page after perform any action from index resource page ([@ernestWarwas](https://github.com/ernestWarwas), [@Zales0123](https://github.com/Zales0123))
- [#14161](https://github.com/Sylius/Sylius/issues/14161) [Core] Remove the "experimental" tag from Message* namespaces ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14166](https://github.com/Sylius/Sylius/issues/14166) [frontend]Create gulp watch script ([@Ferror](https://github.com/Ferror))
- [#14167](https://github.com/Sylius/Sylius/issues/14167) [UPGRADE] Mentioning about adding test services in every test env ([@lchrusciel](https://github.com/lchrusciel))
- [#14170](https://github.com/Sylius/Sylius/issues/14170) [CI] Add a test to build assets with Webpack ([@loic425](https://github.com/loic425))
- [#14175](https://github.com/Sylius/Sylius/issues/14175) [docker]Hot Fix - Create database via doctrine command and minor Docker Pipeline improvements ([@Ferror](https://github.com/Ferror))
- [#14178](https://github.com/Sylius/Sylius/issues/14178) [Hot?-fix] Fix redirect on parametrized create pages ([@Zales0123](https://github.com/Zales0123))
- [#14179](https://github.com/Sylius/Sylius/issues/14179) [bug]Check if last_error variable in twig exists and is not null ([@Ferror](https://github.com/Ferror))
- [#14181](https://github.com/Sylius/Sylius/issues/14181) [Maintenance][Admin] Slight password reset cleanup ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14186](https://github.com/Sylius/Sylius/issues/14186) [Symfony 6][ShopBundle] Fix order customer ip listener ([@loic425](https://github.com/loic425))
- [#14187](https://github.com/Sylius/Sylius/issues/14187) [Symfony 6][Shop bundle] Fix shop user logout handler ([@loic425](https://github.com/loic425))
- [#14191](https://github.com/Sylius/Sylius/issues/14191) [Symfony 6] Fix request password reset action spec ([@loic425](https://github.com/loic425))
- [#14192](https://github.com/Sylius/Sylius/issues/14192) [Symfony 6] Fix notification controller ([@loic425](https://github.com/loic425))
- [#14193](https://github.com/Sylius/Sylius/issues/14193) Rename tag tagged to tagged_iterator ([@GSadee](https://github.com/GSadee))
- [#14194](https://github.com/Sylius/Sylius/issues/14194) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14199](https://github.com/Sylius/Sylius/issues/14199) [UI][Continuation] Minor fixes ([@kulczy](https://github.com/kulczy), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14200](https://github.com/Sylius/Sylius/issues/14200) [Checkout] Add possibility to choose the required address in the checkout ([@GSadee](https://github.com/GSadee))
- [#14207](https://github.com/Sylius/Sylius/issues/14207) [UI] Change cart button to display items count, not products count ([@jakubtobiasz](https://github.com/jakubtobiasz), [@Zales0123](https://github.com/Zales0123))
- [#14215](https://github.com/Sylius/Sylius/issues/14215) [API] Rename OrderPromotionCodeAssigner ([@GSadee](https://github.com/GSadee))
- [#14221](https://github.com/Sylius/Sylius/issues/14221) [CS][DX] Refactor ()
- [#14222](https://github.com/Sylius/Sylius/issues/14222) [Maintenance] Bump JMS/Serializer-Bundle dependency ([@lchrusciel](https://github.com/lchrusciel))
- [#14226](https://github.com/Sylius/Sylius/issues/14226) [Behat] Improve scenarios to work with case sensitive PostgreSQL ([@GSadee](https://github.com/GSadee))
- [#14228](https://github.com/Sylius/Sylius/issues/14228) [Shop][UI] Update cart on checkout ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14230](https://github.com/Sylius/Sylius/issues/14230) [Admin][CatalogPromotion] Add filters ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14234](https://github.com/Sylius/Sylius/issues/14234) [CS][DX] Refactor ()
- [#14242](https://github.com/Sylius/Sylius/issues/14242) [API][Shop] List only orders from current channel ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14249](https://github.com/Sylius/Sylius/issues/14249) [Behat] Scenarios for removing catalog promotions ([@Rafikooo](https://github.com/Rafikooo))
- [#14251](https://github.com/Sylius/Sylius/issues/14251) [docs][docker]Auto build after each change ([@Ferror](https://github.com/Ferror))
- [#14255](https://github.com/Sylius/Sylius/issues/14255) [Admin][Order] Filter by product/variant ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14256](https://github.com/Sylius/Sylius/issues/14256) [Symfony 6] Fix getting criteria ([@loic425](https://github.com/loic425))
- [#14257](https://github.com/Sylius/Sylius/issues/14257) [DOCS] How to get currencies for channel ([@arti0090](https://github.com/arti0090))
- [#14258](https://github.com/Sylius/Sylius/issues/14258) [Symfony 6] Fix getting route params ([@loic425](https://github.com/loic425))
- [#14270](https://github.com/Sylius/Sylius/issues/14270) [CatalogPromotions][API] Removal of catalog promotions ([@Rafikooo](https://github.com/Rafikooo))
- [#14272](https://github.com/Sylius/Sylius/issues/14272) Refresh readme image ([@kulczy](https://github.com/kulczy))
- [#14273](https://github.com/Sylius/Sylius/issues/14273) [CatalogPromotion][UI] Fix promotion labels while changing variants on the product page ([@coldic3](https://github.com/coldic3))
- [#14274](https://github.com/Sylius/Sylius/issues/14274) [AdminPasswordReset][Behat] Missed steps implementation ([@Rafikooo](https://github.com/Rafikooo))
- [#14278](https://github.com/Sylius/Sylius/issues/14278) chore: remove unused Customer/Show/_menu.html.twig template ([@Florian-Merle](https://github.com/Florian-Merle))
- [#14283](https://github.com/Sylius/Sylius/issues/14283) [Symfony 6] Enable authenticator manager ([@loic425](https://github.com/loic425), [@ernestWarwas](https://github.com/ernestWarwas))
- [#14288](https://github.com/Sylius/Sylius/issues/14288) [Config] Marked SenderInterface as excluded in psalm.xml ([@Rafikooo](https://github.com/Rafikooo))
- [#14290](https://github.com/Sylius/Sylius/issues/14290) [Catalog Promotions] Introduce the "processing" state and drop the unused "failed" step ([@coldic3](https://github.com/coldic3))
- [#14291](https://github.com/Sylius/Sylius/issues/14291) [CatalogPromotions][UI] Removal of catalog promotions ([@Rafikooo](https://github.com/Rafikooo))
- [#14292](https://github.com/Sylius/Sylius/issues/14292) Refactor customer provider ([@AdamKasp](https://github.com/AdamKasp))
- [#14294](https://github.com/Sylius/Sylius/issues/14294) [Maintenance] Add conflict with jms/serializer-bundle 4.1.0 ([@coldic3](https://github.com/coldic3))
- [#14297](https://github.com/Sylius/Sylius/issues/14297) [Catalog Promotions][Fixtures] Fix setting state in CatalogPromotionExecutorListener ([@coldic3](https://github.com/coldic3))
- [#14298](https://github.com/Sylius/Sylius/issues/14298) [Maintenance] Introduce Flysystem and use it in place of Gaufrette by default ([@coldic3](https://github.com/coldic3))
- [#14311](https://github.com/Sylius/Sylius/issues/14311) [CatalogPromotions][Swagger] HTTP Response statuses documented for CatalogPromotion removing ([@Rafikooo](https://github.com/Rafikooo))
- [#14314](https://github.com/Sylius/Sylius/issues/14314) [CatalogPromotions][Docs] Removing of catalog promotions documented ([@Rafikooo](https://github.com/Rafikooo))
