<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Component\Core\Resolver;

use Sylius\Component\Core\Model\AddressInterface;
use Sylius\Component\Core\Model\OrderInterface;

final class TaxationAddressResolver implements TaxationAddressResolverInterface
{
    public function __construct(private bool $shippingAddressBasedTaxation)
    {
    }

    public function getTaxationAddressFromOrder(OrderInterface $order): ?AddressInterface
    {
        if ($this->shippingAddressBasedTaxation) {
            return $order->getShippingAddress();
        }

        return $order->getBillingAddress();
    }
}
