<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Sylius Sp. z o.o.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\CurrencyBundle\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Component\Currency\Model\ExchangeRateInterface;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class ExchangeRateType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('ratio', NumberType::class, [
                'label' => 'sylius.form.exchange_rate.ratio',
                'required' => true,
                'invalid_message' => 'sylius.exchange_rate.ratio.invalid',
                'scale' => 5,
                'rounding_mode' => $options['rounding_mode'],
            ])
        ;

        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event): void {
            /** @var ExchangeRateInterface $exchangeRate */
            $exchangeRate = $event->getData();
            $form = $event->getForm();

            $disabled = null !== $exchangeRate->getId();

            $form
                ->add('sourceCurrency', CurrencyChoiceType::class, [
                    'label' => 'sylius.form.exchange_rate.source_currency',
                    'required' => true,
                    'empty_data' => false,
                    'disabled' => $disabled,
                ])
                ->add('targetCurrency', CurrencyChoiceType::class, [
                    'label' => 'sylius.form.exchange_rate.target_currency',
                    'required' => true,
                    'empty_data' => false,
                    'disabled' => $disabled,
                ])
            ;
        });
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver->setDefault('rounding_mode', \NumberFormatter::ROUND_HALFEVEN);
    }

    public function getBlockPrefix()
    {
        return 'sylius_exchange_rate';
    }
}
