# CHANGELOG FOR `1.11.X`

## v1.11.15 (2023-03-28)

#### Details

- [#14784](https://github.com/Sylius/Sylius/issues/14784) [Documentation] Update Sylius versions in release cycle ([@GSadee](https://github.com/GSadee))
- [#14871](https://github.com/Sylius/Sylius/issues/14871) Fix dependency security vulerability for enshrined/svg-sanitize package ([@cosminsandu](https://github.com/cosminsandu))
- [#14876](https://github.com/Sylius/Sylius/issues/14876) Fix CI on Sylius 1.11 ([@jakubtobiasz](https://github.com/jakubtobiasz))

## v1.11.14 (2023-02-02)

#### Details

- [#12996](https://github.com/Sylius/Sylius/issues/12996) Remove sylius.model.shop_billing_data.class ([@vvasiloi](https://github.com/vvasiloi))
- [#13448](https://github.com/Sylius/Sylius/issues/13448) Remove wrong trailing space in test attribute ([@mmenozzi](https://github.com/mmenozzi))
- [#13835](https://github.com/Sylius/Sylius/issues/13835) chore: Replace NBSP by Space in doc ([@sad270](https://github.com/sad270))
- [#14174](https://github.com/Sylius/Sylius/issues/14174) [Admin] Fix 500 error when showing cart in admin panel ([@lchrusciel](https://github.com/lchrusciel))
- [#14416](https://github.com/Sylius/Sylius/issues/14416) [Product] Fixed product attribute translations #11570 ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14576](https://github.com/Sylius/Sylius/issues/14576) Fix notInRangeMessage usage for a few Range validations ([@diimpp](https://github.com/diimpp), [@GSadee](https://github.com/GSadee))
- [#14577](https://github.com/Sylius/Sylius/issues/14577) Product taxon position don't affect parent taxon - API ([@everwhatever](https://github.com/everwhatever))
- [#14719](https://github.com/Sylius/Sylius/issues/14719) [CS][DX] Refactor
- [#14721](https://github.com/Sylius/Sylius/issues/14721) Added forgotten import to docblock. ([@kkevindev](https://github.com/kkevindev))
- [#14722](https://github.com/Sylius/Sylius/issues/14722) [User] Allow configuring `lastLogin` tracking frequency ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14730](https://github.com/Sylius/Sylius/issues/14730) [UI][DX] Extract form collection event handlers to the separate module ([@coldic3](https://github.com/coldic3))
- [#14731](https://github.com/Sylius/Sylius/issues/14731) [Fix] Request stack with null request ([@Prometee](https://github.com/Prometee))
- [#14736](https://github.com/Sylius/Sylius/issues/14736) Updated UPGRADE-1.11.md to add a BC Break on channel pricing ([@devantoine](https://github.com/devantoine))
- [#14740](https://github.com/Sylius/Sylius/issues/14740) [CS][DX] Refactor
- [#14746](https://github.com/Sylius/Sylius/issues/14746) Optimize jeans_04.svg size ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14751](https://github.com/Sylius/Sylius/issues/14751) Fix applying catalog promotions when there is no applied promotions and price differ from original price ([@TheMilek](https://github.com/TheMilek))
- [#14755](https://github.com/Sylius/Sylius/issues/14755) [Maintenance][ApiBundle] Move test app into `Tests` dir ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14762](https://github.com/Sylius/Sylius/issues/14762) Add missing interface to OrderIntegrityChecker ([@Zales0123](https://github.com/Zales0123))
- [#14768](https://github.com/Sylius/Sylius/issues/14768) [CS][DX] Refactor
- [#14773](https://github.com/Sylius/Sylius/issues/14773) [Maintenance][UserBundle] Fix UserLastLoginSubscriber arguments ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14782](https://github.com/Sylius/Sylius/issues/14782) Fix the wrong DQL alias in OrderByIdentifierSqlWalker ([@coldic3](https://github.com/coldic3))
- [#14783](https://github.com/Sylius/Sylius/issues/14783) [Admin] Fix 500 when resending order confirmation email for a cart ([@NoResponseMate](https://github.com/NoResponseMate))

## v1.11.13 (2023-01-13)

#### Details

- [#14715](https://github.com/Sylius/Sylius/issues/14715) [Core] Fix default query hint config ([@coldic3](https://github.com/coldic3))

## v1.11.12 (2023-01-13)

#### Details

- [#12099](https://github.com/Sylius/Sylius/issues/12099) Make link buttons with confirmation modal work again ([@stefandoorn](https://github.com/stefandoorn))
- [#12712](https://github.com/Sylius/Sylius/issues/12712) Fix sprintf parameters order ([@Creeperface01](https://github.com/Creeperface01))
- [#13157](https://github.com/Sylius/Sylius/issues/13157) Add missing space to taxes <tr> ([@pavol-tuka](https://github.com/pavol-tuka))
- [#13207](https://github.com/Sylius/Sylius/issues/13207) Changing replacement interface as previous one does not exist ([@Roshyo](https://github.com/Roshyo))
- [#13689](https://github.com/Sylius/Sylius/issues/13689) Fix typo in sylius_order state machine callback ([@vvasiloi](https://github.com/vvasiloi), [@Rafikooo](https://github.com/Rafikooo), [@Zales0123](https://github.com/Zales0123))
- [#13820](https://github.com/Sylius/Sylius/issues/13820) [Doc] Add depth to theme configuration ([@Nek-](https://github.com/Nek-))
- [#14177](https://github.com/Sylius/Sylius/issues/14177) [Docs] Fix API docs for Shop User token response ([@loic425](https://github.com/loic425))
- [#14289](https://github.com/Sylius/Sylius/issues/14289) [Api] Change int to integer in ProductVariant and ShippingMethod documentation normalizers ()
- [#14525](https://github.com/Sylius/Sylius/issues/14525) Adding skipIf for migrations to allow future runs when they should apply ([@stefantalen](https://github.com/stefantalen))
- [#14575](https://github.com/Sylius/Sylius/issues/14575) [DX] Add EditorConfig for test API responses ([@coldic3](https://github.com/coldic3))
- [#14580](https://github.com/Sylius/Sylius/issues/14580) [Enchancement] Optimize memory usage by sylius:remove-expired-carts command ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14605](https://github.com/Sylius/Sylius/issues/14605) [CS][DX] Refactor ()
- [#14608](https://github.com/Sylius/Sylius/issues/14608) [UI][Shop][Cart] Reset chosen options on refresh in firefox ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14619](https://github.com/Sylius/Sylius/issues/14619) Update catalog_promotions.rst ([@Xusifob](https://github.com/Xusifob))
- [#14632](https://github.com/Sylius/Sylius/issues/14632) [Documentation] Extend the maintenance period of Sylius 1.11 by one month ([@GSadee](https://github.com/GSadee))
- [#14633](https://github.com/Sylius/Sylius/issues/14633) [Documentation] Remove Sylius 1.12 scope from the release cycle page ([@GSadee](https://github.com/GSadee))
- [#14634](https://github.com/Sylius/Sylius/issues/14634) [API] Fix ProductVariantNormalizer exception catching ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14642](https://github.com/Sylius/Sylius/issues/14642) Fix invalid API errors normalization ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14643](https://github.com/Sylius/Sylius/issues/14643) [ProductAssociation] Fix empty product associations ([@coldic3](https://github.com/coldic3))
- [#14645](https://github.com/Sylius/Sylius/issues/14645) Move Upgrade API from 1.11.11 to 1.11.12 section to the top of file ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14650](https://github.com/Sylius/Sylius/issues/14650) Validate existence of coupon ([@bashilbers](https://github.com/bashilbers), [@everwhatever](https://github.com/everwhatever))
- [#14651](https://github.com/Sylius/Sylius/issues/14651) Remove unit from shipment ([@kayue](https://github.com/kayue), [@everwhatever](https://github.com/everwhatever))
- [#14659](https://github.com/Sylius/Sylius/issues/14659) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#14661](https://github.com/Sylius/Sylius/issues/14661) [Maintenance][Psalm] Add LifecycleEventArgs to deprecated classes ([@Rafikooo](https://github.com/Rafikooo))
- [#14662](https://github.com/Sylius/Sylius/issues/14662) Improve loading taxons ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14669](https://github.com/Sylius/Sylius/issues/14669) Wrong Rounding of the prices in the percentage discount catalog promotions ([@maxmishyn](https://github.com/maxmishyn), [@everwhatever](https://github.com/everwhatever))
- [#14677](https://github.com/Sylius/Sylius/issues/14677) [Maintenance] Remove Doctrine's LifecycleEventArgs deprecations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14678](https://github.com/Sylius/Sylius/issues/14678) [UX] Fix cart button on small screens ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14682](https://github.com/Sylius/Sylius/issues/14682) It's 2023! 🎉 ([@coldic3](https://github.com/coldic3))
- [#14683](https://github.com/Sylius/Sylius/issues/14683) Extract authorized user assignment to separate method/ cp to 1.11 ([@everwhatever](https://github.com/everwhatever))
- [#14685](https://github.com/Sylius/Sylius/issues/14685) Default ORDER BY for all entities and their relationships ([@coldic3](https://github.com/coldic3))
- [#14689](https://github.com/Sylius/Sylius/issues/14689) [CS][DX] Refactor ()
- [#14691](https://github.com/Sylius/Sylius/issues/14691) [Fix] Symfony container reanimation after friendsofsymfony/rest-bundle: 3.5.0 release ([@Rafikooo](https://github.com/Rafikooo))
- [#14697](https://github.com/Sylius/Sylius/issues/14697) Remove error suppression to fix unit tests ([@coldic3](https://github.com/coldic3))
- [#14700](https://github.com/Sylius/Sylius/issues/14700) Add a conflict for doctrine/migrations:3.5.3 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14701](https://github.com/Sylius/Sylius/issues/14701) [API] Fix IRI converter catching homepage ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14704](https://github.com/Sylius/Sylius/issues/14704) [Conflicts] Doctrine/annotations:^2.0 ([@Rafikooo](https://github.com/Rafikooo))
- [#14706](https://github.com/Sylius/Sylius/issues/14706) [Promotion][UI] Fix hardcoded "sylius_promotion" selector ([@coldic3](https://github.com/coldic3))

## v1.11.11 (2022-12-08)

#### Details

- [#12611](https://github.com/Sylius/Sylius/issues/12611) Change on from string to array, consistent with other definitions ([@stefandoorn](https://github.com/stefandoorn))
- [#13187](https://github.com/Sylius/Sylius/issues/13187) issue/12985-migration-in-corebundle ([@coldic3](https://github.com/coldic3))
- [#13202](https://github.com/Sylius/Sylius/issues/13202) [Core][Checkout] fixed #13201 ([@acornforth](https://github.com/acornforth), [@SirDomin](https://github.com/SirDomin))
- [#14435](https://github.com/Sylius/Sylius/issues/14435) Include 1.13 branch in the PR template ([@Zales0123](https://github.com/Zales0123))
- [#14474](https://github.com/Sylius/Sylius/issues/14474) :arrow_up: Upgrade gaufrette version (PHP 8+ compat) ([@Nek-](https://github.com/Nek-), [@coldic3](https://github.com/coldic3))
- [#14486](https://github.com/Sylius/Sylius/issues/14486) [Cart] Set the created_by_guest flag as false if the cart was created by a customer authenticated via access token ([@nicolalazzaro](https://github.com/nicolalazzaro))
- [#14488](https://github.com/Sylius/Sylius/issues/14488) [Maintenance][CI] Remove deprecations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14489](https://github.com/Sylius/Sylius/issues/14489) [Api] Sorting products by price should be per channel ([@j92](https://github.com/j92))
- [#14500](https://github.com/Sylius/Sylius/issues/14500) [Docs] Update inventory source resolving ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14501](https://github.com/Sylius/Sylius/issues/14501) [Maintenance] Removal of direct unneeded dependency on proxy manager LTS ([@lchrusciel](https://github.com/lchrusciel))
- [#14514](https://github.com/Sylius/Sylius/issues/14514) [Behat][API] Add missing channels suite to imports ([@GSadee](https://github.com/GSadee))
- [#14516](https://github.com/Sylius/Sylius/issues/14516) [Docs] Update release cycle with 1.12 and 1.13 info ([@Zales0123](https://github.com/Zales0123))
- [#14523](https://github.com/Sylius/Sylius/issues/14523) Product taxon position don't affect parent taxon ([@everwhatever](https://github.com/everwhatever))
- [#14527](https://github.com/Sylius/Sylius/issues/14527) [GitHub Actions] Add 1.13 branch to "Refactor" workflow ([@coldic3](https://github.com/coldic3))
- [#14536](https://github.com/Sylius/Sylius/issues/14536) [Maintenance][Fixture] Allow using default values with optional array nodes ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14538](https://github.com/Sylius/Sylius/issues/14538) [Product] Fix product variant choice labels ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14543](https://github.com/Sylius/Sylius/issues/14543) [Maintenance] Fix type casting in migrations ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14544](https://github.com/Sylius/Sylius/issues/14544) [Doc] Fix Supported versions table ([@oallain](https://github.com/oallain))
- [#14545](https://github.com/Sylius/Sylius/issues/14545) [Migrations] Remove usage of non existent AbstractMigration ([@GSadee](https://github.com/GSadee))
- [#14548](https://github.com/Sylius/Sylius/issues/14548) Fix removing the root taxon, when the second one is Menu Taxon of the channel ([@TheMilek](https://github.com/TheMilek))
- [#14554](https://github.com/Sylius/Sylius/issues/14554) Fix service definition at custom-payment-gateway ([@diimpp](https://github.com/diimpp))
- [#14563](https://github.com/Sylius/Sylius/issues/14563) Add repository option to product_image node ([@TheMilek](https://github.com/TheMilek))
- [#14567](https://github.com/Sylius/Sylius/issues/14567) [Core] Fix invalid catalog promotion repository service id ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14570](https://github.com/Sylius/Sylius/issues/14570) [CS][DX] Fix ECS refactoring ([@coldic3](https://github.com/coldic3))
- [#14573](https://github.com/Sylius/Sylius/issues/14573) [API] Fix ProductReview normalization context ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14574](https://github.com/Sylius/Sylius/issues/14574) [API] Fix missing address serialization for phone number and company name ([@andrehoffmann30](https://github.com/andrehoffmann30), [@coldic3](https://github.com/coldic3))
- [#14586](https://github.com/Sylius/Sylius/issues/14586) [DX] Unify default repo classes for resources ([@coldic3](https://github.com/coldic3))
- [#14595](https://github.com/Sylius/Sylius/issues/14595) [Fix] Filtering out disabled channel scenario ([@Rafikooo](https://github.com/Rafikooo))
- [#14596](https://github.com/Sylius/Sylius/issues/14596) [Orders] Cart not found for registered user ([@Rafikooo](https://github.com/Rafikooo))
- [#14600](https://github.com/Sylius/Sylius/issues/14600) [ProductAssociation] Show product associations within current channel only ([@coldic3](https://github.com/coldic3))
- [#14602](https://github.com/Sylius/Sylius/issues/14602) [GitHub Actions] Restrict "Refactor" workflow to Sylius/Sylius repo ([@coldic3](https://github.com/coldic3))
- [#14614](https://github.com/Sylius/Sylius/issues/14614) Run behat using dual session as javascript scenario ([@Rafikooo](https://github.com/Rafikooo))
- [#14618](https://github.com/Sylius/Sylius/issues/14618) Use MakerBundle instead of SensioGeneratorBundle ([@hmonglee](https://github.com/hmonglee))

## v1.11.10 (2022-10-31)

#### Details

- [#14144](https://github.com/Sylius/Sylius/issues/14144) [Documentation] Fix incorrect translation domain in implementation ([@anned20](https://github.com/anned20))
- [#14156](https://github.com/Sylius/Sylius/issues/14156) [DOCS] Cookbook of how to modify placed order ([@arti0090](https://github.com/arti0090))
- [#14197](https://github.com/Sylius/Sylius/issues/14197) [Docs] Describe Sylius architectural drivers ([@Zales0123](https://github.com/Zales0123))
- [#14246](https://github.com/Sylius/Sylius/issues/14246) [DOCS] Add note about min node version ([@arti0090](https://github.com/arti0090))
- [#14247](https://github.com/Sylius/Sylius/issues/14247) [DOCS] Add info about mailer in installation doc ([@arti0090](https://github.com/arti0090))
- [#14362](https://github.com/Sylius/Sylius/issues/14362) Using the new template namespace syntax in the doc ([@mamazu](https://github.com/mamazu))
- [#14384](https://github.com/Sylius/Sylius/issues/14384) [API] Use tokenValue instead of id ([@Prometee](https://github.com/Prometee))
- [#14397](https://github.com/Sylius/Sylius/issues/14397) [Docs] Fix 1.12 release dates ([@Zales0123](https://github.com/Zales0123))
- [#14402](https://github.com/Sylius/Sylius/issues/14402) [Api] fix order normalization groups ([@mtarld](https://github.com/mtarld))
- [#14410](https://github.com/Sylius/Sylius/issues/14410) [Documentation] Remove the tip about ShopApiPlugin from the architecture page ([@GSadee](https://github.com/GSadee))
- [#14415](https://github.com/Sylius/Sylius/issues/14415) [Behat] Add calendar hook to suites using calendar ([@GSadee](https://github.com/GSadee))
- [#14421](https://github.com/Sylius/Sylius/issues/14421) [DOCS] Add info about supervisors ([@arti0090](https://github.com/arti0090))
- [#14442](https://github.com/Sylius/Sylius/issues/14442) [Hot-fix] Conflict with the newest AP that changes a Customer->User response ([@GSadee](https://github.com/GSadee))
- [#14445](https://github.com/Sylius/Sylius/issues/14445) [Hot-fix] Conflict with the SymfonyMockerContainer 1.0.6 due to incompatible version with Symfony 4.x ([@GSadee](https://github.com/GSadee))
- [#14454](https://github.com/Sylius/Sylius/issues/14454) [Behat] Move scenario from Plus ([@TheMilek](https://github.com/TheMilek))
- [#14471](https://github.com/Sylius/Sylius/issues/14471) [Api] fixed normalization/denormalization resources groups ([@mtarld](https://github.com/mtarld))
- [#14476](https://github.com/Sylius/Sylius/issues/14476) Delay 1.12 release for a few days ([@Zales0123](https://github.com/Zales0123))
- [#14479](https://github.com/Sylius/Sylius/issues/14479) [Maintenance] Allow APIP 2.7.2 ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14482](https://github.com/Sylius/Sylius/issues/14482) Adding batching to the expired carts remover v2 ([@mamazu](https://github.com/mamazu), [@lchrusciel](https://github.com/lchrusciel))
- [#14496](https://github.com/Sylius/Sylius/issues/14496) [README] Switch Sylius naming from platform to framework ([@lchrusciel](https://github.com/lchrusciel))

## v1.11.9 (2022-10-03)

#### Details

- [#14243](https://github.com/Sylius/Sylius/issues/14243) Revert temporary build fix ([@TheMilek](https://github.com/TheMilek))
- [#14310](https://github.com/Sylius/Sylius/issues/14310) [Docs] Release cycle changes ([@Zales0123](https://github.com/Zales0123))
- [#14321](https://github.com/Sylius/Sylius/issues/14321) [CS][DX] Refactor ()
- [#14324](https://github.com/Sylius/Sylius/issues/14324) [Admin] Improve highlighting menu items ([@GSadee](https://github.com/GSadee))
- [#14331](https://github.com/Sylius/Sylius/issues/14331) [Docs] Add conventions for Template Events ([@coldic3](https://github.com/coldic3))
- [#14346](https://github.com/Sylius/Sylius/issues/14346) [Maintenance] Bump doctrine/orm minimal version to 2.13 ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14377](https://github.com/Sylius/Sylius/issues/14377) [Products][Admin][UI] Display the channel name instead of the channel code in the variant list ([@Rafikooo](https://github.com/Rafikooo))
- [#14390](https://github.com/Sylius/Sylius/issues/14390) [GitHub Actions] Add builds for API Platform ~2.6.0 ([@GSadee](https://github.com/GSadee))

## v1.11.8 (2022-09-19)

#### Details

- [#14196](https://github.com/Sylius/Sylius/issues/14196) [Documentation] Add naming conventions to contributing section ([@GSadee](https://github.com/GSadee))
- [#14202](https://github.com/Sylius/Sylius/issues/14202) [Bundle][Attribute]It will also listen on the product attribute objec… ()
- [#14211](https://github.com/Sylius/Sylius/issues/14211) [Behat] Extract javascript driver check ([@Zales0123](https://github.com/Zales0123))
- [#14212](https://github.com/Sylius/Sylius/issues/14212) Adjust PR template file for 1.11 and 1.12 branches ([@Zales0123](https://github.com/Zales0123))
- [#14213](https://github.com/Sylius/Sylius/issues/14213) [bug]Send request to GUS with https ([@Ferror](https://github.com/Ferror))
- [#14214](https://github.com/Sylius/Sylius/issues/14214) [API] Remove redundant validation config for the command that does not exist ([@GSadee](https://github.com/GSadee))
- [#14216](https://github.com/Sylius/Sylius/issues/14216) [Documentation] Minor fixes to naming conventions page ([@GSadee](https://github.com/GSadee))
- [#14217](https://github.com/Sylius/Sylius/issues/14217) [CatalogPromotion] Fix too early data setting during catalog promotion form submission ([@lchrusciel](https://github.com/lchrusciel))
- [#14220](https://github.com/Sylius/Sylius/issues/14220) [CS][DX] Refactor ()
- [#14223](https://github.com/Sylius/Sylius/issues/14223) [Maintenance] Use getObject instead of getEntity on doctrine events ([@lchrusciel](https://github.com/lchrusciel))
- [#14225](https://github.com/Sylius/Sylius/issues/14225) [Minor][Behat] Attributes deletion scenario improvements ([@lchrusciel](https://github.com/lchrusciel))
- [#14233](https://github.com/Sylius/Sylius/issues/14233) [CS][DX] Refactor ()
- [#14236](https://github.com/Sylius/Sylius/issues/14236) [API] Remove problematic mapping path ([@coldic3](https://github.com/coldic3))
- [#14237](https://github.com/Sylius/Sylius/issues/14237) Add coupon channel eligibility checker ([@TheMilek](https://github.com/TheMilek), [@PILLOWPET](https://github.com/PILLOWPET))
- [#14240](https://github.com/Sylius/Sylius/issues/14240) [Checkout][Addressing] Fix duplicated email validation errors ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14245](https://github.com/Sylius/Sylius/issues/14245) [DOCS] How to run async task added in installation ([@arti0090](https://github.com/arti0090))
- [#14248](https://github.com/Sylius/Sylius/issues/14248) [UI] Fix autocomplete empty value ([@NoResponseMate](https://github.com/NoResponseMate))
- [#14250](https://github.com/Sylius/Sylius/issues/14250) [docs]Recommend cron jobs values ([@Ferror](https://github.com/Ferror))
- [#14254](https://github.com/Sylius/Sylius/issues/14254) [Adjustment] Adjustment cloning resets ID and timestamps ([@coldic3](https://github.com/coldic3))
- [#14277](https://github.com/Sylius/Sylius/issues/14277) [ProductAttributes] Change translatable status to yes/no in ProductAttributes grid ([@TheMilek](https://github.com/TheMilek))
- [#14295](https://github.com/Sylius/Sylius/issues/14295) [Config] Mark SenderInterface as excluded in psalm.xml ([@Rafikooo](https://github.com/Rafikooo))
- [#14301](https://github.com/Sylius/Sylius/issues/14301) [Behat][Fix] Check notification expectation in JavaScriptTestHelper ([@Rafikooo](https://github.com/Rafikooo))
- [#14309](https://github.com/Sylius/Sylius/issues/14309) Conflict api-platform/core 2.7.0 ([@loic425](https://github.com/loic425), [@Rafikooo](https://github.com/Rafikooo))

## v1.11.7 (2022-07-28)

#### Details

- [#12773](https://github.com/Sylius/Sylius/issues/12773) [API][FIX] Remove code attribute of OrderItem in API serialization ([@oallain](https://github.com/oallain), [@lchrusciel](https://github.com/lchrusciel))
- [#13874](https://github.com/Sylius/Sylius/issues/13874) [Product] Render disabled main taxon without link in breadcrumb ([@hbsfaria](https://github.com/hbsfaria), [@GSadee](https://github.com/GSadee))
- [#13918](https://github.com/Sylius/Sylius/issues/13918) Changing templates with Sylius Event ([@arti0090](https://github.com/arti0090), [@coldic3](https://github.com/coldic3))
- [#14112](https://github.com/Sylius/Sylius/issues/14112) [Documentation][Plus] Add missing step for updating security file during installation ([@GSadee](https://github.com/GSadee))
- [#14114](https://github.com/Sylius/Sylius/issues/14114) Move login events on Ui bundle ([@loic425](https://github.com/loic425))
- [#14116](https://github.com/Sylius/Sylius/issues/14116) [Docs] Fix logo customization guide ([@coldic3](https://github.com/coldic3))
- [#14120](https://github.com/Sylius/Sylius/issues/14120) [Docs] Drop security support for Sylius 1.9 ([@Zales0123](https://github.com/Zales0123))
- [#14123](https://github.com/Sylius/Sylius/issues/14123) Removed version specification ([@vjandrea](https://github.com/vjandrea))
- [#14130](https://github.com/Sylius/Sylius/issues/14130) [Maintenance] Fix package build ([@lchrusciel](https://github.com/lchrusciel), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14140](https://github.com/Sylius/Sylius/issues/14140) [GitHub Actions] Replace master branch with 1.12 in "Refactor" workflow ([@coldic3](https://github.com/coldic3))
- [#14146](https://github.com/Sylius/Sylius/issues/14146) Allow to set zero tax rate ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14155](https://github.com/Sylius/Sylius/issues/14155) [BUG] The hostname resolver does not check for the channel status ([@lruozzi9](https://github.com/lruozzi9), [@jakubtobiasz](https://github.com/jakubtobiasz))
- [#14180](https://github.com/Sylius/Sylius/issues/14180) [CS] ECS configuration updated ([@Rafikooo](https://github.com/Rafikooo))
- [#14190](https://github.com/Sylius/Sylius/issues/14190) [CS][DX] Refactor ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))

## v1.11.6 (2022-06-27)

#### Details

- [#13573](https://github.com/Sylius/Sylius/issues/13573) [UI] Disable session storage for autocomplete dropdowns ()
- [#13987](https://github.com/Sylius/Sylius/issues/13987) Remove custom error level on Phpspec ([@loic425](https://github.com/loic425))
- [#13998](https://github.com/Sylius/Sylius/issues/13998) Split Sylius packages in Github Actions ([@Zales0123](https://github.com/Zales0123))
- [#14000](https://github.com/Sylius/Sylius/issues/14000) fix `products-by-slug` api docs ([@sad270](https://github.com/sad270))
- [#14002](https://github.com/Sylius/Sylius/issues/14002) [maintenance]Upload Dark and Light version of Sylius logo ([@Ferror](https://github.com/Ferror))
- [#14004](https://github.com/Sylius/Sylius/issues/14004) Specifications should be final ([@loic425](https://github.com/loic425))
- [#14020](https://github.com/Sylius/Sylius/issues/14020) [Dependencies] Removed unused registered Sonata bundles ([@Rafikooo](https://github.com/Rafikooo))
- [#14023](https://github.com/Sylius/Sylius/issues/14023) [DOCS] Add docs about deploy platforms ([@arti0090](https://github.com/arti0090), [@CoderMaggie](https://github.com/CoderMaggie))
- [#14024](https://github.com/Sylius/Sylius/issues/14024) [DOCS] Fix github link on search doc ([@arti0090](https://github.com/arti0090))
- [#14027](https://github.com/Sylius/Sylius/issues/14027) [CS][DX] Refactor ()
- [#14029](https://github.com/Sylius/Sylius/issues/14029) [CS][DX] Refactor ()
- [#14030](https://github.com/Sylius/Sylius/issues/14030) [DOCS] Update image with installation requirements ([@arti0090](https://github.com/arti0090))
- [#14031](https://github.com/Sylius/Sylius/issues/14031) [DOCS] Change the github link on search page ([@arti0090](https://github.com/arti0090))
- [#14032](https://github.com/Sylius/Sylius/issues/14032) [Maintenance] Remove 1.10 branch from scheduled ECS refactor ([@GSadee](https://github.com/GSadee), [@Rafikooo](https://github.com/Rafikooo))
- [#14033](https://github.com/Sylius/Sylius/issues/14033) [Documentation] Remove section about CurrencyProvider that does not exist ([@GSadee](https://github.com/GSadee))
- [#14038](https://github.com/Sylius/Sylius/issues/14038) [Behat] Refactor to use PHP 7.4 syntax ([@GSadee](https://github.com/GSadee))
- [#14039](https://github.com/Sylius/Sylius/issues/14039) [Behat] Introduce PHP 8.0 syntax ([@GSadee](https://github.com/GSadee))
- [#14041](https://github.com/Sylius/Sylius/issues/14041) [Addressing] Prevent deleting zones and provinces that are zone members ([@coldic3](https://github.com/coldic3))
- [#14045](https://github.com/Sylius/Sylius/issues/14045) [Rector] Configure PHP version up to 8.0 ([@loic425](https://github.com/loic425))
- [#14046](https://github.com/Sylius/Sylius/issues/14046) Mention 1.10 full support drop in the documentation ([@Zales0123](https://github.com/Zales0123))
- [#14047](https://github.com/Sylius/Sylius/issues/14047) Remove auto commenting feature on 1.10 & 1.11 as well ([@lchrusciel](https://github.com/lchrusciel))
- [#14049](https://github.com/Sylius/Sylius/issues/14049) Revert "Split Sylius packages in Github Actions" ([@Zales0123](https://github.com/Zales0123))
- [#14058](https://github.com/Sylius/Sylius/issues/14058) [Admin][Zones] Choosing disabled country as a zone member made possible for admin user ([@TheMilek](https://github.com/TheMilek))
- [#14059](https://github.com/Sylius/Sylius/issues/14059) [Addressing] Enable orphan removal for zone members ([@coldic3](https://github.com/coldic3))
- [#14061](https://github.com/Sylius/Sylius/issues/14061) [Addressing] Fix adding and removing zone members again ([@coldic3](https://github.com/coldic3))
- [#14065](https://github.com/Sylius/Sylius/issues/14065) [Symfony 6] Fix zone member integrity listener ([@loic425](https://github.com/loic425))
- [#14067](https://github.com/Sylius/Sylius/issues/14067) [Addressing] Fix adding and removing zone members again (with API coverage only) ([@coldic3](https://github.com/coldic3))
- [#14070](https://github.com/Sylius/Sylius/issues/14070) [Maintenance] Fix Version20220407131547 migration ([@coldic3](https://github.com/coldic3))
- [#14071](https://github.com/Sylius/Sylius/issues/14071) [Addressing] Minor refactor ([@coldic3](https://github.com/coldic3))
- [#14081](https://github.com/Sylius/Sylius/issues/14081) Change deprecated PHPStan config ([@Zales0123](https://github.com/Zales0123))
- [#14082](https://github.com/Sylius/Sylius/issues/14082) Revert ReflectionExtractor hot-fix ([@Zales0123](https://github.com/Zales0123))
- [#14085](https://github.com/Sylius/Sylius/issues/14085) [Migrations] Minimum price migration fixed ([@TheMilek](https://github.com/TheMilek))
- [#14090](https://github.com/Sylius/Sylius/issues/14090) Fix calculate order item subtotal ([@vvasiloi](https://github.com/vvasiloi), [@AdamKasp](https://github.com/AdamKasp))
- [#14091](https://github.com/Sylius/Sylius/issues/14091) [Docs] Upgrade Plus installation guide ([@ernestWarwas](https://github.com/ernestWarwas))
- [#14095](https://github.com/Sylius/Sylius/issues/14095) [Fixtures] Add a fixture listener for removing images ([@GSadee](https://github.com/GSadee))
- [#14101](https://github.com/Sylius/Sylius/issues/14101) [Template][Events] Part of new UI bundle events for security and grid ([@ernestWarwas](https://github.com/ernestWarwas))
- [#14102](https://github.com/Sylius/Sylius/issues/14102) [Fixtures] Fix removing images before suite ([@GSadee](https://github.com/GSadee))
- [#14103](https://github.com/Sylius/Sylius/issues/14103) Tweet automatically about every new Sylius release ([@Zales0123](https://github.com/Zales0123))
- [#14105](https://github.com/Sylius/Sylius/issues/14105) Fix @javascript scenarios about channels menu taxon ([@Zales0123](https://github.com/Zales0123))
- [#14106](https://github.com/Sylius/Sylius/issues/14106) [Maintenance] Composer allow plugins finally sorted out + removal of symfony thanks ([@lchrusciel](https://github.com/lchrusciel))
- [#14108](https://github.com/Sylius/Sylius/issues/14108) [Templates] Move grid events to UI bundle ([@GSadee](https://github.com/GSadee))

## v1.11.5 (2022-05-13)

#### Details

- [#12868](https://github.com/Sylius/Sylius/issues/12868) Fix zone cannot contain itself validator ([@vvasiloi](https://github.com/vvasiloi))
- [#13847](https://github.com/Sylius/Sylius/issues/13847) [Maintenance]Run schema validation on mysql pipeline ([@Ferror](https://github.com/Ferror))
- [#13894](https://github.com/Sylius/Sylius/issues/13894) Using Sylius template event to change logo ([@arti0090](https://github.com/arti0090))
- [#13898](https://github.com/Sylius/Sylius/issues/13898) [maintenance][mailer]Assert that email is not null ([@Ferror](https://github.com/Ferror))
- [#13903](https://github.com/Sylius/Sylius/issues/13903) [Documentation] Improve and fix the release cycle documentation ([@Zales0123](https://github.com/Zales0123))
- [#13905](https://github.com/Sylius/Sylius/issues/13905) [AUTO] Updated translations from Crowdin (1.11) ([@SyliusBot](https://github.com/SyliusBot))
- [#13907](https://github.com/Sylius/Sylius/issues/13907) [Docs] Updated Sylius Plus installation guide - optional PDF Generator ([@Rafikooo](https://github.com/Rafikooo))
- [#13908](https://github.com/Sylius/Sylius/issues/13908) [DX] General refactor using ECS ([@coldic3](https://github.com/coldic3))
- [#13909](https://github.com/Sylius/Sylius/issues/13909) [Maintenance] Specify the default path in the ECS configuration ([@coldic3](https://github.com/coldic3))
- [#13919](https://github.com/Sylius/Sylius/issues/13919) [Maintenance][CI] Add Refactor workflow ([@coldic3](https://github.com/coldic3))
- [#13920](https://github.com/Sylius/Sylius/issues/13920) [Maintenance] Fix missing import in ECS config ([@coldic3](https://github.com/coldic3))
- [#13921](https://github.com/Sylius/Sylius/issues/13921) [1.11][User] Reduce usage of deprecated `\Serializable` interface #13642  ([@sad270](https://github.com/sad270))
- [#13929](https://github.com/Sylius/Sylius/issues/13929) Specify rough 1.12 release term and its planned content ([@Zales0123](https://github.com/Zales0123))
- [#13933](https://github.com/Sylius/Sylius/issues/13933) Bump flex to ^1.17, v1.13 - old infrastructure shutdown ([@em411](https://github.com/em411))
- [#13938](https://github.com/Sylius/Sylius/issues/13938) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions))
- [#13940](https://github.com/Sylius/Sylius/issues/13940) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions))
- [#13948](https://github.com/Sylius/Sylius/issues/13948) [Docs] add info about subresources ([@SirDomin](https://github.com/SirDomin), [@GSadee](https://github.com/GSadee))
- [#13959](https://github.com/Sylius/Sylius/issues/13959) [Docs] Favicon ([@Rafikooo](https://github.com/Rafikooo))
- [#13961](https://github.com/Sylius/Sylius/issues/13961) [GH] Store composer lock and generate diff ([@lchrusciel](https://github.com/lchrusciel))
- [#13966](https://github.com/Sylius/Sylius/issues/13966) Update orders.rst ([@groupecomplus](https://github.com/groupecomplus))

## v1.11.4 (2022-04-22)

#### Details

- [#13601](https://github.com/Sylius/Sylius/issues/13601) Use the Gaufrette FilesystemInterface instead of a concrete implementation ([@GSadee](https://github.com/GSadee), [@mbabker](https://github.com/mbabker))
- [#13841](https://github.com/Sylius/Sylius/issues/13841) [Maintenance] Add note to UPGRADE file about dropping Symfony 5.2 support ([@GSadee](https://github.com/GSadee))
- [#13844](https://github.com/Sylius/Sylius/issues/13844) [API][Swagger] Accept language header in SwaggerUI ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13848](https://github.com/Sylius/Sylius/issues/13848) [DOCS] Update index tip ([@arti0090](https://github.com/arti0090))
- [#13849](https://github.com/Sylius/Sylius/issues/13849) [API] Fix sorting products by price of their first variant ([@coldic3](https://github.com/coldic3))
- [#13852](https://github.com/Sylius/Sylius/issues/13852) [Maintenance] Run the build on tags rather than on releases ([@Zales0123](https://github.com/Zales0123))
- [#13857](https://github.com/Sylius/Sylius/issues/13857) [DOC] Bump minimal PHP version needed to install Sylius ([@Roshyo](https://github.com/Roshyo))
- [#13865](https://github.com/Sylius/Sylius/issues/13865) [Cart] Add Validator for localeCode ([@SirDomin](https://github.com/SirDomin))
- [#13866](https://github.com/Sylius/Sylius/issues/13866) [Maintenance] Relax conflict on liip imagine bundle - rebased version ([@Nek-](https://github.com/Nek-))
- [#13867](https://github.com/Sylius/Sylius/issues/13867) [Template][Events] Sylius template events - improvements ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13870](https://github.com/Sylius/Sylius/issues/13870) [ShippingMethod] Change shipping rule to be based on items total instead of order total ([@GSadee](https://github.com/GSadee), [@mdevlamynck](https://github.com/mdevlamynck))
- [#13875](https://github.com/Sylius/Sylius/issues/13875) [Swagger] Enum with available locale codes in Accept-Language header ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13876](https://github.com/Sylius/Sylius/issues/13876) [API] Refactor FilterEagerLoadingExtension ([@coldic3](https://github.com/coldic3))
- [#13878](https://github.com/Sylius/Sylius/issues/13878) [Template] Variant name instead of product name ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13886](https://github.com/Sylius/Sylius/issues/13886) [Templates][Admin] Refactor order payments template to use events ([@coldic3](https://github.com/coldic3))
- [#13888](https://github.com/Sylius/Sylius/issues/13888) [Documentation] Fix the description of items total shipping rules ([@GSadee](https://github.com/GSadee))
- [#13890](https://github.com/Sylius/Sylius/issues/13890) [maintenance]Fix ECS HeaderCommentFixer ([@Ferror](https://github.com/Ferror))
- [#13891](https://github.com/Sylius/Sylius/issues/13891) [maintenance]Run ECS in parallel ([@Ferror](https://github.com/Ferror))

## v1.11.3 (2022-04-08)

#### Details

- [#11850](https://github.com/Sylius/Sylius/issues/11850) Fix redirection when there is a trailing slash in the products list path ([@loic425](https://github.com/loic425))
- [#12538](https://github.com/Sylius/Sylius/issues/12538) [Behat] Allow to use some useful methods on Order show page ([@loic425](https://github.com/loic425))
- [#13724](https://github.com/Sylius/Sylius/issues/13724) Fix disappearing products in Admin Panel when translation for current locale is missing ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#13736](https://github.com/Sylius/Sylius/issues/13736) [Maintenance] Testing with PHP 8.1 ([@loic425](https://github.com/loic425))
- [#13744](https://github.com/Sylius/Sylius/issues/13744) [Maintenance]Ignore phpstan.neon file ([@Ferror](https://github.com/Ferror))
- [#13745](https://github.com/Sylius/Sylius/issues/13745) [Promotion] Add validation of coupon usage limit per customer ([@coldic3](https://github.com/coldic3))
- [#13753](https://github.com/Sylius/Sylius/issues/13753) [UI] Replacing the placeholder avatar with an icon ([@mamazu](https://github.com/mamazu))
- [#13759](https://github.com/Sylius/Sylius/issues/13759) [Behat] Use "When" for user actions where possible ([@coldic3](https://github.com/coldic3))
- [#13767](https://github.com/Sylius/Sylius/issues/13767) Change sylius.behat.context.ui.email context to sylius.behat.context.api.email ([@Ferror](https://github.com/Ferror))
- [#13768](https://github.com/Sylius/Sylius/issues/13768) Bump Psalm version to 4.19 (php 8.1 support) ([@loic425](https://github.com/loic425))
- [#13769](https://github.com/Sylius/Sylius/issues/13769) [Core][Shipping] Fix estimated shipping costs ([@coldic3](https://github.com/coldic3), [@lchrusciel](https://github.com/lchrusciel))
- [#13770](https://github.com/Sylius/Sylius/issues/13770) [ADR] Clean up existing ADRs mostly by updating their statuses ([@GSadee](https://github.com/GSadee))
- [#13772](https://github.com/Sylius/Sylius/issues/13772) [ADR][API] Update ADR for providing locales after changing the approach ([@GSadee](https://github.com/GSadee))
- [#13775](https://github.com/Sylius/Sylius/issues/13775) [Behat][API] Change the undefined step to create a configurable product instead of simple one ([@GSadee](https://github.com/GSadee))
- [#13779](https://github.com/Sylius/Sylius/issues/13779) [Documentation][Plus] Update cookbook about restricting access to the entity ([@GSadee](https://github.com/GSadee))
- [#13782](https://github.com/Sylius/Sylius/issues/13782) [Plus] Fix Sylius installation guide ([@lchrusciel](https://github.com/lchrusciel))
- [#13787](https://github.com/Sylius/Sylius/issues/13787) [ADR] Use raw data in commands and events ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13790](https://github.com/Sylius/Sylius/issues/13790) [Maintenance] Update UPGRADE-1.11.md ([@coldic3](https://github.com/coldic3))
- [#13795](https://github.com/Sylius/Sylius/issues/13795) [ADR] Remove flush() from handlers. ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13798](https://github.com/Sylius/Sylius/issues/13798) [Events] Sylius template event forms ([@SirDomin](https://github.com/SirDomin))
- [#13799](https://github.com/Sylius/Sylius/issues/13799) [Core][Shipping] Deprecate processing shipments before recalculating prices ([@coldic3](https://github.com/coldic3))
- [#13801](https://github.com/Sylius/Sylius/issues/13801) [Behat] added context to manage non-collection subresources ([@emmanuel-tilleuls](https://github.com/emmanuel-tilleuls))
- [#13802](https://github.com/Sylius/Sylius/issues/13802) [Docs] Add a guide on how to deal with file access problems in the wkhtmltopdf ([@coldic3](https://github.com/coldic3))
- [#13803](https://github.com/Sylius/Sylius/issues/13803) [Admin][JS] Applying all the options selected for an attribute of type multiple select fixed ([@TheMilek](https://github.com/TheMilek))
- [#13805](https://github.com/Sylius/Sylius/issues/13805) [JS] Not render empty value in multi select autocompletes ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13809](https://github.com/Sylius/Sylius/issues/13809) [Documentation] Fix build by specifying jinja2 version requirement ([@GSadee](https://github.com/GSadee))
- [#13811](https://github.com/Sylius/Sylius/issues/13811) [Documentation][Plus] Adjust installation guide after entities refactor ([@GSadee](https://github.com/GSadee))
- [#13817](https://github.com/Sylius/Sylius/issues/13817) [Admin] Clean up and refactor new template events ([@GSadee](https://github.com/GSadee))
- [#13818](https://github.com/Sylius/Sylius/issues/13818) [Maintenance] Bump copyright year in docs and license files ([@coldic3](https://github.com/coldic3))
- [#13828](https://github.com/Sylius/Sylius/issues/13828) [Maintenance] Fix a misleading description ([@GSadee](https://github.com/GSadee))
- [#13839](https://github.com/Sylius/Sylius/issues/13839) Limit the number of packages build run on 1.10 ([@Zales0123](https://github.com/Zales0123))
- [#13840](https://github.com/Sylius/Sylius/issues/13840) [GitHub Actions] Fix symfony/flex in workflows and invalid EngineInterface namespace ([@coldic3](https://github.com/coldic3))

## v1.11.2 (2022-03-14)

#### Details

- [#13432](https://github.com/Sylius/Sylius/issues/13432) Update SalesDataProvider.php ([@remoteclient](https://github.com/remoteclient))
- [#13723](https://github.com/Sylius/Sylius/issues/13723) [Docs] Deployment on artifakt ([@AdamKasp](https://github.com/AdamKasp))
- [#13731](https://github.com/Sylius/Sylius/issues/13731) [Taxation] Add validation of negative tax rate ([@coldic3](https://github.com/coldic3))
- [#13734](https://github.com/Sylius/Sylius/issues/13734) [JS] add empty value to autocomplete selects ([@SirDomin](https://github.com/SirDomin))
- [#13735](https://github.com/Sylius/Sylius/issues/13735) [Docs] add note to translation ([@AdamKasp](https://github.com/AdamKasp))
- [#13737](https://github.com/Sylius/Sylius/issues/13737) [Admin] Fix undefined labels in taxon autocomplete ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13738](https://github.com/Sylius/Sylius/issues/13738) [Docs] Synchronous messenger transport ([@Rafikooo](https://github.com/Rafikooo))
- [#13750](https://github.com/Sylius/Sylius/issues/13750) [Admin][Shop] placehold.it replaced to local placeholders ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13751](https://github.com/Sylius/Sylius/issues/13751) [Docs] Blank line removed ([@Rafikooo](https://github.com/Rafikooo))
- [#13756](https://github.com/Sylius/Sylius/issues/13756) [GitHub Actions] Change PHP ini values + clear cache ([@GSadee](https://github.com/GSadee))
- [#13765](https://github.com/Sylius/Sylius/issues/13765) [Security] Fixes for SVG XSS, wrong cache for logged in users and clickjacking ([@ernestWarwas](https://github.com/ernestWarwas), [@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee), [@Zales0123](https://github.com/Zales0123), [@Rafikooo](https://github.com/Rafikooo))
- [#13766](https://github.com/Sylius/Sylius/issues/13766) [Security][API] passwordResetToken nulled after password is changed ([@lchrusciel](https://github.com/lchrusciel), [@ernestWarwas](https://github.com/ernestWarwas), [@GSadee](https://github.com/GSadee), [@TheMilek](https://github.com/TheMilek))

## v1.11.1 (2022-03-07)

#### Details

- [#13575](https://github.com/Sylius/Sylius/issues/13575) [DX] add correct return type to getAdjustments method ([@PILLOWPET](https://github.com/PILLOWPET))
- [#13641](https://github.com/Sylius/Sylius/issues/13641) [ADR] Declaring services as public in container ([@lchrusciel](https://github.com/lchrusciel))
- [#13647](https://github.com/Sylius/Sylius/issues/13647) Update Sylius supported versions ([@Zales0123](https://github.com/Zales0123))
- [#13650](https://github.com/Sylius/Sylius/issues/13650) [Documentation] Update installation guide for Plus ([@GSadee](https://github.com/GSadee))
- [#13651](https://github.com/Sylius/Sylius/issues/13651) [Admin][API] Catalog promotion actions validation fixed ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13658](https://github.com/Sylius/Sylius/issues/13658) [Documentation] Adjust installation guide for Plus on 1.11 ([@GSadee](https://github.com/GSadee))
- [#13660](https://github.com/Sylius/Sylius/issues/13660) [CLI] Cancel unpaid orders command ([@rafalswierczek](https://github.com/rafalswierczek))
- [#13673](https://github.com/Sylius/Sylius/issues/13673) [Psalm] Configuration - totallyTyped replaced according to docs to avoid deprecation problem ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13676](https://github.com/Sylius/Sylius/issues/13676) [Cart] Fix retrieving/overriding cart of logged in user by guest ([@SirDomin](https://github.com/SirDomin), [@GSadee](https://github.com/GSadee))
- [#13679](https://github.com/Sylius/Sylius/issues/13679) [Docs] [AdminBundle] fix minor typo ([@gigamarr](https://github.com/gigamarr))
- [#13683](https://github.com/Sylius/Sylius/issues/13683) Improve verbosity of canceling unpaid orders test ([@rafalswierczek](https://github.com/rafalswierczek))
- [#13684](https://github.com/Sylius/Sylius/issues/13684) [Product][API][Bug] Fixed product sorting by translated names ([@Rafikooo](https://github.com/Rafikooo))
- [#13687](https://github.com/Sylius/Sylius/issues/13687) [Behat][API] Remove duplicated steps in ProductContext ([@GSadee](https://github.com/GSadee))
- [#13691](https://github.com/Sylius/Sylius/issues/13691) [Docs] Force user to login during checkout ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13692](https://github.com/Sylius/Sylius/issues/13692) [Admin] Fix for floating point amount on fixed action in catalog promotion. ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13695](https://github.com/Sylius/Sylius/issues/13695) [Order] Change getters and setters to use a proper flag name ([@GSadee](https://github.com/GSadee))
- [#13698](https://github.com/Sylius/Sylius/issues/13698) [Docs] Path fix for validator in API force login cookbook ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13699](https://github.com/Sylius/Sylius/issues/13699) [Documentation] Add reference to the cookbook about forcing login in API ([@GSadee](https://github.com/GSadee))
- [#13700](https://github.com/Sylius/Sylius/issues/13700) [Order] Fix getters and setters to use a proper flag name after upmerge issue ([@GSadee](https://github.com/GSadee))
- [#13704](https://github.com/Sylius/Sylius/issues/13704) Update PHP Version in installation doc ([@sad270](https://github.com/sad270))
- [#13708](https://github.com/Sylius/Sylius/issues/13708) [Locale] Add header based locale context ([@AdamKasp](https://github.com/AdamKasp))
- [#13715](https://github.com/Sylius/Sylius/issues/13715) add dependency injection conflict ([@SirDomin](https://github.com/SirDomin))
- [#13716](https://github.com/Sylius/Sylius/issues/13716) [Documentation] Fix start date of development 1.12 version ([@GSadee](https://github.com/GSadee))
- [#13725](https://github.com/Sylius/Sylius/issues/13725) [PaypalExpress] Dont take shipping tax adjustment to shipping cost ([@SirDomin](https://github.com/SirDomin))
- [#13730](https://github.com/Sylius/Sylius/issues/13730) [Maintenance] Add conflict to symfony/framework-bundle to fix problem with solving path prefix in API scenarios ([@GSadee](https://github.com/GSadee))
- [#13732](https://github.com/Sylius/Sylius/issues/13732) [Hot-fix] Conflict with symfony/dependency-injection even more ([@Zales0123](https://github.com/Zales0123))

## v1.11.0 (2022-02-14)

#### TL;DR

Final-**final** fixes for CatalogPromotions' system

#### Details

- [#13632](https://github.com/Sylius/Sylius/issues/13632) Add time for start and end date in catalog promotions index ()
- [#13638](https://github.com/Sylius/Sylius/issues/13638) [CatalogPromotion] Code improvements ([@Rafikooo](https://github.com/Rafikooo))
- [#13639](https://github.com/Sylius/Sylius/issues/13639) [UI][CatalogPromotion] Fix to not displaying duplicated validation message for fixed discount action ([@GSadee](https://github.com/GSadee))
- [#13644](https://github.com/Sylius/Sylius/issues/13644) [Maintenance] Minor clean up of UPGRADE files for Sylius 1.11 ([@GSadee](https://github.com/GSadee))

## v1.11.0-RC.1 (2022-02-10)

#### TL;DR

Final fixes for Catalog Promotions' system

#### Details

- [#13431](https://github.com/Sylius/Sylius/issues/13431) FIX: Avoid passing empty needle to strpos() ([@rimas-kudelis](https://github.com/rimas-kudelis))
- [#13588](https://github.com/Sylius/Sylius/issues/13588) Use semantic ui view instead of deprecated semantic_ui_translated ([@loic425](https://github.com/loic425))
- [#13604](https://github.com/Sylius/Sylius/issues/13604) [CatalogPromotion][UI][Shop] Fixed label displaying after option change ([@Rafikooo](https://github.com/Rafikooo))
- [#13606](https://github.com/Sylius/Sylius/issues/13606) [Catalog Promotion] Add exclusive flag to UI ([@AdamKasp](https://github.com/AdamKasp))
- [#13607](https://github.com/Sylius/Sylius/issues/13607) [Catalog Promotion][UI] Fixed error when trying to save catalog promotion with empty percentage discount value ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13608](https://github.com/Sylius/Sylius/issues/13608) [Catalog Promotion] Improve fixtures ([@AdamKasp](https://github.com/AdamKasp))
- [#13611](https://github.com/Sylius/Sylius/issues/13611) Optimize variant autocomplete selector ([@rafal](https://github.com/rafal).[@swierczek](https://github.com/swierczek)@[@drophub](https://github.com/drophub).[@pl](https://github.com/pl))
- [#13614](https://github.com/Sylius/Sylius/issues/13614) [Maintenance] Add info about messenger transport and api_platform directory to UPGRADE files ([@GSadee](https://github.com/GSadee))
- [#13616](https://github.com/Sylius/Sylius/issues/13616) [Behat][API] Fixed adding simple product scenarios ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13620](https://github.com/Sylius/Sylius/issues/13620) Changes in Catalog Promotions validation ([@Zales0123](https://github.com/Zales0123))
- [#13623](https://github.com/Sylius/Sylius/issues/13623) [Core] Reorganize namespaces of services related with catalog promotions ([@GSadee](https://github.com/GSadee))
- [#13624](https://github.com/Sylius/Sylius/issues/13624) [CatalogPromotions] Refactor processing catalog promotions states to use commands ([@GSadee](https://github.com/GSadee))
- [#13626](https://github.com/Sylius/Sylius/issues/13626) [Behat][Api] Second part of fixing simple product creation in api tests ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13627](https://github.com/Sylius/Sylius/issues/13627) Move ScopeValidatorInterface to PromotionBundle ([@Zales0123](https://github.com/Zales0123))
- [#13629](https://github.com/Sylius/Sylius/issues/13629) [Catalog Promotion] Fix priorities fixtures ([@AdamKasp](https://github.com/AdamKasp))
- [#13630](https://github.com/Sylius/Sylius/issues/13630) [Docs][Catalog Promotion] Warning added to docs ([@AdamKasp](https://github.com/AdamKasp))
- [#13633](https://github.com/Sylius/Sylius/issues/13633) [UPGRADE] Add more details about PHP, mocker container and api platform folder ([@lchrusciel](https://github.com/lchrusciel))
- [#13635](https://github.com/Sylius/Sylius/issues/13635) [Docs] Drop warning about active, not applied promotions as states are handled in async manner as well ([@lchrusciel](https://github.com/lchrusciel))
- [#13637](https://github.com/Sylius/Sylius/issues/13637) [CatalogPromotion] Move scope validator and constraint to PromotionBundle ([@GSadee](https://github.com/GSadee)

## v1.11.0-BETA.1 (2022-02-04)

#### TL;DR

- process variants instead of promotions to allow easier batching and performance improvements
- general improvements and fixes for Catalog Promotion and Shop API

#### Details

- [#13466](https://github.com/Sylius/Sylius/issues/13466) move default criteria to catalog promotion provider ([@AdamKasp](https://github.com/AdamKasp), [@Rafikooo](https://github.com/Rafikooo))
- [#13523](https://github.com/Sylius/Sylius/issues/13523) Improving the documentation ([@mamazu](https://github.com/mamazu))
- [#13535](https://github.com/Sylius/Sylius/issues/13535) [Minor] Removal of logic duplication in shipping charges processor ([@lchrusciel](https://github.com/lchrusciel))
- [#13536](https://github.com/Sylius/Sylius/issues/13536) Refactor catalog promotions - process variants instead promotion ([@AdamKasp](https://github.com/AdamKasp))
- [#13538](https://github.com/Sylius/Sylius/issues/13538) [CatalogPromotion] Apply catalog promotions for product created in catalog promotions scope ([@ernestWarwas](https://github.com/ernestWarwas), [@GSadee](https://github.com/GSadee))
- [#13542](https://github.com/Sylius/Sylius/issues/13542) Specify explicit priorities for all form type extensions ([@rimas-kudelis](https://github.com/rimas-kudelis))
- [#13545](https://github.com/Sylius/Sylius/issues/13545) [Core][Optimalization] Assign fallback locale for command based requests ([@SirDomin](https://github.com/SirDomin))
- [#13546](https://github.com/Sylius/Sylius/issues/13546) [Admin][UI] Catalog promotions UI fixes ([@SirDomin](https://github.com/SirDomin))
- [#13547](https://github.com/Sylius/Sylius/issues/13547) [Promotion] Fix js errors associated with actions/rules/scopes ([@GSadee](https://github.com/GSadee))
- [#13548](https://github.com/Sylius/Sylius/issues/13548) [Maintenance] Remove phpstan exclude for PHP7.4 ([@lchrusciel](https://github.com/lchrusciel))
- [#13550](https://github.com/Sylius/Sylius/issues/13550) [CatalogPromotion] Process all catalog promotions when catalog promotion is created ([@SirDomin](https://github.com/SirDomin))
- [#13551](https://github.com/Sylius/Sylius/issues/13551) [UI][Admin] add divider after form elements ([@SirDomin](https://github.com/SirDomin))
- [#13552](https://github.com/Sylius/Sylius/issues/13552) Fixing the documentation (1.10) ([@mamazu](https://github.com/mamazu))
- [#13553](https://github.com/Sylius/Sylius/issues/13553) [Fixtures] USA deleted from the World zone ([@TheMilek](https://github.com/TheMilek))
- [#13555](https://github.com/Sylius/Sylius/issues/13555) [Core][Optimalization] Assign fallback locale for command based requests ([@lchrusciel](https://github.com/lchrusciel))
- [#13556](https://github.com/Sylius/Sylius/issues/13556) [Behat] Scenario for creating an exclusive catalog promotion ([@TheMilek](https://github.com/TheMilek))
- [#13557](https://github.com/Sylius/Sylius/issues/13557) [Promotion] Use sylius/calendar instead of the existing Calendar ([@GSadee](https://github.com/GSadee))
- [#13558](https://github.com/Sylius/Sylius/issues/13558) [Shipping][Behat] Use sylius/calendar instead of the existing Calendar ([@GSadee](https://github.com/GSadee))
- [#13561](https://github.com/Sylius/Sylius/issues/13561) [Docs] Mention autoconfiguration case when extending the form ([@Zales0123](https://github.com/Zales0123))
- [#13562](https://github.com/Sylius/Sylius/issues/13562) PHP 8.0 syntax in bundles (without CoreBundle and ApiBundle) ([@Zales0123](https://github.com/Zales0123))
- [#13563](https://github.com/Sylius/Sylius/issues/13563) [API][UI][Behat][Refactor] OriginalUnitPrice property on the OrderItem entity ([@Rafikooo](https://github.com/Rafikooo))
- [#13565](https://github.com/Sylius/Sylius/issues/13565) PHP 8.0 syntax in Core Bundle ([@Zales0123](https://github.com/Zales0123))
- [#13566](https://github.com/Sylius/Sylius/issues/13566) [Catalog Promotion] Privatize function in CP clearer and remove redundant channelPricing repository ([@AdamKasp](https://github.com/AdamKasp))
- [#13567](https://github.com/Sylius/Sylius/issues/13567) [Catalog Promotion] ProductVariantForCatalogPromotionEligibility refactored ([@AdamKasp](https://github.com/AdamKasp))
- [#13569](https://github.com/Sylius/Sylius/issues/13569) [Catalog Promotion] Catalog promotion states refactor ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13570](https://github.com/Sylius/Sylius/issues/13570) PHP 8.0 syntax in ApiBundle ([@Zales0123](https://github.com/Zales0123))
- [#13576](https://github.com/Sylius/Sylius/issues/13576) [Catalog Promotion] Select more data during processing to avoid inefficient db calls ([@lchrusciel](https://github.com/lchrusciel))
- [#13577](https://github.com/Sylius/Sylius/issues/13577) [Catalog Promotion] Removal of unused function ([@lchrusciel](https://github.com/lchrusciel))
- [#13578](https://github.com/Sylius/Sylius/issues/13578) [Catalog Promotion] add update variant event to messenger routing ([@AdamKasp](https://github.com/AdamKasp))
- [#13579](https://github.com/Sylius/Sylius/issues/13579) [Catalog Promotion] Move catalog promotion processing after the fixture execution ([@lchrusciel](https://github.com/lchrusciel))
- [#13580](https://github.com/Sylius/Sylius/issues/13580) Bump Psalm version to 4.19 (php 8.1 support) ([@loic425](https://github.com/loic425))
- [#13581](https://github.com/Sylius/Sylius/issues/13581) [Catalog Promotion] Refactor - rename AllCatalogPromotionsProcessor ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13584](https://github.com/Sylius/Sylius/issues/13584) Update catalog promotion instantly if date is set on future ([@SirDomin](https://github.com/SirDomin))
- [#13585](https://github.com/Sylius/Sylius/issues/13585) [Catalog Promotion] [Docs] docs updated ([@AdamKasp](https://github.com/AdamKasp))
- [#13587](https://github.com/Sylius/Sylius/issues/13587) [CatalogPromotion] batch configuration size made a part of config ([@TheMilek](https://github.com/TheMilek))
- [#13589](https://github.com/Sylius/Sylius/issues/13589) [Catalog Promotion] remove redundant method ([@AdamKasp](https://github.com/AdamKasp))
- [#13591](https://github.com/Sylius/Sylius/issues/13591) [Catalog Promotion][Docs] update CP scopes docs ([@AdamKasp](https://github.com/AdamKasp))
- [#13592](https://github.com/Sylius/Sylius/issues/13592) [Migration] add migration to messenger if transport is configured to doctrine ([@SirDomin](https://github.com/SirDomin))
- [#13593](https://github.com/Sylius/Sylius/issues/13593) [Catalog Promotions] State processing after fixtures load ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13594](https://github.com/Sylius/Sylius/issues/13594) [Catalog Promotion][Test] Assert proper batch size configuration ([@lchrusciel](https://github.com/lchrusciel))
- [#13595](https://github.com/Sylius/Sylius/issues/13595) [Docs] Configuring catalog promotions batch sizes explained ([@TheMilek](https://github.com/TheMilek))
- [#13596](https://github.com/Sylius/Sylius/issues/13596) [Cookbook] Minor fixes in custom catalog promotion scope ([@GSadee](https://github.com/GSadee))
- [#13597](https://github.com/Sylius/Sylius/issues/13597) Core Configuration style and tests improvements ([@Zales0123](https://github.com/Zales0123))

## v1.11.0-ALPHA.2 (2022-01-24)

#### TL;DR

Improvements and fixes in Catalog Promotion and Shop API

#### Details

- [#12549](https://github.com/Sylius/Sylius/issues/12549) [Product Variant] Price Calculator fixed to return always int ([@lruozzi9](https://github.com/lruozzi9))
- [#12759](https://github.com/Sylius/Sylius/issues/12759) Use phpspec ^7.1 and avoid custom error reporting level in its configuration ([@pamil](https://github.com/pamil))
- [#13214](https://github.com/Sylius/Sylius/issues/13214) Replace `json_array` with `json` type as requested by the deprecation ([@Prometee](https://github.com/Prometee))
- [#13251](https://github.com/Sylius/Sylius/issues/13251) Change all MasterRequest calls to MainRequest ([@Roshyo](https://github.com/Roshyo))
- [#13379](https://github.com/Sylius/Sylius/issues/13379) [Bug][Migrations] Add missing `mysql` check for our migrations to ensure proper syntax is available ([@lchrusciel](https://github.com/lchrusciel))
- [#13386](https://github.com/Sylius/Sylius/issues/13386) [Docs] Catalog promotion label customization ([@AdamKasp](https://github.com/AdamKasp))
- [#13389](https://github.com/Sylius/Sylius/issues/13389) [Catalog Promotion] Moved labels to separate twig ([@AdamKasp](https://github.com/AdamKasp))
- [#13392](https://github.com/Sylius/Sylius/issues/13392) [Minor] Update possible branch version in GitHub PR template ([@lchrusciel](https://github.com/lchrusciel))
- [#13393](https://github.com/Sylius/Sylius/issues/13393) [BUG] Check action type for fixed promotion ([@SirDomin](https://github.com/SirDomin))
- [#13396](https://github.com/Sylius/Sylius/issues/13396) [API] Doctrine extension parameter names and aliases refactor ([@TheMilek](https://github.com/TheMilek))
- [#13397](https://github.com/Sylius/Sylius/issues/13397) [CatalogPromotion][Admin] Fix displaying fixed discount action on catalog show page ([@GSadee](https://github.com/GSadee))
- [#13398](https://github.com/Sylius/Sylius/issues/13398) [Documentation][CatalogPromotion] Add cookbook about creating a custom action + minor improvements ([@GSadee](https://github.com/GSadee))
- [#13400](https://github.com/Sylius/Sylius/issues/13400) [API][SHOP] serialization of ShippingMethod and ProductOption - dynamic translation refactor ([@TheMilek](https://github.com/TheMilek))
- [#13401](https://github.com/Sylius/Sylius/issues/13401) [Translations][Shop][API] Dynamic serialization of translations for a Product, ProductVariant and Taxon entities ([@Rafikooo](https://github.com/Rafikooo))
- [#13403](https://github.com/Sylius/Sylius/issues/13403) [RFC][CatalogPromotion] Refactor actions and scopes to dynamically set parameters with types without obligatory getType method ([@GSadee](https://github.com/GSadee), [@lchrusciel](https://github.com/lchrusciel))
- [#13405](https://github.com/Sylius/Sylius/issues/13405) Class name typo ([@TheDevilOnLine](https://github.com/TheDevilOnLine))
- [#13407](https://github.com/Sylius/Sylius/issues/13407) Remove invalid PHP version from PHPSpec build ([@Zales0123](https://github.com/Zales0123))
- [#13408](https://github.com/Sylius/Sylius/issues/13408) [CatalogPromotion] Add compiler pass tests for setting action/scope types parameters ([@GSadee](https://github.com/GSadee))
- [#13409](https://github.com/Sylius/Sylius/issues/13409) [Shop][API] Contract tests for an Address resource, customer authorization refactor ([@Rafikooo](https://github.com/Rafikooo))
- [#13410](https://github.com/Sylius/Sylius/issues/13410) [Test][API][Refactor] CardContext, ProductVariant and Taxon resource  ([@Rafikooo](https://github.com/Rafikooo))
- [#13412](https://github.com/Sylius/Sylius/issues/13412) [API][SHOP] serialization of Payment and PaymentMethod - dynamic translation refactor ([@TheMilek](https://github.com/TheMilek))
- [#13415](https://github.com/Sylius/Sylius/issues/13415) [Shop][Api] Translatable resources api docs, included slug field in a Taxon and Product responses ([@Rafikooo](https://github.com/Rafikooo))
- [#13421](https://github.com/Sylius/Sylius/issues/13421) [Docs] How to customize the invoice logo - updated cookbook ([@Rafikooo](https://github.com/Rafikooo))
- [#13423](https://github.com/Sylius/Sylius/issues/13423) [Docs] Customizing Credit Memo's logo ([@TheMilek](https://github.com/TheMilek))
- [#13426](https://github.com/Sylius/Sylius/issues/13426) Architecture tests initialization  ([@Zales0123](https://github.com/Zales0123))
- [#13427](https://github.com/Sylius/Sylius/issues/13427) [Minor] Lineup documentation ([@lchrusciel](https://github.com/lchrusciel))
- [#13428](https://github.com/Sylius/Sylius/issues/13428) Symfony2 is no more 💃 ([@Zales0123](https://github.com/Zales0123))
- [#13430](https://github.com/Sylius/Sylius/issues/13430) [Maintenance] Do not skip auto-configuration tests ([@lchrusciel](https://github.com/lchrusciel))
- [#13435](https://github.com/Sylius/Sylius/issues/13435) [Behat] [Taxons] Fixed issue with asserting Taxons ([@TheDevilOnLine](https://github.com/TheDevilOnLine))
- [#13436](https://github.com/Sylius/Sylius/issues/13436) [CatalogPromotion] Fix dates in contract tests ([@GSadee](https://github.com/GSadee))
- [#13439](https://github.com/Sylius/Sylius/issues/13439) Recalculate cart on remove item ([@SirDomin](https://github.com/SirDomin))
- [#13451](https://github.com/Sylius/Sylius/issues/13451) [docs] fix catalog promotion async tip ([@AdamKasp](https://github.com/AdamKasp))
- [#13453](https://github.com/Sylius/Sylius/issues/13453) [Order][API] Translation deleted from payment patch response ([@TheMilek](https://github.com/TheMilek))
- [#13454](https://github.com/Sylius/Sylius/issues/13454) Using phparkitect github actions ([@AlessandroMinoccheri](https://github.com/AlessandroMinoccheri))
- [#13455](https://github.com/Sylius/Sylius/issues/13455) Delay 1.11 one more time ([@Zales0123](https://github.com/Zales0123))
- [#13458](https://github.com/Sylius/Sylius/issues/13458) Applied promotion information formatter service configuration cleanup ([@Rafikooo](https://github.com/Rafikooo))
- [#13459](https://github.com/Sylius/Sylius/issues/13459) [API] Bring back SwaggerUI overriding ([@lchrusciel](https://github.com/lchrusciel))
- [#13464](https://github.com/Sylius/Sylius/issues/13464) Bugfix: display full cart promotion rule form when adding a new rule ([@rimas-kudelis](https://github.com/rimas-kudelis))
- [#13465](https://github.com/Sylius/Sylius/issues/13465) Catalog promotion priority ([@Rafikooo](https://github.com/Rafikooo))
- [#13468](https://github.com/Sylius/Sylius/issues/13468) [CatalogPromotion] Rename actions and scopes ([@SirDomin](https://github.com/SirDomin))
- [#13469](https://github.com/Sylius/Sylius/issues/13469) [CatalogPromotions] Refactor CatalogPromotionsScopeType to remove dup… ([@SirDomin](https://github.com/SirDomin))
- [#13471](https://github.com/Sylius/Sylius/issues/13471) [CatalogPromotion] refactor action type ([@AdamKasp](https://github.com/AdamKasp))
- [#13472](https://github.com/Sylius/Sylius/issues/13472) [Docs] add info about hardcoded translations ([@SirDomin](https://github.com/SirDomin))
- [#13473](https://github.com/Sylius/Sylius/issues/13473) [CatalogPromotion] Introduce CatalogPromotionCreated event ([@GSadee](https://github.com/GSadee))
- [#13477](https://github.com/Sylius/Sylius/issues/13477) Validation deleted from PercentageDiscountActionConfigurationType ([@TheMilek](https://github.com/TheMilek))
- [#13479](https://github.com/Sylius/Sylius/issues/13479) [CatalogPromotion] Refactor names of listeners to be consistent with others ([@GSadee](https://github.com/GSadee))
- [#13480](https://github.com/Sylius/Sylius/issues/13480) [Minor][Behat] Change feature name to reflect convention and reality ([@lchrusciel](https://github.com/lchrusciel))
- [#13484](https://github.com/Sylius/Sylius/issues/13484) [CI] bin/console lint:container - command added to workflow ([@Rafikooo](https://github.com/Rafikooo))
- [#13490](https://github.com/Sylius/Sylius/issues/13490) Unify latest CHANGELOGs format with the previous ones ([@Zales0123](https://github.com/Zales0123))
- [#13491](https://github.com/Sylius/Sylius/issues/13491) [API][Minor] Archiving shipping methods filter rename to maintain naming convention ([@lchrusciel](https://github.com/lchrusciel))
- [#13495](https://github.com/Sylius/Sylius/issues/13495) [API] Doctrine filters moved below filters namespace ([@lchrusciel](https://github.com/lchrusciel))
- [#13498](https://github.com/Sylius/Sylius/issues/13498) [Docs] Sylius 1.8 is not supported anymore ([@Zales0123](https://github.com/Zales0123))
- [#13499](https://github.com/Sylius/Sylius/issues/13499) Refactor catalog promotion applicator ([@SirDomin](https://github.com/SirDomin))
- [#13502](https://github.com/Sylius/Sylius/issues/13502) Move to PHP8.0 syntax in Components ([@Zales0123](https://github.com/Zales0123))
- [#13504](https://github.com/Sylius/Sylius/issues/13504) Postpone 1.10 end of maintenance date ([@Zales0123](https://github.com/Zales0123))
- [#13506](https://github.com/Sylius/Sylius/issues/13506) [Docs] How to customize the invoice logo - neatly cut invoice image ([@Rafikooo](https://github.com/Rafikooo))
- [#13512](https://github.com/Sylius/Sylius/issues/13512) [CatalogPromotion] Extract dispatching catalog promotion events from listeners to a separate service ([@GSadee](https://github.com/GSadee))
- [#13513](https://github.com/Sylius/Sylius/issues/13513) [Architecture] Do not double install PHP dependencies ([@lchrusciel](https://github.com/lchrusciel))
- [#13514](https://github.com/Sylius/Sylius/issues/13514) [Documentation] Update Core Team in our documentation ([@lchrusciel](https://github.com/lchrusciel))
- [#13515](https://github.com/Sylius/Sylius/issues/13515) [Maintenance] Replace `test-package.sh` with native GH Actions ([@lchrusciel](https://github.com/lchrusciel))
- [#13516](https://github.com/Sylius/Sylius/issues/13516) [Maintenance] Remove NelmioAlice from the main packages config ([@lchrusciel](https://github.com/lchrusciel))
- [#13517](https://github.com/Sylius/Sylius/issues/13517) [Docs] Change the template path in customization ([@Roshyo](https://github.com/Roshyo))
- [#13519](https://github.com/Sylius/Sylius/issues/13519) [Docs] Altered custom invoice logo path ([@Rafikooo](https://github.com/Rafikooo))
- [#13520](https://github.com/Sylius/Sylius/issues/13520) change suggested path in refund docs ([@AdamKasp](https://github.com/AdamKasp))
- [#13527](https://github.com/Sylius/Sylius/issues/13527) [Minor] Typo fixes in github packages config ([@lchrusciel](https://github.com/lchrusciel))
- [#13530](https://github.com/Sylius/Sylius/issues/13530) [Build fix] Remove unneeded test package binary step ([@Zales0123](https://github.com/Zales0123))

## v1.11.0-ALPHA.1 (2021-12-14)

#### TL;DR

- NEW FEATURE 🎉🎉🎉 Catalog promotions management: CRUD, asynchronous application on variants, different scopes, priorities management, exclusiveness and many more
- New API improvements: especially the **Shop** part, reaching ~80% of UI features coverage
- Bump required PHP version to 8.0, due to the end of life of PHP 7.4
- Bump required Symfony 5 version to 5.4 LTS

#### Details

- [#12029](https://github.com/Sylius/Sylius/issues/12029) [BC BREAK] [API][BC-Break] Move commands and handlers to common namespace ([@lchrusciel](https://github.com/lchrusciel))
- [#12177](https://github.com/Sylius/Sylius/issues/12177) [Behat][API] Programitically generate API autorization token ([@lchrusciel](https://github.com/lchrusciel))
- [#12202](https://github.com/Sylius/Sylius/issues/12202) Feat: Add breadcrumb var in CRUD template for AdminBundle ([@toofff](https://github.com/toofff))
- [#12689](https://github.com/Sylius/Sylius/issues/12689) [API][Country] Initialize contract tests for api/v2 ([@GSadee](https://github.com/GSadee))
- [#12693](https://github.com/Sylius/Sylius/issues/12693) [API] allow extending and overwrite api in yaml + test ([@SirDomin](https://github.com/SirDomin))
- [#12695](https://github.com/Sylius/Sylius/issues/12695) [API][PaymentMethod] Add contract test for available payment methods endpoint ([@GSadee](https://github.com/GSadee))
- [#12700](https://github.com/Sylius/Sylius/issues/12700) [Docs] Docs customization ([@SirDomin](https://github.com/SirDomin))
- [#12703](https://github.com/Sylius/Sylius/issues/12703) [Api] Denying usage of unexisting promotion coupon ([@Tomanhez](https://github.com/Tomanhez))
- [#12704](https://github.com/Sylius/Sylius/issues/12704) [API] Denying usage of coupon for invalid promotion ([@Zales0123](https://github.com/Zales0123))
- [#12713](https://github.com/Sylius/Sylius/issues/12713) [API] Use serializer instead of custom view for shipping methods ([@GSadee](https://github.com/GSadee))
- [#12716](https://github.com/Sylius/Sylius/issues/12716) [API][ShippingMethod] Add contract test for available shipping methods endpoint ([@GSadee](https://github.com/GSadee))
- [#12718](https://github.com/Sylius/Sylius/issues/12718) [POC] Add change of tax by address ([@arti0090](https://github.com/arti0090))
- [#12719](https://github.com/Sylius/Sylius/issues/12719) [Api] Unnecessary addresses should not be saved to the database while addressing an order ([@Tomanhez](https://github.com/Tomanhez))
- [#12742](https://github.com/Sylius/Sylius/issues/12742) [API] Serialize only shipment id and method as shipment in order response ([@GSadee](https://github.com/GSadee))
- [#12743](https://github.com/Sylius/Sylius/issues/12743) [API] add final to clssess, cs fixes ([@SirDomin](https://github.com/SirDomin))
- [#12744](https://github.com/Sylius/Sylius/issues/12744) [Docs] fix unsetting filters ([@SirDomin](https://github.com/SirDomin))
- [#12745](https://github.com/Sylius/Sylius/issues/12745) [API] Add contract test to admin ProductVariant ([@arti0090](https://github.com/arti0090))
- [#12746](https://github.com/Sylius/Sylius/issues/12746) [API] handle shipping without addressing ([@SirDomin](https://github.com/SirDomin))
- [#12749](https://github.com/Sylius/Sylius/issues/12749) [API] change error to violation ([@SirDomin](https://github.com/SirDomin))
- [#12750](https://github.com/Sylius/Sylius/issues/12750) [ApiBundle] Small CS fixes ([@Zales0123](https://github.com/Zales0123))
- [#12761](https://github.com/Sylius/Sylius/issues/12761) [API] contract test for get order collection by guest ([@AdamKasp](https://github.com/AdamKasp))
- [#12766](https://github.com/Sylius/Sylius/issues/12766) [Locale]Available locales in channel by api ([@AdamKasp](https://github.com/AdamKasp))
- [#12769](https://github.com/Sylius/Sylius/issues/12769) [API] Refactor converting arguments of commands from IRIs to identifiers ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#12772](https://github.com/Sylius/Sylius/issues/12772) [ENHANCEMENT][API] Refactor Api Constraints to match rest of them ([@arti0090](https://github.com/arti0090))
- [#12774](https://github.com/Sylius/Sylius/issues/12774) [API] Add Product Image type to responses ([@arti0090](https://github.com/arti0090))
- [#12780](https://github.com/Sylius/Sylius/issues/12780) [Locale ][Api] Get locale refactor api ([@AdamKasp](https://github.com/AdamKasp))
- [#12782](https://github.com/Sylius/Sylius/issues/12782) [API] Check payment amount ([@Tomanhez](https://github.com/Tomanhez), [@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#12785](https://github.com/Sylius/Sylius/issues/12785) [API] Remove customer and serialize posted address ([@arti0090](https://github.com/arti0090))
- [#12790](https://github.com/Sylius/Sylius/issues/12790) [ENH][API] Fixing naming issues after PR for serializing post on address ([@arti0090](https://github.com/arti0090))
- [#12805](https://github.com/Sylius/Sylius/issues/12805) [Behat][API][Taxes] Turn on chunk of taxation related scenarios ([@lchrusciel](https://github.com/lchrusciel))
- [#12806](https://github.com/Sylius/Sylius/issues/12806) [Behat][API][Promotion] Turn on chunk of promotion scenarios ([@lchrusciel](https://github.com/lchrusciel))
- [#12830](https://github.com/Sylius/Sylius/issues/12830) [API] Exclude meaningless scenarios ([@lchrusciel](https://github.com/lchrusciel))
- [#12834](https://github.com/Sylius/Sylius/issues/12834) [Docs] Customization docs + yaml customization ([@SirDomin](https://github.com/SirDomin))
- [#12841](https://github.com/Sylius/Sylius/issues/12841) [UPGRADE] Split API and non API upgrade files ([@lchrusciel](https://github.com/lchrusciel))
- [#12842](https://github.com/Sylius/Sylius/issues/12842) [AUTO] Updated translations from Crowdin (master) ()
- [#12846](https://github.com/Sylius/Sylius/issues/12846) [BC BREAK] [API] Unification of filtration namespaces ([@lchrusciel](https://github.com/lchrusciel))
- [#12847](https://github.com/Sylius/Sylius/issues/12847) [API]Product image handling ([@arti0090](https://github.com/arti0090))
- [#12851](https://github.com/Sylius/Sylius/issues/12851) [Order] Protect processors from execution if the order is in a state different than cart ([@GSadee](https://github.com/GSadee))
- [#12854](https://github.com/Sylius/Sylius/issues/12854) [SM] Change priorities of State Machine callbacks ([@arti0090](https://github.com/arti0090))
- [#12855](https://github.com/Sylius/Sylius/issues/12855) [API][Country] Improve endpoints serialization ([@GSadee](https://github.com/GSadee))
- [#12856](https://github.com/Sylius/Sylius/issues/12856) [API] reduce customer update serialization ([@SirDomin](https://github.com/SirDomin))
- [#12858](https://github.com/Sylius/Sylius/issues/12858) [Core] Wrap resource update operation with a transaction ([@GSadee](https://github.com/GSadee))
- [#12862](https://github.com/Sylius/Sylius/issues/12862) [API] Add liip image filters to API ([@arti0090](https://github.com/arti0090), [@SirDomin](https://github.com/SirDomin))
- [#12866](https://github.com/Sylius/Sylius/issues/12866) Update release-cycle.rst ([@oallain](https://github.com/oallain))
- [#12874](https://github.com/Sylius/Sylius/issues/12874) [ORM] add created at index to customer ([@SirDomin](https://github.com/SirDomin))
- [#12876](https://github.com/Sylius/Sylius/issues/12876) [Minor] Add missing license blocks ([@lchrusciel](https://github.com/lchrusciel))
- [#12877](https://github.com/Sylius/Sylius/issues/12877) [API] add original price to product variant ([@SirDomin](https://github.com/SirDomin))
- [#12879](https://github.com/Sylius/Sylius/issues/12879) [DOCS] How to modify invoices ([@arti0090](https://github.com/arti0090))
- [#12880](https://github.com/Sylius/Sylius/issues/12880) [Maintenance] Configure builds on postgressql & mariadb ([@Arminek](https://github.com/Arminek))
- [#12883](https://github.com/Sylius/Sylius/issues/12883) [API] Rename original_price to originalPrice in api responses ([@AdamKasp](https://github.com/AdamKasp), [@arti0090](https://github.com/arti0090))
- [#12884](https://github.com/Sylius/Sylius/issues/12884) [Docs] add registration/login examples ([@SirDomin](https://github.com/SirDomin), [@arti0090](https://github.com/arti0090))
- [#12887](https://github.com/Sylius/Sylius/issues/12887) [DOCS] Generating invoice after payment ([@arti0090](https://github.com/arti0090))
- [#12888](https://github.com/Sylius/Sylius/issues/12888) [API] Fix formating for list in invoice cookbook ([@arti0090](https://github.com/arti0090))
- [#12889](https://github.com/Sylius/Sylius/issues/12889) Original price behat fix ([@arti0090](https://github.com/arti0090))
- [#12890](https://github.com/Sylius/Sylius/issues/12890) Fix to ordered list ([@arti0090](https://github.com/arti0090))
- [#12963](https://github.com/Sylius/Sylius/issues/12963) Update swagger docs with product variants originalPrice ([@arti0090](https://github.com/arti0090))
- [#12967](https://github.com/Sylius/Sylius/issues/12967) [API] Log in contract tests + minor fixes ([@lchrusciel](https://github.com/lchrusciel))
- [#12968](https://github.com/Sylius/Sylius/issues/12968) [API] AddressOrderHandler refactored to use customer provider ([@lchrusciel](https://github.com/lchrusciel))
- [#12969](https://github.com/Sylius/Sylius/issues/12969) [Maintenance] Dead code removal ([@lchrusciel](https://github.com/lchrusciel))
- [#12970](https://github.com/Sylius/Sylius/issues/12970) [DX] Add sylius prefixes to normalizers ALREADY_CALLED consts values to avoid name collision ([@lchrusciel](https://github.com/lchrusciel))
- [#12971](https://github.com/Sylius/Sylius/issues/12971) [DX] Adjust service names in ApiBundle ([@lchrusciel](https://github.com/lchrusciel))
- [#12972](https://github.com/Sylius/Sylius/issues/12972) [DOCS] Update images in api authorization book ([@arti0090](https://github.com/arti0090))
- [#12974](https://github.com/Sylius/Sylius/issues/12974) [Maintenance] Make all API Bundle services public and unify public notation ([@lchrusciel](https://github.com/lchrusciel))
- [#12978](https://github.com/Sylius/Sylius/issues/12978) [API] Resend verification email refactor to take current user from the security context ([@lchrusciel](https://github.com/lchrusciel))
- [#12979](https://github.com/Sylius/Sylius/issues/12979) [Minor] Adjust test class names to follow emerged convention ([@lchrusciel](https://github.com/lchrusciel))
- [#12980](https://github.com/Sylius/Sylius/issues/12980) [API] Expose taxon children as IRI in menu endpoint ([@lchrusciel](https://github.com/lchrusciel))
- [#12981](https://github.com/Sylius/Sylius/issues/12981) [API] Refactor current customer email aware commands ([@lchrusciel](https://github.com/lchrusciel))
- [#12983](https://github.com/Sylius/Sylius/issues/12983) [Documentation] Change the order of pages in Getting Started section ([@GSadee](https://github.com/GSadee))
- [#12986](https://github.com/Sylius/Sylius/issues/12986) [CatalogPromotion] Creating simple catalog promotion only with code and name ([@Arminek](https://github.com/Arminek), [@Tomanhez](https://github.com/Tomanhez))
- [#12990](https://github.com/Sylius/Sylius/issues/12990) [CatalogPromotions] Catalog promotion event ([@Tomanhez](https://github.com/Tomanhez), [@Arminek](https://github.com/Arminek))
- [#12994](https://github.com/Sylius/Sylius/issues/12994) Get, Update, Post and delete catalog promotions ([@arti0090](https://github.com/arti0090))
- [#12997](https://github.com/Sylius/Sylius/issues/12997) [API] Add gender field to customer ([@arti0090](https://github.com/arti0090))
- [#12998](https://github.com/Sylius/Sylius/issues/12998) [CatalogPromotion][API] Minor fixes to creating simple catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13001](https://github.com/Sylius/Sylius/issues/13001) [Catalog Promotions] add rule to catalog promotion ([@AdamKasp](https://github.com/AdamKasp), [@SirDomin](https://github.com/SirDomin))
- [#13002](https://github.com/Sylius/Sylius/issues/13002) [CatalogPromotion] Applying Catalog Promotion with hardcoded rule and action ([@Tomanhez](https://github.com/Tomanhez), [@Zales0123](https://github.com/Zales0123))
- [#13003](https://github.com/Sylius/Sylius/issues/13003) Fixes to endpoints and contract tests of CP ([@arti0090](https://github.com/arti0090))
- [#13005](https://github.com/Sylius/Sylius/issues/13005) [CatalogPromotion][API] Create catalog promotion with translatable fields ([@GSadee](https://github.com/GSadee))
- [#13008](https://github.com/Sylius/Sylius/issues/13008) [Catalog Promotions] Add behat scenarios for endpoints ([@arti0090](https://github.com/arti0090))
- [#13009](https://github.com/Sylius/Sylius/issues/13009) [CatalogPromotion][API] Add channels to catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13010](https://github.com/Sylius/Sylius/issues/13010) [Catalog Promotion] Remove delete endpoint ([@arti0090](https://github.com/arti0090))
- [#13011](https://github.com/Sylius/Sylius/issues/13011) [CatalogPromotion][API] Add simple validation for creating catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13013](https://github.com/Sylius/Sylius/issues/13013) [CatalogPromotion][API] Extend the possibility of editing catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13014](https://github.com/Sylius/Sylius/issues/13014) [CatalogPromotion] Use Catalog Promotion rule during application ([@Zales0123](https://github.com/Zales0123))
- [#13015](https://github.com/Sylius/Sylius/issues/13015) [CatalogPromotion] Add fixtures for catalog promotion entity ([@GSadee](https://github.com/GSadee))
- [#13016](https://github.com/Sylius/Sylius/issues/13016) [CatalogPromotion][Behat] Minor improvements for catalog promotions scenarios ([@GSadee](https://github.com/GSadee))
- [#13017](https://github.com/Sylius/Sylius/issues/13017) [CatalogPromotion][API] Add scenarios for browsing catalog promotions ([@GSadee](https://github.com/GSadee))
- [#13022](https://github.com/Sylius/Sylius/issues/13022) [Bug] Fix default sylius config file path in Sylius master branch ([@lchrusciel](https://github.com/lchrusciel))
- [#13026](https://github.com/Sylius/Sylius/issues/13026) [CatalogPromotion][Admin] Add browsing catalog promotions ([@GSadee](https://github.com/GSadee))
- [#13028](https://github.com/Sylius/Sylius/issues/13028) [CatalogPromotion][Admin] Add creating catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13029](https://github.com/Sylius/Sylius/issues/13029) Catalog promotions action ([@SirDomin](https://github.com/SirDomin), [@Zales0123](https://github.com/Zales0123))
- [#13030](https://github.com/Sylius/Sylius/issues/13030) Add validation for Catalog Promotion Rules ([@AdamKasp](https://github.com/AdamKasp))
- [#13033](https://github.com/Sylius/Sylius/issues/13033) [Catalog Promotion] refactor rule configuration change iri with code ([@AdamKasp](https://github.com/AdamKasp))
- [#13034](https://github.com/Sylius/Sylius/issues/13034) [CatalogPromotion][Admin] Add editing catalog promotions ([@GSadee](https://github.com/GSadee))
- [#13035](https://github.com/Sylius/Sylius/issues/13035) [CatalogPromotions] Inform about promotions applied on variants ([@Zales0123](https://github.com/Zales0123))
- [#13036](https://github.com/Sylius/Sylius/issues/13036) [CatalogPromotions] Use actions for discount application ([@Zales0123](https://github.com/Zales0123))
- [#13041](https://github.com/Sylius/Sylius/issues/13041) [CartPromotion][Admin] Change label of promotion to cart promotion ([@GSadee](https://github.com/GSadee))
- [#13048](https://github.com/Sylius/Sylius/issues/13048) [CatalogPromotions] Move variant-related CatalogPromotionRule constant to Core ([@Zales0123](https://github.com/Zales0123))
- [#13052](https://github.com/Sylius/Sylius/issues/13052) [CatalogPromotions] Manage rules and actions from UI ([@Zales0123](https://github.com/Zales0123))
- [#13055](https://github.com/Sylius/Sylius/issues/13055) [CatalogPromotions] Add fixtures for catalog promotions rules and actions ([@Tomanhez](https://github.com/Tomanhez))
- [#13060](https://github.com/Sylius/Sylius/issues/13060) [CP] Add scenario for `Inform about promotions applied on variant` ([@arti0090](https://github.com/arti0090))
- [#13061](https://github.com/Sylius/Sylius/issues/13061) [UI][Behat] tests for editing catalog promotion with rule and action ([@SirDomin](https://github.com/SirDomin))
- [#13064](https://github.com/Sylius/Sylius/issues/13064) [Behat] move actions redirect to different step ([@SirDomin](https://github.com/SirDomin))
- [#13066](https://github.com/Sylius/Sylius/issues/13066) [CatalogPromotion] refactor cp rule to be consistent with cp action ([@SirDomin](https://github.com/SirDomin))
- [#13067](https://github.com/Sylius/Sylius/issues/13067) Fix persisting of Catalog Promotion data on create ([@arti0090](https://github.com/arti0090))
- [#13068](https://github.com/Sylius/Sylius/issues/13068) [CatalogPromotions][Api] Add test for creation rule ([@Tomanhez](https://github.com/Tomanhez))
- [#13071](https://github.com/Sylius/Sylius/issues/13071) [CatalogPromotion][API] Add validation for creating catalog promotion with actions ([@Arminek](https://github.com/Arminek), [@GSadee](https://github.com/GSadee))
- [#13072](https://github.com/Sylius/Sylius/issues/13072) [CatalogPromotion] Improve names and namespaces of catalog promotion rule form types ([@GSadee](https://github.com/GSadee))
- [#13073](https://github.com/Sylius/Sylius/issues/13073) [CatalogPromotion][Behat] Improve steps names ([@GSadee](https://github.com/GSadee))
- [#13075](https://github.com/Sylius/Sylius/issues/13075) [CatalogPromotion][API] Refactor validation of rules ([@GSadee](https://github.com/GSadee))
- [#13077](https://github.com/Sylius/Sylius/issues/13077) [CatalogPromotion] Fix configuration of fixtures for actions and rules ([@GSadee](https://github.com/GSadee))
- [#13079](https://github.com/Sylius/Sylius/issues/13079) [DOCS] Rename promotions to cart promotions ([@arti0090](https://github.com/arti0090))
- [#13080](https://github.com/Sylius/Sylius/issues/13080) [Catalog Promotions] Fixing issues with multiple variants ([@arti0090](https://github.com/arti0090))
- [#13081](https://github.com/Sylius/Sylius/issues/13081) [CatalogPromotion][API] Apply catalog promotion in proper channels ([@GSadee](https://github.com/GSadee))
- [#13082](https://github.com/Sylius/Sylius/issues/13082) [API] [Catalog Promotion] validate action amount ([@AdamKasp](https://github.com/AdamKasp))
- [#13084](https://github.com/Sylius/Sylius/issues/13084) [DOCS]Add Catalog Promotion documentation ([@arti0090](https://github.com/arti0090))
- [#13085](https://github.com/Sylius/Sylius/issues/13085) [CatalogPromotions] Modify AppliedPromotionInformationFormatter ([@Tomanhez](https://github.com/Tomanhez))
- [#13086](https://github.com/Sylius/Sylius/issues/13086) [CatalogPromotion][API] Add examples of rules and actions to Swagger ([@GSadee](https://github.com/GSadee))
- [#13089](https://github.com/Sylius/Sylius/issues/13089) [CatalogPromotions] Add missing description to applied promotions ([@arti0090](https://github.com/arti0090))
- [#13091](https://github.com/Sylius/Sylius/issues/13091) [CatalogPromotions] Add api behat for multiple catalog promotions ([@Tomanhez](https://github.com/Tomanhez))
- [#13092](https://github.com/Sylius/Sylius/issues/13092) [CatalogPromotion][Behat] Add scenarios for reapplying catalog promotions after editing its channels ([@GSadee](https://github.com/GSadee))
- [#13093](https://github.com/Sylius/Sylius/issues/13093) [CatalogPromotions][Validation] add validation to catalog promotion, … ([@SirDomin](https://github.com/SirDomin))
- [#13094](https://github.com/Sylius/Sylius/issues/13094) [Catalog Promotions][Docs] Add a section about how promotions are applied ([@arti0090](https://github.com/arti0090))
- [#13096](https://github.com/Sylius/Sylius/issues/13096) [DOCS] Fix catalog promotions docs reference ([@arti0090](https://github.com/arti0090))
- [#13098](https://github.com/Sylius/Sylius/issues/13098) [CatalogPromotions] Add product to cart with discounted catalog price ([@Tomanhez](https://github.com/Tomanhez), [@arti0090](https://github.com/arti0090))
- [#13100](https://github.com/Sylius/Sylius/issues/13100) [CatalogPromotion] Clear applied catalog promotions after updating ([@GSadee](https://github.com/GSadee))
- [#13101](https://github.com/Sylius/Sylius/issues/13101) [CatalogPromotions] Showing catalog promotions in Products index and show page ([@SirDomin](https://github.com/SirDomin), [@Zales0123](https://github.com/Zales0123))
- [#13103](https://github.com/Sylius/Sylius/issues/13103) [UI][Catalog Promotion] Add discounted product to cart ([@AdamKasp](https://github.com/AdamKasp))
- [#13104](https://github.com/Sylius/Sylius/issues/13104) [API] Use POST action to add new item to cart ([@lchrusciel](https://github.com/lchrusciel))
- [#13105](https://github.com/Sylius/Sylius/issues/13105) [Catalog Promotions] Reapplying Catalog Promotion on Action Edit ([@arti0090](https://github.com/arti0090))
- [#13107](https://github.com/Sylius/Sylius/issues/13107) [Api] Customer add product with discounted catalog price ([@Tomanhez](https://github.com/Tomanhez))
- [#13110](https://github.com/Sylius/Sylius/issues/13110) [Fixtures] Extract promotions to a separate file to fix applying catalog promotions ([@GSadee](https://github.com/GSadee))
- [#13111](https://github.com/Sylius/Sylius/issues/13111) [ChannelPricing] Improve query for finding discounted pricings ([@GSadee](https://github.com/GSadee))
- [#13112](https://github.com/Sylius/Sylius/issues/13112) [Catalog Promotion] Cart catalog promotion becomes ineligible ([@GSadee](https://github.com/GSadee), [@AdamKasp](https://github.com/AdamKasp))
- [#13114](https://github.com/Sylius/Sylius/issues/13114) [CatalogPromotions] Do not display applied promotion description in label if not set ([@Zales0123](https://github.com/Zales0123))
- [#13117](https://github.com/Sylius/Sylius/issues/13117) [API] Remove phoneNumber from Customer command and handler ([@lchrusciel](https://github.com/lchrusciel))
- [#13121](https://github.com/Sylius/Sylius/issues/13121) [AUTO] Updated translations from Crowdin (master) ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#13124](https://github.com/Sylius/Sylius/issues/13124) [CatalogPromotion][API] Reapplying catalog promotions after update its channel ([@AdamKasp](https://github.com/AdamKasp))
- [#13128](https://github.com/Sylius/Sylius/issues/13128) [API][CatalogPromotion] Reapplying catalog promotion on variant once its data changes ([@GSadee](https://github.com/GSadee))
- [#13129](https://github.com/Sylius/Sylius/issues/13129) [API][CatalogPromotion] Reapplying catalog promotions on rule update ([@SirDomin](https://github.com/SirDomin), [@GSadee](https://github.com/GSadee))
- [#13130](https://github.com/Sylius/Sylius/issues/13130) [CatalogPromotion][Behat] Cover scenarios for reapplying catalog promotions ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#13131](https://github.com/Sylius/Sylius/issues/13131) [CatalogPromotions][API] Reapply promotions after action removal ([@arti0090](https://github.com/arti0090))
- [#13132](https://github.com/Sylius/Sylius/issues/13132) [API][UI] Toggle catalog promotion ([@AdamKasp](https://github.com/AdamKasp))
- [#13133](https://github.com/Sylius/Sylius/issues/13133) Reorganize flushes in Catalog Promotions processing ([@Zales0123](https://github.com/Zales0123))
- [#13137](https://github.com/Sylius/Sylius/issues/13137) [CatalogPromotions] Add behats for CatalogPromotions based on taxon ([@Tomanhez](https://github.com/Tomanhez), [@AdamKasp](https://github.com/AdamKasp))
- [#13138](https://github.com/Sylius/Sylius/issues/13138) [Build] ignore string inflector phpstan ([@SirDomin](https://github.com/SirDomin))
- [#13141](https://github.com/Sylius/Sylius/issues/13141) [UI][CatalogPromotion] Reapplying catalog promotion on variant once its data changes ([@GSadee](https://github.com/GSadee))
- [#13145](https://github.com/Sylius/Sylius/issues/13145) [API][CatalogPromotion] refactor Variants Provider to strategy Pattern ([@AdamKasp](https://github.com/AdamKasp))
- [#13146](https://github.com/Sylius/Sylius/issues/13146) [Api] CatalogPromotionRule per taxon ([@AdamKasp](https://github.com/AdamKasp), [@Tomanhez](https://github.com/Tomanhez), [@Zales0123](https://github.com/Zales0123))
- [#13147](https://github.com/Sylius/Sylius/issues/13147) [API] Fix admin path in swagger ([@arti0090](https://github.com/arti0090))
- [#13150](https://github.com/Sylius/Sylius/issues/13150) [API] Refactor path removal with (unset) ([@Zales0123](https://github.com/Zales0123))
- [#13152](https://github.com/Sylius/Sylius/issues/13152) [CatalogPromotion] Refactor to not listen on Doctrine events ([@GSadee](https://github.com/GSadee))
- [#13153](https://github.com/Sylius/Sylius/issues/13153) [UI][CatalogPromotion] Reapply catalog promotions after editing their rules and actions ([@GSadee](https://github.com/GSadee))
- [#13155](https://github.com/Sylius/Sylius/issues/13155) [Documentation][CatalogPromotion] Adjust docs after removing usage of Doctrine events ([@GSadee](https://github.com/GSadee))
- [#13156](https://github.com/Sylius/Sylius/issues/13156) [CatalogPromotion] change change channel with toggle in UI ([@AdamKasp](https://github.com/AdamKasp))
- [#13161](https://github.com/Sylius/Sylius/issues/13161) [CatalogPromotions] Rename CP Rule to Scope ([@arti0090](https://github.com/arti0090))
- [#13164](https://github.com/Sylius/Sylius/issues/13164) Rename behat file from rule to scope on catalog promotion ([@arti0090](https://github.com/arti0090))
- [#13168](https://github.com/Sylius/Sylius/issues/13168) [CatalogPromotion] Minor fixes after renaming rule to scope ([@GSadee](https://github.com/GSadee))
- [#13169](https://github.com/Sylius/Sylius/issues/13169) [Catalog Promotions] Reapply CP after changing its taxons ([@arti0090](https://github.com/arti0090))
- [#13174](https://github.com/Sylius/Sylius/issues/13174) [CatalogPromotion] Refactor scope validators to be more extendable ([@GSadee](https://github.com/GSadee))
- [#13175](https://github.com/Sylius/Sylius/issues/13175) [CatalogPromotions] "For taxons" scope in UI with dynamic form configurations ([@Zales0123](https://github.com/Zales0123))
- [#13179](https://github.com/Sylius/Sylius/issues/13179) [CatalogPromotions] Start and end date  ([@Zales0123](https://github.com/Zales0123))
- [#13181](https://github.com/Sylius/Sylius/issues/13181) [CatalogPromotion][UI] Reapply catalog promotions after product's taxon changes + refactor ([@GSadee](https://github.com/GSadee))
- [#13182](https://github.com/Sylius/Sylius/issues/13182) [CatalogPromotions] Display taxons with names in scope ([@Zales0123](https://github.com/Zales0123))
- [#13183](https://github.com/Sylius/Sylius/issues/13183) [DOCS][Catalog Promotions] Making new CP scope ([@arti0090](https://github.com/arti0090))
- [#13184](https://github.com/Sylius/Sylius/issues/13184) [CatalogPromotion][UI][Behat] Implement scenarios for reapplying catalog promotions after editing their for taxons scope ([@GSadee](https://github.com/GSadee))
- [#13186](https://github.com/Sylius/Sylius/issues/13186) [CatalogPromotion][API][UI] Introduce states with state machine for catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13189](https://github.com/Sylius/Sylius/issues/13189) [CatalogPromotions] Take into account CP dates during processing ([@Zales0123](https://github.com/Zales0123))
- [#13190](https://github.com/Sylius/Sylius/issues/13190) [CatalogPromotion] Minor improvements in EligibleCatalogPromotionsProvider ([@GSadee](https://github.com/GSadee))
- [#13191](https://github.com/Sylius/Sylius/issues/13191) [CatalogPromotion][Behat] Add scenario for applying catalog promotion with different scopes defined ([@GSadee](https://github.com/GSadee))
- [#13192](https://github.com/Sylius/Sylius/issues/13192) [DOCS] Refactor from promotion to cart promotion ([@arti0090](https://github.com/arti0090))
- [#13195](https://github.com/Sylius/Sylius/issues/13195) [CatalogPromotion] Secure that the catalog promotion cannot be edited ([@GSadee](https://github.com/GSadee))
- [#13196](https://github.com/Sylius/Sylius/issues/13196) [CatalogPromotions] async workers introduction ([@SirDomin](https://github.com/SirDomin))
- [#13206](https://github.com/Sylius/Sylius/issues/13206) [API][UI] Sort products by their discounted price ([@arti0090](https://github.com/arti0090), [@GSadee](https://github.com/GSadee))
- [#13208](https://github.com/Sylius/Sylius/issues/13208) [CatalogPromotion] fix pricing clearer ([@AdamKasp](https://github.com/AdamKasp))
- [#13209](https://github.com/Sylius/Sylius/issues/13209) Move channel pricing to separate tab ([@AdamKasp](https://github.com/AdamKasp))
- [#13212](https://github.com/Sylius/Sylius/issues/13212) [Hot-fix] Conflict doctrine/dbal 3.* in ApiBundle ([@Zales0123](https://github.com/Zales0123))
- [#13217](https://github.com/Sylius/Sylius/issues/13217) [Docs] Add description of prices ([@AdamKasp](https://github.com/AdamKasp))
- [#13218](https://github.com/Sylius/Sylius/issues/13218) [CatalogPromotion] Add show page for catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13219](https://github.com/Sylius/Sylius/issues/13219) [ChannelPricing] fixes after merge ([@AdamKasp](https://github.com/AdamKasp))
- [#13220](https://github.com/Sylius/Sylius/issues/13220) Add note about time delay ([@AdamKasp](https://github.com/AdamKasp))
- [#13221](https://github.com/Sylius/Sylius/issues/13221) [CatalogPromotions] Prevent editing start and end date ([@Zales0123](https://github.com/Zales0123))
- [#13222](https://github.com/Sylius/Sylius/issues/13222) [UI][Catalog Promotions] Set default time for CP dates if not provided ([@Zales0123](https://github.com/Zales0123))
- [#13226](https://github.com/Sylius/Sylius/issues/13226) [CatalogPromotions] Handle failed catalog promotions ([@SirDomin](https://github.com/SirDomin))
- [#13227](https://github.com/Sylius/Sylius/issues/13227) [CatalogPromotions] Always prevent CP dates editing - even if they're not set during creation ([@Zales0123](https://github.com/Zales0123))
- [#13228](https://github.com/Sylius/Sylius/issues/13228) [Conflict] add conflict to new release of fos-rest ([@SirDomin](https://github.com/SirDomin))
- [#13229](https://github.com/Sylius/Sylius/issues/13229) [CatalogPromotion] docs about async messages ([@AdamKasp](https://github.com/AdamKasp))
- [#13230](https://github.com/Sylius/Sylius/issues/13230) [CatalogPromotion] change DateRange criteria + functional tests ([@SirDomin](https://github.com/SirDomin))
- [#13231](https://github.com/Sylius/Sylius/issues/13231) [CatalogPromotion] Make criteria services public in container by default ([@lchrusciel](https://github.com/lchrusciel))
- [#13234](https://github.com/Sylius/Sylius/issues/13234) Update Typo in Performance section ([@zairigimad](https://github.com/zairigimad))
- [#13235](https://github.com/Sylius/Sylius/issues/13235) [CatalogPromotion] Changing state after toggling catalog promotion ([@GSadee](https://github.com/GSadee))
- [#13236](https://github.com/Sylius/Sylius/issues/13236) [CatalogPromotion] fix service typo, stateMachine error fixed ([@SirDomin](https://github.com/SirDomin))
- [#13248](https://github.com/Sylius/Sylius/issues/13248) [CatalogPromotion] Small fixes to `docs about async messages` ([@arti0090](https://github.com/arti0090))
- [#13256](https://github.com/Sylius/Sylius/issues/13256) [CatalogPromotion] dates are editable and validated ([@AdamKasp](https://github.com/AdamKasp))
- [#13260](https://github.com/Sylius/Sylius/issues/13260) [CatalogPromotions] Add priorities ([@Zales0123](https://github.com/Zales0123), [@GSadee](https://github.com/GSadee))
- [#13262](https://github.com/Sylius/Sylius/issues/13262) Remove conflict with fos/rest-bundle ([@Zales0123](https://github.com/Zales0123))
- [#13264](https://github.com/Sylius/Sylius/issues/13264) [AUTO] Updated translations from Crowdin (master) ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#13266](https://github.com/Sylius/Sylius/issues/13266) Specify minimum price of product and apply it on catalogPromotions ([@SirDomin](https://github.com/SirDomin))
- [#13271](https://github.com/Sylius/Sylius/issues/13271) Fix composer.json file after rebase ([@Zales0123](https://github.com/Zales0123))
- [#13273](https://github.com/Sylius/Sylius/issues/13273) [CatalogPromotion] Add "for products" scope ([@GSadee](https://github.com/GSadee))
- [#13279](https://github.com/Sylius/Sylius/issues/13279) [Behat] Remove deprecated whitespace from behat tags on master ([@GSadee](https://github.com/GSadee))
- [#13280](https://github.com/Sylius/Sylius/issues/13280) Get products by slug api endpoint ([@paullla](https://github.com/paullla))
- [#13287](https://github.com/Sylius/Sylius/issues/13287) List of channel currencies endpoint ([@paullla](https://github.com/paullla))
- [#13291](https://github.com/Sylius/Sylius/issues/13291) [MinimumPrice] Handle minimum price cart ([@SirDomin](https://github.com/SirDomin), [@lchrusciel](https://github.com/lchrusciel))
- [#13294](https://github.com/Sylius/Sylius/issues/13294) [Minimum Price] documentation ([@AdamKasp](https://github.com/AdamKasp))
- [#13295](https://github.com/Sylius/Sylius/issues/13295) [Github] clear cache before phpunit ([@SirDomin](https://github.com/SirDomin))
- [#13297](https://github.com/Sylius/Sylius/issues/13297) [Actions] disable xdebug for actions ([@SirDomin](https://github.com/SirDomin))
- [#13299](https://github.com/Sylius/Sylius/issues/13299) [Adr] Fix customization api documentation url ([@SebLours](https://github.com/SebLours))
- [#13303](https://github.com/Sylius/Sylius/issues/13303) [CatalogPromotion] Add exclusiveness flag ([@AdamKasp](https://github.com/AdamKasp))
- [#13305](https://github.com/Sylius/Sylius/issues/13305) [Behat] Skip ui based checkout steps in api coverage ([@lchrusciel](https://github.com/lchrusciel))
- [#13306](https://github.com/Sylius/Sylius/issues/13306) [Minor][Behat] Style and type refactor ([@lchrusciel](https://github.com/lchrusciel))
- [#13311](https://github.com/Sylius/Sylius/issues/13311) Code cleanup - user password reset ([@antonioperic](https://github.com/antonioperic))
- [#13325](https://github.com/Sylius/Sylius/issues/13325) [CatalogPromotion][API][UI] Fixed discount action ([@GSadee](https://github.com/GSadee))
- [#13328](https://github.com/Sylius/Sylius/issues/13328) [CartPromotion][API][UI] Apply on discounted flag added ([@SirDomin](https://github.com/SirDomin), [@AdamKasp](https://github.com/AdamKasp))
- [#13329](https://github.com/Sylius/Sylius/issues/13329) Addressing, locale update and apply coupon code unified to one endpoint ([@paullla](https://github.com/paullla))
- [#13333](https://github.com/Sylius/Sylius/issues/13333) Replace data providers with doctrine extensions ([@paullla](https://github.com/paullla))
- [#13337](https://github.com/Sylius/Sylius/issues/13337) [AUTO] Updated translations from Crowdin (master) ([@bot](https://github.com/bot)@[@sylius](https://github.com/sylius).[@org](https://github.com/org))
- [#13338](https://github.com/Sylius/Sylius/issues/13338) Drop support for PHP 7.4 ([@AdamKasp](https://github.com/AdamKasp))
- [#13339](https://github.com/Sylius/Sylius/issues/13339) Add Support for Symfony 5.4 ([@AdamKasp](https://github.com/AdamKasp))
- [#13343](https://github.com/Sylius/Sylius/issues/13343) [Documentation] Update required version of PHP ([@GSadee](https://github.com/GSadee))
- [#13344](https://github.com/Sylius/Sylius/issues/13344) Doctrine Extensions upgrade info & code cleanup ([@paullla](https://github.com/paullla))
- [#13349](https://github.com/Sylius/Sylius/issues/13349) [CartPromotion][CatalogPromotion] Receiving discount only on non discounted products ([@GSadee](https://github.com/GSadee), [@SirDomin](https://github.com/SirDomin))
- [#13350](https://github.com/Sylius/Sylius/issues/13350) Order items list and order/item adjustments serialization groups ([@paullla](https://github.com/paullla))
- [#13352](https://github.com/Sylius/Sylius/issues/13352) Use QueryNameGenerator for extension query parameters ([@paullla](https://github.com/paullla))
- [#13367](https://github.com/Sylius/Sylius/issues/13367) [Maintenance] Remove Sf6.0 conflicts ([@lchrusciel](https://github.com/lchrusciel))
- [#13368](https://github.com/Sylius/Sylius/issues/13368) [UI] change time format to 24H, autocomplete times on data change ([@SirDomin](https://github.com/SirDomin))
- [#13369](https://github.com/Sylius/Sylius/issues/13369) [Command] add command to generate jwt ([@SirDomin](https://github.com/SirDomin))
- [#13373](https://github.com/Sylius/Sylius/issues/13373) Revert "Move "polishsymfonycommunity/symfony-mocker-container" into dev dependencies" due to the BC break ([@lchrusciel](https://github.com/lchrusciel))
- [#13375](https://github.com/Sylius/Sylius/issues/13375) Catalog promotion channel pricing relation ([@Rafikooo](https://github.com/Rafikooo))
- [#13377](https://github.com/Sylius/Sylius/issues/13377) Move "polishsymfonycommunity/symfony-mocker-container" into dev dependencies ([@stloyd](https://github.com/stloyd), [@lchrusciel](https://github.com/lchrusciel))
- [#13378](https://github.com/Sylius/Sylius/issues/13378) [CatalogPromotion] change icon on show page ([@AdamKasp](https://github.com/AdamKasp))
- [#13380](https://github.com/Sylius/Sylius/issues/13380) [Bug][Migrations] Add missing mysql check for our migrations to ensure proper syntax is available - master edition ([@lchrusciel](https://github.com/lchrusciel))
- [#13381](https://github.com/Sylius/Sylius/issues/13381) Drop support for older `gedmo/doctrine-extensions` versions ([@mbabker](https://github.com/mbabker))
- [#13387](https://github.com/Sylius/Sylius/issues/13387) Explanation note about minimum price in product variant creation form ([@TheMilek](https://github.com/TheMilek))
- [#13388](https://github.com/Sylius/Sylius/issues/13388) [Migrations] Remove invalid NOT NULL usage ([@Zales0123](https://github.com/Zales0123))
- [#13391](https://github.com/Sylius/Sylius/issues/13391) [Maintenance] Conflict with Symfony 6 packages ([@lchrusciel](https://github.com/lchrusciel))
