# CHANGELOG FOR `1.10.X`

## v1.10.14 (2022-05-13)

#### Details

- [#12868](https://github.com/Sylius/Sylius/issues/12868) Fix zone cannot contain itself validator ([@vvasiloi](https://github.com/vvasiloi))
- [#13894](https://github.com/Sylius/Sylius/issues/13894) Using Sylius template event to change logo ([@arti0090](https://github.com/arti0090))
- [#13898](https://github.com/Sylius/Sylius/issues/13898) [maintenance][mailer]Assert that email is not null ([@Ferror](https://github.com/Ferror))
- [#13903](https://github.com/Sylius/Sylius/issues/13903) [Documentation] Improve and fix the release cycle documentation ([@Zales0123](https://github.com/Zales0123))
- [#13907](https://github.com/Sylius/Sylius/issues/13907) [Docs] Updated Sylius Plus installation guide - optional PDF Generator ([@Rafikooo](https://github.com/Rafikooo))
- [#13908](https://github.com/Sylius/Sylius/issues/13908) [DX] General refactor using ECS ([@coldic3](https://github.com/coldic3))
- [#13909](https://github.com/Sylius/Sylius/issues/13909) [Maintenance] Specify the default path in the ECS configuration ([@coldic3](https://github.com/coldic3))
- [#13919](https://github.com/Sylius/Sylius/issues/13919) [Maintenance][CI] Add Refactor workflow ([@coldic3](https://github.com/coldic3))
- [#13929](https://github.com/Sylius/Sylius/issues/13929) Specify rough 1.12 release term and its planned content ([@Zales0123](https://github.com/Zales0123))
- [#13933](https://github.com/Sylius/Sylius/issues/13933) Bump flex to ^1.17, v1.13 - old infrastructure shutdown ([@em411](https://github.com/em411))
- [#13940](https://github.com/Sylius/Sylius/issues/13940) [CS][DX] Refactor ([@github-actions](https://github.com/github-actions))
- [#13959](https://github.com/Sylius/Sylius/issues/13959) [Docs] Favicon ([@Rafikooo](https://github.com/Rafikooo))
- [#13961](https://github.com/Sylius/Sylius/issues/13961) [GH] Store composer lock and generate diff ([@lchrusciel](https://github.com/lchrusciel))
- [#13966](https://github.com/Sylius/Sylius/issues/13966) Update orders.rst ([@groupecomplus](https://github.com/groupecomplus))

## v1.10.13 (2022-04-22)

#### Details

- [#13601](https://github.com/Sylius/Sylius/issues/13601) Use the Gaufrette FilesystemInterface instead of a concrete implementation ([@GSadee](https://github.com/GSadee), [@mbabker](https://github.com/mbabker))
- [#13841](https://github.com/Sylius/Sylius/issues/13841) [Maintenance] Add note to UPGRADE file about dropping Symfony 5.2 support ([@GSadee](https://github.com/GSadee))
- [#13848](https://github.com/Sylius/Sylius/issues/13848) [DOCS] Update index tip ([@arti0090](https://github.com/arti0090))
- [#13852](https://github.com/Sylius/Sylius/issues/13852) [Maintenance] Run the build on tags rather than on releases ([@Zales0123](https://github.com/Zales0123))
- [#13857](https://github.com/Sylius/Sylius/issues/13857) [DOC] Bump minimal PHP version needed to install Sylius ([@Roshyo](https://github.com/Roshyo))
- [#13865](https://github.com/Sylius/Sylius/issues/13865) [Cart] Add Validator for localeCode ([@SirDomin](https://github.com/SirDomin))
- [#13866](https://github.com/Sylius/Sylius/issues/13866) [Maintenance] Relax conflict on liip imagine bundle - rebased version ([@Nek-](https://github.com/Nek-))
- [#13867](https://github.com/Sylius/Sylius/issues/13867) [Template][Events] Sylius template events - improvements ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13870](https://github.com/Sylius/Sylius/issues/13870) [ShippingMethod] Change shipping rule to be based on items total instead of order total ([@GSadee](https://github.com/GSadee), [@mdevlamynck](https://github.com/mdevlamynck))
- [#13878](https://github.com/Sylius/Sylius/issues/13878) [Template] Variant name instead of product name ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13886](https://github.com/Sylius/Sylius/issues/13886) [Templates][Admin] Refactor order payments template to use events ([@coldic3](https://github.com/coldic3))
- [#13888](https://github.com/Sylius/Sylius/issues/13888) [Documentation] Fix the description of items total shipping rules ([@GSadee](https://github.com/GSadee))
- [#13890](https://github.com/Sylius/Sylius/issues/13890) [maintenance]Fix ECS HeaderCommentFixer ([@Ferror](https://github.com/Ferror))
- [#13891](https://github.com/Sylius/Sylius/issues/13891) [maintenance]Run ECS in parallel ([@Ferror](https://github.com/Ferror))

## v1.10.12 (2022-04-08)

#### Details

- [#11850](https://github.com/Sylius/Sylius/issues/11850) Fix redirection when there is a trailing slash in the products list path ([@loic425](https://github.com/loic425))
- [#12538](https://github.com/Sylius/Sylius/issues/12538) [Behat] Allow to use some useful methods on Order show page ([@loic425](https://github.com/loic425))
- [#13724](https://github.com/Sylius/Sylius/issues/13724) Fix disappearing products in Admin Panel when translation for current locale is missing ([@jakubtobiasz](https://github.com/jakubtobiasz))
- [#13736](https://github.com/Sylius/Sylius/issues/13736) [Maintenance] Testing with PHP 8.1 ([@loic425](https://github.com/loic425))
- [#13744](https://github.com/Sylius/Sylius/issues/13744) [Maintenance]Ignore phpstan.neon file ([@Ferror](https://github.com/Ferror))
- [#13745](https://github.com/Sylius/Sylius/issues/13745) [Promotion] Add validation of coupon usage limit per customer ([@coldic3](https://github.com/coldic3))
- [#13753](https://github.com/Sylius/Sylius/issues/13753) [UI] Replacing the placeholder avatar with an icon ([@mamazu](https://github.com/mamazu))
- [#13759](https://github.com/Sylius/Sylius/issues/13759) [Behat] Use "When" for user actions where possible ([@coldic3](https://github.com/coldic3))
- [#13767](https://github.com/Sylius/Sylius/issues/13767) Change sylius.behat.context.ui.email context to sylius.behat.context.api.email ([@Ferror](https://github.com/Ferror))
- [#13768](https://github.com/Sylius/Sylius/issues/13768) Bump Psalm version to 4.19 (php 8.1 support) ([@loic425](https://github.com/loic425))
- [#13769](https://github.com/Sylius/Sylius/issues/13769) [Core][Shipping] Fix estimated shipping costs ([@coldic3](https://github.com/coldic3), [@lchrusciel](https://github.com/lchrusciel))
- [#13770](https://github.com/Sylius/Sylius/issues/13770) [ADR] Clean up existing ADRs mostly by updating their statuses ([@GSadee](https://github.com/GSadee))
- [#13779](https://github.com/Sylius/Sylius/issues/13779) [Documentation][Plus] Update cookbook about restricting access to the entity ([@GSadee](https://github.com/GSadee))
- [#13782](https://github.com/Sylius/Sylius/issues/13782) [Plus] Fix Sylius installation guide ([@lchrusciel](https://github.com/lchrusciel))
- [#13787](https://github.com/Sylius/Sylius/issues/13787) [ADR] Use raw data in commands and events ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13795](https://github.com/Sylius/Sylius/issues/13795) [ADR] Remove flush() from handlers. ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13798](https://github.com/Sylius/Sylius/issues/13798) [Events] Sylius template event forms ([@SirDomin](https://github.com/SirDomin))
- [#13799](https://github.com/Sylius/Sylius/issues/13799) [Core][Shipping] Deprecate processing shipments before recalculating prices ([@coldic3](https://github.com/coldic3))
- [#13801](https://github.com/Sylius/Sylius/issues/13801) [Behat] added context to manage non-collection subresources ([@emmanuel-tilleuls](https://github.com/emmanuel-tilleuls))
- [#13802](https://github.com/Sylius/Sylius/issues/13802) [Docs] Add a guide on how to deal with file access problems in the wkhtmltopdf ([@coldic3](https://github.com/coldic3))
- [#13803](https://github.com/Sylius/Sylius/issues/13803) [Admin][JS] Applying all the options selected for an attribute of type multiple select fixed ([@TheMilek](https://github.com/TheMilek))
- [#13805](https://github.com/Sylius/Sylius/issues/13805) [JS] Not render empty value in multi select autocompletes ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13809](https://github.com/Sylius/Sylius/issues/13809) [Documentation] Fix build by specifying jinja2 version requirement ([@GSadee](https://github.com/GSadee))
- [#13811](https://github.com/Sylius/Sylius/issues/13811) [Documentation][Plus] Adjust installation guide after entities refactor ([@GSadee](https://github.com/GSadee))
- [#13817](https://github.com/Sylius/Sylius/issues/13817) [Admin] Clean up and refactor new template events ([@GSadee](https://github.com/GSadee))
- [#13818](https://github.com/Sylius/Sylius/issues/13818) [Maintenance] Bump copyright year in docs and license files ([@coldic3](https://github.com/coldic3))
- [#13839](https://github.com/Sylius/Sylius/issues/13839) Limit the number of packages build run on 1.10 ([@Zales0123](https://github.com/Zales0123))

## v1.10.11 (2022-03-14)

#### Details

- [#13432](https://github.com/Sylius/Sylius/issues/13432) Update SalesDataProvider.php ([@remoteclient](https://github.com/remoteclient))
- [#13723](https://github.com/Sylius/Sylius/issues/13723) [Docs] Deployment on artifakt ([@AdamKasp](https://github.com/AdamKasp))
- [#13731](https://github.com/Sylius/Sylius/issues/13731) [Taxation] Add validation of negative tax rate ([@coldic3](https://github.com/coldic3))
- [#13734](https://github.com/Sylius/Sylius/issues/13734) [JS] add empty value to autocomplete selects ([@SirDomin](https://github.com/SirDomin))
- [#13750](https://github.com/Sylius/Sylius/issues/13750) [Admin][Shop] placehold.it replaced to local placeholders ([@ernestWarwas](https://github.com/ernestWarwas))
- [#13756](https://github.com/Sylius/Sylius/issues/13756) [GitHub Actions] Change PHP ini values + clear cache ([@GSadee](https://github.com/GSadee))
- [#13765](https://github.com/Sylius/Sylius/issues/13765) [Security] Fixes for SVG XSS, wrong cache for logged in users and clickjacking ([@ernestWarwas](https://github.com/ernestWarwas), [@lchrusciel](https://github.com/lchrusciel), [@GSadee](https://github.com/GSadee), [@Zales0123](https://github.com/Zales0123), [@Rafikooo](https://github.com/Rafikooo))
- [#13766](https://github.com/Sylius/Sylius/issues/13766) [Security][API] passwordResetToken nulled after password is changed ([@lchrusciel](https://github.com/lchrusciel), [@ernestWarwas](https://github.com/ernestWarwas), [@GSadee](https://github.com/GSadee), [@TheMilek](https://github.com/TheMilek))

## v1.10.10 (2022-03-07)

#### Details

- [#13575](https://github.com/Sylius/Sylius/issues/13575) [DX] add correct return type to getAdjustments method ([@PILLOWPET](https://github.com/PILLOWPET))
- [#13641](https://github.com/Sylius/Sylius/issues/13641) [ADR] Declaring services as public in container ([@lchrusciel](https://github.com/lchrusciel))
- [#13647](https://github.com/Sylius/Sylius/issues/13647) Update Sylius supported versions ([@Zales0123](https://github.com/Zales0123))
- [#13650](https://github.com/Sylius/Sylius/issues/13650) [Documentation] Update installation guide for Plus ([@GSadee](https://github.com/GSadee))
- [#13660](https://github.com/Sylius/Sylius/issues/13660) [CLI] Cancel unpaid orders command ([@rafalswierczek](https://github.com/rafalswierczek))
- [#13676](https://github.com/Sylius/Sylius/issues/13676) [Cart] Fix retrieving/overriding cart of logged in user by guest ([@SirDomin](https://github.com/SirDomin), [@GSadee](https://github.com/GSadee))
- [#13683](https://github.com/Sylius/Sylius/issues/13683) Improve verbosity of canceling unpaid orders test ([@rafalswierczek](https://github.com/rafalswierczek))
- [#13684](https://github.com/Sylius/Sylius/issues/13684) [Product][API][Bug] Fixed product sorting by translated names ([@Rafikooo](https://github.com/Rafikooo))
- [#13695](https://github.com/Sylius/Sylius/issues/13695) [Order] Change getters and setters to use a proper flag name ([@GSadee](https://github.com/GSadee))
- [#13715](https://github.com/Sylius/Sylius/issues/13715) add dependency injection conflict ([@SirDomin](https://github.com/SirDomin))
- [#13716](https://github.com/Sylius/Sylius/issues/13716) [Documentation] Fix start date of development 1.12 version ([@GSadee](https://github.com/GSadee))
- [#13725](https://github.com/Sylius/Sylius/issues/13725) [PaypalExpress] Dont take shipping tax adjustment to shipping cost ([@SirDomin](https://github.com/SirDomin))
- [#13730](https://github.com/Sylius/Sylius/issues/13730) [Maintenance] Add conflict to symfony/framework-bundle to fix problem with solving path prefix in API scenarios ([@GSadee](https://github.com/GSadee))
- [#13732](https://github.com/Sylius/Sylius/issues/13732) [Hot-fix] Conflict with symfony/dependency-injection even more ([@Zales0123](https://github.com/Zales0123))

## v1.10.9 (2022-02-14)

#### Details

- [#13421](https://github.com/Sylius/Sylius/issues/13421) [Docs] How to customize the invoice logo - updated cookbook ([@Rafikooo](https://github.com/Rafikooo))
- [#13423](https://github.com/Sylius/Sylius/issues/13423) [Docs] Customizing Credit Memo's logo ([@TheMilek](https://github.com/TheMilek))
- [#13431](https://github.com/Sylius/Sylius/issues/13431) FIX: Avoid passing empty needle to strpos() ([@rimas-kudelis](https://github.com/rimas-kudelis))
- [#13498](https://github.com/Sylius/Sylius/issues/13498) [Docs] Sylius 1.8 is not supported anymore ([@Zales0123](https://github.com/Zales0123))
- [#13504](https://github.com/Sylius/Sylius/issues/13504) Postpone 1.10 end of maintenance date ([@Zales0123](https://github.com/Zales0123))
- [#13506](https://github.com/Sylius/Sylius/issues/13506) [Docs] How to customize the invoice logo - neatly cut invoice image ([@Rafikooo](https://github.com/Rafikooo))
- [#13513](https://github.com/Sylius/Sylius/issues/13513) [Architecture] Do not double install PHP dependencies ([@lchrusciel](https://github.com/lchrusciel))
- [#13514](https://github.com/Sylius/Sylius/issues/13514) [Documentation] Update Core Team in our documentation ([@lchrusciel](https://github.com/lchrusciel))
- [#13515](https://github.com/Sylius/Sylius/issues/13515) [Maintenance] Replace `test-package.sh` with native GH Actions ([@lchrusciel](https://github.com/lchrusciel))
- [#13516](https://github.com/Sylius/Sylius/issues/13516) [Maintenance] Remove NelmioAlice from the main packages config ([@lchrusciel](https://github.com/lchrusciel))
- [#13517](https://github.com/Sylius/Sylius/issues/13517) [Docs] Change the template path in customization ([@Roshyo](https://github.com/Roshyo))
- [#13519](https://github.com/Sylius/Sylius/issues/13519) [Docs] Altered custom invoice logo path ([@Rafikooo](https://github.com/Rafikooo))
- [#13520](https://github.com/Sylius/Sylius/issues/13520) change suggested path in refund docs ([@AdamKasp](https://github.com/AdamKasp))
- [#13527](https://github.com/Sylius/Sylius/issues/13527) [Minor] Typo fixes in github packages config ([@lchrusciel](https://github.com/lchrusciel))
- [#13535](https://github.com/Sylius/Sylius/issues/13535) [Minor] Removal of logic duplication in shipping charges processor ([@lchrusciel](https://github.com/lchrusciel))
- [#13552](https://github.com/Sylius/Sylius/issues/13552) Fixing the documentation (1.10) ([@mamazu](https://github.com/mamazu))
- [#13553](https://github.com/Sylius/Sylius/issues/13553) [Fixtures] USA deleted from the World zone ([@TheMilek](https://github.com/TheMilek))
- [#13561](https://github.com/Sylius/Sylius/issues/13561) [Docs] Mention autoconfiguration case when extending the form ([@Zales0123](https://github.com/Zales0123))

## v1.10.8 (2022-01-17)

#### Details

- [#12549](https://github.com/Sylius/Sylius/issues/12549) [Product Variant] Price Calculator fixed to return always int ([@lruozzi9](https://github.com/lruozzi9))
- [#12759](https://github.com/Sylius/Sylius/issues/12759) Use phpspec ^7.1 and avoid custom error reporting level in its configuration ([@pamil](https://github.com/pamil))
- [#13214](https://github.com/Sylius/Sylius/issues/13214) Replace `json_array` with `json` type as requested by the deprecation ([@Prometee](https://github.com/Prometee))
- [#13366](https://github.com/Sylius/Sylius/issues/13366) [Docs] Add missing references in CONFLICT.md ([@lchrusciel](https://github.com/lchrusciel))
- [#13379](https://github.com/Sylius/Sylius/issues/13379) [Bug][Migrations] Add missing `mysql` check for our migrations to ensure proper syntax is available ([@lchrusciel](https://github.com/lchrusciel))
- [#13392](https://github.com/Sylius/Sylius/issues/13392) [Minor] Update possible branch version in GitHub PR template ([@lchrusciel](https://github.com/lchrusciel))
- [#13405](https://github.com/Sylius/Sylius/issues/13405) Class name typo ([@TheDevilOnLine](https://github.com/TheDevilOnLine))
- [#13426](https://github.com/Sylius/Sylius/issues/13426) Architecture tests initialization  ([@Zales0123](https://github.com/Zales0123))
- [#13428](https://github.com/Sylius/Sylius/issues/13428) Symfony2 is no more 💃 ([@Zales0123](https://github.com/Zales0123))
- [#13430](https://github.com/Sylius/Sylius/issues/13430) [Maintenance] Do not skip auto-configuration tests ([@lchrusciel](https://github.com/lchrusciel))
- [#13435](https://github.com/Sylius/Sylius/issues/13435) [Behat] [Taxons] Fixed issue with asserting Taxons ([@TheDevilOnLine](https://github.com/TheDevilOnLine))
- [#13439](https://github.com/Sylius/Sylius/issues/13439) Recalculate cart on remove item ([@SirDomin](https://github.com/SirDomin))
- [#13454](https://github.com/Sylius/Sylius/issues/13454) Using phparkitect github actions ([@AlessandroMinoccheri](https://github.com/AlessandroMinoccheri))
- [#13455](https://github.com/Sylius/Sylius/issues/13455) Delay 1.11 one more time ([@Zales0123](https://github.com/Zales0123))
- [#13459](https://github.com/Sylius/Sylius/issues/13459) [API] Bring back SwaggerUI overriding ([@lchrusciel](https://github.com/lchrusciel))
- [#13490](https://github.com/Sylius/Sylius/issues/13490) Unify latest CHANGELOGs format with the previous ones ([@Zales0123](https://github.com/Zales0123))

## v1.10.7 (2021-12-09)

#### Details

- [#13365](https://github.com/Sylius/Sylius/issues/13365) Let's not release Sylius 1.11 on Sunday ([@Zales0123](https://github.com/Zales0123))
- [#13372](https://github.com/Sylius/Sylius/issues/13372) Remove ORM 2.10 conflict ([@mbabker](https://github.com/mbabker))
- [#13373](https://github.com/Sylius/Sylius/issues/13373) Revert "Move "polishsymfonycommunity/symfony-mocker-container" into dev dependencies" due to the BC break ([@lchrusciel](https://github.com/lchrusciel))

## v1.10.6 (2021-12-07)

#### Details

- [#11751](https://github.com/Sylius/Sylius/issues/11751) [Core] added default factory for avatar image ([@foxou33](https://github.com/foxou33), [@lchrusciel](https://github.com/lchrusciel))
- [#13118](https://github.com/Sylius/Sylius/issues/13118) Move "polishsymfonycommunity/symfony-mocker-container" into dev dependencies ([@stloyd](https://github.com/stloyd))
- [#13275](https://github.com/Sylius/Sylius/issues/13275) [Maintenance] Add note about doctrine/dbal requirement ([@lchrusciel](https://github.com/lchrusciel))
- [#13278](https://github.com/Sylius/Sylius/issues/13278) [Behat] Remove deprecated whitespace from behat tags ([@GSadee](https://github.com/GSadee))
- [#13282](https://github.com/Sylius/Sylius/issues/13282) [API] Revert changes of checked keys in cart and checkout responses to fix the build ([@GSadee](https://github.com/GSadee))
- [#13307](https://github.com/Sylius/Sylius/issues/13307) [Docs] Drop 1.9 bug support ([@lchrusciel](https://github.com/lchrusciel))
- [#13310](https://github.com/Sylius/Sylius/issues/13310) Corrections for adding a field to the response ([@j92](https://github.com/j92))
- [#13320](https://github.com/Sylius/Sylius/issues/13320) Remove swagger decorators when docs are disabled ([@paullla](https://github.com/paullla))
- [#13322](https://github.com/Sylius/Sylius/issues/13322) [Spec] change username to runtime exception ([@SirDomin](https://github.com/SirDomin), [@lchrusciel](https://github.com/lchrusciel))
- [#13335](https://github.com/Sylius/Sylius/issues/13335) [Minor] Removal of additional spaces and deprecation version fix ([@lchrusciel](https://github.com/lchrusciel))
- [#13357](https://github.com/Sylius/Sylius/issues/13357) Add Symfony 5.4 support for Sylius 1.10  ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee), [@lchrusciel](https://github.com/lchrusciel))
- [#13360](https://github.com/Sylius/Sylius/issues/13360) Minimize number of build for packages ([@Zales0123](https://github.com/Zales0123))

## v1.10.5 (2021-11-03)

#### Details

- [#13162](https://github.com/Sylius/Sylius/issues/13162) [docs] typofixes ([@nexxai](https://github.com/nexxai))
- [#13165](https://github.com/Sylius/Sylius/issues/13165) [HotFix] Add conflict to doctrine/orm to fix the problem with creating taxons ([@GSadee](https://github.com/GSadee))
- [#13173](https://github.com/Sylius/Sylius/issues/13173) [HotFix] Update conflict to doctrine/orm to fix the problem with creating taxons ([@GSadee](https://github.com/GSadee))
- [#13215](https://github.com/Sylius/Sylius/issues/13215) Add conflict with doctrine/dbal ^3 to avoid missing `json_array` doctrine type error ([@Prometee](https://github.com/Prometee))
- [#13216](https://github.com/Sylius/Sylius/issues/13216) [Maintenance] Bump node version in CI ([@lchrusciel](https://github.com/lchrusciel))
- [#13232](https://github.com/Sylius/Sylius/issues/13232) Update ElasticSearch Depricated Plugin with the maintained one ([@zairigimad](https://github.com/zairigimad))
- [#13242](https://github.com/Sylius/Sylius/issues/13242) [Docs] Delay Sylius 1.11 release ([@Zales0123](https://github.com/Zales0123))
- [#13243](https://github.com/Sylius/Sylius/issues/13243) BUGFIX: #12859 Fix link to ResourceController in documentation ([@Jashi](https://github.com/Jashi))
- [#13244](https://github.com/Sylius/Sylius/issues/13244) Fix builds ([@nedac-sorbo](https://github.com/nedac-sorbo))
- [#13252](https://github.com/Sylius/Sylius/issues/13252) [Maintenance] Replace dbal conflict with explicit requirement ([@lchrusciel](https://github.com/lchrusciel))
- [#13261](https://github.com/Sylius/Sylius/issues/13261) Conflict liip/imagine-bundle ^2.7 ([@Zales0123](https://github.com/Zales0123))
- [#13263](https://github.com/Sylius/Sylius/issues/13263) Remove undocumented conflict on laminas-code ^4.0 ([@4c0n](https://github.com/4c0n))

## v1.10.4 (2021-09-30)

#### Details

- [#13160](https://github.com/Sylius/Sylius/issues/13160) Remove types in public and protected properties in not final classes ([@Zales0123](https://github.com/Zales0123))

## v1.10.3 (2021-09-30)

#### Details

- [#12222](https://github.com/Sylius/Sylius/issues/12222) logo path corrected ([@Snowbaha](https://github.com/Snowbaha), [@CoderMaggie](https://github.com/CoderMaggie))
- [#12452](https://github.com/Sylius/Sylius/issues/12452) [Doc] Customizing admin routes prefix ([@oallain](https://github.com/oallain), [@CoderMaggie](https://github.com/CoderMaggie))
- [#12637](https://github.com/Sylius/Sylius/issues/12637) Missing Behat directory on the path to be excluded ([@tonicospinelli](https://github.com/tonicospinelli))
- [#12786](https://github.com/Sylius/Sylius/issues/12786) [Documentation] Fixed Incorrect Theme Directory And Incorrect Import Paths ([@tugrulgencoglu](https://github.com/tugrulgencoglu))
- [#12824](https://github.com/Sylius/Sylius/issues/12824) [Documentation] Fixed logo customization  (, [@CoderMaggie](https://github.com/CoderMaggie))
- [#12849](https://github.com/Sylius/Sylius/issues/12849) [Docs] Webpack - Display logo on login page ([@Jibbarth](https://github.com/Jibbarth))
- [#12863](https://github.com/Sylius/Sylius/issues/12863) Add yaml configuration examples to the "Custom Payment Gateway" cookbook ([@DennisCodeBuds](https://github.com/DennisCodeBuds))
- [#12892](https://github.com/Sylius/Sylius/issues/12892) [DOCS] Add note about docker builder ([@arti0090](https://github.com/arti0090))
- [#12982](https://github.com/Sylius/Sylius/issues/12982) [Docs] Fix link to token generation for API ([@lchrusciel](https://github.com/lchrusciel))
- [#13012](https://github.com/Sylius/Sylius/issues/13012) Use PHP 7.4 syntax in Sylius components ([@Zales0123](https://github.com/Zales0123))
- [#13038](https://github.com/Sylius/Sylius/issues/13038) PHP 7.4 syntax in Sylius bundles vol.1 ([@Zales0123](https://github.com/Zales0123))
- [#13039](https://github.com/Sylius/Sylius/issues/13039) PHP 7.4 syntax in bundles vol.2 ([@Zales0123](https://github.com/Zales0123))
- [#13040](https://github.com/Sylius/Sylius/issues/13040) PHP 7.4 syntax in bundles vol.3 ([@Zales0123](https://github.com/Zales0123))
- [#13069](https://github.com/Sylius/Sylius/issues/13069) [API] Fix command denormalizer to not throw exception if command does not have constructor ([@lchrusciel](https://github.com/lchrusciel))
- [#13070](https://github.com/Sylius/Sylius/issues/13070) [Minor][DI] Add interface alias to UriBasedSectionProvider ([@lchrusciel](https://github.com/lchrusciel))
- [#13088](https://github.com/Sylius/Sylius/issues/13088) [Docs][Customization Guide][API] Headlines fix ([@CoderMaggie](https://github.com/CoderMaggie))
- [#13102](https://github.com/Sylius/Sylius/issues/13102) Check if the form is submitted before validation ([@jacquesbh](https://github.com/jacquesbh))
- [#13116](https://github.com/Sylius/Sylius/issues/13116) PHP 7.4 syntax in Behat ([@Zales0123](https://github.com/Zales0123))
- [#13154](https://github.com/Sylius/Sylius/issues/13154) [API] Do not allow to address empty cart ([@Zales0123](https://github.com/Zales0123))
- [#13159](https://github.com/Sylius/Sylius/issues/13159) [Build][Hot-fix] Ignore PHPStan analysis for StringInflector ([@Zales0123](https://github.com/Zales0123))

## v1.10.2 (2021-09-02)

#### Details

- [#11623](https://github.com/Sylius/Sylius/issues/11623) Fix #11603, Update documentation to replace use of removed function ([@CoderMaggie](https://github.com/CoderMaggie))
- [#12085](https://github.com/Sylius/Sylius/issues/12085) [Doc] Add contact email ([@MatthieuCutin](https://github.com/MatthieuCutin), [@CoderMaggie](https://github.com/CoderMaggie))
- [#12223](https://github.com/Sylius/Sylius/issues/12223) Remove security.yaml change when disabling localized URLs ([@maximehuran](https://github.com/maximehuran))
- [#12852](https://github.com/Sylius/Sylius/issues/12852) [API] Do not check command arguments if there is an object to populate ([@GSadee](https://github.com/GSadee))
- [#12873](https://github.com/Sylius/Sylius/issues/12873) [Docs] sylius performance boost ([@SirDomin](https://github.com/SirDomin), [@arti0090](https://github.com/arti0090))
- [#12875](https://github.com/Sylius/Sylius/issues/12875) [Admin] Fix shipping totals in order summary ([@aleho](https://github.com/aleho))
- [#12881](https://github.com/Sylius/Sylius/issues/12881) [Documentation] Note about changes related to upgrade to GridBundle 1.10 ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#12885](https://github.com/Sylius/Sylius/issues/12885) [Minor][Docs] Bump requirements version ([@lchrusciel](https://github.com/lchrusciel))
- [#12973](https://github.com/Sylius/Sylius/issues/12973) Fix borders in order - show - addresses ([@pavol-tk](https://github.com/pavol-tk))
- [#12975](https://github.com/Sylius/Sylius/issues/12975) [Docs] fix annotations ([@SirDomin](https://github.com/SirDomin))
- [#12976](https://github.com/Sylius/Sylius/issues/12976) [Documentation] Minor fix in grids docs ([@GSadee](https://github.com/GSadee))
- [#12977](https://github.com/Sylius/Sylius/issues/12977) [Docs] add prefix to sylius customer table ([@SirDomin](https://github.com/SirDomin))
- [#12984](https://github.com/Sylius/Sylius/issues/12984) [Documentation] Move invoice cookbooks to payments section ([@GSadee](https://github.com/GSadee))
- [#12988](https://github.com/Sylius/Sylius/issues/12988) [Docs] Specify Sylius 1.11 release date ([@Zales0123](https://github.com/Zales0123))
- [#12993](https://github.com/Sylius/Sylius/issues/12993) [Build] Force symfony flex in github actions ([@SirDomin](https://github.com/SirDomin))
- [#13018](https://github.com/Sylius/Sylius/issues/13018) [Bug] Fix default sylius config file path in Sylius 1.8 ([@lchrusciel](https://github.com/lchrusciel))
- [#13019](https://github.com/Sylius/Sylius/issues/13019) [Bug] Fix default sylius config file path in Sylius 1.9 ([@lchrusciel](https://github.com/lchrusciel))
- [#13020](https://github.com/Sylius/Sylius/issues/13020) [Bug] Fix default sylius config file path in Sylius 1.10 ([@lchrusciel](https://github.com/lchrusciel))
- [#13027](https://github.com/Sylius/Sylius/issues/13027) Remove serialization moved to admin api bundle ([@AdamKasp](https://github.com/AdamKasp))
- [#13032](https://github.com/Sylius/Sylius/issues/13032) [Docs] Choosing the right branch - fix ([@CoderMaggie](https://github.com/CoderMaggie))

## v1.10.1 (2021-07-30)

#### Details

- [#12751](https://github.com/Sylius/Sylius/issues/12751) [Docs] Describe API customization requirement for SyliusPlus with Sylius 1.9 ([@Zales0123](https://github.com/Zales0123), [@Tomanhez](https://github.com/Tomanhez))
- [#12763](https://github.com/Sylius/Sylius/issues/12763) [Docs] Remove redundant refund interfaces ([@Tomanhez](https://github.com/Tomanhez))
- [#12764](https://github.com/Sylius/Sylius/issues/12764) [Taxon] Wrap resource deletion operation with a transaction to fix a problem with removing used taxon ([@GSadee](https://github.com/GSadee))
- [#12767](https://github.com/Sylius/Sylius/issues/12767) [Documentation] Fix warning about version of Sylius in Plus installation guide ([@GSadee](https://github.com/GSadee))
- [#12768](https://github.com/Sylius/Sylius/issues/12768) [Docs] Update release cycle after 1.10 release ([@CoderMaggie](https://github.com/CoderMaggie))
- [#12770](https://github.com/Sylius/Sylius/issues/12770) [Documentation] One more fix for warning about version of Sylius in Plus installation guide ([@GSadee](https://github.com/GSadee))
- [#12771](https://github.com/Sylius/Sylius/issues/12771) [API] Turn on/off api endpoints with parameter ([@SirDomin](https://github.com/SirDomin))
- [#12776](https://github.com/Sylius/Sylius/issues/12776) [Docs][Plus] Modify plus installation guide ([@Tomanhez](https://github.com/Tomanhez))
- [#12777](https://github.com/Sylius/Sylius/issues/12777) [Docs][Plus] Change steps order ([@Tomanhez](https://github.com/Tomanhez))
- [#12784](https://github.com/Sylius/Sylius/issues/12784) [Documentation][Cookbook] How to add another type of refund? ([@GSadee](https://github.com/GSadee))
- [#12789](https://github.com/Sylius/Sylius/issues/12789) [API] Disable API by default ([@GSadee](https://github.com/GSadee))
- [#12800](https://github.com/Sylius/Sylius/issues/12800) [Documentation] Update Plus installation guide for Sylius 1.10 ([@GSadee](https://github.com/GSadee))
- [#12801](https://github.com/Sylius/Sylius/issues/12801) [Documentation] Update Plus installation guide for Sylius 1.9 ([@GSadee](https://github.com/GSadee))
- [#12804](https://github.com/Sylius/Sylius/issues/12804) Enable API by default in dev environment ([@Zales0123](https://github.com/Zales0123))
- [#12807](https://github.com/Sylius/Sylius/issues/12807) Optimizing the attribute loading in product edit ([@mamazu](https://github.com/mamazu))
- [#12808](https://github.com/Sylius/Sylius/issues/12808) [API] Add missing note about enabling API to UPGRADE-1.10 file ([@GSadee](https://github.com/GSadee))
- [#12811](https://github.com/Sylius/Sylius/issues/12811) [API] Test not providing required fields during registration ([@Zales0123](https://github.com/Zales0123))
- [#12814](https://github.com/Sylius/Sylius/issues/12814) [Documentation] API docs reorganisation  ([@AdamKasp](https://github.com/AdamKasp))
- [#12816](https://github.com/Sylius/Sylius/issues/12816) [Maintenance] Fix 1.8 build ([@GSadee](https://github.com/GSadee), [@SirDomin](https://github.com/SirDomin))
- [#12817](https://github.com/Sylius/Sylius/issues/12817) [Taxation] Add scenarios for applying proper taxes for shipping ([@GSadee](https://github.com/GSadee))
- [#12818](https://github.com/Sylius/Sylius/issues/12818) [Core] Bring back String u function ([@GSadee](https://github.com/GSadee))
- [#12819](https://github.com/Sylius/Sylius/issues/12819) [API] 1.8 api as opt ([@SirDomin](https://github.com/SirDomin))
- [#12820](https://github.com/Sylius/Sylius/issues/12820) [Documentation] Chapter about legacy APIs ([@AdamKasp](https://github.com/AdamKasp))
- [#12823](https://github.com/Sylius/Sylius/issues/12823) [API] Allow creation of commands with no arguments with a default value ([@GSadee](https://github.com/GSadee))
- [#12825](https://github.com/Sylius/Sylius/issues/12825) [API] Do not check command arguments if there is an object to populate ([@GSadee](https://github.com/GSadee))
- [#12826](https://github.com/Sylius/Sylius/issues/12826) [Documentation] New API described in architecture chapter ([@AdamKasp](https://github.com/AdamKasp))
- [#12828](https://github.com/Sylius/Sylius/issues/12828) [Docs] split api customization docs ([@SirDomin](https://github.com/SirDomin))
- [#12833](https://github.com/Sylius/Sylius/issues/12833) [API] Disable API by default ([@GSadee](https://github.com/GSadee))
- [#12837](https://github.com/Sylius/Sylius/issues/12837) [UPGRADE] Split API and non API upgrade files ([@lchrusciel](https://github.com/lchrusciel))
- [#12838](https://github.com/Sylius/Sylius/issues/12838) [UPGRADE] Split API and non API upgrade files ([@lchrusciel](https://github.com/lchrusciel))
- [#12839](https://github.com/Sylius/Sylius/issues/12839) [UI] Add bottom scroll to the order summary table ([@kulczy](https://github.com/kulczy))
- [#12840](https://github.com/Sylius/Sylius/issues/12840) [UPGRADE] Split API and non API upgrade files ([@lchrusciel](https://github.com/lchrusciel))
- [#12843](https://github.com/Sylius/Sylius/issues/12843) [Documentation] Change version of Plus in installation guide ([@GSadee](https://github.com/GSadee))
- [#12844](https://github.com/Sylius/Sylius/issues/12844) [API][PHPSpec] Improve spec for CommandNormalizer ([@GSadee](https://github.com/GSadee))
- [#12845](https://github.com/Sylius/Sylius/issues/12845) Quick Typo update :) ([@FaithlessLooting](https://github.com/FaithlessLooting))

## v1.10.0 (2021-06-28)

#### Details

No additional changes apart from the ones reported in pre-releases.

## v1.10.0-RC.1 (2021-06-28)

#### TL;DR

**This is a security release!**

Fixes the follwing vulnerability:

- [List of order ids, number, items total and token value exposed for unauthorized uses via new API](https://github.com/Sylius/Sylius/security/advisories/GHSA-rpxh-vg2x-526v)

#### Details

- [#12596](https://github.com/Sylius/Sylius/issues/12596) Country api resource shouldn't have created/updated at ([@kayue](https://github.com/kayue))
- [#12618](https://github.com/Sylius/Sylius/issues/12618) [Docs] Fix cookbook for custom entity ([@Tomanhez](https://github.com/Tomanhez))
- [#12682](https://github.com/Sylius/Sylius/issues/12682) Use Symfony 5.2.* instead of ^5.2 for GitHub Actions ([@pamil](https://github.com/pamil))
- [#12683](https://github.com/Sylius/Sylius/issues/12683) Improve the UPGRADE file for Sylius v1.10 ([@pamil](https://github.com/pamil))
- [#12686](https://github.com/Sylius/Sylius/issues/12686) [DOCS] Cookbook for customizing refund process ([@arti0090](https://github.com/arti0090))
- [#12687](https://github.com/Sylius/Sylius/issues/12687) Fix typo and imporve error message ([@dantleech](https://github.com/dantleech))
- [#12690](https://github.com/Sylius/Sylius/issues/12690) [Doctrine] Fix problem with explicitly defining entity managers ([@GSadee](https://github.com/GSadee))
- [#12698](https://github.com/Sylius/Sylius/issues/12698) Fix the build with Symfony 5.3 ([@pamil](https://github.com/pamil))
- [#12699](https://github.com/Sylius/Sylius/issues/12699) [Documentation] Update templates directory in Themes doc ([@CoderMaggie](https://github.com/CoderMaggie))
- [#12701](https://github.com/Sylius/Sylius/issues/12701) Delay Sylius 1.10 release by two weeks ([@pamil](https://github.com/pamil))
- [#12702](https://github.com/Sylius/Sylius/issues/12702) [Documentation] Fix Refund Process Cookbook ([@GSadee](https://github.com/GSadee))
- [#12706](https://github.com/Sylius/Sylius/issues/12706) [Documentation] Tweaks on the refunds process cookbook ([@CoderMaggie](https://github.com/CoderMaggie), [@GSadee](https://github.com/GSadee))
- [#12707](https://github.com/Sylius/Sylius/issues/12707) [Documentation] Fix links in the refunds process cookbook ([@GSadee](https://github.com/GSadee))
- [#12709](https://github.com/Sylius/Sylius/issues/12709) Fix the build after upgrade to Symfony 5.3 in GitHub Actions ([@pamil](https://github.com/pamil))
- [#12715](https://github.com/Sylius/Sylius/issues/12715) [Dql] Add parameter instead of hardcoding it in where statement ([@SirDomin](https://github.com/SirDomin))
- [#12720](https://github.com/Sylius/Sylius/issues/12720) [DQL] Change hardcoded enabled value to parameter in where statements ([@GSadee](https://github.com/GSadee))
- [#12725](https://github.com/Sylius/Sylius/issues/12725) Bring back testing for Symfony ^5.2 ([@pamil](https://github.com/pamil))
- [#12726](https://github.com/Sylius/Sylius/issues/12726) [DQL] Change hardcoded tracked value to parameter in where statements ([@lchrusciel](https://github.com/lchrusciel))
- [#12731](https://github.com/Sylius/Sylius/issues/12731) Add cookbook with how to change tax address ([@arti0090](https://github.com/arti0090))
- [#12732](https://github.com/Sylius/Sylius/issues/12732) Remove unnecessary note about conflict with api-platform/core ([@GSadee](https://github.com/GSadee))
- [#12733](https://github.com/Sylius/Sylius/issues/12733) Bring back conflict to symfony/polyfill-mbstring ([@GSadee](https://github.com/GSadee))
- [#12734](https://github.com/Sylius/Sylius/issues/12734) Revert "Bring back conflict to symfony/polyfill-mbstring" ([@GSadee](https://github.com/GSadee))
- [#12736](https://github.com/Sylius/Sylius/issues/12736) Force Symfony 5.2.* on GitHub Actions ([@pamil](https://github.com/pamil))
- [#12747](https://github.com/Sylius/Sylius/issues/12747) [Docs] Move AdminApi docs to AdminApiBundle ([@Tomanhez](https://github.com/Tomanhez))
- [#12748](https://github.com/Sylius/Sylius/issues/12748) [Documentation][Refund] Add cookbook about refund customization with improvements ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))

## v1.10.0-BETA.1 (2021-05-27)

#### Details

- [#12578](https://github.com/Sylius/Sylius/issues/12578) [API][Shop] Remove channel pricing from shop ([@lchrusciel](https://github.com/lchrusciel), [@SirDomin](https://github.com/SirDomin))
- [#12602](https://github.com/Sylius/Sylius/issues/12602) [Refactor] Unification of buses ([@SirDomin](https://github.com/SirDomin))
- [#12619](https://github.com/Sylius/Sylius/issues/12619) [Docs] Add docs for custom entity with access per admin channel ([@Tomanhez](https://github.com/Tomanhez), [@GSadee](https://github.com/GSadee))
- [#12621](https://github.com/Sylius/Sylius/issues/12621) [API] sorting product by position in taxon ([@AdamKasp](https://github.com/AdamKasp))
- [#12623](https://github.com/Sylius/Sylius/issues/12623) [API] Revert locale to localeCode in pickup cart ([@arti0090](https://github.com/arti0090))
- [#12626](https://github.com/Sylius/Sylius/issues/12626) [Api] Adding product to cart with proper product price per channel ([@Tomanhez](https://github.com/Tomanhez), [@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee))
- [#12627](https://github.com/Sylius/Sylius/issues/12627) [DOCS] API custom logic example ([@arti0090](https://github.com/arti0090), [@GSadee](https://github.com/GSadee))
- [#12628](https://github.com/Sylius/Sylius/issues/12628) [API] Conflict with symfony/property-info due to problem with wrong namespaces of some translation entities ([@GSadee](https://github.com/GSadee))
- [#12632](https://github.com/Sylius/Sylius/issues/12632) [Docs] Mention localhost exposure for easier Facebook login ([@Zales0123](https://github.com/Zales0123))
- [#12633](https://github.com/Sylius/Sylius/issues/12633) [Bug] [Temporary solution] Comment out 2 behats steps for checking notifications ([@SirDomin](https://github.com/SirDomin))
- [#12634](https://github.com/Sylius/Sylius/issues/12634) [DOCS] Change response codeblocks to be more clarified ([@arti0090](https://github.com/arti0090))
- [#12639](https://github.com/Sylius/Sylius/issues/12639) [API]Add inStock serialization to productVariant ([@arti0090](https://github.com/arti0090))
- [#12640](https://github.com/Sylius/Sylius/issues/12640) [DOCS] Modify serialization fields in api ([@arti0090](https://github.com/arti0090))
- [#12642](https://github.com/Sylius/Sylius/issues/12642) [Documentation] Fix Customizing API doc headers inconsistency ([@CoderMaggie](https://github.com/CoderMaggie))
- [#12643](https://github.com/Sylius/Sylius/issues/12643) [README] Fix link to plugin list ([@lchrusciel](https://github.com/lchrusciel))
- [#12644](https://github.com/Sylius/Sylius/issues/12644) [README] Supported versions update ([@lchrusciel](https://github.com/lchrusciel))
- [#12647](https://github.com/Sylius/Sylius/issues/12647) Improve API Platform customisation guide ([@pamil](https://github.com/pamil))
- [#12648](https://github.com/Sylius/Sylius/issues/12648) [Api] Prevent product more than in stock ([@Tomanhez](https://github.com/Tomanhez))
- [#12649](https://github.com/Sylius/Sylius/issues/12649) [API][Product] Expose default variant on product show and index ([@GSadee](https://github.com/GSadee))
- [#12650](https://github.com/Sylius/Sylius/issues/12650) [API][ProductVariant] Fix product variant response by using proper normalizer ([@GSadee](https://github.com/GSadee))
- [#12651](https://github.com/Sylius/Sylius/issues/12651) [API][ProductVariant] Add additional specs for product variant normalizer ([@GSadee](https://github.com/GSadee))
- [#12652](https://github.com/Sylius/Sylius/issues/12652) [API][Product] Add additional specs for product normalizer ([@GSadee](https://github.com/GSadee))
- [#12653](https://github.com/Sylius/Sylius/issues/12653) [API] Add missing inStock field to swagger ([@arti0090](https://github.com/arti0090))
- [#12654](https://github.com/Sylius/Sylius/issues/12654) [Api] Check stock sufficient while cart update ([@Tomanhez](https://github.com/Tomanhez))
- [#12655](https://github.com/Sylius/Sylius/issues/12655) [Documentation][Plus] Minor improvements in cookbook for accessing to entities by channel admins ([@GSadee](https://github.com/GSadee))
- [#12657](https://github.com/Sylius/Sylius/issues/12657) [API] Adding inexistent payment method ([@arti0090](https://github.com/arti0090))
- [#12658](https://github.com/Sylius/Sylius/issues/12658) add validation on complete order ([@AdamKasp](https://github.com/AdamKasp))
- [#12660](https://github.com/Sylius/Sylius/issues/12660) [API] Preventing from choosing unavailable shipping method during checkout ([@GSadee](https://github.com/GSadee))
- [#12661](https://github.com/Sylius/Sylius/issues/12661) [API] Add itemsTotal field to order resource ([@arti0090](https://github.com/arti0090))
- [#12663](https://github.com/Sylius/Sylius/issues/12663) [Api] Customer see description of a product ([@Tomanhez](https://github.com/Tomanhez))
- [#12665](https://github.com/Sylius/Sylius/issues/12665) Add Validation to chose payment method ([@AdamKasp](https://github.com/AdamKasp))
- [#12666](https://github.com/Sylius/Sylius/issues/12666) [API] Prevent from using inexistent shipping method ([@pamil](https://github.com/pamil))
- [#12667](https://github.com/Sylius/Sylius/issues/12667) [Documentation] Customizing CreditMemo entity by adding a new field ([@GSadee](https://github.com/GSadee))
- [#12668](https://github.com/Sylius/Sylius/issues/12668) [API] write order email send test in api bundle ([@pamil](https://github.com/pamil), [@SirDomin](https://github.com/SirDomin))
- [#12669](https://github.com/Sylius/Sylius/issues/12669) [API] short description on product index ([@AdamKasp](https://github.com/AdamKasp))
- [#12671](https://github.com/Sylius/Sylius/issues/12671) [Api] Tests adding incorrect county code to address order ([@Tomanhez](https://github.com/Tomanhez))
- [#12672](https://github.com/Sylius/Sylius/issues/12672) Fix for build of Sylius Standard ([@arti0090](https://github.com/arti0090))
- [#12673](https://github.com/Sylius/Sylius/issues/12673) [API][Address] Remove account prefix from addresses endpoints ([@GSadee](https://github.com/GSadee))
- [#12674](https://github.com/Sylius/Sylius/issues/12674) [Minor] Return shop user after registration command to improve extendibility ([@lchrusciel](https://github.com/lchrusciel))
- [#12675](https://github.com/Sylius/Sylius/issues/12675) Add missing return value ([@AdamKasp](https://github.com/AdamKasp))

## v1.10.0-ALPHA.1 (2021-05-10)

#### TL;DR

- Added support for PHP 8.0 ([#12552](https://github.com/Sylius/Sylius/issues/12552))
- Allowed user password to be null ([#12441](https://github.com/Sylius/Sylius/issues/12441))
- Bumped PHP requirements to 7.4 ([#12297](https://github.com/Sylius/Sylius/issues/12297))
- Removed Admin API Bundle from the default Sylius installation ([#12547](https://github.com/Sylius/Sylius/issues/12547))
- Replaced codes and ids in API v2 with IRIs ([#12487](https://github.com/Sylius/Sylius/issues/12487))
- Replaced deprecated Zend libraries with Laminas replacements ([#12357](https://github.com/Sylius/Sylius/issues/12357))
- Switched to utf8mb4 database charset ([#12429](https://github.com/Sylius/Sylius/issues/12429))
- Unified serialization groups within API v2 ([#12532](https://github.com/Sylius/Sylius/issues/12532))
- Upgraded to API Platform ^2.6 ([#12510](https://github.com/Sylius/Sylius/issues/12510))

#### Details

- [#12048](https://github.com/Sylius/Sylius/issues/12048) [API] Explicitly exclude feature from API implementation ([@lchrusciel](https://github.com/lchrusciel))
- [#12092](https://github.com/Sylius/Sylius/issues/12092) Resource layer tip - English corrections ([@tuala](https://github.com/tuala))
- [#12297](https://github.com/Sylius/Sylius/issues/12297) Bump up requirements to PHP 7.4 ([@pamil](https://github.com/pamil))
- [#12303](https://github.com/Sylius/Sylius/issues/12303) Remove lock file from cache hashes in CI ([@szepeviktor](https://github.com/szepeviktor))
- [#12304](https://github.com/Sylius/Sylius/issues/12304) Update PHPStan configuration ([@szepeviktor](https://github.com/szepeviktor))
- [#12333](https://github.com/Sylius/Sylius/issues/12333) [API] remove promotion coupon ([@arti0090](https://github.com/arti0090))
- [#12347](https://github.com/Sylius/Sylius/issues/12347) Remove roadmap links for now ([@pjedrzejewski](https://github.com/pjedrzejewski))
- [#12357](https://github.com/Sylius/Sylius/issues/12357) Replace zendframework/zend-stdlib with laminas/laminas-stdlib ([@pamil](https://github.com/pamil))
- [#12360](https://github.com/Sylius/Sylius/issues/12360) [API] Password reset ([@arti0090](https://github.com/arti0090))
- [#12366](https://github.com/Sylius/Sylius/issues/12366) [API] change variants to iri + tests ([@SirDomin](https://github.com/SirDomin))
- [#12368](https://github.com/Sylius/Sylius/issues/12368) [API] Account verifying ([@AdamKasp](https://github.com/AdamKasp), [@arti0090](https://github.com/arti0090))
- [#12382](https://github.com/Sylius/Sylius/issues/12382) Filter product variants by product & option values ([@pamil](https://github.com/pamil), [@GSadee](https://github.com/GSadee))
- [#12385](https://github.com/Sylius/Sylius/issues/12385) Add contact email in channel fixture ([@maximehuran](https://github.com/maximehuran))
- [#12390](https://github.com/Sylius/Sylius/issues/12390) Shipping method change key cost to price ([@SirDomin](https://github.com/SirDomin), [@AdamKasp](https://github.com/AdamKasp))
- [#12391](https://github.com/Sylius/Sylius/issues/12391) [API] reseting password with validation ([@arti0090](https://github.com/arti0090))
- [#12395](https://github.com/Sylius/Sylius/issues/12395) [Docs] Add note about doctrine migrations ([@Tomanhez](https://github.com/Tomanhez))
- [#12402](https://github.com/Sylius/Sylius/issues/12402) Remove duplicated entry in composer file and add return type in setup trait ([@arti0090](https://github.com/arti0090))
- [#12405](https://github.com/Sylius/Sylius/issues/12405) Decouple translation used in emails from shopBundle to coreBundle ([@arti0090](https://github.com/arti0090))
- [#12408](https://github.com/Sylius/Sylius/issues/12408) [ApiBundle] Use one kernel in test application ([@GSadee](https://github.com/GSadee))
- [#12419](https://github.com/Sylius/Sylius/issues/12419) [API] Add missing specs and make fixes to reset password PR ([@arti0090](https://github.com/arti0090))
- [#12420](https://github.com/Sylius/Sylius/issues/12420) [API] Adjust reset password requests ([@lchrusciel](https://github.com/lchrusciel))
- [#12424](https://github.com/Sylius/Sylius/issues/12424) Doc: Fix Doctrine project url ([@n3wborn](https://github.com/n3wborn))
- [#12429](https://github.com/Sylius/Sylius/issues/12429) Use 4-Byte UTF-8 Unicode Encoding ([@jacquesbh](https://github.com/jacquesbh))
- [#12431](https://github.com/Sylius/Sylius/issues/12431) Bump elliptic from 6.5.3 to 6.5.4 ([@dependabot](https://github.com/dependabot)[[@bot](https://github.com/bot)])
- [#12441](https://github.com/Sylius/Sylius/issues/12441) [UserBundle] Allow user password to be null for SSO ([@loic425](https://github.com/loic425))
- [#12444](https://github.com/Sylius/Sylius/issues/12444) Create resource belongs to collectionOperation ([@kayue](https://github.com/kayue))
- [#12445](https://github.com/Sylius/Sylius/issues/12445) [Api] Subscribed to newsletter ([@Tomanhez](https://github.com/Tomanhez))
- [#12451](https://github.com/Sylius/Sylius/issues/12451) [Docs] How to add product variants by options to the cart in Sylius API? ([@AdamKasp](https://github.com/AdamKasp))
- [#12456](https://github.com/Sylius/Sylius/issues/12456) Update sspooky13/yaml-standards requirement from ^5.1 to ^5.1 || ^6.0 ([@dependabot-preview](https://github.com/dependabot-preview)[[@bot](https://github.com/bot)])
- [#12457](https://github.com/Sylius/Sylius/issues/12457) Drop sspooky13/yaml-standards ^5.1 in favour of ^6.0 ([@pamil](https://github.com/pamil))
- [#12460](https://github.com/Sylius/Sylius/issues/12460) Use egulias/email-validator ^3.0 ([@pamil](https://github.com/pamil))
- [#12470](https://github.com/Sylius/Sylius/issues/12470) [API] Remove untested route on ProductVariant ([@lchrusciel](https://github.com/lchrusciel))
- [#12472](https://github.com/Sylius/Sylius/issues/12472) [Api] Visitor and Customer add ProductReview ([@Tomanhez](https://github.com/Tomanhez))
- [#12474](https://github.com/Sylius/Sylius/issues/12474) [API] Resend Verification email ([@arti0090](https://github.com/arti0090))
- [#12476](https://github.com/Sylius/Sylius/issues/12476) [API] Subscribing to newsletter on account register ([@arti0090](https://github.com/arti0090))
- [#12477](https://github.com/Sylius/Sylius/issues/12477) [API] product review filters ([@SirDomin](https://github.com/SirDomin))
- [#12478](https://github.com/Sylius/Sylius/issues/12478) Remove unnecessary logic from handler ([@arti0090](https://github.com/arti0090))
- [#12479](https://github.com/Sylius/Sylius/issues/12479) Add few cosmetic improvements in ChangeShopUserPasswordHandler.php and xml files ([@Tomanhez](https://github.com/Tomanhez))
- [#12480](https://github.com/Sylius/Sylius/issues/12480) Change command constructor ([@arti0090](https://github.com/arti0090))
- [#12482](https://github.com/Sylius/Sylius/issues/12482) Remove duplicated service ([@Tomanhez](https://github.com/Tomanhez))
- [#12483](https://github.com/Sylius/Sylius/issues/12483) [Api] Product has last 3 reviews by default ([@SirDomin](https://github.com/SirDomin))
- [#12485](https://github.com/Sylius/Sylius/issues/12485) Use route name instead of a hardcoded '/' to redirect user on logout ([@rimas-kudelis](https://github.com/rimas-kudelis))
- [#12487](https://github.com/Sylius/Sylius/issues/12487) [Api][POC]Convert iri to code in command ([@Tomanhez](https://github.com/Tomanhez), [@arti0090](https://github.com/arti0090))
- [#12491](https://github.com/Sylius/Sylius/issues/12491) [API] Added product average rating ([@SirDomin](https://github.com/SirDomin))
- [#12496](https://github.com/Sylius/Sylius/issues/12496) fixed find files in yaml standards ([@sspooky13](https://github.com/sspooky13))
- [#12497](https://github.com/Sylius/Sylius/issues/12497) [API] Validating shipment that was shipped ([@arti0090](https://github.com/arti0090))
- [#12498](https://github.com/Sylius/Sylius/issues/12498) Convert iri to code in command AddProductReview ([@Tomanhez](https://github.com/Tomanhez))
- [#12499](https://github.com/Sylius/Sylius/issues/12499) [API][Shop] Add validation for adding a product review ([@GSadee](https://github.com/GSadee))
- [#12509](https://github.com/Sylius/Sylius/issues/12509) [API] Add admin and shop section resolvers ([@GSadee](https://github.com/GSadee))
- [#12510](https://github.com/Sylius/Sylius/issues/12510) Update to api platform v2.6 ([@Tomanhez](https://github.com/Tomanhez))
- [#12512](https://github.com/Sylius/Sylius/issues/12512) [API] Fix cart blaming ([@GSadee](https://github.com/GSadee), [@arti0090](https://github.com/arti0090))
- [#12518](https://github.com/Sylius/Sylius/issues/12518) fix: add unique index to token_value in order entity ([@pptasinski](https://github.com/pptasinski))
- [#12526](https://github.com/Sylius/Sylius/issues/12526) Remove unused api cart blamer method add missing spec ([@arti0090](https://github.com/arti0090))
- [#12528](https://github.com/Sylius/Sylius/issues/12528) Refactor cart blaming ([@arti0090](https://github.com/arti0090))
- [#12529](https://github.com/Sylius/Sylius/issues/12529) Cleanup resend verification email handler ([@arti0090](https://github.com/arti0090))
- [#12530](https://github.com/Sylius/Sylius/issues/12530) [API]Unify change quantity endpoint with other orders endpoints ([@arti0090](https://github.com/arti0090))
- [#12532](https://github.com/Sylius/Sylius/issues/12532) [API] Serialization groups unified ([@SirDomin](https://github.com/SirDomin))
- [#12533](https://github.com/Sylius/Sylius/issues/12533) Minor fixes for cart blaming command ([@arti0090](https://github.com/arti0090))
- [#12534](https://github.com/Sylius/Sylius/issues/12534) [Api] upgrade taxon filter on product ([@AdamKasp](https://github.com/AdamKasp), [@GSadee](https://github.com/GSadee), [@SirDomin](https://github.com/SirDomin))
- [#12542](https://github.com/Sylius/Sylius/issues/12542) Upgrade release cycle dates for 1.9 and 1.10 ([@pamil](https://github.com/pamil))
- [#12544](https://github.com/Sylius/Sylius/issues/12544) [API][Checkout] Add tag to promotion scenario ([@lchrusciel](https://github.com/lchrusciel))
- [#12545](https://github.com/Sylius/Sylius/issues/12545) [API][Promotion] Test applying promotion rules ([@lchrusciel](https://github.com/lchrusciel))
- [#12547](https://github.com/Sylius/Sylius/issues/12547) Remove Admin API Bundle from the default Sylius installation ([@pamil](https://github.com/pamil))
- [#12552](https://github.com/Sylius/Sylius/issues/12552) Add support for PHP 8.0 ([@pamil](https://github.com/pamil))
- [#12557](https://github.com/Sylius/Sylius/issues/12557) update Plus installation guide ([@AdamKasp](https://github.com/AdamKasp))
- [#12558](https://github.com/Sylius/Sylius/issues/12558) [Order] Fix race condition problem with multiple order recalculations ([@GSadee](https://github.com/GSadee))
- [#12562](https://github.com/Sylius/Sylius/issues/12562) [DOC] update theme structure documentation ([@Sylvain](https://github.com/Sylvain) [@Just](https://github.com/Just))
- [#12564](https://github.com/Sylius/Sylius/issues/12564) [Docs] add minor improvement to Plus installation guide ([@AdamKasp](https://github.com/AdamKasp))
- [#12565](https://github.com/Sylius/Sylius/issues/12565) [API][Order] Fix possibility to limit orders by refactoring from data provider to extension ([@GSadee](https://github.com/GSadee))
- [#12568](https://github.com/Sylius/Sylius/issues/12568) [API] channel based product collection ([@SirDomin](https://github.com/SirDomin))
- [#12569](https://github.com/Sylius/Sylius/issues/12569) Bugfix | Filter out not enabled products in API collection ([@stloyd](https://github.com/stloyd), [@arti0090](https://github.com/arti0090))
- [#12571](https://github.com/Sylius/Sylius/issues/12571) [API] remove productCode from addToCart ([@SirDomin](https://github.com/SirDomin))
- [#12574](https://github.com/Sylius/Sylius/issues/12574) Upgrade to GitHub-native Dependabot ([@dependabot-preview](https://github.com/dependabot-preview)[[@bot](https://github.com/bot)])
- [#12579](https://github.com/Sylius/Sylius/issues/12579) [API] Validate if product or variant is enabled ([@arti0090](https://github.com/arti0090))
- [#12581](https://github.com/Sylius/Sylius/issues/12581) [Api]Fix isAllowedProperty return type in ReflectionExtractor ([@Tomanhez](https://github.com/Tomanhez), [@pamil](https://github.com/pamil))
- [#12592](https://github.com/Sylius/Sylius/issues/12592) Include just one MySQL 5.7 build ([@pamil](https://github.com/pamil))
- [#12599](https://github.com/Sylius/Sylius/issues/12599) [Docs] Add and improve new api docs ([@AdamKasp](https://github.com/AdamKasp))
- [#12600](https://github.com/Sylius/Sylius/issues/12600) [Api]Add customers id next to token ([@Tomanhez](https://github.com/Tomanhez))
- [#12604](https://github.com/Sylius/Sylius/issues/12604) [API] Cherry pick commits on 1.9 branch for validating if product is enabled during adding to cart ([@arti0090](https://github.com/arti0090), [@GSadee](https://github.com/GSadee))
- [#12609](https://github.com/Sylius/Sylius/issues/12609) Adding product from another channel bugfix ([@arti0090](https://github.com/arti0090))
- [#12610](https://github.com/Sylius/Sylius/issues/12610) Fixes after upmerge ([@AdamKasp](https://github.com/AdamKasp))
- [#12612](https://github.com/Sylius/Sylius/issues/12612) [Documentation] Update cookbook about Facebook login ([@GSadee](https://github.com/GSadee))
- [#12613](https://github.com/Sylius/Sylius/issues/12613) [API] Adding inexistent variant ([@arti0090](https://github.com/arti0090), [@GSadee](https://github.com/GSadee))
- [#12617](https://github.com/Sylius/Sylius/issues/12617) [API][PHPSpec] Fix validator after upmerge ([@GSadee](https://github.com/GSadee))
