# [Contribute To This Project](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> Logo Created with :sparkling_heart: By [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Оголошення:**
>
> Чи хотіли б ви бути супроводжуючим цього проєкту та допомагати підтримувати його роботу? Якщо ви зацікавлені, прочитайте [посібник з супроводу](/translations/maintainer_guide/maintainer_guide.ukr.md ) і надішліть мені повідомлення на [Twitter](https://twitter.com/Syknapse).

---

### Індекс швидкого доступу

#### Зміст

- [Оголошення](#оголошення)
- [Вступ](#вступ)
- [Для кого це?](#для-кого-це)
- [Навіщо це потрібно робити?](#навіщо-це-потрібно-робити)
- [До чого я збираюся внести свій внесок?](#до-чого-я-збираюся-внести-свій-внесок)
- [Переклади](#переклади)
- [Налаштування](#налаштування)
- [Наступні кроки](#наступні-кроки)
- [Подяки](#подяки)

#### Кроки

- [Зробіть свій внесок](#зробіть-свій-внесок)
- [Крок 1 - Створіть “форк” сховища](#крок-1-створіть-форк-сховища)
- [Крок 2 - Зробіть клон сховища](#крок-2-зробіть-клон-сховища)
- [Крок 3 - Створіть нову гілку](#крок-3-створіть-нову-гілку)
- [Крок 4 - Відкрийте основний html файл](#крок-4-відкрийте-файл-indexhtml)
- [Крок 5 - Скопіюйте шаблон картки](#крок-5-скопіюйте-шаблон-картки)
- [Крок 6 - Застосуйте зміни](#крок-6-застосуйте-свої-зміни)
- [Крок 7 - Зробіть коміти змін](#крок-7-зробіть-коміти-своїх-змін)
- [Крок 8 - Надішліть зміни в GitHub](#крок-8-надішліть-зміни-в-github)
- [Крок 9 - Відкрийте Запит на Пул (PR)](#крок-9-відкрийте-запит-на-пул-pull-request)
- [Крок 10 - Відсвяткуйте](#крок-10-відсвяткуйте)

---

## Вступ

Тут ми дізнаємося, як зробити внесок у цей проект або в GitHub/Git використовуючи _Terminal_.
Це посібник, який допоможе початківцям долучитися до простого і зрозумілого проєкту.

### Мета

- Зробіть внесок у проєкт з відкритим кодом.
- Станьте більш досконалими у використанні GitHub.

### Для кого це?

- Це для абсолютних новачків. Якщо ви знаєте, як написати і відредагувати тег прив'язки `<a href="" target=""></a>`, тоді ви можете це зробити.
- Це також для тих, хто має трохи більше досвіду, але хоче зробити свій перший внесок в проєкт з відкритим кодом, або зробити більше внесків для більшого досвіду та впевненості.

### Навіщо це потрібно робити?

Будь-який веб-розробник, початківець або досвідчений, повинен повинен вміти контролювати версії Git, і GitHub є найпопулярнішим сервісом Git, яким користуються всі. Це також серце спільноти Open Source. Освоєння GitHub є важливою навичкою. Внесок у проєкт підвищує вашу впевненість і дає вам що показати у своєму профілі GitHub.

Якщо ви новий розробник і вам цікаво, чи потрібно вам вивчати Git та GitHub, то ось відповідь: [Ви повинні були вивчити Git вчора](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'Новий розробник? Ти повинен був вивчити Git вчора. by Брендон Мореллі, творець CodeBurst.io ').

### До чого я збираюся внести свій внесок

![Картка учасника](/readme-only/card.PNG 'Картка учасника')

Ви збираєтеся опублікувати на цій [веб-сторінці проєкту](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project') картку, схожа на цю. Вона буде включати ваше ім'я, ваш Twitter, короткий опис і 3 посилання на корисні ресурси для веб-розробників, які ви рекомендуєте.

Ви зробите копію шаблону картки всередині HTML-файлу та налаштуєте його за допомогою власної інформації.

---

### Переклади

Цей посібник також доступний на [інших мовах](/translations/README.md)

> Вітаються переклади проєктної документації. Прочитайте ['Посібник з перекладу'](/translations/README.md), щоб зробити свій внесок.

---

### Налаштування

Примітка: Якщо ви не дуже добре володієте інтерфейсом командного рядка [використовуйте навчальний посібник для GitHub Desktop](/translations/README/UKRAINIAN.md))

Спочатку, давайте налаштуємо все, щоб виконати роботу

1. Увійдіть до свого облікового запису GitHub. Якщо у вас ще немає облікового запису, [приєднайтеся до GitHub](https://github.com/join). Перш ніж продовжити, я рекомендую вам пройти [підручник GitHub Hello World](https://guides.github.com/activities/hello-world/).
2. Якщо у вас ще немає Git, [встановіть його тут](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git)

> Тепер, коли все налаштовано, давайте приступимо до роботи над внеском у проєкт.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

### Зробіть свій внесок

Станьте учасником проєкту з відкритим кодом за 10 простих кроків.

_Приблизний час: менше 30 хвилин_.

#### Крок 1: Створіть “форк” сховища

- Мета полягає в тому, щоб зробити копію цього проєкту і помістити її в свій аккаунт.
- Сховище (репозиторій) - це те, як називається проєкт на GitHub, а форк - його копія.
- Переконайтеся, що ви перебуваєте на [головній сторінці](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') цього сховища.

| ![Fork](/readme-only/fork.png "Натисніть на 'Fork'") |
| :-------------------------------------------------: |
|           **Натисніть на кнопку _Fork_**            |

- Тепер у вас є повна копія проєкту у власному сховищі на GitHub. 

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 2: Зробіть клон сховища

- Тепер ми хочемо створити локальну копію проєкту. Тобто це копія, збережена на власному комп'ютері.

![Clone](/readme-only/clone-terminal.png)

- Тепер клонуйте це сховище на свою машину. Натисніть кнопку клонування, а потім клацніть значок копіювання в буфер обміну.
- Сховище (репозиторій) — це те, як проект називається на GitHub, а форк — це його копія.

Відкрийте термінал і виконайте таку команду git:

```bash
git clone "url який ви щойно скопіювали"
```

Наприклад:

```bash
git clone https://github.com/$Username/Contribute-To-This-Project.git
```

де `$Username` це ваше ім’я користувача GitHub. Тут ви копіюєте вміст репозиторію перших внесків на GitHub на свій комп’ютер.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 3: Створіть нову гілку

Перейдіть до каталогу сховища на вашому комп’ютері (якщо ви ще там не перебуваєте):

```bash
cd Contribute-To-This-Project
```

Тепер створіть нову гілку за допомогою команди `git checkout`

```bash
git checkout -b назва-вашої-нової-гілки
```

Наприклад:

```bash
git checkout -b add-$Username-card
```

Примітка: Змініть `$Username` на ваше ім’я користувача GitHub.

- Зараз ви створили нову гілку, яка відокремлена від основної.
- Для наступних кроків переконайтеся, що ви працюєте в цій гілці. Ви побачите назву гілки, у якій ви перебуваєте, у нижній лівій частині текстового редактора, який ви використовуєте, де вказано `$Username-card` як назву вашої гілки.

- **НЕ ПРАЦЮЙТЕ У ГІЛЦІ 'master'**

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 4: Відкрийте файл index.html

Тепер нам потрібно відкрити файл, який ми збираємося редагувати, за допомогою вашого улюбленого редактора коду. Ми використовуємо [VSCode](https://code.visualstudio.com/) як наш улюблений редактор коду.

- Файл `index.html` знаходиться безпосередньо в папці `Contribute-To-This-Project`.
- Ви можете відкрити файл за допомогою такої команди:

```bash
code index.html
```

Примітка: це команда терміналу щоб відкрити файл `index.html` в `VSCode`.

- Тепер файл, який ви збираєтеся редагувати, відкритий у вашому редакторі, і ви готові почати вносити в нього зміни.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 5: Скопіюйте шаблон картки

- Ми зробимо копію шаблону картки, щоб почати працювати над нею
- У верхній частині html-файлу, під розділами `<head>` і `<header>` ви знайдете розділ з міткою `== TEMPLATE ==`
- Скопіюйте все в межах червоного квадрата на зображенні з коментаря `Contributor card START` до коментаря `Contributor card END`

| ![Скопіюйте шаблон картки](/readme-only/card-copy.PNG 'Скопіюйте шаблон картки') |
| :-----------------------------------------------------------------------------: |

- Вставте все це безпосередньо під вказуючим на це коментарем
- Переконайтеся, що між початком вашої картки і кінцем останньої картки є один рядок пробілу. Рекомендується зберігати наш код якомога чіткішим
- Ніколи не використовуйте linter або форматери стилю. Проект має налаштування Prettier

| ![Вставте шаблон картки](/readme-only/card-paste.PNG 'Вставте нижче зазначеного рядка') |
| :-------------------------------------------------------------------------------------: |

- Тепер це **ваша** картка, яку ви можете налаштувати та відредагувати.                              

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 6: Застосуйте свої зміни

- Тепер ми почнемо редагувати html, змінюючи користувацькі поля в нашій картці.

| :arrow_right_hook: Замініть `Name` на ваше ім'я | ![Змініть ім'я](/readme-only/change-name.PNG 'Введіть своє ім\'я') |
| :---------------------------------------------- | :--------------------------------------------------------------: |

- **Примітка: не змінюйте `class="name"`**

| :arrow_right_hook: Вставте URL-адресу свого Твіттера `href="Insert URL here"`, введіть своє ім'я у текстове поле | ![Change contact](/readme-only/change-contact.PNG 'Insert a link to your Twitter account and type your handle') |
| :--------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- Якщо ви віддаєте перевагу іншим контактам, крім Твіттера, вам потрібно замінити значок твіттера `<i class="fa fa-x-twitter"></i>` на [Font Awesome Icons](http://fontawesome.io/icons/), знайшовши потрібну піктограму та замінивши лише частину `fa-x-twitter` на новий значок, наприклад, `fa-facebook`. Потім виконайте ті ж дії, що і вище.

|                                                                                                                                         ![Change about](/readme-only/change-about.PNG 'Напишіть речення про вас')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **Розкажіть дещо про вас. Нехай це буде коротким і приємним. Думайте про це більше як твіт, ніж як публікацію в блозі**                                                                                                                |
|                                                                                                              ![Change resources](/readme-only/change-resources.PNG 'Вставте посилання, напишіть короткий опис і введіть назву ресурсу')                                                                                                              |
| :arrow_right_hook: **Поділіться зі спільнотою 3 посиланнями на ресурси, корисні для веб-розробки. Це може бути що завгодно, відео, виступ, подкаст, стаття, посилання або інструмент. Якщо ви новачок, нехай вас це не лякає, поділіться тим, що знаєте, навіть якщо вважаєте це базовим. Ви здивуєтеся, скільки людей отримають користь.** |

- **Посилання:** вставте посилання `href="сюди"` замінючи `#`. Будь ласка, утримайтеся від використання скорочувачів URL-адрес або URL-адрес, які не належать до сайту, який ви публікуєте!
- **Заголовок:** Напишіть короткий опис `title="сюди"`.
- **Назва:** Напишіть ім'я ресурсу в текстовому полі `>сюди</a>`.
- Переконайтеся, що ви **зберігли всі зміни**.
- **Протестуйте свої зміни**. ЦЕ ДУЖЕ ВАЖЛИВО! Відкрийте html-файл в браузері (наприклад, двічі клікнувши по ньому) і подивіться, як ваша картка буде виглядати на сайті. Переконайтеся, що вся сторінка виглядає однаково і нічого не зламано. Натисніть на свої посилання та переконайтеся, що вони працюють. Відкрийте консоль (Ctrl + Shift + J (Windows / Linux) або Cmd + Opt + J (Mac)) і перевірте, чи немає повідомлень про помилки.
- Чудово, ви закінчили редагувати код! Наступні кроки надішлють ваші зміни до GitHub, а потім відправлять їх до об'єднання з основним проєктом.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 7: Зробіть коміти своїх змін

- Тепер відкрийте термінал у каталозі вашого проекту та запустіть команду `git status`, і ви помітите, що в git не внесено жодних змін.
- Ви можете додати ті зміни, які ви зробили, за допомогою команди `git-add`

```bash
git add index.html
```

- Тепер зафіксуйте ці зміни за допомогою команди `git commit`
- Примітка: замініть `$Username` вашим іменем користувача Github.

```bash
git commit -m "Add $Username card info"
```

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 8: Надішліть зміни в GitHub

- Тепер ваші зміни збережено або committed. Але вони зберігаються тільки локально, тобто на вашому комп'ютері.
- Синхронізація локальних змін зі сховищем GitHub називається _Push_. Ви "проштовхуєте" зміни з локального сховища до віддаленого сховища на GitHub.
- Ми використовуємо команду `git push`, щоб надсилати зміни на github.
- Примітка: замініть `$Username-card` назвою вашої гілки.

```bash
git push -u origin $Username-card
```

- Через кілька секунд операція буде завершена, і тепер у вас є точно така ж копія цієї гілки як на вашому комп'ютері, так і на GitHub.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 9: Відкрийте Запит на Пул (Pull Request)

- Настав момент, якого ви так довго чекали: подання _Запиту на Пул_ (Pull Request - PR).
- Поки що вся робота, яку ви зробили, була пов'язана з форком проєкту, який, як ви пам'ятаєте, знаходиться у вашому власному обліковому записі GitHub.
- Тепер настав час перенести свої зміни в основний проєкт, щоб об'єднати з ним.
- Це називається [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help'), тому що ви просите супроводжуючого (maintainer) оригінального проєкту "перетягнути" ваші зміни до свого проєкту.
- Перейдіть на головну сторінку **вашого форка** на GitHub (нагорі буде значок вилки і ваш логін).
- У верхній частині сховища ви побачите виділене повідомлення Pull Request з зеленою кнопкою.

|  ![Submit a Pull Request](/readme-only/pull-request.PNG 'Зазвичай це знаходиться вгорі сторінки, під описом і над файлами та папками проєкту')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Натисніть на кнопку `Compare and pull request`**                                                     |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'Ви подаєте запит на об\'єднання вашої гілки з вашого форка в головну гілку оригінального проєкту') |
|                                              :arrow_right_hook: Приблизно так виглядає сторінка `Open a pull request`.                                               |

- ПАМ'ЯТАЙТЕ, _ви намагаєтеся об'єднати вашу гілку з оригінальним проєктом, а не з гілкою `Master` вашого форка_.
- Зображення нижче дасть вам уявлення про те, як має виглядати заголовок вашого pull request.
- Зліва - оригінальний проєкт, за яким слідує гілка `Master`. Праворуч - ваш форк і гілка, яку ви створили.

|                   ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Натисніть зелену кнопку. Не лякайтеся!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Створить pull request: введіть заголовок, додайте необов'язкову інформацію в опис і натисніть на `Create pull request`** |

- Нехай вас не бентежать усі варіанти. Поки що вам потрібно виконати лише ці три кроки.
- Залиште опцію `Allow edits from maintainers` позначеною галочкою.
- Тепер, ваш _Pull Request_ буде надіслано супроводжуючому оригінального проєкта. Коли він буде розглянутий та прийнятий, ваші зміни з'являться на вкладці [веб-сторінки проєкту](https://syknapse.github.io/Contribute-To-This-Project 'Contribute To This Project web page').

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 10: Відсвяткуйте

От і все. Ви зробили це! Тепер ви зробили свій внесок у відкритий код на GitHub.

Ви додали код на опубліковану веб-сторінку: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Ваші зміни **не будуть помітні відразу**; Спочатку вони повинні бути переглянуті, прийняті та консолідовані супроводжувачем проєкту. Після їх об'єднання ваша картка повинна бути видимою і діючою на сторінці.

Це цілком нормально, якщо рецензент може просити про внесення змін в ваш PR. Вважайте це хорошою практикою, якщо так трапиться з вами. Слідкуйте за коментарями та запитами на внесення змін. Після того, як ви внесли запрошені рецензентом зміни (у свою гілку), все, що вам потрібно, це зробити commit та push ваших змін. PR буде автоматично оновлений новими змінами.

Обіцяю, що постараюся переглянути і об'єднати якомога швидше, але роблю це у вільний час, тому затримка на кілька днів неминуча.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

### Наступні кроки

- Поверніться через деякий час, щоб перевірити, як обробився ваш Pull Request.
- Ви повинні отримати електронний лист від GitHub, коли ваші зміни будуть схвалені, або якщо будуть запитані додаткові зміни. І коли PR буде остаточно з'єднаний з master, ваша картка буде додана.
- Ви також можете дізнатися, як зробити свій внесок із цієї _безкоштовної_ серії: [Як зробити внесок у проект з відкритим кодом на GitHub](https://kcd.im/pull-request)
- Якщо ви вважаєте цей проєкт **корисним**, будь ласка, поставте йому :star: зірочку :star: у верхній частині сторінки і напишіть **Tweet** про нього щоб допомогти поширити інформацію [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project').
- Ви можете **стежити за мною** і зв'язатися зі мною на [Twitter](https://twitter.com/Syknapse '@Syknapse') або [використайте будь-який з цих інших варіантів](https://syknapse.github.io/Syk-Houdeib/#contact 'Розділ мої контакти | Портфоліо').
- Це проєкт з відкритим кодом, тому, окрім додавання вашої картки, ви можете допомогти виправити помилки, покращити або створити нові функції. Відкрийте [проблему](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') або надішліть новий [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help').
- Щоб допомогти покращити нашу спільноту, погляньте на розділ GitHub [Discussions](https://github.com/Syknapse/Contribute-To-This-Project/discussions), розташований поруч з Pull Requests. Це місце, де можна представитися, заглибитися в дискусію Open Source та поспілкуватися з супроводжуючими проєкту. Допоможете нам створити цю функцію та покращити нашу спільноту?
- **Дякуємо, що зробили свій внесок у цей проєкт**. Тепер ви можете спробувати зробити свій внесок в інші проєкти; зверніть увагу на позначку ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png), щоб знайти варіанти зробити свій внесок, зручні для початківців.
- Я також шукаю співавторів, які могли б допомогти мені з експертною оцінкою та об'єднанням PR. Якщо ви хочете отримати більш просунуту практику Git, будь ласка, напишіть мені DM у Twitter і прочитайте [керівництво супроводжуючого](/maintainer_guide.md).

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

### Подяки

На цей проєкт сильно вплинула робота [Рошана Джоссі](https://github.com/Roshanjossey) Чудові [перші внески](https://github.com/Roshanjossey/first-contributions) з його чудовим підручником.

Цей проєкт також особливо надихається великою спільнотою навколо [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) Стипендія Google Challenge: Front-End Web Dev, клас 2017 року в Європі.

### 100 найкращих авторів

[![Зображення учасників GitHub](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
