# [Contribua Com Este Projeto](https://syknapse.github.io/Contribute-To-This-Project/)

![informação da imagem](/favicon.png)

> Logo Criado com :sparkling_heart: Por [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Entre no nosso servidor do Discord!')
[![PRs Bem vindos](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Amor Open Source](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Anúncio:**
>
> Gostaria de se tornar um mantenedor deste projeto e ajudar a mantê-lo ativo? Se estiver interessado, leia o [maintainer's guide](/maintainer_guide.md) e envie-me uma DM [Twitter](https://twitter.com/Syknapse).

---

### Índice de Acesso Rápido

#### Visão Geral

- [Anúncio](#anúncio)
- [Introdução](#introdução)
- [Para quem é isso?](#para-quem-é-isso)
- [Porque preciso fazer isso?](#por-que-preciso-fazer-isso)
- [Com o que eu irei contribuir?](#com-o-que-eu-vou-contribuir)
- [Tradução](#traduções)
- [Configuração](#configuração-)
- [Próximos Passos](#passos)
- [Agradecimentos](#agradecimentos)

#### Passos

- [Contribue](#contribua)
- [Step 1 - Forking](#passo-1-de-um-fork-nesse-repositório)
- [Step 2 - Clonando](#passo-2-clone-esse-repositório)
- [Step 3 - Criando uma nova branch](#passo-3-crie-uma-nova-branch)
- [Step 4 - Abrindo o arquivo main html](#passo-4-abra-o-arquivo-indexhtml)
- [Step 5 - Copiando o card modelo](#passo-5-copie-o-modelo-de-card)
- [Step 6 - Aplicando suas mudanças](#passo-6-aplique-suas-mudanças)
- [Step 7 - Committing](#passo-7-commit-suas-mudanças)
- [Step 8 - Enviando para o GitHub](#passo-8-envie-suas-alterações-para-o-github)
- [Step 9 - Enviar um PR](#passo-9-envie-um-pr-pull-request)
- [Step 10 - Comemore](#passo-10-comemore)

---

## Introdução

Aqui vamos aprender como contribuir para este projeto ou no GitHub/Git usando o Terminal.
Este é um tutorial para ajudar contribuidores de primeira viagem a participarem de um projeto simples e fácil.

### Objetivos

- Fazer uma contribuição para um projeto de código aberto.
- Sentir-se mais confortável usando o GitHub.

### Para quem é isso?

- Isso é para iniciantes absolutos.  Se você sabe como escrever e editar uma tag de âncora `<a href="" target=""></a>` então você deve ser capaz de fazer isso.
- É também para aqueles com um pouco mais de experiência, mas que desejam fazer sua primeira contribuição para o código aberto, ou conseguir mais contribuições para adquirir mais experiência e confiança.

### Por que preciso fazer isso?

Qualquer desenvolvedor web, aspirante ou experiente, precisa usar o controle de versão Git, e o GitHub é o serviço de hospedagem Git mais popular usado por todos. Ele também é o coração da comunidade Open Source. Tornar-se confortável usando o GitHub é uma habilidade essencial. Fazer uma contribuição para um projeto aumenta sua confiança e oferece algo para mostrar no seu perfil do GitHub.

Se você é um novo desenvolvedor e está se perguntando se precisa aprender Git e GitHub, aqui está a resposta: [Você Deveria Ter Aprendido Git Ontem](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'Novo Desenvolvedor? Você deveria ter aprendido Git ontem. por Brandon Morelli, criador do CodeBurst.io').

### Com o que eu vou contribuir?

![Card de contribuidor](/readme-only/card.PNG 'Card de contribuidor')

Você vai contribuir com um card como esse aqui para a [página web do projeto](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project'). Ele incluirá seu nome, seu usuário no Twitter, uma descrição curta e 3 links para recursos úteis para desenvolvedores web que você recomenda.

Você fará uma cópia do modelo de cartão dentro do arquivo HTML e personalizá-lo com suas próprias informações.

---

### Traduções

Esse tutorial está disponivel em [outros idiomas](/translations/README.md)

| [English](/terminal_tutorial.md) | [Bangla](/translations/terminal_tutorial/terminal_tutorial.ben.md) | [Ukrainian](/translations/terminal_tutorial/terminal_tutorial.ukr.md) | [Chinese (Traditional)](/translations/terminal_tutorial/terminal_tutorial.zho-tc.md)| [Portuguese](/translations/terminal_tutorial/terminal_tutorial.por-br.md)|
| :----: | :----: | :----: | :----: | :----: |

> Traduções para documentações de projetos são bem-vindas. Leia [`Guia de tradução`](/translations/README.md) para contribuir.

---

### Configuração! :)

Nota: Se vocÊ não é bom com a interface de linha de comando [Aqui está o tutorial de GUI usando o Github desktop](/README.md)

Primeiro, vamos configurar para realizar o trabalho.

1. Entre em sua conta no Github. Se você não tem uma conta [crie uma aqui](https://github.com/join). Eu recomendo que você faça o [tutorial de Hello World do GitHub](https://guides.github.com/activities/hello-world/) before you continue.
2. If you don't have Git, [instale aqui](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git)

> Agora que está tudo configurado, vamos ao trabalho de contribuir para o projeto.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

### Contribua

Torne-se um contribuidor de código aberto em 10 passos fáceis.

_Tempo estimado: Menos de 30 minutos_.

#### Passo 1: De um fork nesse repositório

- O objetivo aqui é fazer uma cópia deste projeto e colocá-la na sua conta.
- Um repositório (repo) é como um projeto é chamado no GitHub e um fork é uma cópia dele.
- Tenha certeza que você está na [pagina main](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') desse repositório.

| ![Fork](/readme-only/fork.png "click on 'Fork'") |
| :---------------------------------------------: |
|         **Clique no botão _Fork_**          |

- Agora você tem uma cópia completa do projeto na sua própria conta.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 2: Clone esse repositório

- Agora nós temos que fazer uma cópia local desse projeto. Uma cópia salva no seu próprio computador.

![Clone](/readme-only/clone-terminal.png)

- Agora clone este repositório para sua máquina. Clique no botão de clonar e então clique no ícone de copiar para a área de transferência.
- Um repositório (repo) é como um projeto é chamado no GitHub e uma cópia é uma duplicação dele.

Abra um terminal e execute o seguinte comando git:

```bash
git clone "url que voce copiou"
```

Por exemplo:

```bash
git clone https://github.com/$NomeDeUsuario/Contribute-To-This-Project.git
```

Onde `$NomeDeUsuario` é o seu nome de usuario do GitHub.  Aqui você está copiando o conteúdo do repositório first-contributions no GitHub para o seu computador.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 3: Crie uma nova branch

Mude para o diretório que está o repositório em sua máquina (Se você ainda não estiver lá):

```bash
cd Contribute-To-This-Project
```

Agora crie uma nova branch e use o comando `git checkout`

```bash
git checkout -b nome-da-sua-nova-branch
```

Por exemplo:

```bash
git checkout -b add-$NomeDeUsuario-card
```

Nota: Mude `$NomdeDeUsuario` pelo seu nome de usuário da sua conta do GitHub.

- Agora você criou uma nova branch separada da master.
- Para os próximos passos, certifique-se de estar trabalhando nesta branch. Você verá o nome da branch em que está no canto inferior esquerdo do editor de texto que você está usando, onde diz.
`$NomeDeUsuario-card` como o nome da sua branch.

**NÃO trabalhe na branch master**

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 4: Abra o arquivo index.html

Agora precisamos abrir o arquivo que vamos editar com o seu editor de código favorito. Estamos usando o [VSCode](https://code.visualstudio.com/) como nosso editor de código preferido.

- O arquivo `index.html` está diretamente na pasta `Contribute-To-This-Project`.
- Você pode abrir o arquivo com o seguinte comando:

```bash
code index.html
```

Nota: Esse é um código de termenal para abrir o arquivo: `index.html` in `VSCode`.

- Agora você tem o arquivo que você irá abrir para editar, e estar pronto para começar a fazer as alterações nele.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 5: Copie o modelo de Card

- Nós vamos mudar a cópia do modelo de Card para começar a trabalhar.
- No topo do arquivo html, em baixo das seções `<head>` e `<header>` você vai achar a seção rotulada `== TEMPLATE ==`
- Copie tudo dentro do quadro vermelho na imagem, do comentário Contribuidor card START até o comentário Contribuidor card END.

| ![Copie o modelo do Card](/readme-only/card-copy.PNG 'Copie o modelo do Card') |
| :-----------------------------------------------------------------------: |

- Cole o conteúdo inteiro diretamente abaixo do comentário que indica isso.
- Certifique-se de que haja uma única linha de espaço entre o início do seu cartão e o final do último cartão. É uma boa prática manter nosso código o mais claro possível.
- Nunca use linters ou formatadores de estilo. O projeto tem a configuração do Prettier.

| ![Cole o modelo do Card](/readme-only/card-paste.PNG 'Cole abaixo da linha indicada') |
| :---------------------------------------------------------------------------------: |

- Agora **esse** é seu Card para editar e personalizar.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 6: Aplique suas mudanças

- Bem, agora nós vamos começar a editar o arquivo html, Mudando e customizando os campos no nosso card.

| :arrow_right_hook: Substitua 'Name' pelo seu nome | ![mude o nome](/readme-only/change-name.PNG 'Escreva seu nome') |
| :----------------------------------------------- | :----------------------------------------------------------: |

- **Nota: Não mude `class="name"`**

| :arrow_right_hook: Digite a URL para a conta do seu twitter `href="Insert URL here"`, Digite seu identificador no campo de texto | ![Mude o contato](/readme-only/change-contact.PNG 'Insira um link da sua conta do twitter e digite seu identificador') |
| :--------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- Se você preferir usar um contato diferente do Twitter, você precisará substituir o ícone do Twitter `<i class="fa fa-x-twitter"></i>` visitando [Font Awesome Icons](http://fontawesome.io/icons/) e procurando pelo ícone certo, substituindo apenas a parte fa-x-twitter pelo novo ícone como fa-facebook, por exemplo. Depois, siga os mesmos passos acima.

|                                                                                                                                         ![Change about](/readme-only/change-about.PNG 'Write a sentence about you')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **Nos diga algo sobre você. Mantenha isso curto e direto. Penso mais como um tweet do que um post de  blog**                                                                                                                |
|                                                                                                              ![Mudando os recursos](/readme-only/change-resources.PNG 'Insira um link, escreva uma curta descrição, e digite o nome do recurso')                                                                                                              |
| :arrow_right_hook: **Compartilhe com a comunidade 3 links para recursos úteis para desenvolvimento web. Isso pode ser qualquer coisa, um vídeo, uma palestra, um podcast, um artigo, uma referência ou uma ferramenta. Se você é iniciante, não se intimide com isso, compartilhe o que você sabe, mesmo que você pense que é básico. Você ficará surpreso com quantas pessoas se beneficiarão.** |

- **Link:** Insira o link href="aqui" substituindo o `#`. Por favor, evite usar encurtadores de URL ou URLs que não sejam do site que você está postando!
- **Title:** Escreva uma descrição breve title="aqui".
- **Name:** Escreva o nome do recurso no campo de texto `>aqui</a>`.
- Tenha certeza que você **salvou todas as suas mudanças**.
- **Teste suas mudanças**. ISSO É IMPORTANTE! Abra o arquivo html no seu navegador (clicando duas vezes nele por exemplo) e veja como o seu cartão ficará no site. Verifique se a página inteira ainda parece a mesma e que nada está quebrado. Clique nos seus links e certifique-se de que estão funcionando. Abra o console (Ctrl + Shift + J (Windows / Linux) ou Cmd + Opt + J (Mac)) e verifique se não há mensagens de erro.
- Ótimo, você terminou de editar seu código! Os próximos passos enviarão suas alterações para o GitHub e depois as submeterão para serem mescladas com o projeto principal.


[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 7: Commit suas mudanças

- Agora abra o terminal no diretório do seu projeto e execute git status e você notará que não há alterações feitas no git.
= Você pode adicionar essas alterações que fez usando o comando git add


```bash
git add index.html
```

- Agora faça o commit dessas alterações usando o comando git commit

```bash
git commit -m "Add $NomeDeUsuario card info"
```

- Substituindo $NomeDeUsuario pelo seu nome de usuário do GitHub.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 8: Envie suas alterações para o GitHub

- Suas alterações estão agora salvas ou "commitadas". Mas estão salvas apenas localmente, ou seja, no seu computador.
- Sincronizar alterações locais com o seu repositório no GitHub é chamado de Push. Você está "empurrando" as alterações do seu repositório local para o repositório remoto no GitHub.
- Usamos o comando git push para enviar alterações para o GitHub.


```bash
git push -u origin $NomeDeUsuario-card
```

- Substituindo $NomeDeUsuario-card pelo nome da sua branch.

- Após alguns segundos, a operação estará completa e agora você terá exatamente a mesma cópia desta branch no seu computador e no GitHub.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 9: Envie um PR (Pull Request)

- Este é o momento que você estava esperando; enviando um _Pull Request_ (PR).
- Até agora, todo o trabalho que você fez foi no fork do projeto, que, como você se lembra, está na sua própria conta do GitHub.
- Agora é hora de enviar suas alterações para o projeto principal para serem mescladas com ele.
- Isso se chama [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'Sobre Pull Requests - GitHub Help') Porque você está pedindo ao mantenedor original do projeto para dar um "pull" em suas alterações para o projeto dele.
- Vá para a página principal do seu fork no GitHub (ele terá o ícone de fork e seu próprio nome de usuário no topo).
- Perto do topo do repositório, você verá uma mensagem destacada de pull request com um botão verde.

|  ![Envie um Pull Request](/readme-only/pull-request.PNG 'Isso geralmente fica no topo da página, abaixo da descrição e acima dos arquivos e pastas do projeto.')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Clique em `Compare and pull request`**                                                     |
| ![Abra um Pull Request](/readme-only/pull-request-branches.PNG 'Você está solicitando a fusão da sua branch do seu fork na branch master do projeto original') |
|                                              :arrow_right_hook: Isso é o que a pagina `Open a pull request` parece.                                               |

- LEMBRE-SE _você está tentando mesclar sua branch com o projeto original, não com a branch Master do seu fork._.
- A imagem abaixo dá uma ideia de como o cabeçalho do seu pull request deve parecer.
- À esquerda está o projeto original, seguido pela branch master. À direita está o seu fork e a branch que você criou.

|                   ![Envie um Pull Request](/readme-only/pull-request-open.PNG "Clique no botão verde. Não tenha medo!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Crie um pull request: Escreva um título, Adicione informações opcionais na descrição e Clique em Criar pull request`** |

- Não se intimide com todas as opções. Você só precisa fazer esses três passos por enquanto.
- Deixe a opção Permitir edições dos mantenedores marcada.
- Agora, um Pull Request será enviado ao mantenedor do projeto. Assim que for revisado e aceito, suas alterações aparecerão na [página web do projeto](https://syknapse.github.io/Contribute-To-This-Project 'Contribua com esse projeto web').

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

#### Passo 10: Comemore

É isso. Você conseguiu! Agora você contribuiu para um projeto de código aberto no GitHub.

Você adicionou código a uma página web ao vivo: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Suas alterações não serão visíveis imediatamente; primeiro elas têm que ser revisadas, aceitas e mescladas pelo mantenedor do projeto. Uma vez mescladas, seu cartão deverá ser visível e ativo na página.

É muito normal que um revisor peça alterações em um PR. Pense nisso como uma boa prática se acontecer com você. Fique atento para comentários e alterações solicitadas. Depois de fazer as alterações solicitadas (de volta à sua branch), tudo o que você precisa fazer é confirmar e enviar suas alterações. O PR será atualizado automaticamente com as novas alterações.

Prometo que tentarei revisar e mesclar o mais rápido possível, mas faço isso no meu tempo livre, então um pequeno atraso é inevitável.

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

### Próximos Passos

- Volte depois de um tempo para verificar seu Pull Request mesclado.
- Você deve receber um e-mail do GitHub quando suas alterações forem aprovadas ou se forem solicitadas alterações adicionais. E quando o PR finalmente for mesclado com o master e seu cartão tiver sido adicionado.
- Você também pode aprender como contribuir com esta série gratuita: [Como Contribuir para um Projeto de Código Aberto no GitHub](https://kcd.im/pull-request)
- Se você achou este projeto **útil**por favor, dê uma :star: estrela :star: no topo da página e Tweet sobre ele para ajudar a espalhar a palavra [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]
- Você pode **me seguir**  e entrar em contato no [Twitter](https://twitter.com/Syknapse '@Syknapse') ou [usando qualquer uma dessas outras opções](https://syknapse.github.io/Syk-Houdeib/#contact 'Minha sessão de contato | Portfolio')
- Este é um projeto de código aberto, então, além de contribuir com seu cartão, você é bem-vindo para ajudar a corrigir bugs, melhorias ou novos recursos. Abra uma [issue](https://help.github.com/articles/creating-an-issue/ 'Masterizando Issues | GitHub Guides') ou envie um [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Criando um pull request de um fork | GitHub Help')
- Para ajudar a melhorar nossa comunidade, dê uma olhada na aba [Discussões](https://github.com/Syknapse/Contribute-To-This-Project/discussions) do GitHub localizada ao lado de Pull Requests. Esta área é um lugar para se apresentar, entrar em discussões mais profundas sobre código aberto e se comunicar com os Mantenedores do Projeto. Você nos ajudará a desenvolver esse recurso e melhorar nossa comunidade?
- **Obrigado por contribuir para este projeto**. Agora você pode seguir em frete e tentar contribuir com outros projetos; Procure pelo selo ![primeira boa Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png)  para opções de contribuição amigáveis para iniciantes.
- Também estou procurando colaboradores para me ajudar na revisão e mesclagem de PRs. Se você gostaria de praticar mais o Git, por favor, me envie uma DM no Twitter e leia o guia do mantenedor. [mantenedor guide](/maintainer_guide.md).

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

---

### Agradecimentos

Este projeto é fortemente influenciado pelo [Roshan Jossey's](https://github.com/Roshanjossey) excelente [first-contributions](https://github.com/Roshanjossey/first-contributions) projeto first-contributions de Roshan Jossey com seu excelente tutorial.

Ele também é particularmente inspirado pela grande comunidade em torno de [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) O Google Challenge Scholarship: Front-End Web Dev, turma de 2017 da Europa.

### Top 100 Contribuidores

[![GitHub Contribuidores Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[↑ Vá para o topo ↑](#índice-de-acesso-rápido)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'De Tweet um sobre esse projeto'
