# [Zu diesem Projekt beitragen](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> Logo mit :sparkling_heart: erstellt von [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## Ausschreibung
>
> Willst Du ein Maintainer dieses Projekts werden und helfen, es am Laufen zu halten? Bei Interesse lies den [Maintainers Guide](/translations/maintainer_guide/maintainer_guide.ger.md) und sende mir eine PN bei [Twitter](https://twitter.com/Syknapse).

---

### Schnellzugriff

#### Übersicht

- [Ausschreibung](#ausschreibung)
- [Einleitung](#einleitung)
- [Für wen ist es geeignet?](#für-wen-ist-es-geeignet)
- [Warum sollte ich mitmachen?](#warum-sollte-ich-mitmachen)
- [Was werde ich beitragen?](#was-werde-ich-beitragen)
- [Übersetzungen](#übersetzungen)
- [Setup](#setup-)
- [Nächste Schritte](#nächste-schritte)
- [Danke](#danke)

#### Steps

- [Beitragen](#beitragen)
- [Schritt 1: Fork dieses Repository](#schritt-1-fork-dieses-repository)
- [Schritt 2: Clone das Repository](#schritt-2-clone-das-repository)
- [Schritt 3: Erstelle einen Branch](#schritt-3-erstelle-einen-branch)
- [Schritt 4: Öffne die Datei index.html](#schritt-4-öffne-die-datei-indexhtml)
- [Schritt 5: Kopiere die Karten-Vorlage](#schritt-5-kopiere-die-karten-vorlage)
- [Schritt 6: Änderungen eintragen](#schritt-6-änderungen-eintragen)
- [Schritt 7: Commit Deine Änderungen](#schritt-7-commit-deine-änderungen)
- [Schritt 8: Push Deine Änderungen zu GitHub](#schritt-8-push-deine-änderungen-zu-github)
- [Schritt 9: Erstelle einen PR(Pull Request)](#schritt-9-erstelle-einen-prpull-request)
- [Schritt 10: Feier](#schritt-10-feier)

---

## Einleitung

Hier lernst Du, wie Du zu diesem Projekt bzw. in Git/GitHub über das *Terminal* beitragen kannst.
Dieses Tutorial hilft Erstautoren zu einem einfachen und unkomplizierten Projekt beizutragen.

### Ziele

- Trage zu einem Open-Source-Projekt bei.
- Werde vertrauter in der GitHub-Benutzung.

### Für wen ist es geeignet

- Es ist für absolute Anfänger geeignet. Wenn Du weißt, wie man einen Anker-tag `<a ref="" target=""></a>` schreibt und editiert, solltest Du auch diese Aufgabe schaffen.
- Es ist auch für diejenigen, die etwas mehr Erfahrung haben und jetzt ihren ersten Open-Source-Beitrag einreichen wollen, oder auch mehr Erfahrung und Routine erlangen wollen.

### Warum sollte ich mitmachen?

Jeder Web-Entwickler, ob Anfänger oder Experte, sollte die Versionsverwaltung Git nutzen und GitHub ist der populärste Git-Hosting-Service, den jeder nutzt. Es ist auch das Herz der Open-Source-Gemeinschaft. Sich mit GitHub vertraut zu machen, ist eine notwendige Fähigkeit. Zu einem Projekt beizutragen, stärkt das Vertrauen in die eigenen Fähigkeiten und man kann es auch im eigenen GitHub-Profil zeigen.

Wenn Du als Entwickler gerade erst beginnst und Dich fragst, ob Du Git und GitHub lernen solltest, so ist hier Deine Antwort: [Du solltest Git bereits gestern gelernt haben (eng., You Should've Learned Git Yesterday)](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'Neuer Entwickler? Du solltest Git gestern schon gelernt haben. von Brandon Morelli, Creator von CodeBurst.io').

### Was werde ich beitragen?

![Contributor Card](/readme-only/card.PNG 'Contributor Card')

Du wirst eine Karte wie diese zur [Projekt Webseite](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project') beisteuern. Sie wird Deinen Namen, Deinen Twitter-Namen, eine kurze Beschreibung und drei von Dir empfohlene Links zu für Web-Entwickler nützlichen Seiten enthalten.

Du wirst eine Kopie der Karten-Vorlage innerhalb der HTML-Datei erstellen und sie mit Deinen Informationen anpassen.

---

### Übersetzungen

Dieses Tutorial ist auch in [anderen Sprachen](/translations/README.md) verfügbar:

| [English](/terminal_tutorial.md) | [Bangla](/translations/terminal_tutorial/terminal_tutorial.ben.md) | [Chinese (Traditional)](/translations/terminal_tutorial/terminal_tutorial.zho-tc.md) | [German](/translations/terminal_tutorial.ger.md) | [Hindi](/translations/terminal_tutorial/terminal_tutorial.hin.md) |
| :----: | :----: | :----: | :----: | :----: |
[Portuguese (Brazilian)](/translations/terminal_tutorial/terminal_tutorial.por-br.md) | [Ukrainian](/translations/terminal_tutorial/terminal_tutorial.ukr.md) |

> Übersetzungen der Projektdokumentation sind gerne gesehen. Siehe [`Translation Guide` (engl.)](/translations/README.md) um beizutragen.

---

### Setup! :)

Info: Wenn Du Dich nicht so gut mit der Kommandozeile auskennst, [gibt es hier ein GUI-Tutorial mit dem GitHub-Desktop](/translations/README/GERMAN.md)

Als erstes bereiten wir das Setup vor.

1. Logge Dich in Deinen GibtHub-Account ein. Wenn Du noch keinen hast, kannst Du [hier einen erstellen](https://github.com/join). Ich empfehle das [GitHub Hello World tutorial](https://guides.github.com/activities/hello-world/) zu machen, bevor Du hier weiter machst.
2. Wenn Du noch kein Git installiert hast, [kannst Du es hier installieren](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git).

> Jetzt, wo alles eingerichtet ist, können wir mit dem Beitrag zum Projekt beginnen.

[↑ Nach oben ↑](#schnellzugriff)

---

### Beitragen

Werde ein Open-Source-Mitwirkender in 10 einfachen Schritten.

*Geschätzte Zeit: Weniger als 30 Minuten.*

#### Schritt 1: Fork dieses Repository

- Das Ziel ist es, eine Kopie dieses Projekts in Deinem Konto zu erstellen.
- Als Repository (Repo) bezeichnet man ein Projekt auf GitHub und ein Fork ist eine Kopie davon.
- Stelle sicher, dass Du auf der [Hauptseite](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') dieses Repos bist.

| ![Fork](/readme-only/fork.png "click on 'Fork'") |
| :---------------------------------------------: |
|         **Klicke auf die _Fork_-Schaltfläche**          |

- Jetzt hast Du eine vollständige Kopie des Projekts in Deinem Konto.

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 2: Clone das Repository

- Jetzt erstellen wir die lokale Kopie des Projekts, welche auf Deinem eigenen Computer gespeichert wird.

![Clone](/readme-only/clone-terminal.png)

- Jetzt »clone« dieses Repo auf Deinen Computer. Klicke auf die Schaltfläche »Clone« und danach auf das Kopieren-Symbol.
- Als Repository (Repo) bezeichnet man ein Projekt auf GitHub und ein Fork ist eine Kopie davon.

Öffne ein Terminal und führe folgenden Git-Befehl aus:

```bash
git clone "url you just copied"
```

Zum Beispiel:

```bash
git clone https://github.com/$Username/Contribute-To-This-Project.git
```

wobei `$Username` Dein GitHub-Benutzername ist. Damit kopierst Du den Inhalt dieses Repositories auf Deinen Computer.

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 3: Erstelle einen Branch

Wechsle in das Repository-Verzeichnis auf Deinem Computer (wenn DU nicht bereits dort bist):

```bash
cd Contribute-To-This-Project
```

Jetzt erstelle mit dem Befehl `git checkout` einen neuen Zweig (Branch):

```bash
git checkout -b dein-neuer-branch-name
```

Zum Beispiel:

```bash
git checkout -b add-$Username-card
```

Info: Ersetze `$Username` mit Deinem GitHub-Kontonamen.

- Du hast nun einen neuen, vom Master-Branch (bzw. Main-branch) separierten, Zweig erstellt
- Stelle fr die nächsten Schritte sicher, dass Du in diesem Branch arbeitest. Je nach Editor wird der Branch-Name unten links angezeigt.

**Arbeite NICHT im  `master`/`main` Branch**

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 4: Öffne die Datei index.html

Jetzt öffnen wir in unserem Lieblingseditor die Datei, die wir bearbeiten werden. In diesem Tutorial nutzen wir [VSCode](https://code.visualstudio.com/).

- Die Datei `index.html` ist im Verzeichnis `Contribute-To-This-Project`.
- Du kannst diese Datei mit folgendem Befehl im Editor öffnen:

```bash
code index.html
```

Info: Dies ist die Befehlszeilenversion, um `index.html` in `VSCode` zu öffnen.

- Jetzt, da die Datei zum Editieren geöffnet ist, kannst Du mit den Änderungen beginnen.

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 5: Kopiere die Karten-Vorlage

- Wir erstellen eine Kopie der Karten-Vorlage um daran zu arbeiten.
- Zu Beginn der Datei, unterhalb der Sektionen `<head>` und `<header>` ist eine Sektion `== TEMPLATE ==`
- Kopiere alles, was im Bild rot markiert ist, also vom `Contributor card START`-Kommentar bis zum `Contributor card END`-Kommentar.

| ![Copy card template](/readme-only/card-copy.PNG 'Copy the card template') |
| :-----------------------------------------------------------------------: |

- Füge dies dann direkt unter dem entsprechenden Kommentar wieder ein.
- Stelle sicher, dass zwischen dem Beginn Deiner Karte und dem Ende der letzten Karte genau eine Leerzeile ist. Es ist üblich, den Quelltext so verständlich wie möglich zu halten.
- Nutze keinen Linter oder »Style-Formatierer«. Dieses Projekt hat »Prettier« eingerichtet.

| ![Paste card template](/readme-only/card-paste.PNG 'Paste below the indicated line') |
| :---------------------------------------------------------------------------------: |

- Dies ist jetzt **Deine** Karte, die Du nun  editieren und anpassen kannst.

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 6: Änderungen eintragen

- Jetzt beginnen wir, das HTML zu editieren, und die anpassbaren Felder der Karte zu ändern.

| :arrow_right_hook: Ersetze 'Name' mit Deinem Namen | ![Change name](/readme-only/change-name.PNG 'Schreibe Deinem Namen') |
| :----------------------------------------------- | :----------------------------------------------------------: |

- **Info: Ändere `class="name"` NICHT**

| :arrow_right_hook: Trage die URL Deines Twitter-Kontos hier `href="Insert URL here"` ein, und Deinen Twitternamen in das Textfeld | ![Change contact](/readme-only/change-contact.PNG 'Füge Deinen Twitter-Link und Deinen Twitter-Namen ein') |
| :--------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- Wenn Du lieber einen anderen Kontakt anstatt Twitter eintragen möchtest, musst Du das Twitter-Symbol `<i class="fa fa-x-twitter"></i>` ersetzen und ein anderes von [Font Awesome Icons](http://fontawesome.io/icons/) suchen und dann nur den `fa-x-twitter`-Teil mit dem neuen Icon ersetzen, z. B. `fa-facebook`. Dann wieder den obigen Schritten folgen.

|                                                                                                                                         ![Change about](/readme-only/change-about.PNG 'Schreib einen Satz über Dich')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **Erzähl uns etwas über Dich. Halte es kurz und bündig. Mehr wie ein Tweet, als ein Blog Post**                                                                                                                |
|                                                                                                              ![Change resources](/readme-only/change-resources.PNG 'Link einfügen, kurze Beschreibung und der Name der Ressource')                                                                                                              |
| :arrow_right_hook: **Teile 3 Links zu Ressourcen mit der Community, die nützlich für Web-Entwicklung sind. Es kann alles sein, ein Video, Podcast, Artikel, Referenz oder ein Tool. Wenn Du ein Anfänger bist, lass Dich davon nicht einschüchtern; teile, was Du meinst, selbst wenn Du es für grundlegend hältst. Du wirst überrascht sein, wie viele Leute davon profitieren.** |

- **Link:** Füge den Link ein `href="hier"`, indem Du das `#` ersetzt. Bitte nutze keinen URL-Shortener und auch keine Links, die nicht von der Seite kommen, die teilst!
- **Title:** Eine kurze Beschreibung `title="hier"`.
- **Name:** Schreibe den Ressourcen-Name in das Textfeld `>hier</a>`.
- Stelle sicher, dass Du **alle Änderungen gespeichert** hast.
- **Teste Deine Änderungen**. DIES IST WICHTIG! Öffne die HTML-Datei in Deinem Browser (z. B. durch einen Doppelklick) und schau Dir Deine Karte an, wie sie auf der Seite aussehen wird. Die komplette Seite sollte noch gleich aussehen und nichts sollte kaputt sein. Klicke Deine Links und stell sicher, dass sie funktionieren. Öffne die Konsole (Strg + Shift + J (Windows / Linux) or Cmd + Opt + J (Mac)) und prüfe, dass dort keine Fehlermeldungen sind.
- Großartig, Du hast die Bearbeitung des Quelltextes abgeschlossen. Als Nächstes wirst Du Deine Änderungen zu GitHub übertragen und sie dann beim Hauptprojekt einreichen

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 7: Commit Deine Änderungen

- Öffne ein Terminal in Deinem Projektverzeichnis und führe `git status` aus und Du bemerkst, dass in git nichts geändert wurde.
- Du kannst Deine Änderungen mit dem `git add`-Befehl hinzufügen

```bash
git add index.html
```

- Jetzt commit diese Änderungen mit dem Befehl `git commit`

```bash
git commit -m "Add $Username card info"
```

- Wieder `$Username` mit Deinem GitHub-Namen ersetzen.

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 8: Push Deine Änderungen zu GitHub

- Deine Änderungen sind nur gespeichert und »committed« (zu git übertragen). Aber sie sind bis jetzt nur lokal, also auf Deinem Computer.
- Lokale Änderungen mit Deinem Repository auf GitHub zu synchronisieren nennt man *Push*. Du »pushst« Änderungen von Deinem lokalen Repository zu Deinem entfernten Repo auf GitHub.
- Hierfür nutzen wir den Befehl `git push`

```bash
git push -u origin $Username-card
```

- Ersetze `$Username-card` mit dem Namen Deines Branches.

- Nach ein paar Sekunden ist der Befehl erfolgreich ausgeführt und Du hast eine genau gleiche Kopie deines Branches auf Deinem Computer und auf GitHub.

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 9: Erstelle einen PR(Pull Request)

- Dies ist der Moment, auf den Du gewartet hast: Einen Pull Request (PR) erstellen.
- Bis jetzt hast Du alle Änderungen in Deinem Fork des Projekts vorgenommen, welches ja in Deinem GitHub-Konto ist.
- Jetzt ist es Zeit, Deine Änderungen an das Hauptprojekt zu schicken, um dort eingepflegt zu werden.
- Dies nennt man einen [*Pull Request*](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help'), weil man den/die Betreuer des Originalprojekts fragt, die Änderungen in ihr Projekt zu ziehen (to pull).
- Gehe zur Hauptseite **Deines Forks** auf GitHub (oben wird das Fork-Symbol und Dein eigener Benutzernamen angezeigt).
- Oben im Repo siehst Du eine hervorgehobene Pull-Request-Nachricht mit einer grünen Schaltfläche.

|  ![Submit a Pull Request](/readme-only/pull-request.PNG 'Dies befindet sich normalerweise oben auf der Seite, unter der Beschreibung und über den Projektdateien und -ordnern')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Klicke auf `Compare and pull request`**                                                     |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'Du fragst nach einer Zusammenführung Deines Branches von Deinem Fork mit dem Master-Branch des ursprünglichen Projekts') |
|                                              :arrow_right_hook: So sieht die `Erstelle einen Pull-Request`-Seite aus.                                               |

- ERINNERUNG: *Du versuchst, Deinen Branch mit dem Original-Projekt zu vereinen, nicht mit dem `Master`-Branch Deines Forks.*
- Das Bild oben zeigt, wie der Kopf der Pull-Request-Seite aussehen sollte.
- Links steht das Original-Projekt, gefolgt vom Master-Branch. Auf der rechten Seite ist Dein Fork und der von Dir erstellte Branch

|                   ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Klicke den grünen Knopf. Keine Angst!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Erstelle einen Pull-Request: Schreibe eine Überschrift, füge optionale Informationen in der Beschreibung hinzu und klicke auf `Create pull request`** |

- Lass Dich nicht von all den Optionen überwältigen. Du musst jetzt nur diese drei Schritte ausführen.
- Lass die Option `Allow edits from maintainers` aktiviert.
- Nun wird ein Pull-Request an die Projektbetreuer gesendet. Sobald diese ihn begutachtet und akzeptiert haben, werden Deine Änderungen auf der [Project Webseite](https://syknapse.github.io/Contribute-To-This-Project 'Contribute To This Project web page') sichtbar.

[↑ Nach oben ↑](#schnellzugriff)

---

#### Schritt 10: Feier

Das war's. Du hast es geschafft. Du hast soeben zu ein Open-Source-Project auf GItHub beigetragen.

Du hast Code zu einer Webseite beigetragen: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Deine Änderungen **werden nicht sofort sichtbar sein**; sie werden erst durch die Projektbetreuer überprüft, akzeptiert und eingebunden. Nachdem sie eingebunden wurden, ist Deine Karte sichtbar auf der Seite.

Es ist normal, dass ein Prüfer nach Änderungen an einem PR fragt. Denk einfach daran, dass es normal ist, wenn es Dir passiert. Schau immer mal mit einem Auge auf die Kommentare. Nachdem Du die angefragten Kommentare erledigt hast (in Deinem Branch), musst Du nur noch die Änderungen commit'en und push'en. Der PR wird sich automatisch aktualisieren.

Ich verspreche Dir, dass ich versuchen werden, die Änderungen so schnell wie möglich zu prüfen und einzubinden; aber da ich das in meiner Freizeit mache, kann es schon mal einen Moment dauern.

[↑ Nach oben ↑](#schnellzugriff)

---

### Nächste Schritte

- Komm etwas später zurück und sieh Dir Deinen eingebundenen Pull Request an.
- Du solltest eine E-Mail von GitHub erhalten haben, als Deine Änderungen akzeptiert wurden, oder, falls weitere Anpassungen angefragt wurden. Nachdem Dein PR eingebunden (merged) wurde, wurde Deine Karte hinzugefügt.
- Du kannst auch durch diese *freie* Reihe lernen, wie man beitragen kann: [How to Contribute to an Open Source Project on GitHub](https://kcd.im/pull-request)
- Wenn Du dieses Projekt **nützlich** findest, bitte gib ihm oben einen :star: star :star: und **tweete** über es [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit], um es bekannter zu machen.
- Du kannst mir auf [Twitter](https://twitter.com/Syknapse '@Syknapse') folgen und mich kontaktieren, oder Du  [nutzt eine der anderen Optionen](https://syknapse.github.io/Syk-Houdeib/#contact 'My contact section | Portfolio')
- Da dies ein Open-Source-Projekt ist, kannst Du nicht nur Deine Karte beitragen, sondert bist herzlich eingeladen, Fehler zu beheben, Verbesserungen oder auch neue Features beizutragen. Erstelle ein [issue](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') oder sende einen neuen [Pull Request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Einen Pull Request von einem Fork erstellen | GitHub Help')
- Um unsere Community zu verbessern, schaue in die GitHub [Diskussionen](https://github.com/Syknapse/Contribute-To-This-Project/discussions) oben neben den Pull Requests. Hier kannst Du Dich selbst vorstellen, tiefere Diskussionen über Open Source führen und mit den Projektbetreuern in reden. Wirst Du uns helfen, dieses Feature weiter auszubauen und unsere Community weiter aufzubauen?
- **Danke, dass Du zu diesem Projekt beigetragen hast.** Jetzt kannst Du Dich auch an anderen Projekten beteiligen; suche nach ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) für Einsteiger-freundliche Beteiligungsoptionen.
- Ich suche auch nach Projektmitarbeitern, die mir beim Überprüfen und einbinden der Pull Requests helfen. Wenn Du gerne weitere Git-Erfahrung sammeln möchtest, schicke mir eine PN auf Twitter und lies den [maintainer's guide](/translations/maintainer_guide/maintainer_guide.ger.md).

[↑ Nach oben ↑](#schnellzugriff)

---

### Danke

Dieses Projekt ist stark durch [Roshan Josseys](https://github.com/Roshanjossey) großartiges [first-contributions](https://github.com/Roshanjossey/first-contributions)-Projekt mit seinem exzellenten Tutorial beeinflusst.

Es ist teilweise durch die großartige Community um [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) »The Google Challenge Scholarship: Front-End Web Dev, class of 2017 Europe« inspiriert.

### Top 100 Beitragende

[![GitHub Contributors Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[↑ Nach oben ↑](#schnellzugriff)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
