# Посібник з супроводу

Цей посібник призначений для тих, хто хотів би приєднатися до проєкту як супроводжуючі, щоб допомогти керувати та підтримувати проєкт для спільноти. (Це не посібник для тих, хто **робить внесок вперше**)

## Переклади

Цей посібник також доступний на [інших мовах](/translations/README.md)

> Вітаються переклади проєктної документації. Прочитайте ['Посібник з перекладу'](/translations/README.md), щоб зробити свій внесок.

---

## Мета

Наша головна мета полягає в тому, щоб надати нашим учасникам якомога швидший зворотний зв'язок з того моменту, коли вони зроблять свій pull request. Це, перш за все, означає надання оглядів коду та об'єднання прийнятих PR.  
Крім того, ми можемо підтримувати проєкт, переконавшись, що все працює належним чином і є настільки корисним, наскільки це може бути для наших учасників.

## Для кого це?

Це для будь-кого, хто має трохи навичок Git та GitHub. Не обов'язково бути експертом, це керівництво має допомогти навіть новачкам. Це активний проєкт, який отримує регулярні внески, і це допомагає багатьом людям зробити свій перший внесок в проєкти з відкритим кодом. Супровід цього проєкту допомагає переконатися, що він продовжує надавати нашим учасникам хороший перший досвід та заохочує їх робити більший внесок.

Ви можете присвятити цьому так багато або так мало часу, скільки захочете. Між нами, ми сподіваємося, що зможемо підтримувати його безперебійну роботу.

## Методологія

- Перейдіть до розділу pull request проєкту, почніть з найстарішого pull-запиту, який не перебуває у стані "запитані зміни" ('changes requested').
- Відкрийте PR і перейдіть на вкладку змін файлів і почніть перевірку коду.
- Перевірте PR, переконайтеся, що він відповідає специфікації підручника.
- Переконайтеся, що HTML-код, посилання та дані правильні. Переконайтеся, що картку розташовано на початку файлу там, де вона повинна бути.
- Далі перевірте наявність конфліктів. Об'єднайте (merge) `master` в гілку PR щоб виправити конфлікти. Конфлікти зазвичай трапляються, коли минуло багато часу з моменту попереднього злиття, і кілька запитів (PR) використовують одну і ту ж застарілу версію.
- Якщо це так, виправте конфлікт. Зазвичай вам доведеться додати нову карту поверх карток, які були додані з моменту створення форку.
- Якщо все в порядку, схваліть PR, напишіть повідомлення учаснику, подякувавши за внесок (пам'ятайте, що вони роблять це перший раз і отримають користь від підбадьорення).
- Об'єднайте PR в `master`.

## Запит на зміни

- Іноді виникають проблеми з PR, які повинні бути виправлені учасником, такі як неправильно створена гілка, зламаний HTML, відсутня інформація, або картка, розміщена не в тому місці. Все, де учасник не дотримувався підручника правильно (а не прості конфлікти злиття).
- Почніть перевірку коду на GitHub і надішліть запит на зміни. Постарайтеся бути максимально описовими, прокоментуйте точний рядок, розкажіть їм, в чому саме полягає проблема і як її виправити, і заохочуйте їх, що це нормальна частина процесу перевірки PR.
- Коли будете готові, надішліть рецензію.
- Слідкуйте за розмовою, якщо у учасника виникнуть додаткові запитання, з якими ви можете допомогти. Наша мета — довести всіх до фінішу, тож ми намагаємося скерувати їх до кінця.
- Як тільки вони виправлять запитувані зміни, PR можна об'єднати в `master`.

Будь ласка, завжди перевіряйте, що зміни не порушили проєкт і що активна сторінка все ще працює належним чином. Завжди краще перевірити зміни локально перед об'єднанням і ніколи не об'єднувати те, що виглядає підозрілим.

## Інструменти

Якщо накопичених PR не так багато, весь цей процес можна зробити прямо на сторінці проєкту GitHub.  
Однак нерідко чекають кілька PR, і саме тоді неминуче виникнуть конфлікти злиття. Ви можете використовувати будь-які інструменти, з якими ви знайомі, щоб побачити відмінності та виправити конфлікти.  
Рекомендую використовувати такий інструмент, як [GitKraken](https://www.gitkraken.com/download). Він візуальний і дозволяє легше керувати проєктом, коли потрібно пройти кілька PR.  
Завантажте GitKraken, клонуйте проєкт. Використання комбінації вашого редактора коду та інтегрованого інструменту GitKraken для вирішення конфліктів злиття дає вам повний контроль, щоб швидко проходити через PR, виправляти конфлікти та виконувати злиття.

У проєкті встановлено Prettier, щоб гарантувати, що незалежно від того, як учасник подає PR, посібник по стилю буде виконуватися. Проект таким чином завжди витримується з однаковим відступом і стилем.  
Якщо ви помітили, що HTML-файл виглядає безладно, запустіть код нижче в корені проєкту.

```js
npx prettier --write index.html
```

Це повинно спробувати відформатувати файл, і якщо це не може бути зроблено, то покаже вам помилки. Іноді відсутній закриваючий тег або зламаний HTML об'єднується помилково, і це хороший спосіб виявити та виправити помилки.

Якщо ви коли-небудь сумніваєтеся, ви завжди можете згадати мене або інших супроводжувачів у самому PR або надіслати мені повідомлення на [Twitter](https://twitter.com/Syknapse).

## Приєднуйтесь до нас

Приєднуйтесь до нас, щоб допомогти розвивати цей проєкт разом. Зв'яжіться зі мною у [Twitter](https://twitter.com/Syknapse) і надішліть мені своє ім'я користувача GitHub, щоб я міг додати вас. Ви також можете приєднатися до нашої спільноти Discord, натиснувши кнопку нижче:

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Приєднуйтесь до нашого сервера Discord!')