# Руководство сопровождающего

Это руководство предназначено для тех, кто хотел бы присоединиться к проекту в качестве сопровождающих, чтобы помочь сообществу управлять проектом и поддерживать его. (Это руководство не для **начинающих участников**.)

## Translations

Это руководство также доступно на [других языках](/translations/README.md)

| [Английский](/maintainer_guide.md)   | [Бангла](/translations/maintainer_guide/maintainer_guide.ben.md) | [Китайский (традиционный)](/translations/maintainer_guide/maintainer_guide.zho-tc.md) | [Немецкий](/translations/maintainer_guide/maintainer_guide.ger.md) | [хинди](/translations/maintainer_guide/maintainer_guide.hin.md) |
| :---: | :---: | :---: | :---: | :---: |
| [итальянский](/translations/maintainer_guide/maintainer_guide.ita.md) | [Японский](/translations/maintainer_guide/maintainer_guide.jpn.md) | [португальский](/translations/maintainer_guide/maintainer_guide.por.md) | [украинец](/translations/maintainer_guide/maintainer_guide.ukr.md) |

> Приветствуются переводы проектной документации. Прочтите [`Руководство по переводу`](/translations/README.md) внести свой вклад.

---

## Цели

Наша главная цель — предоставить нашим участникам максимально быструю обратную связь с того момента, как они отправляют запрос на включение. В первую очередь это означает проведение проверок кода и объединение принятых заявок на участие.
Кроме того, мы можем поддерживать проект, следя за тем, чтобы все работало правильно и было максимально полезным и полезным для наших участников.

## Это кому?

Любой, кто хоть немного разбирается в Git и GitHub. Вам не обязательно быть экспертом, это руководство поможет даже новичкам. Это активный проект, который регулярно получает пожертвования и помогает многим людям сделать свой первый вклад в открытый исходный код. Участие в сопровождении этого проекта помогает гарантировать, что он продолжает давать нашим участникам хороший первый опыт и побуждает их вносить больший вклад.

Вы можете уделять этому столько времени, сколько захотите. Между нами, мы надеемся, что сможем обеспечить бесперебойную работу.

## Методология

- Перейдите в раздел запроса на включение проекта, начните с самого старого запроса на включение, который не находится в состоянии «запрошены изменения».
— Откройте PR, перейдите на вкладку «Изменения файлов» и начните проверку кода.
- Проверьте PR, убедитесь, что он соответствует спецификации, указанной в руководстве.
– Убедитесь, что HTML, ссылки и данные верны. Убедитесь, что карта расположена в начале файла там, где она должна быть.
- Далее проверьте наличие конфликтов. Объедините `master` с веткой PR, чтобы устранить конфликты. Конфликты обычно случаются, когда с момента предыдущего слияния прошло много времени и несколько PR используют одну и ту же устаревшую версию.
- Если это так, устраните конфликт. Обычно вам придется добавить новую карту поверх карт, которые были добавлены после создания форка.
- Если все остальное в порядке, одобрите PR, напишите сообщение участнику, поблагодарив его за вклад (помнив, что они новички и им будет полезна поддержка).
- Объединить PR с `master`.

## Запросить изменения

- Иногда возникают проблемы с PR, которые должен исправить участник, например неправильное ветвление, неправильный HTML, недостающая информация, карточка, размещенная в неправильном месте. Все, что не соответствует инструкции (кроме простых конфликтов слияния).
- Запустите проверку кода на GitHub и запросите изменения. Постарайтесь быть как можно более описательными, прокомментируйте точную строку, точно расскажите им, в чем проблема и как ее исправить, и убедите их, что это нормальная часть процесса проверки PR.
- Когда будете готовы, отправьте отзыв.
– Следите за разговором, если у участника есть дополнительные вопросы, с которыми вы можете помочь. Наша цель — помочь всем пройти финишную черту, поэтому мы стараемся провести их до конца.
- Как только запрошенные изменения будут исправлены, PR можно будет объединить с «главным».

Пожалуйста, всегда проверяйте, что изменения не нарушили работу проекта и что действующая страница по-прежнему работает должным образом. Всегда лучше проверять изменения локально перед объединением и никогда не объединять ничего, что выглядит подозрительно.

## Инструменты

Если накопленных PR не так много, весь этот процесс можно выполнить непосредственно на странице проекта на GitHub.
Однако нередко приходится ждать несколько PR, и тогда неизбежно возникнут некоторые конфликты слияний. Вы можете использовать любые знакомые вам инструменты, чтобы увидеть различия и исправить конфликты.
Я рекомендую использовать такой инструмент, как [GitKraken](https://www.gitkraken.com/download). Он нагляден и позволяет упростить управление проектом, когда нужно пройти несколько PR.
Скачайте GitKraken, клонируйте проект. Использование комбинации вашего редактора кода и встроенного инструмента GitKraken для конфликтов слияний дает вам полный контроль над быстрой проработкой PR, исправлением конфликтов и слиянием.

В проекте установлен Prettier, чтобы гарантировать, что независимо от того, как участник отправит PR, руководство по стилю будет соблюдаться. Таким образом, проект всегда поддерживается с одинаковыми отступами и стилем.
Если вы заметили, что HTML-файл выглядит беспорядочно, выполните приведенный ниже код в корне проекта.

```js
npx prettier --write index.html
```

Он должен попытаться отформатировать файл, и если это не удастся, он покажет вам ошибки. Иногда отсутствующий закрывающий тег или неправильный HTML-код объединяются по ошибке, и это хороший способ обнаружить и исправить это.

Если у вас когда-нибудь возникнут сомнения, вы всегда можете упомянуть меня или других сопровождающих в самом PR или написать мне в [Twitter](https://twitter.com/Syknapse).

## Присоединяйтесь к нам

Присоединяйтесь к нам, чтобы вместе помочь развитию этого проекта. Свяжитесь со мной в [Twitter](https://twitter.com/Syknapse) и пришлите мне свое имя пользователя GitHub, чтобы я мог вас добавить. Вы также можете присоединиться к нашему сообществу Discord, нажав кнопку ниже:

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Присоединяйтесь к нашему серверу Discord !')
