# देखभाल करणाऱ्यांचे मार्गदर्शक

हे मार्गदर्शक त्यांच्यासाठी आहे जे प्रकल्पात देखभालकर्ता म्हणून सामील होऊ इच्छितात, समुदायासाठी प्रकल्प व्यवस्थापित करण्यात आणि देखरेख करण्यात मदत करण्यासाठी. (हे **पहिल्यांदा योगदानकर्त्यांसाठी मार्गदर्शक नाही**)

## भाषांतरे


हे ट्यूटोरियल उपलब्ध आहे [इतर भाषांमध्ये](../README.md)


| [इंग्रजी](../../maintainer_guide.md) | [बंगाली](/translations/maintainer_guide/maintainer_guide.ben.md) | [जर्मन](/translations/maintainer_guide/maintainer_guide.ger.md) | [इटालियन](/translations/maintainer_guide/maintainer_guide.ita.md) | [जपानी](/translations/maintainer_guide/maintainer_guide.jpn.md) |
| :---: | :---: | :---: | :---: | :---: |
| [हिंदी](maintainer_guide.hin.md) | [पोर्तुगीज](/translations/maintainer_guide/maintainer_guide.por.md) | [युक्रेनियन](/translations/maintainer_guide/maintainer_guide.ukr.md) | [चीनी (पारंपारिक)](/translations/maintainer_guide/maintainer_guide.zho-tc.md) | [मराठी](maintainer_guide.mar.md)

> प्रकल्प कागदपत्रांच्या भाषांतरांचे स्वागत आहे. योगदान देण्यासाठी [`अनुवाद मार्गदर्शक`](../README.md) वाचा.

---

## उद्दिष्टे

आमचे मुख्य उद्दिष्ट आमच्या योगदानकर्त्यांना त्यांच्या पुल विनंतीवरून शक्य तितक्या जलद अभिप्राय देणे हे आहे. याचा मुख्य अर्थ कोड पुनरावलोकने देणे आणि स्वीकारलेले PR विलीन करणे असा होतो.
या व्यतिरिक्त आम्ही सर्व काही योग्यरित्या कार्य करत आहे आणि आमच्या योगदानकर्त्यांसाठी उपयुक्त आणि उपयुक्त आहे याची खात्री करून प्रकल्प राखू शकतो.

## हे कोणासाठी आहे?

Git आणि GitHub कौशल्ये असलेले कोणीही. तुम्ही तज्ञ असण्याची गरज नाही, या मार्गदर्शकाने अगदी नवशिक्यांनाही मदत केली पाहिजे. हा एक सक्रिय प्रकल्प आहे जो नियमित योगदान प्राप्त करतो आणि अनेक लोकांना त्यांचे प्रथम मुक्त स्रोत योगदान देण्यात मदत करतो. या प्रकल्पाचा मेंटेनर असल्‍याने हे सुनिश्चित करण्‍यात मदत करते की ते आमच्‍या योगदानकर्त्‍यांना एक चांगला पहिला अनुभव देत आहे आणि त्‍यांना अधिक योगदान देण्‍यासाठी प्रोत्‍साहित करत आहे.

यासाठी तुम्ही जास्त किंवा कमी वेळ देऊ शकता. आमच्या दरम्यान आम्ही आशा करतो की ते सुरळीत चालू ठेवू.

## पद्धती

- प्रकल्पाच्या पुल विनंती विभागात जा, सर्वात जुन्या पुल विनंतीसह प्रारंभ करा जी 'चेंजेस रिक्वेस्ट' स्थितीत नाही.
- PR उघडा आणि फाइल्स बदल टॅबवर जा आणि कोड पुनरावलोकन सुरू करा.
- PR तपासा, ते ट्यूटोरियलमधील वैशिष्ट्यांचे अनुसरण करत असल्याची खात्री करा.
- HTML, लिंक्स आणि डेटा सर्व बरोबर असल्याची खात्री करा. कार्ड फाईलच्या सुरुवातीला जिथे असावे तिथे ठेवलेले असल्याची खात्री करा.
- कोणत्याही मतभेदांसाठी पुढील तपासा. विवादांचे निराकरण करण्यासाठी PR शाखेत `मास्टर` विलीन करा. जेव्हा मागील विलीनीकरणास थोडा वेळ झाला असेल आणि अनेक PR समान कालबाह्य आवृत्ती वापरत असतील तेव्हा सहसा संघर्ष होतात.
- जर असे असेल तर संघर्ष दूर करा. सामान्यतः तुम्हाला काटा बनवल्यापासून जोडलेल्या कार्डांच्या वर नवीन कार्ड जोडावे लागेल.
- बाकी सर्व काही ठीक असल्यास, PR मंजूर करा, योगदानकर्त्याला योगदानाबद्दल त्यांचे आभार मानणारा संदेश लिहा (लक्षात ठेवा की ते प्रथम टाइमर आहेत आणि त्यांना प्रोत्साहनाचा फायदा होईल).
- PR ला `master` मध्ये विलीन करा.

## बदलांची विनंती करा

- काहीवेळा पीआरमध्ये अशा समस्या येतात ज्या योगदानकर्त्याने दुरुस्त केल्या पाहिजेत जसे की चुकीची शाखा, तुटलेली एचटीएमएल, गहाळ माहिती, चुकीच्या ठिकाणी ठेवलेले कार्ड. कोणतीही गोष्ट जिथे ट्यूटोरियलचे अचूक पालन केले गेले नाही (आणि साधे विलीनीकरण विरोधाभास नाही).
- GitHub वर कोड पुनरावलोकन सुरू करा आणि बदलांची विनंती करा. शक्य तितके वर्णनात्मक होण्याचा प्रयत्न करा, नेमक्या ओळीवर टिप्पणी करा, समस्या काय आहे आणि त्याचे निराकरण कसे करावे ते त्यांना सांगा आणि त्यांना प्रोत्साहित करा की हा PR पुनरावलोकन प्रक्रियेचा एक सामान्य भाग आहे.
- तुम्ही तयार असाल तेव्हा पुनरावलोकन सबमिट करा.
- तुम्ही मदत करू शकता असे योगदानकर्त्याकडे पाठपुरावा प्रश्न असल्यास संभाषणावर लक्ष ठेवा. आमचे उद्दिष्ट प्रत्येकाला अंतिम रेषा पार करणे हा आहे, म्हणून आम्ही त्यांना तेथे सर्व मार्गाने मार्गदर्शन करण्याचा प्रयत्न करतो.
- त्यांनी विनंती केलेले बदल निश्चित केल्यावर, PR ला `master` मध्ये विलीन केले जाऊ शकते.

कृपया नेहमी तपासा की बदलांमुळे प्रकल्प खंडित झाला नाही आणि थेट पृष्ठ अजूनही अपेक्षेप्रमाणे कार्य करते. विलीन होण्यापूर्वी स्थानिक पातळीवर बदलांची चाचणी घेणे केव्हाही उत्तम आहे आणि संशयास्पद वाटणारी कोणतीही गोष्ट कधीही विलीन करू नका.

## साधने

जर तेथे जास्त जमा झालेले PR नसतील तर ही सर्व प्रक्रिया थेट प्रकल्पाच्या GitHub पृष्ठावर केली जाऊ शकते.
तथापि, काही PR ला वाट पाहणे असामान्य नाही आणि तेव्हाच काही विलीनीकरण संघर्ष अपरिहार्यपणे होतील. फरक पाहण्यासाठी आणि विरोधाभास दूर करण्यासाठी तुम्ही परिचित असलेली कोणतीही साधने वापरू शकता.
मी [GitKraken](https://www.gitkraken.com/download) सारखे साधन वापरण्याची शिफारस करतो. हे व्हिज्युअल आहे आणि जेव्हा काही PRs पार करायचे असतात तेव्हा ते प्रकल्पाचे सुलभ व्यवस्थापन करण्यास अनुमती देते.
GitKraken डाउनलोड करा, प्रकल्प क्लोन करा. तुमचा कोड एडिटर आणि GitKraken चे इंटिग्रेटेड मर्ज कॉन्फ्लिक्ट टूल यांच्या संयोजनाचा वापर केल्याने तुम्हाला PRs, विवादांचे निराकरण आणि विलीनीकरण करण्यासाठी त्वरीत पूर्ण नियंत्रण मिळते.

योगदानकर्त्याने PR कसे सबमिट केले याची पर्वा न करता, शैली मार्गदर्शकाची अंमलबजावणी केली जाईल याची खात्री करण्यासाठी प्रकल्पामध्ये प्रीटीअर स्थापित केले आहे. अशा प्रकारे प्रकल्प नेहमी समान इंडेंटेशन आणि शैलीसह राखला जातो.
जर तुम्हाला एचटीएमएल फाइल गोंधळलेली दिसत असेल तर प्रोजेक्ट रूटमधील कोड खाली चालवा.

```js
npx prettier --write index.html
```

फाईल फॉरमॅट करण्याचा प्रयत्न केला पाहिजे आणि जर ते शक्य नसेल तर ते तुम्हाला त्रुटी दर्शवेल. काहीवेळा गहाळ क्लोजिंग टॅग किंवा तुटलेला HTML चुकून विलीन केला जातो आणि तो शोधण्याचा आणि निराकरण करण्याचा हा एक चांगला मार्ग आहे.

तुम्हाला कधीही शंका असल्यास, तुम्ही नेहमी माझा किंवा PR मधील इतर देखभाल करणार्‍यांचा उल्लेख करू शकता किंवा [ट्विटर](https://twitter.com/Syknapse) वर मला DM करू शकता.

## आमच्यात सामील व्हा

हा प्रकल्प एकत्रितपणे वाढविण्यात मदत करण्यासाठी आमच्यात सामील व्हा. माझ्याशी [ट्विटर](https://twitter.com/Syknapse) वर संपर्क साधा आणि मला तुमचे GitHub वापरकर्ता नाव पाठवा जेणेकरून मी तुम्हाला जोडू शकेन. तुम्ही खालील बटणावर क्लिक करून आमच्या Discord समुदायात देखील सामील होऊ शकता:

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'आमच्या सर्व्हरमध्ये सामील व्हा !')
