# メンテナンスガイド

このガイドは、コミュニティのためにプロジェクトを管理・維持するメンテナーとして、プロジェクトに参加したい人向けのものです。(このガイドは**初回コントリビュータ向け**のものではありません)

このチュートリアルは[ほかの言語](../README.md)でも提供されています。

> README の翻訳、またはメンテナンスガイドの README の翻訳を歓迎します！

## 目的

私たちの主な目的は、コントリビューター達がプルリクエストを作成した時点から可能な限り早くフィードバックを提供することです。これは主に、コードレビューの実施や認められた PR のマージを指します。
また、私たちはプロジェクトがすべて正しく機能し、コントリビューター達にとって役に立ち、使えることを確認するために、プロジェクトを維持することができます。

## 誰のため？

Git と GitHub のスキルが少しでも持っている人。専門家でなくても、このガイドは初心者にも役立つはずです。このプロジェクトは定期的にコントリビューションを受ける活発なプロジェクトで、多くの人が初めてオープンソースにコントリビューションするのに役立っています。
このプロジェクトのメンテナーになることで、コントリビューター達に最初の良い経験を与え続け、さらにコントリビューションすることを促すことができます。

あなたは好きなだけ、あるいは少ない時間であっても、プロジェクトに参加することができます。私たちの間で、円滑に運営できるようにしたいと思います。

## 方法

- プロジェクトのプルリクエストセクションに行き、最も古いプルリクエストから見て、'changes requested'ステートじゃないものから始めてください。
- PR を開き、ファイル変更タブでコードレビューを始めてください。
- PR を確認し、チュートリアルの仕様に従っていることを確認してください。
- HTML、リンク、データすべてが正しいことを確認してください。カードがファイルの先頭のあるべきところに配置されていることを確認してください。
- 次に競合が発生していないかを確認してください。競合が発生していた場合は、`master`ブランチを PR ブランチにマージして競合を修正してください。競合は前回のマージから時間が経過し、複数の PR が同じ古いバージョンを使用している場合に発生します。
- 上記のような競合のケースでは、新しいカードはフォークが作られた後に追加されたカードの上に追加する必要があります。
- 他が問題なければ PR を許可し、コントリビューターに対しお礼のメッセージを送ってください。(彼らは初心者であり、励ましから恩恵を受けることを忘れないでください).
- PR を`master`にマージしてください。

### 変更依頼

- たまに PR に問題があり、コントリビューター自身が修正するべき場合が発生します。例えば、ブランチが違う、壊れた HTML、データがない、カードが違うところにあったりなどのチュートリアルに正しく従っていないもの。(そして難しい競合の発生など).
- その場合は GitHub のファイル変更タブでコードレビューを行ってください。なるべく説明的な文章を心がけましょう。例えば、正確な行位置やどのような問題でどのように修正するのかなど。そしてこの PR レビューのプロセスが通常であるように伝えてしてください。
- コメントし尽したらレビューを投稿してください。
- コントリビューターからの質問に答えられるようにチャットから目を離さないようにしてください。私たちの目的は全員をゴールに導くことなので、そこまで導くことを心がけています。
- 要求された変更を修正したら、PR を`master`にマージできます。

変更内容がプロジェクトを破壊しないか、ライブページが期待通りに動作するかを常に確認してください。マージする前にローカルで変更をテストし、疑わしいものは決してマージしないようにしましょう。

## ツール

PR があまり溜まっていなければ、この作業はすべて GitHub で直接行うことができます。
しかしながら、いくつかの PR があることは珍しくなく、その場合は必然的にいくつかの競合が発生します。あなたの使い慣れたツールで差分を確認し、競合を修正することができます。
私は[GitKraken](https://www.gitkraken.com/download)のようなツールの利用をおすすめします。このツールは視覚的に見やすいので、PR がいくつかある場合でも管理がしやすいです。
GitKraken をダウンロードし、プロジェクトをクローンします。コードエディターと GitKraken の統合されたマージコンフリクトツールを組み合わせて使うことで、PR を素早く調べて、競合を修正し、マージすることができます。

このプロジェクトではコントリビューターがどのように PR を作成しても、スタイルガイドが強制的に適用されるために、Prettier がインストールされています。この方法により常に同じインデントとスタイルでプロジェクトの状態が維持されます。
もし、HTML ファイルが汚く見えるようであれば、プロジェクトのルートで下記のコマンドを実行してください。

```js
npx prettier --write index.html
```

上記コマンドはファイルをフォーマットしようとし、できなかった場合はエラーが表示されるはずです。たまに閉じタグがなかったり、HTML が壊れている状態で誤ってマージされることがありますが、これを発見して修正するのに役立ちます。

迷ったときは、PR 内で私もしくはほかのメンテナに伝えるか、[Twitter](https://twitter.com/Syknapse)で DM を送ってください。

## 参加してください

私たちと一緒にこのプロジェクトを成長させましょう。[Twitter](https://twitter.com/Syknapse)であなたの GitHub ユーザ名を送るとあなたをプロジェクトに追加できます。

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')
