# [Contribute To This Project](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> Logo Created with :sparkling_heart: By [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Оголошення:**
>
> Чи хотіли б ви бути супроводжуючим цього проєкту та допомагати підтримувати його роботу? Якщо ви зацікавлені, прочитайте [посібник з супроводу](/maintainer_guide.md ) і надішліть мені повідомлення на [Twitter](https://twitter.com/Syknapse).

---

### Індекс швидкого доступу

#### Зміст

- [Оголошення](#оголошення)
- [Вступ](#вступ)
- [Для кого це?](#для-кого-це)
- [Навіщо це потрібно робити?](#навіщо-це-потрібно-робити)
- [До чого я збираюся внести свій внесок?](#до-чого-я-збираюся-внести-свій-внесок)
- [Переклади](#переклади)
- [Налаштування](#налаштування)
- [Наступні кроки](#наступні-кроки)
- [Подяки](#подяки)

#### Кроки

- [Зробіть свій внесок](#зробіть-свій-внесок)
- [Крок 1 - Створіть “форк” сховища](#крок-1-створіть-форк-сховища)
- [Крок 2 - Зробіть клон сховища](#крок-2-зробіть-клон-сховища)
- [Крок 3 - Створіть нову гілку](#крок-3-створіть-нову-гілку)
- [Крок 4 - Відкрийте основний html файл](#крок-4-відкрийте-файл-indexhtml)
- [Крок 5 - Скопіюйте шаблон картки](#крок-5-скопіюйте-шаблон-картки)
- [Крок 6 - Застосуйте зміни](#крок-6-застосуйте-свої-зміни)
- [Крок 7 - Зробіть коміти змін](#крок-7-зробіть-коміти-своїх-змін)
- [Крок 8 - Надішліть зміни в GitHub](#крок-8-надішліть-зміни-в-github)
- [Крок 9 - Відкрийте Запит на Пул (PR)](#крок-9-відкрийте-запит-на-пул-pull-request)
- [Крок 10 - Відсвяткуйте](#крок-10-відсвяткуйте)

---

## Вступ

Це посібник, який допоможе початківцям долучитися до простого і зрозумілого проєкту.

### Мета

- Зробіть внесок у проєкт з відкритим кодом.
- Станьте більш досконалими у використанні GitHub.

### Для кого це?

- Це для абсолютних новачків. Якщо ви знаєте, як написати і відредагувати тег прив'язки `<a href="" target=""></a>`, тоді ви можете це зробити.
- Це також для тих, хто має трохи більше досвіду, але хоче зробити свій перший внесок в проєкт з відкритим кодом, або зробити більше внесків для більшого досвіду та впевненості.

### Навіщо це потрібно робити?

Будь-який веб-розробник, початківець або досвідчений, повинен повинен вміти контролювати версії Git, і GitHub є найпопулярнішим сервісом Git, яким користуються всі. Це також серце спільноти Open Source. Освоєння GitHub є важливою навичкою. Внесок у проєкт підвищує вашу впевненість і дає вам що показати у своєму профілі GitHub.

Якщо ви новий розробник і вам цікаво, чи потрібно вам вивчати Git та GitHub, то ось відповідь: [Ви повинні були вивчити Git вчора](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'Новий розробник? Ти повинен був вивчити Git вчора. by Брендон Мореллі, творець CodeBurst.io ').

### До чого я збираюся внести свій внесок

![Картка учасника](/readme-only/card.PNG 'Картка учасника')

Ви збираєтеся опублікувати на цій [веб-сторінці проєкту](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project') картку, схожа на цю. Вона буде включати ваше ім'я, ваш Twitter, короткий опис і 3 посилання на корисні ресурси для веб-розробників, які ви рекомендуєте.

Ви зробите копію шаблону картки всередині HTML-файлу та налаштуєте його за допомогою власної інформації.

---

### Переклади

Цей посібник також доступний на [інших мовах](/translations/README.md)

|     [Arabic](/translations/README/ARABIC.md)     |  [Bangla](/translations/README/BANGLA.md)  |            [English](/README.md)             |  [French](/translations/README/FRENCH.md)  |  [German](/translations/README/German.md)  |
| :---------------------------------------------: | :---------------------------------------: | :-----------------------------------------: | :---------------------------------------: | :---------------------------------------: |
|      [Hindi](/translations/README/HINDI.md)      | [Italian](/translations/README/ITALIAN.md) | [Japanese](/translations/README/JAPANESE.md) |  [Korean](/translations/README/KOREAN.md)  |  [Polish](/translations/README/POLISH.md)  |
| [Portuguese](/translations/README/PORTUGUESE.md) | [Russian](/translations/README/RUSSIAN.md) |  [Serbian](/translations/README/SERBIAN.md)  | [Spanish](/translations/README/SPANISH.md) | [Turkish](/translations/README/TURKISH.md) |
|  [Ukrainian](/translations/README/UKRAINIAN.md)  |

> Вітаються переклади проєктної документації. Прочитайте ['Посібник з перекладу'](/translations/README.md), щоб зробити свій внесок.

---

### Налаштування

Примітка: Цей підручник заснований на GitHub PC. [Якщо вам зручно користуватися терміналом, перейдіть до цього підручника (Натисніть тут)](/terminal_tutorial.md)

Спочатку, давайте налаштуємо все, щоб виконати роботу

1. Увійдіть до свого облікового запису GitHub. Якщо у вас ще немає облікового запису, [приєднайтеся до GitHub](https://github.com/join). Перш ніж продовжити, я рекомендую вам пройти [підручник GitHub Hello World](https://guides.github.com/activities/hello-world/).
2. Завантажте [додаток GitHub Desktop](https://desktop.github.com/).
   - Крім того, якщо вам зручно користуватися Git у командному рядку, ви можете це зробити [ось посилання на підручник CLI](/terminal-tutorial.md).
   - Якщо ви використовуєте [VS Code](https://code.visualstudio.com/ 'Сайт Visual Studio Code'), він поставляється з інтегрованим Git і дозволяє нам робити те, що нам потрібно, безпосередньо з редактора.
   - Однак найпростіший і найлегший спосіб слідувати цьому посібнику - використовувати GitHub Desktop.

> Тепер, коли все налаштовано, давайте приступимо до роботи над внеском у проєкт.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

### Зробіть свій внесок

Станьте учасником проєкту з відкритим кодом за 10 простих кроків.

_Приблизний час: менше 30 хвилин_.

#### Крок 1: Створіть “форк” сховища

- Мета полягає в тому, щоб зробити копію цього проєкту і помістити її в свій аккаунт.
- Сховище (репозиторій) - це те, як називається проєкт на GitHub, а форк - його копія.
- Переконайтеся, що ви перебуваєте на [головній сторінці](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') цього сховища.

| ![Fork](/readme-only/fork.png "Натисніть на 'Fork'") |
| :-------------------------------------------------: |
|           **Натисніть на кнопку _Fork_**            |

- Тепер у вас є повна копія проєкту у власному сховищі на GitHub. 

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 2: Зробіть клон сховища

- Тепер ми хочемо створити локальну копію проєкту. Тобто це копія, збережена на власному комп'ютері.
- Відкрийте настільну програму GitHub. У програмі:

| ![Clone](/readme-only/clone.PNG 'Натисніть clone repository') |
| :----------------------------------------------------------: |
|     **Натисніть на _File_ потім на _Clone repository_**      |

- Ви побачите список своїх проєктів і форків на GitHub.
- Виберіть `<Ваше-ім'я-користувача-на-github>/Contribute-To-This-Project`.
- Натисніть _Clone_

| ![Зробіть клон сховища](/readme-only/clone-project.PNG 'Натисніть на on =Ваше-ім\'я-користувача-на-github=/Contribute-To-This-Project') |
| :----------------------------------------------------------------------------------------------------------: |

| :arrow_right_hook: Форк проєкту матиме символ вилки зліва. Ваш форк матиме ваше ім'я користувача GitHub | ![ваш форк](/readme-only/clone-your-fork.PNG 'ваш форк буде виглядати так, з вашим ім\'ям користувача') |
| :------------------------------------------------------------------------------------------------------------------ | :----------------------------------------------------------------------------------------------------: |

- Знадобиться деякий час, щоб проєкт був скопійований на ваш жорсткий диск. Я рекомендую зберегти шлях за замовчуванням, який зазвичай є `..\Documents\GitHub`.
- Тепер у вас є локальна копія проєкту.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 3: Створіть нову гілку

- Після клонування сховища і відкриття його на робочому столі GitHub, прийшов час створити нову гілку.
- Гілка - це спосіб зберегти ваші зміни окремо від основної частини проєкту під назвою `Master`. Наприклад, якщо щось піде не так, і ви незадоволені своїми змінами, ви можете просто видалити гілку, і основний проєкт не постраждає.

| :arrow_right_hook: Натисніть на _`Current branch`_, потім натисніть на _`New`_ | ![Створити гілку](/readme-only/branch-new.PNG "Натисніть на 'Branch', потім 'New'") |
| :---------------------------------------------------------------------------- | :-----------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Дайте назву своїй гілці, а потім натисніть на `Create branch`** |                           ![Name branch](/readme-only/branch-name.PNG 'Дайте назву своїй гілці')                            |
| :arrow_right_hook: **Опублікуйте нову гілку на GitHub**                      | ![Name branch](/readme-only/branch-publish.PNG 'Натисніть опублікувати, щоб надіслати нову гілку до віддаленого сховища на GitHub') |

- Ви можете назвати її як завгодно, але оскільки це гілка для додавання картки з вашим ім'ям, назвати її `ваше-ім'я-користувача-card` буде хорошою практикою, оскільки вона зберігає наміри цієї гілки чіткими.
- Зараз ви створили нову гілку, яка відокремлена від основної.
- Для подальших кроків переконайтеся, що ви працюєте в цій гілці. Ви побачите назву гілки, в якій ви перебуваєте, у верхній центральній частині програми GitHub Desktop, де написано _Current branch_.

- **НЕ ПРАЦЮЙТЕ У ГІЛЦІ 'master'**

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 4: Відкрийте файл index.html

- Тепер нам потрібно відкрити файл, який ми збираємося редагувати, за допомогою улюбленого редактора коду.
- Знайдіть папку проєкту на комп'ютері. Якщо ви зберегли папку за замовчуванням, вона має бути приблизно такою: `Ваш комп'ютер > Документи > GitHub > Contribute-To-This-Project`.
- Файл `index.html` знаходиться безпосередньо в папці `Contribute-To-This-Project`.
- Відкрийте ваш редактор коду (Sublime, VS Code, Atom.. і т.п.), скористайтеся командою `Open file` і знайдіть файл index.html в головному каталозі проєкту

|               ![Open index file](/readme-only/index-open.PNG 'Відкрийте index.html в вашому текстовому редакторі')            |
| :------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Також ви можете знайти файл на жорсткому диску, клацнути правою кнопкою миші та відкрити за допомогою редактора** |

- Тепер файл, який ви збираєтеся редагувати, відкритий у вашому редакторі, і ви готові почати вносити в нього зміни.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 5: Скопіюйте шаблон картки

- Ми зробимо копію шаблону картки, щоб почати працювати над нею
- У верхній частині html-файлу, під розділами `<head>` і `<header>` ви знайдете розділ з міткою `== TEMPLATE ==`
- Скопіюйте все в межах червоного квадрата на зображенні з коментаря `Contributor card START` до коментаря `Contributor card END`

| ![Скопіюйте шаблон картки](/readme-only/card-copy.PNG 'Скопіюйте шаблон картки') |
| :-----------------------------------------------------------------------------: |

- Вставте все це безпосередньо під вказуючим на це коментарем
- Переконайтеся, що між початком вашої картки і кінцем останньої картки є один рядок пробілу. Рекомендується зберігати наш код якомога чіткішим
- Ніколи не використовуйте linter або форматери стилю. Проект має налаштування Prettier

| ![Вставте шаблон картки](/readme-only/card-paste.PNG 'Вставте нижче зазначеного рядка') |
| :------------------------------------------------------------------------------------: |

- Тепер це **ваша** картка, яку ви можете налаштувати та відредагувати.                              

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 6: Застосуйте свої зміни

- Тепер ми почнемо редагувати html, змінюючи користувацькі поля в нашій картці.

| :arrow_right_hook: Замініть 'Name' на ваше ім'я | ![Змініть ім'я](/readme-only/change-name.PNG 'Введіть своє ім\'я') |
| :---------------------------------------------- | :--------------------------------------------------------------: |

- **Примітка: не змінюйте `class="name"`**

| :arrow_right_hook: Вставте URL-адресу свого Твіттера `href="Insert URL here"`, введіть своє ім'я у текстове поле | ![Change contact](/readme-only/change-contact.PNG 'Insert a link to your Twitter account and type your handle') |
| :--------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- Якщо ви віддаєте перевагу іншим контактам, крім Твіттера, вам потрібно замінити значок твіттера `<i class="fa fa-x-twitter"></i>` на [Font Awesome Icons](http://fontawesome.io/icons/), знайшовши потрібну піктограму та замінивши лише частину `fa-x-twitter` на новий значок, наприклад, `fa-facebook`. Потім виконайте ті ж дії, що і вище.

|                                                                                                                                         ![Change about](/readme-only/change-about.PNG 'Напишіть речення про вас')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **Розкажіть дещо про вас. Нехай це буде коротким і приємним. Думайте про це більше як твіт, ніж як публікацію в блозі**                                                                                                                |
|                                                                                                              ![Change resources](/readme-only/change-resources.PNG 'Вставте посилання, напишіть короткий опис і введіть назву ресурсу')                                                                                                              |
| :arrow_right_hook: **Поділіться зі спільнотою 3 посиланнями на ресурси, корисні для веб-розробки. Це може бути що завгодно, відео, виступ, подкаст, стаття, посилання або інструмент. Якщо ви новачок, нехай вас це не лякає, поділіться тим, що знаєте, навіть якщо вважаєте це базовим. Ви здивуєтеся, скільки людей отримають користь.** |

- **Посилання:** вставте посилання `href="сюди"` замінючи `#`. Будь ласка, утримайтеся від використання скорочувачів URL-адрес або URL-адрес, які не належать до сайту, який ви публікуєте!
- **Заголовок:** Напишіть короткий опис `title="сюди"`.
- **Назва:** Напишіть ім'я ресурсу в текстовому полі `>сюди</a>`.
- Переконайтеся, що ви **зберігли всі зміни**.
- **Протестуйте свої зміни**. ЦЕ ДУЖЕ ВАЖЛИВО! Відкрийте html-файл в браузері (наприклад, двічі клікнувши по ньому) і подивіться, як ваша картка буде виглядати на сайті. Переконайтеся, що вся сторінка виглядає однаково і нічого не зламано. Натисніть на свої посилання та переконайтеся, що вони працюють. Відкрийте консоль (Ctrl + Shift + J (Windows / Linux) або Cmd + Opt + J (Mac)) і перевірте, чи немає повідомлень про помилки.
- Чудово, ви закінчили редагувати код! Наступні кроки надішлють ваші зміни до GitHub, а потім відправлять їх до об'єднання з основним проєктом.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 7: Зробіть коміти своїх змін

- Поверніться до програми GitHub.
- Внесені зміни буде автоматично додано до області зберігання.
- Це означає, що Git записав усі **збережені** зміни.
- Ви можете побачити це в програмі. Все, що ви додали до файлу, буде виділено зеленим, а видалення - червоним.

|                                                                                                  ![Commit changes](/readme-only/commit.PNG "Додані вами зміни мають з'явитися зеленим кольором праворуч у програмі GitHub. Кнопка Commit знаходиться внизу ліворуч")                                                                                                  |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: Наступний крок називається _`Commit`_. Це приблизно означає `підтвердити зміни` |
|                                                                                              ![Commit changes](/readme-only/commit-header.PNG "Додані вами зміни мають з'явитися зеленим кольором праворуч у програмі GitHub. Кнопка Commit знаходиться внизу ліворуч")                                                                                               |
|                                                                            :arrow_right_hook: **Саме так має виглядати ваш заголовок програми GitHub. Зверніть увагу на символ вилки поруч з назвою проєкту в `Current repository`, Ваш `Current branch` матиме ім'я, яке ви дали йому на кроці 3**                                                                            |
|                                                                                                                  ![Write commit message and commit](/readme-only/commit-message.PNG "Напишіть коротке повідомлення про коміт в полі 'summary', і натисніть кнопку 'commit'")                                                                                                                  |
| :arrow_right_hook: **Для того, щоб зробити _`Commit`_, вам необхідно заповнити поле _`Summary`_. Це повідомлення про коміт, яке пояснює, що ви змінили. У цьому випадку `"Додати дані моєї картки"` було б розумним повідомленням. За бажанням можна додати більш детальний опис у поле _`Description`_. Натисніть кнопку _`Commit`_. Ваша кнопка скаже щось на зразок `Commit to "your-branch-name"`** |

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 8: Надішліть зміни в GitHub

- Тепер ваші зміни збережено або committed. Але вони зберігаються тільки локально, тобто на вашому комп'ютері.
- Синхронізація локальних змін зі сховищем GitHub називається _Push_. Ви "проштовхуєте" зміни з локального сховища до віддаленого сховища на GitHub.

| :arrow_right_hook: Натисніть кнопку _`Push`_ | ![Push to GitHub](/readme-only/push.PNG "Надішліть свої зміни на GitHub, натисніть на кнопку 'Push'") |
| :------------------------------------------- | :-----------------------------------------------------------------------------------------------: |

- Через кілька секунд операція буде завершена, і тепер у вас є точно така ж копія цієї гілки як на вашому комп'ютері, так і на GitHub.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 9: Відкрийте Запит на Пул (Pull Request)

- Настав момент, якого ви так довго чекали: подання _Запиту на Пул_ (Pull Request - PR).
- Поки що вся робота, яку ви зробили, була пов'язана з форком проєкту, який, як ви пам'ятаєте, знаходиться у вашому власному обліковому записі GitHub.
- Тепер настав час перенести свої зміни в основний проєкт, щоб об'єднати з ним.
- Це називається [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help'), тому що ви просите супроводжуючого (maintainer) оригінального проєкту "перетягнути" ваші зміни до свого проєкту.
- Перейдіть на головну сторінку **вашого форка** на GitHub (нагорі буде значок вилки і ваш логін).
- У верхній частині сховища ви побачите виділене повідомлення Pull Request з зеленою кнопкою.

|  ![Submit a Pull Request](/readme-only/pull-request.PNG 'Зазвичай це знаходиться вгорі сторінки, під описом і над файлами та папками проєкту')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Натисніть на кнопку `Compare and pull request`**                                                     |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'Ви подаєте запит на об\'єднання вашої гілки з вашого форка в головну гілку оригінального проєкту') |
|                                              :arrow_right_hook: Приблизно так виглядає сторінка `Open a pull request`.                                               |

- ПАМ'ЯТАЙТЕ, _ви намагаєтеся об'єднати вашу гілку з оригінальним проєктом, а не з гілкою `Master` вашого форка_.
- Зображення нижче дасть вам уявлення про те, як має виглядати заголовок вашого pull request.
- Зліва - оригінальний проєкт, за яким слідує гілка `Master`. Праворуч - ваш форк і гілка, яку ви створили.

|                   ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Натисніть зелену кнопку. Не лякайтеся!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Створить pull request: введіть заголовок, додайте необов'язкову інформацію в опис і натисніть на `Create pull request`** |

- Нехай вас не бентежать усі варіанти. Поки що вам потрібно виконати лише ці три кроки.
- Залиште опцію `Allow edits from maintainers` позначеною галочкою.
- Тепер, ваш _Pull Request_ буде надіслано супроводжуючому оригінального проєкта. Коли він буде розглянутий та прийнятий, ваші зміни з'являться на вкладці [веб-сторінки проєкту](https://syknapse.github.io/Contribute-To-This-Project 'Contribute To This Project web page').

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

#### Крок 10: Відсвяткуйте

От і все. Ви зробили це! Тепер ви зробили свій внесок у відкритий код на GitHub.

Ви додали код на опубліковану веб-сторінку: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Ваші зміни **не будуть помітні відразу**; Спочатку вони повинні бути переглянуті, прийняті та консолідовані супроводжувачем проєкту. Після їх об'єднання ваша картка повинна бути видимою і діючою на сторінці.

Це цілком нормально, якщо рецензент може просити про внесення змін в ваш PR. Вважайте це хорошою практикою, якщо так трапиться з вами. Слідкуйте за коментарями та запитами на внесення змін. Після того, як ви внесли запрошені рецензентом зміни (у свою гілку), все, що вам потрібно, це зробити commit та push ваших змін. PR буде автоматично оновлений новими змінами.

Обіцяю, що постараюся переглянути і об'єднати якомога швидше, але роблю це у вільний час, тому затримка на кілька днів неминуча.

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

### Наступні кроки

- Поверніться через деякий час, щоб перевірити, як обробився ваш Pull Request.
- Ви повинні отримати електронний лист від GitHub, коли ваші зміни будуть схвалені, або якщо будуть запитані додаткові зміни. І коли PR буде остаточно з'єднаний з master, ваша картка буде додана.
- Ви також можете дізнатися, як зробити свій внесок із цієї _безкоштовної_ серії: [Як зробити внесок у проект з відкритим кодом на GitHub](https://kcd.im/pull-request)
- Якщо ви вважаєте цей проєкт **корисним**, будь ласка, поставте йому :star: зірочку :star: у верхній частині сторінки і напишіть **Tweet** про нього щоб допомогти поширити інформацію [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project').
- Ви можете **стежити за мною** і зв'язатися зі мною на [Twitter](https://twitter.com/Syknapse '@Syknapse') або [використайте будь-який з цих інших варіантів](https://syknapse.github.io/Syk-Houdeib/#contact 'Розділ мої контакти | Портфоліо').
- Це проєкт з відкритим кодом, тому, окрім додавання вашої картки, ви можете допомогти виправити помилки, покращити або створити нові функції. Відкрийте [проблему](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') або надішліть новий [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help').
- Щоб допомогти покращити нашу спільноту, погляньте на розділ GitHub [Discussions](https://github.com/Syknapse/Contribute-To-This-Project/discussions), розташований поруч з Pull Requests. Це місце, де можна представитися, заглибитися в дискусію Open Source та поспілкуватися з супроводжуючими проєкту. Допоможете нам створити цю функцію та покращити нашу спільноту?
- **Дякуємо, що зробили свій внесок у цей проєкт**. Тепер ви можете спробувати зробити свій внесок в інші проєкти; зверніть увагу на позначку ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png), щоб знайти варіанти зробити свій внесок, зручні для початківців.
- Я також шукаю співавторів, які могли б допомогти мені з експертною оцінкою та об'єднанням PR. Якщо ви хочете отримати більш просунуту практику Git, будь ласка, напишіть мені DM у Twitter і прочитайте [керівництво супроводжуючого](/maintainer_guide.md).

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

---

### Подяки

На цей проєкт сильно вплинула робота [Рошана Джоссі](https://github.com/Roshanjossey) Чудові [перші внески](https://github.com/Roshanjossey/first-contributions) з його чудовим підручником.

Цей проєкт також особливо надихається великою спільнотою навколо [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) Стипендія Google Challenge: Front-End Web Dev, клас 2017 року в Європі.

### 100 найкращих авторів

[![Зображення учасників GitHub](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[↑ Повернутися до початку ↑](#індекс-швидкого-доступу)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
