# [Contribuye a este proyecto](https://syknapse.github.io/Contribute-To-This-Project/)

![Logo del proyecto](/favicon.png)

> Logo Created with :sparkling_heart: By [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Twittea este proyecto')

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Unete a nuestro servidor de Discord!')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Anuncio:**
>
> Te gustaría formar parte de este proyecto y ayudar a mantenerlo? Si estás interesado, lee la [guía para mantenedores](/maintainer_guide.md) y envíame un DM en [Twitter](https://twitter.com/Syknapse).

---

### Índice de acceso rápido

#### General

- [Anuncios](#anuncio)
- [Introducción](#introducción)
- [Objetivos](#objetivos)
- [Para quién es?](#para-quién-es)
- [Por qué debería hacer esto?](#por-qué-debería-hacer-esto)
- [Con qué voy a contribuir?](#con-qué-voy-a-contribuir)
- [Traducciones](#traducciones)
- [Preparación](#preparación)
- [Próximos pasos](#próximos-pasos)
- [Agradecimientos](#agradecimientos)

#### Pasos

- [Contribuye](#contribuye)
- [Paso 1: Copia el repositorio](#paso-1-copia-el-repositorio)
- [Paso 2: Clona el repositorio](#paso-2-clona-el-repositorio)
- [Paso 3: Crea una nueva rama](#paso-3-crea-una-nueva-rama)
- [Paso 4: Abre el archivo html](#paso-4-abre-el-archivo-html)
- [Paso 5: Copia la plantilla de la tarjeta](#paso-5-copia-la-plantilla-de-la-tarjeta)
- [Paso 6: Aplica tus cambios](#paso-6-aplica-tus-cambios)
- [Paso 7: Confirma tus cambios](#paso-7-confirma-tus-cambios)
- [Paso 8: Sube tus cambios a GitHub](#paso-8-sube-tus-cambios-a-github)
- [Paso 9: Crea una solicitud para que añadan tus cambios](#paso-9-crea-una-solicitud-para-que-añadan-tus-cambios)
- [Paso 10: A celebrar!](#paso-10-a-celebrar)

---

## Introducción

Éste es un tutorial para ayudar a aquellos que quieren contribuir por primera vez a un proyecto fácil y simple.

### Objetivos

- Hacer una contribución a un proyecto de código abierto.
- Ganar confianza usando Github.

### Para quién es?

- Es para principiantes absolutos. Si sabes como escribir y editar una etiqueta de hipertexto `<a href="" target=""></a>` entonces deberías ser capaz de seguir este tutorial.
- Es también para aquellos que, aún con un poco más de experiencia, quieran hacer su primera contribución al código abierto, o hacer más contribuciones para ganar experiencia y confianza.

### Por qué debería hacer esto?

Cualquier desarrollador web, principiante o experimentado, necesita usar el control de versiones Git y Github es el servicio más popular. Es también el corazón de la comunidad de código abierto. Sentirse cómodo usando Github es una habilidad esencial.
Hacer una contribución al código abierto aumenta tu confianza y te provee de algo para mostrar en tu perfil de Github.<br>
Si eres nuevo en el desarrollo de software y te estás preguntando si necesitas aprender Git y Github, la respuesta es: [Deberías haber aprendido Git ayer](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'New Developer? You should’ve learned Git yesterday. Por Brandon Morelli, creador de CodeBurst.io').

### Con qué voy a contribuir?

![Tarjeta de contribuyente](/readme-only/card.PNG 'Tarjeta de contribuyente')

Vas a contribuir con una tarjeta como ésta a la [página del proyecto](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project'). La tarjeta va a incluir tu nombre, tu usuario de twitter, una descripción y tres recomendaciones de hipervínculos apuntando a recursos que tú creas útiles para desarrolladores.

Vas a hacer una copia de la plantilla de la tarjeta dentro del archivo HTML y vas a personalizarla con tu información.

---

### Traducciones

Este tutorial tambien está disponible en [otros idiomas](/translations/README.md)

|     [Árabe](/translations/README/ARABIC.md)     |  [Bengalí](/translations/README/BANGLA.md)  | [Chino (Tradicional)](/translations/README/CHINESE_TRADITIONAL.md) |            [Inglés](/README.md)             |  [Francés](/translations/README/FRENCH.md)  
| :---------------------------------------------: | :---------------------------------------: | :-----------------------------------------: | :---------------------------------------: | :---------------------------------------: |
|  [Alemán](/translations/README/GERMAN.md)  |      [Hindú](/translations/README/HINDI.md)      | [Italiano](/translations/README/ITALIAN.md) | [Japonés](/translations/README/JAPANESE.md) |  [Coreano](/translations/README/KOREAN.md)  |
  [Polaco](/translations/README/POLISH.md)  | [Portugués](/translations/README/PORTUGUESE.md) | [Ruso](/translations/README/RUSSIAN.md) |  [Serbio](/translations/README/SERBIAN.md)  | [Español](/translations/README/SPANISH.md) |
   [Turco](/translations/README/TURKISH.md) | [Ucraniano](/translations/README/UKRAINIAN.md) |

> Las traducciones para la documentación del proyecto son bienvenidas. Lee la [`Guia de traducciones`](/translations/README.md) para contribuir.

---

### Preparación

Nota: Este tutorial está basado en GitHub para escritorio. [Si te sientes cómodo usando la terminal ve a este tutorial (Click Aquí)](/terminal_tutorial.md)

Primero, vamos a preparar lo necesario:

1. Inicia sesión en tu cuenta de GitHub. Si aún no tienes una, [créala](https://github.com/join). Te recomiendo que sigas el tutorial [Hello World Github tutorial](https://guides.github.com/activities/hello-world/) antes de continuar.
2. Descarga el software [GitHub Desktop](https://desktop.github.com/).
   - Si te sientes cómodo usando Git en la consola de comandos, puedes hacerlo (el tutorial [first-contributions](https://github.com/Syknapse/first-contributions) es un proyecto similar a éste que puede servirte de guia para los comandos que necesitarás).
   - Si usas [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website'), trae integrado Git y te permite hacer lo que necesites directamente desde el editor.
   - Sin embargo, la forma más simple y fácil de seguir este tutorial es usar GitHub Desktop.

> Ahora que tenemos todo listo vamos a ponernos manos a la obra para contribuir al proyecto.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

### Contribuye

Conviértete en un contribuyente al código abierto en 10 sencillos pasos.

_Tiempo estimado: Menos de 30 minutos_.

#### Paso 1: Copia el repositorio

- El objetivo aquí es hacer una copia de éste proyecto para colocarlo en tu cuenta.
- Un repositorio (repo) el nombre que se le da a un proyecto en GitHub y una bifurcación (fork) es una copia del mismo.
- Asegúrate de estar en la [página principal](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') de éste repositorio.

| <ul><li>Haz click en el botón _Fork_ </li></ul> | ![Fork](/readme-only/fork.png "Haz click en 'Fork'") |
| :---------------------------------------------- | ---------------------------------------------------: |


- Ahora tienes una copia completa del proyecto en tu propia cuenta.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 2: Clona el repositorio

- Ahora queremos hacer una copia local del proyecto, ésto es, una copia guardada en tu computadora.
- Abre la aplicacion GitHub Desktop y en la aplicación:

| <ul><li>Haz click en _File_ y luego en _Clone repository_</li></ul> | ![Clone](/readme-only/clone.PNG 'Haz click en "clone repository"') |
| :------------------------------------------------------------------ | -----------------------------------------------------------------: |


| <ul><li>Vas a ver una lista de tus proyectos y bifurcaciones en GitHub.</li><li>Selecciona `<tu-nombre-de-usuario-de-github'>/Contribute-To-This-Project`.</li><li>Haz click en _Clone_</li></ul> | ![Clona el proyecto](/readme-only/clone-project.PNG 'Selecciona <tu-nombre-de-usuario-de-github>/Contribute-To-This-Project') |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | :---------------------------------------------------------------------------------------------------------------------------: |
| ![Pega la plantilla de la tarjeta](/readme-only/card-paste.PNG 'Pega sobre la línea indicada')                                                                                                                                                                                                                                                               |

- Va a tomar un momento realizar la copia del proyecto a tu disco duro. Te recomiendo que dejes la ruta por defecto que normalmente es `..\Documentos\GitHub`.
- Ahora tienes una copia local del proyecto

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 3: Crea una nueva rama

- Una vez que el repositorio se ha clonado y tienes abierto GitHub Desktop es hora de crear una nueva rama (branch).
- Una rama es la manera de mantener separados tus cambios del proyecto principal llamado `Master`. Si, por ejemplo, las cosas van mal y no estas conforme con los cambios que has hecho, simplemente puedes borrar la rama y el proyecto principal no se verá afectado.

| <ul><li>Haz click en _Current branch_</li><li>Luego en _New_</li></ul> | ![Crear rama](/readme-only/branch-new.PNG "Click en 'Branch', luego en 'New'") |
| :--------------------------------------------------------------------- | -----------------------------------------------------------------------------: |


| <ul><li>Dale un nombre a tu rama</li><li>Haz click en `Create branch`</li></ul> | ![Nombra tu rama](/readme-only/branch-name.PNG 'Nombra tu rama') |
| :------------------------------------------------------------------------------ | ---------------------------------------------------------------: |


- La puedes llamar como desees pero dado que es una rama en la que agregarás una tarjeta al proyecto, llamarla `tarjeta-de-tu-nombre` es una buena práctica, ya que quedará clara cual es la intención de la rama.

| <ul><li>Publica tu nueva rama en Github</li></ul> | ![Nombre de la rama](/readme-only/branch-publish.PNG 'Haz click en "Publish" para enviar la nueva rama a tu repositorio en GitHub') |
| :------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------: |


- Haz creado una nueva rama separada de la rama 'master' (que es la principal).
- Para los próximos cambios asegúrate de estar trabajando en ésta rama. Arriba y al centro de GitHub Desktop (donde se lee _Current Branch_) podrás ver el nombre de la rama en la que estas ubicado.

**NO trabajes en la rama `master`**

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 4: Abre el archivo html

- En éste momento necesitaremos abrir el archivo que vamos a modificar con tu editor de código favorito.
- Busca la carpeta en tu computadora. Si usaste las opciones por defecto debería estar en `tu-nombre-de-usuario-de-windows > Documentos > GitHub > Contribute-To-This-Project`
- El archivo `index.html` está justo en la carpeta `Contribute-To-This-Project`.

| <ul><li>Abre tu editor (Sublime, VS Code, Atom, etc.) y utiliza el comando `Open file` para localizar el archivo index.html en el directorio principal del proyecto</li><li>También puedes hacerlo localizando el archivo en tu disco duro, darle click derecho y abrir con tu editor.</li></ul> | ![Abrir el archivo index](/readme-only/index-open.PNG 'Abrir index.html en tu editor de texto') |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------: |


- Ahora tienes el archivo que vas a editar abierto en tu editor y estás listo para comenzar a hacer cambios en él.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 5: Copia la plantilla de la tarjeta

- Vamos a hacer una copia de la tarjeta para empezar a trabajar en ella

| <ul><li>Desplázate hacia abajo hasta el final del archivo, donde encontrarás una sección etiquetada como `== TEMPLATE ==`</li><li>Copia todo lo que está dentro del recuadro rojo en la imagen, desde el comentario `Contributor card START` hasta el comentario `Contributor card END`</li></ul> |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| ![Copia la plantilla de la tarjeta](/readme-only/card-copy.PNG 'Copia la plantilla de la tarjeta')                                                                                                                                                                                                |

| <ul><li>Pega todo justo debajo del comentario que lo indica</li><li>Asegúrate de dejar sólo una linea entre el final de la última tarjeta y el principio de tu tarjeta. Es una buena práctica dejar tu código tan claro como sea posible</li><li>Asegúrate de que la indentación de tu código es la correcta y que coincide con la de la plantilla</li></ul> |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Pega la plantilla de la tarjeta](/readme-only/card-paste.PNG 'Pega sobre la línea indicada')                                                                                                                                                                                                                                                               |

- Ésta es ahora **tu** tarjeta y puedes personalizarla.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 6: Aplica tus cambios

- Comenzaremos editando el html, cambiando los campos personalizables en nuestra tarjeta.

| <ul><li>Reemplaza 'Name' con tu nombre</li><li>Nota: No cambies `class="name"`</li></ul> | ![Cambia el nombre](/readme-only/change-name.PNG 'Escribe tu nombre') |
| :--------------------------------------------------------------------------------------- | --------------------------------------------------------------------: |


| <ul><li>Inserta la URL de tu cuenta de Twitter `href="Insert URL here"`</li><li>Escribe tu @ en el campo de texto</li></ul> |
| :-------------------------------------------------------------------------------------------------------------------------- |
| ![Cambiar contacto](/readme-only/change-contact.PNG 'Inserta un vínculo a tu cuenta de Twitter y escribe tu arroba')        |

- Si prefieres usar otro método de contacto en lugar de Twitter, deberás reemplazar el ícono`<i class="fa fa-x-twitter"></i>` yendo a [Font Awesome Icons](http://fontawesome.io/icons/), buscando el ícono adecuado y reemplazando sólo la parte de `fa-x-twitter` con la del nuevo ícono. `fa-facebook` por ejemplo. Luego continúa con los mismos pasos.

| <ul><li>Dinos algo acerca de tí</li><li>Hazlo corto y sencillo. Piensa mas en un tweet que en un artículo de un blog</li></ul> | ![Cambia el "Acerca de"](/readme-only/change-about.PNG 'Escribe una oración acerca de tí') |
| :----------------------------------------------------------------------------------------------------------------------------- | -----------------------------------------------------------------------------------------: |


| <ul><li>Comparte con la comunidad tres enlaces que puedan ser útiles para el desarrollo web</li><li>Puede ser lo que quieras: un vídeo, una charla, un podcast, un artículo, una referencia o una herramienta</li><li>Si eres un principiante no te sientas intimidado por ésto, comparte lo que conozcas aunque pienses que es básico. Te sorprenderá la cantidad de gente que se beneficiará de eso</li></ul> |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Cambia recursos](/readme-only/change-resources.PNG 'Inserta un enlace, escribe una descripción corta y el nombre del recurso')                                                                                                                                                                                                                                                                                |
| <ul><li>Enlace: Inserta el enlace `href="aquí"` reemplazando el `#`</li><li>Título: Escribe una breve descripción `title="aquí"`</li><li>Nombre: Escribe el nombre del recurso en el campo de texto `>aquí</a>`</li></ul>                                                                                                                                                                                       |

- Asegúrate de haber **guardado todos tus cambios**.
- **Prueba tus cambios**. ÉSTO ES IMPORTANTE! Abre el archivo html en tu navegador (dándole doble click, por ejemplo) y observa como se ve tu tarjeta en el sitio. Verifica que la página completa luce igual y que nada está roto. Haz click en tus enlaces y comprueba que funcionan. Abre la consola (Ctrl + Shift + J (Windows / Linux) o Cmd + Opt + J (Mac)) y verifica que no hay mensajes de error.
- Genial, has terminado de editar tu código! Los pasos siguientes subirán tus cambios a GitHub y los enviarán para ser unidos con el proyecto principal.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 7: Confirma tus cambios

- Ve hacia atrás en la aplicacion GitHub Desktop.
- Tus cambios serán agregados automáticamente al area de trabajo (staging area).
- Ésto significa que Git ha registrado todos los cambios **guardados**.
- Puedes ver ésto reflejado en la aplicación. Todo lo que has agregado al archivo estará en verde y lo que has borrado se mostrará en rojo.

| <ul><li>El próximo paso se llama _Commit_</li><li>Ésto significa "confirma los cambios"</li></ul> | ![confirma los cambios](/readme-only/commit.PNG 'Los cambios que has agregado deberían aparecer en verde a la derecha de GitHub Desktop. El botón Commit está abajo a la izquierda') |
| :------------------------------------------------------------------------------------------------ | -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>Así es como debería verse la cabecera de GitHub Desktop</li><li>Nota el símbolo de bifurcación cerca del nombre del proyecto en `Current repository` (Repositorio actual)</li><li>Tu `Current branch` (Rama actual) tendrá el nombre que le diste en el paso 3</li></ul> |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Confirma los cambios](/readme-only/commit-header.PNG 'Los cambios que has agregado deberían aparecer en verde a la derecha de GitHub Desktop. El botón Commit está abajo a la izquierda')                                                                                      |

| <ul><li>Para confirmar tus cambios (_Commit_) deberás llenar el campo _Summary_ (Resumen)</li><li>Éste es el mensaje de confirmación que explica tus cambios</li><li>En éste caso "Agregué mi tarjeta de información" sería un mensaje acorde</li><li>Opcionalmente puedes usar el campo _Description_ para añadir mas información</li><li>Haz click en el botón _Commit_. Tu boton va a decir algo como `Commit to "nombre-de-tu-rama"`</li></ul> | ![Escribe un mensaje y confirma](/readme-only/commit-message.PNG "Escribe un breve mensaje en 'summary' y haz click en 'commit'") |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------: |

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 8: Sube tus cambios a GitHub

- Tus cambios ahora están guardados o confirmados. Pero ellos están guardados localmente, es decir, en tu computadora.
- Sincronizar cambios locales con tu repositorio en GitHub es llamado _Push_. Estás "pusheando" (subiendo) los cambios desde tu ambiente local a tu repositorio remoto en GitHub.

| <ul><li>Haz click en el botón _Push_</li></ul> | ![Push a GitHub](/readme-only/push.PNG "Sube tus cambios a GitHub, haz click en el botón 'Push'") |
| :--------------------------------------------- | ------------------------------------------------------------------------------------------------: |


- Despues de unos segundos la operación se habrá completado y tendras exactamente la misma copia de esta rama tanto en tu computadora como en GitHub.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 9: Crea una solicitud para que añadan tus cambios

- Éste es el momento por el que has estado esperando: enviar una solicitud para que añadan tus cambios (_Pull Request_ o _PR_).
- Hasta aquí, todo el trabajo que has hecho ha sido en tu bifurcación del proyecto que, como recuerdas, vive en tu propia cuenta de GitHub.
- Es hora de enviar tus cambios al proyecto principal para que sea unido a él.
- Ésto es llamado ([_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help')) porque estas solicitando a quien mantiene el proyecto original que "extraiga" tus cambios y los incluya en el proyecto.
- Vé a la página principal de tu **bifurcación** en GitHub (tendrá el símbolo de bifurcación y tu nombre arriba).
- Hacia la parte superior del repositorio verás un mensaje de Pull Request resaltado con un botón verde.

| <ul><li>Haz click en `Compare and pull request`</li></ul> | ![Enviar una Pull Request](/readme-only/pull-request.PNG 'Ésto usualmente está ubicado hacia la parte superior de la página, bajo la descripción y sobre las carpetas y archivos del proyecto') |
| :-------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>Así es como luce la página `Open a pull request` (Abrir una Pull Request).</li><li>RECUERDA _estás tratando de unir tu rama con el proyecto original, no con la rama `master` de tu bifurcación_.</li><li>La imagen a continuación de una idea de como debería verse la cabecera de tu Pull Request.</li><li>A la izquierda el proyecto original, seguido por la rama master. A la derecha está tu bifurcación y la rama que creaste.</li></ul> |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Abre una Pull Request](/readme-only/pull-request-branches.PNG 'Estás solicitando que se una la rama de tu bifurcación a la rama master del proyecto original')                                                                                                                                                                                                                                                                                                   |

| <ul><li>Crear una Pull Request:</li><li>Escribe un título</li><li>Agrega información adicional en la descripción</li><li>Haz click en `Create pull request`</li></ul> | ![Envía una Pull Request](/readme-only/pull-request-open.PNG 'Haz click en el boton verde, no tengas miedo!!') |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------: |


- No te marees con la cantidad de opciones. Solo necesitas seguir estos tres pasos por ahora.
- Deja marcada la opción `Allow edits from maintainers` (Permitir que quien mantiene el proyecto haga cambios)
- Ahora un _Pull Request_ será enviado a quien mantiene el proyecto. Tan pronto como él lo revise y acepte tus cambios, ellos aparecerán en la [página del proyecto](https://syknapse.github.io/Contribute-To-This-Project 'Página web de Contribute To This Project').

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

#### Paso 10: A celebrar!

Eso es todo. Lo hiciste! Has contribuido al código abierto en GitHub.

Has agregado código a la página: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Tus cambios **no serán visibles inmediatamente**; primero deben ser revisados, aceptados y unidos al proyecto por quien lo mantiene. Una vez que sean unidos, tu tarjeta será visible en la página.

Es muy normal que un revisor pida que hagas cambios en tu Pull Request. Piensa en ésto como una buena práctica si llega a sucederte. Presta atención a los comentarios y los cambios solicitados. Una vez que hagas esos cambios (nuevamente en tu rama), todo lo que tienes que hacer es confirmar tus cambios y subirlos (commit y push). La Pull Request se actualizará automáticamente con los nuevos cambios.

Te prometo tratar de revisar y unir los cambios tan pronto como me sea posible pero lo hago en mi tiempo libre, por lo que algunos dias de retraso son inevitables.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

### Próximos pasos

- Vuelve en un tiempo para verificar que tus cambios se hayan unido.
- Deberías recibir un email de GitHub cuando tus cambios hayan sido aprobados, si te han pedido cambios adicionales y si la Pull Request está finalmente unida a master y tu tarjeta ha sido añadida.
- Si encuentras **útil** éste proyecto, por favor dale una :star: estrella :star: al inicio de la página y **twittea** al respecto para hacer correr la voz [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Twittea este proyecto')
- Puedes **seguirme** y estar en contacto en [Twitter](https://twitter.com/Syknapse '@Syknapse') o [usando cualquiera de estas otras opciones](https://syknapse.github.io/Syk-Houdeib/#contact 'Mi sección de contacto | Portfolio')
- Éste es un proyecto de código abierto, por lo que aparte de contribuir con tu tarjeta eres bienvenido a corregir errores, a proponer mejoras y a agregar funcionalidades. Abre un [issue](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') o envía una nueva [Pull Request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help')
- **Gracias por contribuir a éste proyecto**. Ahora puedes ir y tratar de contribuir a otros. Busca la etiqueta ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) para ver los issues orientados a principiantes.
- También estoy buscando colaboradores para que me den una mano revisando y uniendo las solicitudes de extracción. Si te gustaría ganar conocimientos y práctica con Git, enviame un mensaje privado via Twitter.

[↑ Ir arriba ↑](#índice-de-acceso-rápido)

---

### Agradecimientos

Éste proyecto está fuertemente influenciado por el grandioso proyecto [first-contributions](https://github.com/Roshanjossey/first-contributions) de [Roshan Jossey](https://github.com/Roshanjossey) con su excelente tutorial.

También está particularmente inspirado por la grandiosa comunidad alrededor de [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) La beca Google: Desarrollo web Front-End, clase de 2017 Europa.

### Licencias

[MIT License](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/LICENSE)

### Top 100 Contributors

[![GitHub Contributors Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[Volver al principio &uparrow;](#introducción)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Twittea este proyecto'
