# [Doprinesi ovom projektu](https://syknapse.github.io/Contribute-To-This-Project/)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project')

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')

> **Objava:** Želite da pomognete razvoj ovog projekta? Ako ste zainteresovani posaljite mi poruku na Tviteru. [Twitter](https://twitter.com/Syknapse) i procitajte vodič [vodič za održavaoca projekta](maintainer_guide.md).

## Uvod

Ovo je tutorijal koji pomaže onima koji prvi put žele da učestvuju u jednostavnom i lakom projektu.

Ovaj tutorijal je takođe dostupan [drugi jezici](https://github.com/Syknapse/Contribute-To-This-Project/tree/master/translations) ([Engleski](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/README.MD), [Portugalski](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/translations/PORTUGUESE.md), [Spanski](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/translations/SPANISH.md), and [Italijanski](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/translations/ITALIAN.md) trenutno. Prevodi su veoma dobrodošli.).

### Ciljevi

- Dajte doprinos projektu otvorenog koda.
- Učite GitHub.

### Za koga je ovo namenjeno?

- Ovo je namenjeno apsolutnim početnicima. Ukoliko znate kako da napišete tag `<a href="" target=""></a>` , trebalo bi da budete u mogućnosti da ovo odradite.
- Ovo je namjenjeno i onima sa malo više iskustva, ali koji žele da daju svoj prvi doprinos projektu otvorenog koda, ili da dobiju više iskustva i samopouzdanja.

### Zašto sam započeo ovaj projekat?

Svaki veb developer koji je ambiciozaN ili iskusan treba da koristi Git - kontrolu verzija, a GitHub je najpopularnija uluga Git hostinga koju koriste svi. Takođe je srce zajednice otvorenog koda. Dobro poznavanje GitHub-a je neophodna veština. Davanje doprinosa projektu povećava vaše samopouzdanje i daje vam nešto što možete da pokažete na svom GitHub profilu.<br>
Ako ste novi u programiranju i pitate se da li treba da naučite Git i GitHub, evo odgovora: [Trebali ste naučiti Git juče](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'New Developer? You should’ve learned Git yesterday. by Brandon Morelli, creator of CodeBurst.io').

## Šta ću ja da doprinesem?

![Kartica saradnika](/readme-only/card.PNG 'Kartica saradnika')

Vi ćete doprineti projektu karticom kao što je ova [stranica projekta](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project'). Uključiće vaše ime, vaš tviter profil i veze do korisnih resursa za veb programere koje preporučujete.

Napravićete kopiju šablona kartice unutar index.html fajla i prilagoditi je sopstvenim informacijama.

## Index brzog pristupa

| <ul><li>[Uvod](#uvod)</li><li>[Šta ću da doprinesem?](#šta-cu-da-doprinesem)</li><li>[Nameštanje](#nameštanje)</li><li>[Doprinsi &rightarrow;](#doprinesi)</li><li>[Sledeći koraci](#sledeći-koraci)</li><li>[Priznanja](#priznanja)</li></ul> | Doprinesi: <ul><li>[Korak 1: Napravite račvanje (fork) repozitorijuma](#korak-1-račvaj-ovaj-repozitorijum)</li><li>[Korak 2: Kloniraj repozitorijum](#korak-2-kloniraj-repozitorijum)</li><li>[Korak 3: Napravi novu granu](#korak-3-napravi-novu-granu)</li><li>[Korak 4: Otvori index.html fajl](#korak-4-otvori-indexhtml-fajl)</li><li>[Korak 5: Kopiraj šablon kartice](#korak-5-kopiraj-šablon-kartice)</li><li>[Korak 6: Primeni svoje promene](#korak-6-primeni-svoje-promene)</li><li>[Korak 7: Potvrdi svoj promene](#step-7-potvrdi-svoje-promene)</li><li>[Korak 8: Pošalji izmene na GitHub](#korak-8-pošalji-svoje-izmene-na-github)</li><li>[Korak 9: Pošalji izmene na reviziju](#korak-9-pošalji-izmene-na-reviziju)</li><li>[Korak 10: Proslavi!](#korak-10-proslavi)</li></ul> |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |


## Podešavanje! :)

Prvo hajde sve da podesimo za posao!

1. Ulogujte se na svoj GitHub nalog. Ako još uvek nemate nalog [pridruži se GitHub'u](https://github.com/join). Preporučujem da pogledate [GitHub Hello World tutorial](https://guides.github.com/activities/hello-world/) pre nego što nastavite.
1. Skinite [GitHub Desktop aplikaciju](https://desktop.github.com/).
   - Alternativni ako Vam je prijatnije da koristite Git na komadnoj liniji možete i tako (ovdje su [prvi-doprinosi](https://github.com/Syknapse/first-contributions), sličan projekat u kojem možete videti neophodne komande). ILI
   - Ako koristie [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website') dolazi sa integrisanim Gitom i omogućava Vam da uradite ono što nam je potrebno direktno iz editora.
   - Međutim najjednostavniji i najlakši način da pratite ovaj tutorijal je korišćenhe GitHub Desktop aplikacije.

Sada kada ste sve podesili, hajde da nastavimo sa poslom doprinosa projektu.

---

---

## Doprinesi

Postanite saradnik otvorenog koda u 10 jednostavnih koraka.

_Procenjeno vreme: Manje od 30 minuta_.

### Korak 1: Račvaj (fork) ovaj repozitorijum

- Ovde je cilj da napravite kopiju ovog projekta i postavite je na svoj nalog.
- Repozitorijum (repo) je način na koji se projekat naziva na GitHub-u, a fork je njegova kopija.
- Uverite se da ste na [glavnoj stranici](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') of this repo.

| <ul><li>Kliknite na _Fork_ dugme</li></ul> | ![Fork](/readme-only/fork.png "klikni na 'Fork'") |
| :----------------------------------------- | ------------------------------------------------: |


- Sada imate kompletnu kopiju projekta na svom nalogu.

---

### Korak 2: Kloniraj repozitorijum

- Sada želimo da napravimo lokalnu kopiju projekta. To je kopija sačuvana na Vašoj mašini.
- Otvorite GitHub desktop aplikaciju. U aplikaciji :

| <ul><li>Klikni na _File_ potom _Clone repository_</li></ul> | ![Clone](/readme-only/clone.PNG 'klikni clone repository') |
| :---------------------------------------------------------- | ---------------------------------------------------------: |


| <ul><li>Videćete listu svojih projekata i forkova na GitHub-u.</li><li>Izaberite `<vaše-github-username>/Contribute-To-This-Project`.</li><li>Klikni _Clone_</li></ul> | ![Kloniraj projekat](/readme-only/clone-project.PNG 'klikni na <your-github-username>/Contribute-To-This-Project') |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------: |
| <ul><li>Izračvan projekat će imati simbol viljuške sa leve strane.</li><li>Vaše račvanje će imati vaše sopstveno GitHub korisničko ime.</li></ul>                      | ![vaše račvanje](/readme-only/clone-your-fork.PNG 'vaše račvanje će izgledati ovako, sa vašim korisničkim imenom') |

- Ovo će potrajati trenutak dok se projekat ne kopira na vaš hard disk. Preporučujem Vam da zadržite podrazumevanu putanju koja je obično `..\Documents\GitHub`.
- Sada imate lokalnu kopiju projekta.

---

### Korak 3: Napravite novu granu

- Kada se repo klonira i otvorite ga na GitHub radnoj površini, vreme je da napravite novu granu.
- Grana je način da Vaše izmene držite odvojeno od glavnog dela projekta pod nazivom `Master`. Na primer, ako stvari krenu naopako i niste zadovoljni svojim izmenama, možete jednostavno da izbrišete granu i to neće uticati na glavni projekat.

| <ul><li>Kliknite na _Current branch_</li><li>Potom kliknite na _New_</li></ul> | ![Create branch](/readme-only/branch-new.PNG "Klikni na 'Branch', potom 'New'") |
| :----------------------------------------------------------------------------- | ------------------------------------------------------------------------------: |


| <ul><li>Dajte grani ime</li><li>Kliknite `Create branch`</li></ul> | ![Naziv grane](/readme-only/branch-name.PNG 'Dajte naziv grani') |
| :----------------------------------------------------------------- | ---------------------------------------------------------------: |


- Možete nazvati granu kako god želite, ali pošto je ovo grana za dodavanje kartice sa vašim imenom u projekat, nazvati je `your-name-card` je dobra praksa jer nameru ove grane održava jasnom.

| <ul><li>Objavite Vašu granu na Github'u</li></ul> | ![Ime grane](/readme-only/branch-publish.PNG 'Kliknite na Objavi da biste novu granu poslali u vaš udaljeni repo na GitHub-u') |
| :------------------------------------------------ | -----------------------------------------------------------------------------------------------------------------------------: |


- Sada ste kreirali novu granu odvojenu od mastera.
- Za sledeće korake proverite da li radite na ovoj grani. Videćete ime grane na kojoj se nalazite u gornjem centru GitHub desktop aplikacije gde piše _Current branch_.

**NEMOJTE da radite na `master` grani**

---

### Korak 4: Otvori index.html fajl

- Sada moramo da otvorimo datoteku koju ćemo urediti pomoću Vašeg omiljenog kod editora.
- Pronađite folder projekta na računaru. Ako ste zadržali podrazumevano, ovo bi trebalo da bude nešto slično `your-computer > Documents > GitHub > Contribute-To-This-Project`
- `index.html` fajl je direktno u `Contribute-To-This-Project` folderu.

| <ul><li>Otvorite kod editor (Sublime, VS Code, Atom..etc) i otvorite fajl `Open file` komandom i locirajte index.html fajl u glavnom direktorijumu projekta.</li><li>Alternativno, možete locirati datoteku na hard disku, kliknuti desnim tasterom miša i otvoriti je pomoću uređivača</li></ul> | ![Otvori index fajl](/readme-only/index-open.PNG 'Otvori index.html u svom text editoru') |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------: |


- Sada imate otvorenu datoteku koju ćete uređivati u editoru i spremni ste da počnete da unosite izmene u nju.

---

### Korak 5: Kopirajte šablon kartice

- Napravićemo kopiju šablona kartice da bismo počeli da radimo na njemu

| <ul><li>Na vrhu html fajla, ispod `<head>` i `<header>` sekcije naći ćete odeljak označen `== TEMPLATE ==`</li><li>Kopirajte sve unutar crvenog kvadrata na slici, iz `Contributor card START` komentara do `Contributor card END` komentara</li></ul> |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Kopirajte šablon kartice](/readme-only/card-copy.PNG 'Kopirajte šablon kartice')                                                                                                                                                                     |

| <ul><li>Zalepite celu stvar direktno ispod komentara koji na to ukazuje</li><li>Uverite se da postoji jedna linija razmaka između početka i kraja poslednje kartice. Dobra je praksa da naš kod bude što jasniji</li><li>Nikada ne koristite lintere ili formatere stilova. Projekat ima lepšu postavku</li></ul> |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Nalepite šablon kartice](/readme-only/card-paste.PNG 'Zalepite ispod naznačene linije')                                                                                                                                                                                                                         |

- Ovo je sada **vaša** kartica koju možete prilagoditi i urediti.

---

### Korak 6: Primenite promene

- Sada ćemo početi da uređujemo html, menjajući prilagodljiva polja na našoj kartici.

| <ul><li>Yamenite 'Name' sa Vašim imenom</li><li>Poruka: Nemojte menjati `class="name"`</li></ul> | ![Promeni ime](/readme-only/change-name.PNG 'Ukucaj svoje ime') |
| :----------------------------------------------------------------------------------------------- | --------------------------------------------------------------: |


| <ul><li>Unesite URL svog Tvitter naloga `href="Insert URL here"`</li><li>Unesite svoju oznaku u polje za tekst</li></ul>     |
| :--------------------------------------------------------------------------------------------------------------------------- |
| ![Promeni kontakt](/readme-only/change-contact.PNG 'Umetnite vezu do svog Tvitter naloga i otkucajte svoje tviter username') |

- Ako više volite da koristite kontakt koji nije Tviter, moraćete da zamenite tviter ikonicu`<i class="fa fa-x-twitter"></i>` tako što ćete da odete na [Font Awesome Icons](http://fontawesome.io/icons/) pronađete odgovarajucu ikonicu i zamenite samo `fa-x-twitter` deo sa novom ikonicom `fa-facebook` fna primer. Potom pratite iste korake iznad.

| <ul><li>Recite nam nešto o sebi</li><li>Neka bude kratko i slatko. Razmislite o tome više kao na tvit nego na post na blogu</li></ul> | ![Promeni o sebi](/readme-only/change-about.PNG 'Napiši rečenicu o sebi') |
| :------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------: |


| <ul><li>Podelite sa zajednicom 3 veze do resursa koji su korisni za razvoj veba</li><li>Ovo može biti bilo šta, video, razgovor, podkast, članak, referenca ili alat</li><li>Ako ste početnik, nemojte da Vas ovo plaši, podelite sve što znate čak i ako mislite da je osnovno. Iznenadićete se koliko će ljudi imati koristi</li></ul> |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![izmeni resurse](/readme-only/change-resources.PNG 'Umetnite vezu, napišite kratak opis i otkucajte naziv resursa')                                                                                                                                                                                                                     |
| <ul><li>Link: Umetnite link `href="here"` zamenite `#`</li><li>Title: Napišite kratak opis `title="here"`</li><li>Name: Upišite naziv resursa u tekstualno polje `>ovde</a>`</li></ul>                                                                                                                                                   |

- Uverite se da ste **sačuvali sve promene**.
- **Testirajte svoje promene**. OVO JE VAŽNO! Otvorite html datoteku u svom pretraživaču (na primer dvostrukim klikom na nju) i pogledajte kako će vaša kartica izgledati na sajtu. Uverite se da cela stranica i dalje izgleda isto i da ništa nije pokvareno. Kliknite na svoje veze i uverite se da rade. Otvorite konzolu (Ctrl + Shift + J (Windows / Linux) ili Cmd + Opt + J (Mac)) i proverite da nema poruka o grešci.
- Odlično, završili ste sa uređivanjem koda! Sledeći koraci će poslati vaše izmene na GitHub, a zatim ih poslati da se spoje sa glavnim projektom.

---

### Korak 7: Potvrdite svoje promene

- Vratite se na GitHub desktop aplikaciju.
- Vaše promene će biti automatski dodate u oblast za pripremu.
- To znači da je Git zabeležio sve **sačuvane** promene.
- To možete videti u aplikaciji. Sve što ste dodali u datoteku biće zeleno, a brisanja će biti prikazana crvenom bojom.

| <ul><li>Sledeći korak se zove _Commit_</li><li>Ugrubo ovo znači "potvrdi promene"</li></ul> | ![Komituj promene](/readme-only/commit.PNG 'Promene koje ste dodali trebalo bi da se pojave u zelenoj boji na desnoj strani GitHub desktop aplikacije. Dugme za komitovanje se nalazi u donjem levom uglu') |
| :------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>Tako bi trebalo da izgleda zaglavlje vašeg GitHub desktopa</li><li>Obratite pažnju na simbol račvanja pored naziva projekta u `Current repository`</li><li>Vaša `Current branch` imaće ime koje ste mu dali u koraku 3</li></ul> |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Komituj promene](/readme-only/commit-header.PNG 'Promene koje ste dodali trebalo bi da se pojave u zelenoj boji na desnoj strani GitHub desktop aplikacije. Dugme za urezivanje se nalazi u donjem levom uglu')                        |

| <ul><li>Da biste _Commit_ morate popuniti _Summary_ polje</li><li>Ovo je poruka potvrđivanja promene koja objašnjava šta ste promenili</li><li>U ovom slučaju "Add my card information" bi bila logična poruka</li><li>Opciono možete dodati i detaljniji opis _Description_</li><li>Kliknite _Commit_ dugme. Vaše dugme će imati poruku `Commit to "your-branch-name"`</li></ul> | ![Napiši poruku komitovanja i komituj](readme-only/commit-message.PNG "Napiši kratku poruku komitovanja u 'summary' polju, i klikni 'commit'") |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------: |


---

### Korak 8: Pošalji svoje promene na GitHub

- Vaše promene su sada sačuvane ili unete. Ali oni se čuvaju samo lokalno, to jest na vašem računaru.
- Sinhronizacija lokalnih promena sa vašim repozitorijumom na Github-u se zove _Push_. Vi „gurate“ promene iz vašeg lokalnog repozitorijuma na repozitorijum na Github-u.

| <ul><li>Kliknite _Push_ dugme</li></ul> | ![Pušuj na GitHub](/readme-only/push.PNG "Pošalji svoje promene na GitHub, klikni na 'Push' dugme") |
| :-------------------------------------- | --------------------------------------------------------------------------------------------------: |


- Posle nekoliko sekundi operacija je završena i sada imate potpuno istu kopiju ove grane na vašoj mašini kao i na GitHub-u.

---

### Korak 9: Pošalji izmene na reviziju (Pull Request)

- Ovo je trenutak koji ste čekali; podnošenje _Pull Request_ (PR).
- Do sada je sav posao koji ste uradili bio na granici projekta, koji se, kako se sećate, nalazi na vašem nalogu GitHub-a.
- Sada je vreme da svoje izmene pošaljete glavnom projektu da se spoje sa njim.
- Ovo se zove [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help') jer tražite od originalnog održavaoca projekta da "uvuče" vaše izmene u svoj projekat.
- Idite na glavnu stranicu **vašeg račvanja** na GitHub'u (imaće ikonicu račvanja i vaše korisničko ime na vrhu).
- Pri vrhu repo-a videćete istaknutu poruku zahteva za povlačenje sa zelenim dugmetom. (Pull request)

| <ul><li>Kliknite na `Compare and pull request`</li></ul> | ![Submit a Pull Request](/readme-only/pull-request.PNG 'Ovo se obično nalazi na vrhu stranice, ispod opisa i iznad projektnih datoteka i fascikli') |
| :------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>Ovako `Open a pull request` stranica izgleda.</li><li>SETITE SE _vi pokušavate da spojite Vašu granu sa originalnim projektom, a ne sa `Master` granom na vašem račvanju_.</li><li>Slika ispod daje vam ideju kako bi zaglavlje vašeg zahteva za povlačenje trebalo da izgleda</li><li>a levoj strani je originalni projekat, a zatim glavna grana. Na desnoj strani je vaše račvanje i grana koju ste kreirali.</li></ul> |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'Zahtevate da spojite svoju granu sa vaše vilice u glavnu granu originalnog projekta')                                                                                                                                                                                                                                                                               |

| <ul><li>Kreirajte pull request:</li><li>Napišite naslov</li><li>Dodajte opcionalne informacije i opis</li><li>Kliknite `Create pull request`</li></ul> | ![Submit a Pull Request](/readme-only/pull-request-open.PNG 'Kliknite yeleno dugme. Nemojte se plašiti!') |
| :----------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------: |


- Nemojte da vas uznemiravaju sve opcije. Za sada treba da uradite samo ova tri koraka.
- Ostavi opciju `Allow edits from maintainers` obeleženom.
- Sada, _Pull Request_ će biti poslat održavaocu projekta. Čim bude pregledan i prihvaćen, vaše promene će se pojaviti na [veb stranici projekta](https://syknapse.github.io/Contribute-To-This-Project 'Contribute To This Project web page').

---

### Korak 10: Proslavite!!

To je to. Uspeli ste! Sada ste doprineli otvorenom kodu na GitHub-u.

Dodali ste kod na živu veb stranicu: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Vaše promene **neće biti vidljive odmah**; prvo se moraju pregledati, prihvatiti i spojiti sa master granom što odobrava nosilac projekta. Kada se spoje, vaša kartica treba da bude vidljiva i aktivna na stranici.

Veoma je normalno da recenzent traži izmene u Pull Request-u. Smatrajte to dobrom praksom ako Vam se to dogodi. Pratite komentare i tražene izmene. Jednom kada izvršite tražene izmene (povratak u svoju granu) sve što treba da uradite je da izvršite i pogurate svoje promene. PR će se automatski ažurirati novim izmenama.

Obećavam da ću pokušati da pregledam i spojim što je pre moguće, ali ovo radim u slobodno vreme, tako da je kašnjenje od nekoliko dana neizbežno.

---

---

## Sledeci koraci

- Nakon nekog vremena proverite da li imate spojeni zahtev za povlačenje.
- Trebalo bi da dobijete mejl u od GitHub-a kada vaše promene budu odobrene ili ako se zahtevaju dodatne promene. A kada se PR konačno spoji sa master granom, vaša kartica je dodata.
- Ako smatrate da je ovaj projekat **koristan**, dajte mu :star: zvezda :star: na vrhu stranice i **Tvitujte** o njemu da biste pomogli u širenju reči [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project')
- Možete me **pratiti** i ostati u kontaktu na [Twitter](https://twitter.com/Syknapse '@Syknapse') or [using any of these other options](https://syknapse.github.io/Syk-Houdeib/#contact 'My contact section | Portfolio')
- Ovo je projekat otvorenog koda, tako da osim doprinosa Vašoj kartici, dobrodošli ste da pomognete u ispravljanju grešaka, poboljšanjima ili novim funkcijama. Otvorite [issue](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') ili pošaljite novu pull zahtev [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help')
- Da biste poboljšali našu zajednicu, pogledajte Github [Diskusije](https://github.com/Syknapse/Contribute-To-This-Project/discussions) tab lociran pored Pull Requests. Ova oblast je mesto da se predstavite, uđete u dublje diskusije o otvorenom kodu i komunicirate sa održavaocima projekta. Hoćete li nam pomoći da izgradimo ovu funkciju i poboljšamo našu zajednicu? -**Hvala što ste doprineli ovom projektu**. Sada možete nastaviti i pokušati da doprinesete drugim projektima; potražite ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) oznaku za opcije doprinosa prilagođene početnicima.
- Takođe tražim saradnike da mi pomognu u pregledu i spajanju PR-a. Ako želite da dobijete napredniju Git praksu, pošaljite mi DM na Tvitter-u i pročitajte [maintainer's guide](maintainer_guide.md).

## Priznanja

Na ovaj projekat veliki uticaj je imao [Roshan Jossey's](https://github.com/Roshanjossey) odlični [first-contributions](https://github.com/Roshanjossey/first-contributions) projekat sa sjajnim tutorijalom.

Takođe je posebno inspirisano velikom zajednicom u okolini [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) The Google Challenge Scholarship: Front-End Web Dev, class of 2017 Europe.

## Licenca

[MIT License](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/LICENSE)

[Vrati se na početak &uparrow;](#uvod)
