# [Contribute To This Project](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> Logo Created with :sparkling_heart: By [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Объявление:**
>
> Хотели бы вы стать сопровождающим этого проекта и помогать поддерживать его в рабочем состоянии? Если вам интересно, прочтите [руководство по сопровождению](/maintainer_guide.md ) и пришлите мне сообщение в [Твиттере](https://twitter.com/Syknapse).

---

### Индекс быстрого доступа

#### Оглавление

- [Объявления](#объявление)
- [Введение](#введение)
- [Для кого это?](#для-кого-это)
- [Зачем мне это делать?](#зачем-мне-это-делать)
- [Какой вклад я собираюсь внести?](#какой-вклад-я-собираюсь-внести)
- [Переводы](#переводы)
- [Настройка](#настройка)
- [Следующие шаги](#следующие-шаги)
- [Благодарности](#благодарности)

#### Steps

- [Внесение вклада](#внесение-вклада)
- [Шаг 1: Форкните репозиторий](#шаг-1-форкните-этот-репозиторий)
- [Шаг 2: Клонируйте репозиторий](#шаг-2-клонируйте-репозиторий)
- [Шаг 3: Создайте новую ветку](#шаг-3-создайте-новую-ветку)
- [Шаг 4: Откройте index.html](#шаг-4-откройте-indexhtml)
- [Шаг 5: Скопируйте шаблон карточки](#шаг-5-скопируйте-шаблон-карточки)
- [Шаг 6: Примените ваши изменения](#шаг-6-примените-ваши-изменения)
- [Шаг 7: Закоммитьте свои изменения](#шаг-7-закоммитьте-свои-изменения)
- [Шаг 8: Отправьте свои изменения на GitHub](#шаг-8-отправьте-свои-изменения-на-github)
- [Шаг 9: Отправьте PR (Pull Request)](#шаг-9-отправьте-pr-pull-request)
- [Шаг 10: Отпразднуйте](#шаг-10-отпразднуйте)

---

## Введение

Это руководство, которое поможет начинающим участникам принять участие в простом и понятном проекте.

### Цели

- Внесите свой вклад в проект с открытым исходным кодом.
- Станьте более продвинутыми в использовании GitHub.

### Для кого это?

- Это для абсолютных новичков. Если вы знаете, как написать и отредактировать тег привязки `<a href="" target=""></a>`, то вы сможете это сделать.
- Это также для тех, у кого немного больше опыта, но кто хочет внести свой первый вклад с открытым исходным кодом или получить больше вкладов для получения большего опыта и уверенности.

### Зачем мне это делать?

Любой веб-разработчик, начинающий или опытный, должен уметь контролировать версии Git, GitHub - самый популярный сервис, которым пользуются все. Это также сердце сообщества с открытым исходным кодом. Освоение GitHub - это важный навык. Внесение вклада в проект повышает вашу уверенность в себе и дает вам возможность показать что-то в своем профиле на GitHub.<br>

Если вы новый разработчик и вам интересно, нужно ли вам изучать Git и GitHub, то вот ответ: [Вы должны были изучить Git вчера](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'Новый разработчик? Тебе следовало бы выучить Git вчера. автор: Брэндон Морелли, создатель CodeBurst.io ').

### Какой вклад я собираюсь внести?

![Карточка участника](/readme-only/card.PNG 'Карточка участника')

Вы собираетесь разместить на этой [веб-странице проекта](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project') карточку, подобную этой. Она будет включать ваше имя, ваш Twitter, краткое описание и 3 ссылки на полезные ресурсы для веб-разработчиков, которые вы рекомендуете.

Вы сделаете копию шаблона открытки внутри HTML-файла и настроите ее с помощью собственной информации.

---

### Переводы

Это руководство также доступно на [других языках](/translations/README.md)

> Приветствуются переводы проектной документации. Прочтите [`Руководство по переводу`](/translations/README.md) чтобы внести свой вклад.

---

### Настройка

Примечание. Это руководство основано на GitHub для ПК. [Если вам удобно работать с терминалом, перейдите к этому руководству (Нажмите здесь)](/terminal_tutorial.md)

Сначала давайте настроим всё для выполнения работы

1. Войдите в свою учетную запись GitHub. Если у вас еще нет учетной записи, то [присоединитесь к GitHub](https://github.com/join). Перед тем как продолжить, я рекомендую вам выполнить [учебник GitHub Hello World](https://guides.github.com/activities/hello-world/).
2. Скачайте [приложение GitHub Desktop](https://desktop.github.com/).
   - В качестве альтернативы, если вам удобно использовать Git в командной строке, вы можете сделать это [Вот ссылка на учебник CLI](/terminal-tutorial.md).
   - Если вы используете [VS Code](https://code.visualstudio.com/ 'Сайт Visual Studio Code'), он поставляется с интегрированным Git'ом и позволяет делать то, что нам нужно, прямо из редактора.
   - Однако самый простой и легкий способ следовать этому руководству - использовать GitHub Desktop.

> Теперь, когда вы все настроили, давайте приступим к работе по внесению вклада в проект.<br><br>

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

### Внесение вклада

Станьте участником проекта с открытым исходным кодом за 10 простых шагов.

_Примерное время: Менее 30 минут_.

#### Шаг 1: Форкните этот репозиторий

- Цель состоит в том, чтобы сделать копию этого проекта и поместить ее в свой аккаунт.
- Репозиторий - это то, как проект называется на GitHub, а форк - это его копия.
- Убедитесь, что вы находитесь на [главной странице](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') этого репозитория.

| ![Fork](/readme-only/fork.png "Кликните на кнопку 'Fork'") |
| :-------------------------------------------------: |
|           **Кликните на кнопку _Fork_**            |

- Теперь у вас есть полная копия на проекта на вашем аккаунте

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 2: Клонируйте репозиторий

- Теперь мы хотим создать локальную копию проекта. То есть копию, сохраненную на вашей собственной машине.
- Откройте приложение GitHub для рабочего стола. В этом приложении:

| ![Clone](/readme-only/clone.PNG 'Нажмите clone repository') |
| :----------------------------------------------------------: |
|     **Кликните на _File_ потом на _Clone repository_**      |

- Вы увидите список ваших проектов и форков на GitHub.
- Выберите `<Ваш-ник-на-GitHub>/Contribute-To-This-Project`.
- Нажмите _Clone_

| ![Clone project](/readme-only/clone-project.PNG 'Нажмите на =Ваше-ім\'я-користувача-на-github=/Contribute-To-This-Project') |
| :----------------------------------------------------------------------------------------------------------: |

| :arrow_right_hook: Проект, который вы форкнули, будет иметь значок вилки слева. У вашего форка будет ваш ник на GitHub. | ![ваш форк](/readme-only/clone-your-fork.PNG 'ваш форк будет выглядеть так, с вашим іменем пользователя') |
| :------------------------------------------------------------------------------------------------------------------ | :----------------------------------------------------------------------------------------------------: |

- Это займет некоторое время, пока проект будет копироваться на ваш жесткий диск. Я рекомендую сохранить путь по умолчанию, который обычно `..\Documents\GitHub`.
- Теперь у вас есть локальная копия проекта.

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 3: Создайте новую ветку

- После клонирования репозитория и открытия его на рабочем столе GitHub пришло время создать новую ветвь.
- Ответвление - это способ сохранить ваши изменения отдельно от основной части проекта под названием `Master`. Например, если что-то пойдет не так и вы будете недовольны своими изменениями, вы можете просто удалить ветку, и основной проект не пострадает.

| :arrow_right_hook: Кликните на _`Current branch`_, затем кликните на _`New`_ | ![Создать ветку](/readme-only/branch-new.PNG "Нажмите на 'Branch', потом 'New'") |
| :---------------------------------------------------------------------------- | :-----------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Дайте своей ветке имя, а потом нажмите на `Create branch`** |                           ![Name branch](/readme-only/branch-name.PNG 'Дайте своей ветке имя')                            |
| :arrow_right_hook: **Выложите свою ветку на GitHub**                      | ![Name branch](/readme-only/branch-publish.PNG 'Нажмите опубликовать, чтобы отправить новую ветку в удаленное хранилище на GitHub') |

- Вы можете назвать его как угодно, но поскольку это ответвление для добавления в проект карточки с вашим именем, называть его `your-name-card` будет хорошей практикой, так как это сохраняет ясность намерений этого ответвления.
- Теперь вы создали новую ветвь, отдельную от основной.
- Для следующих шагов убедитесь, что вы работаете в этой ветке. Вы увидите название ветки, в которой вы находитесь, в верхней центральной части приложения GitHub для рабочего стола, где написано _Current branch_.

- **НЕ РАБОТАЙТЕ В ВЕТКЕ 'master'**

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 4: Откройте index.html

- Теперь нам нужно открыть файл, который мы собираемся редактировать, с помощью вашего любимого редактора кода.
- Найдите папку проекта на вашем компьютере. Если вы сохранили папку по умолчанию, она должна быть примерно такой: `Ваш компьютер > Документы > GitHub > Contribute-To-This-Project`.
- Файл `index.html` находится непосредственно в папке `Contribute-To-This-Project`.
- Откройте ваш редактор кода (Sublime, VS Code, Atom..), используйте команду `Open file` и найдите файл index.html в главной директории проекта

| ![Open index file](/readme-only/index-open.PNG 'Откройте index.html в вашем редакторе кода') |
| :------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Также вы можете найти файл на жестком диске, щелкнуть правой кнопкой мыши и открыть его в редакторе** |

- Теперь файл, который вы собираетесь редактировать, открыт в вашем редакторе, и вы готовы начать вносить в него изменения.

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 5: Скопируйте шаблон карточки</h5>

- Мы сделаем копию шаблона карточки, чтобы начать работу над ней
- В верхней части html-файла, под разделами `<head>` и `<header>`, вы найдете раздел `== TEMPLATE ==`.
- Скопируйте все, что находится в пределах красного квадрата на изображении, от комментария `Contributor card START` до комментария `Contributor card END`.

| ![Copy card template](/readme-only/card-copy.PNG 'Скопируйте шаблон карточки') |
| :----------------------------------------------------------------------------: |

- Вставьте все это непосредственно под указывающим на это комментарием
- Убедитесь, что между началом вашей карточки и концом последней карточки есть пробел в одну строку. Рекомендуется, чтобы наш код был как можно более понятным
- Никогда не используйте линтеры или форматтеры стилей. Проект имеет настройку Prettier

| ![Paste card template](/readme-only/card-paste.PNG 'Вставьте ниже указанной строки') |
| :----------------------------------------------------------------------------------: |

- Теперь это **ваша** карточка, которую вы можете настраивать и редактировать.

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 6: Примените ваши изменения

- Теперь мы начнем редактировать html, изменяя настраиваемые поля в нашей карточке.

| :arrow_right_hook: Замените `Name` на ваше имя | ![Измените имя](/readme-only/change-name.PNG 'Введите свое имя') |
| :--------------------------------------------- | :--------------------------------------------------------------: |

- **Примечание: не изменяйте `class="name"`**

| :arrow_right_hook: Вставьте URL-адрес вашего аккаунта в Twitter `href="Insert URL here"`, введите свое имя в текстовое поле | ![Change contact](/readme-only/change-contact.PNG 'Insert a link to your Twitter account and type your handle') |
| :-------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------------------------------------: |

- Если вы предпочитаете использовать контакты, отличные от Twitter, вам нужно заменить значок twitter `<i class="fa fa-x-twitter"></i>` на [Font Awesome Icons](http://fontawesome.io/icons/), найдя нужный значок и заменив только часть `fa-x-twitter` на новый значок, например, `fa-facebook`. Затем выполните те же шаги, что описаны выше.

| ![Change about](/readme-only/change-about.PNG 'Напишите предложение о себе') |
| :------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Расскажите нам что-нибудь о себе. Будьте краткими и милыми. Думайте об этом как о твите, а не как о записи в блоге.** |
| ![Change resources](/readme-only/change-resources.PNG 'Вставьте ссылку, напишите краткое описание и введите название ресурса')   |
| :arrow_right_hook: **Поделитесь с сообществом 3 ссылками на ресурсы, полезные для веб-разработки. Это может быть что угодно: видео, беседа, подкаст, статья, ссылка или инструмент. Если вы новичок, не пугайтесь этого, поделитесь всем, что вы знаете, даже если вам кажется, что это элементарно. Вы удивитесь, как много людей получат пользу.** |

- **Ссылка:** вставьте ссылку `href="сюда"` заменяя `#`. Пожалуйста, воздержитесь от использования сокращателей URL-адресов или URL-адресов, не относящихся к публикуемому сайту!
- **Заголовок:** Напишите краткое описание `title="здесь"`.
- **Имя:** Напишите имя ресурса в текстовом поле `>здесь</a>`.
- Убедитесь, что вы **сохранили все изменения**.
- **Протестируйте свои изменения**. ЭТО ОЧЕНЬ ВАЖНО! Откройте html-файл в браузере (например, дважды щелкнув по нему) и посмотрите, как будет выглядеть ваша карточка на сайте. Убедитесь, что вся страница выглядит одинаково и ничего не нарушено. Нажмите на свои ссылки и убедитесь, что они работают. Откройте консоль (Ctrl + Shift + J (Windows / Linux) или Cmd + Opt + J (Mac)) и проверьте, нет ли сообщений об ошибках.
- Отлично, вы закончили редактирование кода! Следующие шаги отправят ваши изменения на GitHub, а затем отправят их для слияния с основным проектом.

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 7: Закоммитьте свои изменения

- Вернитесь к настольному приложению GitHub.
- Ваши изменения будут автоматически добавлены в область хранения.
- Это означает, что Git записал все **сохраненные** изменения.
- Вы можете увидеть это в приложении. Все, что вы добавили в файл, будет выделено зеленым цветом, а удаление - красным.

|                                                                                                  ![Commit changes](/readme-only/commit.PNG "Добавленные вами изменения должны появиться зеленым цветом справа в программе GitHub. Кнопка Commit находится внизу слева")                                                                                                  |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: Следующий шаг называется _`Commit`_. Это приблизительно означает "принять изменения" |
|                                                                                              ![Commit changes](/readme-only/commit-header.PNG "Добавленные вами изменения должны появиться зеленым цветом справа в программе GitHub. Кнопка Commit находится внизу слева")                                                                                               |
|                                                                            :arrow_right_hook: **Вот как должен выглядеть заголовок вашего рабочего стола GitHub. Обратите внимание на символ вилки рядом с именем проекта в разделе `Current repository`, Ваша `Current Branch` будет иметь имя, которое вы дали ей в шаге 3**                                                                            |
|                                                                                                                  ![Write commit message and commit](/readme-only/commit-message.PNG "Напишіть коротке повідомлення про коміт в полі 'summary', і натисніть кнопку 'commit'")                                                                                                                  |
| :arrow_right_hook: **Чтобы _Закоммитить_ вам нужно заполнить поле _Summary_ . Это сообщение, объясняющее, что вы изменили. В этом случае `"Добавить информацию о моей карточке"` было бы разумным сообщением. По желанию вы можете добавить более подробное описание в поле _`Description`_. Нажмите кнопку _`Commit`_. На кнопке будет написано что-то вроде `Commit to "your-branch-name"`** |

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 8: Отправьте свои изменения на GitHub

- Теперь ваши изменения сохранены или зафиксированы. Но они сохранены только локально, то есть на вашем компьютере.
- Синхронизация локальных изменений с вашим репозиторием на GitHub называется _Push_. Вы "проталкиваете" изменения из вашего локального репозитория в удаленный репозиторий на GitHub.

| :arrow_right_hook: Нажмите на кнопку _`Push`_ | ![Push to GitHub](/readme-only/push.PNG "Отправьте свои изменения на GitHub, нажмите на кнопку 'Push'") |
| :------------------------------------------- | :-----------------------------------------------------------------------------------------------: |

- Через несколько секунд операция будет завершена, и теперь у вас есть точно такая же копия этой ветки как на вашей машине, так и на GitHub.

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 9: Отправьте PR (Pull Request)

- Настал момент, которого вы так долго ждали: подача _пулл реквеста_ (PR).
- До сих пор вся проделанная вами работа была связана с форком проекта, который, как вы помните, находится на вашем собственном аккаунте на GitHub.
- Теперь пришло время отправить свои изменения в основной проект для слияния с ним.
- Это называется [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help'), потому что вы просите сопровождающего оригинального проекта "перетянуть" ваши изменения в свой проект.
- Перейдите на главную страницу **вашего форка** на GitHub (вверху будет значок форка и ваше имя пользователя).
- В верхней части репозитория вы увидите выделенное сообщение Pull Request с зеленой кнопкой.

|  ![Submit a Pull Request](/readme-only/pull-request.PNG 'Обычно это находится вверху страницы, под описанием и над файлами и папками проекта')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Нажмите на кнопку `Compare and pull request`**                                                     |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'Вы подаете запрос на объединение вашей ветви с вашего форка в главную ветвь оригинального проекта') |
|                                              :arrow_right_hook: Приблизительно так выглядит страница `Open a pull request`.                                               |

- ПОМНИТЕ, _вы пытаетесь объединить свою ветку с оригинальным проектом, а не с веткой `Master` на вашем форке_.
- Приведенное ниже изображение дает вам представление о том, как должен выглядеть заголовок вашего pull request.
- Слева - исходный проект, за которым следует ветка `Master`. Справа - ваш форк и созданная вами ветка.

|                   ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Нажмите на зеленую кнопку. Не пугайтесь!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Создайте pull request: введите заголовок, добавьте необязательную информацию в описание и нажмите на `Create pull request`** |

- Не пугайтесь множества вариантов. Вам нужно выполнить только эти три шага.
- Оставьте опцию `Allow edits from maintainers` отмеченной.
- Теперь мейнтейнеру проекта будет отправлен запрос _Pull Request_. Как только он будет рассмотрен и принят, ваши изменения появятся на [веб-странице проекта](https://syknapse.github.io/Contribute-To-This-Project 'Contribute To This Project web page').

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

#### Шаг 10: Отпразднуйте

Вот и все. Вы сделали это! Теперь вы внесли свой вклад в открытый исходный код на GitHub.

Вы добавили код на живую веб-страницу: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Ваши изменения **не будут видны сразу**; сначала они должны быть рассмотрены, приняты и объединены сопровождающим проекта. Как только они будут объединены, ваша карточка должна стать видимой и живой на странице.

Это вполне нормально, когда рецензент просит внести изменения в PR. Считайте это хорошей практикой, если это произойдет с вами. Следите за комментариями и запрошенными изменениями. Как только вы внесете запрашиваемые изменения (в свою ветку), все, что вам нужно сделать, это зафиксировать и отправить изменения. PR будет автоматически обновлен новыми изменениями.

Я обещаю, что постараюсь рассмотреть и объединить как можно скорее, но я делаю это в свободное время, поэтому задержка в несколько дней неизбежна.

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

### Следующие шаги

- Вернитесь через некоторое время, чтобы проверить, как прошел ваш объединенный Pull Request.
- Вы должны получить письмо от GitHub, когда ваши изменения будут одобрены, или если будут запрошены дополнительные изменения. И когда PR будет окончательно объединен с мастером и ваша карточка будет добавлена.
- Вы также можете узнать, как внести свой вклад, из этой _бесплатной_ серии: [Как внести свой вклад в проект с открытым исходным кодом на GitHub](https://kcd.im/pull-request)
- Если вы нашли этот проект **полезным**, пожалуйста, поставьте ему :star: звезду :star: вверху страницы и **Tweet** о нем, чтобы помочь распространить информацию [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project').
- Вы можете **следовать за мной** и связаться со мной в [Твиттере](https://twitter.com/Syknapse '@Syknapse') или [используя любой из этих других вариантов](https://syknapse.github.io/Syk-Houdeib/#contact 'Мой раздел контактов | Портфолио').
- Это проект с открытым исходным кодом, поэтому, помимо вклада в свою карту, вы можете помочь исправить ошибки, внести улучшения или новые функции. Откройте [проблему](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') или отправьте новый [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help').
- Чтобы помочь улучшить наше сообщество, загляните на вкладку GitHub [Discussions](https://github.com/Syknapse/Contribute-To-This-Project/discussions), расположенную рядом с Pull Requests. Это место, где можно представиться, углубиться в обсуждение Open Source и пообщаться с мейнтейнерами проекта. Поможете ли вы нам создать эту функцию и улучшить наше сообщество?
- **Спасибо за ваш вклад в этот проект**. Теперь вы можете попробовать внести свой вклад в другие проекты; обратите внимание на метку ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png), чтобы найти варианты вклада, удобные для новичков.
- Я также ищу соавторов, которые могли бы помочь мне в рецензировании и объединении PR. Если вы хотите получить более продвинутую практику работы с Git, пожалуйста, напишите мне DM в Twitter и прочитайте [руководство сопровождающего](/maintainer_guide.md).

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

---

### Благодарности

На этот проект сильно повлияла работа [Рошана Джосси](https://github.com/Roshanjossey) - проект замечательные [первые вклады](https://github.com/Roshanjossey/first-contributions) с его отличным учебником.

Этот проект также особенно вдохновлен большим сообществом вокруг [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) Стипендия Google Challenge: Front-End Web Dev, класс 2017г. в Европе.

### 100 лучших участников

[![GitHub Contributors Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[↑ Вернуться наверх ↑](#индекс-быстрого-доступа)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
