# [Contribua para esse projeto](https://syknapse.github.io/Contribute-To-This-Project/)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project')

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')

## Introdução

Esse é um tutorial para ajudar os contribuidores inicial a participar de um simples e fácil projeto.

### Objetivos

- Fazer uma contribuição para um projeto Open Source.
- Ficar mais confortável usando o GitHub.

### Para quem é isso?

- Isto é para iniciantes absolutos. Se você sabe como escrever e editar uma tag de âncora `<a href="" target=""> </a>`, deve poder fazer isso.
- Isto é para aqueles com um pouco mais de experiência mas que querem fazer a sua primeira contribuição para um Open Source, ou possuir mais contribuições para maior experiência e confiança.

### Por que eu preciso fazer isso?

Qualquer desenvolvedor web, aspirante ou experiente, precisa usar o controle de versão do Git, e o GitHub é o serviço de hospedagem Git mais popular usado por todos. É também o coração da comunidade Open Source. Ficar confortável com o GitHub é uma habilidade essencial. Fazer uma contribuição para um projeto aumenta sua confiança e oferece a você algo para mostrar no seu perfil do GitHub. <br>
Se você é um novo desenvolvedor e está se perguntando se precisa aprender Git e GitHub, aqui está a resposta: [Você deveria ter aprendido Git ontem](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'New Developer? You should’ve learned Git yesterday. by Brandon Morelli, creator of CodeBurst.io').

## Com o que vou contribuir?

![Cartão de Colaborador](/readme-only/card.PNG 'Contributor Card')

Você contribuirá com um cartão como este para esta [página de projetos](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project'). Ele incluirá seu nome, seu endereço no Twitter, uma breve descrição e três links para recursos úteis para os desenvolvedores da web que você recomenda.

Você fará uma cópia do modelo do cartão dentro do arquivo HTML e o personalizará com suas próprias informações.

## Índice de Acesso Rápido

| <ul><li>[Introdução](#introdução)</li><li>[Com o que vou contribuir?](#com-o-que-vou-contribuir)</li><li>[Configurando](#configurando)</li><li>[Contribua &rightarrow;](#contribuindo)</li><li>[Próximos passos](#próximos-passos)</li><li>[Agradecimentos](#Agradecimentos)</li></ul> | Contribuindo: <ul><li>[Passo 1: dê um Fork nesse repositório](#passo-1-de-um-fork-nesse-repositório)</li><li>[Passo 2: Clone o repositório](#passo-2-clone-o-repositório)</li><li>[Passo 3: Cria uma nova Branch](#passo-3-crie-uma-nova-branch)</li><li>[Passo 4: Abra o arquivo index.html](#passo-4-abra-o-arquivo-indexhtml)</li><li>[Passo 5: Copie o modelo do cartão](#passo-5-copie-o-modelo-do-cartão)</li><li>[Passo 6: Aplique suas mudanças](#passo-6-aplique-suas-mudanças)</li><li>[Passo 7: Commit suas mudanças](#passo-7-commit-nas-suas-mudanças)</li><li>[Passo 8: Envie suas alterações para o GitHub](#passo-8-envie-suas-mudanças-ao-github)</li><li>[Passo 9: Submeta a PR](#passo-9-envie-um-pr)</li><li>[Passo 10: Comemore!](#passo-10-comemore)</li></ul> |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |


## Configurando

Primeiro vamos configurar para fazer o trabalho

1. Faça o login na sua conta do GitHub. Se você ainda não tem uma conta então [entre no GitHub](https://github.com/join). Eu recomendo que você faça o [GitHub Hello World tutorial](https://guides.github.com/activities/hello-world/) antes de você continuar.
2. Download [GitHub Desktop](https://desktop.github.com/).
   - Como alternativa, se você estiver confortável usando o Git na linha de comando, faça isso (aqui está [primeiras contribuições](https://github.com/Syknapse/first-contributions), um projeto semelhante que pode servir como um guia para os comandos necessários). OU
   - Se você usa [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website') ele vem com o Git integrado e permite que você faça o que precisamos diretamente do editor.
   - No entanto, a maneira mais simples e fácil de seguir este tutorial é usar o GitHub Desktop.

Agora que você está pronto, vamos continuar com o negócio de contribuir para o projeto.

---

---

## Contribuindo

Torne-se um contribuidor Open Source em 10 passos.

_Tempos estimado: menos de 30 minutos_.

### Passo 1: de um Fork nesse repositório

- O objetivo aqui é fazer uma cópia desse projeto e colocar na sua conta.
- Um repositório (repo) é como o projeto é chamado no GitHub e o Fork é uma cópia dele.
- Garanta que você esteja na [página principal](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') desse repositório.

| <ul><li>Clique no botão _Fork_ </li></ul> | ![Fork](/readme-only/fork.png "click on 'Fork'") |
| :---------------------------------------- | -----------------------------------------------: |


- Agora você tem um cópia complete desse projeto na sua conta.

---

### Passo 2: Clone o repositório

- Agora nós temos que fazer uma cópia local do projeto. Essa é uma cópia salva na sua máquina.
- Abra o Github Desktop. E no seu Aplicativo:

| <ul><li>Clique no _arquivo_ e então _Clone o repositório_</li></ul> | ![Clone](/readme-only/clone.PNG 'click clone repository') |
| :------------------------------------------------------------------ | --------------------------------------------------------: |


| <ul><li>Você verá uma lista dos seus projetos e Forks no GitHub.</li><li>Selecione `<seu-nome-de-usuario>/Contribute-To-This-Project`.</li><li>Clique em _Clone_</li></ul> | ![Clone o projeto](/readme-only/clone-project.PNG 'click on <your-github-username>/Contribute-To-This-Project') |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------------------------------------: |
| <ul><li>Um fork de projeto terá o símbolo de um garfo ao lado.</li><li>Seu Fork terá seu nome de usuário do GitHub.</li></ul>                                              |     ![your fork](/readme-only/clone-your-fork.PNG 'your fork will look like this, with your own user name')     |

- Isso levará um momento enquanto o projeto é copiado para o seu disco rígido. Eu recomendo que você mantenha o caminho padrão que geralmente é `.. \ Documents \ GitHub`.
- Agora você tem uma cópia local do projeto.

---

### Passo 3: Crie uma nova branch

- Depois que o repositório for clonado e você o abrir na área de trabalho do GitHub, é hora de criar um novo ramo.
- Uma ramificação é uma maneira de manter suas alterações separadas da parte principal do projeto chamada `Mestre '. Por exemplo, se as coisas derem errado e você não estiver satisfeito com as alterações, basta excluir a ramificação e o projeto principal não será afetado.

| <ul><li>Clique em _Current branch_</li><li>Em seguida, clique em _New_</li></ul> | ![Crie a branch](/readme-only/branch-new.PNG "Click on 'Branch', then 'New'") |
| :------------------------------------------------------------------------------- | ----------------------------------------------------------------------------: |


| <ul><li>Dê um nome a sua branch</li><li>Clique em `Create branch`</li></ul> | ![Nomeie a branch](/readme-only/branch-name.PNG 'Name your branch') |
| :-------------------------------------------------------------------------- | ------------------------------------------------------------------: |


- Você pode dar o nome que desejar, mas como esse é um ramo para adicionar um cartão com o seu nome ao projeto, chamá-lo de `seu nome do cartão 'é uma boa prática, pois mantém clara a intenção desse ramo.

| <ul><li>Publique sua nova branch no Github</li></ul> | ![Nome da branch](/readme-only/branch-publish.PNG 'Click publish to send the new branch to your remote repo on GitHub') |
| :--------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------: |


- Agora você criou uma nova branch separada da master.
- Para as próximas etapas, verifique se você está trabalhando neste ramo. Você verá o nome da filial em que se encontra, na parte superior central do aplicativo de desktop do GitHub, onde diz _Current branch_.

**Não trabalhe na branch `master`**

---

### Passo 4: Abra o arquivo index.html

- Agora precisamos abrir o arquivo que vamos editar com seu editor de código favorito.
- Encontre a pasta do projeto no seu computador. Se você manteve o padrão, deve ser algo como `seu-computador> Documentos> GitHub> Contribua para este projeto`
- O arquivo `index.html` está diretamente na pasta`Contribute-To-This-Project`.

| <ul><li>Abra seu editor de código (Sublime, VS Code, Atom..etc) e use o comando `Open file` e localize o arquivo index.html do diretório principal do projeto</li><li>Como alternativa, você pode localizar o arquivo no disco rígido, clicar com o botão direito e abrir com o seu editor.</li></ul> | ![Abra o arquivo index](/readme-only/index-open.PNG 'Open index.html in your text editor') |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -----------------------------------------------------------------------------------------: |


- Agora você tem o arquivo que deseja editar aberto no seu editor e está pronto para começar a fazer alterações.

---

### Passo 5: Copie o modelo do cartão

- Faremos uma cópia do modelo do cartão para começar a trabalhar nele

| <ul><li>Role para baixo até o final do arquivo, onde você encontrará a seção `== TEMPLATE ==`</li><li>Copie tudo dentro do quadrado vermelho da imagem, do comentário `Contributor card START` ao comentário `Contributor card END`</li></ul> |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Copy card template](/readme-only/card-copy.PNG 'Copy the card template')                                                                                                                                                                    |

| <ul><li>Cole a coisa toda diretamente acima do comentário indicando</li><li>Verifique se há uma única linha de espaço entre o início do cartão e o último final do cartão. É uma boa prática manter nosso código o mais claro possível </li><li> Verifique se o seu recuo está correto e corresponde ao modelo</li></ul> |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Cole o modelo de cartão](/readme-only/card-paste.PNG 'Paste above the indicated line')                                                                                                                                                                                                                                 |

- Agora esse é seu **cartão** para você personalizar e editar.

---

### Passo 6: Aplique suas mudanças

- Agora começaremos a editar o html, alterando os campos personalizáveis em nosso cartão.

| <ul><li>Substitua 'Name' com seu nome</li><li>Nota: não mude `class="name"`</li></ul> | ![Altere o nome](/readme-only/change-name.PNG 'Type your name') |
| :------------------------------------------------------------------------------------ | --------------------------------------------------------------: |


| <ul><li>Insira o URL da sua conta do Twitter `href="Insert URL here"`</li><li>Digite sua alça no campo de texto</li></ul> |
| :------------------------------------------------------------------------------------------------------------------------ |
| ![Mude o contato](/readme-only/change-contact.PNG 'Insert a link to your Twitter account and type your handle')           |

- Se você preferir usar um contato que não seja o Twitter, será necessário substituir o ícone do twitter `<i class="fa fa-x-twitter"></i>` indo ao [Font Awesome Icons](http://fontawesome.io/icons/) procurando o ícone certo e substituindo apenas a parte `fa-x-twitter` pelo novo ícone como`fa-facebook` por exemplo. Depois siga os mesmos passos acima.

| <ul><li>Conte-nos algo sobre você</li><li>Mantenha isso curto e agradável. Pense nisso mais como um tweet do que uma postagem no blog</li></ul> | ![Alterar sobre você](/readme-only/change-about.PNG 'Write a sentence about you') |
| :---------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------: |


| <ul><li>Compartilhe com a comunidade 3 links para recursos úteis para o desenvolvimento web</li><li>Pode ser qualquer coisa, um vídeo, uma palestra, um podcast, um artigo, uma referência ou uma ferramenta</li><li>Se você é iniciante, não se deixe intimidar por isso, compartilhe o que sabe, mesmo que você ache básico. Você ficará surpreso com quantas pessoas se beneficiarão</li></ul> |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| ![Alterar recurso](/readme-only/change-resources.PNG 'Insert link, write a short description, and type the name of the resource')                                                                                                                                                                                                                                                                 |
| <ul><li>Link: Insira o link `href="here"` substituindo o `#`</li><li>Título: Escreva uma breve descrição `title="here"`</li><li> Nome: escreva o nome do recurso no campo de texto `>here</a>`</li></ul>                                                                                                                                                                                          |

- Garanta que você **salvou todas as suas mudanças**.
- **Teste suas mudanças**. ISSO É IMPORTANTE!Abra o arquivo html no seu navegador (clicando duas vezes nele, por exemplo) e veja como será o seu cartão no site. Veja que a página inteira ainda parece a mesma e nada está quebrado. Clique nos seus links e verifique se eles estão funcionando.Abra o console (Ctrl + Shift + J (Windows / Linux) ou Cmd + Opt + J (Mac)) e verifique se não há mensagens de erro.
- Ótimo, você terminou de editar seu código! As próximas etapas enviarão suas alterações para o GitHub e as enviarão para serem mescladas com o projeto principal.

---

### Passo 7: Commit nas suas mudanças

- Volte para o GitHub Desktop.
- Suas alterações serão adicionadas automaticamente à área de preparação.
- Isso significa que o Git registrou todas as alterações **salvas**.
- Você pode ver isso refletido no aplicativo. Tudo o que você adicionou ao arquivo ficará em verde e as exclusões aparecerão em vermelho.

| <ul><li>O próximo passo é chamado _Commit_</li><li>Isso aproximadamente significa "confirmar as mudanças"</li></ul> | ![Commit suas mudanças](/readme-only/commit.PNG "The changes you've added should appear in green on the right side of GitHub desktop app. The commit button is on the buttom left") |
| :------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>É assim que o cabeçalho da área de trabalho do GitHub deve parecer</li><li>Observe o símbolo de bifurcação ao lado do nome do projeto no repositório atual `Current repository`</li><li>Seu `Current branch` terá o nome que você deu na etapa 3 </li></ul> |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| ![Commit suas mudanças](/readme-only/commit-header.PNG "The changes you've added should appear in green on the right side of GitHub desktop app. The commit button is on the buttom left")                                                                          |

| <ul><li>Para o _Commit_ você deve preencher o campo _Summary_ </li><li>Esta é a mensagem de confirmação explicando o que você mudou</li><li>Nesse caso, "Adicionou as informações do meu cartão" seria uma mensagem razoável</li><li>Opcionalmente, você pode adicionar uma descrição mais detalhada em _Description_</li><li>Clique no botão _Commit_. Seu botão irá dizer algo como `Commit to "your-branch-name"`</li></ul> | ![Escreva a mensagem e dê o Commit](/readme-only/commit-message.PNG "Write a brief commit message in the 'summary' input, and click 'commit'") |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------: |


---

### Passo 8: Envie suas mudanças ao GitHub

- Suas alterações agora estão salvas ou confirmadas. Mas eles são salvos apenas localmente, ou seja, no seu computador.
- A sincronização de alterações locais com seu repositório no Github é chamada de _Push_. Você está "enviando" as alterações do seu repositório local para o repositório remoto no Github.

| <ul><li>Clique no botão _Push_ </li></ul> | ![Envie ao GitHub](/readme-only/push.PNG "Push your changes to GitHub, click on the 'Push' button") |
| :---------------------------------------- | --------------------------------------------------------------------------------------------------: |


- Após alguns segundos, a operação está concluída e agora você tem exatamente a mesma cópia desta ramificação em sua máquina e no GitHub.

---

### Passo 9: Envie um PR

- Este é o momento que você estava esperando; enviando um _Pull Request_ (PR).
- Até agora, todo o trabalho que você fez esteve na bifurcação do projeto, que, como você se lembra, reside em sua própria conta do GitHub.
- Agora é hora de enviar as alterações para o projeto principal a serem mescladas.
- Isso é chamado de [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'Sobre solicitações de recebimento - Ajuda do GitHub') porque você está pedindo ao mantenedor do projeto original para "puxar" suas mudanças em seu projeto.
- Vá para a página principal de **seu fork** no GitHub (ele terá o ícone do fork e seu próprio nome de usuário na parte superior).
- Na parte superior do repositório, você verá uma mensagem destacada de solicitação de recebimento com um botão verde.

| <ul><li>Clique em `Compare and pull request`</li></ul> | ![Envie um Pull Request](/readme-only/pull-request.PNG 'This is usually towards the top of the page, under the description and above the project files and folders') |
| :----------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>Isso é o que uma página `Open a pull request` parece.</li><li>LEMBRE-SE _você está tentando mesclar sua ramificação com o projeto original e não com a ramificação `Master` no seu fork_.</li><li>A imagem abaixo fornece uma idéia de como deve ser o cabeçalho da sua solicitação pull.</li><li>À esquerda está o projeto original, seguido pelo ramo mestre. À direita está o seu Fork e o ramo que você criou.</li></ul> |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Abra um Pull Request](/readme-only/pull-request-branches.PNG 'You are requesting to merge your branch from your fork into the master branch of the original project')                                                                                                                                                                                                                                                              |

| <ul><li>Crie um pull request:</li><li>Escreva um título</li><li>Adicione informações opcionais na descrição</li><li>Clique em `Create pull request`</li></ul> | ![Submeta um Pull Request](/readme-only/pull-request-open.PNG "Click the green button. Don't be scared!") |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------: |


- Não se assuste com todas as opções. Você só precisa executar essas três etapas por enquanto.
- Deixe a opção "Permitir edições dos mantenedores" marcada.
- Agora, um _Pull Request_ será enviado ao mantenedor do projeto. Assim que for revisado e aceito, suas alterações aparecerão na [página da web do projeto](https://syknapse.github.io/Contribute-To-This-Project 'Contribuir para esta página da web do projeto').

---

### Passo 10: Comemore!

É isso aí. Você conseguiu! Você já contribuiu para o código aberto no GitHub.

Você adicionou código a uma página da web ao vivo: [https://syknapse.github.io/Contribute-To-This-ProjectBody((https://syknapse.github.io/Contribute-To-This-Project)

Suas alterações **não serão visíveis imediatamente**; primeiro eles precisam ser revisados, aceitos e mesclados pelo mantenedor do projeto. Depois que eles forem mesclados, seu cartão estará visível e estará na página.

É muito normal que um revisor solicite alterações em um PR. Pense nisso como uma boa prática, se acontecer com você. Fique de olho nos comentários e nas alterações solicitadas. Depois de fazer as alterações solicitadas (de volta ao seu ramo), tudo o que você precisa fazer é confirmar e enviar as alterações. O PR será atualizado automaticamente com as novas alterações.

## Prometo que tentarei revisar e mesclar o mais rápido possível, mas faço isso no meu tempo livre, por isso é inevitável um atraso de alguns dias.

---

## Próximos passos

- Volte em um tempo para verificar sua solicitação de solicitação mesclada.
- Você deve receber um email do GitHub quando suas alterações forem aprovadas ou se alterações adicionais forem solicitadas. E quando o PR for finalmente mesclado ao mestre e seu cartão foi adicionado.
- Se você achou este projeto **útil**, dê a ele: estrela: ⭐ no topo da página e **Tweet** sobre ele para ajudar a espalhar a palavra [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project')
- Você pode **me seguir** e entrar em contato no [Twitter](https://twitter.com/Syknapse '@Syknapse') ou [usando qualquer uma dessas outras opções](https://syknapse.github.io/Syk-Houdeib/#contact 'A minha secção de contactos | Portfólio')
- Este é um projeto de código aberto. Além de contribuir com seu board, você pode ajudar a corrigir bugs, melhorias ou novos recursos. Abra um [issue](https://help.github.com/articles/creating-an-issue/ 'Como dominar problemas | Guias do GitHub') ou envie uma nova [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Criando uma solicitação pull de uma bifurcação | Ajuda do GitHub')
- **Obrigado por contribuir com este projeto**. Agora você pode ir em frente e tentar contribuir com outros projetos; procure o rótulo [![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) para obter opções de contribuição para iniciantes.
- Também estou procurando colaboradores para me ajudar na revisão e mesclagem de PRs. Se você deseja obter uma prática mais avançada do Git, envie-me um DM no Twitter.

## Agradecimentos

Este projeto é fortemente influenciado por [Roshan Jossey's](https://github.com/Roshanjossey) ótimas [primeiras contribuições](https://github.com/Roshanjossey/first-contributions) em projetos com seu excelente tutorial.

Também é particularmente inspirado pela grande comunidade em torno de [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) A bolsa de estudos do Desafio do Google: desenvolvedor Web front-end, turma da Europa de 2017.

## Licença

[MIT License](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/LICENSE)

[Volte ao topo &uparrow;](#introdução)
