# [Contribute To This Project](https://syknapse.github.io/Contribute-To-This-Project/)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project')

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')

## Wprowadzenie

To tutorial, który pomoże początkującym kontrybutorom uczestniczyć w prostym i łatwym projekcie.

Ten tutorial jest również dostępny w [innych językach](https://github.com/Syknapse/Contribute-To-This-Project/tree/master/translations) (tłumaczenia mile widziane).

### Cele

- Wgraj swoją pierwszą kontrybucję w projekt open source.
- Poczuj się bardziej komfortowo korzystając z GitHub.

### Dla kogo to jest?

- Dla początkujących. Jeśli wiesz jak napisać i edytować element <em>kotwicy</em> `<a href="" target=""></a>`, powinieneś być w stanie to zrobić.
- Dla tych, którzy mają trochę więcej doświadczenia, ale chcą wgrać swoją pierwszą zmianę w projekt open source lub wgrać więcej zmian, aby uzyskać więcej doświadczenia i pewności siebie.

### Po co mi to?

Każdy programista, początkujący czy doświadczony, musi korzystać z systemu kontroli wersji Git, a GitHub jest najpopularniejszą usługą hostingową Gita używaną przez wszystkich. To także serce społeczności Open Source. Korzystanie z GitHuba to niezbędna umiejętność. Wgrywanie zmian do projektu zwiększa Twoją pewność siebie i daje Ci coś do pokazania na Twoim profilu na GitHub.<br>
Jeśli jesteś początkującym programistą i zastanawiasz się, czy powinieneś nauczyć się Gita i GitHuba, oto odpowiedź: [You Should've Learned Git Yesterday](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'New Developer? You should’ve learned Git yesterday. by Brandon Morelli, creator of CodeBurst.io').

## Jaką zmianę wgram?

![Contributor Card](/readme-only/card.PNG 'Contributor Card')

Wgrasz kartę, jak ta, do [strony internetowej projektu](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project'). Karta będzie zawierała Twoje imię, nazwę użytkownika na Twiterze, krótki opis i 3 linki do użytecznych zasobów dla programistów, które polecasz.

Stworzysz kopię szablonu karty w pliku HTML i uzupełnisz ją informacjami o sobie.

## Indeks Szybkiego Dostpępu

| <ul><li>[Wprowadzenie](#wprowadzenie)</li><li>[Jaką zmianę wgram?](#jaką-zmianę-wgram)</li><li>[Ustawienia](#ustawienia)</li><li>[Wgraj swoją zmianę &rightarrow;](#wgraj-swoją-zmianę)</li><li>[Następne kroki](#następne-kroki)</li><li>[Podziękowania](#podziękowania)</li></ul> | Wgraj swoją zmianę: <ul><li>[Krok 1: Utwórz fork repozytorium](#krok-1-utwórz-fork-repozytorium)</li><li>[Krok 2: Sklonuj repozytorium](#krok-2-sklonuj-repozytorium)</li><li>[Krok 3: Stwórz nową gałąź](#krok-3-stwórz-nową-gałąź)</li><li>[Krok 4: Otwórz plik index.html](#krok-4-otwórz-plik-indexhtml)</li><li>[Krok 5: Skopiuj szablon karty](#krok-5-skopiuj-szablon-karty)</li><li>[Krok 6: Wprowadź zmiany](#krok-6-wprowadź-zmiany)</li><li>[Krok 7: Wgraj zmiany](#krok-7-wgraj-zmiany)</li><li>[Krok 8: Wyślij zmiany na GitHub](#krok-8-wyślij-zmiany-na-github)</li><li>[Krok 9: Wyślij swoje zmiany do zatwierdzenia](#krok-9-wyślij-swoje-zmiany-do-zatwierdzenia)</li><li>[Krok 10: Świętuj!](#krok-10-świętuj)</li></ul> |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |


## Ustawienia

Najpierw przygotujmy się do pracy

1. Zaloguj się na GitHub. Jeśli nie masz konta, [dołącz do GitHub](https://github.com/join). Przed kontynuowaniem zalecam zapoznanie się z [GitHub Hello World tutorial](https://guides.github.com/activities/hello-world/).
2. Pobierz [GitHub Desktop app](https://desktop.github.com/).
   - Ewentualnie, jeśli czujesz się komfortowo używając Gita w wierszu poleceń, możesz to zrobić (tutaj jest [first-contributions](https://github.com/Syknapse/first-contributions), podobny projekt, który może służyć jako przewodnik po potrzebnych poleceniach). LUB
   - Jeśli używasz [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website') ma ono wbudowaną obsługę Git i pozwala robić to, co potrzebujemy, bezpośrednio z edytora.
   - Jednak najprostszym i najłatwiejszym sposobem wykonania tego tutorialu jest GitHub Desktop.

Teraz, gdy wszystko gotowe, przejdźmy do wgrywania zmiany do projektu.

---

---

## Wgraj swoją zmianę

Zostań kontrybutorem open source w 10 prostych krokach.

_Przewidywany czas: Mniej niż 30 minut_.

### Krok 1: Utwórz fork repozytorium

- Celem jest wykonanie kopii tego projektu i umieszczenie jej na swoim koncie.
- Projekt na GitHub jest nazywany repozytorium (repo), a fork jest jego kopią.
- Upewnij się, że jesteś na [głównej stronie](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') tego repozytorium.

| <ul><li>Kliknij przycisk _Fork_</li></ul> | ![Fork](/readme-only/fork.png "click on 'Fork'") |
| :---------------------------------------- | ----------------------------------------------: |


- Masz teraz pełną kopię projektu na swoim koncie.

---

### Krok 2: Sklonuj repozytorium

- Teraz chcemy stworzyć lokalną kopię projektu. To jest kopia zapisana na Twoim komputerze.
- Otwórz aplikację GitHub Desktop. W aplikacji:

| <ul><li>Kliknij _File_, a następnie _Clone repository_</li></ul> | ![Clone](/readme-only/clone.PNG 'click clone repository') |
| :--------------------------------------------------------------- | -------------------------------------------------------: |


| <ul><li>Zobaczysz listę swoich projektów i forków na GitHubie.</li><li>Wybierz `<twoja-nazwa-użytkownika>/Contribute-To-This-Project`.</li><li>Kliknij _Clone_</li></ul> | ![Clone project](/readme-only/clone-project.PNG 'click on <your-github-username>/Contribute-To-This-Project') |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------: |
| <ul><li>Sforkowany projekt będzie miał symbol fork po lewej stronie.</li><li>Twój fork będzie miał nazwę Twojej nazwy użytkownika na GitHub.</li></ul>                   |    ![your fork](/readme-only/clone-your-fork.PNG 'your fork will look like this, with your own user name')    |

- Może to chwilę potrwać, ponieważ porjekt zostanie skopiowany na na Twój dysk twardy. Zalecam zachowanie domyślnej ścieżki, jaką jest zwykle `..\Dokumenty\GitHub`.
- Teraz masz lokalną kopię projektu.

---

### Krok 3: Stwórz nową gałąź

- Po sklonowaniu repozytorium i otwarciu go w GitHub Desktop nadszedł czas, aby utworzyć nową gałąź.
- Gałąź to sposób na oddzielenie zmian od głównej części projektu nazwanej `Master`. Na przykład, jeśli coś pójdzie nie tak i nie jesteś zadowolony ze zmian, możesz po prostu usunąć gałąź, a główny projekt nie zostanie zmieniony.

| <ul><li>Kliknij _Current branch_</li><li>Następnie kliknij _New_</li></ul> | ![Create branch](/readme-only/branch-new.PNG "Click on 'Branch', then 'New'") |
| :------------------------------------------------------------------------- | ---------------------------------------------------------------------------: |


| <ul><li>Nazwij swoją gałąź</li><li>Kliknij `Create branch`</li></ul> | ![Name branch](/readme-only/branch-name.PNG 'Name your branch') |
| :------------------------------------------------------------------- | -------------------------------------------------------------: |


- Możesz nazwać ją jak chcesz, ale dlatego, że jest to gałąź, aby dodać kartę z Twoim imieniem do projektu, nazwanie tego `twoje-imię-card` jest dobrą praktyką, ponieważ jasno określa cel tej gałęzi.

| <ul><li>Opublikuj swoją nową gałąź na GitHubie</li></ul> | ![Name branch](/readme-only/branch-publish.PNG 'Click publish to send the new branch to your remote repo on GitHub') |
| :------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------: |


- Właśnie utworzyłeś nową gałąź niezależną od mastera.
- Przy następnych krokach upewnij się, że pracujesz na tej gałęzi. Nazwę gałęzi, w której się znajdujesz, zobaczysz w górnej środkowej części GitHub Desktop, gdzie jest napisane _Current branch_.

**NIE pracuj na gałęzi `master`**

---

### Krok 4: Otwórz plik index.html

- Teraz musimy otworzyć plik, który będziemy edytować za pomocą Twojego ulubionego edytora kodu.
- Znajdź folder projektu na swoim komputerze. Jeśli zachowałeś wartość domyślną, powinno to być coś w stylu `twój-komputer > Dokumenty > GitHub > Contribute-To-This-Project`
- Plik `index.html` znajduje się bezpośrednio w folderze `Contribute-To-This-Project`.

| <ul><li>Otwórz edytor kodu (Sublime, VS Code, Atom..etc) i użyj polecenia `Open file` i znajdź plik index.html w głównym folderze projektu</li><li>Ewentualnie możesz znaleźć plik na dysku twardym, kliknąć go prawym przyciskiem myszy i otworzyć go w edytorze</li></ul> | ![Open index file](/readme-only/index-open.PNG 'Open index.html in your text editor') |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -----------------------------------------------------------------------------------: |


- Teraz masz plik, który będziesz edytować, w swoim edytorze i możesz rozpocząć wprowadzanie w nim zmian.

---

### Krok 5: Skopiuj szablon karty

- Stwórzmy kopię szablonu karty, aby rozpocząć nad nim pracę.

| <ul><li>W górnej części pliku html, pod sekcjami `<head>` i `<header>` znajduje się sekcja oznaczona `== TEMPLATE ==`</li><li>Skopiuj wszystko, co znajduje się w czerwonym kwadracie na obrazie, od komentarza `Contributor card START` do komentarza `Contributor card END`</li></ul> |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Copy card template](/readme-only/card-copy.PNG 'Copy the card template')                                                                                                                                                                                                               |

| <ul><li>Wklej całość bezpośrednio pod wskazanym komentarzem</li><li>Upewnij się, że przed komentarzem, gdzie zaczyna się Twoja karta i po komentarzu, gdzie się kończy, jest jedna linia odstępu. Dobrą praktyką jest, aby nasz kod był jak najbardziej przejrzysty</li><li>Nigdy nie używaj linterów ani formatorów stylu. Projekt ma konfigurację Prettier</li></ul> |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Paste card template](/readme-only/card-paste.PNG 'Paste below the indicated line')                                                                                                                                                                                                                                                                                    |

- To jest teraz **Twoja** karta, którą możesz dostosowywać i edytować.

---

### Krok 6: Wprowadź zmiany

- Zaczniemy teraz edytować kod html, zmieniając konfigurowalne pola na naszej karcie.

| <ul><li>Zastąp 'Name' swoim imieniem</li><li>Uwaga: Nie zmieniaj `class="name"`</li></ul> | ![Change name](/readme-only/change-name.PNG 'Type your name') |
| :---------------------------------------------------------------------------------------- | -----------------------------------------------------------: |


| <ul><li>Wprowadź adres URL swojego konta na Twitterze `href="Insert URL here"`</li><li>Wpisz swój nick w polu tekstowym</li></ul> |
| :-------------------------------------------------------------------------------------------------------------------------------- |
| ![Change contact](/readme-only/change-contact.PNG 'Insert a link to your Twitter account and type your handle')                    |

- Jeśli wolisz użyć kontaktu innego niż Twitter, musisz zmienić ikonę Twittera, `<i class="fa fa-x-twitter"></i>`, przechodząc do [Font Awesome Icons](http://fontawesome.io/icons/), wyszukując odpowiedniej ikony i zastępując tylko część `fa-x-twitter` nową ikoną, jak na przykład `fa-facebook`. Następnie wykonaj te same kroki co powyżej.

| <ul><li>Powiedz nam coś o sobie</li><li>Pisz krótko i miło. Pomyśl o tym bardziej jak o tweecie niż poście na bloga</li></ul> | ![Change about](/readme-only/change-about.PNG 'Write a sentence about you') |
| :---------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------: |


| <ul><li>Udostępnij społeczności 3 linki do zasobów przydatnych przy tworzeniu stron internetowych</li><li>Może to być wszystko, wideo, wykład, podcast, artykuł, odniesienie lub narzędzie</li><li>Jeśli jesteś początkującym, nie krępuj się, podziel się tym, co wiesz, nawet jeśli uważasz, że jest to proste. Zdziwisz się, ile osób na tym skorzysta</li></ul> |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| ![Change resources](/readme-only/change-resources.PNG 'Insert link, write a short description, and type the name of the resource')                                                                                                                                                                                                                                   |
| <ul><li>Link: Wstaw link `href="tutaj"` zastępując `#`</li><li>Tytuł: Napisz krótki opis `title="tutaj"`</li><li>Nazwa: Wpisz nazwę zasobu w polu tekstowym `>here</a>`</li></ul>                                                                                                                                                                                   |

- Upewnij się, że **zapisałeś wszystkie zmiany**.
- **Przetestuj swoje zmiany**. TO JEST WAŻNE! Otwórz plik html w swojej przeglądarce (na przykład kilkając na niego dwukrotnie) i zobacz, jak Twoja karta będzie wyglądała na stronie. Sprawdź, czy cała strona nadal wygląda tak samo i nic nie jest zepsute. Kliknij swoje linki i upewnij się, że działają. Otwórz konsolę (Ctrl + Shift + J (Windows / Linux) lub Cmd + Opt + J (Mac)) i sprawdź, czy nie ma komunikatów o błędach.
- Świetnie, skończyłeś edytować swój kod!! Następne kroki spowodują wysłanie zmin do GitHub, a póżniej wysłanie ich do połączenia z głównym projektem.

---

### Krok 7: Wgraj zmiany

- Wróć do aplikacji GitHub Desktop.
- Twoje zmiany zostaną automatycznie dodane do obszaru startowego aplikacji.
- Oznacza to, że Git zarejestrował wszystkie **zapisane** zmiany.
- Widać to w aplikacji. Wszystko, co dodałeś do pliku, będzie zaznaczone na zielono, a usunięte elementy na czerwono.

| <ul><li>Następny krok nosi nazwę _Commit_</li><li>To z grubsza oznacza "potwiedź zmiany"</li></ul> | ![Commit changes](/readme-only/commit.PNG "The changes you've added should appear in green on the right side of GitHub desktop app. The commit button is on the bottom left") |
| :------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>Tak powinien wyglądać nagłowek Github Desktop</li><li>Zwróć uwagę na symbol fork obok nazwy projektu w `Current repository`</li><li>Twoje `Current branch` będzie miało nazwę, jaką nadałeś mu w kroku 3</li></ul> |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Commit changes](/readme-only/commit-header.PNG "The changes you've added should appear in green on the right side of GitHub desktop app. The commit button is on the bottom left")                                        |

| <ul><li>Aby kliknąć _Commit_ musisz wypełnić pole _Summary_</li><li>To wiadomość, wyjaśniająca, co zmieniłeś</li><li>W tym przypadku rozsądną wiadomością byłoby "Dodanie informacji o mojej karcie"</li><li>Opcjonalnie możesz dodać bardziej szczegółowy opis _Description_</li><li>Kliknij przycisk _Commit_. Na przycisku pojawi się coś w rodzaju `Commit to "nazwa-twojej-gałęzi"`</li></ul> | ![Write commit message and commit](/readme-only/commit-message.PNG "Write a brief commit message in the 'summary' input, and click 'commit'") |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------: |


---

### Krok 8: Wyślij zmiany na GitHub

- Twoje zmiany są teraz zapisane lub wgrane. Ale są one zapisane tylko lokalnie, czyli na Twoim komputerze.
- Synchronizacja lokalnych zmian z repozytorium na GitHubnazywa się _Push_. "Wypychasz" zmiany z lokalnego repozytorium do zdalnego repozytorium na GitHub.

| <ul><li>Kliknij przycisk _Push_</li></ul> | ![Push to GitHub](/readme-only/push.PNG "Push your changes to GitHub, click on the 'Push' button") |
| :---------------------------------------- | ------------------------------------------------------------------------------------------------: |


- Po kilku sekundach operacja jest zakończona i teraz masz dokładnie taką samą kopię tej gałęzi na swoim komputerze jak i na GitHubie.

---

### Krok 9: Wyślij swoje zmiany do zatwierdzenia

- To jest moment, na który czekałeś; wysłanie _Pull Request_ (PR).
- Do tej pory cała praca, którą wykonałeś, znajdowała się w forku projektu, który jak pamiętasz, znajduje się na Twoim koncie GitHub.
- Teraz nadszedł czas, aby wysłać zmiany do głównego projektu, aby zostały z nim połączone.
- To się nazywa [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help'), ponieważ prosisz oryginalnego opiekuna projektu, aby "wciągnął" Twoje zmiany do swojego projektu.
- Przejdź do strony głównej **swojego forka** na GitHubie (będzie miał ikonę fork i Twoją nazwę użytkownika na górze).
- W górnej części repozytorium zobaczysz podświetloną wiadomość z zielonym przyciskiem.

| <ul><li>Kliknij na `Compare and pull request`</li></ul> | ![Submit a Pull Request](/readme-only/pull-request.PNG 'This is usually towards the top of the page, under the description and above the project files and folders') |
| :------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------: |


| <ul><li>Tak wygląda strona `Open a pull request`.</li><li>PAMIĘTAJ, że _próbujesz połączyć swoją gałąź z oryginalnym projektem, a nie gałęzią `Master`_.</li><li>Poniższy obraz pokazuje, jak powinien wyglądać nagłówek Twojej prośby o scalenie.</li><li>Po lewej stronie znajduje się oryginalny projekt, a po nim gałąź główna. Po prawej jest Twój fork i utworzona przez Ciebie gałąź.</li></ul> |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'You are requesting to merge your branch from your fork into the master branch of the original project')                                                                                                                                                                                                                                  |

| <ul><li>Stwórz prośbę o scalenie:</li><li>Napisz tytuł</li><li>Dodaj opcjonalne informacje w opisie</li><li>Kliknij `Create pull request`</li></ul> | ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Click the green button. Don't be scared!") |
| :-------------------------------------------------------------------------------------------------------------------------------------------------- | -----------------------------------------------------------------------------------------------------: |


- Nie przejmuj się wszystkimi opcjami. Na razie musisz wykonać tylko te trzy kroki.
- Pozostaw opcję `Allow edits from maintainers` zaznaczoną.
- Teraz _Pull Request_ zostanie wysłany do opiekuna projektu. Jak tylko zostanie sprawdzony i zaakceptowany, Twoje zmiany pojawią się na [stronie internetowej projektu](https://syknapse.github.io/Contribute-To-This-Project 'Contribute To This Project web page').

---

### Krok 10: Świętuj!

To wszystko. Zrobiłeś to! Wgrałeś swoją pierwszą kontrybucję w projekt open source na GitHub!

Dodałeś kod do strony internetowej: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project).

Twoje zmiany **nie będą widoczne od razu**; najpierw muszą zostać przejrzane, zaakcetpowane i połączone z projektem przez opiekuna. Po ich połączeniu Twoja karta powinna być widoczna na stronie.

To normalne, że recenzent prosi o zmiany w postaci <em>Pull Request</em> (PR). Potraktuj to jako dobrą praktykę, jeśli Ci się to przytrafi. Miej oko na komentarze i wymagane zmiany. Po wprowadzeniu wymaganych zmian (w swojej gałęzi) wszystko, co musisz zrobić, to wgranie i wysłanie swoich zmian. PR zostanie automatycznie zaktualizowany o nowe zmiany.

Obiecuję, że postaram się jak najszybciej przejrzeć je i scalić z głównym projektem, jendak robię to w wolnym czasię, więc kilkudniowe opóźnienie jest nieuniknione.

---

---

## Następne kroki

- Wróć za jakiś, aby sprawdzić, czy Twój PR został złączony z projektem.
- Powinieneś otrzymać wiadomość e-mail od GitHub, gdy Twoje zmiany zostaną zatwierdzone lub jeśli będą wymagane dodatkowe zmiany. A kiedy PR zostanie ostatecznie połączony z masterem, Twoja karta zostanie dodana.
- Jeśli uważasz, że ten projekt jest **przydatny** daj :star: gwiazdkę :star: u góry strony i **Tweet** o tym, aby pomóc w rozprzestrzenianiu informacji [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project').
- Możesz **obserwować mnie** i kontaktować się ze mną na [Twitterze](https://twitter.com/Syknapse '@Syknapse') lub [korzystając z tych opcji](https://syknapse.github.io/Syk-Houdeib/#contact 'My contact section | Portfolio').
- Jest to projekt open source, więc oprócz wgrania swojej karty, możesz pomóc w naprawianiu błędów, wprowadzaniu popraw i nowych możliwości. Otwórz [problem](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') lub wyślij nowy [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help').
- **Dziękuję za wgrywanie kontrybucji do tego projektu**. Teraz możesz śmiało spróbować wgrywać zmiany do innych projektów; szukaj etykiety ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) dla możliwości wgrywania zmian przyjaznych dla początkujących.
- Szukam również współpracowników, którzy pomogliby mi w recenzowaniu i łączeniu PR. Jeśli chcesz uzyskać bardziej zaawansowaną praktykę Git, wyślij mi wiadomość na Twitterze i przeczytaj [przewodnik współpracownika](collaborator_guide.md).

## Podziękowania

Na ten projekt duży wpływ ma świetny projekt [first-contributions](https://github.com/Roshanjossey/first-contributions) [Roshana Josseya](https://github.com/Roshanjossey) z jego znakomitym tutorialem.

Jest on również szczególnie zainspirowany przez świetną społeczność [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) The Google Challenge Scholarship: Front-End Web Dev, class of 2017 Europe.

## Licencja

[Licencja MIT](https://github.com/Syknapse/Contribute-To-This-Project/blob/master/LICENSE)

[Powrót na górę &uparrow;](#wprowadzenie)
