# [Contribute To This Project](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> :sparkling_heart: 으로 제작된 로고, 제작자: [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **공지:**
>
> 이 프로젝트의 메인테이너가 되어 도움을 주고 싶으신가요? 관심이 있으시다면 메인테이너 가이드 [maintainer's guide](/translations/maintainer_guide/maintainer_guide.kor.md) 를 읽고 [Twitter](https://twitter.com/Syknapse) 에서 DM을 보내주세요.

---

### 빠른 액세스 인덱스

#### 개요

- [공지](#공지)
- [소개](#소개)
- [누구를 위한 프로젝트인가요?](#누구를-위한-프로젝트인가요)
- [이 프로젝트는 왜 필요한가요?](#이-프로젝트는-왜-필요한가요)
- [무엇을 기여하게 되나요?](#무엇을-기여하게-되나요)
- [번역](#번역)
- [준비](#준비-)
- [다음 단계](#다음-단계)
- [감사의 말](#감사의-말)

#### 진행단계

- [기여하기](#기여하기)
- [1단계 - 저장소 포크(fork)하기](#1단계-저장소-포크fork하기)
- [2단계 - 저장소 복제(clone)하기](#2단계-저장소-복제clone하기)
- [3단계 - 새 브랜치 생성](#3단계-새-브랜치-생성)
- [4단계 - 메인 index.html 파일 열기](#4단계-메인-indexhtml-파일-열기)
- [5단계 - 카드 템플릿 복사하기](#5단계-카드-템플릿-복사하기)
- [6단계 - 내용 변경 적용하기](#6단계-내용-변경-적용하기)
- [7단계 - 변경사항 커밋(commit)하기](#7단계-변경사항-커밋commit하기)
- [8단계 - Github에 푸시(push)하기](#8단계-github에-푸시push하기)
- [9단계 - PR 제출하기](#9단계-prpull-request-제출하기)
- [10단계 - 축하합니다](#10단계-축하합니다)

---

## 소개

이 튜토리얼은 기여가 처음인 분들이 쉽고 간단하게 프로젝트에 참여할 수 있도록 도움을 주기 위한 튜토리얼입니다.

### 목표

- 오픈소스 프로젝트에 기여하기.
- Github를 더 능숙하게 사용하기.

### 누구를 위한 프로젝트인가요?

- 이 프로젝트는 완전 초보자들을 위한 프로젝트입니다. 앵커 태그 `<a href="" target=""></a>`를 작성하고 수정할 수 있다면 진행 할 수 있습니다.
- 처음으로 오픈소스에 기여 해보고 싶거나, 이미 경험이 있지만 더 많은 기여를 경험하고 자신감을 얻고 싶은 분들을 위한 프로젝트입니다.

### 이 프로젝트는 왜 필요한가요?

웹 개발자 취업을 희망하는 사람들과 현직 개발자들에게 Git 버전 관리는 필수입니다. GitHub는 많은 사람들이 사용하는 가장 대중적인 Git 호스팅 서비스이자 오픈소스 커뮤니티입니다. GitHub를 능숙하게 사용하는 것은 개발자로서 필수이며 중요한 기술 중 하나입니다. 프로젝트에 기여하면 GitHub 사용에 대한 자신감이 높아지고 GitHub 프로필에 기여 내용이 표시됩니다.

만약 본인이 입문자이며 Git과 GitHub에 대해 배워야 할지 고민을 하고 있다면 여기에 답이 있습니다: [You Should've Learned Git Yesterday](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'New Developer? You should’ve learned Git yesterday. by Brandon Morelli, creator of CodeBurst.io').

### 무엇을 기여하게 되나요?

![Contributor Card](/readme-only/card.PNG 'Contributor Card')

여러분은 이 [프로젝트의 웹 페이지](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project')에 위 그림과 같은 카드를 기여하게 될 것입니다. 카드에는 본인 이름, 트위터 아이디, 간단한 소개 및 여러분들이 추천하는 웹 개발자들을 위한 유용한 리소스 링크가 포함됩니다.

HTML 파일 내부에 카드 템플릿의 복사본을 만들고 본인의 정보로 수정하세요.

### 번역

이 튜토리얼은 [다른 언어](/translations/README.md)로도 제공됩니다. 

|     [Arabic](/translations/README/ARABIC.md)     |  [Bangla](/translations/README/BANGLA.md)  | [Chinese (Traditional)](/translations/README/CHINESE_TRADITIONAL.md) |            [English](/README.md)             |  [French](/translations/README/FRENCH.md)  
| :---------------------------------------------: | :---------------------------------------: | :-----------------------------------------: | :---------------------------------------: | :---------------------------------------: |
|  [German](/translations/README/GERMAN.md)  |      [Hindi](/translations/README/HINDI.md)      | [Italian](/translations/README/ITALIAN.md) | [Japanese](/translations/README/JAPANESE.md) |  [Korean](/translations/README/KOREAN.md)  |
  [Polish](/translations/README/POLISH.md)  | [Portuguese](/translations/README/PORTUGUESE.md) | [Russian](/translations/README/RUSSIAN.md) |  [Serbian](/translations/README/SERBIAN.md)  | [Spanish](/translations/README/SPANISH.md) |
   [Turkish](/translations/README/TURKISH.md) | [Ukrainian](/translations/README/UKRAINIAN.md) |

> 프로젝트 문서 번역을 하고 싶다면 환영입니다. [`번역 가이드`](/translations/README.md)를 읽고 기여해주세요.

---

### 준비! :)

참고: 이 튜토리얼은 GitHub PC를 기반으로 합니다. [터미널을 편하게 사용하신다면 해당 튜토리얼로 이동하세요 (여기를 클릭하세요)](/translations/terminal_tutorial/terminal_tutorial.kor.md)

먼저 작업 환경을 설정해봅시다.

1. GitHub 계정에 로그인하세요. 만약 아직 계정이 없으시다면 [GitHub에 가입하세요](https://github.com/join). 원활한 작업 진행을 위해 [GitHub Hello World 튜토리얼](https://guides.github.com/activities/hello-world/)을 읽고 시작하는 것을 추천드립니다.
2. [GitHub 데스크탑 앱](https://desktop.github.com/)을 다운로드 후 설치하세요.
   - 커맨드 라인에서 Git을 사용하는 것이 편하다면 GitHub 데스크탑 앱을 설치하지 않으셔도됩니다. [커맨드 라인(CLI) 튜토리얼 링크](/translations/terminal_tutorial/terminal_tutorial.kor.md).
   - [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website')를 사용하는 경우 통합 Git이 제공되므로 에디터에서 직접 필요한 작업을 수행할 수 있습니다.
   - 하지만 이 튜토리얼을 따라하기 가장 간단하고 쉬운 방법은 GitHub Desktop을 사용하는 것입니다.

> 이제 모든 준비가 완료되었으므로 본격적으로 프로젝트 기여를 위한 작업을 시작해보겠습니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

### 기여하기

간단한 10가지 단계를 통해 오픈소스 기여자가 되어보세요.

_예상 소요 시간: 30분 미만_.

#### 1단계: 저장소 포크(fork)하기

- 이 단계에서의 목표는 프로젝트의 복사본을 만들어 여러분의 GitHub 계정에 저장하는 것입니다.
- 저장소(repo)는 GitHub에서 프로젝트가 호출되는 방식이며 포크는 프로젝트의 복사본입니다.
- 자신이 저장소의 [메인 페이지](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project')에 있는지 확인하세요.

| ![Fork](/readme-only/fork.png "click on 'Fork'") |
| :---------------------------------------------: |
|         **_Fork_ button을 클릭하세요.**          |

- 이제 여러분의 계정에 프로젝트 사본 복사가 완료되었습니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 2단계: 저장소 복제(clone)하기

- 이제 프로젝트의 로컬 복사본이 필요합니다. 로컬 복사본이란 여러분의 컴퓨터에 저장된 프로젝트의 복사본을 의미합니다.
- GitHub 데스크탑 앱을 열고 다음 작업을 수행하세요:

| ![Clone](/readme-only/clone.PNG 'click clone repository') |
| :------------------------------------------------------: |
|       **_File_ 버튼을 클릭 후 _Clone repository_ 를 클릭하세요.**        |

- GitHub에서 자신의 프로젝트와 포크 목록을 볼 수 있을겁니다.
- `<your-github-username>/Contribute-To-This-Project`를 선택하세요.
- _Clone_ 버튼을 클릭하세요.

| ![Clone project](/readme-only/clone-project.PNG 'click on =your-github-username=/Contribute-To-This-Project') |
| :----------------------------------------------------------------------------------------------------------: |

| :arrow_right_hook: 포크된 프로젝트는 왼쪽에 포크 아이콘이 있을 것입니다. 자신의 포크는 자신의 GitHub 사용자명이 표시됩니다. | ![your fork](/readme-only/clone-your-fork.PNG 'your fork will look like this, with your own user name') |
| :------------------------------------------------------------------------------------------------------------------ | :----------------------------------------------------------------------------------------------------: |

- 프로젝트가 하드디스크로 복사되는데 시간이 소요됩니다. 일반적으로 `..\Documents\GitHub`를 기본 경로로 설정하는 것을 추천드립니다.
- 이제 프로젝트의 로컬 복사본이 생성되었습니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 3단계: 새 브랜치 생성

- 저장소가 복제되고 GitHub 데스크탑에서 열리면 새로운 브랜치를 생성할 차례입니다.
- 브랜치는 수정 사항을 `Master`라는 프로젝트의 주요 부분과 분리하는 수단입니다. 예를 들어 잘못된 수정을 통해 원하지 않은 결과를 얻게되더라도 간단히 브랜치 삭제를 통해 메인 프로젝트에 영향을 끼치지않게 할 수 있습니다.

| :arrow_right_hook: _`Current branch`_ 를 클릭한 후, _`New`_ 를 클릭하세요. | ![Create branch](/readme-only/branch-new.PNG "Click on 'Branch', then 'New'") |
| :---------------------------------------------------------------------------- | :-----------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **브랜치 이름을 지정한 후, `Create branch`를 클릭하세요.** |                           ![Name branch](/readme-only/branch-name.PNG 'Name your branch')                            |
| :arrow_right_hook: **생성된 브랜치를 Github에 게시.**                      | ![Name branch](/readme-only/branch-publish.PNG 'Click publish to send the new branch to your remote repo on GitHub') |

- 브랜치 이름을 마음대로 지정할 수 있지만, 이 브랜치는 본인의 이름이 입력된 카드를 프로젝트에 추가하기 위한 브랜치이므로 브랜치의 의도를 잘 나타낼 수 있는 `your-name-card`(본인 이름)로 지정하는 것이 좋습니다.
- 이제 마스터와 분리된 새로운 브랜치를 생성했습니다.
- 다음 단계를 위해 이 브랜치에서 작업중인지 확인하세요. GitHub 데스크탑 앱의 상단 중앙에 _Current branch_ 에서 현재 작업중인 브랜치의 이름이 표시됩니다.

**절대 `master` 브랜치에서 작업하지 마세요.**

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 4단계: 메인 index.html 파일 열기 

- 이제 선호하는 코드 에디터에서 편집할 파일을 열어야 합니다.
- 컴퓨터에서 프로젝트 폴더를 찾으세요. 기본 값으로 설정했다면 다음과 같은 경로에서 프로젝트 폴더를 찾을 수 있습니다. `your-computer > Documents > GitHub > Contribute-To-This-Project`
- `index.html` 파일은 `Contribute-To-This-Project` 폴더에서 찾을 수 있습니다.
- 코드 에디터(Sublime, VS Code, Atom..등)를 사용해 `Open file` 명령으로 프로젝트의 메인 디렉토리에서 index.html 파일을 찾습니다.

|                  ![Open index file](/readme-only/index-open.PNG 'Open index.html in your text editor')                   |
| :---------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **하드 디스크에 저장된 파일을 우클릭해 직접 코드 에디터로 여는 방법도 있습니다.** |

- 코드 에디터에서 편집할 파일을 열었으니 내용을 변경할 준비가 완료되었습니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 5단계: 카드 템플릿 복사하기

- 작업을 시작하기에 앞서, 카드 템플릿의 복사본을 만들어야 합니다.
- html 파일 상단, `<head>` 및 `<header>` 섹션 아래에 `== TEMPLATE ==` 레이블이 지정된 섹션이 있습니다.
- 아래 이미지에 빨간색으로 표시된 사각형 내부의 `Contributor card START` 부터 `Contributor card END` 주석 사이의 모든 코드를 복사하세요.

| ![Copy card template](/readme-only/card-copy.PNG 'Copy the card template') |
| :-----------------------------------------------------------------------: |

- 복사한 코드를 주석 바로 아래에 붙여넣으세요.
- 카드의 시작 부분과 마지막 끝 부분 사이에 공백 한 줄이 있는지 확인하세요. 코드를 가능한 명확하게 유지하는 것이 좋습니다.
- 린터나 스타일 포매터를 사용하지마세요. 프로젝트에 Prettier 설정이 있습니다.

| ![Paste card template](/readme-only/card-paste.PNG 'Paste below the indicated line') |
| :---------------------------------------------------------------------------------: |

- 이제 카드를 **본인**의 정보로 변경하고 편집할 차례입니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 6단계: 내용 변경 적용하기

- 이제 html 편집을 시작합니다. 카드에서 수정해야 될 필드의 내용을 변경합니다.

| :arrow_right_hook: 'Name'을 자신의 이름으로 변경합니다 | ![Change name](/readme-only/change-name.PNG 'Type your name') |
| :----------------------------------------------- | :----------------------------------------------------------: |

- **참고: `class="name"`은 수정하지마세요.**

| :arrow_right_hook: `href="Insert URL here"`에 트위터 계정 URL을 입력하고, 텍스트 필드에 트위터 계정 이름(핸들)을 입력합니다 | ![Change contact](/readme-only/change-contact.PNG 'Insert a link to your Twitter account and type your handle') |
| :--------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- 트위터가 아닌 다른 연락처를 사용하려면 [Font Awesome Icons](http://fontawesome.io/icons/)에서 연락처에 알맞는 아이콘을 찾아 `<i class="fa fa-x-twitter"></i>` 에서 `fa-x-twitter` 부분을 수정하면 됩니다. 예를 들어 페이스북 아이콘을 사용하려면 `fa-facebook`을 대신 사용하면됩니다.

|                                                                                                                                         ![Change about](/readme-only/change-about.PNG 'Write a sentence about you')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **여러분의 소개를 간단히 해주세요, 블로그 게시물처럼 길고 자세한 설명보단 트윗처럼 짧고 간결하게 작성해주세요.**                                                                                                                |
|                                                                                                              ![Change resources](/readme-only/change-resources.PNG 'Insert link, write a short description, and type the name of the resource')                                                                                                              |
| :arrow_right_hook: **웹 개발과 관련해 유용한 리소스가 있는 커뮤니티의 링크 3개를 공유하세요. 영상, 강연, 팟캐스트, 기사, 참고 자료 무엇이든 좋습니다. 만약 여러분이 입문자라도 부담 갖지 말고 아는 것 무엇이든 공유하세요. 많은 사람들이 도움을 받을 수 있을겁니다.** |

- **링크:** `href="여기"`에 있는 `#` 부분에 링크를 삽입하세요. URL 링크단축 서비스나 해당 사이트가 아닌 URL을 사용하지 말아주세요!
- **설명:** `title="여기"`에 간단한 설명을 작성하세요.
- **이름:** `>여기</a>`에는 리소스의 이름을 적어주세요.
- 변경된 내용들이 **모두 저장되었는지 확인하세요** .
- 변경된 내용들을 가지고 **꼭 테스트를 하세요**. 중요! 브라우저에서 html 파일을 열고 카드가 웹사이트에서 어떻게 보이는지 확인해야합니다. 전체 페이지에 이상이 없는지 확인하세요. 링크를 클릭하고 제대로 동작하는지도 확인해야합니다. 콘솔(Ctrl + Shift + J (Windows / Linux) 또는 Cmd + Opt + J (Mac))을 열고 에러 메시지가 없는지 확인하세요.
- 이제 코드 편집을 무사히 마쳤습니다! 다음 단계에서는 변경 사항을 GitHub로 보낸 다음 제출해 메인 프로젝트와 병합할 것입니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 7단계: 변경사항 커밋(commit)하기

- 다시 GitHub 데스크탑 앱으로 돌아갑니다.
- 변경 사항이 스테이징 영역에 자동으로 추가됩니다.
- 이건 Git에 의해 모든 변경 사항이 **저장 되었음**을 의미합니다.
- 변경 사항이 앱에 반영된 것을 확인할 수 있습니다. 파일에 추가된 부분은 녹색으로 표시되며 삭제된 항목은 빨간색으로 표시됩니다.

|                                                                                                  ![Commit changes](/readme-only/commit.PNG "The changes you've added should appear in green on the right side of GitHub desktop app. The commit button is on the bottom left")                                                                                                  |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: 다음 단계는 _`Commit`_ 입니다. 간단히 말해 `변경 사항 확인` 정도로 설명할 수 있습니다. |
|                                                                                              ![Commit changes](/readme-only/commit-header.PNG "The changes you've added should appear in green on the right side of GitHub desktop app. The commit button is on the bottom left")                                                                                               |
|                                                                            :arrow_right_hook: **GitHub 데스크탑 헤더는 다음과 같아야 합니다. `Current repository`에서 프로젝트 이름 옆 fork 아이콘을 확인하세요, `Current branch` 에는 3단계에서 지정한 이름이 표시됩니다.**                                                                            |
|                                                                                                                  ![Write commit message and commit](/readme-only/commit-message.PNG "Write a brief commit message in the 'summary' input, and click 'commit'")                                                                                                                  |
| :arrow_right_hook: **_`Commit`_ 위해선 _`Summary`_ 필드를 작성해야합니다. 이 필드는 여러분이 무엇을 변경했는지를 설명하는 commit 메시지입니다. 이 경우 `"Add my card information"`이 적당한 메세지가 될 것입니다. 추가로 더 자세한 설명이 담긴 _`Description`_ 을 입력할 수 있습니다. _`Commit`_ 버튼을 클릭하세요. 버튼에 `Commit to "your-branch-name"`를 확인할 수 있을 것입니다.** |

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 8단계: GitHub에 푸시(push)하기

- 이제 변경된 내용들이 저장되고 commit되었습니다. 그러나 변경 사항들은 여러분의 로컬 컴퓨터에만 저장된 것입니다.
- GitHub의 저장소와 로컬 변경 사항을 동기화하는 것을 _Push_ 라고 합니다. _Push_ 를 통해 로컬 컴퓨터 저장소의 변경 사항들을 GitHub의 저장소로 "pushing"합니다.

| :arrow_right_hook: _`Push`_ 을 클릭하세요. | ![Push to GitHub](/readme-only/push.PNG "Push your changes to GitHub, click on the 'Push' button") |
| :------------------------------------------- | :-----------------------------------------------------------------------------------------------: |

- 몇 초 후에 작업이 완료되고 GitHub에 여러분의 컴퓨터의 브랜치 복사본과 정확히 일치하는 복사본이 존재하게 됩니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 9단계: PR(Pull Request) 제출하기

- 드디어 여러분이 기다리시던 _Pull Request_ (PR)를 제출하는 단계입니다.
- 지금까지 실시한 모든 작업들은 여러분의 GitHub의 계정의 프로젝트 fork에 있었습니다.
- 이제 병합될 변경 사항을 메인 프로젝트에 보낼 차례입니다.
- 이것을 [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help')라고 합니다. 말 그대로 프로젝트 관리자에게 끌어오도록("pull") 요청하는 작업입니다.
- Github에 있는 **본인의 fork 저장소**의 메인 페이지로 이동하세요 (맨 위의 사용자 이름과 fork 아이콘이 있습니다).
- 저장소 상단에서 pull request 메시지가 적혀진 녹색 버튼이 있습니다.

|  ![Submit a Pull Request](/readme-only/pull-request.PNG 'This is usually towards the top of the page, under the description and above the project files and folders')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **`Compare and pull request`를 클릭하세요.**                                                     |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'You are requesting to merge your branch from your fork into the master branch of the original project') |
|                                              :arrow_right_hook: `Open a pull request` 페이지입니다.                                               |

- 중요: _우리는 지금 여러분의 브랜치의 fork를 Master 브랜치가 아닌 기존 프로젝트와 병합하려고 시도하고 있다는 것을 꼭 기억하세요_.
- 아래 이미지는 pull request의 헤더가 어떻게 구성되는지를 보여주고 있습니다.
- 가장 왼쪽 드롭박스에는 기존의 프로젝트가 있으며, 다음은 master 브랜치, 이어서 생성한 fork와 브랜치가 있습니다.

|                   ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Click the green button. Don't be scared!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Pull request 생성하기: 제목 작성 후, 설명에 추가적인 설명을 작성하고 `Create pull request`를 클릭하세요.** |

- 다른 많은 옵션들에 당황하지마세요. 여러분은 이 세 단계만 실시하시면 됩니다.
- `Allow edits from maintainers` 을 선택한 상태로 두세요.
- 이제 _Pull Request_ 가 프로젝트 메인테이너에게 전송될 것입니다. 리뷰 후 검토가 완료되면 여러분이 변경한 내용이 [프로젝트 웹 페이지](https://syknapse.github.io/Contribute-To-This-Project 'Contribute To This Project web page')에 반영됩니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

#### 10단계: 축하합니다

모든 단계가 완료되었습니다! 여러분은 이제 GitHub의 오픈 소스 프로젝트에 기여했습니다.

라이브 웹 페이지에 여러분의 코드가 추가 되었습니다.: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

여러분이 추가하고 변경한 내용은 **즉시 반영되지 않습니다**. 먼저 프로젝트 메인테이너의 리뷰, 승인 및 병합 과정을 거쳐야합니다. 병합되면 카드가 라이브 웹 페이지에 표시됩니다.

PR에 대한 리뷰어의 수정 요청은 매우 일반적인 일입니다. 만약 여러분의 PR에 리뷰어가 수정 요청을 한다면 좋은 기회라고 생각하세요. 리뷰어의 의견과 요청된 변경 사항을 확인하고 변경 후 여러분의 브랜치에서 다시 commit, push 하시면 됩니다. PR은 새로운 변경 사항과 함께 자동으로 업데이트됩니다.

PR에 대해 가능한 빠르게 검토를하고 병합할 것을 약속합니다. 하지만 여가 시간에 작업하기 때문에 며칠정도 소요될 수 있습니다.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

### 다음 단계

- 조금 시간이 흐른 후 병합된 Pull Request를 확인하세요.
- 변경 사항이 승인되거나 추가적인 요청사항이 있을 경우 GitHub에서 메일을 발송하게 됩니다. 그리고 PR이 master와 최종적으로 병합되면 여러분의 카드가 추가됩니다.
- 이 _무료_ 시리즈에서도 기여하는 방법을 배울 수 있습니다: [How to Contribute to an Open Source Project on GitHub](https://kcd.im/pull-request)
- 이 프로젝트가 여러분에게 **도움이 되었다면** :star: star :star: **트윗**을 통해 공유하고 널리 알려주세요. [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]
- 연락을 원하시면 **저를 팔로우**해주세요, [트위터](https://twitter.com/Syknapse '@Syknapse')나[여기를 통해 연락도 가능합니다](https://syknapse.github.io/Syk-Houdeib/#contact 'My contact section | Portfolio')
- 이 프로젝트는 오픈 소스 프로젝트입니다. 카드 기여 외에도 버그, 개선 사항 및 새로운 기능 추가 등의 수정 사항은 언제든 환영입니다. [issue](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides')를 관리하거나 [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help')를 보내세요.
- 커뮤니티에 참여하시려면 Pull Requerst 옆에 위치한 GitHub [Discussions](https://github.com/Syknapse/Contribute-To-This-Project/discussions) 탭을 확인하세요. 이곳에선 본인 소개, 오픈 소스에 대한 토론 및 프로젝트 메인테이너와 소통할 수 있습니다. 커뮤니티에 참여해 기능을 추가하고 커뮤니티를 발전시키는데 도움을 주시겠습니까?
- **프로젝트에 기여해주셔서 감사합니다**. 이제 ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png)레이블을 찾아 다른 프로젝트에도 기여해보세요.
- PR을 리뷰하고 병합하는데 도움을 줄 콜라보레이터를 찾고 있습니다. 고급 Git 작업 연습을 원하신다면 트위터로 DM을 보내주시고 [maintainer's guide](/maintainer_guide.md)를 읽어주세요.

[↑ 위로 ↑](#빠른-액세스-인덱스)

---

### 감사의 말

이 프로젝트는 [Roshan Jossey](https://github.com/Roshanjossey)가 만든 최고의 [first-contributions](https://github.com/Roshanjossey/first-contributions) 프로젝트에서 많은 영향을 받았습니다.

또한 [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) The Google Challenge Scholarship: Front-End Web Dev, class of 2017 Europe에서 큰 영감을 받았습니다.

### 상위 100명의 기여자들

[![GitHub Contributors Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[맨 위로 &uparrow;](#소개)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
