# [Contribuisci a Questo Progetto](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> Logo Creato con :sparkling_heart: Da [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Join our Discord server!')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Annunci:**
>
> Ti piacerebbe diventare un manutentore di questo progetto e contribuire a mantenerlo in vita? Se sei interessato, leggi la [guida del manutentore](/maintainer_guide.md) e mandami un DM su [Twitter](https://twitter.com/Syknapse).

---

### Indice di accesso rapido

#### Sommario

- [Annunci](#annunci)
- [Introduzione](#introduzione)
- [Per chi è questo?](#per-chi-è-questo)
- [Perché devo farlo?](#perché-devo-farlo)
- [A cosa contribuirò?](#A-cosa-contribuirò)
- [Traduzioni](#traduzioni)
- [Setup](#setup-)
- [Prossimi Passi](#prossimi-passi)
- [Ringraziamenti](#ringraziamenti)

#### Step

- [Contribuisci](#Contribuisci)
- [Step 1 - Copia la repository](#step-1-copia-la-repository)
- [Step 2 - Clona la repository](#step-2-clona-la-repository)
- [Step 3 - Crea un nuovo ramo](#step-3-crea-un-nuovo-ramo)
- [Step 4 - Apri il file html principale](#step-4-apri-il-file-html-principale)
- [Step 5 - Copia la template della card](#step-5-copia-la-template-della-card)
- [Step 6 - Conferma le modifiche](#step-6-conferma-le-modifiche)
- [Step 7 - Esegui il commit](#step-7-esegui-il-commit)
- [Step 8 - Invia a GitHub](#step-8-invia-a-GitHub)
- [Step 9 - Crea una Pull Request](#step-9-crea-una-Pull-Request)
- [Step 10 - Festeggia](#step-10-festeggia)

---

## Introduzione

Questo è un tutorial per aiutare chi contribuisce per la prima volta a partecipare a un progetto semplice e facile.

### Obiettivi

- Dare un contributo a un progetto open source.
- Prendere più dimestichezza nell'uso di GitHub.

### Per chi è questo?

- Questo è per principianti assoluti. Se sai come scrivere e modificare un tag di ancoraggio `<a href="" target=""></a>` allora dovresti essere in grado di farlo.
- È anche per chi ha un po' più di esperienza ma vuole dare il suo primo contributo open source o ottenere più contributi per avere più esperienza e sicurezza.

### Perché devo farlo?

Qualsiasi sviluppatore web, aspirante o esperto, deve utilizzare il controllo della versione Git e GitHub è il servizio di hosting Git più popolare utilizzato da tutti. È anche il cuore della comunità Open Source. Acquisire familiarità con GitHub è un'abilità essenziale. Dare un contributo a un progetto aumenta la tua sicurezza e ti dà qualcosa da mostrare sul tuo profilo GitHub.

Se sei un nuovo sviluppatore e ti stai chiedendo se hai bisogno di imparare Git e GitHub, ecco la risposta: [Avresti dovuto imparare Git ieri](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa)'Nuovo sviluppatore? Avresti dovuto imparare Git ieri. di Brandon Morelli, creatore di CodeBurst.io').

### A cosa contribuirò?

![Scheda collaboratore](/readme-only/card.PNG 'Scheda collaboratore')

Contribuirai con una carta proprio come questa a questa [pagina web del progetto](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute- A questo progetto'). Includerà il tuo nome, il tuo account Twitter, una breve descrizione e 3 collegamenti a risorse utili per gli sviluppatori web da te consigliate.

Farai una copia del modello della carta all'interno del file HTML e la personalizzerai con le tue informazioni.

---

### Traduzioni

Questo tutorial è anche disponibile in [altre lingue](/translations/README.md)

|     [Arabo](/translations/README/ARABIC.md)     |  [Bangla](/translations/README/BANGLA.md)  | [Cinese (Traditional)](/translations/README/CHINESE_TRADITIONAL.md) |            [Inglese](/README.md)             |  [Francese](/translations/README/FRENCH.md)  
| :---------------------------------------------: | :---------------------------------------: | :-----------------------------------------: | :---------------------------------------: | :---------------------------------------: |
|  [Tedesco](/translations/README/GERMAN.md)  |      [Hindi](/translations/README/HINDI.md)      | [Italiano](/translations/README/ITALIAN.md) | [Giapponese](/translations/README/JAPANESE.md) |  [Coreano](/translations/README/KOREAN.md)  |
  [Polacco](/translations/README/POLISH.md)  | [Portoghese](/translations/README/PORTUGUESE.md) | [Russo](/translations/README/RUSSIAN.md) |  [Serbo](/translations/README/SERBIAN.md)  | [Spagnolo](/translations/README/SPANISH.md) |
   [Turco](/translations/README/TURKISH.md) | [Ucraino](/translations/README/UKRAINIAN.md) |

> Sono gradite traduzioni per la documentazione dei progetti. Leggi la [`Guida alla traduzione`](/translations/README.md) per contribuire.

---

### Setup! :)

N.B.: Questo tutorial è basato su GitHub PC. [Se ti senti a tuo agio con il terminale, vai a questo tutorial (fai clic qui)](/terminal_tutorial.md)

Per prima cosa prepariamoci

1. Accedi al tuo account GitHub. Se non hai ancora un account, [unisciti a GitHub](https://github.com/join). Ti consiglio di seguire il [tutorial su GitHub Hello World](https://guides.github.com/activities/hello-world/) prima di continuare.
2. Scarica [GitHub Desktop app](https://desktop.github.com/).
   - In alternativa, se hai dimestichezza con Git dalla riga di comando, puoi farlo [Ecco il collegamento al tutorial CLI](/terminal-tutorial.md).
   - Se utilizzi [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website') viene fornito con Git integrato e ti consente di fare ciò di cui abbiamo bisogno direttamente dall'editor.
   - Tuttavia, il modo più semplice e facile per seguire questo tutorial è utilizzare GitHub Desktop.

> Ora che sei pronto, possiamo dedicarci al contributo al progetto.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

### Contribute

Diventa un collaboratore open source in 10 semplici passaggi.

_Tempo stimato: Meno di 30 minuti _.

#### Step 1: Copia la repository

- L'obiettivo qui è creare una copia di questo progetto e inserirla nel tuo account.
- Un repository (repo) è il modo in cui un progetto viene chiamato su GitHub e un fork ne è una copia.
- Assicurati di essere sulla [pagina principale](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') di questo pronti contro termine.

| ![Fork](/readme-only/fork.png "clicca su 'Fork'") |
| :---------------------------------------------: |
|         **Clicca sul bottone _Fork_ **          |

- Ora hai una copia completa del progetto nel tuo account.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 2: Clona la repository

- Ora vogliamo creare una copia locale del progetto. Questa è una copia salvata sul tuo computer.
- Apri l'app desktop GitHub. Nell'app:

| ![Clona](/readme-only/clone.PNG 'clicca clona repository') |
| :------------------------------------------------------: |
|       **Clicca su _File_ poi _Clona repository_**        |

- Vedrai un elenco dei tuoi progetti e fork su GitHub.
- Seleziona  `<tuo-nome-utente-github>/Contribuisci a questo progetto`.
- Clicca _Clona_

| ![Clona progetto](/readme-only/clone-project.PNG 'clicca su =tuo-nome-utente-github=/Contribute-To-This-Project') |
| :----------------------------------------------------------------------------------------------------------: |

| :arrow_right_hook: Un progetto forkato avrà il simbolo del bivio sulla sinistra. Il tuo fork avrà il tuo utente GitHub | ![il tuo fork](/readme-only/clone-your-fork.PNG 'il tuo fork sarà simile a questo, con il tuo nome utente') |
| :------------------------------------------------------------------------------------------------------------------ | :----------------------------------------------------------------------------------------------------: |

- Questa operazione richiederà qualche istante poiché il progetto verrà copiato sul disco rigido. Ti consiglio di mantenere il percorso predefinito che di solito è `..\Documents\GitHub`.
- Ora hai una copia locale del progetto.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 3: Crea un nuovo ramo

- Una volta che il repository è stato clonato e lo hai aperto sul desktop GitHub, è ora di creare un nuovo ramo.
- Un ramo è un modo per mantenere le modifiche separate dalla parte principale del progetto chiamata "Master". Ad esempio, se le cose vanno male e non sei soddisfatto delle modifiche, puoi semplicemente eliminare il ramo e il progetto principale non verrà influenzato.

| :arrow_right_hook: fare clic su _`Ramo corrente`_, quindi fare clic su _`Nuovo`_| ![Crea ramo](/readme-only/branch-new.PNG "Fare clic su 'Ramo', quindi su 'Nuovo'") |
| :---------------------------------------------------------------------------- | :-----------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Dai un nome al tuo ramo, quindi fai clic su "Crea ramo"** |                           ![Name branch](/readme-only/branch-name.PNG 'Rinomina il ramo')                            |
| :arrow_right_hook: **Pubblica il tuo nuovo ramo su GitHub**                      | ![Rinomina ramo](/readme-only/branch-publish.PNG 'Fai clic su Pubblica per inviare il nuovo ramo al tuo repository remoto su GitHub') |

- Puoi chiamarlo come preferisci, ma poiché questo è un ramo per aggiungere una carta con il tuo nome al progetto, chiamarlo "il tuo nome" è una buona pratica perché mantiene chiara l'intenzione di questo ramo.
- Ora hai creato un nuovo ramo separato dal master.
- Per i passaggi successivi assicurati di lavorare su questo ramo. Vedrai il nome del ramo in cui ti trovi in alto al centro dell'app desktop GitHub dove dice _Ramo corrente_.

**NON lavorare sul ramo `master`**

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 4: Apri il file html principale

- Ora dobbiamo aprire il file che andremo a modificare con il tuo editor di codice preferito.
- Trova la cartella del progetto sul tuo computer. Se hai mantenuto l'impostazione predefinita, dovrebbe essere qualcosa come "il tuo computer > Documenti > GitHub > Contribuisci a questo progetto"
- Il file `index.html` si trova direttamente nella cartella `Contribute-To-This-Project`.
- Apri il tuo editor di codice (Sublime, VS Code, Atom..etc) e utilizza il comando "Apri file" e individua il file index.html nella directory principale del progetto

|                  ![Apri file index](/readme-only/index-open.PNG 'Apri index.html nel tuo editor di testo')                   |
| :---------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **In alternativa puoi individuare il file sul tuo disco rigido, fare clic con il pulsante destro del mouse e aprirlo con il tuo editor** |

- Ora hai il file che intendi modificare aperto nel tuo editor e sei pronto per iniziare ad apportarvi modifiche.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 5: Copia la template della card

- Faremo una copia del modello della carta per iniziare a lavorarci
- Nella parte superiore del file html, sotto le sezioni `<head>` e `<header>` troverai la sezione etichettata `== TEMPLATE ==`
- Copia tutto all'interno del quadrato rosso nell'immagine, dal commento `Scheda collaboratore START` al commento `Scheda collaboratore FINE`

| ![Copia template card](/readme-only/card-copy.PNG 'Copia la template della card') |
| :-----------------------------------------------------------------------: |

- Incolla il tutto direttamente sotto il commento indicandolo
- Assicurati che ci sia una sola linea di spazio tra l'inizio della carta e la fine dell'ultima carta. È buona norma mantenere il nostro codice il più chiaro possibile
- Non utilizzare mai linter o formattatori di stile. Il progetto ha una configurazione più carina

| ![Incolla template card](/readme-only/card-paste.PNG 'Incolla sotto la linea indicata') |
| :---------------------------------------------------------------------------------: |

- Questa ora è la **tua** carta che puoi personalizzare e modificare.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 6: Conferma le modifiche

- Inizieremo ora a modificare l'html, modificando i campi personalizzabili nella nostra scheda.

| :arrow_right_hook: Sostituisci "Nome" con il tuo nome | ![Cambia nome](/readme-only/change-name.PNG 'Digita il tuo nome') |
| :----------------------------------------------- | :----------------------------------------------------------: |

- **Nota: non modificare `class="nome"`**

| :arrow_right_hook: Inserisci l'URL del tuo account Twitter `href="Inserisci URL qui"`, digita il tuo handle nel campo di testo | ![Cambia contatto](/readme-only/change-contact.PNG 'Inserisci un collegamento al tuo account Twitter e digita il tuo handle') |
| :--------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- Se preferisci utilizzare un contatto diverso da Twitter dovrai sostituire l'icona di Twitter `<i class="fa fa-x-twitter"></i>` andando su [Icone Font Awesome](http://fontawesome.io/icons/) cercando l'icona giusta e sostituendo solo la parte `fa-x-twitter` con la nuova icona come ad esempio `fa-facebook`. Quindi seguire gli stessi passaggi precedenti.

|                                                                                                                                         ![Cambia didascalia](/readme-only/change-about.PNG 'Scrivi una frase su di te')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **Raccontaci qualcosa di te. Sii breve e dolce. Pensalo più come un tweet che come un post sul blog**                                                                                                                |
|                                                                                                              ![Cambia risorse](/readme-only/change-resources.PNG 'Inserisci il collegamento, scrivi una breve descrizione e digita il nome della risorsa')                                                                                                              |
| :arrow_right_hook: **Condividi con la community 3 link a risorse utili per lo sviluppo web. Può essere qualsiasi cosa, un video, un discorso, un podcast, un articolo, un riferimento o uno strumento. Se sei un principiante, non lasciarti intimidire da questo, condividi tutto ciò che sai anche se pensi che sia basilare. Rimarrai sorpreso da quante persone ne trarranno beneficio.** |

- **Link:** Inserisci il link `href="qui"` sostituendo il `#`. Si prega di astenersi dall'utilizzare abbreviazioni URL o URL che non provengono dal sito che si sta pubblicando!
- **Title:** Scrivi una breve descrizione `title="qui"`.
- **Name:** Scrivi il nome della risorsa nel campo di testo `>qui</a>`.
- Assicurati di aver **salvato tutte le modifiche**.
- **Prova le modifiche**. QUESTO È IMPORTANTE! Apri il file html nel tuo browser (ad esempio facendo doppio clic su di esso) e guarda come apparirà la tua carta sul sito. Controlla che l'intera pagina abbia ancora lo stesso aspetto e che nulla sia rotto. Fai clic sui collegamenti e assicurati che funzionino. Apri la console (Ctrl+Shift+J (Windows/Linux) o Cmd+Opt+J (Mac)) e controlla che non ci siano messaggi di errore.
- Ottimo, hai finito di modificare il tuo codice! I passaggi successivi invieranno le modifiche a GitHub e quindi le invieranno per essere unite al progetto principale.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 7: Esegui il commit

- Torna all'app desktop GitHub.
- Le modifiche verranno aggiunte automaticamente all'area di staging.
- Ciò significa che Git ha registrato tutte le modifiche **salvate**.
- Puoi vederlo riflesso nell'app. Tutto ciò che hai aggiunto al file sarà in verde e le eliminazioni verranno visualizzate in rosso.

|                                                                                                  ![Conferma le modifiche](/readme-only/commit.PNG "Le modifiche che hai aggiunto dovrebbero apparire in verde sul lato destro dell'app desktop GitHub. Il pulsante di conferma è in basso a sinistra")                                                                                                  |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: Il passaggio successivo si chiama _`Commit`_. Questo significa più o meno `confermare le modifiche`. |
|                                                                                              ![Conferma le modifiche](/readme-only/commit-header.PNG "Le modifiche che hai aggiunto dovrebbero apparire in verde sul lato destro dell'app desktop GitHub. Il pulsante di conferma è in basso a sinistra")                                                                                               |
|                                                                            :arrow_right_hook: **Questo è l'aspetto che dovrebbe avere l'intestazione del desktop GitHub. Nota il simbolo del fork accanto al nome del progetto in "Repository corrente", il tuo "ramo corrente" avrà il nome che gli hai assegnato nel passaggio 3**                                                                           |
|                                                                                                                  ![Scrivi il messaggio di commit e conferma](/readme-only/commit-message.PNG "Scrivi un breve messaggio di commit nell'input "riepilogo" e fai clic su "commit"")                                                                                                                  |
| :arrow_right_hook: **Per _`Commit`_ devi compilare il campo _`Summary`_. Questo è il messaggio di commit che spiega cosa hai cambiato. In questo caso "Aggiungi i dati della mia carta" sarebbe un messaggio ragionevole. Facoltativamente è possibile aggiungere una _`Descrizione`_ più dettagliata. Fare clic sul pulsante _`Commit`_. Il tuo pulsante dirà qualcosa come "Conferma con il nome del tuo ramo"** |

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 8: Invia a GitHub

- Le tue modifiche sono ora salvate o confermate. Ma vengono salvati solo localmente, cioè sul tuo computer.
- La sincronizzazione delle modifiche locali con il tuo repository su GitHub è chiamata _Push_. Stai "spingendo" le modifiche dal tuo repository locale al repository remoto su GitHub.

| :arrow_right_hook: Fare clic sul pulsante _`Push`_ | ![Invia le modifiche a GitHub](/readme-only/push.PNG "Invia le modifiche a GitHub, fai clic sul pulsante "Push".) |
| :------------------------------------------- | :-----------------------------------------------------------------------------------------------: |

- Dopo pochi secondi l'operazione è completata e ora hai esattamente la stessa copia di questo ramo sulla tua macchina oltre che su GitHub.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 9: Crea una Pull Request

- Questo è il momento che stavi aspettando; invio di una _Pull Request_ (PR).
- Finora tutto il lavoro che hai svolto è stato sul fork del progetto, che, come ricordi, risiede sul tuo account GitHub.
- Ora è il momento di inviare le modifiche al progetto principale per unirle ad esso.
- Questa è chiamata [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'Informazioni sulle richieste pull - GitHub Help') perché stai chiedendo al manutentore del progetto originale di "tirare" le tue modifiche nel loro progetto.
- Vai alla pagina principale del **tuo fork** su GitHub (avrà l'icona del fork e il tuo nome utente in alto).
- Verso la parte superiore del repository vedrai un messaggio di richiesta pull evidenziato con un pulsante verde.

|  ![Invia una Pull Request](/readme-only/pull-request.PNG 'Di solito si trova nella parte superiore della pagina, sotto la descrizione e sopra i file e le cartelle del progetto') |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Fai clic su `Confronta e ottieni richiesta`**                                                   |
| ![Apri una Pull Request](/readme-only/pull-request-branches.PNG 'Stai richiedendo di unire il tuo ramo dal fork nel ramo principale del progetto originale') |
|                                              :arrow_right_hook: Questo è l'aspetto della pagina `Apri una Pull Request`.                                             |

- RICORDA _stai tentando di unire il tuo ramo con il progetto originale e non con il ramo `Master` sul tuo fork_.
- L'immagine seguente ti dà un'idea di come dovrebbe apparire l'intestazione della tua richiesta pull.
- A sinistra c'è il progetto originale, seguito dal ramo master. Sulla destra c'è la tua forchetta e il ramo che hai creato.

|                   ![Invia una Pull Request](/readme-only/pull-request-open.PNG "Fare clic sul pulsante verde. Non aver paura!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook:**Crea una richiesta pull: scrivi un titolo, aggiungi informazioni facoltative nella descrizione e fai clic su `Crea richiesta pull`** |

- Non lasciarti turbare da tutte le opzioni. Per ora devi eseguire solo questi tre passaggi.
- Lasciare selezionata l'opzione `Consenti modifiche ai manutentori`.
- Ora, una _Pull Request_ verrà inviata al manutentore del progetto. Non appena verrà esaminato e accettato, le modifiche verranno visualizzate nella [pagina web del progetto](https://syknapse.github.io/Contribute-To-This-Project 'Contribuisci a questa pagina web del progetto').

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

#### Step 10: Festeggia

Questo è tutto. Ce l'hai fatta! Ora hai contribuito all'open source su GitHub.

Hai aggiunto il codice a una pagina web attiva: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Le tue modifiche **non saranno immediatamente visibili**; prima devono essere riviste, accettate e unite dal manutentore del progetto. Una volta unite, la tua carta dovrebbe essere visibile e pubblicata sulla pagina.

È molto normale che un revisore chieda modifiche a un PR. Considerala una buona pratica se ti succede. Tieni d'occhio i commenti e le modifiche richieste. Una volta apportate le modifiche richieste (di nuovo nel tuo ramo), tutto ciò che devi fare è confermare e inviare le modifiche. Il PR si aggiornerà automaticamente con le nuove modifiche.

Prometto che cercherò di rivedere e unire il prima possibile, ma lo faccio nel mio tempo libero, quindi qualche giorno di ritardo è inevitabile.

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

### Prossimi passi

- Torna tra un po' per verificare la presenza della tua richiesta di pull unita.
- Dovresti ricevere un'e-mail da GitHub quando le modifiche sono state approvate o se sono richieste ulteriori modifiche. E quando il PR sarà finalmente fuso con il master e la tua carta sarà stata aggiunta.
- Puoi anche imparare come contribuire da questa serie _gratuita_: [Come contribuire a un progetto Open Source su GitHub](https://kcd.im/pull-request)
- Se hai trovato questo progetto **utile**, assegnagli :star: star :star: nella parte superiore della pagina e **Twitta**** al riguardo per contribuire a spargere la voce [![Tweet](https:/ /img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]
- Puoi **seguirmi** ed entrare in contatto su [Twitter](https://twitter.com/Syknapse '@Syknapse') o [utilizzando una qualsiasi di queste altre opzioni](https://syknapse.github. io/Syk-Houdeib/#contact 'La mia sezione contatti | Portfolio')
- Questo è un progetto open source, quindi oltre a contribuire con la tua carta, sei invitato a contribuire a correggere bug, miglioramenti o nuove funzionalità. Apri un [problema](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') o invia una nuova [pull request](https://help.github.com /articles/creating-a-pull-request-from-a-fork/ 'Creazione di una richiesta pull da un fork | Guida GitHub')
- Per contribuire a migliorare la nostra community, dai un'occhiata alla scheda GitHub [Discussions](https://github.com/Syknapse/Contribute-To-This-Project/discussions) situata accanto a Pull Requests. Quest'area è un luogo in cui presentarti, approfondire discussioni sull'Open Source e comunicare con i manutentori del progetto. Ci aiuterai a sviluppare questa funzionalità e a migliorare la nostra community?
- **Grazie per aver contribuito a questo progetto**. Ora puoi andare avanti e provare a contribuire ad altri progetti; cerca l'etichetta ![Buon primo numero](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) per opzioni di contributo adatte ai principianti.
- Cerco anche collaboratori che mi diano una mano nella revisione e nella fusione dei PR. Se desideri fare pratica Git più avanzata, inviami un DM su Twitter e leggi la [guida del manutentore](/maintainer_guide.md).

[↑ Torna su ↑](#indice-di-accesso-rapido)

---

### Ringraziamenti

Questo progetto è fortemente influenzato dal fantastico progetto [first-contributions](https://github.com/Roshanjossey/first-contributions) di [Roshan Jossey](https://github.com/Roshanjossey) con il suo eccellente tutorial.

È inoltre particolarmente ispirato dalla grande community attorno a [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) La borsa di studio Google Challenge: Front-End Web Dev, classe 2017 Europa.

### Top 100 Collaboratori

[![GitHub Contributors Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[Torna in cima &uparrow;](#introduzione)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
