# [An diesem Projekt mitwirken](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> Dieses Logo wurde mit :sparkling_heart: von [CandidDeer](https://github.com/CandidDeer) erstellt

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Join%20Our%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Tritt unserem Discord-Server bei')
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Ankündigung:**
>
> Würdest du gerne Betreuer bei diesem Projekt werden und helfen, es am Laufen zu halten? Falls du interessiert bist, lies die [Betreuer-Anleitung](/maintainer_guide.md) durch, tritt unserem [Discord-Server](https://discord.gg/tWkvS4ueVF) bei und schick dem Projekt-Betreuungsteam eine Anfrage.

---

### Schnellzugriffsregister

- [Einführung](#einführung)
- [Ziele](#ziele)
- [Für wen ist diese Anleitung?](#für-wen-ist-diese-anleitung)
- [Warum sollte ich das machen?](#warum-sollte-ich-das-machen)
- [Was werde ich beitragen?](#was-werde-ich-beitragen)
- [Übersetzungen](#übersetzungen)
- [Installation! :)](#installation-)
- [Beitragen](#beitragen)
  - [Schritt 1: Gabele (fork) dieses Verzeichnis (repository)](#schritt-1-gabele-fork-dieses-verzeichnis-repository)
  - [Schritt 2: Klone dieses Verzeichnis (repository)](#schritt-2-klone-dieses-verzeichnis-repository)
  - [Schritt 3: Erstelle einen neuen Zweig (Branch)](#schritt-3-erstelle-einen-neuen-zweig-branch)
  - [Schritt 4: Öffne die index.html Datei](#schritt-4-öffne-die-indexhtml-datei)
  - [Schritt 5: Kopiere die HTML-Karten Vorlage](#schritt-5-kopiere-die-html-karten-vorlage)
  - [Schritt 6: Passe die Vorlage an](#schritt-6-passe-die-vorlage-an)
  - [Schritt 7: Übernimm deine Änderungen](#schritt-7-übernimm-deine-änderungen)
  - [Schritt 8: Schiebe (Push) deine Änderungen zu GitHub](#schritt-8-schiebe-push-deine-änderungen-zu-github)
  - [Schritt 9: Reiche eine Pull Request ein](#schritt-9-reiche-eine-pull-request-ein)
  - [Schritt 10: Feiere](#schritt-10-feiere)
- [Nächste Schritte](#nächste-schritte)
- [Anerkennungen](#anerkennungen)
- [Lizenzen](#lizenzen)
- [Top 100 Beitragende](#top-100-beitragende)

---

## Einführung

Diese Anleitung soll Erst-Beitragenden helfen, Teil eines simplen und einfachen Projektes zu werden.

### Ziele

- Leiste einen Beitrag zu einem Open Source Projekt.
- Werde vertrauter im Umgang mit GitHub.

### Für wen ist diese Anleitung?

- Diese Anleitung ist für absolute Anfänger. Wenn du bereits weißt, wie man ein anchor-Tag `<a href="" target=""></a>` erstellt und bearbeitet, dann sollte diese Anleitung kein Problem für dich sein.
- Diese Anleitung ist auch für jene gedacht, welche schon etwas Erfahrung haben, aber einen ersten Open Source Beitrag leisten wollen, oder mehr Beiträge und Selbstvertrauen auf diesem Gebiet erreichen wollen.

### Warum sollte ich das machen?

Jeder Web-Entwickler, angehend oder erfahren, muss Git-Versionskontrollsysteme kennen, und GitHub ist der populärste Git Hosting Anbieter, und wird von fast jedem genutzt. Es ist außerdem das Herz der Open Source Gemeinschaft. Mit GitHub vertraut zu sein ist also eine essentielle Fähigkeit. Einen Beitrag zu einem Projekt zu leisten steigert dein Selbstvertrauen und gibt dir Inhalte, welche du auf deinem GitHub-Profil vorzeigen kannst.

Falls du ein neuer Entwickler bist und dich fragst, ob du den Umgang mit Git und GitHub lernen solltest, dann ist hier deine Antwort: [You Should've Learned Git Yesterday](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'New Developer? You should’ve learned Git yesterday. by Brandon Morelli, creator of CodeBurst.io').

### Was werde ich beitragen?

![Contributor Card](/readme-only/card.PNG 'Contributor Card')

Du wirst eine Karte, genau so wie diese hier, auf dieser Webseite beitragen: [Projekt-Startseite](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project'). Diese soll deinen Namen, deinen Twitter- bzw. X-Namen, eine kurze Beschreibung sowie 3 Links zu nützlichen Unterlagen für Web-Entwickler, welche du empfiehlst, enthalten.

Du wirst eine Kopie von dem Karten-Template innerhalb der HTML-Datei machen und sie mit deinen eigenen Informationen anpassen.

---

### Übersetzungen

Diese Anleitung ist auch in anderen Sprachen verfügbar:  [other languages](/translations/README.md)

|     [Arabisch (عربي)](/translations/README/ARABIC.md)     |  [Bangla (বাংলা)](/translations/README/BANGLA.md)  | [Chinesisch (Traditionell) (繁體中文)](/translations/README/CHINESE_TRADITIONAL.md) |            [Englisch (English)](/README.md)             |  [Französisch (Français)](/translations/README/FRENCH.md)  
| :---------------------------------------------: | :---------------------------------------: | :-----------------------------------------: | :---------------------------------------: | :---------------------------------------: |
|  [Deutsch (Deutsch)](/translations/README/GERMAN.md)  |      [Hindi (हिंदी)](/translations/README/HINDI.md)      | [Italienisch (Italiano)](/translations/README/ITALIAN.md) | [Japanisch (日本語)](/translations/README/JAPANESE.md) |  [Koreanisch (한국어)](/translations/README/KOREAN.md)  |
  [Polnisch (Polski)](/translations/README/POLISH.md)  | [Portugisisch (Portuguese)](/translations/README/PORTUGUESE.md) | [Russisch (Русский)](/translations/README/RUSSIAN.md) |  [Serbisch (Српски)](/translations/README/SERBIAN.md)  | [Spanisch (Español)](/translations/README/SPANISH.md) |
   [Turkisch (Türkçe)](/translations/README/TURKISH.md) | [Ukrainisch (українська)](/translations/README/UKRAINIAN.md) | [Norwegisch (Norsk)](/translations/README/NORWEGIAN.md)

> Übersetzungen für Projekt-Dokumentationen sind stets willkommen. Lies dir den [`Translation Guide`](/translations/README.md) druch, um dort beizutragen.

---

### Installation :)

> [!Note]
> Diese Anleitung basiert auf GitHub PC. [Wenn du im Umgang mit GitHub per Terminal bereits vertraut bist: (Klicke Hier)](/terminal_tutorial.md)

Zuerst lass die Installationsanwendung ihre Arbeit verrichten.

1. Logge dich in dein GitHub Konto ein. Falls du noch kein Konto besitzt, [tritt GitHub bei](https://github.com/join). Ich empfehle dir, dass du zuerst das [GitHub Hello World Tutorial](https://guides.github.com/activities/hello-world/) absolvierst, bevor du hier weitermachst.
2. Lade die [GitHub Desktop Anwendung](https://desktop.github.com/) herunter.
   - Alternativ: Wenn du im Umgang mit GitHub per Terminal vertraut bist: [Hier ist ein Link zu der CLI-Anleitung](/terminal_tutorial.md).
   - Falls du  [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website') benutzt, beinhaltet es Git bereits und erlaubt dir, alles Notwendige gleich innerhalb des Editors zu machen.
   - Allerdings ist die einfachste Art dieser Anleitung zu folgen, die GitHub Desktop Anwendung zu benutzen.

> Nachdem GitHub installiert ist, können wir mit dem Beitrag zum Projekt anfangen.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

### Beitragen

Werde ein(e) Open Source Beitragende(r) in 10 einfachen Schritten.

_Voraussichtlich benötigte Zeit: weniger als 30 Minuten_.

#### Schritt 1: Gabele (fork) dieses Verzeichnis (repository)

- Das Ziel hier ist es, eine Kopie des Projektes auf deinem eigenen Konto anzulegen.
- Ein Verzeichnis (repository oder kurz repo) ist der Name eines Projektes auf GitHub, eine Gabelung (fork) ist eine Kopie von diesem.
- Stell sicher, dass du auf der [main page](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') dieses Verzeichnises (repository) bist.

| ![Fork](/readme-only/fork.png "Drücke auf 'Fork'") |
| :---------------------------------------------: |
|         **Drücke auf den _Fork_-Knopf**          |

- Nun hast du eine komplette Kopie dieses Projektes auf deinem Konto.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 2: Klone dieses Verzeichnis (repository)

- Jetzt wollen wir eine lokale Kopie des Projektes anlegen. Das ist eine Kopie, welche auf deinem Gerät gespeichert ist.
- Öffne die GitHub Desktop Anwendung. In der Anwendung:

| ![Clone](/readme-only/clone.PNG 'Drücke clone repository') |
| :------------------------------------------------------: |
|       **Drücke auf _File_ dann _Clone repository_**        |

- Du wirst eine Liste deiner GitHub Projekte und Zweige (Branches) sehen.
- Wähle `<your-github-username>/Contribute-To-This-Project` aus.
- Drücke auf _Clone_

| ![Clone project](/readme-only/clone-project.PNG 'Drücke auf =your-github-username=/Contribute-To-This-Project') |
| :----------------------------------------------------------------------------------------------------------: |

| :arrow_right_hook: Ein abgezweigtes (forked) Projekt hat ein Gabel Symbol auf der linken Seite. Deine Abzweigung hat deinen eigenen GitHub Benutzer an dessen Stelle | ![your fork](/readme-only/clone-your-fork.PNG 'Deine Fork wird so aussehen, mit deinem Nutzernamen') |
| :------------------------------------------------------------------------------------------------------------------ | :----------------------------------------------------------------------------------------------------: |

- Es wird eine Weile dauern, bis das Projekt auf deine Festplatte kopiert wurde. Ich empfehle, den standard Pfad beizubehalten:  `..\Documents\GitHub`.
- Nun hast du eine lokale Kopie des Projektes.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 3: Erstelle einen neuen Zweig (Branch)

- Sobald das Verzeichnis geklont ist und du sie in der GitHub Desktop Anwendung geöffnet hast, wird es Zeit, einen neuen Zweig (branch) zu erstellen.
- Ein Zweig (branch) ist ein Weg, um deine Änderungen vom Hauptteil des Projektes namens `Master` zu separieren. Falls zum Beispiel etwas schief läuft und du nicht glücklich über deine Änderungen bist, kannst du diesen Zweig (branch) einfach löschen und das Hauptprojekt (Master) wird nicht davon beeinflusst.

| :arrow_right_hook: Drücke auf _`Current branch`_, Dann drücke auf _`New`_ | ![Create branch](/readme-only/branch-new.PNG "Drücke auf 'Branch', dann 'New'") |
| :---------------------------------------------------------------------------- | :-----------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Gib deinem Zweig einen Namen, dann drücke auf `Create branch`** |                           ![Name branch](/readme-only/branch-name.PNG 'bennen deinen Zweig (branch)')                            |
| :arrow_right_hook: **Veröffentliche deinen Zweig auf GitHub**                      | ![Name branch](/readme-only/branch-publish.PNG 'Drücke auf publish, um deinen Zweig zu deinem Verzeichnis auf GitHub zu schicken') |

- Du kannst dir den Namen frei aussuchen, aber nachdem es ein Zweig ist, um eine Karte mit deinem Namen zu dem Projekt hinzuzufügen, ist es allgemein üblich, den Namen `your-name-card` zu wählen, da es die Intention deines Zweiges (fork) klar zum Ausdruck bringt.
- Nun hast du einen eigenen Zweig (branch), unabhängig vom Master-Zweig (Master), erstellt.
- Stelle für die nächsten Schritte sicher, dass du an diesem neuem Zweig arbeitest. Du siehst den Namen des momentan ausgewählten Zweiges (branch) in der Mitte oben in der GitHub Desktop Anwendung, wo _Current branch_ steht.

**Arbeite KEINESFALLS am `master` Zweig (branch)**

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 4: Öffne die index.html Datei

- Nun musst du die Datei, welche wir gleich öffnen, mit deinem Lieblings-Code Editor öffnen.
- Finde den Projekt Ordner auf deinem Computer. Falls du den Standardpfad ausgewählt hast, sollte es`your-computer > Documents > GitHub > Contribute-To-This-Project` sein.
- Die `index.html` Datei ist direkt im `Contribute-To-This-Project` Ordner.
- Öffne deinen Code Editor (Sublime, VS Code, Atom..etc), nutze den `Datei öffnen` Befehl und finde die index.html Datei im Hauptordner des Projektes.

|                  ![Open index file](/readme-only/index-open.PNG 'Öffne index.html in deinem Text-Editor')                   |
| :---------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Alternativ kannst du die Datei auf deinem Computer suchen, Rechtsklick, öffne mit... _deinem Editor_** |

- Nun ist die Datei in deinem Editor geöffnet und du kannst anfangen, deine Änderungen durchzuführen.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 5: Kopiere die HTML-Karten Vorlage

- Wir werden eine Kopie der Kopier-Vorlage anlegen, um an dieser risikofrei arbeiten zu können.
- Genau innerhalb von `<body>`, findest du eine Sektion mit dem Namen `<div class="container">`. Diese Abteilung enthält auch eine Menge anderer Sektionen.
- Die **ersten 2** Sektionen sind exakt genau so wie: `<div class="row">`. Klappe die Beiden zusammen, indem du auf den Pfeil auf deren linke Seite drückst, so wie im Bild darunter gezeigt wird. (Falls du einen anderen Editor benutzt, steht dir diese Funktion eventuell nicht zur Verfügung. In diesem Fall musst du runter scrollen). Das Einklappen macht es einfach einige Code-Teile zu verstecken, an welchen wir keine Änderungen durchführen müssen.
- Nun solltest du die Sektion sehen, welche alle anderen Beitrags-Karten (von anderen Beitragenden) enthält: `<div class="grid" id="contributions">`

| ![Find card template](/readme-only/find-card-template.png 'Finde die HTML-Karten Vorlage') |
| :-----------------------------------------------------------------------: |

- In dieser Sektion gibt es eine Unterabteilung namens  `== TEMPLATE ==`.
- Kopiere alles innehalb des roten Bereichs, welcher auf dem Bild zu sehen ist, vom Anfang des `Contributor card START` Kommentars bis zum Ende des `Contributor card END` Kommentars.

| ![Copy card template](/readme-only/card-copy.PNG 'Kopiere die HTML-Karten Vorlage') |
| :-----------------------------------------------------------------------: |

- Füge nun das Kopierte genau unterhalb der Linie mit dem anzeigendem Kommentar ein; genau über der zuletzt eingefügten Karte vom vorherigen Beitragenden.
- Stelle sicher, dass genau eine Zeile über und unter deiner Karte frei bleibt. Füge außerdem eine weitere freie Zeile zwischen deinem Code und dem Kommentar `=== Paste YOUR CARD directly BELOW this line ===` ein. Es ist gute Übung, unseren Code immer übersichtlich zu halten.
- Benutze niemals Formatierer. Dieses Projekt hat schönere Werkzeuge zur Verfügung.

| ![Paste card template](/readme-only/card-paste.PNG 'Füge unterhalb der angezeigten Linie ein') |
| :---------------------------------------------------------------------------------: |

- Dies ist nun **deine** HTML-Karte, welche du anpassen und bearbeiten kannst.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 6: Passe die Vorlage an

- Nun werden wir damit anfangen, HTML zu bearbeiten, indem wir die anpassbaren Felder unserer HTML-Karte ändern.

| :arrow_right_hook: Ersetze 'Name' mit deinem Namen | ![Change name](/readme-only/change-name.PNG 'Gib deinen Namen ein') |
| :----------------------------------------------- | :----------------------------------------------------------: |

- **Anmerkuing: Ändere KEINESFALLS `class="name"`**

| :arrow_right_hook: Füge die URL zu deinem Twittter bzw. X-Account ein `href="Insert URL here"`, und gib deinen Twitter bzw. X Namen ein | ![Change contact](/readme-only/change-contact.PNG 'Füge einen Link zu deinem Twitter bzw. X Konto ein und gib deinen Namen an') |
| :--------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- Falls du lieber eine andere Kontakmöglichkeit angeben möchtest, musst das das Twitter icon in `<i class="fa fa-x-twitter"></i>` ersetzen, indem du auf die Seite [Font Awesome Icons](http://fontawesome.io/icons/) gehst, nach dem richtigen Icon suchst, und nur den `fa-x-twitter` teil mit dem beispielsweise passenden Teil `fa-facebook` für facebook ersetzt. Dann folge wieder den gleichen Schritten wie oben.

|                                                                                                                                         ![Change about](/readme-only/change-about.PNG 'Schreibe einen Satz über dich')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **Nenn uns etwas über dich. Halte dich kurz und präzise. Stelle es dir eher wie einen Tweet als wie einen Blogpost vor.**                                                                                                                |
|                                                                                                              ![Change resources](/readme-only/change-resources.PNG 'Füge den Link ein, schreibe eine kurze Beschreibung, Und gib den Namen der Ressource ein.')                                                                                                              |
| :arrow_right_hook: **Teile mit der Gemeinde 3 Links, welche du hilfreich beim Web-Development findest. Das kann alles Mögliche sein, von Video, Zeitschrift, Artikel bis hin zu Blogposts. Falls du ein Anfänger bist, lasse dich davon nicht einschüchtern, teile was auch immer du kennst, auch wenn es nur Grundlagen sind. Du wirst überrascht sein, wie viele Leute davon profitieren können.** |

- **Link:** Füge den Link `href="here"`, das `#` ersetzend, ein. Bitte benutze keinen URL-Kürzer oder versuche eine andere (welcher nicht von der ursprünglichen Website bereitgestellt wurde) Mehtode, um Ähnliches zu erreichen.
- **Titel:** Gib eine kurze Beschreibung bei `title="here"` an.
- **Name:** Schreibe den Namen der Ressource hier hin: `>here</a>`.
- Stelle sicher, **dass du all deine Änderungen gespeichert hast.**.
- **Teste deine Änderungen**. DIESER SCHRITT IST WICHTIG! Öffne die HTML Datei (index.html) in deinem Browser (z.B. indem du doppelt darauf klickst) und sieh dir an, wie deine Karte aussehen wird. Stelle sicher, dass die Seite noch so aussieht wie davor (mit deiner neuen Karte), und nichts kaputt gegangen ist. Drücke auf deine Links, und stelle sicher, dass diese auch funktionieren. Öffne die Konsole (Strg) + Shift + J (Windows / Linux) oder Cmd + Opt + J (Mac)) und überprüfe, dass keine Fehler aufgetreten sind.
- Sehr gut, du hast deinen Code fertig bearbeitet! Die nächsten Schritte werden dir zeigen, wie du deine Änderungen an GitHub senden kannst, und sie dann zum fertigen verschmelzen (merge) mit dem Hauptprojekt abgeben kannst.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 7: Übernimm deine Änderungen

- Gehe zurück in die GitHub Desktop Anwendung.
- Deine Änderungen wurden automatisch dem Vorbereitungsbereich (staging area) hinzugefügt.
- Das bedeutet, dass Git alle  **gespeicherten** Änderungen aufgezeichnet hat.
- Dies sollte in der Anwendung widergespiegelt werden. Alles, was du der Datei hinzugefügt hast, erscheint in grün. Alles, was gelöscht wurde, erscheint in rot.

|                                                                                                  ![Commit changes](/readme-only/commit.PNG "Deine hinzugefügten Änderungen sollten in grün auf der rechten Seite der GitHub Desktop Anwendung erscheinen. Der Einreichen-Schalter (commit) ist unten links ")                                                                                                  |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: Der nächste Schritt heißt _`Commit`_. Das bedeutet ungefährerweise `bestätige die Änderungen` |
|                                                                                              ![Commit changes](/readme-only/commit-header.PNG "TDeine hinzugefügten Änderungen sollten in grün auf der rechten Seite der GitHub Desktop Anwendung erscheinen. Der Einreichen-Schalter (commit) ist unten links")                                                                                               |
|                                                                            :arrow_right_hook: **So sollte der obere Teil deiner GitHub Desktop Anwendung aussehen. Achte auf das Gabel Symbol neben dem Projektnamen bei `Current repository`, dein `Current branch` wird den Namen haben, welchen du ihm in Schritt 3 gegeben hast**                                                                            |
|                                                                                                                  ![Write commit message and commit](/readme-only/commit-message.PNG "Schreibe eine kurze Zusammenfassung deiner Änderungen bei 'summmary' und drücke dann auf 'commit'")                                                                                                                  |
| :arrow_right_hook: **Um _`Commit`_ betätigen zu können, musst du erst das  _`Summary`_ Feld ausfüllen. In dieser Einreichungsmeldung, kannst du festhalten, welche Änderungen du durchgeführt hast. In diesem Fall wäre  `"Add my card information"` eine vernünftige Meldung. Alternativ kannst du auch noch mehr unter _`Description`_ eintragen. Drücke auf den _`Commit`_ Schalter. Dein Button müsste ungefähr Folgendes anzeigen: `Commit to "your-branch-name"`** |

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 8: Schiebe (Push) deine Änderungen zu GitHub

- Deine Änderungen sind nun gespeichert und eingereicht. Allerdings nur lokal, also auf deinem Computer.
- Synchronisieren von lokalen Änderungen mit deinem Online GitHub Konto nennt man _Push_. Du "schiebst" (pushing) die Änderungen von deinem lokalen Verzeichnis (repository) zu der ferngesteuerten / abgelegenen (remote) Lager (repository) auf GitHub.

| :arrow_right_hook: Drücke auf den _`Push`_ Schalter | ![Push to GitHub](/readme-only/push.PNG "Schiebe (push) deine Änderunge auf GitHub, drücke auf den 'Push' Schalter") |
| :------------------------------------------- | :-----------------------------------------------------------------------------------------------: |

- Nach einigen Sekunden sollte die Anweisung ausgeführt worden sein, und nun hast du die exakt gleiche Kopie dieses Zweigs (branch) auf deinem Computer, sowie online auf GitHub.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 9: Reiche eine 'Pull Request' ein

- Nun ist der Moment gekommen, auf den Du gewartet hast: Eine _Pull Request_ (PR) Anfrage.
- Bis jetzt hat all die Arbeit, die du getätigt hast, in deinem Zweig des Projektes stattgefunden, welcher sich, falls du dich erinnerst, auf deinem eigenen GitHub Account befindet.
- Nun ist es an der Zeit, die Änderungen an das Hauptprojekt (master) zu schicken, und diese mit jenem zu verschmelzen (merge).
- Diesen Vorgang nennt man [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'Über Pull Requests - GitHub Help'), da du den originalen Projektbetreiber bittest, deine Änderungen "in das Projekt zu ziehen".
- Gehe auf die Hauptseite **deines Zweiges** auf GitHub (dieses hat ein Gabelsymbol und deinen Benutzernamen ganz oben).
- Oben auf der Seite deiner Repository, wirst du eine hervorgehobene "Pull Request"-Nachricht mit einem grünem Button sehen.

|  ![Submit a Pull Request](/readme-only/pull-request.PNG 'Dieser ist normalerweise ganz oben auf der Seite, unter der Beschreibung und über den Projekt-Dateien und -Ordnern')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Drücke auf `Compare and pull request`**                                                     |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'Du stellst eine Anfrage, um deinen Zweig (branch) von deiner Abzweigung (fork) dem "Master"-Zweig des originalen Projekts hinzuzufügen.') |
|                                              :arrow_right_hook: So sieht die `Open a pull request` Seite aus.                                               |

- VERGISS NICHT: _Du versuchst deinen Zweig (branch) mit dem originalen Projekt zu verschmelzen, nicht mit dem `Master` Zweig (branch) deiner Abzweigung (fork)_.
- Das Bild weiter unten zeigt dir, wie der Header deiner Pull Anfrage aussehen sollte.
- Auf der linken Seite, steht das originale Projekt, gefolgt vom Master-Zweig. Auf der rechten Seite ist deine Abzweigung (fork) und der Zweig (branch), welchen du erstellt hast.

|                   ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Drücke au den grünen Schalter. Hab keine Angst!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Erstelle eine Pull Anfrage: Schreibe einen Titel, füge der Beschreibung optionale Information hinzu, und drücke auf `Create pull request`** |

- Lass dich nicht von all den Einstellungen beunruhigen. Du musst vorerst nur diese drei Schritte durchführen .
- Lasse die Option `Allow edits from maintainers` angekreuzt.
- Nun wird eine _Pull Request_ zum Projekt Betreiber gesendet. Sobald diese begutachtet wurde, werden deine Änderungen auf der [project web page](https://syknapse.github.io/Contribute-To-This-Project 'Trage zu diesem Projekt bei Seite') angezeigt.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

#### Schritt 10: Feiere

Das war's. Du hast es geschafft! Du hast nun zu Open Source auf GitHub beigetragen.

Du hast Code zu einer Live-Internetseite beigetragen: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Deine Änderungen **werden nicht sofort sichtbar**; zuerst müssen diese begutachtet, angenommen, und vom Projektbetreiber verschmolzen (merge) werden. Sobald diese verschmolzen (merge) wurden, sollte deine Karte live auf der Seite sichtbar sein.

Es ist vollkommen normal, dass ein Begutachter um Änderungen an der Pull Anfrage bittet. Seh es als eine gute Übung, falls es dir einmal passieren sollte. Halte Ausschau nach Kommentaren und erwünschten Änderungen. Sobald du die gewünschten Anpassungen (in deinem eigenem Zweig (branch)) vorgenommen hast, musst du nur noch deine Änderungen übernehmen und erneut auf GitHub "pushen". Die Pull Anfrage wird automatisch alle neuen Änderungen übernehmen.

Ich verspreche dir, dass ich jede neue Karte so schnell wie möglich begutachte und verschmelze (merge), aber ich erledige dies in meiner Freizeit, also sind einige Tage Verzögerung leider nicht zu vermeiden.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---

### Nächste Schritte

- Komme in einer Weile wieder, um nach deiner Pull Anfrage zu sehen.
- Du solltest eine E-Mail von GitHub bekommen, falls deine Änderungen angenommen wurden, oder zusätzliche Änderungen notwendig sind, sowie sobald deine Pull Anfrage mit dem master verschmolzen (merge) wurden und deine Karte hinzugefügt wurde.
- Du kannst auch von dieser _kostenlosen_ Serie lernen, wie du weitere Beiträge leisten kannst: [How to Contribute to an Open Source Project on GitHub](https://kcd.im/pull-request).
- Falls du dieses Projekt **nützlich** fandest, gib ihm bitte einen :star: Stern :star: oben auf der Seite und **Tweete** darüber, um dieses Projekt weiter zu verbreiten [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit].
- Du kannst auch unserem [Discord-Server](https://discord.gg/tWkvS4ueVF) beitreten.
- Du kannst **mir folgen** und mit mir in Kontakt treten [𝕏 (Twitter)](https://twitter.com/Syknapse '@Syknapse') oder [eine der anderen Optionen nutzen](https://syknapse.github.io/Syk-Houdeib/#contact 'Meine Kontakt Abteilung | Portfolio').
- Dieses Projekt ist ein Open Source Projekt. Du bist herzlich dazu eingeladen, Verbesserungsvorschläge zu stellen, Bugs zu beheben, oder auf sonstige Weise mitzuwirken. Eröffne ein [issue](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') oder schicke eine [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Erstelle eine Pull Anfrage von einer Abzweigung (fork) | GitHub Help').
- Um die Gemeinschaft weiter zu verbessern, seh dir auch den: [Discussions](https://github.com/Syknapse/Contribute-To-This-Project/discussions)-Tab neben den Pull Anfragen an. Dieser Bereich ist dafür da, um dich genauer vorzustellen, an tieferen Diskussionen über Open Source teilzunehmen, und mit den Projekt-Betreibern in Kontakt zu treten. Wirst du uns helfen diese Funktion und Gemeinschaft weiter zu verbessern?
- **Vielen Dank für deine Teilnahme an diesem Projekt**. Nun kannst du fortfahren, und bei anderen Projekten beitragen; Halte nach dem ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) Schlüsselwort Ausschau, welches für anfängerfreundliche Problemstellungen gedacht ist.
- Ich suche außerdem nach Mitwirkenden, welche mir bei der Begutachtung von eingereichten Pull Anfragen und Verschmelzungen jener helfen. Falls du fortgeschrittenere Git Anwendungspraktiken lernen möchtest, lies den [maintainer's guide](/maintainer_guide.md), trete unserem [Discord-Server](https://discord.gg/tWkvS4ueVF) bei, und frage an, ob du dem Team der Projekt-Betreuer beitreten kannst.

[↑ Gehe nach oben ↑](#schnellzugriffsregister)

---
### Anerkennungen

Dieses Projekt ist sehr stark von [Roshan Jossey's](https://github.com/Roshanjossey) großartigem [first-contributions](https://github.com/Roshanjossey/first-contributions) Projekt und dessen hervorragender Anleitung beeinflusst.

Es ist außerdem besonders von der hervorragenden [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) Gemeinschaft inspiriert. The Google Challenge Scholarship: Front-End Web Dev, class of 2017 Europe.

### Lizenzen

Dieses Projekt ist lizensiert unter folgender Lizenz: [MIT License](./LICENSE).

### Top 100 Beitragende

[![GitHub Contributors Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[Zurück nach oben &uparrow;](#einführung)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
