# [Draag bij aan dit project](https://syknapse.github.io/Contribute-To-This-Project/)

![image info](/favicon.png)

> Logo gemaakt met :sparkling_heart: door [CandidDeer](https://github.com/CandidDeer)

[![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]

[![Discord](https://badgen.net/discord/online-members/tWkvS4ueVF?label=Sluit%20je%20aan%20bij%20onze%20Discord%20Server&icon=discord)](https://discord.gg/tWkvS4ueVF 'Sluit je aan bij onze Discord server!')
[![PRs Welkom](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square&label=PR's)](https://syknapse.github.io/Contribute-To-This-Project/)
[![Open Source Love](https://badges.frapsoft.com/os/v2/open-source.svg?v=103)](https://syknapse.github.io/Contribute-To-This-Project/)

---

> ## **Mededeling:**
>
> Wil je een beheerder worden van dit project en helpen het draaiende te houden? Als je geïnteresseerd bent, lees dan de [beheerdershandleiding](/maintainer_guide.md), sluit je aan bij onze [Discord server](https://discord.gg/tWkvS4ueVF), en vraag om aan te sluiten bij het team van de projectbeheerders.

---

### Snelle toegangsindex

- [Introductie](#introductie)
- [Doelstellingen](#doelstellingen)
- [Voor wie is dit?](#voor-wie-is-dit)
- [Waarom moet ik dit doen?](#waarom-moet-ik-dit-doen)
- [Wat zal ik gaan bijdragen?](#wat-zal-ik-gaan-bijdragen)
- [Vertalingen](#vertalingen)
- [Setup! :)](#setup-)
- [Bijdragen](#bijdragen)
  - [Stap 1: Splits (fork) deze bron (repository)](#stap-1-splits-fork-deze-bron-repository)
  - [Stap 2: Kloon deze bron (repository)](#stap-2-kloon-deze-bron-repository)
  - [Stap 3: Creëer een nieuwe tak (branch)](#stap-3-creëer-een-nieuwe-tak-branch)
  - [Stap 4: Open het index.html bestand](#stap-4-open-het-indexhtml-bestand)
  - [Stap 5: Kopieer het HTML-kaartsjabloon](#stap-5-kopieer-het-html-kaartsjabloon)
  - [Stap 6: Pas je wijzigingen toe](#stap-6-pas-je-wijzigingen-toe)
  - [Stap 7: Bevestig je wijzigingen](#stap-7-bevestig-je-wijzigingen)
  - [Stap 8: Publiceer (Push) je wijzigingen naar GitHub](#stap-8-publiceer-push-je-wijzigingen-naar-github)
  - [Stap 9: Dien een PR(Pull Request) in](#stap-9-dien-een-prpull-request-in)
  - [Stap 10: Vier feest](#stap-10-vier-feest)
- [Volgende stappen](#volgende-stappen)
- [Dankbetuigingen](#dankbetuigingen)
- [Licensie](#licensie)
- [Top 100 bijdragers](#top-100-bijdragers)

---

## Introductie

Dit is een handleiding om beginnende bijdragers te helpen om deel te nemen aan een eenvoudig en gemakkelijk project.

### Doelstellingen

- Lever een bijdrage aan een open source-project.
- Raak meer vertrouwd met het gebruik van GitHub.

### Voor wie is dit?

- Dit is voor absolute beginners. Als je weet hoe je een anchor tag `<a href="" target=""></a>` moet schrijven en bewerken, dan zou dit je moeten lukken.
- Het is ook voor hen met iets meer ervaring, maar die hun eerste open source-bijdrage willen leveren, of meer bijdragen nodig hebben voor meer ervaring en zelfvertrouwen.

### Waarom moet ik dit doen?

Elke webontwikkelaar, aspirant of ervaren, moet "Git version control" gebruiken, en GitHub is de populairste Git hosting service die door iedereen wordt gebruikt. Het is ook het hart van de Open Source gemeenschap. Op je gemak raken met het gebruik van GitHub is een essentiële vaardigheid. Een bijdrage leveren aan een project versterkt je zelfvertrouwen en geeft je wat moois om te laten zien op je GitHub-profiel.
Als je een nieuwe ontwikkelaar bent en je vraagt je af of je met Git en GitHub moet leren omgaan, dan is hier het antwoord: [Je had gisteren Git moeten leren](https://codeburst.io/number-one-piece-of-advice-for-new-developers-ddd08abc8bfa 'New Developer? You should’ve learned Git yesterday. by Brandon Morelli, creator of CodeBurst.io').

### Wat zal ik gaan bijdragen?

![Contributor Card](/readme-only/card.PNG 'Contributor Card')

Je gaat een kaart zoals deze bijdragen aan deze [webpagina van het project](https://syknapse.github.io/Contribute-To-This-Project/ 'https://syknapse.github.io/Contribute-To-This-Project'). Het zal je naam bevatten, je Twitter- / X-naam, een korte beschrijving en 3 links naar nuttige bronnen voor webontwikkelaars, die je zou aanraden.

Je maakt een kopie van het kaartsjabloon in het HTML-bestand en past het aan met je eigen informatie.

---

### Vertalingen

Deze handleiding is ook beschikbaar in [andere talen](/translations/README.md)

| [Arabisch (عربي)](/translations/README/ARABIC.md) | [Bangla (বাংলা)](/translations/README/BANGLA.md) | [Chinees (Traditioneel) (繁體中文)](/translations/README/CHINESE_TRADITIONAL.md) | [Duits (Deutsch)](/translations/README/GERMAN.md) | [Engels (English)](/README.md)   
| :---------------------------------------------: | :---------------------------------------: | :-----------------------------------------: | :---------------------------------------: | :---------------------------------------: |
| [Frans (Français)](/translations/README/FRENCH.md) | [Hindi (हिंदी)](/translations/README/HINDI.md) | [Italiaans (Italiano)](/translations/README/ITALIAN.md) | [Japans (日本語)](/translations/README/JAPANESE.md) | [Koreaans (한국어)](/translations/README/KOREAN.md) |
  [Nederlands](/translations/README/DUTCH.md) | [Noors (Norsk)](/translations/README/NORWEGIAN.md) | [Oekraïens (українська)](/translations/README/UKRAINIAN.md) | [Pools (Polski)](/translations/README/POLISH.md) | [Portuguees (Portuguese)](/translations/README/PORTUGUESE.md) | [Russisch (Русский)](/translations/README/RUSSIAN.md) 
  [Servisch (Српски)](/translations/README/SERBIAN.md)  | [Spaans (Español)](/translations/README/SPANISH.md) | [Turks (Türkçe)](/translations/README/TURKISH.md)

> Vertalingen voor projectdocumentaties zijn welkom. Lees de [`Vertaalhandleiding`](/translations/README.md) om bij te dragen.

---

### Setup! :)

> [!Note]
> Deze handleiding is gebaseerd op GitHub Desktop. [Als je vertrouwd bent met een terminal, ga dan naar deze tutorial (Klik hier)](/terminal_tutorial.md)

Laten we ons eerst voorbereiden op het werk

1. Log in op je GitHub-account. Als je nog geen account heb, [maak dan een account aan](https://github.com/join). Ik raad je aan om de [GitHub Hello World tutorial](https://guides.github.com/activities/hello-world/) te doen voordat je verder gaat.
2. Download [GitHub Desktop](https://desktop.github.com/).
   - Als alternatief kun je Git ook op een terminal gebruiken [Hier is de link naar de CLI-handleiding](/terminal_tutorial.md).
   - Als je [VS Code](https://code.visualstudio.com/ 'Visual Studio Code website') gebruikt: het komt met geïntegreerde Git en stelt je in staat om direct vanuit de editor te doen wat nodig is.
   - Maar de eenvoudigste en makkelijkste manier om deze handleiding te volgen is door GitHub Desktop te gebruiken.

> Nu je alles hebt ingesteld, kunnen we verder gaan met het bijdragen aan het project.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

### Bijdragen

Word een open source-bijdrager in 10 makkelijke stappen.

_Geschatte tijd: Minder dan 30 minuten_.

#### Stap 1: Splits (fork) deze bron (repository)

- Het doel is hier om een kopie te maken van dit project en het in je eigen account te plaatsen.
- Een bron (repository of kortweg repo) is de benaming op Github van een project en een afsplitsing (fork) is een kopie daarvan.
- Zorg ervoor dat je op de [hoofdpagina](https://github.com/Syknapse/Contribute-To-This-Project 'https://github.com/Syknapse/Contribute-To-This-Project') van deze repo bent.

| ![Fork](/readme-only/fork.png "click on 'Fork'") |
| :---------------------------------------------: |
|         **Klik op de knop _Fork_**          |

- Je hebt nu een volledige kopie van het project in je eigen account.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 2: Kloon deze bron (repository)

- Nu willen we een lokale kopie van het project maken. Dat is een kopie die is opgeslagen op je eigen computer.
- Open GitHub Desktop. In het programma:

| ![Clone](/readme-only/clone.PNG 'click clone repository') |
| :------------------------------------------------------: |
|       **Klik op _File_ en dan _Clone repository_**        |

- Je ziet een lijst van je projecten en takken (branches) die je op GitHub hebt.
- Selecteer `<je-github-gebruikersnaam>/Contribute-To-This-Project`.
- Klik _Clone_

| ![Clone project](/readme-only/clone-project.PNG 'click on =your-github-username=/Contribute-To-This-Project') |
| :----------------------------------------------------------------------------------------------------------: |

| :arrow_right_hook: Een afgesplitst (forked) project zal het vorksymbool aan de linkerkant hebben. Je afsplitsing zal je eigen GitHubgebruikersnaam hebben. | ![your fork](/readme-only/clone-your-fork.PNG 'je afsplitsing zal er zo uitkomen te zien, met je eigen gebruikersnaam') |
| :------------------------------------------------------------------------------------------------------------------ | :----------------------------------------------------------------------------------------------------: |

- Dit zal eventjes duren, daar het project naar je harde schijf wordt gekopieerd. Ik raad aan om het standaard pad te gebruiken, dat meestal `..\Documents\GitHub` is.
- Nu heb je een lokale kopie van het project.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 3: Creëer een nieuwe tak (branch)

- Als de repo eenmaal afgesplitst (gecloned) is en je het open hebt staan in GitHub Desktop, is het tijd om een nieuwe tak(branch) te creëeren.
- Een aftaking maken is een manier om jouw veranderingen apart te houden van het hoofddeel van het project genaamd `Master`. Als er bijvoorbeeld dingen fout gaan en je niet blij bent met je veranderingen dan kan je gemakkelijk jouw tak verwijderen zonder dat dit alles het hoofdproject beïnvloedt.

| :arrow_right_hook: klik op _`Current branch`_, Klik daarna op _`New`_ | ![Create branch](/readme-only/branch-new.PNG "Klik op 'Branch', dan 'New'") |
| :---------------------------------------------------------------------------- | :-----------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Geef jouw tak een naam en klik daarna op `Create branch`** |                           ![Name branch](/readme-only/branch-name.PNG 'Geef je tak (branch) een naam')                            |
| :arrow_right_hook: **Publiceer je nieuwe tak naar to GitHub**                      | ![Name branch](/readme-only/branch-publish.PNG 'Klik publiceer om je nieuwe tak te verzenden naar je online GitHub bron (repo)') |

- Je kan je tak noemen wat je wilt, maar daar dit een tak is die de bedoeling heeft een kaart met je naam aan het project toe te voegen, is het een goede oefening om het `je-naam-card` te noemen daar dat de intentie van deze tak duidelijk maakt.
- Nu heb je een nieuwe tak (branch) gemaakt die gescheiden is van de hoofdtak (master branch).
- Voor de volgende stappen moet je er zeker van zijn dat je in deze branch werkt. Je zult de naam van de tak waarin je zit bovenaan in het midden van GitHub Desktop zien, waar het zegt _Current branch_.

**Werk NIET in de `master` tak (branch)**

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 4: Open het index.html bestand

- Nu moeten we het bestand openen dat we gaan bewerken met je favoriete bewerkingsprogramma voor code.
- Ga op zoek naar het mapje van het project op je computer. Als je die standaard had gelaten, zal het iets zijn zoals `je-computer > Documenten > GitHub > Contribute-To-This-Project`
- Het `index.html` bestand bevind zich direct in het `Contribute-To-This-Project` mapje.
- Open je bewerkingsprogramma voor code (Sublime, VS Code, Atom, etc.) en gebruik de `Open bestand` opdracht en zoek het index.html bestand op in de hoofdmap van het project

|                  ![Open index file](/readme-only/index-open.PNG 'Open index.html in je tekstbewerker')                   |
| :---------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Het is ook mogelijk om eerst het bestand op je harde schijf op te zoeken, rechtermuisknopklik, en open met je bewerker** |

- Nu heb je het bestand dat je gaat bewerken open in je bewerkingsprogramma en je bent klaar om veranderingen te gaan maken.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 5: Kopieer het HTML-kaartsjabloon

- We maken een kopie van het kaartsjabloon, zodat we ermee aan de slag kunnen.
- Direct binnen de `<body>` vind je een `<div class="container">` sectie, die een hoop andere secties bevat.
- De **eerste 2** secties beginnen exact met: `<div class="row">`. Klap ze samen door op de pijl aan de zijkant te klikken in je VS Code editor, zoals in de afbeelding hieronder. (Als u een andere editor gebruikt, kunt u deze functie mogelijk niet gebruiken. Je moet dan gewoon naar beneden scrollen). Het samenvouwen maakt het gemakkelijk om sommige codecomponenten te verbergen die je niet hoeft te veranderen.
- Je zou nu de sectie moeten zien die alle bijdragekaarten (kaarten die door anderen zijn bijgedragen) bevat: `<div class="grid" id="contributions">`

| ![Find card template](/readme-only/find-card-template.png 'Zoek de kaartsjabloon') |
| :-----------------------------------------------------------------------: |

- In deze sectie vindt u de sectie met het label `== TEMPLATE ==`
- Kopieer alles binnen het rode vierkant in de afbeelding, van de `Contributor card START` opmerking tot de `Contributor card END` opmerking

| ![Copy card template](/readme-only/card-copy.PNG 'Kopieer het kaartsjabloom') |
| :-----------------------------------------------------------------------: |

- Plak het geheel direct onder de opmerking die dit aangeeft; boven de kaart van de meest recente bijdrager.
- Zorg ervoor dat er een regel afstand is tussen het einde van je kaart en het begin van de laatste kaart. Voeg ook een regel toe tussen het begin van je kaart en de regel met de opmerking `=== Paste YOUR CARD directly BELOW this line ===`. Dit is een goede oefening om onze code zo duidelijk mogelijk te houden.
- Gebruik nooit linters of stijlopmaakprogramma's. Het project is mooier opgezet.

| ![Paste card template](/readme-only/card-paste.PNG 'Plak onder de aangegeven regel') |
| :---------------------------------------------------------------------------------: |

- Dit is nu **jouw** HTML-kaart, die je kan personaliseren en bewerken.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 6: Pas je wijzigingen toe

- We zullen nu beginnen de html-code te bewerken door de aanpasbare velden van je kaart te veranderen.

| :arrow_right_hook: Vervang 'Name' met je naam | ![Change name](/readme-only/change-name.PNG 'Type je naam') |
| :----------------------------------------------- | :----------------------------------------------------------: |

- **Let op: Wijzig niet `class="name"`**

| :arrow_right_hook: Voeg de URL van je Twitter- / X-account toe in `href="Insert URL here"`, Type je Twitternaam in het tekstvak | ![Change contact](/readme-only/change-contact.PNG 'Voeg een link naar je Twitter-account in en typ je gebruikersnaam') |
| :--------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------: |

- Als je liever een ander contact dan Twitter gebruikt, moet je het twitterpictogram vervangen `<i class="fa fa-x-twitter"></i>` door naar [Font Awesome Icons](http://fontawesome.io/icons/) te gaan en te zoeken voor het juiste icoontje en vervolgens alleen het `fa-x-twitter` deel te vervangen met het nieuwe icoontje, zoals bijvoorbeeld `fa-facebook`. Volg dan de bovenstaande stappen.

|                                                                                                                                         ![Change about](/readme-only/change-about.PNG 'Schrijf een zin die iets over jou verteld')                                                                                                                                          |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                                                                               :arrow_right_hook: **Vertel ons iets over jezelf. Houd het kort en bondig. Zie het meer als een tweet dan als een blogbericht.**                                                                                                                |
|                                                                                                              ![Change resources](/readme-only/change-resources.PNG 'Link invoegen, korte beschrijving schrijven en de naam van de bron typen')                                                                                                              |
| :arrow_right_hook: **Deel met de gemeenschap 3 koppelingen naar bronnen die nuttig zijn voor webontwikkeling. Dit kan van alles zijn, een video, een voordracht, een podcast, een artikel, een referentie of een programma. Laat je niet intimideren als je een beginner bent; deel alles wat je weet, zelfs als je denkt dat het basiskennis is. Je zult verbaasd zijn hoeveel mensen er baat bij zullen hebben.** |

- **Link:** Voeg de snelkoppeling toe in `href="here"` door het `#` te vervangen. Gebruik geen URL-verkorters of URL's die niet van de site zijn die je post!
- **Title:** Geef een korte omschrijving onder `title="here"`.
- **Name:** Schrijf de naam van de bron in het tekstvak `>here</a>`.
- Zorg ervoor dat je **alle wijzigingen opgeslagen hebt**..
- **Test je veranderingen**. DIT IS BELANGRIJKT! Open het html-bestand in je browser (door er bijvoorbeeld dubbel op te klikken) en kijk hoe je kaart er op de site uitziet. Kijk of de hele pagina er nog hetzelfde uitziet en of er niets verkeerd is gegaan. Klik op je snelkoppelingen en controleer of ze werken. Open de console (Ctrl + Shift + J (Windows / Linux) of Cmd + Opt + J (Mac)) en controleer of er geen foutmeldingen zijn.
- Geweldig, je bent klaar met het bewerken van je code! De volgende stappen zullen je wijzigingen naar GitHub sturen en ze dan indienen om samengevoegd te worden met het hoofdproject. 

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 7: Bevestig je wijzigingen

- Ga terug naar GitHub Desktop.
- Je wijzigingen zijn automatisch toegevoegd aan de voorbereidingsplaats (staging area).
- Dit betekent dat Git alle **opgeslagen** wijzigingen heeft vastgelegd.
- Je kunt dit terugzien in het programma. Alles wat je hebt toegevoegd aan het bestand wordt groen weergegeven en verwijderingen worden rood weergegeven.

|                                                                                                  ![Commit changes](/readme-only/commit.PNG "De wijzigingen die je hebt toegevoegd zouden in het groen moeten verschijnen aan de rechterkant van GitHub Desktop. De vastlegknop (commit button) bevindt zich linksonder")                                                                                                  |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: De volgende stap heet _`Commit`_. Dit betekent ongeveer `bevestig de wijzigingen` |
|                                                                                              ![Commit changes](/readme-only/commit-header.PNG "De wijzigingen die je hebt toegevoegd zouden in het groen moeten verschijnen aan de rechterkant van GitHub Desktop. De vastlegknop (commit button) bevindt zich linksonder")                                                                                               |
|                                                                            :arrow_right_hook: **Dit is hoe jouw GitHub Desktop header eruit zou moeten zien. Let op het vorksymbool naast de projectnaam in `Current repository`, je `Current branch` zal de naam hebben die je het in stap 3 hebt gegeven.**                                                                            |
|                                                                                                                  ![Write commit message and commit](/readme-only/commit-message.PNG "Schrijf een korte samenvatting van je veranderingen in de 'summary' invoer en klik op 'commit'")                                                                                                                  |
| :arrow_right_hook: **Om op _`Commit`_ te kunnen klikken, moet je het _`Summary`_ veld invullen. Dit is het vastleggingsbericht dat uitlegt wat je hebt veranderd. In dit geval zou `"Voeg mijn kaartgegevens toe"` een redelijk bericht zijn. Optioneel kun je een meer gedetailleerde _`Description`_ bijvoegen. Klik op de _`Commit`_ knop. Op je knop staat zoiets als `Commit to "your-branch-name"`** |

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 8: Publiceer (Push) je wijzigingen naar GitHub

- Je wijzigingen zijn nu opgeslagen of vastgelegd. Maar ze worden alleen lokaal opgeslagen, dat wil zeggen op je computer.
- Het synchroniseren van lokale wijzigingen met je bron (repository) op GitHub wordt een _Push_ genoemd. Je "duwt" de wijzigingen van je lokale repository naar de online bron op GitHub.

| :arrow_right_hook: Klik de _`Push`_ knop | ![Push to GitHub](/readme-only/push.PNG "Publiceer je wijzigingen naar GitHub, klik op de knop 'Push'") |
| :------------------------------------------- | :-----------------------------------------------------------------------------------------------: |

- Na een paar seconden is de operatie voltooid en nu heb je precies dezelfde kopie van deze tak (branch) op zowel je computer als op GitHub.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 9: Dien een PR(Pull Request) in

- Dit is het moment waar je op hebt gewacht: het indienen van een _Pull Request_ (PR).
- Tot nu toe is al het werk dat je gedaan hebt op je eigen tak van het project geweest, die zoals je je herinnert op je eigen account van GitHub staat.
- Nu is het tijd om je wijzigingen naar het hoofdproject te sturen zodat ze ermee samengevoegd kunnen worden.
- Dit wordt een [_Pull Request_](https://help.github.com/articles/about-pull-requests/ 'About Pull Requests - GitHub Help') genoemd, omdat je de originele projectontwikkelaar vraagt om jou veranderingen in zijn project op te nemen (to "pull").
- Ga naar de hoofdpagina van **je afsplitsing** op GitHub (het zal bovenaan het vork-icoon en je gebruikersnaam weergeven).
- Bovenaan de repo zie je een gemarkeerd pull request-bericht met een groene knop.

|  ![Submit a Pull Request](/readme-only/pull-request.PNG 'Dit staat meestal bovenaan de pagina, onder de beschrijving en boven de projectbestanden en -mappen.')  |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                                                    :arrow_right_hook: **Klik op `Compare and pull request`**                                                     |
| ![Open a Pull Request](/readme-only/pull-request-branches.PNG 'Je vraagt om je tak (branch) van je afsplitsing (fork) samen te voegen in de hoofdtak van het originele project') |
|                                              :arrow_right_hook: Dit is hoe de `Open a pull request` webpagina eruit ziet.                                               |

- ONTHOUD dat _je probeert je tak (branch) samen te voegen met het originele project, niet met de `Master` tak van je afsplitsing (fork)_.
- De afbeelding hieronder geeft je een idee van hoe de header van je pull request eruit zou moeten zien.
- Aan de linkerkant staat het originele project, gevolgd door de hoofdtak. Aan de rechterkant staat je afsplitsing (fork) en de tak (branch) die je gemaakt hebt.

|                   ![Submit a Pull Request](/readme-only/pull-request-open.PNG "Klik op de groene knop. Wees niet bang!")                    |
| :-----------------------------------------------------------------------------------------------------------------------------------------: |
| :arrow_right_hook: **Maak een pull request: Schrijf een titel, voeg optionele informatie toe in de beschrijving en klik op `Create pull request`** |

- Laat je niet afschrikken door alle opties. Je hoeft voorlopig alleen deze drie stappen uit te voeren.
- Laat de optie `Allow edits from maintainers` aangevinkt.
- Nu wordt er een _Pull Request_ naar de projectbeheerder gestuurd. Zodra het is bekeken en geaccepteerd, verschijnen je wijzigingen op de [webpagina van het project](https://syknapse.github.io/Contribute-To-This-Project 'Draag bij aan deze project webpagina').

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

#### Stap 10: Vier feest

Dat is het. Je hebt het gedaan! Je hebt nu bijgedragen aan open source op GitHub.

Je hebt code toegevoegd aan een live webpagina: [https://syknapse.github.io/Contribute-To-This-Project](https://syknapse.github.io/Contribute-To-This-Project)

Je wijzigingen **zullen niet meteen zichtbaar zijn**; ze moeten eerst bekeken, geaccepteerd en samengevoegd worden door de projectbeheerder. Zodra ze zijn samengevoegd zou je kaart zichtbaar moeten zijn en live op de pagina moeten staan.

Het is heel normaal dat een reviewer vraagt om wijzigingen in een PR. Zie het als een goede oefening als het jou overkomt. Houd commentaar en aangevraagde wijzigingen in de gaten. Zodra je de gevraagde wijzigingen hebt doorgevoerd ( op jouw tak (branch)) hoef je alleen nog maar je wijzigingen vast te leggen en te publiceren (pushen). De PR zal automatisch bijgewerkt worden met de nieuwe wijzigingen.

Ik beloof dat ik zal proberen zo snel mogelijk te reviewen en samen te voegen, maar ik doe dit in mijn vrije tijd, dus een paar dagen vertraging is onvermijdelijk.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---

### Volgende stappen

- Kom over een tijdje terug om te kijken of je Pull Request is gefuseerd.
- Je zou een e-mail van GitHub moeten ontvangen als je wijzigingen zijn goedgekeurd, of als er om extra wijzigingen wordt gevraagd. En ook als de PR uiteindelijk is samengevoegd met de hoofdmap en je kaart is toegevoegd.
- Je kunt ook leren hoe je kunt bijdragen met behulp van deze _gratis_ serie: [How to Contribute to an Open Source Project on GitHub](https://kcd.im/pull-request)
- Als je dit project **bruikbaar** vond, geef het dan een :star: ster :star: bovenaan de pagina en **Tweet** erover om het nieuws te helpen verspreiden [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)][twit]
- Je kunt je aansluiten bij onze [Discord server](https://discord.gg/tWkvS4ueVF)
- Je kunt me **volgen** en contact opnemen op via [𝕏 (Twitter)](https://twitter.com/Syknapse '@Syknapse') of [een van deze andere optie te gebruiken](https://syknapse.github.io/Syk-Houdeib/#contact 'My contact section | Portfolio')
- Dit is een open source project, dus naast het bijdragen van je kaart ben je welkom om te helpen bij het oplossen van fouten, het maken van verbeteringen of het toevoegen van nieuwe functies. Open een [issue](https://help.github.com/articles/creating-an-issue/ 'Mastering Issues | GitHub Guides') of begin a nieuw [pull request](https://help.github.com/articles/creating-a-pull-request-from-a-fork/ 'Creating a pull request from a fork | GitHub Help')
- Om onze community te helpen verbeteren, kun je een kijkje nemen op het GitHub [Discussies](https://github.com/Syknapse/Contribute-To-This-Project/discussions) tabblad dat zich naast die van de Pull Requests bevindt. Dit is een plaats om jezelf voor te stellen, dieper in te gaan op discussies over Open Source en te communiceren met de projectbeheerders. Wil je ons helpen deze functie uit te bouwen en onze gemeenschap te versterken?
- **Dank voor je bijdrage aan dit project**. Nu kun je proberen bij te dragen aan andere projecten; zoek naar de ![Good First Issue](https://user-images.githubusercontent.com/29199184/33852733-e23b7070-debb-11e7-907b-4e7a03aad436.png) label voor beginnersvriendelijke bijdrageopties.
- Ik ben ook op zoek naar medewerkers die me kunnen helpen met het reviewen en samenvoegen van PR's. Als je meer geavanceerde Git oefeningen wilt, lees dan de [beheerdershandleiding](/maintainer_guide.md), sluit je aan bij onze [Discord server](https://discord.gg/tWkvS4ueVF), en vraag om aan te sluiten bij het team van de projectbeheerders.

[↑ Ga naar boven ↑](#snelle-toegangsindex)

---
### Dankbetuigingen

Dit project is erg beïnvloed door [Roshan Jossey's](https://github.com/Roshanjossey) geweldige [first-contributions](https://github.com/Roshanjossey/first-contributions) project met zijn uitstekende handleiding.

Het is ook bijzonder geïnspireerd door de geweldige gemeenschap rond [#GoogleUdacityScholars](https://twitter.com/hashtag/GoogleUdacityScholars?src=hash) The Google Challenge Scholarship: Front-End Web Dev, class of 2017 Europe.

### Licensie

Dit project is gelicentieerd onder de [MIT License](./LICENSE).

### Top 100 bijdragers

[![GitHub Contributors Image](https://contrib.rocks/image?repo=Syknapse/Contribute-To-This-Project)](https://github.com/Syknapse/Contribute-To-This-Project/graphs/contributors)

[Terug naar boven &uparrow;](#introductie)

[twit]: https://twitter.com/intent/tweet?text=Contribute%20To%20This%20Project.%20An%20easy%20project%20for%20first-time%20contributors,%20with%20a%20full%20tutorial.%20By%20@Syknapse&url=https://github.com/Syknapse/Contribute-To-This-Project&hashtags=100DaysofCode 'Tweet this project'
