//
//  Prespecialize.swift
//
//  The MIT License
//  Copyright (c) 2015 - 2024 Susan Cheng. All rights reserved.
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.
//

@inline(never)
private func consume<T>(_ t: T) {
    withExtendedLifetime(t) { t in }
}

@usableFromInline
internal func _prespecialize() {
    
    consume(ColorSpace<CMYColorModel>.self)
    consume(ColorSpace<CMYKColorModel>.self)
    consume(ColorSpace<Device2ColorModel>.self)
    consume(ColorSpace<Device3ColorModel>.self)
    consume(ColorSpace<Device4ColorModel>.self)
    consume(ColorSpace<Device5ColorModel>.self)
    consume(ColorSpace<Device6ColorModel>.self)
    consume(ColorSpace<Device7ColorModel>.self)
    consume(ColorSpace<Device8ColorModel>.self)
    consume(ColorSpace<Device9ColorModel>.self)
    consume(ColorSpace<DeviceAColorModel>.self)
    consume(ColorSpace<DeviceBColorModel>.self)
    consume(ColorSpace<DeviceCColorModel>.self)
    consume(ColorSpace<DeviceDColorModel>.self)
    consume(ColorSpace<DeviceEColorModel>.self)
    consume(ColorSpace<DeviceFColorModel>.self)
    consume(ColorSpace<GrayColorModel>.self)
    consume(ColorSpace<LabColorModel>.self)
    consume(ColorSpace<LuvColorModel>.self)
    consume(ColorSpace<RGBColorModel>.self)
    consume(ColorSpace<XYZColorModel>.self)
    consume(ColorSpace<YCbCrColorModel>.self)
    consume(ColorSpace<YxyColorModel>.self)
    
    consume(Color<CMYColorModel>.self)
    consume(Color<CMYKColorModel>.self)
    consume(Color<Device2ColorModel>.self)
    consume(Color<Device3ColorModel>.self)
    consume(Color<Device4ColorModel>.self)
    consume(Color<Device5ColorModel>.self)
    consume(Color<Device6ColorModel>.self)
    consume(Color<Device7ColorModel>.self)
    consume(Color<Device8ColorModel>.self)
    consume(Color<Device9ColorModel>.self)
    consume(Color<DeviceAColorModel>.self)
    consume(Color<DeviceBColorModel>.self)
    consume(Color<DeviceCColorModel>.self)
    consume(Color<DeviceDColorModel>.self)
    consume(Color<DeviceEColorModel>.self)
    consume(Color<DeviceFColorModel>.self)
    consume(Color<GrayColorModel>.self)
    consume(Color<LabColorModel>.self)
    consume(Color<LuvColorModel>.self)
    consume(Color<RGBColorModel>.self)
    consume(Color<XYZColorModel>.self)
    consume(Color<YCbCrColorModel>.self)
    consume(Color<YxyColorModel>.self)
    
    consume(Float16ColorPixel<CMYColorModel>.self)
    consume(Float16ColorPixel<CMYKColorModel>.self)
    consume(Float16ColorPixel<Device2ColorModel>.self)
    consume(Float16ColorPixel<Device3ColorModel>.self)
    consume(Float16ColorPixel<Device4ColorModel>.self)
    consume(Float16ColorPixel<Device5ColorModel>.self)
    consume(Float16ColorPixel<Device6ColorModel>.self)
    consume(Float16ColorPixel<Device7ColorModel>.self)
    consume(Float16ColorPixel<Device8ColorModel>.self)
    consume(Float16ColorPixel<Device9ColorModel>.self)
    consume(Float16ColorPixel<DeviceAColorModel>.self)
    consume(Float16ColorPixel<DeviceBColorModel>.self)
    consume(Float16ColorPixel<DeviceCColorModel>.self)
    consume(Float16ColorPixel<DeviceDColorModel>.self)
    consume(Float16ColorPixel<DeviceEColorModel>.self)
    consume(Float16ColorPixel<DeviceFColorModel>.self)
    consume(Float16ColorPixel<GrayColorModel>.self)
    consume(Float16ColorPixel<LabColorModel>.self)
    consume(Float16ColorPixel<LuvColorModel>.self)
    consume(Float16ColorPixel<RGBColorModel>.self)
    consume(Float16ColorPixel<XYZColorModel>.self)
    consume(Float16ColorPixel<YCbCrColorModel>.self)
    consume(Float16ColorPixel<YxyColorModel>.self)
    
    consume(Float32ColorPixel<CMYColorModel>.self)
    consume(Float32ColorPixel<CMYKColorModel>.self)
    consume(Float32ColorPixel<Device2ColorModel>.self)
    consume(Float32ColorPixel<Device3ColorModel>.self)
    consume(Float32ColorPixel<Device4ColorModel>.self)
    consume(Float32ColorPixel<Device5ColorModel>.self)
    consume(Float32ColorPixel<Device6ColorModel>.self)
    consume(Float32ColorPixel<Device7ColorModel>.self)
    consume(Float32ColorPixel<Device8ColorModel>.self)
    consume(Float32ColorPixel<Device9ColorModel>.self)
    consume(Float32ColorPixel<DeviceAColorModel>.self)
    consume(Float32ColorPixel<DeviceBColorModel>.self)
    consume(Float32ColorPixel<DeviceCColorModel>.self)
    consume(Float32ColorPixel<DeviceDColorModel>.self)
    consume(Float32ColorPixel<DeviceEColorModel>.self)
    consume(Float32ColorPixel<DeviceFColorModel>.self)
    consume(Float32ColorPixel<GrayColorModel>.self)
    consume(Float32ColorPixel<LabColorModel>.self)
    consume(Float32ColorPixel<LuvColorModel>.self)
    consume(Float32ColorPixel<RGBColorModel>.self)
    consume(Float32ColorPixel<XYZColorModel>.self)
    consume(Float32ColorPixel<YCbCrColorModel>.self)
    consume(Float32ColorPixel<YxyColorModel>.self)
    
    consume(Float64ColorPixel<CMYColorModel>.self)
    consume(Float64ColorPixel<CMYKColorModel>.self)
    consume(Float64ColorPixel<Device2ColorModel>.self)
    consume(Float64ColorPixel<Device3ColorModel>.self)
    consume(Float64ColorPixel<Device4ColorModel>.self)
    consume(Float64ColorPixel<Device5ColorModel>.self)
    consume(Float64ColorPixel<Device6ColorModel>.self)
    consume(Float64ColorPixel<Device7ColorModel>.self)
    consume(Float64ColorPixel<Device8ColorModel>.self)
    consume(Float64ColorPixel<Device9ColorModel>.self)
    consume(Float64ColorPixel<DeviceAColorModel>.self)
    consume(Float64ColorPixel<DeviceBColorModel>.self)
    consume(Float64ColorPixel<DeviceCColorModel>.self)
    consume(Float64ColorPixel<DeviceDColorModel>.self)
    consume(Float64ColorPixel<DeviceEColorModel>.self)
    consume(Float64ColorPixel<DeviceFColorModel>.self)
    consume(Float64ColorPixel<GrayColorModel>.self)
    consume(Float64ColorPixel<LabColorModel>.self)
    consume(Float64ColorPixel<LuvColorModel>.self)
    consume(Float64ColorPixel<RGBColorModel>.self)
    consume(Float64ColorPixel<XYZColorModel>.self)
    consume(Float64ColorPixel<YCbCrColorModel>.self)
    consume(Float64ColorPixel<YxyColorModel>.self)
    
    consume(Image<Float16ColorPixel<CMYColorModel>>.self)
    consume(Image<Float16ColorPixel<CMYKColorModel>>.self)
    consume(Image<Float16ColorPixel<Device2ColorModel>>.self)
    consume(Image<Float16ColorPixel<Device3ColorModel>>.self)
    consume(Image<Float16ColorPixel<Device4ColorModel>>.self)
    consume(Image<Float16ColorPixel<Device5ColorModel>>.self)
    consume(Image<Float16ColorPixel<Device6ColorModel>>.self)
    consume(Image<Float16ColorPixel<Device7ColorModel>>.self)
    consume(Image<Float16ColorPixel<Device8ColorModel>>.self)
    consume(Image<Float16ColorPixel<Device9ColorModel>>.self)
    consume(Image<Float16ColorPixel<DeviceAColorModel>>.self)
    consume(Image<Float16ColorPixel<DeviceBColorModel>>.self)
    consume(Image<Float16ColorPixel<DeviceCColorModel>>.self)
    consume(Image<Float16ColorPixel<DeviceDColorModel>>.self)
    consume(Image<Float16ColorPixel<DeviceEColorModel>>.self)
    consume(Image<Float16ColorPixel<DeviceFColorModel>>.self)
    consume(Image<Float16ColorPixel<GrayColorModel>>.self)
    consume(Image<Float16ColorPixel<LabColorModel>>.self)
    consume(Image<Float16ColorPixel<LuvColorModel>>.self)
    consume(Image<Float16ColorPixel<RGBColorModel>>.self)
    consume(Image<Float16ColorPixel<XYZColorModel>>.self)
    consume(Image<Float16ColorPixel<YCbCrColorModel>>.self)
    consume(Image<Float16ColorPixel<YxyColorModel>>.self)
    
    consume(Image<Float32ColorPixel<CMYColorModel>>.self)
    consume(Image<Float32ColorPixel<CMYKColorModel>>.self)
    consume(Image<Float32ColorPixel<Device2ColorModel>>.self)
    consume(Image<Float32ColorPixel<Device3ColorModel>>.self)
    consume(Image<Float32ColorPixel<Device4ColorModel>>.self)
    consume(Image<Float32ColorPixel<Device5ColorModel>>.self)
    consume(Image<Float32ColorPixel<Device6ColorModel>>.self)
    consume(Image<Float32ColorPixel<Device7ColorModel>>.self)
    consume(Image<Float32ColorPixel<Device8ColorModel>>.self)
    consume(Image<Float32ColorPixel<Device9ColorModel>>.self)
    consume(Image<Float32ColorPixel<DeviceAColorModel>>.self)
    consume(Image<Float32ColorPixel<DeviceBColorModel>>.self)
    consume(Image<Float32ColorPixel<DeviceCColorModel>>.self)
    consume(Image<Float32ColorPixel<DeviceDColorModel>>.self)
    consume(Image<Float32ColorPixel<DeviceEColorModel>>.self)
    consume(Image<Float32ColorPixel<DeviceFColorModel>>.self)
    consume(Image<Float32ColorPixel<GrayColorModel>>.self)
    consume(Image<Float32ColorPixel<LabColorModel>>.self)
    consume(Image<Float32ColorPixel<LuvColorModel>>.self)
    consume(Image<Float32ColorPixel<RGBColorModel>>.self)
    consume(Image<Float32ColorPixel<XYZColorModel>>.self)
    consume(Image<Float32ColorPixel<YCbCrColorModel>>.self)
    consume(Image<Float32ColorPixel<YxyColorModel>>.self)
    
    consume(Image<Float64ColorPixel<CMYColorModel>>.self)
    consume(Image<Float64ColorPixel<CMYKColorModel>>.self)
    consume(Image<Float64ColorPixel<Device2ColorModel>>.self)
    consume(Image<Float64ColorPixel<Device3ColorModel>>.self)
    consume(Image<Float64ColorPixel<Device4ColorModel>>.self)
    consume(Image<Float64ColorPixel<Device5ColorModel>>.self)
    consume(Image<Float64ColorPixel<Device6ColorModel>>.self)
    consume(Image<Float64ColorPixel<Device7ColorModel>>.self)
    consume(Image<Float64ColorPixel<Device8ColorModel>>.self)
    consume(Image<Float64ColorPixel<Device9ColorModel>>.self)
    consume(Image<Float64ColorPixel<DeviceAColorModel>>.self)
    consume(Image<Float64ColorPixel<DeviceBColorModel>>.self)
    consume(Image<Float64ColorPixel<DeviceCColorModel>>.self)
    consume(Image<Float64ColorPixel<DeviceDColorModel>>.self)
    consume(Image<Float64ColorPixel<DeviceEColorModel>>.self)
    consume(Image<Float64ColorPixel<DeviceFColorModel>>.self)
    consume(Image<Float64ColorPixel<GrayColorModel>>.self)
    consume(Image<Float64ColorPixel<LabColorModel>>.self)
    consume(Image<Float64ColorPixel<LuvColorModel>>.self)
    consume(Image<Float64ColorPixel<RGBColorModel>>.self)
    consume(Image<Float64ColorPixel<XYZColorModel>>.self)
    consume(Image<Float64ColorPixel<YCbCrColorModel>>.self)
    consume(Image<Float64ColorPixel<YxyColorModel>>.self)
    
    consume(Image<Gray16ColorPixel>.self)
    consume(Image<Gray32ColorPixel>.self)
    
    consume(Image<ABGR32ColorPixel>.self)
    consume(Image<ARGB32ColorPixel>.self)
    consume(Image<ARGB64ColorPixel>.self)
    consume(Image<BGRA32ColorPixel>.self)
    consume(Image<RGBA32ColorPixel>.self)
    consume(Image<RGBA64ColorPixel>.self)
    
    consume(Texture<Float16ColorPixel<CMYColorModel>>.self)
    consume(Texture<Float16ColorPixel<CMYKColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device2ColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device3ColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device4ColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device5ColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device6ColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device7ColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device8ColorModel>>.self)
    consume(Texture<Float16ColorPixel<Device9ColorModel>>.self)
    consume(Texture<Float16ColorPixel<DeviceAColorModel>>.self)
    consume(Texture<Float16ColorPixel<DeviceBColorModel>>.self)
    consume(Texture<Float16ColorPixel<DeviceCColorModel>>.self)
    consume(Texture<Float16ColorPixel<DeviceDColorModel>>.self)
    consume(Texture<Float16ColorPixel<DeviceEColorModel>>.self)
    consume(Texture<Float16ColorPixel<DeviceFColorModel>>.self)
    consume(Texture<Float16ColorPixel<GrayColorModel>>.self)
    consume(Texture<Float16ColorPixel<LabColorModel>>.self)
    consume(Texture<Float16ColorPixel<LuvColorModel>>.self)
    consume(Texture<Float16ColorPixel<RGBColorModel>>.self)
    consume(Texture<Float16ColorPixel<XYZColorModel>>.self)
    consume(Texture<Float16ColorPixel<YCbCrColorModel>>.self)
    consume(Texture<Float16ColorPixel<YxyColorModel>>.self)
    
    consume(Texture<Float32ColorPixel<CMYColorModel>>.self)
    consume(Texture<Float32ColorPixel<CMYKColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device2ColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device3ColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device4ColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device5ColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device6ColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device7ColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device8ColorModel>>.self)
    consume(Texture<Float32ColorPixel<Device9ColorModel>>.self)
    consume(Texture<Float32ColorPixel<DeviceAColorModel>>.self)
    consume(Texture<Float32ColorPixel<DeviceBColorModel>>.self)
    consume(Texture<Float32ColorPixel<DeviceCColorModel>>.self)
    consume(Texture<Float32ColorPixel<DeviceDColorModel>>.self)
    consume(Texture<Float32ColorPixel<DeviceEColorModel>>.self)
    consume(Texture<Float32ColorPixel<DeviceFColorModel>>.self)
    consume(Texture<Float32ColorPixel<GrayColorModel>>.self)
    consume(Texture<Float32ColorPixel<LabColorModel>>.self)
    consume(Texture<Float32ColorPixel<LuvColorModel>>.self)
    consume(Texture<Float32ColorPixel<RGBColorModel>>.self)
    consume(Texture<Float32ColorPixel<XYZColorModel>>.self)
    consume(Texture<Float32ColorPixel<YCbCrColorModel>>.self)
    consume(Texture<Float32ColorPixel<YxyColorModel>>.self)
    
    consume(Texture<Float64ColorPixel<CMYColorModel>>.self)
    consume(Texture<Float64ColorPixel<CMYKColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device2ColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device3ColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device4ColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device5ColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device6ColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device7ColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device8ColorModel>>.self)
    consume(Texture<Float64ColorPixel<Device9ColorModel>>.self)
    consume(Texture<Float64ColorPixel<DeviceAColorModel>>.self)
    consume(Texture<Float64ColorPixel<DeviceBColorModel>>.self)
    consume(Texture<Float64ColorPixel<DeviceCColorModel>>.self)
    consume(Texture<Float64ColorPixel<DeviceDColorModel>>.self)
    consume(Texture<Float64ColorPixel<DeviceEColorModel>>.self)
    consume(Texture<Float64ColorPixel<DeviceFColorModel>>.self)
    consume(Texture<Float64ColorPixel<GrayColorModel>>.self)
    consume(Texture<Float64ColorPixel<LabColorModel>>.self)
    consume(Texture<Float64ColorPixel<LuvColorModel>>.self)
    consume(Texture<Float64ColorPixel<RGBColorModel>>.self)
    consume(Texture<Float64ColorPixel<XYZColorModel>>.self)
    consume(Texture<Float64ColorPixel<YCbCrColorModel>>.self)
    consume(Texture<Float64ColorPixel<YxyColorModel>>.self)
    
    consume(Texture<Gray16ColorPixel>.self)
    consume(Texture<Gray32ColorPixel>.self)
    
    consume(Texture<ABGR32ColorPixel>.self)
    consume(Texture<ARGB32ColorPixel>.self)
    consume(Texture<ARGB64ColorPixel>.self)
    consume(Texture<BGRA32ColorPixel>.self)
    consume(Texture<RGBA32ColorPixel>.self)
    consume(Texture<RGBA64ColorPixel>.self)
    
    consume(ImageContext<Float16ColorPixel<CMYColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<CMYKColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device2ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device3ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device4ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device5ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device6ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device7ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device8ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<Device9ColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<DeviceAColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<DeviceBColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<DeviceCColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<DeviceDColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<DeviceEColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<DeviceFColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<GrayColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<LabColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<LuvColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<RGBColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<XYZColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<YCbCrColorModel>>.self)
    consume(ImageContext<Float16ColorPixel<YxyColorModel>>.self)
    
    consume(ImageContext<Float32ColorPixel<CMYColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<CMYKColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device2ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device3ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device4ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device5ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device6ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device7ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device8ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<Device9ColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<DeviceAColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<DeviceBColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<DeviceCColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<DeviceDColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<DeviceEColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<DeviceFColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<GrayColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<LabColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<LuvColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<RGBColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<XYZColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<YCbCrColorModel>>.self)
    consume(ImageContext<Float32ColorPixel<YxyColorModel>>.self)
    
    consume(ImageContext<Float64ColorPixel<CMYColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<CMYKColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device2ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device3ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device4ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device5ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device6ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device7ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device8ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<Device9ColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<DeviceAColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<DeviceBColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<DeviceCColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<DeviceDColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<DeviceEColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<DeviceFColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<GrayColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<LabColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<LuvColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<RGBColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<XYZColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<YCbCrColorModel>>.self)
    consume(ImageContext<Float64ColorPixel<YxyColorModel>>.self)
    
    consume(ImageContext<Gray16ColorPixel>.self)
    consume(ImageContext<Gray32ColorPixel>.self)
    
    consume(ImageContext<ABGR32ColorPixel>.self)
    consume(ImageContext<ARGB32ColorPixel>.self)
    consume(ImageContext<ARGB64ColorPixel>.self)
    consume(ImageContext<BGRA32ColorPixel>.self)
    consume(ImageContext<RGBA32ColorPixel>.self)
    consume(ImageContext<RGBA64ColorPixel>.self)
    
    consume(StencilTexture<float16>.self)
    consume(StencilTexture<Float32>.self)
    consume(StencilTexture<Float64>.self)
}
