//
//  ARGB64ColorPixel.swift
//
//  The MIT License
//  Copyright (c) 2015 - 2024 Susan Cheng. All rights reserved.
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.
//

@frozen
public struct ARGB64ColorPixel: _RGBColorPixel {
    
    public var a: UInt16
    public var r: UInt16
    public var g: UInt16
    public var b: UInt16
    
    @inlinable
    @inline(__always)
    public init(red: UInt16, green: UInt16, blue: UInt16, opacity: UInt16 = 0xFFFF) {
        self.a = opacity
        self.r = red
        self.g = green
        self.b = blue
    }
    
    @inlinable
    @inline(__always)
    public init(_ hex: UInt64) {
        self.a = UInt16((hex >> 48) & 0xFFFF)
        self.r = UInt16((hex >> 32) & 0xFFFF)
        self.g = UInt16((hex >> 16) & 0xFFFF)
        self.b = UInt16(hex & 0xFFFF)
    }
}
