Contributing
============

Below are the guidelines for getting started when contributing to Strider
and any related plugins. Contributions don't need to be code based, you are
encouraged to help out with issues by answering questions or just following up.
We also have documentation that needs to be written/updated, so feel free to contribute
there as well.

## Technology Stack

Here are the technologies to be familiar with:
- [ember](https://emberjs.com) see clients/strider-ui
- [tailwind](https://tailwindcss.com)
- [express](http://expressjs.com)
- [angular](http://angularjs.com) legacy, see apps/strider/client
  - [less css](http://lesscss.org) legacy
  - [twitter bootstrap](http://twitter.github.io/bootstrap) legacy

## Setup

How to get setup (if you're using docker, see the [Docker section in the README][docker], you can skip this):

- grab the repo
- Install Rush (https://rushjs.io/pages/intro/get_started/)
- `rush install`
- `cd apps/strider && bower install`
- `rush build` or `rush watch`
- run the tests with `npm test` to make sure your environment is setup
  properly. If you don't have it already, install
  [mongodb]. You could also
  develop using an externally hosted mongodb if you want, just set `DB_URI`.

## Troubleshooting

- Issues with `rush install`
Run `rush purge` and delete the `common/config/rush/pnpm-lock.yaml`, than run `rush update`

## Making Code Contributions

**Note:**: **Don't** make changes to the compiled files in the `dist/` directory, those
are generated by using `rush build` or `rush watch`. Most of the relavent files are
either in `clients/strider-ui/app` or `apps/strider/lib/` directories and that's where your changes should happen.

### Client-Side Dependencies

Use of Bower is legacy and no new items should be added for bower.

After installing Bower dependencies, make sure that `npm run vendor` copies all the needed files.
If not, you can add the needed files in the `"install"` section of `bower.json`.

## Pull Requests

Before submitting pull requests, please run `npm test` to make sure you didn't
break anything. If you're adding or changing backend functionality, include tests.

If you're adding or changing the front-end, please include one or more
explanatory screenshots in the pull request.

[docker]: https://github.com/Strider-CD/strider#docker-quickstart
[mongodb]: http://docs.mongodb.org/manual/installation/
