"""Add status col to uploads table

Revision ID: eab5bf7ec514
Revises: 45e43cb617f2
Create Date: 2024-06-26 14:00:46.079456

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'eab5bf7ec514'
down_revision = '45e43cb617f2'
branch_labels = None
depends_on = None

upload_status_enum = sa.Enum('IN_PROGRESS', 'COMPLETED', name='uploadstatus')

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    upload_status_enum.create(op.get_bind(), checkfirst=True)
    
    op.add_column('upload', sa.Column('status', sa.Enum('IN_PROGRESS', 'COMPLETED', name='uploadstatus'), nullable=False, server_default='COMPLETED'))
    op.alter_column('upload', 'status', server_default=None)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('upload', 'status')
    
    upload_status_enum.drop(op.get_bind(), checkfirst=True)
    # ### end Alembic commands ###
