"""Add checkpoints table

Revision ID: 6fa42be09dd2
Revises: 3a8a5f819c5f
Create Date: 2024-05-26 02:42:53.431421

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects.postgresql import UUID


# revision identifiers, used by Alembic.
revision = '6fa42be09dd2'
down_revision = '3a8a5f819c5f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('checkpoints',
    sa.Column('thread_id', UUID(as_uuid=True), nullable=False),
    sa.Column('thread_ts', UUID(as_uuid=True), nullable=False),
    sa.Column('parent_ts', UUID(as_uuid=True), nullable=True),
    sa.Column('checkpoint', sa.LargeBinary(), nullable=False),
    sa.Column('metadata', sa.LargeBinary(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['thread_id'], ['thread.id'], ),
    sa.PrimaryKeyConstraint('thread_id', 'thread_ts')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('checkpoints')
    # ### end Alembic commands ###
