"""Add interrupt column in members table

Revision ID: 3b4636df4c6d
Revises: b922e3e826e9
Create Date: 2024-05-25 01:04:31.805491

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes


# revision identifiers, used by Alembic.
revision = '3b4636df4c6d'
down_revision = 'b922e3e826e9'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    # Add the new column without the NOT NULL constraint
    op.add_column('member', sa.Column('interrupt', sa.Boolean(), nullable=True))
    # Set the default value for existing rows
    op.execute('UPDATE member SET interrupt = FALSE WHERE interrupt IS NULL')
    # Alter the column to add the NOT NULL constraint
    op.alter_column('member', 'interrupt', nullable=False, server_default=sa.false())
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('member', 'interrupt')
    # ### end Alembic commands ###
