"""Create writes table

Revision ID: 0a354b5c6f6c
Revises: bfa5449b6bba
Create Date: 2024-07-15 06:08:02.686420

"""
from alembic import op
import sqlalchemy as sa
import sqlmodel.sql.sqltypes
from sqlalchemy.dialects.postgresql import UUID


# revision identifiers, used by Alembic.
revision = '0a354b5c6f6c'
down_revision = 'bfa5449b6bba'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('writes',
    sa.Column('thread_id', UUID(as_uuid=True), nullable=False),
    sa.Column('thread_ts', UUID(as_uuid=True), nullable=False),
    sa.Column('task_id', UUID(as_uuid=True), nullable=False),
    sa.Column('idx', sa.Integer(), nullable=False),
    sa.Column('channel', sqlmodel.sql.sqltypes.AutoString(), nullable=False),
    sa.Column('value', sa.LargeBinary(), nullable=False),
    sa.ForeignKeyConstraint(['thread_id'], ['thread.id'], ),
    sa.PrimaryKeyConstraint('thread_id', 'thread_ts', 'task_id', 'idx')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('writes')
    # ### end Alembic commands ###
