# Tribe Code of Conduct

## Our Pledge

We, the community of contributors and users of Tribe, pledge to create a welcoming and inclusive environment for everyone. We are committed to fostering a respectful and harassment-free space where diverse ideas and perspectives can thrive.

## Expected Behavior

To contribute to a positive and inclusive atmosphere, we expect all participants, including contributors, users, and maintainers, to:

1. Be respectful and considerate: Treat others with kindness, respect, and empathy. Recognize and embrace diversity in backgrounds, experiences, and opinions.

2. Be inclusive: Welcome and support people of all backgrounds, identities, and abilities. Avoid any form of discrimination or exclusionary behavior.

3. Listen actively: Pay attention to others' ideas, experiences, and feedback. Be open to constructive criticism and different points of view.

4. Show empathy: Understand that people may have different cultural norms, communication styles, and perspectives. Be patient and considerate when engaging with others.

5. Resolve conflicts constructively: Disagreements and conflicts are natural, but we encourage participants to address them in a respectful and solution-oriented manner. Avoid personal attacks and name-calling.

6. Use clear and inclusive language: Use language that is respectful, inclusive, and considerate of all participants. Avoid offensive, derogatory, or discriminatory language.

## Unacceptable Behavior

The following behaviors are considered unacceptable and will not be tolerated within the Tribe community:

1. Harassment: Any form of harassment, including but not limited to offensive comments, slurs, intimidation, or unwelcome advances, is strictly prohibited.

2. Discrimination: Discriminatory actions or comments based on race, ethnicity, nationality, gender, gender identity, sexual orientation, disability, religion, age, or any other characteristic will not be tolerated.

3. Hate speech: Hate speech, promoting violence, or advocating harm towards individuals or groups based on their identity is not allowed.

4. Personal attacks: Engaging in personal attacks, insults, or trolling of others within the community is unacceptable.

5. Disruptive behavior: Deliberate disruption of discussions, events, or community activities is discouraged.

## Reporting Violations

If you witness or experience behavior that violates this code of conduct, please report it promptly to the project maintainers by contacting [jerron@wovenblocks.com](jerron@wovenblocks.com).
All reports will be treated with confidentiality, and the project maintainers will take appropriate action as necessary to address violations. We are committed to providing a safe and welcoming environment for all participants.

## Enforcement

Enforcement of this code of conduct will be carried out in a fair and just manner. Depending on the severity and frequency of violations, consequences may include warnings, temporary or permanent bans from the community, or other appropriate actions.

## Attribution

This code of conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 2.0, available at https://www.contributor-covenant.org/version/2/0/code_of_conduct.html.