// The symbol 'Environment' is banned for use by analyzers: see https://github.com/dotnet/roslyn-analyzers/issues/6467 
#pragma warning disable RS1035 

using System;

namespace Vogen;

internal static class GeneratedCodeSegments
{
    internal static readonly string Preamble =
        """
            // ------------------------------------------------------------------------------
            // <auto-generated>
            //     This code was generated by a source generator named Vogen (https://github.com/SteveDunn/Vogen)
            //
            //     Changes to this file may cause incorrect behavior and will be lost if
            //     the code is regenerated.
            // </auto-generated>
            // ------------------------------------------------------------------------------

            // Suppress warnings about [Obsolete] member usage in generated code.
            #pragma warning disable CS0618

            // Suppress warnings for 'Override methods on comparable types'.
            #pragma warning disable CA1036

            // Suppress Error MA0097 : A class that implements IComparable<T> or IComparable should override comparison operators
            #pragma warning disable MA0097

            // Suppress warning for 'The annotation for nullable reference types should only be used in code within a '#nullable' annotations context. Auto-generated code requires an explicit '#nullable' directive in source.'
            // The generator copies signatures from the BCL, e.g. for `TryParse`, and some of those have nullable annotations.
            #pragma warning disable CS8669, CS8632

            // Suppress warnings about CS1591: Missing XML comment for publicly visible type or member 'Type_or_Member'
            #pragma warning disable CS1591
            """.Replace("\r\n", "\n").Replace("\n", Environment.NewLine); // normalize regardless of git checkout policy        
}