interface ControlPointConf {
	cx: number;
	cy: number;
	x: number;
	y: number;
	ur: number;
	vr: number;
	up: number;
	vp: number;
}

interface ControlPointPreset {
	width: number;
	height: number;
	conf: ControlPointConf[];
}

const p = (
	cx: number,
	cy: number,
	x: number,
	y: number,
	ur = 0,
	vr = 0,
	up = 1,
	vp = 1,
) => Object.freeze({ cx, cy, x, y, ur, vr, up, vp }) as ControlPointConf;
const preset = (width: number, height: number, conf: ControlPointConf[]) =>
	Object.freeze({ width, height, conf }) as ControlPointPreset;

export const CONTROL_POINT_PRESETS = [
	// TODO: 竖屏推荐
	preset(5, 5, [
		p(0, 0, -1, -1, 0, 0, 1, 1),
		p(1, 0, -0.5, -1, 0, 0, 1, 1),
		p(2, 0, 0, -1, 0, 0, 1, 1),
		p(3, 0, 0.5, -1, 0, 0, 1, 1),
		p(4, 0, 1, -1, 0, 0, 1, 1),
		p(0, 1, -1, -0.5, 0, 0, 1, 1),
		p(1, 1, -0.5, -0.5, 0, 0, 1, 1),
		p(2, 1, -0.0052029684413368305, -0.6131420587090777, 0, 0, 1, 1),
		p(3, 1, 0.5884227308309977, -0.3990805107556692, 0, 0, 1, 1),
		p(4, 1, 1, -0.5, 0, 0, 1, 1),
		p(0, 2, -1, 0, 0, 0, 1, 1),
		p(1, 2, -0.4210024670505933, -0.11895058380429502, 0, 0, 1, 1),
		p(2, 2, -0.1019613423315412, -0.023812118047224606, 0, -47, 0.629, 0.849),
		p(3, 2, 0.40275125660925437, -0.06345314544600389, 0, 0, 1, 1),
		p(4, 2, 1, 0, 0, 0, 1, 1),
		p(0, 3, -1, 0.5, 0, 0, 1, 1),
		p(1, 3, 0.06801958477287173, 0.5205913248960121, -31, -45, 1, 1),
		p(2, 3, 0.21446469120128908, 0.29331610114301043, 6, -56, 0.566, 1.321),
		p(3, 3, 0.5, 0.5, 0, 0, 1, 1),
		p(4, 3, 1, 0.5, 0, 0, 1, 1),
		p(0, 4, -1, 1, 0, 0, 1, 1),
		p(1, 4, -0.31378372841550195, 1, 0, 0, 1, 1),
		p(2, 4, 0.26153633255328046, 1, 0, 0, 1, 1),
		p(3, 4, 0.5, 1, 0, 0, 1, 1),
		p(4, 4, 1, 1, 0, 0, 1, 1),
	]),
	preset(6, 6, [
		p(0, 0, -1, -1, 0, 0, 1, 1),
		p(1, 0, -0.6, -1, 0, 0, 1, 1),
		p(2, 0, -0.19999999999999996, -1, 0, 0, 1, 1),
		p(3, 0, 0.19999999999999996, -1, 0, 0, 1, 1),
		p(4, 0, 0.6000000000000001, -1, 0, 0, 1, 1),
		p(5, 0, 1, -1, 0, 0, 1, 1),
		p(0, 1, -1, -0.6, 0, 0, 1, 1),
		p(1, 1, -0.6, -0.6, 0, 0, 1, 1),
		p(2, 1, -0.10980661589020635, -0.4108069757237176, 0, 0, 1, 1),
		p(3, 1, 0.37398525356081525, -0.437252891735175, 0, 0, 1, 1),
		p(4, 1, 0.6000000000000001, -0.6, 0, 0, 1, 1),
		p(5, 1, 1, -0.6, 0, 0, 1, 1),
		p(0, 2, -1, -0.19999999999999996, 0, 0, 1, 1),
		p(1, 2, -0.5125306585683541, -0.1780829148228924, 0, 0, 1, 1),
		p(2, 2, -0.19999999999999996, -0.19999999999999996, 0, 0, 1, 1),
		p(3, 2, 0.19999999999999996, -0.19999999999999996, 0, 0, 1, 1),
		p(4, 2, 0.6485698281140977, -0.1939504644297667, 0, 0, 1, 1),
		p(5, 2, 1, -0.19999999999999996, 0, 0, 1, 1),
		p(0, 3, -1, 0.19999999999999996, 0, 0, 1, 1),
		p(1, 3, -0.7321983182109801, 0.23447337495584342, 0, 0, 1, 1),
		p(2, 3, -0.46545901721636285, 0.4619082526543773, 0, 0, 1, 1),
		p(3, 3, -0.12549716300753677, 0.4275285618394826, -65, -36, 1.195, 2.296),
		p(4, 3, 0.3582947064434847, -0.04320874316445944, 0, 0, 1, 1),
		p(5, 3, 1, 0.19999999999999996, 0, 0, 1, 1),
		p(0, 4, -1, 0.6000000000000001, 0, 0, 1, 1),
		p(1, 4, -0.742658682955867, 0.6549634395380164, 0, 0, 1, 1),
		p(2, 4, -0.3843911904434889, 0.7475241455781174, 0, 0, 0.535, 0.66),
		p(3, 4, 0.07847994951775883, 0.7263674127689514, 0, 0, 1, 1),
		p(4, 4, 0.6000000000000001, 0.6000000000000001, 0, 0, 1, 1),
		p(5, 4, 1, 0.6000000000000001, 0, 0, 1, 1),
		p(0, 5, -1, 1, 0, 0, 1, 1),
		p(1, 5, -0.6, 1, 0, 0, 1, 1),
		p(2, 5, -0.19999999999999996, 1, 0, 0, 1, 1),
		p(3, 5, 0.19999999999999996, 1, 0, 0, 1, 1),
		p(4, 5, 0.6000000000000001, 1, 0, 0, 1, 1),
		p(5, 5, 1, 1, 0, 0, 1, 1),
	]),
	// TODO: 横屏推荐
	preset(4, 4, [
		p(0, 0, -1, -1, 0, 0, 1, 1),
		p(1, 0, -0.33333333333333337, -1, 0, 0, 1, 1),
		p(2, 0, 0.33333333333333326, -1, 0, 0, 1, 1),
		p(3, 0, 1, -1, 0, 0, 1, 1),
		p(0, 1, -1, -0.04495399932657351, 0, 0, 1, 1),
		p(1, 1, -0.24056117520129328, -0.22465999020104, 0, 0, 1, 1),
		p(2, 1, 0.334758885767489, -0.00531297192779423, 0, 0, 1, 1),
		p(3, 1, 0.9989920470678106, -0.3382976020775408, 8, 0, 0.566, 1.792),
		p(0, 2, -1, 0.33333333333333326, 0, 0, 1, 1),
		p(1, 2, -0.3425497314639411, -0.000027501607956947893, 0, 0, 1, 1),
		p(2, 2, 0.3321437945812673, 0.1981776353859399, 0, 0, 1, 1),
		p(3, 2, 1, 0.0766118180296832, 0, 0, 1, 1),
		p(0, 3, -1, 1, 0, 0, 1, 1),
		p(1, 3, -0.33333333333333337, 1, 0, 0, 1, 1),
		p(2, 3, 0.33333333333333326, 1, 0, 0, 1, 1),
		p(3, 3, 1, 1, 0, 0, 1, 1),
	]),
	preset(4, 4, [
		p(0, 0, -1, -1, 0, 0, 1, 2.075),
		p(1, 0, -0.33333333333333337, -1, 0, 0, 1, 1),
		p(2, 0, 0.33333333333333326, -1, 0, 0, 1, 1),
		p(3, 0, 1, -1, 0, 0, 1, 1),
		p(0, 1, -1, -0.4545779491139603, 0, 0, 1, 1),
		p(1, 1, -0.33333333333333337, -0.33333333333333337, 0, 0, 1, 1),
		p(2, 1, 0.0889403142626457, -0.6025711180694033, -32, 45, 1, 1),
		p(3, 1, 1, -0.33333333333333337, 0, 0, 1, 1),
		p(0, 2, -1, -0.07402408608567845, 1, 0, 1, 0.094),
		p(1, 2, -0.2719422694359541, 0.09775369930903222, 25, -18, 1.321, 0),
		p(2, 2, 0.19877414408395877, 0.4307383294587789, 48, -40, 0.755, 0.975),
		p(3, 2, 1, 0.33333333333333326, -37, 0, 1, 1),
		p(0, 3, -1, 1, 0, 0, 1, 1),
		p(1, 3, -0.33333333333333337, 1, 0, 0, 1, 1),
		p(2, 3, 0.5125850864305672, 1, -20, -18, 0, 1.604),
		p(3, 3, 1, 1, 0, 0, 1, 1),
	]),
	preset(4, 4, [
		p(0, 0, -1, -1, 0, 0, 1, 1),
		p(1, 0, -0.04704442742088466, -1, 0, 14, 2.013, 3.522),
		p(2, 0, 0.5910378220172194, -1, 0, 0, 1, 1),
		p(3, 0, 1, -1, 0, 0, 1, 1),
		p(0, 1, -1, -0.33333333333333337, 0, 0, 1, 1),
		p(1, 1, -0.13072734537998032, -0.20616084408160962, 0, 0, 1, 1),
		p(2, 1, 0.5178152688030109, -0.45722068427387885, 0, 0, 1, 1),
		p(3, 1, 1, -0.5021471819924956, 0, 0, 1, 1),
		p(0, 2, -1, 0.33333333333333326, 0, 0, 1, 1),
		p(1, 2, -0.4210024670505933, 0.2563178089041497, 0, 0, 1, 1),
		p(2, 2, 0.11247613493864139, -0.050239469646410795, 4, -2, 0.849, 1.132),
		p(3, 2, 1, -0.08195229156543427, 0, 0, 1, 1),
		p(0, 3, -1, 1, 0, 0, 1, 1),
		p(1, 3, -0.33333333333333337, 1, 0, 0, 1, 1),
		p(2, 3, 0.33333333333333326, 1, 0, 0, 1, 1),
		p(3, 3, 1, 1, 0, 0, 1, 1),
	]),
	preset(5, 5, [
		p(0, 0, -1, -1, 0, 0, 1, 1),
		p(1, 0, -0.632824853134554, -1, 0, -31, 1.101, 1.038),
		p(2, 0, -0.1019613423315412, -1, 0, 0, 1, 1),
		p(3, 0, 0.7348678372594151, -1, 0, 39, 0.66, 2.421),
		p(4, 0, 1, -1, 0, 0, 1, 1),
		p(0, 1, -1, -0.5, 0, 0, 1, 1),
		p(1, 1, -0.7165077710936496, -0.5100753874722515, 0, 0, 0.629, 1),
		p(2, 1, -0.5491419351754585, -0.4149369217151808, 16, 25, 1, 1.478),
		p(3, 1, 0.5021247216856803, -0.5523591500309495, 0, 44, 0.629, 1.509),
		p(4, 1, 1, -0.5, 0, 0, 1, 1),
		p(0, 2, -1, 0, 0, 0, 1, 1),
		p(1, 2, -0.6851266768589888, -0.013241177407550042, 0, 0, 1, 1),
		p(2, 2, -0.36347046095371505, -0.09252323220510883, -23, -31, 1, 1),
		p(3, 2, 0.08371013189020227, -0.11630784864437649, 0, 0, 0.409, 1),
		p(4, 2, 1, -0.002670236767875478, 0, 0, 1, 1),
		p(0, 3, -1, 0.5, 0, 0, 1, 1),
		p(1, 3, -0.3294742755328324, 0.6844409048109668, -3, 19, 1.415, 1),
		p(2, 3, 0.028793216979545733, 0.36202721530089466, 6, 0, 1.541, 0.472),
		p(3, 3, 0.5230454511754543, 0.2801024253434172, 10, -42, 0, 1.352),
		p(4, 3, 1, 0.5, -3, 0, 1.981, 2.17),
		p(0, 4, -1, 1, 0, 0, 1, 1),
		p(1, 4, -0.48114956433369327, 1, 0, 53, 0, 1.509),
		p(2, 4, 0, 1, 0, 0, 1, 1),
		p(3, 4, 0.6093434603207717, 1, 0, 0, 0.629, 1),
		p(4, 4, 1, 1, 0, 0, 1, 1),
	]),
] as const;
