/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.util.ProxyUtil;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.DefaultMemberAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecurityMemberAccess
extends DefaultMemberAccess {
    private static final Logger LOG = LogManager.getLogger(SecurityMemberAccess.class);
    private final boolean allowStaticMethodAccess;
    private Set<Pattern> excludeProperties = Collections.emptySet();
    private Set<Pattern> acceptProperties = Collections.emptySet();
    private Set<Class<?>> excludedClasses = Collections.emptySet();
    private Set<Pattern> excludedPackageNamePatterns = Collections.emptySet();
    private Set<String> excludedPackageNames = Collections.emptySet();
    private boolean disallowProxyMemberAccess;

    public SecurityMemberAccess(boolean method) {
        super(false);
        this.allowStaticMethodAccess = method;
    }

    public boolean getAllowStaticMethodAccess() {
        return this.allowStaticMethodAccess;
    }

    public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
        LOG.debug("Checking access for [target: {}, member: {}, property: {}]", target, (Object)member, (Object)propertyName);
        if (this.checkEnumAccess(target, member)) {
            LOG.trace("Allowing access to enum: {}", target);
            return true;
        }
        Class<?> targetClass = target.getClass();
        Class<?> memberClass = member.getDeclaringClass();
        if (Modifier.isStatic(member.getModifiers()) && this.allowStaticMethodAccess) {
            LOG.debug("Support for accessing static methods [target: {}, member: {}, property: {}] is deprecated!", target, (Object)member, (Object)propertyName);
            if (!this.isClassExcluded(member.getDeclaringClass())) {
                targetClass = member.getDeclaringClass();
            }
        }
        if (this.isPackageExcluded(targetClass.getPackage(), memberClass.getPackage())) {
            LOG.warn("Package of target [{}] or package of member [{}] are excluded!", target, (Object)member);
            return false;
        }
        if (this.isClassExcluded(targetClass)) {
            LOG.warn("Target class [{}] is excluded!", target);
            return false;
        }
        if (this.isClassExcluded(memberClass)) {
            LOG.warn("Declaring class of member type [{}] is excluded!", (Object)member);
            return false;
        }
        if (this.disallowProxyMemberAccess && ProxyUtil.isProxyMember(member, target)) {
            LOG.warn("Access to proxy [{}] is blocked!", (Object)member);
            return false;
        }
        boolean allow = true;
        if (!this.checkStaticMethodAccess(member)) {
            LOG.warn("Access to static [{}] is blocked!", (Object)member);
            allow = false;
        }
        if (!allow) {
            return false;
        }
        return super.isAccessible(context, target, member, propertyName) && this.isAcceptableProperty(propertyName);
    }

    protected boolean checkStaticMethodAccess(Member member) {
        int modifiers = member.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return this.allowStaticMethodAccess;
        }
        return true;
    }

    protected boolean checkEnumAccess(Object target, Member member) {
        Class clazz;
        return target instanceof Class && Enum.class.isAssignableFrom(clazz = (Class)target) && member.getName().equals("values");
    }

    protected boolean isPackageExcluded(Package targetPackage, Package memberPackage) {
        if (targetPackage == null || memberPackage == null) {
            LOG.warn("The use of the default (unnamed) package is discouraged!");
        }
        String targetPackageName = targetPackage == null ? "" : targetPackage.getName();
        String memberPackageName = memberPackage == null ? "" : memberPackage.getName();
        for (Pattern pattern : this.excludedPackageNamePatterns) {
            if (!pattern.matcher(targetPackageName).matches() && !pattern.matcher(memberPackageName).matches()) continue;
            return true;
        }
        for (String packageName : this.excludedPackageNames) {
            if (!targetPackageName.startsWith(packageName) && !targetPackageName.equals(packageName) && !memberPackageName.startsWith(packageName) && !memberPackageName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassExcluded(Class<?> clazz) {
        if (clazz == Object.class || clazz == Class.class && !this.allowStaticMethodAccess) {
            return true;
        }
        for (Class<?> excludedClass : this.excludedClasses) {
            if (!clazz.isAssignableFrom(excludedClass)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAcceptableProperty(String name) {
        return name == null || !this.isExcluded(name) && this.isAccepted(name);
    }

    protected boolean isAccepted(String paramName) {
        if (!this.acceptProperties.isEmpty()) {
            for (Pattern pattern : this.acceptProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean isExcluded(String paramName) {
        if (!this.excludeProperties.isEmpty()) {
            for (Pattern pattern : this.excludeProperties) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void setExcludeProperties(Set<Pattern> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public void setAcceptProperties(Set<Pattern> acceptedProperties) {
        this.acceptProperties = acceptedProperties;
    }

    public void setExcludedClasses(Set<Class<?>> excludedClasses) {
        this.excludedClasses = excludedClasses;
    }

    public void setExcludedPackageNamePatterns(Set<Pattern> excludedPackageNamePatterns) {
        this.excludedPackageNamePatterns = excludedPackageNamePatterns;
    }

    public void setExcludedPackageNames(Set<String> excludedPackageNames) {
        this.excludedPackageNames = excludedPackageNames;
    }

    public void setDisallowProxyMemberAccess(boolean disallowProxyMemberAccess) {
        this.disallowProxyMemberAccess = disallowProxyMemberAccess;
    }
}

