﻿namespace Squalr.Source.Utils.Observables
{
    using System;
    using System.Collections.Generic;

    public class Unsubscriber<T> : IDisposable
    {
        internal Unsubscriber(HashSet<IObserver<T>> observers, IObserver<T> observer)
        {
            this.Observers = observers;
            this.Observer = observer;
        }

        private HashSet<IObserver<T>> Observers { get; set; }

        private IObserver<T> Observer { get; set; }

        public void Dispose()
        {
            if (this.Observers.Contains(this.Observer))
            {
                this.Observers.Remove(this.Observer);
            }
        }
    }
    //// End class
}
//// End namespace