﻿namespace Squalr.Source.Controls
{
    using System.Drawing;

    /// <summary>
    /// Dark brushes for GUI rendering. This is based on the colors in the xaml theme.
    /// </summary>
    public static class DarkBrushes
    {
        /// <summary>
        /// White theme color.
        /// </summary>
        public static readonly Color SqualrColorWhite = Color.White;

        /// <summary>
        /// Off-White theme color.
        /// </summary>
        public static readonly Color SqualrColorOffWhite = Color.FromArgb(0xD8, 0xD8, 0xD8);

        /// <summary>
        /// Black theme color.
        /// </summary>
        public static readonly Color SqualrColorBlack = Color.Black;

        /// <summary>
        /// Gray 20 theme color.
        /// </summary>
        public static readonly Color SqualrColorGray20 = Color.FromArgb(0x33, 0x33, 0x33);

        /// <summary>
        /// Gray 24 theme color.
        /// </summary>
        public static readonly Color SqualrColorGray24 = Color.FromArgb(0x3D, 0x3D, 0x3D);

        /// <summary>
        /// Gray 29 theme color.
        /// </summary>
        public static readonly Color SqualrColorGray29 = Color.FromArgb(0x4A, 0x4A, 0x4A);

        /// <summary>
        /// Gray 74 theme color.
        /// </summary>
        public static readonly Color SqualrColorGray74 = Color.FromArgb(0xBD, 0xBD, 0xBD);

        /// <summary>
        /// Theme color for the frames.
        /// </summary>
        public static readonly Color SqualrColorFrame = Color.FromArgb(0x33, 0x33, 0x33);

        /// <summary>
        /// Theme color for panels.
        /// </summary>
        public static readonly Color SqualrColorPanel = Color.FromArgb(0x20, 0x20, 0x20);

        /// <summary>
        /// Theme color for input fields.
        /// </summary>
        public static readonly Color SqualrColorInput = Color.FromArgb(0x44, 0x44, 0x44);

        /// <summary>
        /// Theme color for input field borders.
        /// </summary>
        public static readonly Color SqualrColorBorder = Color.FromArgb(0x66, 0x66, 0x66);

        /// <summary>
        /// Blue theme color.
        /// </summary>
        public static readonly Color SqualrColorBlue = Color.FromArgb(0x00, 0x7A, 0xCC);

        /// <summary>
        /// Red theme color.
        /// </summary>
        public static readonly Color SqualrColorRed = Color.FromArgb(0xFF, 0xBB, 0x00);

        /// <summary>
        /// Orange theme color.
        /// </summary>
        public static readonly Color SqualrColorOrange = Color.FromArgb(0xCA, 0x51, 0x00);
    }
    //// End class
}
//// End namespace