package window

import "github.com/SpaiR/imgui-go"

func (w *Window) setDefaultTheme() {
	imgui.StyleColorsDark()

	s := imgui.CurrentStyle()
	s.SetWindowBorderSize(1)
	s.SetChildBorderSize(0)
	s.SetScrollbarSize(10)
	s.SetTabRounding(3)
	s.SetWindowRounding(3)
	s.SetScrollbarRounding(3)
	s.SetPopupRounding(3)
	s.SetFrameRounding(2)

	s.SetColor(imgui.StyleColorText, imgui.Vec4{X: 1.00, Y: 1.00, Z: 1.00, W: 1.00})
	s.SetColor(imgui.StyleColorTextDisabled, imgui.Vec4{X: 0.50, Y: 0.50, Z: 0.50, W: 1.00})
	s.SetColor(imgui.StyleColorWindowBg, imgui.Vec4{X: 0.10, Y: 0.10, Z: 0.10, W: 1.00})
	s.SetColor(imgui.StyleColorChildBg, imgui.Vec4{})
	s.SetColor(imgui.StyleColorPopupBg, imgui.Vec4{X: 0.19, Y: 0.19, Z: 0.19, W: 0.92})
	s.SetColor(imgui.StyleColorBorder, imgui.Vec4{X: 0.19, Y: 0.19, Z: 0.19, W: 0.29})
	s.SetColor(imgui.StyleColorBorderShadow, imgui.Vec4{W: 0.24})
	s.SetColor(imgui.StyleColorFrameBg, imgui.Vec4{X: 0.18, Y: 0.21, Z: 0.22, W: 1.00})
	s.SetColor(imgui.StyleColorFrameBgHovered, imgui.Vec4{X: 0.36, Y: 0.41, Z: 0.44, W: 1.00})
	s.SetColor(imgui.StyleColorFrameBgActive, imgui.Vec4{X: 0.27, Y: 0.31, Z: 0.33, W: 1.00})
	s.SetColor(imgui.StyleColorTitleBg, imgui.Vec4{W: 1.00})
	s.SetColor(imgui.StyleColorTitleBgActive, imgui.Vec4{X: 0.06, Y: 0.06, Z: 0.06, W: 1.00})
	s.SetColor(imgui.StyleColorTitleBgCollapsed, imgui.Vec4{W: 0.73})
	s.SetColor(imgui.StyleColorMenuBarBg, imgui.Vec4{X: 0.14, Y: 0.14, Z: 0.14, W: 1.00})
	s.SetColor(imgui.StyleColorScrollbarBg, imgui.Vec4{X: 0.05, Y: 0.05, Z: 0.05, W: 0.54})
	s.SetColor(imgui.StyleColorScrollbarGrab, imgui.Vec4{X: 0.40, Y: 0.40, Z: 0.40, W: 1.00})
	s.SetColor(imgui.StyleColorScrollbarGrabHovered, imgui.Vec4{X: 0.50, Y: 0.50, Z: 0.50, W: 1.00})
	s.SetColor(imgui.StyleColorScrollbarGrabActive, imgui.Vec4{X: 0.30, Y: 0.30, Z: 0.30, W: 1.00})
	s.SetColor(imgui.StyleColorCheckMark, imgui.Vec4{X: 0.34, Y: 0.69, Z: 0.86, W: 1.00})
	s.SetColor(imgui.StyleColorSliderGrab, imgui.Vec4{X: 0.34, Y: 0.69, Z: 0.86, W: 1.00})
	s.SetColor(imgui.StyleColorSliderGrabActive, imgui.Vec4{X: 0.51, Y: 0.76, Z: 0.89, W: 1.00})
	s.SetColor(imgui.StyleColorButton, imgui.Vec4{X: 0.18, Y: 0.21, Z: 0.22, W: 1.00})
	s.SetColor(imgui.StyleColorButtonHovered, imgui.Vec4{X: 0.36, Y: 0.41, Z: 0.44, W: 1.00})
	s.SetColor(imgui.StyleColorButtonActive, imgui.Vec4{X: 0.27, Y: 0.31, Z: 0.33, W: 1.00})
	s.SetColor(imgui.StyleColorButton, imgui.Vec4{X: 0.27, Y: 0.32, Z: 0.33, W: 1.00})
	s.SetColor(imgui.StyleColorButtonHovered, imgui.Vec4{X: 0.31, Y: 0.37, Z: 0.38, W: 1.00})
	s.SetColor(imgui.StyleColorButtonActive, imgui.Vec4{X: 0.22, Y: 0.27, Z: 0.27, W: 1.00})
	s.SetColor(imgui.StyleColorHeader, imgui.Vec4{X: 0.27, Y: 0.31, Z: 0.33, W: 1.00})
	s.SetColor(imgui.StyleColorHeaderHovered, imgui.Vec4{X: 0.31, Y: 0.36, Z: 0.38, W: 1.00})
	s.SetColor(imgui.StyleColorHeaderActive, imgui.Vec4{X: 0.22, Y: 0.26, Z: 0.27, W: 1.00})
	s.SetColor(imgui.StyleColorSeparator, imgui.Vec4{X: 0.28, Y: 0.28, Z: 0.28, W: 0.29})
	s.SetColor(imgui.StyleColorSeparatorHovered, imgui.Vec4{X: 0.44, Y: 0.44, Z: 0.44, W: 0.29})
	s.SetColor(imgui.StyleColorSeparatorActive, imgui.Vec4{X: 0.40, Y: 0.44, Z: 0.47, W: 1.00})
	s.SetColor(imgui.StyleColorResizeGrip, imgui.Vec4{X: 0.25, Y: 0.25, Z: 0.25, W: 1.00})
	s.SetColor(imgui.StyleColorResizeGripHovered, imgui.Vec4{X: 0.45, Y: 0.45, Z: 0.45, W: 1.00})
	s.SetColor(imgui.StyleColorResizeGripActive, imgui.Vec4{X: 0.20, Y: 0.20, Z: 0.20, W: 1.00})
	s.SetColor(imgui.StyleColorTab, imgui.Vec4{X: 0.18, Y: 0.21, Z: 0.22, W: 1.00})
	s.SetColor(imgui.StyleColorTabHovered, imgui.Vec4{X: 0.36, Y: 0.41, Z: 0.44, W: 1.00})
	s.SetColor(imgui.StyleColorTabActive, imgui.Vec4{X: 0.27, Y: 0.31, Z: 0.33, W: 1.00})
	s.SetColor(imgui.StyleColorTabUnfocused, imgui.Vec4{X: 0.09, Y: 0.11, Z: 0.11, W: 1.00})
	s.SetColor(imgui.StyleColorTabUnfocusedActive, imgui.Vec4{X: 0.13, Y: 0.16, Z: 0.16, W: 1.00})
	s.SetColor(imgui.StyleColorDockingPreview, imgui.Vec4{X: 0.34, Y: 0.69, Z: 0.86, W: 1.00})
	s.SetColor(imgui.StyleColorDockingEmptyBg, imgui.Vec4{X: 0.10, Y: 0.10, Z: 0.10, W: 1.00})
	s.SetColor(imgui.StyleColorPlotLines, imgui.Vec4{X: 1.00, W: 1.00})
	s.SetColor(imgui.StyleColorPlotLinesHovered, imgui.Vec4{X: 1.00, W: 1.00})
	s.SetColor(imgui.StyleColorPlotHistogram, imgui.Vec4{X: 1.00, W: 1.00})
	s.SetColor(imgui.StyleColorPlotHistogramHovered, imgui.Vec4{X: 1.00, W: 1.00})
	s.SetColor(imgui.StyleColorTableHeaderBg, imgui.Vec4{W: 0.52})
	s.SetColor(imgui.StyleColorTableBorderStrong, imgui.Vec4{W: 0.52})
	s.SetColor(imgui.StyleColorTableBorderLight, imgui.Vec4{X: 0.28, Y: 0.28, Z: 0.28, W: 0.29})
	s.SetColor(imgui.StyleColorTableRowBg, imgui.Vec4{})
	s.SetColor(imgui.StyleColorTableRowBgAlt, imgui.Vec4{X: 1.00, Y: 1.00, Z: 1.00, W: 0.06})
	s.SetColor(imgui.StyleColorTextSelectedBg, imgui.Vec4{X: 0.45, Y: 0.53, Z: 0.55, W: 0.78})
	s.SetColor(imgui.StyleColorDragDropTarget, imgui.Vec4{})
	s.SetColor(imgui.StyleColorNavHighlight, imgui.Vec4{})
	s.SetColor(imgui.StyleColorNavWindowingHighlight, imgui.Vec4{})
	s.SetColor(imgui.StyleColorNavWindowingDimBg, imgui.Vec4{})
	s.SetColor(imgui.StyleColorModalWindowDimBg, imgui.Vec4{X: 0.80, Y: 0.80, Z: 0.80, W: 0.35})
}
