/*
 * Copyright(c) Sophist Solutions, Inc. 1990-2024.  All rights reserved
 */


#define SystemSevenOrBetter 1			// we want the extended types
#define	SystemSevenOrLater	1			// Types.r uses this variable

#include	"BalloonTypes.r"
#include	"SysTypes.r"
#include	"Types.r"

#include	"PowerPlant.r"

#include	"LedConfig.h"
#include	"LedStdDialogs.h"

#include	"LedItConfig.h"
#include	"LedItResources.h"



// From PP_Resources.h  -	cannot directly include, cuz declarations are const, rather than #defines...
#define	MBAR_Initial			128
#define	STRx_Standards			200




#if		TARGET_CARBON
// LGP 2003-01-20	- I THINK this resource marks our application as having been carbonized (so can run directly under OSX)
data	'carb' (0) {
};
#endif





/*
 ********************************************************************************
 ********************************* Finder Resources *****************************
 ********************************************************************************
 */
	#if		qLed_Version_Stage == qLed_Version_Stage_Dev
		#define developmentStage		development
	#elif	qLed_Version_Stage == qLed_Version_Stage_Alpha
		#define developmentStage		alpha
	#elif	qLed_Version_Stage == qLed_Version_Stage_Beta
		#define developmentStage		beta
	#elif	qLed_Version_Stage == qLed_Version_Stage_ReleaseCandidate
		#define developmentStage		final
	#elif	qLed_Version_Stage == qLed_Version_Stage_Release
		#define developmentStage		final
	#else
		#error	"bad stage?"
	#endif
resource 'vers' (1) {
	qLed_Version_Major,
	qLed_Version_Minor,
	developmentStage,
	qLed_Version_SubStage,
	verUS,
	qLed_ShortVersionString,
	"LedIt! " qLed_ShortVersionString
};
resource 'vers' (2) {
	qLed_Version_Major,
	qLed_Version_Minor,
	developmentStage,
	qLed_Version_SubStage,
	verUS,
	qLed_ShortVersionString,
	"LedIt! " qLed_ShortVersionString
};
resource 'open' (128) {
	kApplicationSignature,
	{
		kLedPrivateDocumentFileType,					
		kTEXTFileType,					
		'****',					
	}
};
#ifndef	ftApplicationName
	#define	ftApplicationName	'apnm'
#endif
resource 'kind' (128) {
	kApplicationSignature,
	0,
	{
		ftApplicationName,				"LedIt!",
		kLedPrivateDocumentFileType,	"Led Rich Text format",
		kTEXTFileType,					"Text file",
	},
};
data kApplicationSignature (0, "Owner Resource") {
	"LedIt! " qLed_ShortVersionString
};
resource 'BNDL' (5000, "Application BNDL") {
	kApplicationSignature,
	0,
	{
		'FREF',
		{
			0, kApplicationFinderIconResID,
			1, kPrivateDocument_FinderIconResID,
			2, kPrivateDocumentStationary_FinderIconResID,
			3, kTEXTDocument_FinderIconResID,
			4, kTEXTDocumentStationary_FinderIconResID,
			5, kAnyTypeFinderIconResID,
		},
		'ICN#',
		{
			0, kApplicationFinderIconResID,
			1, kPrivateDocument_FinderIconResID,
			2, kPrivateDocumentStationary_FinderIconResID,
			3, kTEXTDocument_FinderIconResID,
			4, kTEXTDocumentStationary_FinderIconResID,
			5, 0,			/* no ICN# reference since we provide no icon for this case */
		}
	}
};
resource 'FREF' (kApplicationFinderIconResID) {
	'APPL',
	0,
	""
};
resource 'FREF' (kPrivateDocument_FinderIconResID) {
	kLedPrivateDocumentFileType,
	1,
	""
};
resource 'FREF' (kPrivateDocumentStationary_FinderIconResID) {
	kLedPrivateDocumentStationeryFileType,
	2,
	""
};
resource 'FREF' (kTEXTDocument_FinderIconResID) {
	kTEXTFileType,
	3,
	""
};
resource 'FREF' (kTEXTDocumentStationary_FinderIconResID) {
	kTEXTStationeryFileType,
	4,
	""
};
resource 'FREF' (kAnyTypeFinderIconResID) {
	'****',
	5,
	""
};
resource 'ICN#' (kApplicationFinderIconResID) {
	{
		$"FFFF FFFF FFFF FFFF FFFF FFFF FC00 0103 FC01 B903 FC00 0103 FC00 7903 FC00 0103"
		$"FC00 0103 FDF8 0103 FC00 0103 FDE8 0103 FC00 0103 FC00 0103 FD8C 1903 FC01 0117"
		$"FDF2 0233 FC06 046B FDCB 08D3 FC15 F1A3 FC2A A343 FC15 4683 FC2A 8D03 FC55 1A03"
		$"FCAA 3403 FC54 6803 FCA8 D003 FD51 2003 FCA1 8003 FD40 0003 FE80 0003 FFFF FFFF",
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	}
};
resource 'icl8' (kApplicationFinderIconResID) {
	$"0000 0000 0000 0000 0000 0000 0000 0000 00F5 F5F5 F5F6 F6F6 F6F6 2B2B 2B2B F7F7"
	$"00FC FCFC FCFC FCFC FCFC FCFC FBFB FBFB 8181 81FA FAFA F9F9 F956 5656 56F8 F8F7"
	$"00FB FCFB FCFB FCFB FCFB FCFB FBFB 8181 81FA FAFA FAF9 F9F9 5656 56F8 F8F8 F8F7"
	$"00FC FCFC FCFC 0000 0000 0000 0000 0000 0000 0000 00F5 F62B 5656 56F8 F8F8 F7F8"
	$"00FC FCFB FCFB 0000 0000 0000 0000 0000 0000 0000 F5F6 2BF7 56F8 F8F8 F8F7 F7F8"
	$"00FC FBFC FCFC 0000 0000 0000 0000 AC00 ACAC 00AC ACFD FDF8 56F8 F8F8 F7F7 F7F8"
	$"00FC FCFB FCFC 0000 0000 0000 0000 0000 0000 00F5 F6F7 F856 F8F8 F8F7 F7F7 2BF8"
	$"00FC FBFC FBFC 0000 0000 0000 0000 0000 AC00 ACAC FDFD FD56 F8F7 F7F7 F72B 2B56"
	$"00FC FCFC FCFB 0000 0000 0000 0000 0000 0000 F52B F7F8 56F9 F7F7 F7F7 2B2B 2B56"
	$"00FC FBFC FBFB 0000 0000 0000 0000 0000 ACF8 F8F8 2BFD FDFA F7F7 F72B 2B2B F656"
	$"00FB FCFB FBFB 0000 0000 0000 0000 0000 00F6 2BF7 56F9 F9FA F7F7 2B2C FFF6 F656"
	$"00FC FBFB FB81 0000 0000 0000 0000 0000 F52B F756 56F9 FA81 2B2B 2C11 11F6 F656"
	$"00FB FBFB 8181 0000 ACAC ACAC ACAC 00F7 F6F7 F856 F9FA 8181 2B2B 1011 2C2B F6F9"
	$"00FB FB81 8181 0000 0000 0000 0000 00FA F8F8 56F9 FA81 81FB 2B2C 1110 2B2B F6F9"
	$"00FB 8181 81FA 0000 ACAC AC00 0000 56AC F956 F9FA 8181 FBFC 2B11 112C 2BF6 F5F9"
	$"0081 8181 FAFA 0000 0000 0000 0000 FBAC 56F8 FA81 FBFB 81FC 0F11 332B 2BF5 F5FA"
	$"F581 81FA FAFA 0000 0000 0000 00F9 FDFA F5F5 56FA 8156 56FB 1111 F72B F6F5 00FA"
	$"F581 FAFA FAF9 0000 00AC ACAC ACFC FBF6 F5F9 81FA 56FC FB34 1132 2B2B F500 00FA"
	$"F5FA FAFA F9F9 0000 0000 0000 FAAC 2BF5 F981 F9F9 8181 5611 102B 2BF6 F500 00FA"
	$"F5FA FAF9 F9F9 0000 00AC ACFC FD56 0056 81F9 81FC FAF7 1011 2C2B F6F5 0000 00FA"
	$"F6FA F9F9 F956 0000 0000 00FC FA00 F981 56F9 FB56 F607 1110 2B2B F500 0000 0081"
	$"F6F9 F9F9 5656 0000 00AC FCFC 00F9 FA56 FCFA F7F6 F610 11F7 2BF6 F500 0000 0081"
	$"F6F9 F956 5656 0000 0000 FDF6 56FA 8181 F92B F6F6 0811 332B F6F5 0000 0000 0081"
	$"F6F9 5656 56F8 0000 00FB 2B56 F9FC FB56 2BF6 F6F6 1011 2B2B F600 0000 0000 0081"
	$"2B56 5656 F8F8 0000 00FA F956 81FB 56F6 F6F5 F508 112C 2BF6 F500 0000 0000 00FB"
	$"2B56 56F8 F8F8 0000 5656 81AC FC56 F6F6 F5F6 F511 102B 2BF5 0000 0000 0000 00FB"
	$"2B56 F8F8 F8F8 0000 56FA ACFC F9F6 F6F6 F5F5 3210 2C2B F6F5 0000 0000 0000 00FB"
	$"2BF8 F8F8 F7F7 00F9 FAFC FBF8 F6F6 F5F5 F5F6 5C32 F6F6 F500 0000 0000 0000 00FB"
	$"2BF8 F8F7 F7F7 81FA FA56 2BF6 F6F5 F5F5 F5F7 5CF5 F5F5 0000 0000 0000 0000 00FC"
	$"F7F8 F7F7 F7F7 2B2B 2BF6 F6F6 F5F5 F5F5 00F5 F500 0000 0000 0000 0000 0000 00FC"
	$"F7F8 F7F7 2B2B 2B2B F6F6 F6F5 F5F5 F500 0000 0000 0000 0000 0000 0000 0000 00FC"
	$"F7F7 F8F8 F8F8 5656 5656 F9F9 F9F9 F9FA FAFA FA81 8181 81FB FBFB FBFB FCFC FCFC"
};
resource 'icl4' (kApplicationFinderIconResID) {
	$"EEEE EEEE EEEE EEEE EEEE EEEE EEEE EEEE EEEE EEEE EEEE EEEE EEED DDDD DDDD DDDE"
	$"EEEE EEEE EEEE EEEE DDDD DDDD DDDD DDCE EEEE EE00 0000 0000 0000 00CC DDDD CCCE"
	$"EEEE EE00 0000 0000 0000 0CCC DDDC CCCE EEEE EE00 0000 000E EEEE EAAC DDCC CCCE"
	$"EEEE EE00 0000 0000 0000 CCCD DCCC CCCE EEEE EE00 0000 0000 E0EE AAAD CCCC CCCD"
	$"EEEE EE00 0000 0000 000C CCDD CCCC CCCD EEEE EE00 0000 0000 EEAA AAAD CCCC CCCD"
	$"EEEE EE00 0000 0000 0CCC DDDD CCCC FCCD EEEE ED00 0000 0000 0CCD DDDD CCC2 2CCD"
	$"EEEE EE00 EEEE EE0C CCCD DDDD CCC2 CCCD EEED ED00 0000 000D CCDD DDDE CC22 CCCD"
	$"EEDE DE00 EEE0 00DE DDDD DDEE C22C C00D EDED ED00 0000 00EE DCDD EEDE C2DC C00D"
	$"DEDE DD00 0000 0DAD 00DD DDDE 22CC 000D EDED ED00 0EEE EEEC 0DDD DEEB 2CCC 000D"
	$"DEDD DD00 0000 DEC0 DDDD DDD2 2CC0 000D EDED DD00 0EEE AD0D DDDE DC22 CC00 000D"
	$"DEDD DD00 000E D0DD DDED CC22 CC00 000D EDDD DD00 0EEE 0DDD EDCC C22C C000 000D"
	$"DDDD DD00 00AC DDDD DCCC C2DC C000 000D DDDD DC00 0ECD DEED CCCC 22CC 0000 000D"
	$"DDDD CC00 0DDD DEDC CCCC 2CCC 0000 000E DDDC CC00 DDDE EDCC CCC2 2CC0 C000 000E"
	$"DDCC CC00 DDEE DCCC CC44 CCCC 0000 000E DCCC CC0D DEEC CCCC CC44 CCC0 C000 000E"
	$"DCCC CCDD DDCC CCCC CCCC 0C0C 0C00 000E DCCC CCCC CCCC CCC0 C0C0 C0C0 C0C0 000E"
	$"DCCC CCCC CC0C 0C0C 0C0C 0C0C 0C0C 000E DDDD DDDD DDDD DDDD DDDD DDDE EEEE EEEE"
};
resource 'ics#' (kApplicationFinderIconResID) {
	{
		$"FFFF FFFF E00F EE8F E00F E00F EBCD E01B ED37 E06F ECDF E1BF E37F E6FF EFFF FFFF",
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	}
};
resource 'ics8' (kApplicationFinderIconResID) {
	$"FCFC FCFC FCFC FBFB FBFA FAF9 F956 F8F8 FCFC FCFC FCFC FB81 FAFA FAF9 56F8 F8F8"
	$"FCFC FC00 0000 0000 0000 0000 F8F8 F8F8 FCFC FC00 FAF6 F7F7 F700 0000 F8F8 F8F8"
	$"FCFC FC00 0000 0000 0000 0000 F7F7 F7F7 FCFC FB00 F9F9 F600 F6F7 0000 F7F7 FEF8"
	$"FBFB 8100 0000 0000 0000 0000 F711 11F7 FB81 FA00 F7F7 F9F6 0000 0000 1111 F7F7"
	$"FBFA FA00 0000 0000 0000 00F7 1111 F7F7 FAFA F900 0000 0000 0000 F711 11F7 F7F7"
	$"FAF9 F900 F7F9 F600 00F7 F711 11F7 F8F7 F9F9 F800 0000 0000 F7F7 1111 F8F8 F8F7"
	$"56F8 F800 0000 00F7 F7F7 1111 F8F8 F8F7 F8F8 F800 0000 F7F7 F713 11F8 F8F8 F8F7"
	$"F8F8 F700 00F7 F7F7 6969 F8F8 F8F8 F8F7 F8F8 F8F7 F7F7 F7F7 F7F7 F7F7 F7F7 F7F7"
};
resource 'ics4' (kApplicationFinderIconResID) {
	$"EEEE EEEE EDDD DDCC EEEE EEED DDDD DCCC EEE0 0000 0000 CCCC EEE0 DCCC C000 CCCC"
	$"EEE0 0000 0000 CCCC EEE0 CCC0 CC00 CCFC EED0 0000 0000 C22C EDD0 CCCC 0000 22CC"
	$"EDD0 0000 000C 22CC DDD0 0000 00C2 2CCC DDD0 CCC0 0CC2 2CCC DDC0 0000 CC22 CCCC"
	$"DCC0 000C CC22 CCCC CCC0 00CC C22C CCCC CCC0 0CCC 44CC CCCC CCCC CCCC CCCC CCCC"
};
resource 'ICN#' (kPrivateDocument_FinderIconResID) {
	{
		$"1FFF FC00 1000 0600 1477 0500 1444 8480 1464 8440 1444 8420 1777 07F0 1000 0010"
		$"1000 0010 1000 0010 1000 8010 1002 8010 1005 0810 100A 1410 1014 2210 1028 4110"
		$"1050 8090 10A1 0250 1142 0430 1085 0910 160A 1210 1610 2490 1028 4110 1052 9010"
		$"1085 2410 104A 4890 1064 9130 1071 2A50 1038 5490 101C A110 100E 0010 1FFF FFF0",
		$"1FFF FC00 1FFF FE00 1FFF FF00 1FFF FF80 1FFF FFC0 1FFF FFE0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
	}
};
resource 'icl8' (kPrivateDocument_FinderIconResID) {
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000 0000 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 FAFF FF00 0000 0000 0000 0000"
	$"0000 00FF F8FA F8F8 F8FA FAFA F8FA FAFA F8F8 F8F8 FAFF 2BFF 0000 0000 0000 0000"
	$"0000 00FF F8FA F8F8 F8FA F8F8 F8FA F8F8 FAF8 F8F8 FAFF 2B2B FF00 0000 0000 0000"
	$"0000 00FF F8FA F8F8 F8FA FAF8 F8FA F8F8 FAF8 F8F8 FAFF 2B2B 2BFF 0000 0000 0000"
	$"0000 00FF F8FA F8F8 F8FA F8F8 F8FA F8F8 FAF8 F8F8 FAFA 2B2B 2B2B FF00 0000 0000"
	$"0000 00FF F8FA FAFA F8FA FAFA F8FA FAFA F8F8 F8F8 FAFF FFFF FFFF FFFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 FAFA FAFA FAFA FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8FA FAFA FAFA FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8FA FAFF 0000 0000"
	$"0000 00FF F8F8 1313 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 1369 1616 1616 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 FAFA 1616 1616 1616 1616 F8F8 F8F6 F8F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8FA FAFA 1616 1616 1616 1616 F6F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 FAFA FAFA 1616 1616 1616 FFF8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F600 0000 1616 FFFF F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F6 0000 0000 0000 00F6 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F600 0000 0000 0000 D800 F6F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F6 0000 0000 0000 00D8 0000 00F6 F6FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F600 00FA 0000 0000 D800 00FA 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F6 0000 FA00 0000 00D8 0000 FA00 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F600 0000 0000 0000 D800 00FA 0000 FA00 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F6 0000 FA00 0000 00D8 0000 0000 00FA 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F600 00FA 0000 FA00 D800 00FA 0000 0000 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 FA00 0000 00FA 00D8 0000 FA00 00FA 0000 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 FAFA 0000 FA00 D800 00FA 0000 FA00 0000 FA00 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8FA FA00 00D8 0000 FA00 00FA 0000 00FA 0000 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 FAFB 0000 00FA 0000 FA00 FA00 FA00 00FA 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 FAFA FB00 0000 00FA 00FA 00FA 0000 FA00 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8FA FAFB 0000 FA00 FA00 0000 00FA 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 FAFA FB00 0000 0000 0000 0000 0000 00FF 0000 0000"
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};
resource 'icl4' (kPrivateDocument_FinderIconResID) {
	$"000F FFFF FFFF FFFF FFFF FF00 0000 0000 000F CCCC CCCC CCCC CCCC DFF0 0000 0000"
	$"000F CDCC CDDD CDDD CCCC DFCF 0000 0000 000F CDCC CDCC CDCC DCCC DFCC F000 0000"
	$"000F CDCC CDDC CDCC DCCC DFCC CF00 0000 000F CDCC CDCC CDCC DCCC DDCC CCF0 0000"
	$"000F CDDD CDDD CDDD CCCC DFFF FFFF 0000 000F CCCC CCCC CCCC CCCC DDDD DDDF 0000"
	$"000F CCCC CCCC CCCC CCCC CDDD DDDF 0000 000F CCCC CCCC CCCC CCCC CCCC CDDF 0000"
	$"000F CCCC CCCC CCCC CCCC CCCC CCDF 0000 000F CCC4 2222 CCCC CCCC CCCC CCDF 0000"
	$"000F CCDD 2222 2222 CCCC CCCC CCDF 0000 000F CCCC CDDD 2222 2222 CCCC CCDF 0000"
	$"000F CCCC CCCC DDDD 2222 22FC CCDF 0000 000F CCCC CCCC CCCC C000 22FF CCDF 0000"
	$"000F CCCC CCCC CCCC 0000 000C CCDF 0000 000F CCCC CCCC CCC0 0000 0030 CCDF 0000"
	$"000F CCCC CCCC CC00 0000 0300 0CCF 0000 000F CCCC CCCC C00D 0000 300D 000F 0000"
	$"000F CCCC CCCC 00D0 0003 00D0 000F 0000 000F CCCC CCC0 0000 0030 0D00 D00F 0000"
	$"000F CCCC CC00 D000 0300 000D 000F 0000 000F CCCC C00D 00D0 300D 0000 000F 0000"
	$"000F CCCC D000 0D03 00D0 0D00 000F 0000 000F CCCC DD00 D030 0D00 D000 D00F 0000"
	$"000F CCCC CDD0 0300 D00D 000D 00DF 0000 000F CCCC CCDE 000D 00D0 D0D0 0D0F 0000"
	$"000F CCCC CCDD E000 0D0D 0D00 D00F 0000 000F CCCC CCCD DE00 D0D0 000D 000F 0000"
	$"000F CCCC CCCC DDE0 0000 0000 000F 0000 000F FFFF FFFF FFFF FFFF FFFF FFFF"
};
resource 'ics#' (kPrivateDocument_FinderIconResID) {
	{
		$"7FF0 4048 4044 407C 4104 4204 4404 4844 50A4 4134 424C 4414 4924 464C 4214 7FFC",
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	}
};
resource 'ics8' (kPrivateDocument_FinderIconResID) {
	$"00FF FFFF FFFF FFFF FFFF FFFF 0000 0000 00FF 2B2B 2B2B 2B2B 2B2B FFFF FF00 0000"
	$"00FF 2B2B 2B2B 2B2B 2B2B FF2B FFFF 0000 00FF 2B2B 2B2B 2B2B 2B2B FFFF FFFF 0000"
	$"00FF 2B17 2B2B 2B2B 2B2B 2B2B 2BFF 0000 00FF 2B2B 1717 2B2B 2B2B 2B2B 2BFF 0000"
	$"00FF 2B2B 2B2B 1717 2B2B 2B2B 2BFF 0000 00FF 2B2B 2B2B 2B2B 2B00 2B2B 2BFF 0000"
	$"00FF 2B2B 2B2B 2B2B 0000 002B 2BFF 0000 00FF 2B2B 2B2B 2B00 0000 0000 2BFF 0000"
	$"00FF 2B2B 2B2B 0000 0000 0000 00FF 0000 00FF 2B2B 2B00 00FB 0000 00FB 00FF 0000"
	$"00FF 2B2B 0000 FB00 0000 FB00 00FF 0000 00FF 2B2B 2B00 0000 00FB 00FB 00FF 0000"
	$"00FF 2B2B 2B2B 0000 FB00 FB00 00FF 0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
};
resource 'ics4' (kPrivateDocument_FinderIconResID) {
	$"0FFF FFFF FFFF 0000 0FCC CCCC CCFF F000 0FCC CCCC CCFC FF00 0FCC CCCC CCFF FF00"
	$"0FC2 CCCC CCCC CF00 0FCC 22CC CCCC CF00 0FCC CC22 CCCC CF00 0FCC CCCC C0CC CF00"
	$"0FCC CCCC 000C CF00 0FCC CCC0 0000 CF00 0FCC CC00 0000 0F00 0FCC C00E 000E 0F00"
	$"0FCC 00E0 00E0 0F00 0FCC C000 0E0E 0F00 0FCC CC00 E0E0 0F00 0FFF FFFF FFFF FF"
};
resource 'ICN#' (kPrivateDocumentStationary_FinderIconResID) {
	{
		$"3FFF FFE0 2000 0020 2008 EE38 2008 8928 2008 C928 2008 8928 200E EE28 2800 0028"
		$"2600 0028 2780 0028 21E0 6028 2078 9028 201F 0828 2007 0428 2004 8228 2008 0528"
		$"2010 08A8 2022 1268 2044 2428 2080 4928 2110 8228 2125 2028 210A 4028 2194 8FE8"
		$"20C9 2848 2062 4888 2070 A908 2039 4A08 201C 0C08 3FFF F808 0800 0008 0FFF FFF8",
		$"1FFF FC00 1FFF FE00 1FFF FF00 1FFF FF80 1FFF FFC0 1FFF FFE0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
	}
};
resource 'icl8' (kPrivateDocumentStationary_FinderIconResID) {
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"0000 FF00 0000 0000 0000 00F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FF00 0000 0000"
	$"0000 FF00 0000 0000 0000 00F5 FAF5 F5F5 FAFA FAF5 FAFA FAF5 F5F5 FFFF FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 FAF5 F5F5 FAF5 F5F5 FAF5 F5FA F5F5 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 FAF5 F5F5 FAFA F5F5 FAF5 F5FA F5F5 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 FAF5 F5F5 FAF5 F5F5 FAF5 F5FA F5F5 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 FAFA FAF5 FAFA FAF5 FAFA FAF5 F5F5 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F513 13F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F513 6916 1616 16F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F516 1616 1616 1616 16F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F516 1616 1616 1616 16F6 F5F5 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F516 1616 1616 16FF F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F6 0000 0016 16FF FFF5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F600 0000 0000 0000 F6F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F6 0000 0000 0000 00D8 00F6 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F600 0000 0000 0000 D800 0000 F6F6 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F6 0000 FA00 0000 00D8 0000 FA00 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F600 00FA 0000 0000 D800 00FA 0000 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F6 0000 0000 0000 00D8 0000 FA00 00FA 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F600 00FA 0000 0000 D800 0000 0000 FA00 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F6 0000 FA00 00FA 00D8 0000 FA00 0000 0000 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5FA 0000 0000 FA00 D800 00FA 0000 0000 0000 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5FA FA00 00FA 00D8 0000 FA00 0000 FFFF FFFF FFFF FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 FAFA 0000 D800 00FA 0000 FA00 FF2B 2B2B 2BFF F92B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5FA FB00 0000 FA00 00FA 0000 FF2B 2B2B FFF9 2B2B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5FA FAFB 0000 0000 FA00 FA00 FF2B 2BFF F92B 2B2B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 FAFA FB00 00FA 00FA 0000 FF2B FFF9 2B2B 2B2B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5FA FAFB 0000 0000 0000 FFFF F92B 2B2B 2B2B FF00 0000"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFF9 2B2B 2B2B 2B2B FF00 0000"
	$"0000 0000 FFF9 F9F9 F9F9 F9F9 F9F9 F9F9 F9F9 F9F9 F92B 2B2B 2B2B 2B2B FF00 0000"
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF"
};
resource 'icl4' (kPrivateDocumentStationary_FinderIconResID) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FFF0 0000 00F0 0000 0000 0000 0000 0000 00F0 0000"
	$"00F0 0000 0000 D000 DDD0 DDD0 00FF F000 00F0 0000 0000 D000 D000 D00D 00FD F000"
	$"00F0 0000 0000 D000 DD00 D00D 00FD F000 00F0 0000 0000 D000 D000 D00D 00FD F000"
	$"00F0 0000 0000 DDD0 DDD0 DDD0 00FD F000 00F0 0000 0000 0000 0000 0000 00FD F000"
	$"00F0 0CC0 0000 0000 0000 0000 00FD F000 00F0 0C42 2220 0000 0000 0000 00FD F000"
	$"00F0 0002 2222 2220 0000 0000 00FD F000 00F0 0000 0002 2222 222C 0000 00FD F000"
	$"00F0 0000 0000 0002 2222 2F00 00FD F000 00F0 0000 0000 000C 0002 2FF0 00FD F000"
	$"00F0 0000 0000 00C0 0000 00C0 00FD F000 00F0 0000 0000 0C00 0000 030C 00FD F000"
	$"00F0 0000 0000 C000 0000 3000 CCFD F000 00F0 0000 000C 00D0 0003 00D0 00FD F000"
	$"00F0 0000 00C0 0D00 0030 0D00 00FD F000 00F0 0000 0C00 0000 0300 D00D 00FD F000"
	$"00F0 0000 C00D 0000 3000 00D0 00FD F000 00F0 000C 00D0 0D03 00D0 0000 00FD F000"
	$"00F0 000D 0000 D030 0D00 0000 00FD F000 00F0 000D D00D 0300 D000 FFFF FFFD F000"
	$"00F0 0000 DD00 300D 00D0 FCCC CFDC F000 00F0 0000 0DE0 00D0 0D00 FCCC FDCC F000"
	$"00F0 0000 0DDE 0000 D0D0 FCCF DCCC F000 00F0 0000 00DD E00D 0D00 FCFD CCCC F000"
	$"00F0 0000 000D DE00 0000 FFDC CCCC F000 00FF FFFF FFFF FFFF FFFF FDCC CCCC F000"
	$"0000 FDDD DDDD DDDD DDDD DCCC CCCC F000 0000 FFFF FFFF FFFF FFFF FFFF FFFF F0"
};
resource 'ics#' (kPrivateDocumentStationary_FinderIconResID) {
	{
		$"7FFC 4006 5366 5256 5356 5256 5B66 4006 4086 4146 4226 4416 480A 4412 7FE2 3FFE",
		$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	}
};
resource 'ics8' (kPrivateDocumentStationary_FinderIconResID) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF 0000 00FF 0000 0000 0000 0000 0000 00FF FF00"
	$"00FF 00FF 0000 FFFF 00FF FF00 00FF FF00 00FF 00FF 0000 FF00 00FF 00FF 00FF FF00"
	$"00FF 00FF 0000 FFFF 00FF 00FF 00FF FF00 00FF 00FF 0000 FF00 00FF 00FF 00FF FF00"
	$"00FF 00FF FF00 FFFF 00FF FF00 00FF FF00 00FF 0000 0000 0000 0000 0000 00FF FF00"
	$"00FF 0000 0000 0000 FF00 0000 00FF FF00 00FF 0000 0000 00FF 00FF 0000 00FF FF00"
	$"00FF 0000 0000 FF00 0000 FF00 00FF FF00 00FF 0000 00FF 0000 0000 00FF 00FF FF00"
	$"00FF 0000 FF00 0000 0000 0000 FF00 FF00 00FF 0000 00FF 0000 0000 00FF 0000 FF00"
	$"00FF FFFF FFFF FFFF FFFF FF00 0000 FF00 0000 FFFF FFFF FFFF FFFF FFFF FFFF FF"
};
resource 'ics4' (kPrivateDocumentStationary_FinderIconResID) {
	$"0FFF FFFF FFFF FF00 0F00 0000 0000 0FF0 0F0F 00FF 0FF0 0FF0 0F0F 00F0 0F0F 0FF0"
	$"0F0F 00FF 0F0F 0FF0 0F0F 00F0 0F0F 0FF0 0F0F F0FF 0FF0 0FF0 0F00 0000 0000 0FF0"
	$"0F00 0000 F000 0FF0 0F00 000F 0F00 0FF0 0F00 00F0 00F0 0FF0 0F00 0F00 000F 0FF0"
	$"0F00 F000 0000 F0F0 0F00 0F00 000F 00F0 0FFF FFFF FFF0 00F0 00FF FFFF FFFF FFF0"
};
resource 'ICN#' (kTEXTDocument_FinderIconResID) {
	{
		$"1FFF FC00 1000 0E00 17C0 FD00 1100 2C80 1174 AC40 1144 AC20 1173 2FF0 1043 0FF0"
		$"1074 87F0 1004 8070 1000 0030 1100 0030 1300 0030 1070 0030 100F 0230 1000 0330"
		$"1000 0030 1000 0230 1000 0410 1001 0910 1002 1210 1000 2490 1008 4110 1012 9010"
		$"1085 2410 10CA 4890 1064 9130 1031 2A50 1038 5490 101C A110 100E 0010 1FFF FFF0",
		$"1FFF FC00 1FFF FE00 1FFF FF00 1FFF FF80 1FFF FFC0 1FFF FFE0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
		$"1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0 1FFF FFF0"
	}
};
resource 'icl8' (kTEXTDocument_FinderIconResID) {
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF 0000 0000 0000 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 FAFF FF00 0000 0000 0000 0000"
	$"0000 00FF F8D8 D8D8 D8D8 F8F8 F8F8 F8F8 D8D8 D8D8 D8FF 2BFF 0000 0000 0000 0000"
	$"0000 00FF F8F8 F8D8 F8F8 F8F8 F8F8 F8F8 F8F8 D8F8 FAFF 2B2B FF00 0000 0000 0000"
	$"0000 00FF F8F8 F8D8 F8D8 D8D8 F8D8 F8F8 D8F8 D8F8 FAFF 2B2B 2BFF 0000 0000 0000"
	$"0000 00FF F8F8 F8D8 F8D8 F8F8 F8D8 F8F8 D8F8 D8F8 FAFA 2B2B 2B2B FF00 0000 0000"
	$"0000 00FF F8F8 F8D8 F8D8 D8D8 F8F8 D8D8 F8F8 D8F8 FAFF FFFF FFFF FFFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8D8 F8F8 F8F8 D8D8 F8F8 F8F8 FAFA FAFA FAFA FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8D8 D8D8 F8D8 F8F8 D8F8 F8F8 F8FA FAFA FAFA FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8D8 F8F8 D8F8 F8F8 F8F8 F8F8 F8FA FAFF 0000 0000"
	$"0000 00FF F8F8 1313 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 1369 1616 1616 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 FAFA 1616 1616 1616 1616 F8F8 F8F6 F8F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8FA FAFA 1616 1616 1616 1616 F6F8 F8F8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 FAFA FAFA 1616 1616 1616 FFF8 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F8 F600 0000 1616 FFFF F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F8F6 0000 0000 0000 00F6 F8F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F8 F600 0000 0000 0000 D800 F6F8 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F8F6 0000 0000 0000 00D8 0000 00F6 F6FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 F600 00FA 0000 0000 D800 00FA 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F6 0000 FA00 0000 00D8 0000 FA00 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F600 0000 0000 0000 D800 00FA 0000 FA00 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F6 0000 FA00 0000 00D8 0000 0000 00FA 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F600 00FA 0000 FA00 D800 00FA 0000 0000 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 FA00 0000 00FA 00D8 0000 FA00 00FA 0000 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 FAFA 0000 FA00 D800 00FA 0000 FA00 0000 FA00 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8FA FA00 00D8 0000 FA00 00FA 0000 00FA 0000 FAFF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 FAFB 0000 00FA 0000 FA00 FA00 FA00 00FA 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 FAFA FB00 0000 00FA 00FA 00FA 0000 FA00 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8FA FAFB 0000 FA00 FA00 0000 00FA 0000 00FF 0000 0000"
	$"0000 00FF F8F8 F8F8 F8F8 F8F8 FAFA FB00 0000 0000 0000 0000 0000 00FF 0000 0000"
	$"0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
};
resource 'icl4' (kTEXTDocument_FinderIconResID) {
	$"000F FFFF FFFF FFFF FFFF FF00 0000 0000 000F CCCC CCCC CCCC CCCC DFF0 0000 0000"
	$"000F C333 33CC CCCC 3333 3FCF 0000 0000 000F CCC3 CCCC CCCC CC3C DFCC F000 0000"
	$"000F CCC3 C333 C3CC 3C3C DFCC CF00 0000 000F CCC3 C3CC C3CC 3C3C DDCC CCF0 0000"
	$"000F CCC3 C333 CC33 CC3C DFFF FFFF 0000 000F CCCC C3CC CC33 CCCC DDDD DDDF 0000"
	$"000F CCCC C333 C3CC 3CCC CDDD DDDF 0000 000F CCCC CCCC C3CC 3CCC CCCC CDDF 0000"
	$"000F CCCC CCCC CCCC CCCC CCCC CCDF 0000 000F CCC4 2222 CCCC CCCC CCCC CCDF 0000"
	$"000F CCDD 2222 2222 CCCC CCCC CCDF 0000 000F CCCC CDDD 2222 2222 CCCC CCDF 0000"
	$"000F CCCC CCCC DDDD 2222 22FC CCDF 0000 000F CCCC CCCC CCCC C000 22FF CCDF 0000"
	$"000F CCCC CCCC CCCC 0000 000C CCDF 0000 000F CCCC CCCC CCC0 0000 0030 CCDF 0000"
	$"000F CCCC CCCC CC00 0000 0300 0CCF 0000 000F CCCC CCCC C00D 0000 300D 000F 0000"
	$"000F CCCC CCCC 00D0 0003 00D0 000F 0000 000F CCCC CCC0 0000 0030 0D00 D00F 0000"
	$"000F CCCC CC00 D000 0300 000D 000F 0000 000F CCCC C00D 00D0 300D 0000 000F 0000"
	$"000F CCCC D000 0D03 00D0 0D00 000F 0000 000F CCCC DD00 D030 0D00 D000 D00F 0000"
	$"000F CCCC CDD0 0300 D00D 000D 00DF 0000 000F CCCC CCDE 000D 00D0 D0D0 0D0F 0000"
	$"000F CCCC CCDD E000 0D0D 0D00 D00F 0000 000F CCCC CCCD DE00 D0D0 000D 000F 0000"
	$"000F CCCC CCCC DDE0 0000 0000 000F 0000 000F FFFF FFFF FFFF FFFF FFFF FFFF"
};
resource 'ics#' (kTEXTDocument_FinderIconResID) {
	{
		$"7FF0 4038 402C 413C 403C 5004 5C04 4314 4004 4134 417C 47D4 4BEC 4FFC 46FC 7FFC",
		$"7FF0 7FF8 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC 7FFC"
	}
};
resource 'ics8' (kTEXTDocument_FinderIconResID) {
	$"00FF FFFF FFFF FFFF FFFF FFFF 0000 0000 00FF F8F8 F8F8 F8F8 F8F8 FFFF FF00 0000"
	$"00FF F8F8 F8F8 F8F8 F8F8 FF2B FFFF 0000 00FF F8F8 F8F8 F8D8 F8F8 FFFF FFFF 0000"
	$"00FF F8F8 F8F8 F8F8 F8F8 FAFA FAFF 0000 00FF F869 F8F8 F8F8 F8F8 F8F8 F8FF 0000"
	$"00FF F8FA FAFA 1616 F8F8 F8F8 F8FF 0000 00FF F8F8 F8F8 FAFA F616 16FF F8FF 0000"
	$"00FF F8F8 F8F8 F8F8 0000 00F6 F8FF 0000 00FF F8F8 F8F8 F8FA 0000 D8FA F6FF 0000"
	$"00FF F8F8 F8F8 00FA 00D8 FAFA FAFF 0000 00FF F8F8 F8FA FAFA D8FA 00FA 00FF 0000"
	$"00FF F8F8 FA00 FAD8 FAFA FA00 FAFF 0000 00FF F8F8 FAFB D8FA FAFA FAFA FAFF 0000"
	$"00FF F8F8 F8FA FB00 FAFA FAFA FAFF 0000 00FF FFFF FFFF FFFF FFFF FFFF FFFF"
};
resource 'ics4' (kTEXTDocument_FinderIconResID) {
	$"0FFF FFFF FFFF 0000 0FCC CCCC CCFF F000 0FCC CCCC CCFC FF00 0FCC CCC3 CCFF FF00"
	$"0FCC CCCC CCDD DF00 0FC4 CCCC CCCC CF00 0FCD DD22 CCCC CF00 0FCC CCDD C22F CF00"
	$"0FCC CCCC 000C CF00 0FCC CCCD 003D CF00 0FCC CC0D 03DD DF00 0FCC CDDD 3D0D 0F00"
	$"0FCC D0D3 DDD0 DF00 0FCC DE3D DDDD DF00 0FCC CDE0 DDDD DF00 0FFF FFFF FFFF FF"
};
resource 'ICN#' (kTEXTDocumentStationary_FinderIconResID) {
	{
		$"3FFF FFE0 2000 0020 2000 0038 203E 07E8 2008 0128 200B A528 200A 2528 200B 9928"
		$"2002 1828 2203 A428 2000 2428 2000 0028 2000 0428 2000 0628 2000 0028 2000 0428"
		$"2000 0828 2002 1228 2004 2428 2000 4928 2010 8228 2025 2028 210A 4028 2194 8FE8"
		$"20C9 2848 2062 4888 2070 A908 2039 4A08 201C 0C08 3FFF F808 0800 0008 0FFF FFF8",
		$"3FFF FFE0 3FFF FFE0 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8"
		$"3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8"
		$"3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8"
		$"3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 3FFF FFF8 0FFF FFF8 0FFF FFF8"
	}
};
resource 'icl8' (kTEXTDocumentStationary_FinderIconResID) {
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF00 0000 0000"
	$"0000 FF00 0000 0000 0000 00F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FF00 0000 0000"
	$"0000 FF00 0000 0000 0000 00F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F5 FFFF FF00 0000"
	$"0000 FF00 0000 0000 0000 D8D8 D8D8 D8F5 F5F5 F5F5 F5D8 D8D8 D8D8 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 D8F5 F5F5 F5F5 F5F5 F5F5 F5D8 F5F5 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 D8F5 D8D8 D8F5 D8F5 F5D8 F5D8 F5F5 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 D8F5 D8F5 F5F5 D8F5 F5D8 F5D8 F5F5 FFF9 FF00 0000"
	$"0000 FF00 0000 0000 0000 00F5 D8F5 D8D8 D8F5 F5D8 D8F5 F5D8 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F513 13F5 F5F5 F5F5 F5F5 D8F5 F5F5 F5D8 D8F5 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F513 6916 1616 16F5 F5F5 D8D8 D8F5 D800 F5D8 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F516 1616 1616 1616 16F5 F5F5 D8F5 F5D8 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F516 1616 1616 1616 16F6 F5F5 F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F516 1616 1616 16FF F5F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F5F6 0000 0016 16FF FFF5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F5 F600 0000 0000 0000 F6F5 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F5F6 0000 0000 0000 00D8 00F6 F5F5 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F5 F600 0000 0000 0000 D800 0000 F6F6 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5F6 0000 FA00 0000 00D8 0000 FA00 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F600 00FA 0000 0000 D800 00FA 0000 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F6 0000 0000 0000 00D8 0000 FA00 00FA 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F600 00FA 0000 0000 D800 0000 0000 FA00 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F6 0000 FA00 00FA 00D8 0000 FA00 0000 0000 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5FA 0000 0000 FA00 D800 00FA 0000 0000 0000 0000 FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5FA FA00 00FA 00D8 0000 FA00 0000 FFFF FFFF FFFF FFF9 FF00 0000"
	$"0000 FFF5 F5F5 F5F5 FAFA 0000 D800 00FA 0000 FA00 FF2B 2B2B 2BFF F92B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5FA FB00 0000 FA00 00FA 0000 FF2B 2B2B FFF9 2B2B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5FA FAFB 0000 0000 FA00 FA00 FF2B 2BFF F92B 2B2B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 FAFA FB00 00FA 00FA 0000 FF2B FFF9 2B2B 2B2B FF00 0000"
	$"0000 FFF5 F5F5 F5F5 F5F5 F5FA FAFB 0000 0000 0000 FFFF F92B 2B2B 2B2B FF00 0000"
	$"0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFF9 2B2B 2B2B 2B2B FF00 0000"
	$"0000 0000 FFF9 F9F9 F9F9 F9F9 F9F9 F9F9 F9F9 F9F9 F92B 2B2B 2B2B 2B2B FF00 0000"
	$"0000 0000 FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF FF"
};
resource 'icl4' (kTEXTDocumentStationary_FinderIconResID) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FFF0 0000 00F0 0000 0000 0000 0000 0000 00F0 0000"
	$"00F0 0000 0000 0000 0000 0000 00FF F000 00F0 0000 0033 3330 0000 0333 33FD F000"
	$"00F0 0000 0000 3000 0000 0003 00FD F000 00F0 0000 0000 3033 3030 0303 00FD F000"
	$"00F0 0000 0000 3030 0030 0303 00FD F000 00F0 0000 0000 3033 3003 3003 00FD F000"
	$"00F0 0CC0 0000 0030 0003 3000 00FD F000 00F0 0C42 2220 0033 3030 0300 00FD F000"
	$"00F0 0002 2222 2220 0030 0300 00FD F000 00F0 0000 0002 2222 222C 0000 00FD F000"
	$"00F0 0000 0000 0002 2222 2F00 00FD F000 00F0 0000 0000 000C 0002 2FF0 00FD F000"
	$"00F0 0000 0000 00C0 0000 00C0 00FD F000 00F0 0000 0000 0C00 0000 030C 00FD F000"
	$"00F0 0000 0000 C000 0000 3000 CCFD F000 00F0 0000 000C 00D0 0003 00D0 00FD F000"
	$"00F0 0000 00C0 0D00 0030 0D00 00FD F000 00F0 0000 0C00 0000 0300 D00D 00FD F000"
	$"00F0 0000 C00D 0000 3000 00D0 00FD F000 00F0 000C 00D0 0D03 00D0 0000 00FD F000"
	$"00F0 000D 0000 D030 0D00 0000 00FD F000 00F0 000D D00D 0300 D000 FFFF FFFD F000"
	$"00F0 0000 DD00 300D 00D0 FCCC CFDC F000 00F0 0000 0DE0 00D0 0D00 FCCC FDCC F000"
	$"00F0 0000 0DDE 0000 D0D0 FCCF DCCC F000 00F0 0000 00DD E00D 0D00 FCFD CCCC F000"
	$"00F0 0000 000D DE00 0000 FFDC CCCC F000 00FF FFFF FFFF FFFF FFFF FDCC CCCC F000"
	$"0000 FDDD DDDD DDDD DDDD DCCC CCCC F000 0000 FFFF FFFF FFFF FFFF FFFF FFFF F0"
};
resource 'ics#' (kTEXTDocumentStationary_FinderIconResID) {
	{
		$"7FFC 4006 4006 4006 4006 4006 4036 4026 4176 42F6 47D6 5FBE 4FEA 4FF2 7FE2 3FFE",
		$"7FFC 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 7FFE 3FFE"
	}
};
resource 'ics8' (kTEXTDocumentStationary_FinderIconResID) {
	$"00FF FFFF FFFF FFFF FFFF FFFF FFFF 0000 00FF 0000 00F5 F5F5 F5F5 F5F5 F5FF FF00"
	$"00FF 0000 00F5 F5F5 F5F5 F5F5 F5FF FF00 00FF 0000 00F5 F5F5 F5F5 F5F5 F5FF FF00"
	$"00FF F5F5 F5F5 F5F5 F5F5 F5F5 F5FF FF00 00FF F5F5 F5F5 16F5 F5F6 F5F5 F5FF FF00"
	$"00FF F5F5 F5F5 F5F6 1616 FFFF F5FF FF00 00FF F5F5 F5F5 F6F6 0000 D8F6 F5FF FF00"
	$"00FF F5F5 F5F6 F6FA 00D8 D8FA F6FF FF00 00FF F5F5 F6F6 FA00 D8D8 FAFA 00FF FF00"
	$"00FF F5F6 F6FA FAD8 D8FA 00FA 00FF FF00 00FF F5FA FAFA FAD8 FA00 FFFF FFFF FF00"
	$"00FF F5F5 FAFB D8FA FAFA FF2B FFF9 FF00 00FF F5F5 FAFB FBFA FAFA FFFF F92B FF00"
	$"00FF FFFF FFFF FFFF FFFF FFF9 2B2B FF00 0000 FFFF FFFF FFFF FFFF FFFF FFFF FF"
};
resource 'ics4' (kTEXTDocumentStationary_FinderIconResID) {
	$"0FFF FFFF FFFF FF00 0F00 0000 0000 0FF0 0F00 0000 0000 0FF0 0F00 0000 0000 0FF0"
	$"0F00 0000 0000 0FF0 0F00 0020 0C00 0FF0 0F00 000C 22FF 0FF0 0F00 00CC 003C 0FF0"
	$"0F00 0CCD 033D CFF0 0F00 CCD0 33DD 0FF0 0F0C CDD3 3D0D 0FF0 0F0D DDD3 D0FF FFF0"
	$"0F00 DE3D DDFC FDF0 0F00 DEED DDFF DCF0 0FFF FFFF FFFD CCF0 00FF FFFF FFFF FFF0"
};

















/*
 ********************************************************************************
 ********************** Misc PowerPlant happy Resources *************************
 ********************************************************************************
 */
resource 'WIND' (WIND_TextDoc, purgeable) {
	{0, 0, 400, 500},
	zoomDocProc,
	invisible,
	goAway,
	0x0,
	"",
	staggerParentWindowScreen
};
resource 'PPob' (prto_TextDoc, purgeable) {
	{
		ObjectData {
			Printout {
				{500, 700},
				inactive,
				disabled,
				0,
				numberAcross
			}
		},
		BeginSubs {
		},
		ObjectData {
			PlaceHolder {
				1413640056,
				{356, 556},
				visible,
				disabled,
				bound,
				bound,
				bound,
				bound,
				72,
				72,
				0,
				defaultSuperView,
				0,
				0,
				0,
				0,
				16,
				16,
				noReconcileOverhang,
				0
			}
		},
		EndSubs {
		}
	}
};





resource 'ALRT' (kMemoryExceptionAlertID, purgeable) {
	{104, 130, 237, 488},
	kMemoryExceptionAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kMemoryExceptionAlertID, purgeable) {
	{
		{103, 288, 123, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 90, 348},
		StaticText {
			disabled,
			"Not enough memory to complete the command. Led has purged uneeded caches (including undo information). Try closing some documents, quitting other applications, or increasing the memory size of LedIt! (Get Info command)."
		}
	}
};




resource 'ALRT' (kPowerPlantExceptionAlertID, purgeable) {
	{104, 130, 205, 488},
	kPowerPlantExceptionAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kPowerPlantExceptionAlertID, purgeable) {
	{
		{71, 288, 91, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 58, 348},
		StaticText {
			disabled,
			"Couldn't complete that command because of a PowerPlant exception (id ^0)."
		}
	}
};




resource 'ALRT' (kGenericMacOSExceptionAlertID, purgeable) {
	{104, 130, 205, 488},
	kGenericMacOSExceptionAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kGenericMacOSExceptionAlertID, purgeable) {
	{
		{71, 288, 91, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 58, 348},
		StaticText {
			disabled,
			"Couldn't complete that command because of a MacOS exception (error # ^0)."
		}
	}
};




resource 'ALRT' (kUnknownExceptionAlertID, purgeable) {
	{104, 130, 205, 488},
	kUnknownExceptionAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kUnknownExceptionAlertID, purgeable) {
	{
		{71, 288, 91, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 58, 348},
		StaticText {
			disabled,
			"Couldn't complete that command because of an unknown exception."
		}
	}
};




resource 'ALRT' (kWarnLowLocalRAMAlertID, purgeable) {
	{104, 130, 237, 488},
	kWarnLowLocalRAMAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kWarnLowLocalRAMAlertID, purgeable) {
	{
		{103, 288, 123, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 90, 348},
		StaticText {
			disabled,
			"Very little memory left in the application heap. Text may display improperly, and LedIt! could even crash. Use the finder 'GetInfo' to give the applicatin more memory."
		}
	}
};




resource 'ALRT' (kWarnLowRAMAlertID, purgeable) {
	{104, 130, 237, 488},
	kWarnLowRAMAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kWarnLowRAMAlertID, purgeable) {
	{
		{103, 288, 123, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 90, 348},
		StaticText {
			disabled,
			"Very low on memory - including attempts to use temporary memory. Try quitting some other applications, closing windows, or make more available with the memory control panel."
		}
	}
};







resource 'ALRT' (kCannotOpenHelpFileAlertID, purgeable) {
	{104, 130, 237, 488},
	kCannotOpenHelpFileAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kCannotOpenHelpFileAlertID, purgeable) {
	{
		{103, 288, 123, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 90, 348},
		StaticText {
			disabled,
			"Couldn't open the help file ':LedItDocs:index.html' in the same folder as the application. Open the help file manually in an html browser for more hints."
		}
	}
};





resource 'ALRT' (kCannotOpenWebPageAlertID, purgeable) {
	{104, 130, 237, 488},
	kCannotOpenWebPageAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kCannotOpenWebPageAlertID, purgeable) {
	{
		{103, 288, 123, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 90, 348},
		StaticText {
			disabled,
			"Couldn't open the web page. Are you properly connected to the internet? Do you have Internet Config (IC) setup? Or a web browser running?"
		}
	}
};





resource 'ALRT' (kBadUserInputExceptionAlertID, purgeable) {
	{104, 130, 205, 488},
	kBadUserInputExceptionAlertID,
	{
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent,
		OK, visible, silent
	},
	alertPositionMainScreen
};
resource 'DITL' (kBadUserInputExceptionAlertID, purgeable) {
	{
		{71, 288, 91, 348},
		Button {
			enabled,
			"OK"
		},
		{10, 75, 58, 348},
		StaticText {
			disabled,
			"Invalid user input."
		}
	}
};





resource 'STR#' (STRx_Standards, "Standards", purgeable) {
	{
		"LedIt!",
		"Save File As:",
		"Can�t Undo"
	}
};

include	"PP Document Alerts.rsrc" not 'ckid';
include	"ColorAlertIcons.rsrc" not 'ckid';

#if		qStroika_Foundation_Debug_AssertionsChecked
include	"PP DebugAlerts.rsrc" not 'ckid';
#endif










/*
 ********************************************************************************
 ******************************** Apple Event Resources *************************
 ********************************************************************************
 */
#if 1
data 'aedt' (128, "Required Suite", purgeable) {
	$"6165 7674 6F61 7070 0000 03E9 6165 7674 6F64 6F63 0000 03EA 6165 7674 7064 6F63"                    /* aevtoapp...�aevtodoc...�aevtpdoc */
	$"0000 03EB 6165 7674 7175 6974 0000 03EC"                                                            /* ...�aevtquit...� */
};

data 'aedt' (129, "Core Suite", purgeable) {
	$"636F 7265 636C 6F6E 0000 07D1 636F 7265 636C 6F73 0000 07D2 636F 7265 636E 7465"                    /* coreclon...�coreclos...�corecnte */
	$"0000 07D3 636F 7265 6372 656C 0000 07D4 636F 7265 6465 6C6F 0000 07D5 636F 7265"                    /* ...�corecrel...�coredelo...�core */
	$"646F 6578 0000 07D6 636F 7265 716F 626A 0000 07D7 636F 7265 6765 7464 0000 07D8"                    /* doex...�coreqobj...�coregetd...� */
	$"636F 7265 6473 697A 0000 07D9 636F 7265 6774 6569 0000 07DA 636F 7265 6D6F 7665"                    /* coredsiz...�coregtei...�coremove */
	$"0000 07DB 636F 7265 7361 7665 0000 07DC 636F 7265 7365 7464 0000 07DD"                              /* ...�coresave...�coresetd...� */
};

data 'aedt' (130, "Misc Standards", purgeable) {
	$"6165 7674 6F62 6974 0000 0BB9 6D69 7363 6265 6769 0000 0BBA 6D69 7363 636F 7079"                    /* aevtobit...�miscbegi...�misccopy */
	$"0000 0BBB 6D69 7363 6370 7562 0000 0BBC 6D69 7363 6375 7420 0000 0BBD 6D69 7363"                    /* ...�misccpub...�misccut ...�misc */
	$"646F 7363 0000 0BBE 6D69 7363 6564 6974 0000 0BBF 6D69 7363 656E 6474 0000 0BC0"                    /* dosc...�miscedit...�miscendt...� */
	$"6D69 7363 696D 6772 0000 0BC1 6D69 7363 6973 756E 0000 0BC2 6D69 7363 6D76 6973"                    /* miscimgr...�miscisun...�miscmvis */
	$"0000 0BC3 6D69 7363 7061 7374 0000 0BC4 6D69 7363 7265 646F 0000 0C1F 6D69 7363"                    /* ...�miscpast...�miscredo....misc */
	$"7276 7274 0000 0BC6 6D69 7363 7474 726D 0000 0BC7 6D69 7363 756E 646F 0000 0BC8"                    /* rvrt...�miscttrm...�miscundo...� */
	$"6D69 7363 736C 6374 0000 0BC9"                                                                      /* miscslct...� */
};

#else
resource 'aedt' (128, "Required Suite", purgeable) {
	{
		1634039412, 1868656752, 1001,
		1634039412, 1868853091, 1002,
		1634039412, 1885630307, 1003,
		1634039412, 1903520116, 1004
	}
};
resource 'aedt' (129, "Core Suite", purgeable) {
	{
		1668248165, 1668050798, 2001,
		1668248165, 1668050803, 2002,
		1668248165, 1668183141, 2003,
		1668248165, 1668441452, 2004,
		1668248165, 1684368495, 2005,
		1668248165, 1685022072, 2006,
		1668248165, 1903125098, 2007,
		1668248165, 1734702180, 2008,
		1668248165, 1685285242, 2009,
		1668248165, 1735681385, 2010,
		1668248165, 1836021349, 2011,
		1668248165, 1935767141, 2012,
		1668248165, 1936028772, 2013
	}
};
resource 'aedt' (130, "Misc Standards", purgeable) {
	{
		1634039412, 1868720500, 3001,
		1835627363, 1650812777, 3002,
		1835627363, 1668247673, 3003,
		1835627363, 1668314466, 3004,
		1835627363, 1668641824, 3005,
		1835627363, 1685025635, 3006,
		1835627363, 1701079412, 3007,
		1835627363, 1701733492, 3008,
		1835627363, 1768777586, 3009,
		1835627363, 1769174382, 3010,
		1835627363, 1836476787, 3011,
		1835627363, 1885434740, 3012,
		1835627363, 1919247471, 3103,
		1835627363, 1920365172, 3014,
		1835627363, 1953788525, 3015,
		1835627363, 1970168943, 3016,
		1835627363, 1936483188, 3017
	}
};
#endif
data 'aete' (0, "English", purgeable) {
	$"0100 0000 0000 0004 0E52 6571 7569 7265 6420 5375 6974 652B 5465 726D 7320 7468"                    /* .........Required Suite+Terms th */
	$"6174 2065 7665 7279 2061 7070 6C69 6361 7469 6F6E 2073 686F 756C 6420 7375 7070"                    /* at every application should supp */
	$"6F72 7400 7265 7164 0001 0001 0000 0000 0000 0000 0E53 7461 6E64 6172 6420 5375"                    /* ort.reqd.............Standard Su */
	$"6974 6522 436F 6D6D 6F6E 2074 6572 6D73 2066 6F72 206D 6F73 7420 6170 706C 6963"                    /* ite"Common terms for most applic */
	$"6174 696F 6E73 436F 5265 0001 0001 0008 0563 6C6F 7365 0F43 6C6F 7365 2061 6E20"                    /* ationsCoRe.......close.Close an  */
	$"6F62 6A65 6374 636F 7265 636C 6F73 6E75 6C6C 0000 8000 6F62 6A20 1474 6865 206F"                    /* objectcoreclosnull..�.obj .the o */
	$"626A 6563 7473 2074 6F20 636C 6F73 6500 1000 0002 0673 6176 696E 6700 7361 766F"                    /* bjects to close......saving.savo */
	$"7361 766F 3F73 7065 6369 6669 6573 2077 6865 7468 6572 206F 7220 6E6F 7420 6368"                    /* savo?specifies whether or not ch */
	$"616E 6765 7320 7368 6F75 6C64 2062 6520 7361 7665 6420 6265 666F 7265 2063 6C6F"                    /* anges should be saved before clo */
	$"7369 6E67 A000 0269 6E00 6B66 696C 616C 6973 2474 6865 2066 696C 6520 696E 2077"                    /* sing�..in.kfilalis$the file in w */
	$"6869 6368 2074 6F20 7361 7665 2074 6865 206F 626A 6563 7400 8000 0964 6174 6120"                    /* hich to save the object.�.�data  */
	$"7369 7A65 2552 6574 7572 6E20 7468 6520 7369 7A65 2069 6E20 6279 7465 7320 6F66"                    /* size%Return the size in bytes of */
	$"2061 6E20 6F62 6A65 6374 636F 7265 6473 697A 6C6F 6E67 1F74 6865 2073 697A 6520"                    /*  an objectcoredsizlong.the size  */
	$"6F66 2074 6865 206F 626A 6563 7420 696E 2062 7974 6573 0000 6F62 6A20 2C74 6865"                    /* of the object in bytes..obj ,the */
	$"206F 626A 6563 7420 7768 6F73 6520 6461 7461 2073 697A 6520 6973 2074 6F20 6265"                    /*  object whose data size is to be */
	$"2072 6574 7572 6E65 6400 0000 0000 0367 6574 1A47 6574 2074 6865 2064 6174 6120"                    /*  returned......get.Get the data  */
	$"666F 7220 616E 206F 626A 6563 7400 636F 7265 6765 7464 2A2A 2A2A 1854 6865 2064"                    /* for an object.coregetd****.The d */
	$"6174 6120 6672 6F6D 2074 6865 206F 626A 6563 7400 0000 6F62 6A20 2774 6865 206F"                    /* ata from the object...obj 'the o */
	$"626A 6563 7420 7768 6F73 6520 6461 7461 2069 7320 746F 2062 6520 7265 7475 726E"                    /* bject whose data is to be return */
	$"6564 0000 0000 046D 616B 6512 4D61 6B65 2061 206E 6577 2065 6C65 6D65 6E74 636F"                    /* ed.....make.Make a new elementco */
	$"7265 6372 656C 6F62 6A20 244F 626A 6563 7420 7370 6563 6966 6965 7220 666F 7220"                    /* recrelobj $Object specifier for  */
	$"7468 6520 6E65 7720 656C 656D 656E 7400 0000 6E75 6C6C 0000 9000 0004 036E 6577"                    /* the new element...null..�....new */
	$"6B6F 636C 7479 7065 1C74 6865 2063 6C61 7373 206F 6620 7468 6520 6E65 7720 656C"                    /* kocltype.the class of the new el */
	$"656D 656E 7400 0000 0261 7400 696E 7368 696E 736C 2B74 6865 206C 6F63 6174 696F"                    /* ement....at.inshinsl+the locatio */
	$"6E20 6174 2077 6869 6368 2074 6F20 696E 7365 7274 2074 6865 2065 6C65 6D65 6E74"                    /* n at which to insert the element */
	$"8000 0977 6974 6820 6461 7461 6461 7461 2A2A 2A2A 2074 6865 2069 6E69 7469 616C"                    /* �.�with datadata**** the initial */
	$"2064 6174 6120 666F 7220 7468 6520 656C 656D 656E 7400 8000 0F77 6974 6820 7072"                    /*  data for the element.�..with pr */
	$"6F70 6572 7469 6573 7072 6474 7265 636F 3474 6865 2069 6E69 7469 616C 2076 616C"                    /* opertiesprdtreco4the initial val */
	$"7565 7320 666F 7220 7468 6520 7072 6F70 6572 7469 6573 206F 6620 7468 6520 656C"                    /* ues for the properties of the el */
	$"656D 656E 7400 8000 046F 7065 6E1C 4F70 656E 2074 6865 2073 7065 6369 6669 6564"                    /* ement.�..open.Open the specified */
	$"206F 626A 6563 7428 7329 6165 7674 6F64 6F63 6E75 6C6C 0000 8000 6F62 6A20 3F4F"                    /*  object(s)aevtodocnull..�.obj ?O */
	$"626A 6563 7473 2074 6F20 6F70 656E 2E20 4361 6E20 6265 2061 206C 6973 7420 6F66"                    /* bjects to open. Can be a list of */
	$"2066 696C 6573 206F 7220 616E 206F 626A 6563 7420 7370 6563 6966 6965 722E 1000"                    /*  files or an object specifier... */
	$"0000 0570 7269 6E74 1D50 7269 6E74 2074 6865 2073 7065 6369 6669 6564 206F 626A"                    /* ...print.Print the specified obj */
	$"6563 7428 7329 6165 7674 7064 6F63 6E75 6C6C 0000 8000 6F62 6A20 404F 626A 6563"                    /* ect(s)aevtpdocnull..�.obj @Objec */
	$"7473 2074 6F20 7072 696E 742E 2043 616E 2062 6520 6120 6C69 7374 206F 6620 6669"                    /* ts to print. Can be a list of fi */
	$"6C65 7320 6F72 2061 6E20 6F62 6A65 6374 2073 7065 6369 6669 6572 2E00 0000 0000"                    /* les or an object specifier...... */
	$"0473 6176 6515 7361 7665 2061 2073 6574 206F 6620 6F62 6A65 6374 7300 636F 7265"                    /* .save.save a set of objects.core */
	$"7361 7665 6E75 6C6C 0000 0000 6F62 6A20 104F 626A 6563 7473 2074 6F20 7361 7665"                    /* savenull....obj .Objects to save */
	$"2E00 0000 0002 0269 6E00 6B66 696C 616C 6973 2774 6865 2066 696C 6520 696E 2077"                    /* .......in.kfilalis'the file in w */
	$"6869 6368 2074 6F20 7361 7665 2074 6865 206F 626A 6563 7428 7329 8000 0261 7300"                    /* hich to save the object(s)�..as. */
	$"666C 7470 7479 7065 3774 6865 2066 696C 6520 7479 7065 206F 6620 7468 6520 646F"                    /* fltptype7the file type of the do */
	$"6375 6D65 6E74 2069 6E20 7768 6963 6820 746F 2073 6176 6520 7468 6520 6461 7461"                    /* cument in which to save the data */
	$"8000 0373 6574 1453 6574 2061 6E20 6F62 6A65 6374 D573 2064 6174 6100 636F 7265"                    /* �..set.Set an object�s data.core */
	$"7365 7464 6E75 6C6C 0000 8000 6F62 6A20 1474 6865 206F 626A 6563 7420 746F 2063"                    /* setdnull..�.obj .the object to c */
	$"6861 6E67 6500 1000 0001 0274 6F00 6461 7461 2A2A 2A2A 0D74 6865 206E 6577 2076"                    /* hange......to.data****�the new v */
	$"616C 7565 0000 0003 0B61 7070 6C69 6361 7469 6F6E 6361 7070 1641 6E20 6170 706C"                    /* alue.....applicationcapp.An appl */
	$"6963 6174 696F 6E20 7072 6F67 7261 6D00 0000 0002 6377 696E 0003 696E 6478 6E61"                    /* ication program.....cwin..indxna */
	$"6D65 7265 6C65 646F 6375 0001 6E61 6D65 0677 696E 646F 7700 6377 696E 0841 2057"                    /* mereledocu..name.window.cwin.A W */
	$"696E 646F 7700 000C 0662 6F75 6E64 7300 7062 6E64 7164 7274 2574 6865 2062 6F75"                    /* indow....bounds.pbndqdrt%the bou */
	$"6E64 6172 7920 7265 6374 616E 676C 6520 666F 7220 7468 6520 7769 6E64 6F77 1000"                    /* ndary rectangle for the window.. */
	$"0963 6C6F 7365 6162 6C65 6863 6C62 626F 6F6C 2144 6F65 7320 7468 6520 7769 6E64"                    /* �closeablehclbbool!Does the wind */
	$"6F77 2068 6176 6520 6120 636C 6F73 6520 626F 783F 0000 0674 6974 6C65 6400 7074"                    /* ow have a close box?...titled.pt */
	$"6974 626F 6F6C 2144 6F65 7320 7468 6520 7769 6E64 6F77 2068 6176 6520 6120 7469"                    /* itbool!Does the window have a ti */
	$"746C 6520 6261 723F 0000 0569 6E64 6578 7069 6478 6C6F 6E67 1874 6865 206E 756D"                    /* tle bar?...indexpidxlong.the num */
	$"6265 7220 6F66 2074 6865 2077 696E 646F 7700 1000 0866 6C6F 6174 696E 6700 6973"                    /* ber of the window....floating.is */
	$"666C 626F 6F6C 1644 6F65 7320 7468 6520 7769 6E64 6F77 2066 6C6F 6174 3F00 0000"                    /* flbool.Does the window float?... */
	$"056D 6F64 616C 706D 6F64 626F 6F6C 1449 7320 7468 6520 7769 6E64 6F77 206D 6F64"                    /* .modalpmodbool.Is the window mod */
	$"616C 3F00 0000 0972 6573 697A 6162 6C65 7072 737A 626F 6F6C 1849 7320 7468 6520"                    /* al?...�resizableprszbool.Is the  */
	$"7769 6E64 6F77 2072 6573 697A 6162 6C65 3F00 0000 087A 6F6F 6D61 626C 6500 6973"                    /* window resizable?....zoomable.is */
	$"7A6D 626F 6F6C 1749 7320 7468 6520 7769 6E64 6F77 207A 6F6F 6D61 626C 653F 0000"                    /* zmbool.Is the window zoomable?.. */
	$"067A 6F6F 6D65 6400 707A 756D 626F 6F6C 1549 7320 7468 6520 7769 6E64 6F77 207A"                    /* .zoomed.pzumbool.Is the window z */
	$"6F6F 6D65 643F 1000 046E 616D 6500 706E 616D 6974 7874 1774 6865 2074 6974 6C65"                    /* oomed?...name.pnamitxt.the title */
	$"206F 6620 7468 6520 7769 6E64 6F77 1000 0776 6973 6962 6C65 7076 6973 626F 6F6C"                    /*  of the window...visiblepvisbool */
	$"1669 7320 7468 6520 7769 6E64 6F77 2076 6973 6962 6C65 3F00 0000 0870 6F73 6974"                    /* .is the window visible?....posit */
	$"696F 6E00 7070 6F73 5144 7074 2075 7070 6572 206C 6566 7420 636F 6F72 6469 6E61"                    /* ion.pposQDpt upper left coordina */
	$"7465 7320 6F66 2077 696E 646F 7700 0000 0000 0864 6F63 756D 656E 7400 646F 6375"                    /* tes of window......document.docu */
	$"0A41 2044 6F63 756D 656E 7400 0002 046E 616D 6500 706E 616D 6974 7874 1974 6865"                    /* .A Document....name.pnamitxt.the */
	$"2074 6974 6C65 206F 6620 7468 6520 646F 6375 6D65 6E74 0000 086D 6F64 6966 6965"                    /*  title of the document...modifie */
	$"6400 696D 6F64 626F 6F6C 3348 6173 2074 6865 2064 6F63 756D 656E 7420 6265 656E"                    /* d.imodbool3Has the document been */
	$"206D 6F64 6966 6965 6420 7369 6E63 6520 7468 6520 6C61 7374 2073 6176 653F 0000"                    /*  modified since the last save?.. */
	$"0000 0000 0001 7361 766F 0003 0379 6573 7965 7320 1053 6176 6520 6F62 6A65 6374"                    /* ......savo...yesyes .Save object */
	$"7320 6E6F 7700 026E 6F00 6E6F 2020 1344 6F20 6E6F 7420 7361 7665 206F 626A 6563"                    /* s now..no.no  .Do not save objec */
	$"7473 0361 736B 6173 6B20 1C41 736B 2074 6865 2075 7365 7220 7768 6574 6865 7220"                    /* ts.askask .Ask the user whether  */
	$"746F 2073 6176 6500 174D 6973 6365 6C6C 616E 656F 7573 2053 7461 6E64 6172 6473"                    /* to save..Miscellaneous Standards */
	$"2C55 7365 6675 6C20 6576 656E 7473 2074 6861 7420 6172 656E D574 2069 6E20 616E"                    /* ,Useful events that aren�t in an */
	$"7920 6F74 6865 7220 7375 6974 6500 6D69 7363 0000 0000 0001 0672 6576 6572 7433"                    /* y other suite.misc.......revert3 */
	$"5265 7665 7274 2061 6E20 6F62 6A65 6374 2074 6F20 7468 6520 6D6F 7374 2072 6563"                    /* Revert an object to the most rec */
	$"656E 746C 7920 7361 7665 6420 7665 7273 696F 6E00 6D69 7363 7276 7274 6E75 6C6C"                    /* ently saved version.miscrvrtnull */
	$"0000 8000 6F62 6A20 106F 626A 6563 7420 746F 2072 6576 6572 7400 0000 0000 0000"                    /* ..�.obj .object to revert....... */
	$"0000 0000 0D6F 6464 7320 616E 6420 656E 6473 3854 6869 6E67 7320 7468 6174 2073"                    /* ....�odds and ends8Things that s */
	$"686F 756C 6420 6265 2069 6E20 736F 6D65 2073 7461 6E64 6172 6420 7375 6974 652C"                    /* hould be in some standard suite, */
	$"2062 7574 2061 7265 6ED5 7400 4F64 6473 0001 0001 0001 0673 656C 6563 741B 5365"                    /*  but aren�t.Odds.......select.Se */
	$"6C65 6374 2074 6865 2073 7065 6369 6669 6564 206F 626A 6563 7400 6D69 7363 736C"                    /* lect the specified object.miscsl */
	$"6374 6E75 6C6C 0000 8000 6F62 6A20 1474 6865 206F 626A 6563 7420 746F 2073 656C"                    /* ctnull..�.obj .the object to sel */
	$"6563 7400 9000 0000 0000 0000 0000"                                                                 /* ect.�......... */
};









/*
 ********************************************************************************
 ************************************** Menus ***********************************
 ********************************************************************************
 */


resource 'MBAR' (MBAR_Initial, purgeable) {
	{
		kAppleMenuID,
		kFileMenuID,
		kEditMenuID,
		kSelectMenuID,
		kInsertMenuID,
		kFormatMenuID,
		kRemoveMenuID,
		kOptionsMenuID,
		kWindowsMenuID,
	}
};
resource 'MENU' (kAppleMenuID) {
	kAppleMenuID,
	textMenuProc,
	0x7FFFFFFD,
	enabled,
	apple,
	{
		"About LedIt!�", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain
	}
};
resource 'Mcmd' (kAppleMenuID, purgeable) {
	{
		cmd_About
	}
};
resource 'hmnu' (kAppleMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Find out a little about this application, its authors, and the Led Class Library.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (kFileMenuID) {
	kFileMenuID,
	textMenuProc,
	0x7FFFFC03,
	enabled,
	"File",
	{
		"New", noIcon, "N", noMark, plain,
		"Open�", noIcon, "O", noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Close", noIcon, "W", noMark, plain,
		"Save", noIcon, "S", noMark, plain,
		"Save As�", noIcon, noKey, noMark, plain,
		"Save A Copy As�", noIcon, noKey, noMark, plain,
		"Revert", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Page Setup�", noIcon, noKey, noMark, plain,
		"Print�", noIcon, "P", noMark, plain,
		"Print One", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Quit", noIcon, "Q", noMark, plain
	}
};
resource 'Mcmd' (kFileMenuID, purgeable) {
	{
		cmd_New,
		cmd_Open,
		msg_Nothing,
		cmd_Close,
		cmd_Save,
		cmd_SaveAs,
		kCmdSaveACopyAs,
		cmd_Revert,
		msg_Nothing,
		cmd_PageSetup,
		cmd_Print,
		cmd_PrintOne,
		msg_Nothing,
		cmd_Quit
	}
};
resource 'hmnu' (kFileMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"File menu.\n\nVarious file-oriented commands, opening, closing, etc.",
				"",
				"",
				""
			},
		HMStringItem {
				"Create a new document.",
				"",
				"",
				""
			},
		HMStringItem {
				"Open an existing file.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Close the currently active window",
				"There is no currently active window to close.",
				"",
				""
			},
		HMStringItem {
				"Save the text in the currently active window into the currently associated file. If the document is not currently associated with a file, you will be prompted to pick one.",
				"There either is no currently active window, or the currently active window has not been changed since last saved.",
				"",
				""
			},
		HMStringItem {
				"Save the text in the currently active window into a new file. This command also then associates the document with that newly specified file for future save/revert operations.",
				"There is no currently active window.",
				"",
				""
			},
		HMStringItem {
				"Save the text in the currently active window into a new file. This command does NOT associate the document with that newly created file.",
				"There is no currently active window.",
				"",
				""
			},
		HMStringItem {
				"Restore the contents of the current window to those present at the last save command.",
				"Cannot revert contents of this window to those saved on disk because either there is no current window, or the current window has not been saved to disk, or the contents are already the same as those on disk.",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Set various printing options.",
				"",
				"",
				""
			},
		HMStringItem {
				"Print the current document. You will first be prompted to set various options, like page ranges, etc.",
				"No current document to print.",
				"",
				""
			},
		HMStringItem {
				"Print one copy of all the contents of the currently active document.",
				"No current document to print.",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Exit the LedIt! application. If you have any documents which have been modified since last saved, you will be promted to save these.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (kEditMenuID) {
	kEditMenuID,
	textMenuProc,
	0x7FFFFF80,
	enabled,
	"Edit",
	{
		"Undo", noIcon, "Z", noMark, plain,
		"ReDo", noIcon, "Y", noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Cut", noIcon, "X", noMark, plain,
		"Copy", noIcon, "C", noMark, plain,
		"Paste", noIcon, "V", noMark, plain,
		"Clear", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Properties", noIcon, noKey, noMark, plain,
		"Open Embedding", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (kEditMenuID, purgeable) {
	{
		kCmdUndo,
		kCmdRedo,
		msg_Nothing,
		kCmdCut,
		kCmdCopy,
		kCmdPaste,
		kCmdClear,
		msg_Nothing,
		kPropertiesForSelectionCmd,
		kFirstPrivateEmbeddingCmd,
	}
};
resource 'hmnu' (kEditMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Edit menu.\n\nThis menu contains various commands to apply to the currently selected text. These include clipboard operations, undo/redo, searching, and operations on currently selected objects.",
				"",
				"",
				""
			},
		HMStringItem {
				"Undo the last few command(s). Note LedIt! supports multilevel undo, so you can undo several commands. And then redo them. And go back and forth.",
				"",
				"",
				""
			},
		HMStringItem {
				"Redo a previously undone command.",
				"There have been no commands recently undone.",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Move the currently selected text and/or objects to the clipboard. This command removes the currently selected text (or objects) from the document.",
				"There is no non-empty selection in the currently active document.",
				"",
				""
			},
		HMStringItem {
				"Copy the currently selected text and/or objects to the clipboard. This command doesn't affect the contents of the document.",
				"There is no non-empty selection in the currently active document.",
				"",
				""
			},
		HMStringItem {
				"This command obliterates the current selection (if any) and replaces it with the text (or other objects) currently stored on the clipboard.",
				"There is nothing on the clipboard that LedIt! knows how to insert into the currently active document.",
				"",
				""
			},
		HMStringItem {
				"This command deletes the contents of the current selection (if any)",
				"There is no non-empty selection in the currently active document.",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Edit the properties of the selected object.",
				"There currently selected object.",
				"",
				""
			},
	}
};
resource 'MENU' (kSelectMenuID) {
	kSelectMenuID,
	textMenuProc,
	0x7FFFFFFF,
	enabled,
	"Select",
	{
		"Select Word(s)", noIcon, noKey, noMark, plain,
		"Select Text Row(s)", noIcon, noKey, noMark, plain,
		"Select Paragraph(s)", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Select All in Cell", noIcon, noKey, noMark, plain,
		"Select Table Cell", noIcon, noKey, noMark, plain,
		"Select Table Row(s)", noIcon, noKey, noMark, plain,
		"Select Table Column(s)", noIcon, noKey, noMark, plain,
		"Select Table", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Select All", noIcon, "A", noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Find�", noIcon, "F", noMark, plain,
		"Find Again", noIcon, "G", noMark, plain,
		"Enter 'Find' String", noIcon, "E", noMark, plain,
		"Replace�", noIcon, "H", noMark, plain,
		"Replace Again", noIcon, "R", noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Spellcheck�", noIcon, "L", noMark, plain,
	}
};
resource 'Mcmd' (kSelectMenuID, purgeable) {
	{
		kSelectWordCmd,
		kSelectTextRowCmd,
		kSelectParagraphCmd,
		msg_Nothing,
		kSelectTableIntraCellAllCmd,
		kSelectTableCellCmd,
		kSelectTableRowCmd,
		kSelectTableColumnCmd,
		kSelectTableCmd,
		msg_Nothing,
		kCmdSelectAll,
		msg_Nothing,
		kFindCmd,
		kFindAgainCmd,
		kEnterFindStringCmd,
		kReplaceCmd,
		kReplaceAgainCmd,
		msg_Nothing,
		kSpellCheckCmd,
	}
};
resource 'hmnu' (kSelectMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Select menu.\n\nThis menu contains things that can be selected.",
				"",
				"",
				""
			},
		HMStringItem {
				"Select the current word.",
				"",
				"",
				""
			},
		HMStringItem {
				"Select the current row.",
				"",
				"",
				""
			},
		HMStringItem {
				"Select the current paragraph.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Select all the text in the currently edited cell.",
				"",
				"",
				""
			},
		HMStringItem {
				"Select the table cell.",
				"",
				"",
				""
			},
		HMStringItem {
				"Select the table row.",
				"",
				"",
				""
			},
		HMStringItem {
				"Select the table column.",
				"",
				"",
				""
			},
		HMStringItem {
				"Select the table.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Select All of the text.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Put up a dialog to enter a string to search for, and some other search parameters. And then search for that string.",
				"",
				"",
				""
			},
		HMStringItem {
				"Search for the same string last specified in a 'Find' command, or specified with 'Enter Find String'.",
				"",
				"",
				""
			},
		HMStringItem {
				"Use the currently selected text as the default string to search for in the next 'Find', or 'Find Again' command.",
				"There is currently no selection in the active document.",
				"",
				""
			},
		HMStringItem {
				"Put up a dialog to enter a string to search for and one to replace, and some other search parameters. And then search/replace those strings.",
				"",
				"",
				""
			},
		HMStringItem {
				"Find the same text last searched for again, and replace with the last replaced string. Same as Replace dialog, and just hitting OK.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Put up a dialog to check for misspelled words in the current document.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (kInsertMenuID) {
	kInsertMenuID,
	textMenuProc,
	0x7FFFFFFF,
	enabled,
	"Insert",
	{
		"Insert Table�", noIcon, noKey, noMark, plain,
		"Insert Tabl Row Above", noIcon, noKey, noMark, plain,
		"Insert Table Row Below", noIcon, noKey, noMark, plain,
		"Insert Table Column Before", noIcon, noKey, noMark, plain,
		"Insert Table Column After", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Insert URL�", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (kInsertMenuID, purgeable) {
	{
		kInsertTableCmd,
		kInsertTableRowAboveCmd,
		kInsertTableRowBelowCmd,
		kInsertTableColBeforeCmd,
		kInsertTableColAfterCmd,
		msg_Nothing,
		kInsertURLCmd
	}
};
resource 'hmnu' (kInsertMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Insert menu.\n\nThis menu contains objects that can be insered into the text buffer.",
				"",
				"",
				""
			},
		HMStringItem {
				"Insert a Table object.",
				"",
				"",
				""
			},
		HMStringItem {
				"Insert a Table Row above the insertion point.",
				"",
				"",
				""
			},
		HMStringItem {
				"Insert a Table Row below the insertion point.",
				"",
				"",
				""
			},
		HMStringItem {
				"Insert a Table column before the insertion point.",
				"",
				"",
				""
			},
		HMStringItem {
				"Insert a Table column after the insertion point.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Insert a URL object.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (kFormatMenuID) {
	kFormatMenuID,
	textMenuProc,
	0x7FFFFFFF,
	enabled,
	"Format",
	{
		"Font", noIcon, hierarchicalMenu, "\0Xfa", plain,
		"Style", noIcon, hierarchicalMenu, "\0Xfc", plain,
		"Size", noIcon, hierarchicalMenu, "\0Xfb", plain,
		"Color", noIcon, hierarchicalMenu, "\0Xfd", plain,
		"-", noIcon, noKey, noMark, plain,
		"Justification", noIcon, hierarchicalMenu, "\0Xfe", plain,
		"Paragraph Indents�", noIcon, noKey, noMark, plain,
		"Paragraph Spacing�", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"List Style", noIcon, hierarchicalMenu, "\0Xf9", plain,
		"Increase List Indent", noIcon, noKey, noMark, plain,
		"Decrease List Indent", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (kFormatMenuID, purgeable) {
	{
		cmd_FontMenu,
		cmd_StyleMenu,
		cmd_SizeMenu,
		cmd_ColorMenu,
		msg_Nothing,
		cmd_JustificationMenu,
		kParagraphIndentsCmd,
		kParagraphSpacingCmd,
		msg_Nothing,
		cmd_ListStyleMenu,
		kIncreaseIndentCmd,
		kDecreaseIndentCmd
	}
};
resource 'hmnu' (kFormatMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Format menu.\n\nThis menu contains commands to change the formatting of text. If there is a selection, these commands apply to that selection. If there is no selection, the formatting will apply to newly typed text after the current insertion point.",
				"",
				"",
				""
			},
		HMStringItem {
				"Fonts under this hierarchical menu.",
				"",
				"",
				""
			},
		HMStringItem {
				"Font styles are listed under this hierarchical menu.",
				"",
				"",
				""
			},
		HMStringItem {
				"Font sizes are listed under this hierarchical menu.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Paragraph justifications are listed under this hierarchical menu.",
				"",
				"",
				""
			},
		HMStringItem {
				"Set the left, right and first-line (hanging) indents for the selected paragraphs.",
				"",
				"",
				""
			},
		HMStringItem {
				"Set the spacing (above and below) for the selected paragraphs.",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"List styles are listed under this hierarchical menu.",
				"",
				"",
				""
			},
		HMStringItem {
				"Indent the lists to the right.",
				"",
				"",
				""
			},
		HMStringItem {
				"Indent the lists to the left.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (cmd_ListStyleMenu) {
	cmd_ListStyleMenu,
	textMenuProc,
	allEnabled,
	enabled,
	"List Style",
	{
		"None", noIcon, noKey, noMark, plain,
		"Bullet", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (cmd_ListStyleMenu, purgeable) {
	{
		kListStyle_NoneCmd,
		kListStyle_BulletCmd
	}
};
resource 'hmnu' (cmd_ListStyleMenu, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Apply the list style to the selected paragraphs.",
				"",
				"",
				""
			},
		HMStringItem {	"Change the selected text to NO list style.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this list style.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this list style.",	"No text selected",	"",	""	},
	}
};
resource 'MENU' (cmd_FontMenu) {
	cmd_FontMenu,
	textMenuProc,
	allEnabled,
	enabled,
	"Font",
	{
	}
};
resource 'Mcmd' (cmd_FontMenu, purgeable) {
	{
	}
};
resource 'hmnu' (cmd_FontMenu, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Apply the given fonts to the currently selected text.",
				"",
				"",
				""
			},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
		HMStringItem {	"Change the selected text to this font.",	"No text selected",	"",	""	},
	}
};
resource 'MENU' (cmd_SizeMenu) {
	cmd_SizeMenu,
	textMenuProc,
	allEnabled,
	enabled,
	"Size",
	{
		"9 pt", noIcon, noKey, noMark, plain,
		"10 pt", noIcon, noKey, noMark, plain,
		"12 pt", noIcon, noKey, noMark, plain,
		"14 pt", noIcon, noKey, noMark, plain,
		"18 pt", noIcon, noKey, noMark, plain,
		"24 pt", noIcon, noKey, noMark, plain,
		"36 pt", noIcon, noKey, noMark, plain,
		"48 pt", noIcon, noKey, noMark, plain,
		"72 pt", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain;
		"Smaller", noIcon, "-", noMark, plain,
		"Larger", noIcon, "=", noMark, plain,
		"-", noIcon, noKey, noMark, plain;
		"Other�", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (cmd_SizeMenu, purgeable) {
	{
		kFontSize9Cmd,
		kFontSize10Cmd,
		kFontSize12Cmd,
		kFontSize14Cmd,
		kFontSize18Cmd,
		kFontSize24Cmd,
		kFontSize36Cmd,
		kFontSize48Cmd,
		kFontSize72Cmd,
		msg_Nothing,
		kFontSizeSmallerCmd,
		kFontSizeLargerCmd,
		msg_Nothing,
		kFontSizeOtherCmd
	}
};
resource 'hmnu' (cmd_SizeMenu, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Change the size of the font of the currently selected text to one of these sizes.",
				"",
				"",
				""
			},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 9 point.",	"",	"This text (or insertion point) is all 9 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 10 point.",	"",	"This text (or insertion point) is all 10 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 12 point.",	"",	"This text (or insertion point) is all 12 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 14 point.",	"",	"This text (or insertion point) is all 14 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 18 point.",	"",	"This text (or insertion point) is all 18 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 24 point.",	"",	"This text (or insertion point) is all 24 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 36 point.",	"",	"This text (or insertion point) is all 36 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 48 point.",	"",	"This text (or insertion point) is all 48 point.",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to 72 point.",	"",	"This text (or insertion point) is all 72 point.",	""	},
		HMSkipItem {},	/* separator line */
		HMStringItem {	"Change the selected text (or newly created text if none selected) to a slightly smaller point size.",	"",	"",	""	},
		HMStringItem {	"Change the selected text (or newly created text if none selected) to a slightly larger point size.",	"",	"",	""	},
		HMSkipItem {},	/* separator line */
		HMStringItem {	"Change the selected text (or newly created text if none selected) to an arbitrary point size (chosen from a dialog).",	"",	"",	""	},
	}
};
resource 'MENU' (cmd_StyleMenu) {
	cmd_StyleMenu,
	textMenuProc,
	allEnabled,
	enabled,
	"Style",
	{
		"Plain Text", noIcon, "T", noMark, plain,
		"-", noIcon, noKey, noMark, plain;
		"Bold", noIcon, "B", noMark, 1,
		"Italic", noIcon, "I", noMark, 2,
		"Underline", noIcon, "U", noMark, 4,
		"Outline", noIcon, noKey, noMark, 8,
		"Shadow", noIcon, noKey, noMark, 16,
		"Condensed", noIcon, noKey, noMark, 32,
		"Extended", noIcon, noKey, noMark, 64,
		"SubScript", noIcon, noKey, noMark, plain,
		"SuperScript", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (cmd_StyleMenu, purgeable) {
	{
		kFontStylePlainCmd,
		msg_Nothing,
		kFontStyleBoldCmd,
		kFontStyleItalicCmd,
		kFontStyleUnderlineCmd,
		kFontStyleOutlineCmd,
		kFontStyleShadowCmd,
		kFontStyleCondensedCmd,
		kFontStyleExtendedCmd,
		kSubScriptCmd,
		kSuperScriptCmd,
	}
};
resource 'hmnu' (cmd_StyleMenu, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Apply the given styles to the currently selected text.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to plain (remove any styles)",
				"",
				"",
				""
			},
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Change the selected text to bold.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to italic.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to underline.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to outline.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to shadow.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to condensed.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to extended.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to subscript.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change the selected text to superscript.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (cmd_ColorMenu) {
	cmd_ColorMenu,
	textMenuProc,
	allEnabled,
	enabled,
	"Color",
	{
		"Black", noIcon, noKey, noMark, plain,
		"Maroon", noIcon, noKey, noMark, plain,
		"Green", noIcon, noKey, noMark, plain,
		"Olive", noIcon, noKey, noMark, plain,
		"Navy", noIcon, noKey, noMark, plain,
		"Purple", noIcon, noKey, noMark, plain,
		"Teal", noIcon, noKey, noMark, plain,
		"Gray", noIcon, noKey, noMark, plain,
		"Silver", noIcon, noKey, noMark, plain,
		"Red", noIcon, noKey, noMark, plain,
		"Lime", noIcon, noKey, noMark, plain,
		"Yellow", noIcon, noKey, noMark, plain,
		"Blue", noIcon, noKey, noMark, plain,
		"Fuchsia", noIcon, noKey, noMark, plain,
		"Aqua", noIcon, noKey, noMark, plain,
		"White", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain;
		"Other�", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (cmd_ColorMenu, purgeable) {
	{
		kBlackColorCmd,
		kMaroonColorCmd,
		kGreenColorCmd,
		kOliveColorCmd,
		kNavyColorCmd,
		kPurpleColorCmd,
		kTealColorCmd,
		kGrayColorCmd,
		kSilverColorCmd,
		kRedColorCmd,
		kLimeColorCmd,
		kYellowColorCmd,
		kBlueColorCmd,
		kFuchsiaColorCmd,
		kAquaColorCmd,
		kWhiteColorCmd,
		msg_Nothing,
		kFontColorOtherCmd,
	}
};
resource 'hmnu' (cmd_ColorMenu, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Change the color of the font of the currently selected text to one of these.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (cmd_JustificationMenu) {
	cmd_JustificationMenu,
	textMenuProc,
	allEnabled,
	enabled,
	"Justification",
	{
		"Left", noIcon, noKey, noMark, plain,
		"Center", noIcon, noKey, noMark, plain,
		"Right", noIcon, noKey, noMark, plain,
		"Full", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (cmd_JustificationMenu, purgeable) {
	{
		kJustifyLeftCmd,
		kJustifyCenterCmd,
		kJustifyRightCmd,
		kJustifyFullCmd,
	}
};
resource 'hmnu' (cmd_JustificationMenu, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Change paragraph to left justified.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change paragraph to center justified.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change paragraph to right justified.",
				"",
				"",
				""
			},
		HMStringItem {
				"Change paragraph to fully justified.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (kRemoveMenuID) {
	kRemoveMenuID,
	textMenuProc,
	0x7FFFFFFF,
	enabled,
	"Remove",
	{
		"Remove Rows", noIcon, noKey, noMark, plain,
		"Remove Columns", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain,
		"Hide Selection", noIcon, noKey, noMark, plain,
		"Unhide Selection", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (kRemoveMenuID, purgeable) {
	{
		kRemoveTableRowsCmd,
		kRemoveTableColumnsCmd,
		msg_Nothing,
		kHideSelectionCmd,
		kUnHideSelectionCmd,
	}
};
resource 'hmnu' (kRemoveMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Remove menu.\n\nThis menu contains commands relating to removing or hiding selected items.",
				"",
				"",
				""
			},
		HMStringItem { "Remove selected rows.", "", "", "" },
		HMStringItem { "Remove selected columns", "", "", "" },
		HMSkipItem {},	/* separator line */
		HMStringItem {
				"Hide the selected text.",
				"",
				"",
				""
			},
		HMStringItem {
				"Unhide any hidden text in the selected region.",
				"",
				"",
				""
			},
	}
};
resource 'MENU' (kOptionsMenuID) {
	kOptionsMenuID,
	textMenuProc,
	0x7FFFFFFD,
	enabled,
	"Options",
	{
		"Smart Cut and Paste", noIcon, noKey, noMark, plain,
		"Wrap to Window", noIcon, noKey, noMark, plain,
		"Hidden Text Shown", noIcon, noKey, noMark, plain,
		"Show Paragraph Marks", noIcon, noKey, noMark, plain,
		"Show Tab Marks", noIcon, noKey, noMark, plain,
		"Show Space Marks", noIcon, noKey, noMark, plain,
	}
};
resource 'Mcmd' (kOptionsMenuID, purgeable) {
	{
		kToggleUseSmartCutNPasteCmd,
		kToggleWrapToWindowCmd,
		kToggleShowHiddenTextCmd,
		kShowHideParagraphGlyphsCmd,
		kShowHideTabGlyphsCmd,
		kShowHideSpaceGlyphsCmd,
	}
};
resource 'hmnu' (kOptionsMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Options menu.\n\nThis menu contains options which allow you to try out LedIt! features.",
				"",
				"",
				""
			},
		HMStringItem { "Enable/disable smart cut and paste.", "", "", "" },
		HMStringItem { "Wrap to window (or use ruler).", "", "", "" },
		HMStringItem { "Show/Hide hidden text (text with the 'hidable text' attribute).", "", "", "" },
		HMStringItem { "Show/Hide paragraph markers.", "", "", "" },
		HMStringItem { "Show/Hide tab markers.", "", "", "" },
		HMStringItem { "Show/Hide (invisible) spaces.", "", "", "" },
	}
};
resource 'MENU' (kWindowsMenuID) {
	kWindowsMenuID,
	textMenuProc,
	0x7FFFFFFD,
	enabled,
	"Windows",
	{
	}
};
resource 'Mcmd' (kWindowsMenuID, purgeable) {
	{
	}
};
resource 'hmnu' (kWindowsMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Windows menu.\n\nThis menu contains a list of all open documents. Selecting an item brings that window to the front.",
				"",
				"",
				""
			},
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
		HMStringItem { "Bring this window to the front.", "", "", "" },
	}
};
resource 'hmnu' (kHMHelpMenuID, purgeable) {
	HelpMgrVersion, hmDefaultOptions, 0, 0,
	HMSkipItem {},	/* no missing items */
	{
		HMStringItem {
				"Browse LedIt! help information using your default HTML browser.",
				"",
				"",
				""
			},
	}
};








resource 'PICT' (kUnknownEmbeddingPictID, purgeable) {
	472,
	{2, 2, 30, 30},
	$"0011 02FF 0C00 FFFF FFFF 0002 0000 0002 0000 001E 0000 001E 0000 0000 0000 00A0"
	$"0082 001E 0001 000A 0000 0000 0020 0020 0098 801C 0002 0002 001E 001E 0000 0000"
	$"0000 0000 0048 0000 0048 0000 0000 0008 0001 0008 0000 0000 0194 F9AC 0000 0000"
	$"0000 5717 0000 0004 0000 FFFF FFFF FFFF 0001 1111 0000 0000 0002 BBBB BBBB BBBB"
	$"0003 EEEE 0000 0000 00FF 0000 0000 0000 0002 0002 001E 001E 0002 0002 001E 001E"
	$"0000 02E5 0106 0001 E702 0001 0600 01E7 0200 0106 0001 E702 0001 0600 01E7 0200"
	$"010A 0001 F702 FA03 F802 0001 0F00 01F8 0200 03FB 0201 0303 F902 0001 0E00 01F9"
	$"0200 03F9 0200 03F9 0200 010F 0001 FA02 0103 03F9 0200 03F9 0200 010E 0001 FA02"
	$"0003 F802 0003 F902 0001 0A00 01F0 0200 03F9 0200 010A 0001 F002 0003 F902 0001"
	$"0F00 01F6 0201 0303 FE02 0003 F802 0001 0F00 01F6 0205 0303 0202 0303 F802 0001"
	$"0A00 01F6 02FC 03F7 0200 010B 0001 F602 0103 03F4 0200 010B 0001 F602 0103 03F4"
	$"0200 010B 0001 F602 0103 03F4 0200 010B 0001 F602 0103 03F4 0200 010B 0001 F602"
	$"0103 03F4 0200 0106 0001 E702 0001 0A00 01F7 02FD 03F5 0200 010A 0001 F702 FD03"
	$"F502 0001 0A00 01F7 02FD 03F5 0200 0106 0001 E702 0001 0600 01E7 0200 0106 0001"
	$"E702 0001 02E5 0100 00A0 0083 00FF"
};


resource 'PICT' (kUnsupportedDIBFormatPictID, purgeable) {
	1422,
	{0, 0, 64, 64},
	$"0011 02FF 0C00 FFFF FFFF 0000 0000 0000 0000 0040 0000 0040 0000 0000 0000 00A0"
	$"0082 001E 0001 000A 0000 0000 0040 0040 0098 8040 0000 0000 0040 0040 0000 0000"
	$"0000 0000 0048 0000 0048 0000 0000 0008 0001 0008 0000 0000 0174 7F90 0000 0000"
	$"0000 50B4 0000 0003 0000 FFFF FFFF FFFF 0001 8888 8888 8888 0002 FFFF 0000 0000"
	$"00FF 0000 0000 0000 0000 0000 0040 0040 0000 0000 0040 0040 0000 02C1 FF06 00FF"
	$"C301 00FF 0600 FFC3 0100 FF06 00FF C301 00FF 0A00 FFFA 0100 00CB 0100 FF16 00FF"
	$"FC01 0202 0100 FD02 FC01 0002 FA01 0002 DD01 00FF 1400 FFFC 0102 0200 02FE 0100"
	$"02F4 0100 02DD 0100 FF12 00FF FB01 0002 FD01 0002 F301 0002 DE01 00FF 1600 FFFB"
	$"0100 02FD 0100 02FC 0100 02F9 0100 02DE 0100 FF1A 00FF FB01 0002 FD01 0002 FC01"
	$"0002 F901 0402 0101 0202 E201 00FF 1A00 FFFB 0100 02FD 0100 02FC 0101 0202 FA01"
	$"0102 01FD 02E3 0100 FF1C 00FF FB01 0002 FE01 0102 02FB 0100 02F9 0101 0200 FE01"
	$"0002 E401 00FF 1A00 FFFB 0100 02FE 0100 02FA 0100 02F9 0100 02FD 0100 02E4 0100"
	$"FF16 00FF FB01 FC02 FA01 0002 F901 FB02 ED01 0002 F901 00FF 1600 FFFB 0100 02F6"
	$"0100 02F9 0100 02E7 0100 02FA 0100 FF0E 00FF FB01 0002 D201 0002 FA01 00FF 0E00"
	$"FFF3 0100 02DA 0100 02FA 0100 FF0E 00FF F401 FD02 DC01 0002 FA01 00FF 1600 FFF5"
	$"0105 0202 0101 0202 DD01 0302 0201 02FD 0100 FF19 00FF F501 0002 FD01 0102 02F2"
	$"0101 0202 EE01 0102 02FC 0100 FF1F 00FF F501 0002 FC01 0002 F801 FE02 FE01 FC02"
	$"FB01 FE02 FB01 0102 02FB 0100 FF29 00FF F501 0002 F701 0002 FD01 0002 FD01 0202"
	$"0201 FE02 FD01 0402 0201 0102 FD01 0302 0201 02FB 0100 FF28 00FF F801 FA02 FD01"
	$"FE02 0101 02FE 0100 02FC 0101 0201 FE02 FD01 0002 FD01 0002 FB01 0002 FB01 00FF"
	$"2900 FFF6 0100 02F9 0100 02FE 0104 0202 0101 02FC 0104 0201 0201 02FD 0101 0201"
	$"FD02 FB01 0002 FB01 00FF 2900 FFF6 0100 02F9 0100 02FD 0103 0201 0102 FC01 0402"
	$"0102 0102 FD01 0002 FD01 0002 FA01 0002 FC01 00FF 2A00 FFF6 0100 02F9 0100 02FD"
	$"0100 02FE 0100 02FD 0100 02FE 0100 02FD 0100 02FC 0100 02FB 0100 02FC 0100 FF21"
	$"00FF F601 0102 02FA 0101 0202 FE01 0002 F901 0002 FE01 0102 02F8 0100 02F5 0100"
	$"FF12 00FF F501 0002 F801 FE02 F801 0002 E601 00FF 0600 FFC3 0100 FF06 00FF C301"
	$"00FF 0600 FFC3 0100 FF08 00FF C501 0202 01FF 0C00 FFCC 0100 02FB 0102 0201 FF0D"
	$"00FF CC01 0102 02FC 0102 0201 FF0C 00FF CB01 0002 FC01 0202 01FF 0C00 FFCB 0100"
	$"02FC 0102 0201 FF14 00FF DB01 FE02 F801 0402 0201 0102 FC01 0202 01FF 2C00 FFFE"
	$"0100 02FC 0100 02F7 0104 0201 0102 02F8 0107 0202 0101 0201 0202 FE01 FE02 0201"
	$"0102 FD01 FB02 0101 FF3A 00FF FD01 0002 FD01 0302 0201 01FE 02FD 0103 0201 0102"
	$"FE01 0502 0102 0102 01FD 0204 0102 0101 02FE 0107 0201 0102 0102 0101 FC02 0401"
	$"0202 01FF 3C00 FFFD 0100 02FD 0107 0202 0101 0201 0102 FE01 0302 0101 02FE 0105"
	$"0201 0201 0102 FE01 0502 0102 0102 02FE 01FD 0201 0102 FD01 0702 0201 0102 0201"
	$"FF38 00FF FC01 0402 0201 0102 FE01 1302 0101 0202 0101 0201 0102 0201 0102 0101"
	$"0201 02FE 0101 0201 FE02 FB01 0102 02FB 0101 0202 FE01 0202 01FF 2700 FFFB 01FD"
	$"02FE 0100 02FE 01FD 02FD 0106 0201 0201 0102 01FC 0202 0101 02F1 0101 0202 FD01"
	$"00FF 2000 FFEF 0101 0202 FE01 FE02 0001 FD02 0201 0102 FC01 0002 F001 0102 02FE"
	$"0100 FF0E 00FF E001 0002 FC01 0002 EB01 00FF 0E00 FFE0 0100 02FC 0100 02EB 0100"
	$"FF0E 00FF E001 0002 FC01 0002 EB01 00FF 0E00 FFE0 0100 02FC 0100 02EB 0100 FF0E"
	$"00FF E001 0002 FC01 0002 EB01 00FF 0A00 FFE0 0100 02E5 0100 FF06 00FF C301 00FF"
	$"0600 FFC3 0100 FF06 00FF C301 00FF 0600 FFC3 0100 FF06 00FF C301 00FF 0600 FFC3"
	$"0100 FF06 00FF C301 00FF 0600 FFC3 0100 FF06 00FF C301 00FF 0600 FFC3 0100 FF06"
	$"00FF C301 00FF 0600 FFC3 0100 FF06 00FF C301 00FF 0600 FFC3 0100 FF02 C1FF 00A0"
	$"0083 00FF"
};






/*
 ********************************************************************************
 ************************************ Strings ***********************************
 ********************************************************************************
 */
resource 'STR#' (STRx_Untitled, purgeable) {
	{
		"untitled",
		"untitled "
	}
};







/*
 ********************************************************************************
 *********************************** Text Traits ********************************
 ********************************************************************************
 */
resource 'Txtr' (kTextOrForAboutBoxTextTrait, purgeable) {
	9,
	0,
	center,
	srcOr,
	0,
	0,
	0,
	-1,
	"geneva"
};
resource 'Txtr' (kTextEntryFieldTextTrait, purgeable) {
	0,
	0,
	flushDefault,
	srcCopy,
	0,
	0,
	0,
	1,
	""
};
resource 'Txtr' (kStaticTextTrait, purgeable) {
	0,
	0,
	flushDefault,
	srcCopy,
	0,
	0,
	0,
	0,
	""
};
resource 'Txtr' (kButtonTextTrait, purgeable) {
	0,
	0,
	flushDefault,
	srcCopy,
	0,
	0,
	0,
	0,
	""
};
resource 'Txtr' (kCheckBoxAndRBTextTrait, purgeable) {
	0,
	0,
	flushDefault,
	srcCopy,
	0,
	0,
	0,
	0,
	""
};





/*
 ********************************************************************************
 **************************** Alerts and Dialogs ********************************
 ********************************************************************************
 */
resource 'wctb' (kLedStdDlg_AboutBoxID) {
	{
		wContentColor, 51992, 51992, 51992,
		wFrameColor, 0, 0, 0,
		wTextColor, 0, 0, 0,
		wHiliteColor, 0, 0, 0,
		wTitleBarColor, 65535, 65535, 65535
	}
};
resource 'PICT' (kLedStdDlg_AboutBoxID, purgeable) {
	34296,
	{0, 0, 204, 327},
	$"0011 02FF 0C00 FFFE 0000 0060 0000 0060 0000 0000 0000 0111 01B5 0000 0000 001E"
	$"0001 000A 8001 8001 7FFF 7FFF 009A 0000 00FF 86D4 0000 0000 0111 01B5 0000 0004"
	$"0000 0000 0048 0000 0048 0000 0010 0020 0003 0008 0000 0000 0322 A690 0322 A68C"
	$"0000 0000 0111 01B5 0000 0000 0111 01B5 0040 0018 81CE 81CE 81CE CCCE 81CF 81CF"
	$"81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE"
	$"81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE"
	$"0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE"
	$"81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF"
	$"81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF"
	$"81CE 81CE 81CE CCCE 001E 8CCE 009C 81CE 81CE C2CE 8CCF 009A 81CF 81CF C2CF 8CCE"
	$"009C 81CE 81CE C2CE 0060 F7CE DF00 B9CE 0131 9CFE CE03 9C31 3163 CFCE 029C 3163"
	$"B5CE 0263 6331 81CE CDCE F7CF DF00 B9CF 0130 9AFE CF03 9A30 3065 CFCF 029A 3065"
	$"B5CF 0265 6530 81CF CDCF F7CE DF00 B9CE 0131 9CFE CE03 9C31 3163 CFCE 029C 3163"
	$"B5CE 0263 6331 81CE CDCE 008A F7CE 0200 FFCE F2FF 03CE FFCE FFF7 CE01 9C00 B9CE"
	$"0331 63CE 9CFD 31D0 CE00 9CFE 3100 9CB6 CE03 3131 009C 81CE CDCE F7CF 0200 FFCF"
	$"F2FF 03CF FFCF FFF7 CF01 9A00 B9CF 0330 65CF 9AFD 30D0 CF00 9AFE 3000 9AB6 CF03"
	$"3030 009A 81CF CDCF F7CE 0200 FFCE F2FF 03CE FFCE FFF7 CE01 9C00 B9CE 0331 63CE"
	$"9CFD 31D0 CE00 9CFE 3100 9CB6 CE03 3131 009C 81CE CDCE 00A2 F7CE 0B00 FF63 3163"
	$"3163 3163 3163 31FE 6300 31FD 6303 9C63 9C63 FB9C 03CE 9CCE 00B9 CE04 319C CE63"
	$"9CCE CE01 9C63 B3CE 0031 81CE C9CE F7CF 0B00 FF65 3065 3065 3065 3065 30FE 6500"
	$"30FD 6503 9A65 9A65 FB9A 03CF 9ACF 00B9 CF04 309A CF65 9ACE CF01 9A65 B3CF 0030"
	$"81CF C9CF F7CE 0B00 FF63 3163 3163 3163 3163 31FE 6300 31FD 6303 9C63 9C63 FB9C"
	$"03CE 9CCE 00B9 CE04 319C CE63 9CCE CE01 9C63 B3CE 0031 81CE C9CE 00A2 F7CE 0300"
	$"FF31 63FE 3100 63FE 3103 6331 6331 FD63 009C FE63 019C 63FB 9C02 CE9C 00BA CE04"
	$"9C31 CE63 9CCE CE01 9C31 B3CE 0031 81CE C8CE F7CF 0300 FF30 65FE 3000 65FE 3003"
	$"6530 6530 FD65 009A FE65 019A 65FB 9A02 CF9A 00BA CF04 9A30 CF65 9ACE CF01 9A30"
	$"B3CF 0030 81CF C8CF F7CE 0300 FF31 63FE 3100 63FE 3103 6331 6331 FD63 009C FE63"
	$"019C 63FB 9C02 CE9C 00BA CE04 9C31 CE63 9CCE CE01 9C31 B3CE 0031 81CE C8CE 0102"
	$"F7CE 0600 FF63 3163 3163 F1FF 01CE CEFE 9C01 CE9C FECE 0000 C5CE F79C 0463 63CE"
	$"9C31 E3CE 0363 3131 63EF CE01 6363 FACE FE9C F7CE 029C 319C F7CE 0231 639C F5CE"
	$"019C 63E6 CE01 9C63 F5CE 029C 9C63 FD31 009C 81CE DCCE F7CF 0600 FF65 3065 3065"
	$"F1FF 01CF CFFE 9A01 CF9A FECF 0000 C5CF F79A 0465 65CF 9A30 E3CF 0365 3030 65EF"
	$"CF01 6565 FACF FE9A F7CF 029A 309A F7CF 0230 659A F5CF 019A 65E6 CF01 9A65 F5CF"
	$"029A 9A65 FD30 009A 81CF DCCF F7CE 0600 FF63 3163 3163 F1FF 01CE CEFE 9C01 CE9C"
	$"FECE 0000 C5CE F79C 0463 63CE 9C31 E3CE 0363 3131 63EF CE01 6363 FACE FE9C F7CE"
	$"029C 319C F7CE 0231 639C F5CE 019C 63E6 CE01 9C63 F5CE 029C 9C63 FD31 009C 81CE"
	$"DCCE 0135 F7CE 0100 FFFC 31F2 FF01 CECE FA9C 02CE 9C00 C8CE 0163 31F8 0006 3131"
	$"9CCE CE31 63E5 CE05 6331 6331 009C EFCE 0100 9CFD CE01 9C63 FE00 0031 F7CE 0231"
	$"0063 F8CE 0300 3100 31FB CE01 639C FECE 029C 0000 E6CE 0131 63F6 CE0A 3131 6331"
	$"009C 6331 0000 9C81 CEDE CEF7 CF01 00FF FC30 F2FF 01CF CFFA 9A02 CF9A 00C8 CF01"
	$"6530 F800 0630 309A CFCF 3065 E5CF 0565 3065 3000 9AEF CF01 009A FDCF 019A 65FE"
	$"0000 30F7 CF02 3000 65F8 CF03 0030 0030 FBCF 0165 9AFE CF02 9A00 00E6 CF01 3065"
	$"F6CF 0A30 3065 3000 9A65 3000 009A 81CF DECF F7CE 0100 FFFC 31F2 FF01 CECE FA9C"
	$"02CE 9C00 C8CE 0163 31F8 0006 3131 9CCE CE31 63E5 CE05 6331 6331 009C EFCE 0100"
	$"9CFD CE01 9C63 FE00 0031 F7CE 0231 0063 F8CE 0300 3100 31FB CE01 639C FECE 029C"
	$"0000 E6CE 0131 63F6 CE0A 3131 6331 009C 6331 0000 9C81 CEDE CE01 65F7 CE06 00FF"
	$"6331 6331 63F9 FF04 31FF 3131 FFFE 3104 00CE 9CCE 9CFE CE02 9CCE 00C9 CE02 319C"
	$"9CFE CE01 0031 F8CE 0100 9CE6 CE01 9C63 EBCE 019C 00FD CE06 6363 9CCE 9C00 31F7"
	$"CE02 9C00 63F9 CE04 31CE CE63 00FC CE02 6300 9CFE CE02 9C31 00E6 CE01 009C F8CE"
	$"019C 31FE CE01 0031 FECE 029C 0031 81CE DECE F7CF 0600 FF65 3065 3065 F9FF 0430"
	$"FF30 30FF FE30 0400 CF9A CF9A FECF 029A CF00 C9CF 0230 9A9A FECF 0100 30F8 CF01"
	$"009A E6CF 019A 65EB CF01 9A00 FDCF 0665 659A CF9A 0030 F7CF 029A 0065 F9CF 0430"
	$"CFCF 6500 FCCF 0265 009A FECF 029A 3000 E6CF 0100 9AF8 CF01 9A30 FECF 0100 30FE"
	$"CF02 9A00 3081 CFDE CFF7 CE06 00FF 6331 6331 63F9 FF04 31FF 3131 FFFE 3104 00CE"
	$"9CCE 9CFE CE02 9CCE 00C9 CE02 319C 9CFE CE01 0031 F8CE 0100 9CE6 CE01 9C63 EBCE"
	$"019C 00FD CE06 6363 9CCE 9C00 31F7 CE02 9C00 63F9 CE04 31CE CE63 00FC CE02 6300"
	$"9CFE CE02 9C31 00E6 CE01 009C F8CE 019C 31FE CE01 0031 FECE 029C 0031 81CE DECE"
	$"0168 F7CE 0300 FF31 63FE 31F4 FF03 CECE 9CCE FE9C 06CE 9CCE 9CCE 9C00 CACE 0131"
	$"9CFC CE01 0031 F9CE 029C 009C E7CE 029C 009C EBCE 0163 00FE CE01 6363 FECE 029C"
	$"0063 FECE 019C 00FC CE02 9C00 63F9 CE05 63CE CE63 0063 FDCE 0231 009C FDCE 0131"
	$"31E7 CE02 9C00 9CF9 CE01 9C31 FDCE 0100 31FD CE01 3100 81CE DECE F7CF 0300 FF30"
	$"65FE 30F4 FF03 CFCF 9ACF FE9A 06CF 9ACF 9ACF 9A00 CACF 0130 9AFC CF01 0030 F9CF"
	$"029A 009A E7CF 029A 009A EBCF 0165 00FE CF01 6565 FECF 029A 0065 FECF 019A 00FC"
	$"CF02 9A00 65F9 CF05 65CF CF65 0065 FDCF 0230 009A FDCF 0130 30E7 CF02 9A00 9AF9"
	$"CF01 9A30 FDCF 0100 30FD CF01 3000 81CF DECF F7CE 0300 FF31 63FE 31F4 FF03 CECE"
	$"9CCE FE9C 06CE 9CCE 9CCE 9C00 CACE 0131 9CFC CE01 0031 F9CE 029C 009C E7CE 029C"
	$"009C EBCE 0163 00FE CE01 6363 FECE 029C 0063 FECE 019C 00FC CE02 9C00 63F9 CE05"
	$"63CE CE63 0063 FDCE 0231 009C FDCE 0131 31E7 CE02 9C00 9CF9 CE01 9C31 FDCE 0100"
	$"31FD CE01 3100 81CE DECE 014A F7CE 0100 FFFC 63F7 FF01 31FF FC31 019C 9CFB CE01"
	$"9C00 CBCE 019C 31FB CE01 0063 F9CE 0263 009C E7CE 019C 00EA CE01 3131 FECE 0031"
	$"FDCE 0263 0063 FECE 0131 31FC CE02 9C00 9CF5 CE01 0063 FECE 039C 0000 63FD CE01"
	$"319C E7CE 019C 00F8 CE01 319C FDCE 0100 63FD CE01 3131 81CE DECE F7CF 0100 FFFC"
	$"65F7 FF01 30FF FC30 019A 9AFB CF01 9A00 CBCF 019A 30FB CF01 0065 F9CF 0265 009A"
	$"E7CF 019A 00EA CF01 3030 FECF 0030 FDCF 0265 0065 FECF 0130 30FC CF02 9A00 9AF5"
	$"CF01 0065 FECF 039A 0000 65FD CF01 309A E7CF 019A 00F8 CF01 309A FDCF 0100 65FD"
	$"CF01 3030 81CF DECF F7CE 0100 FFFC 63F7 FF01 31FF FC31 019C 9CFB CE01 9C00 CBCE"
	$"019C 31FB CE01 0063 F9CE 0263 009C E7CE 019C 00EA CE01 3131 FECE 0031 FDCE 0263"
	$"0063 FECE 0131 31FC CE02 9C00 9CF5 CE01 0063 FECE 039C 0000 63FD CE01 319C E7CE"
	$"019C 00F8 CE01 319C FDCE 0100 63FD CE01 3131 81CE DECE 029D F7CE 0100 FFFC 31F4"
	$"FF08 CECE 9C9C 63CE 9CCE 9CFE CE01 9C00 CBCE 0163 31FC CE02 9C00 63F9 CE01 6300"
	$"FECE 0263 0031 FCCE 049C 6300 319C F6CE 0131 00F6 CE03 6300 009C FCCE 089C 6331"
	$"0031 CECE 9C00 FDCE 0763 009C CE9C 3100 00FD 3103 CE9C 009C F5CE 0100 31FE CE03"
	$"009C 0063 FDCE 0000 FCCE 0F63 3100 319C CECE 9C00 31CE CE63 3100 9CFD CE03 6331"
	$"0000 F9CE 029C 009C FECE 029C 0063 FDCE 0B31 31CE 9C31 00CE CE9C 3100 63FE CE04"
	$"6331 0031 9CFD CE04 9C31 0000 9CFD CE02 3100 00FD CE00 9CFE 0004 9CCE CE9C 63FE"
	$"0000 9CFD CE03 3100 0063 FECE 079C 0063 CECE 6300 00A4 CEF7 CF01 00FF FC30 F4FF"
	$"08CF CF9A 9A65 CF9A CF9A FECF 019A 00CB CF01 6530 FCCF 029A 0065 F9CF 0165 00FE"
	$"CF02 6500 30FC CF04 9A65 0030 9AF6 CF01 3000 F6CF 0365 0000 9AFC CF08 9A65 3000"
	$"30CF CF9A 00FD CF07 6500 9ACF 9A30 0000 FD30 03CF 9A00 9AF5 CF01 0030 FECF 0300"
	$"9A00 65FD CF00 00FC CF0F 6530 0030 9ACF CF9A 0030 CFCF 6530 009A FDCF 0365 3000"
	$"00F9 CF02 9A00 9AFE CF02 9A00 65FD CF0B 3030 CF9A 3000 CFCF 9A30 0065 FECF 0465"
	$"3000 309A FDCF 049A 3000 009A FDCF 0230 0000 FDCF 009A FE00 049A CFCF 9A65 FE00"
	$"009A FDCF 0330 0000 65FE CF07 9A00 65CF CF65 0000 A4CF F7CE 0100 FFFC 31F4 FF08"
	$"CECE 9C9C 63CE 9CCE 9CFE CE01 9C00 CBCE 0163 31FC CE02 9C00 63F9 CE01 6300 FECE"
	$"0263 0031 FCCE 049C 6300 319C F6CE 0131 00F6 CE03 6300 009C FCCE 089C 6331 0031"
	$"CECE 9C00 FDCE 0763 009C CE9C 3100 00FD 3103 CE9C 009C F5CE 0100 31FE CE03 009C"
	$"0063 FDCE 0000 FCCE 0F63 3100 319C CECE 9C00 31CE CE63 3100 9CFD CE03 6331 0000"
	$"F9CE 029C 009C FECE 029C 0063 FDCE 0B31 31CE 9C31 00CE CE9C 3100 63FE CE04 6331"
	$"0031 9CFD CE04 9C31 0000 9CFD CE02 3100 00FD CE00 9CFE 0004 9CCE CE9C 63FE 0000"
	$"9CFD CE03 3100 0063 FECE 079C 0063 CECE 6300 00A4 CE02 BBF7 CE03 00FF 6331 FE63"
	$"F7FF 0A31 CE9C CECE 3100 9CCE CE9C FDCE 019C 00CB CE02 3100 9CFD CE02 9C00 9CF9"
	$"CE07 6331 CECE 3163 0000 FCCE FE63 0100 9CF6 CE01 3100 F7CE FE63 0100 63FD CE0A"
	$"639C 9C63 0063 CECE 6300 63FE CE07 6300 9CCE 6363 0031 FE63 04CE CE9C 009C F5CE"
	$"0800 31CE CE63 639C 0031 FECE 0163 63FD CE0F 319C 9C31 009C CECE 3131 00CE 6331"
	$"319C FECE 059C 639C 6331 00F9 CE02 9C00 63FE CE02 9C00 9CFE CE0B 9C00 CECE 6331"
	$"009C CE00 3131 FECE 0531 9C9C 3100 9CFE CE04 9C31 6331 63FD CE0B 3163 3100 9CCE"
	$"CE63 63CE 9C9C FECE 0331 9CCE 9CFC CE0B 319C 6300 00CE CE9C 6300 31CE FE31 A3CE"
	$"F7CF 0300 FF65 30FE 65F7 FF0A 30CF 9ACF CF30 009A CFCF 9AFD CF01 9A00 CBCF 0230"
	$"009A FDCF 029A 009A F9CF 0765 30CF CF30 6500 00FC CFFE 6501 009A F6CF 0130 00F7"
	$"CFFE 6501 0065 FDCF 0A65 9A9A 6500 65CF CF65 0065 FECF 0765 009A CF65 6500 30FE"
	$"6504 CFCF 9A00 9AF5 CF08 0030 CFCF 6565 9A00 30FE CF01 6565 FDCF 0F30 9A9A 3000"
	$"9ACF CF30 3000 CF65 3030 9AFE CF05 9A65 9A65 3000 F9CF 029A 0065 FECF 029A 009A"
	$"FECF 0B9A 00CF CF65 3000 9ACF 0030 30FE CF05 309A 9A30 009A FECF 049A 3065 3065"
	$"FDCF 0B30 6530 009A CFCF 6565 CF9A 9AFE CF03 309A CF9A FCCF 0B30 9A65 0000 CFCF"
	$"9A65 0030 CFFE 30A3 CFF7 CE03 00FF 6331 FE63 F7FF 0A31 CE9C CECE 3100 9CCE CE9C"
	$"FDCE 019C 00CB CE02 3100 9CFD CE02 9C00 9CF9 CE07 6331 CECE 3163 0000 FCCE FE63"
	$"0100 9CF6 CE01 3100 F7CE FE63 0100 63FD CE0A 639C 9C63 0063 CECE 6300 63FE CE07"
	$"6300 9CCE 6363 0031 FE63 04CE CE9C 009C F5CE 0800 31CE CE63 639C 0031 FECE 0163"
	$"63FD CE0F 319C 9C31 009C CECE 3131 00CE 6331 319C FECE 059C 639C 6331 00F9 CE02"
	$"9C00 63FE CE02 9C00 9CFE CE0B 9C00 CECE 6331 009C CE00 3131 FECE 0531 9C9C 3100"
	$"9CFE CE04 9C31 6331 63FD CE0B 3163 3100 9CCE CE63 63CE 9C9C FECE 0331 9CCE 9CFC"
	$"CE0B 319C 6300 00CE CE9C 6300 31CE FE31 A3CE 02A0 F7CE 0600 FF31 6331 6331 F6FF"
	$"0FCE CE9C 9C63 9C63 CE9C CECE 00CE FF9C 00CB CE01 3131 FCCE 0263 009C F9CE 0731"
	$"31CE 63CE CE31 00FD CE05 639C CECE 009C F6CE 0131 00F8 CE05 639C CECE 3163 FECE"
	$"0131 9CFE CE05 0063 CECE 6300 FDCE 0131 00FD CE01 0063 FCCE 029C 009C F5CE 0831"
	$"00CE CE31 9CCE 0031 FECE 0131 9CFE CE0D 319C CECE 6300 31CE 31CE 3131 9C63 FCCE"
	$"019C 63FE CE01 3131 F9CE 029C 009C FECE 0E63 009C CE9C 6300 9CCE 639C 6300 CE31"
	$"FCCE 0A31 9CCE CE63 0031 CECE 9C63 FACE 0031 FECE 0000 FECE 0100 63FC CE02 9C00"
	$"9CFB CE00 31FE CE09 3100 639C 63CE 0063 639C A1CE F7CF 0600 FF30 6530 6530 F6FF"
	$"0FCF CF9A 9A65 9A65 CF9A CFCF 00CF FF9A 00CB CF01 3030 FCCF 0265 009A F9CF 0730"
	$"30CF 65CF CF30 00FD CF05 659A CFCF 009A F6CF 0130 00F8 CF05 659A CFCF 3065 FECF"
	$"0130 9AFE CF05 0065 CFCF 6500 FDCF 0130 00FD CF01 0065 FCCF 029A 009A F5CF 0830"
	$"00CF CF30 9ACF 0030 FECF 0130 9AFE CF0D 309A CFCF 6500 30CF 30CF 3030 9A65 FCCF"
	$"019A 65FE CF01 3030 F9CF 029A 009A FECF 0E65 009A CF9A 6500 9ACF 659A 6500 CF30"
	$"FCCF 0A30 9ACF CF65 0030 CFCF 9A65 FACF 0030 FECF 0000 FECF 0100 65FC CF02 9A00"
	$"9AFB CF00 30FE CF09 3000 659A 65CF 0065 659A A1CF F7CE 0600 FF31 6331 6331 F6FF"
	$"0FCE CE9C 9C63 9C63 CE9C CE9C 00CE FF9C 00CB CE01 3131 FCCE 0263 009C F9CE 0731"
	$"31CE 63CE CE31 00FD CE05 639C CECE 009C F6CE 0131 00F8 CE05 639C CECE 3163 FECE"
	$"0131 9CFE CE05 0063 CECE 6300 FDCE 0131 00FD CE01 0063 FCCE 029C 009C F5CE 0831"
	$"00CE CE31 9CCE 0031 FECE 0131 9CFE CE0D 319C CECE 6300 31CE 31CE 3131 9C63 FCCE"
	$"019C 63FE CE01 3131 F9CE 029C 009C FECE 0E63 009C CE9C 6300 9CCE 639C 6300 CE31"
	$"FCCE 0A31 9CCE CE63 0031 CECE 9C63 FACE 0031 FECE 0000 FECE 0100 63FC CE02 9C00"
	$"9CFB CE00 31FE CE09 3100 639C 63CE 0063 639C A1CE 026C F7CE 0100 FFFC 63F7 FFFE"
	$"CEFE 9C01 6363 FECE FEFF 02CE 9C00 CBCE 009C FBCE 0263 009C F9CE FE31 FECE 0131"
	$"31FE CE05 9C63 CECE 9C63 F5CE 0131 00F8 CE00 31FE CE00 31FE CE01 6363 FDCE 0400"
	$"63CE CE9C FCCE 0131 00FD CE01 0063 FCCE 019C 00F4 CE0C 3100 CE9C 63CE CE31 00CE"
	$"CE9C 63FE CE01 6363 FDCE 0100 31FE CE02 3131 63FC CE01 9C31 FDCE 0131 31F8 CE00"
	$"9CFD CE00 63FE 0001 3163 FCCE 0263 0063 FCCE 0163 63FD CE04 0031 CECE 31FA CE05"
	$"9C9C CECE 9C63 FECE 0131 00FC CE02 9C00 31FC CE01 319C FECE 029C 0063 FECE 0200"
	$"3163 A0CE F7CF 0100 FFFC 65F7 FFFE CFFE 9A01 6565 FECF 059A 9AFF CF9A 00CB CF00"
	$"9AFB CF02 6500 9AF9 CFFE 30FE CF01 3030 FECF 059A 65CF CF9A 65F5 CF01 3000 F8CF"
	$"0030 FECF 0030 FECF 0165 65FD CF04 0065 CFCF 9AFC CF01 3000 FDCF 0100 65FC CF01"
	$"9A00 F4CF 0C30 00CF 9A65 CFCF 3000 CFCF 9A65 FECF 0165 65FD CF01 0030 FECF 0230"
	$"3065 FCCF 019A 30FD CF01 3030 F8CF 009A FDCF 0065 FE00 0130 65FC CF02 6500 65FC"
	$"CF01 6565 FDCF 0400 30CF CF30 FACF 059A 9ACF CF9A 65FE CF01 3000 FCCF 029A 0030"
	$"FCCF 0130 9AFE CF02 9A00 65FE CF02 0030 65A0 CFF7 CE01 00FF FC63 F7FF FECE FE9C"
	$"0A63 63CE CE9C 0000 FFCE 9C00 CBCE 009C FBCE 0263 009C F9CE FE31 FECE 0131 31FE"
	$"CE05 9C63 CECE 9C63 F5CE 0131 00F8 CE00 31FE CE00 31FE CE01 6363 FDCE 0400 63CE"
	$"CE9C FCCE 0131 00FD CE01 0063 FCCE 019C 00F4 CE0C 3100 CE9C 63CE CE31 00CE CE9C"
	$"63FE CE01 6363 FDCE 0100 31FE CE02 3131 63FC CE01 9C31 FDCE 0131 31F8 CE00 9CFD"
	$"CE00 63FE 0001 3163 FCCE 0263 0063 FCCE 0163 63FD CE04 0031 CECE 31FA CE05 9C9C"
	$"CECE 9C63 FECE 0131 00FC CE02 9C00 31FC CE01 319C FECE 029C 0063 FECE 0200 3163"
	$"A0CE 0267 F7CE 0800 FF31 6331 6363 FFFF FB31 02FF 9CFF FD9C FE63 03CE CEFF FFFE"
	$"CE01 6300 C4CE 0231 009C F9CE 0200 009C FECE 0131 31FE CE04 00CE CE9C 63F4 CE01"
	$"3131 F9CE 0431 9CCE CE31 FECE 029C 009C FECE 0263 0063 F9CE 0100 00FE CE02 9C00"
	$"63FC CE01 6300 F4CE 0331 00CE 00FE CE04 3100 9CCE 00FD CE01 3163 FDCE 0100 31FE"
	$"CE02 0000 9CFC CE01 0063 FDCE 0100 63F3 CE02 3100 9CF9 CE02 3100 63FC CE01 3163"
	$"FDCE 0400 31CE 6363 FACE 0431 9CCE 9C63 FDCE 039C 0000 9CFD CE02 6300 00FE CE02"
	$"9C00 9CFE CE08 9C00 63CE CE9C 0031 9CA0 CEF7 CF08 00FF 3065 3065 65FF FFFB 3002"
	$"FF9A FFFD 9AFE 6503 CFCF 9A9A FECF 0165 00C4 CF02 3000 9AF9 CF02 0000 9AFE CF01"
	$"3030 FECF 0400 CFCF 9A65 F4CF 0130 30F9 CF04 309A CFCF 30FE CF02 9A00 9AFE CF02"
	$"6500 65F9 CF01 0000 FECF 029A 0065 FCCF 0165 00F4 CF03 3000 CF00 FECF 0430 009A"
	$"CF00 FDCF 0130 65FD CF01 0030 FECF 0200 009A FCCF 0100 65FD CF01 0065 F3CF 0230"
	$"009A F9CF 0230 0065 FCCF 0130 65FD CF04 0030 CF65 65FA CF04 309A CF9A 65FD CF03"
	$"9A00 009A FDCF 0265 0000 FECF 029A 009A FECF 089A 0065 CFCF 9A00 309A A0CF F7CE"
	$"0800 FF31 6331 6363 FFFF FB31 02FF 9CFF FD9C FE63 08CE CE31 009C CECE 6300 C4CE"
	$"0231 009C F9CE 0200 009C FECE 0131 31FE CE04 00CE CE9C 63F4 CE01 3131 F9CE 0431"
	$"9CCE CE31 FECE 029C 009C FECE 0263 0063 F9CE 0100 00FE CE02 9C00 63FC CE01 6300"
	$"F4CE 0331 00CE 00FE CE04 3100 9CCE 00FD CE01 3163 FDCE 0100 31FE CE02 0000 9CFC"
	$"CE01 0063 FDCE 0100 63F3 CE02 3100 9CF9 CE02 3100 63FC CE01 3163 FDCE 0400 31CE"
	$"6363 FACE 0431 9CCE 9C63 FDCE 039C 0000 9CFD CE02 6300 00FE CE02 9C00 9CFE CE08"
	$"9C00 63CE CE9C 0031 9CA0 CE02 40F7 CE03 00FF 6331 FE63 F8FF 049C 9CCE 9C9C FD63"
	$"03CE CEFF FFFE CE01 9C00 C4CE 0131 00F8 CE01 0031 FDCE 0800 63CE CE9C 0031 3163"
	$"F3CE 0131 31F9 CEFE 3100 63FD CE01 6300 FDCE 0231 009C F9CE 0100 31FE CE02 9C00"
	$"9CFC CE01 9C9C F4CE 0331 0063 63FE CE04 6300 9C63 63FE CE02 9C00 9CFD CE01 009C"
	$"FECE 0100 31FC CE02 9C00 9CFE CE02 6300 63F3 CE01 3100 F8CE 0131 31FC CE02 9C00"
	$"9CFD CE04 009C CE31 63FA CE03 0031 319C FBCE 029C 3100 FCCE 0663 0031 CECE 6300"
	$"FDCE 019C 00FE CE02 9C00 639F CEF7 CF03 00FF 6530 FE65 F8FF 049A 9ACF 9A9A FD65"
	$"03CF CF9A 9AFE CF01 9A00 C4CF 0130 00F8 CF01 0030 FDCF 0800 65CF CF9A 0030 3065"
	$"F3CF 0130 30F9 CFFE 3000 65FD CF01 6500 FDCF 0230 009A F9CF 0100 30FE CF02 9A00"
	$"9AFC CF01 9A9A F4CF 0330 0065 65FE CF04 6500 9A65 65FE CF02 9A00 9AFD CF01 009A"
	$"FECF 0100 30FC CF02 9A00 9AFE CF02 6500 65F3 CF01 3000 F8CF 0130 30FC CF02 9A00"
	$"9AFD CF04 009A CF30 65FA CF03 0030 309A FBCF 029A 3000 FCCF 0665 0030 CFCF 6500"
	$"FDCF 019A 00FE CF02 9A00 659F CFF7 CE03 00FF 6331 FE63 F8FF 049C 9CCE 9C9C FD63"
	$"03CE 9C00 31FE CE01 9C00 C4CE 0131 00F8 CE01 0031 FDCE 0800 63CE CE9C 0031 3163"
	$"F3CE 0131 31F9 CEFE 3100 63FD CE01 6300 FDCE 0231 009C F9CE 0100 31FE CE02 9C00"
	$"9CFC CE01 9C9C F4CE 0331 0063 63FE CE04 6300 9C63 63FE CE02 9C00 9CFD CE01 009C"
	$"FECE 0100 31FC CE02 9C00 9CFE CE02 6300 63F3 CE01 3100 F8CE 0131 31FC CE02 9C00"
	$"9CFD CE04 009C CE31 63FA CE03 0031 319C FBCE 029C 3100 FCCE 0663 0031 CECE 6300"
	$"FDCE 019C 00FE CE02 9C00 639F CE02 40F7 CE02 00FF 31FD 6301 FFFF FE31 FEFF 019C"
	$"31FE 9CFD 6303 31CE FFFF FECE 02FF 6300 C4CE 0100 31F9 CE02 9C00 63FD CE06 0063"
	$"CECE 6300 9CF1 CE01 009C FACE 039C 0063 9CFC CE01 0031 FECE 039C 3100 9CFA CE02"
	$"9C00 31FE CE02 6300 9CED CE03 3100 319C FECE 0463 0031 319C FECE 0263 009C FECE"
	$"019C 31FD CE01 0063 FCCE 0163 00FE CE03 9C31 0063 F3CE 0100 31F8 CE01 3131 FCCE"
	$"0263 009C FECE 059C 31CE CE00 63FB CE02 6300 63F8 CE02 6300 00FC CE05 3100 31CE"
	$"3100 FDCE 0163 63FE CE02 9C00 9C9F CEF7 CF02 00FF 30FD 6501 FFFF FE30 FEFF 019A"
	$"30FE 9AFD 6503 30CF 9A9A FECF 02FF 6500 C4CF 0100 30F9 CF02 9A00 65FD CF06 0065"
	$"CFCF 6500 9AF1 CF01 009A FACF 039A 0065 9AFC CF01 0030 FECF 039A 3000 9AFA CF02"
	$"9A00 30FE CF02 6500 9AED CF03 3000 309A FECF 0465 0030 309A FECF 0265 009A FECF"
	$"019A 30FD CF01 0065 FCCF 0165 00FE CF03 9A30 0065 F3CF 0100 30F8 CF01 3030 FCCF"
	$"0265 009A FECF 059A 30CF CF00 65FB CF02 6500 65F8 CF02 6500 00FC CF05 3000 30CF"
	$"3000 FDCF 0165 65FE CF02 9A00 9A9F CFF7 CE02 00FF 31FD 6301 FFFF FE31 FEFF 019C"
	$"31FE 9CFD 6309 31CE 0000 9CCE CEFF 6300 C4CE 0100 31F9 CE02 9C00 63FD CE06 0063"
	$"CECE 6300 9CF1 CE01 009C FACE 039C 0063 9CFC CE01 0031 FECE 039C 3100 9CFA CE02"
	$"9C00 31FE CE02 6300 9CED CE03 3100 319C FECE 0463 0031 319C FECE 0263 009C FECE"
	$"019C 31FD CE01 0063 FCCE 0163 00FE CE03 9C31 0063 F3CE 0100 31F8 CE01 3131 FCCE"
	$"0263 009C FECE 059C 31CE CE00 63FB CE02 6300 63F8 CE02 6300 00FC CE05 3100 31CE"
	$"3100 FDCE 0163 63FE CE02 9C00 9C9F CE02 50F7 CE01 00FF FD63 009C F9FF 0363 319C"
	$"CEFB 6301 FFFF FECE 03FF FF9C 00C5 CE02 9C00 63F9 CE02 9C00 9CFD CE06 009C CE9C"
	$"6300 9CFE CE00 63F6 CE01 6331 F9CE 029C 0063 FECE 049C 9CCE 0031 FECE 0431 6300"
	$"CE9C FBCE 029C 009C FECE 0163 00EC CE02 3100 63FC CE02 0000 31FD CE02 6300 9CFE"
	$"CE01 639C FECE 029C 009C FCCE 0131 00FE CE05 319C 009C CE63 F6CE 029C 0063 F8CE"
	$"0100 63FC CE02 6300 9CFE CE05 639C CECE 0031 FDCE 039C CE63 00FD CE01 639C FCCE"
	$"0131 00FB CE04 0031 CE31 00FD CE01 319C FECE 0163 009E CEF7 CF01 00FF FD65 009A"
	$"F9FF 0365 309A CFFB 65FE 9A05 CFCF FFFF 9A00 C5CF 029A 0065 F9CF 029A 009A FDCF"
	$"0600 9ACF 9A65 009A FECF 0065 F6CF 0165 30F9 CF02 9A00 65FE CF04 9A9A CF00 30FE"
	$"CF04 3065 00CF 9AFB CF02 9A00 9AFE CF01 6500 ECCF 0230 0065 FCCF 0200 0030 FDCF"
	$"0265 009A FECF 0165 9AFE CF02 9A00 9AFC CF01 3000 FECF 0530 9A00 9ACF 65F6 CF02"
	$"9A00 65F8 CF01 0065 FCCF 0265 009A FECF 0565 9ACF CF00 30FD CF03 9ACF 6500 FDCF"
	$"0165 9AFC CF01 3000 FBCF 0400 30CF 3000 FDCF 0130 9AFE CF01 6500 9ECF F7CE 0100"
	$"FFFD 6300 9CF9 FF03 6331 9CCE FA63 0700 63CE CEFF FF9C 00C5 CE02 9C00 63F9 CE02"
	$"9C00 9CFD CE06 009C CE9C 6300 9CFE CE00 63F6 CE01 6331 F9CE 029C 0063 FECE 049C"
	$"9CCE 0031 FECE 0431 6300 CE9C FBCE 029C 009C FECE 0163 00EC CE02 3100 63FC CE02"
	$"0000 31FD CE02 6300 9CFE CE01 639C FECE 029C 009C FCCE 0131 00FE CE05 319C 009C"
	$"CE63 F6CE 029C 0063 F8CE 0100 63FC CE02 6300 9CFE CE05 639C CECE 0031 FDCE 039C"
	$"CE63 00FD CE01 639C FCCE 0131 00FB CE04 0031 CE31 00FD CE01 319C FECE 0163 009E"
	$"CE02 70F7 CE01 00FF FC63 FAFF 0C63 3163 FFCE 9C63 639C 9C31 FFFF FDCE 02FF 6300"
	$"C5CE 0131 63F8 CE02 9C00 9CFE CE0B 9C00 9C63 9C9C 0031 9CCE 639C F9CE 0463 9C31"
	$"319C FBCE 149C 31CE 0031 9CCE 6363 CECE 0031 9C9C 31CE 6300 9C63 FBCE 0100 9CFD"
	$"CE04 6300 9CCE 31FE CE01 3131 F4CE 0131 00FB CE02 0000 9CFD CE06 6300 00CE CE9C"
	$"63FD CE02 9C00 9CFC CE09 3100 9C9C 319C 9C00 9C31 F5CE 0131 63F7 CE01 0063 FCCE"
	$"0663 0000 CECE 9C31 FECE 0E00 0063 CE9C 319C CE63 0031 CE9C 6363 FBCE 0163 31FB"
	$"CE09 3163 CE31 0031 CECE 6363 FDCE 0163 009E CEF7 CF01 00FF FC65 FAFF 0C65 3065"
	$"FFCF 9A65 659A 9A30 9A9A FDCF 02FF 6500 C5CF 0130 65F8 CF02 9A00 9AFE CF0B 9A00"
	$"9A65 9A9A 0030 9ACF 659A F9CF 0465 9A30 309A FBCF 149A 30CF 0030 9ACF 6565 CFCF"
	$"0030 9A9A 30CF 6500 9A65 FBCF 0100 9AFD CF04 6500 9ACF 30FE CF01 3030 F4CF 0130"
	$"00FB CF02 0000 9AFD CF06 6500 00CF CF9A 65FD CF02 9A00 9AFC CF09 3000 9A9A 309A"
	$"9A00 9A30 F5CF 0130 65F7 CF01 0065 FCCF 0665 0000 CFCF 9A30 FECF 0E00 0065 CF9A"
	$"309A CF65 0030 CF9A 6565 FBCF 0165 30FB CF09 3065 CF30 0030 CFCF 6565 FDCF 0165"
	$"009E CFF7 CE01 00FF FC63 FAFF 0C63 3163 FFCE 9C63 639C 9C31 0000 FDCE 02FF 6300"
	$"C5CE 0131 63F8 CE02 9C00 9CFE CE0B 9C00 9C63 9C9C 0031 9CCE 639C F9CE 0463 9C31"
	$"319C FBCE 149C 31CE 0031 9CCE 6363 CECE 0031 9C9C 31CE 6300 9C63 FBCE 0100 9CFD"
	$"CE04 6300 9CCE 31FE CE01 3131 F4CE 0131 00FB CE02 0000 9CFD CE06 6300 00CE CE9C"
	$"63FD CE02 9C00 9CFC CE09 3100 9C9C 319C 9C00 9C31 F5CE 0131 63F7 CE01 0063 FCCE"
	$"0663 0000 CECE 9C31 FECE 0E00 0063 CE9C 319C CE63 0031 CE9C 6363 FBCE 0163 31FB"
	$"CE09 3163 CE31 0031 CECE 6363 FDCE 0163 009E CE02 84F7 CE06 00FF 6363 9C63 9CFE"
	$"FFFD 310B 6331 FFFF 9C63 9C9C 6331 CEFF FECE FEFF 019C 00C7 CEFE 0001 3131 F9CE"
	$"0163 00FD CE06 9C00 319C CECE 31FE 0000 9CF9 CE00 31FB 00FD 3104 0031 CECE 63FE"
	$"0000 63FE CE08 3100 0031 CECE 6300 31FD CE05 6300 0031 3163 FECE 039C 0031 31FE"
	$"CE02 9C31 31F4 CE01 319C FBCE 0100 63FB CEFE 0001 3163 FCCE 0163 00FB CE08 6300"
	$"0031 9CCE 6300 00F6 CEFE 0001 3131 F9CE 029C 009C FBCE 0400 0031 3163 FDCE 009C"
	$"FE00 0131 9CFE CE00 31FE 0005 63CE CE9C 0031 FE63 03CE CE9C 00FD 6307 CECE 9C00"
	$"0031 319C FCCE 0131 319E CEF7 CF06 00FF 6565 9A65 9AFE FFFD 3009 6530 FFFF 9A65"
	$"9A9A 6530 FE9A 01CF CFFE FF01 9A00 C7CF FE00 0130 30F9 CF01 6500 FDCF 069A 0030"
	$"9ACF CF30 FE00 009A F9CF 0030 FB00 FD30 0400 30CF CF65 FE00 0065 FECF 0830 0000"
	$"30CF CF65 0030 FDCF 0565 0000 3030 65FE CF03 9A00 3030 FECF 029A 3030 F4CF 0130"
	$"9AFB CF01 0065 FBCF FE00 0130 65FC CF01 6500 FBCF 0865 0000 309A CF65 0000 F6CF"
	$"FE00 0130 30F9 CF02 9A00 9AFB CF04 0000 3030 65FD CF00 9AFE 0001 309A FECF 0030"
	$"FE00 0565 CFCF 9A00 30FE 6503 CFCF 9A00 FD65 07CF CF9A 0000 3030 9AFC CF01 3030"
	$"9ECF F7CE 0600 FF63 639C 639C FEFF FD31 0E63 31FF FF9C 639C 9C63 3131 009C CECE"
	$"FEFF 019C 00C7 CEFE 0001 3131 F9CE 0163 00FD CE06 9C00 319C CECE 31FE 0000 9CF9"
	$"CE00 31FB 00FD 3104 0031 CECE 63FE 0000 63FE CE08 3100 0031 CECE 6300 31FD CE05"
	$"6300 0031 3163 FECE 039C 0031 31FE CE02 9C31 31F4 CE01 319C FBCE 0100 63FB CEFE"
	$"0001 3163 FCCE 0163 00FB CE08 6300 0031 9CCE 6300 00F6 CEFE 0001 3131 F9CE 029C"
	$"009C FBCE 0400 0031 3163 FDCE 009C FE00 0131 9CFE CE00 31FE 0005 63CE CE9C 0031"
	$"FE63 03CE CE9C 00FD 6307 CECE 9C00 0031 319C FCCE 0131 319E CE02 47F7 CE06 00FF"
	$"639C 639C 63FB FF06 6331 CECE 9C63 9CFE 6302 9CFF FFFE CEFE FF01 6300 C8CE 019C"
	$"9CFE 6300 9CF9 CE00 9CFC CE02 9C63 9CFE CE02 9C63 63F6 CE01 9C9C FD63 FE31 0163"
	$"9CFD CE02 9C63 9CFD CE02 9C63 9CFE CE02 9C63 9CFD CEFE 9C02 6363 9CFD CE01 6363"
	$"FCCE 0063 F3CE 009C FACE 009C F9CE 0263 639C FBCE 019C 9CFA CE01 639C FDCE 0063"
	$"F6CE 019C 9CFE 6300 9CF9 CE01 9C9C F9CE 0263 639C FBCE 029C 639C FBCE 0263 639C"
	$"FECE 009C FE63 009C FECE 049C 6363 9C9C FDCE 039C 639C 9CFB CE01 9C9C 9ECE F7CF"
	$"0600 FF65 9A65 9A65 FBFF 0665 30CF CF9A 659A FE65 FE9A FECF FEFF 0165 00C8 CF01"
	$"9A9A FE65 009A F9CF 009A FCCF 029A 659A FECF 029A 6565 F6CF 019A 9AFD 65FE 3001"
	$"659A FDCF 029A 659A FDCF 029A 659A FECF 029A 659A FDCF FE9A 0265 659A FDCF 0165"
	$"65FC CF00 65F3 CF00 9AFA CF00 9AF9 CF02 6565 9AFB CF01 9A9A FACF 0165 9AFD CF00"
	$"65F6 CF01 9A9A FE65 009A F9CF 019A 9AF9 CF02 6565 9AFB CF02 9A65 9AFB CF02 6565"
	$"9AFE CF00 9AFE 6500 9AFE CF04 9A65 659A 9AFD CF03 9A65 9A9A FBCF 019A 9A9E CFF7"
	$"CE06 00FF 639C 639C 63FB FF06 6331 CECE 9C63 9CFE 6302 9C00 31FE CEFE FF01 6300"
	$"C8CE 019C 9CFE 6300 9CF9 CE00 9CFC CE02 9C63 9CFE CE02 9C63 63F6 CE01 9C9C FD63"
	$"FE31 0163 9CFD CE02 9C63 9CFD CE02 9C63 9CFE CE02 9C63 9CFD CEFE 9C02 6363 9CFD"
	$"CE01 6363 FCCE 0063 F3CE 009C FACE 009C F9CE 0263 639C FBCE 019C 9CFA CE01 639C"
	$"FDCE 0063 F6CE 019C 9CFE 6300 9CF9 CE01 9C9C F9CE 0263 639C FBCE 029C 639C FBCE"
	$"0263 639C FECE 009C FE63 009C FECE 049C 6363 9C9C FDCE 039C 639C 9CFB CE01 9C9C"
	$"9ECE 0085 F7CE 0300 CE9C 63FE 9CFE FF08 3131 6331 9CFF 9C63 9CFE 6302 CEFF FFFE"
	$"CEFD FF01 9C00 81CE B4CE 009C 81CE C6CE F7CF 0300 CF9A 65FE 9AFE FF08 3030 6530"
	$"9AFF 9A65 9AFE 6502 CF9A 9AFE CFFD FF01 9A00 81CF B4CF 009A 81CF C6CF F7CE 0300"
	$"CE9C 63FE 9CFE FF08 3131 6331 9CFF 9C63 9CFE 6305 CE31 009C CECE FDFF 019C 0081"
	$"CEB4 CE00 9C81 CEC6 CE00 7BF7 CE06 00FF 639C 639C 9CFC FF09 3163 FF9C 639C 6363"
	$"9CCE FEFF 01CE CEFC FF01 6300 81CE 81CE 81CE F8CE F7CF 0600 FF65 9A65 9A9A FCFF"
	$"0E30 65FF 9A65 9A65 659A CFCF 9A9A CFCF FCFF 0165 0081 CF81 CF81 CFF8 CFF7 CE06"
	$"00FF 639C 639C 9CFC FF0E 3163 FF9C 639C 6363 9CCE CE00 31CE CEFC FF01 6300 81CE"
	$"81CE 81CE F8CE 0081 F7CE 0300 CE9C 63FE 9CFE FF11 3131 63FF 9C63 9C31 9C9C FFCE"
	$"FFFF CECE FFCE FDFF 0163 0081 CE81 CE81 CEF8 CEF7 CF03 00CF 9A65 FE9A FEFF 1130"
	$"3065 FF9A 659A 309A 9AFF CF9A 9ACF CFFF CFFD FF01 6500 81CF 81CF 81CF F8CF F7CE"
	$"0300 CE9C 63FE 9CFE FF11 3131 63FF 9C63 9C31 9C9C FFCE 3100 CECE FFCE FDFF 0163"
	$"0081 CE81 CE81 CEF8 CE00 74F7 CE02 00CE 63FD 9CFD FF02 31CE 9CFE 6305 9CCE FFCE"
	$"FFFF FDCE FCFF 0163 0081 CE81 CE81 CEF8 CEF7 CF02 00CF 65FD 9AFD FF02 30CF 9AFE"
	$"6506 9ACF FFCF CF9A 9AFE CFFC FF01 6500 81CF 81CF 81CF F8CF F7CE 0200 CE63 FD9C"
	$"FDFF 0231 CE9C FE63 069C CEFF CE9C 0063 FECE FCFF 0163 0081 CE81 CE81 CEF8 CE00"
	$"77F7 CE01 00CE FD9C 00CE FEFF 0963 CE9C 9C63 639C CEFF CEFE FFFE CEFB FF01 6300"
	$"81CE 81CE 81CE F8CE F7CF 0100 CFFD 9A00 CFFE FF0C 65CF 9A9A 6565 9ACF FFCF FF9A"
	$"9AFE CFFB FF01 6500 81CF 81CF 81CF F8CF F7CE 0100 CEFD 9C00 CEFE FF0C 63CE 9C9C"
	$"6363 9CCE FFCE FF31 00FE CEFB FF01 6300 81CE 81CE 81CE F8CE 006E F7CE 0100 CEFC"
	$"9CFE FF05 639C 9C63 319C FECE FEFF FECE FAFF 0131 0081 CE81 CE81 CEF8 CEF7 CF01"
	$"00CF FC9A FEFF 0565 9A9A 6530 9AFE CF02 FFCF 9AFE CFFA FF01 3000 81CF 81CF 81CF"
	$"F8CF F7CE 0100 CEFC 9CFE FF05 639C 9C63 319C FECE 05FF 9C00 9CCE CEFA FF01 3100"
	$"81CE 81CE 81CE F8CE 0078 F7CE 0F00 CE9C 9CCE 9CCE FFFF 9C9C 6331 319C CEFE FF04"
	$"CEFF FFCE CEF9 FF01 6300 81CE 81CE 81CE F8CE F7CF 0F00 CF9A 9ACF 9ACF FFFF 9A9A"
	$"6530 309A CFFE FF04 CF9A 9ACF CFF9 FF01 6500 81CF 81CF 81CF F8CF F7CE 0F00 CE9C"
	$"9CCE 9CCE FFFF 9C9C 6331 319C CEFE FF04 CE00 31CE CEF9 FF01 6300 81CE 81CE 81CE"
	$"F8CE 007B F7CE 0300 CE9C CEFE 9C11 FFFF 9C63 3131 9CCE FFCE FFCE CEFF CECE FFCE"
	$"FAFF 0131 0081 CE81 CE81 CEF8 CEF7 CF03 00CF 9ACF FE9A 11FF FF9A 6530 309A CFFF"
	$"CFFF CF9A 9ACF CFFF CFFA FF01 3000 81CF 81CF 81CF F8CF F7CE 0300 CE9C CEFE 9C11"
	$"FFFF 9C63 3131 9CCE FFCE FFCE 9C31 9CCE FFCE FAFF 0131 0081 CE81 CE81 CEF8 CE00"
	$"72F7 CE03 00CE CE9C FECE 01FF 9CFE 6301 CECE FEFF 04CE FF9C CECE F7FF 0163 0081"
	$"CE81 CE81 CEF8 CEF7 CF03 00CF CF9A FECF 01FF 9AFE 6501 CFCF FEFF 04CF FF65 9ACF"
	$"F7FF 0165 0081 CF81 CF81 CFF8 CFF7 CE03 00CE CE9C FECE 01FF 9CFE 6301 CECE FEFF"
	$"04CE FF9C 9CCE F7FF 0163 0081 CE81 CE81 CEF8 CE00 72F7 CE01 00CE FE9C 05CE 9C63"
	$"639C 9CFD CE07 FFCE FF9C 9CCE FFCE F8FF 0131 0081 CE81 CE81 CEF8 CEF7 CF01 00CF"
	$"FE9A 05CF 9A65 659A 9AFD CF07 FFCF FF9A 65CF FFCF F8FF 0130 0081 CF81 CF81 CFF8"
	$"CFF7 CE01 00CE FE9C 05CE 9C63 639C 9CFD CE07 FFCE FF9C 9CCE FFCE F8FF 0131 0081"
	$"CE81 CE81 CEF8 CE00 63F7 CE03 00CE CE9C FBCE 01FF CEFE FF00 CEFE FF00 CEF5 FF01"
	$"6300 81CE 81CE 81CE F8CE F7CF 0300 CFCF 9AFB CF01 FFCF FEFF 00CF FEFF 00CF F5FF"
	$"0165 0081 CF81 CF81 CFF8 CFF7 CE03 00CE CE9C FBCE 01FF CEFE FF00 CEFE FF00 CEF5"
	$"FF01 6300 81CE 81CE 81CE F8CE 0054 F7CE 0400 CE9C CE9C FBCE 03FF CEFF CEF0 FF01"
	$"3100 81CE 81CE 81CE F8CE F7CF 0400 CF9A CF9A FBCF 03FF CFFF CFF0 FF01 3000 81CF"
	$"81CF 81CF F8CF F7CE 0400 CE9C CE9C FBCE 03FF CEFF CEF0 FF01 3100 81CE 81CE 81CE"
	$"F8CE 005D F7CE 0600 CECE 9CCE 9CCE F79C 0163 9CF7 6304 3163 3163 0081 CE81 CE81"
	$"CEF8 CEF7 CF06 00CF CF9A CF9A CFF7 9A01 659A F765 0430 6530 6500 81CF 81CF 81CF"
	$"F8CF F7CE 0600 CECE 9CCE 9CCE F79C 0163 9CF7 6304 3163 3163 0081 CE81 CE81 CEF8"
	$"CE00 24F7 CEDF 0081 CE81 CE81 CEF8 CEF7 CFDF 0081 CF81 CF81 CFF8 CFF7 CEDF 0081"
	$"CE81 CE81 CEF8 CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC"
	$"CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81"
	$"CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC CE81"
	$"CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC"
	$"CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81"
	$"CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881"
	$"CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC"
	$"CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81"
	$"CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81"
	$"CE81 CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00"
	$"1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81"
	$"CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 BABF CE00 00F0 CE03 00CE CE00"
	$"FBCE 0000 FBCE 0000 D0CE 0300 CECE 00FB CE00 00C9 CE01 0000 FACE 0000 F0CE 0000"
	$"DECE 0000 F8CE 0000 CCCE 0000 F0CE 0100 00B9 CEBF CF00 00F0 CF03 00CF CF00 FBCF"
	$"0000 FBCF 0000 D0CF 0300 CFCF 00FB CF00 00C9 CF01 0000 FACF 0000 F0CF 0000 DECF"
	$"0000 F8CF 0000 CCCF 0000 F0CF 0100 00B9 CFBF CE00 00F0 CE03 00CE CE00 FBCE 0000"
	$"FBCE 0000 D0CE 0300 CECE 00FB CE00 00C9 CE01 0000 FACE 0000 F0CE 0000 DECE 0000"
	$"F8CE 0000 CCCE 0000 F0CE 0100 00B9 CE00 C6BF CE00 00F0 CE06 00CE CE00 CECE 00FE"
	$"CE00 00C9 CE03 00CE CE00 FBCE 0000 F4CE 0000 D8CE 0000 F8CE 0000 F0CE 0300 CECE"
	$"00D7 CE00 00CC CE00 00F6 CE00 00FD CE00 00B7 CEBF CF00 00F0 CF06 00CF CF00 CFCF"
	$"00FE CF00 00C9 CF03 00CF CF00 FBCF 0000 F4CF 0000 D8CF 0000 F8CF 0000 F0CF 0300"
	$"CFCF 00D7 CF00 00CC CF00 00F6 CF00 00FD CF00 00B7 CFBF CE00 00F0 CE06 00CE CE00"
	$"CECE 00FE CE00 00C9 CE03 00CE CE00 FBCE 0000 F4CE 0000 D8CE 0000 F8CE 0000 F0CE"
	$"0300 CECE 00D7 CE00 00CC CE00 00F6 CE00 00FD CE00 00B7 CE00 C6BF CE00 00F0 CE06"
	$"00CE CE00 CECE 00FE CE00 00C9 CE03 00CE CE00 FBCE 0000 F4CE 0000 D8CE 0000 F8CE"
	$"0000 F0CE 0300 CECE 00D7 CE00 00CC CE00 00F6 CE00 00FD CE00 00B7 CEBF CF00 00F0"
	$"CF06 00CF CF00 CFCF 00FE CF00 00C9 CF03 00CF CF00 FBCF 0000 F4CF 0000 D8CF 0000"
	$"F8CF 0000 F0CF 0300 CFCF 00D7 CF00 00CC CF00 00F6 CF00 00FD CF00 00B7 CFBF CE00"
	$"00F0 CE06 00CE CE00 CECE 00FE CE00 00C9 CE03 00CE CE00 FBCE 0000 F4CE 0000 D8CE"
	$"0000 F8CE 0000 F0CE 0300 CECE 00D7 CE00 00CC CE00 00F6 CE00 00FD CE00 00B7 CE02"
	$"E2BF CE00 00FA CEFE 00FD CE07 0000 CE00 CECE 00CE FE00 02CE CE00 FBCE 0000 FECE"
	$"FE00 F9CE FE00 F9CE FE00 FECE 0700 CE00 00CE CE00 00FD CEFE 00FE CE03 00CE CE00"
	$"FBCE 0300 CE00 00FE CE00 00FE CE01 00CE FE00 FBCE 0300 CE00 00FD CEFE 0002 CECE"
	$"00FE CE00 00FE CE02 00CE CEFE 00FE CE01 00CE FD00 01CE 00FE CE03 00CE CE00 F7CE"
	$"0000 FECE 0400 CECE 00CE FE00 06CE CE00 CE00 CECE FE00 F9CE 0600 00CE 00CE CE00"
	$"FECE 0300 CECE 00FE CEFE 00FE CE00 00FE CE00 00FA CEFE 00FE CE04 00CE 00CE CEFE"
	$"00FD CEFE 00FD CEFE 00FA CE03 00CE 0000 FECE 0000 FDCE FE00 FECE FE00 01CE CEFE"
	$"00FE CEFE 00FD CE0C 00CE 00CE CE00 CE00 00CE CE00 00CF CEBF CF00 00FA CFFE 00FD"
	$"CF07 0000 CF00 CFCF 00CF FE00 02CF CF00 FBCF 0000 FECF FE00 F9CF FE00 F9CF FE00"
	$"FECF 0700 CF00 00CF CF00 00FD CFFE 00FE CF03 00CF CF00 FBCF 0300 CF00 00FE CF00"
	$"00FE CF01 00CF FE00 FBCF 0300 CF00 00FD CFFE 0002 CFCF 00FE CF00 00FE CF02 00CF"
	$"CFFE 00FE CF01 00CF FD00 01CF 00FE CF03 00CF CF00 F7CF 0000 FECF 0400 CFCF 00CF"
	$"FE00 06CF CF00 CF00 CFCF FE00 F9CF 0600 00CF 00CF CF00 FECF 0300 CFCF 00FE CFFE"
	$"00FE CF00 00FE CF00 00FA CFFE 00FE CF04 00CF 00CF CFFE 00FD CFFE 00FD CFFE 00FA"
	$"CF03 00CF 0000 FECF 0000 FDCF FE00 FECF FE00 01CF CFFE 00FE CFFE 00FD CF0C 00CF"
	$"00CF CF00 CF00 00CF CF00 00CF CFBF CE00 00FA CEFE 00FD CE07 0000 CE00 CECE 00CE"
	$"FE00 02CE CE00 FBCE 0000 FECE FE00 F9CE FE00 F9CE FE00 FECE 0700 CE00 00CE CE00"
	$"00FD CEFE 00FE CE03 00CE CE00 FBCE 0300 CE00 00FE CE00 00FE CE01 00CE FE00 FBCE"
	$"0300 CE00 00FD CEFE 0002 CECE 00FE CE00 00FE CE02 00CE CEFE 00FE CE01 00CE FD00"
	$"01CE 00FE CE03 00CE CE00 F7CE 0000 FECE 0400 CECE 00CE FE00 06CE CE00 CE00 CECE"
	$"FE00 F9CE 0600 00CE 00CE CE00 FECE 0300 CECE 00FE CEFE 00FE CE00 00FE CE00 00FA"
	$"CEFE 00FE CE04 00CE 00CE CEFE 00FD CEFE 00FD CEFE 00FA CE03 00CE 0000 FECE 0000"
	$"FDCE FE00 FECE FE00 01CE CEFE 00FE CEFE 00FD CE0C 00CE 00CE CE00 CE00 00CE CE00"
	$"00CF CE03 66BF CE00 00FB CE00 00FE CE0D 00CE CE00 CECE 0000 CECE 00CE CE00 FECE"
	$"0000 FBCE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FB CE00 00FE CE0E 00CE CE00"
	$"00CE CE00 00CE CE00 CECE 00FE CE06 00CE CE00 CECE 00FB CE07 0000 CECE 00CE CE00"
	$"FECE 0300 CECE 00FA CE07 0000 CECE 00CE CE00 FECE 0200 CE00 FECE 0000 FECE 0200"
	$"CE00 FECE 0A00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00F7 CE00 00FE CE06 00CE"
	$"CE00 CECE 00FE CE04 0000 CECE 00FE CE00 00FB CE07 00CE CE00 00CE CE00 FECE 0600"
	$"CECE 00CE CE00 FECE 0600 CECE 00CE CE00 FACE 0000 FECE 0700 CECE 0000 CECE 00FE"
	$"CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE07 0000 CECE 00CE CE00 FECE 0000"
	$"FECE 0000 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 FECE 0100 00FE CE08 0000 CECE"
	$"0000 CECE 00D0 CEBF CF00 00FB CF00 00FE CF0D 00CF CF00 CFCF 0000 CFCF 00CF CF00"
	$"FECF 0000 FBCF 0300 CFCF 00FE CF00 00FB CF00 00FE CF00 00FB CF00 00FE CF0E 00CF"
	$"CF00 00CF CF00 00CF CF00 CFCF 00FE CF06 00CF CF00 CFCF 00FB CF07 0000 CFCF 00CF"
	$"CF00 FECF 0300 CFCF 00FA CF07 0000 CFCF 00CF CF00 FECF 0200 CF00 FECF 0000 FECF"
	$"0200 CF00 FECF 0A00 CFCF 0000 CFCF 00CF CF00 FECF 0300 CFCF 00F7 CF00 00FE CF06"
	$"00CF CF00 CFCF 00FE CF04 0000 CFCF 00FE CF00 00FB CF07 00CF CF00 00CF CF00 FECF"
	$"0600 CFCF 00CF CF00 FECF 0600 CFCF 00CF CF00 FACF 0000 FECF 0700 CFCF 0000 CFCF"
	$"00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF07 0000 CFCF 00CF CF00 FECF"
	$"0000 FECF 0000 FECF 0000 FDCF 0000 FECF 0000 FECF 0000 FECF 0100 00FE CF08 0000"
	$"CFCF 0000 CFCF 00D0 CFBF CE00 00FB CE00 00FE CE0D 00CE CE00 CECE 0000 CECE 00CE"
	$"CE00 FECE 0000 FBCE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FB CE00 00FE CE0E"
	$"00CE CE00 00CE CE00 00CE CE00 CECE 00FE CE06 00CE CE00 CECE 00FB CE07 0000 CECE"
	$"00CE CE00 FECE 0300 CECE 00FA CE07 0000 CECE 00CE CE00 FECE 0200 CE00 FECE 0000"
	$"FECE 0200 CE00 FECE 0A00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00F7 CE00 00FE"
	$"CE06 00CE CE00 CECE 00FE CE04 0000 CECE 00FE CE00 00FB CE07 00CE CE00 00CE CE00"
	$"FECE 0600 CECE 00CE CE00 FECE 0600 CECE 00CE CE00 FACE 0000 FECE 0700 CECE 0000"
	$"CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE07 0000 CECE 00CE CE00"
	$"FECE 0000 FECE 0000 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 FECE 0100 00FE CE08"
	$"0000 CECE 0000 CECE 00D0 CE02 F7BF CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0600"
	$"CECE 00CE CE00 FECE 0000 FBCE 0300 CECE 00F3 CE00 00FB CE00 00FB CE00 00FE CE00"
	$"00FE CE00 00FB CE06 00CE CE00 CECE 00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE"
	$"00FA CE00 00FE CE03 00CE CE00 FECE 0C00 CECE 00CE 00CE 00CE 00CE CE00 FECE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00F7 CE00 00FE CE06 00CE CE00 CECE 00FE"
	$"CE00 00FA CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE 0200"
	$"CE00 F9CE 0000 FBCE 0000 FECE 0000 FECE 0300 CECE 00FB CE00 00F7 CE00 00FE CE03"
	$"00CE CE00 FACE 0000 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 FECE 0000 FDCE 0000"
	$"FECE 0000 FECE 0000 D0CE BFCF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF06 00CF CF00"
	$"CFCF 00FE CF00 00FB CF03 00CF CF00 F3CF 0000 FBCF 0000 FBCF 0000 FECF 0000 FECF"
	$"0000 FBCF 0600 CFCF 00CF CF00 FBCF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FACF"
	$"0000 FECF 0300 CFCF 00FE CF0C 00CF CF00 CF00 CF00 CF00 CFCF 00FE CF03 00CF CF00"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 F7CF 0000 FECF 0600 CFCF 00CF CF00 FECF 0000"
	$"FACF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF06 00CF CF00 CFCF 00FB CF02 00CF 00F9"
	$"CF00 00FB CF00 00FE CF00 00FE CF03 00CF CF00 FBCF 0000 F7CF 0000 FECF 0300 CFCF"
	$"00FA CF00 00FE CF00 00FD CF00 00FE CF00 00FE CF00 00FE CF00 00FD CF00 00FE CF00"
	$"00FE CF00 00D0 CFBF CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"FECE 0000 FBCE 0300 CECE 00F3 CE00 00FB CE00 00FB CE00 00FE CE00 00FE CE00 00FB"
	$"CE06 00CE CE00 CECE 00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FA CE00 00FE"
	$"CE03 00CE CE00 FECE 0C00 CECE 00CE 00CE 00CE 00CE CE00 FECE 0300 CECE 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00F7 CE00 00FE CE06 00CE CE00 CECE 00FE CE00 00FA CE00"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE 0200 CE00 F9CE 0000"
	$"FBCE 0000 FECE 0000 FECE 0300 CECE 00FB CE00 00F7 CE00 00FE CE03 00CE CE00 FACE"
	$"0000 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 FECE 0000 FDCE 0000 FECE 0000 FECE"
	$"0000 D0CE 0306 BFCE 0000 FBCE FC00 02CE CE00 FECE 0600 CECE 00CE CE00 FECE 0000"
	$"FBCE 0000 FECE FE00 F9CE FD00 FACE FE00 FECE 0000 FECE 0000 FECE 0000 FECE FD00"
	$"05CE CE00 CECE 00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FA CE00 00FE CE03"
	$"00CE CE00 FECE 0B00 CECE 00CE 00CE 00CE 00CE CEFC 0002 CECE 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00F7 CE00 00FE CE06 00CE CE00 CECE 00FE CE00 00FD CEFD 0000 CEFE"
	$"0002 CECE 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE FE00 F9CE 0000 FBCE"
	$"0000 FECE 0000 FECE 0000 FECE FE00 FDCE FE00 01CE CEFE 0002 CECE 00FE CE03 00CE"
	$"CE00 FDCE FD00 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 FECE 0000 FDCE 0000 FECE"
	$"0000 FECE 0000 D0CE BFCF 0000 FBCF FC00 02CF CF00 FECF 0600 CFCF 00CF CF00 FECF"
	$"0000 FBCF 0000 FECF FE00 F9CF FD00 FACF FE00 FECF 0000 FECF 0000 FECF 0000 FECF"
	$"FD00 05CF CF00 CFCF 00FB CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FA CF00 00FE"
	$"CF03 00CF CF00 FECF 0B00 CFCF 00CF 00CF 00CF 00CF CFFC 0002 CFCF 00FE CF03 00CF"
	$"CF00 FECF 0300 CFCF 00F7 CF00 00FE CF06 00CF CF00 CFCF 00FE CF00 00FD CFFD 0000"
	$"CFFE 0002 CFCF 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FBCF FE00 F9CF 0000"
	$"FBCF 0000 FECF 0000 FECF 0000 FECF FE00 FDCF FE00 01CF CFFE 0002 CFCF 00FE CF03"
	$"00CF CF00 FDCF FD00 FECF 0000 FDCF 0000 FECF 0000 FECF 0000 FECF 0000 FDCF 0000"
	$"FECF 0000 FECF 0000 D0CF BFCE 0000 FBCE FC00 02CE CE00 FECE 0600 CECE 00CE CE00"
	$"FECE 0000 FBCE 0000 FECE FE00 F9CE FD00 FACE FE00 FECE 0000 FECE 0000 FECE 0000"
	$"FECE FD00 05CE CE00 CECE 00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FA CE00"
	$"00FE CE03 00CE CE00 FECE 0B00 CECE 00CE 00CE 00CE 00CE CEFC 0002 CECE 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00F7 CE00 00FE CE06 00CE CE00 CECE 00FE CE00 00FD CEFD"
	$"0000 CEFE 0002 CECE 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE FE00 F9CE"
	$"0000 FBCE 0000 FECE 0000 FECE 0000 FECE FE00 FDCE FE00 01CE CEFE 0002 CECE 00FE"
	$"CE03 00CE CE00 FDCE FD00 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 FECE 0000 FDCE"
	$"0000 FECE 0000 FECE 0000 D0CE 0318 BFCE 0000 FBCE 0000 FBCE 0000 FECE 0600 CECE"
	$"00CE CE00 FECE 0000 FBCE 0000 FBCE 0000 FBCE 0000 FECE 0000 F7CE 0300 CECE 00FE"
	$"CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE 0000 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FACE 0000 FECE 0300 CECE 00FE CE0C 00CE CE00 CE00 CE00 CE00 CECE"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00F7 CE00 00FE CE06 00CE CE00 CECE"
	$"00FE CE00 00FE CE00 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE"
	$"CE00 FBCE 0300 CECE 00FA CE00 00FB CE00 00FE CE00 00FE CE00 00FB CE00 00FB CE00"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FECE 0000 FDCE 0000 FECE 0000"
	$"FECE 0000 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 D0CE BFCF 0000 FBCF 0000 FBCF"
	$"0000 FECF 0600 CFCF 00CF CF00 FECF 0000 FBCF 0000 FBCF 0000 FBCF 0000 FECF 0000"
	$"F7CF 0300 CFCF 00FE CF00 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FBCF 0000"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 FACF 0000 FECF 0300 CFCF 00FE CF0C 00CF CF00"
	$"CF00 CF00 CF00 CFCF 00FB CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00F7 CF00 00FE"
	$"CF06 00CF CF00 CFCF 00FE CF00 00FE CF00 00FE CF00 00FB CF00 00FE CF03 00CF CF00"
	$"FECF 0600 CFCF 00CF CF00 FBCF 0300 CFCF 00FA CF00 00FB CF00 00FE CF00 00FE CF00"
	$"00FB CF00 00FB CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0000"
	$"FDCF 0000 FECF 0000 FECF 0000 FECF 0000 FDCF 0000 FECF 0000 FECF 0000 D0CF BFCE"
	$"0000 FBCE 0000 FBCE 0000 FECE 0600 CECE 00CE CE00 FECE 0000 FBCE 0000 FBCE 0000"
	$"FBCE 0000 FECE 0000 F7CE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0600 CECE"
	$"00CE CE00 FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0300 CECE"
	$"00FE CE0C 00CE CE00 CE00 CE00 CE00 CECE 00FB CE00 00FE CE03 00CE CE00 FECE 0300"
	$"CECE 00F7 CE00 00FE CE06 00CE CE00 CECE 00FE CE00 00FE CE00 00FE CE00 00FB CE00"
	$"00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE 0300 CECE 00FA CE00 00FB CE00"
	$"00FE CE00 00FE CE00 00FB CE00 00FB CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 FECE 0000 FDCE 0000 FECE 0000 FECE 0000 FECE 0000 FDCE 0000 FECE 0000"
	$"FECE 0000 D0CE 0357 BFCE 0000 FBCE 0000 FECE 0300 CECE 00FE CE06 00CE CE00 CECE"
	$"00F7 CE03 00CE CE00 FECE 0000 FBCE 0400 CECE 0000 FBCE 0000 FECE 0300 CECE 00FE"
	$"CE00 00FE CE0D 00CE CE00 CECE 0000 CECE 00CE CE00 FBCE 0000 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FACE 0700 00CE CE00 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CE00"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 F7CE 0000 FECE 0600 CECE"
	$"00CE CE00 FECE 0000 FECE 0400 CECE 0000 FBCE 0700 CECE 0000 CECE 00FE CE06 00CE"
	$"CE00 CECE 00FE CE06 00CE CE00 CECE 00FA CE00 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0700 00CE CE00 CECE 00FE CE04 00CE"
	$"CE00 00FE CE00 00FD CE00 00FE CE00 00FE CE00 00FE CE00 00FD CE00 00FE CE00 00FE"
	$"CE00 00D0 CEBF CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 F7CF"
	$"0300 CFCF 00FE CF00 00FB CF04 00CF CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0000"
	$"FECF 0D00 CFCF 00CF CF00 00CF CF00 CFCF 00FB CF00 00FE CF03 00CF CF00 FECF 0300"
	$"CFCF 00FA CF07 0000 CFCF 00CF CF00 FECF 0000 FECF 0000 FECF 0000 FECF 0000 FECF"
	$"0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00F7 CF00 00FE CF06 00CF CF00 CFCF"
	$"00FE CF00 00FE CF04 00CF CF00 00FB CF07 00CF CF00 00CF CF00 FECF 0600 CFCF 00CF"
	$"CF00 FECF 0600 CFCF 00CF CF00 FACF 0000 FECF 0300 CFCF 00FE CF00 00FE CF03 00CF"
	$"CF00 FECF 0300 CFCF 00FE CF00 00FB CF07 0000 CFCF 00CF CF00 FECF 0400 CFCF 0000"
	$"FECF 0000 FDCF 0000 FECF 0000 FECF 0000 FECF 0000 FDCF 0000 FECF 0000 FECF 0000"
	$"D0CF BFCE 0000 FBCE 0000 FECE 0300 CECE 00FE CE06 00CE CE00 CECE 00F7 CE03 00CE"
	$"CE00 FECE 0000 FBCE 0400 CECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE00 00FE CE0D"
	$"00CE CE00 CECE 0000 CECE 00CE CE00 FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FACE 0700 00CE CE00 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE03 00CE"
	$"CE00 FECE 0300 CECE 00FE CE03 00CE CE00 F7CE 0000 FECE 0600 CECE 00CE CE00 FECE"
	$"0000 FECE 0400 CECE 0000 FBCE 0700 CECE 0000 CECE 00FE CE06 00CE CE00 CECE 00FE"
	$"CE06 00CE CE00 CECE 00FA CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 FBCE 0700 00CE CE00 CECE 00FE CE04 00CE CE00 00FE CE00"
	$"00FD CE00 00FE CE00 00FE CE00 00FE CE00 00FD CE00 00FE CE00 00FE CE00 00D0 CE02"
	$"E2BF CEFB 0001 CECE FE00 FDCE FD00 09CE CE00 CECE 0000 CECE 00FB CE00 00FE CEFE"
	$"00F9 CE03 0000 CE00 FACE FE00 FECE 0000 FECE 0000 FECE 0000 FECE 0900 00CE 00CE"
	$"CE00 CECE 00FB CEFD 00FD CEFD 0003 CECE 0000 FBCE 0300 CE00 00FD CEFE 00FD CE00"
	$"00FE CE00 00FD CEFE 00FE CE00 00FE CE00 00FE CEFD 0002 CECE 00FE CE00 00FA CEFD"
	$"0009 CECE 00CE CE00 00CE CE00 FDCE 0300 00CE 00FA CE03 0000 CE00 FECE FD00 02CE"
	$"CE00 FECE FE00 FECE 0000 FECE 0000 FACE FE00 FECE 0000 FDCE FE00 FDCE FE00 FDCE"
	$"FE00 FACE 0300 CE00 00FE CE00 00FD CE03 0000 CE00 FECE 0100 00FE CE00 00FD CEFE"
	$"00FD CE00 00FD CE00 00FE CE00 00FE CE00 00FD CE00 00D5 CEBF CFFB 0001 CFCF FE00"
	$"FDCF FD00 09CF CF00 CFCF 0000 CFCF 00FB CF00 00FE CFFE 00F9 CF03 0000 CF00 FACF"
	$"FE00 FECF 0000 FECF 0000 FECF 0000 FECF 0900 00CF 00CF CF00 CFCF 00FB CFFD 00FD"
	$"CFFD 0003 CFCF 0000 FBCF 0300 CF00 00FD CFFE 00FD CF00 00FE CF00 00FD CFFE 00FE"
	$"CF00 00FE CF00 00FE CFFD 0002 CFCF 00FE CF00 00FA CFFD 0009 CFCF 00CF CF00 00CF"
	$"CF00 FDCF 0300 00CF 00FA CF03 0000 CF00 FECF FD00 02CF CF00 FECF FE00 FECF 0000"
	$"FECF 0000 FACF FE00 FECF 0000 FDCF FE00 FDCF FE00 FDCF FE00 FACF 0300 CF00 00FE"
	$"CF00 00FD CF03 0000 CF00 FECF 0100 00FE CF00 00FD CFFE 00FD CF00 00FD CF00 00FE"
	$"CF00 00FE CF00 00FD CF00 00D5 CFBF CEFB 0001 CECE FE00 FDCE FD00 09CE CE00 CECE"
	$"0000 CECE 00FB CE00 00FE CEFE 00F9 CE03 0000 CE00 FACE FE00 FECE 0000 FECE 0000"
	$"FECE 0000 FECE 0900 00CE 00CE CE00 CECE 00FB CEFD 00FD CEFD 0003 CECE 0000 FBCE"
	$"0300 CE00 00FD CEFE 00FD CE00 00FE CE00 00FD CEFE 00FE CE00 00FE CE00 00FE CEFD"
	$"0002 CECE 00FE CE00 00FA CEFD 0009 CECE 00CE CE00 00CE CE00 FDCE 0300 00CE 00FA"
	$"CE03 0000 CE00 FECE FD00 02CE CE00 FECE FE00 FECE 0000 FECE 0000 FACE FE00 FECE"
	$"0000 FDCE FE00 FDCE FE00 FDCE FE00 FACE 0300 CE00 00FE CE00 00FD CE03 0000 CE00"
	$"FECE 0100 00FE CE00 00FD CEFE 00FD CE00 00FD CE00 00FE CE00 00FE CE00 00FD CE00"
	$"00D5 CE00 4881 CECA CE00 00D2 CE00 00DA CE00 00BF CE00 00CC CE00 00D5 CE81 CFCA"
	$"CF00 00D2 CF00 00DA CF00 00BF CF00 00CC CF00 00D5 CF81 CECA CE00 00D2 CE00 00DA"
	$"CE00 00BF CE00 00CC CE00 00D5 CE00 4881 CECA CE00 00D2 CE00 00DA CE00 00BF CE00"
	$"00CC CE00 00D5 CE81 CFCA CF00 00D2 CF00 00DA CF00 00BF CF00 00CC CF00 00D5 CF81"
	$"CECA CE00 00D2 CE00 00DA CE00 00BF CE00 00CC CE00 00D5 CE00 3081 CECA CE00 00AA"
	$"CE00 00BF CE00 009F CE81 CFCA CF00 00AA CF00 00BF CF00 009F CF81 CECA CE00 00AA"
	$"CE00 00BF CE00 009F CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81"
	$"CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881"
	$"CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE01 50D7 CE00 00BA CE00"
	$"00F7 CE00 00E1 CE03 00CE CE00 F8CE 0000 FBCE 0000 F3CE 0100 00EE CE00 00F0 CE00"
	$"00FA CE00 00F1 CE00 00E6 CE00 00F3 CE00 00FC CE03 00CE CE00 FCCE 0600 CECE 00CE"
	$"CE00 FCCE 0000 F8CE 0200 CE00 FCCE 0000 FBCE 0000 FCCE 0000 FCCE 0300 CECE 00F2"
	$"CE00 00E5 CE00 00E9 CED7 CF00 00BA CF00 00F7 CF00 00E1 CF03 00CF CF00 F8CF 0000"
	$"FBCF 0000 F3CF 0100 00EE CF00 00F0 CF00 00FA CF00 00F1 CF00 00E6 CF00 00F3 CF00"
	$"00FC CF03 00CF CF00 FCCF 0600 CFCF 00CF CF00 FCCF 0000 F8CF 0200 CF00 FCCF 0000"
	$"FBCF 0000 FCCF 0000 FCCF 0300 CFCF 00F2 CF00 00E5 CF00 00E9 CFD7 CE00 00BA CE00"
	$"00F7 CE00 00E1 CE03 00CE CE00 F8CE 0000 FBCE 0000 F3CE 0100 00EE CE00 00F0 CE00"
	$"00FA CE00 00F1 CE00 00E6 CE00 00F3 CE00 00FC CE03 00CE CE00 FCCE 0600 CECE 00CE"
	$"CE00 FCCE 0000 F8CE 0200 CE00 FCCE 0000 FBCE 0000 FCCE 0000 FCCE 0300 CECE 00F2"
	$"CE00 00E5 CE00 00E9 CE01 5CD7 CE00 00BA CE03 00CE CE00 D6CE 0000 F8CE 0000 FBCE"
	$"0000 F4CE 0000 F0CE 0000 FECE 0000 F0CE 0100 00FC CE01 0000 E7CE 0000 F0CE 0000"
	$"F3CE 0000 FCCE 0400 CECE 0000 FDCE 0300 CECE 00FE CE00 00FE CE00 00F8 CE00 00FE"
	$"CE00 00FE CE00 00FA CE00 00FD CE02 00CE 00FD CE00 00EF CE00 00E4 CE00 00EA CED7"
	$"CF00 00BA CF03 00CF CF00 D6CF 0000 F8CF 0000 FBCF 0000 F4CF 0000 F0CF 0000 FECF"
	$"0000 F0CF 0100 00FC CF01 0000 E7CF 0000 F0CF 0000 F3CF 0000 FCCF 0400 CFCF 0000"
	$"FDCF 0300 CFCF 00FE CF00 00FE CF00 00F8 CF00 00FE CF00 00FE CF00 00FA CF00 00FD"
	$"CF02 00CF 00FD CF00 00EF CF00 00E4 CF00 00EA CFD7 CE00 00BA CE03 00CE CE00 D6CE"
	$"0000 F8CE 0000 FBCE 0000 F4CE 0000 F0CE 0000 FECE 0000 F0CE 0100 00FC CE01 0000"
	$"E7CE 0000 F0CE 0000 F3CE 0000 FCCE 0400 CECE 0000 FDCE 0300 CECE 00FE CE00 00FE"
	$"CE00 00F8 CE00 00FE CE00 00FE CE00 00FA CE00 00FD CE02 00CE 00FD CE00 00EF CE00"
	$"00E4 CE00 00EA CE01 5FD7 CE00 00BA CE03 00CE CE00 D6CE 0000 F8CE 0000 FBCE 0000"
	$"F4CE 0000 F0CE 0000 FECE 0000 F0CE 0100 00FC CE01 0000 E7CE 0000 F0CE 0000 F3CE"
	$"0000 FCCE 0500 CECE 00CE 00FE CE03 00CE CE00 FECE 0000 FECE 0000 F8CE 0000 FECE"
	$"0000 FECE 0000 F9CE 0000 FECE 0200 CE00 FECE 0000 EECE 0000 E4CE 0000 EACE D7CF"
	$"0000 BACF 0300 CFCF 00D6 CF00 00F8 CF00 00FB CF00 00F4 CF00 00F0 CF00 00FE CF00"
	$"00F0 CF01 0000 FCCF 0100 00E7 CF00 00F0 CF00 00F3 CF00 00FC CF05 00CF CF00 CF00"
	$"FECF 0300 CFCF 00FE CF00 00FE CF00 00F8 CF00 00FE CF00 00FE CF00 00F9 CF00 00FE"
	$"CF02 00CF 00FE CF00 00EE CF00 00E4 CF00 00EA CFD7 CE00 00BA CE03 00CE CE00 D6CE"
	$"0000 F8CE 0000 FBCE 0000 F4CE 0000 F0CE 0000 FECE 0000 F0CE 0100 00FC CE01 0000"
	$"E7CE 0000 F0CE 0000 F3CE 0000 FCCE 0500 CECE 00CE 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 F8CE 0000 FECE 0000 FECE 0000 F9CE 0000 FECE 0200 CE00 FECE 0000 EECE"
	$"0000 E4CE 0000 EACE 0387 F0CE 0000 FECE 0000 FECE 0200 CECE FE00 FECE 0800 CE00"
	$"CECE 0000 CE00 FBCE 0300 CE00 00FE CE04 00CE 00CE CEFE 00FD CEFE 00FD CEFE 00FD"
	$"CEFE 00FD CEFE 00FD CEFE 00FE CE02 00CE 00F8 CE01 00CE FE00 FBCE 0000 FECE FE00"
	$"F9CE FE00 02CE CE00 FECE 0200 CECE FE00 FECE 0300 CECE 00FE CEFE 00FE CE03 00CE"
	$"0000 FECE 0000 FECE FE00 FBCE FE00 01CE CEFE 00FE CE02 00CE 00FD CEFE 0005 CECE"
	$"00CE 0000 FDCE FE00 FACE 0200 CE00 FECE 0200 CE00 FECE FE00 FDCE FE00 FECE 0800"
	$"CECE 00CE 0000 CECE FE00 FECE FE00 FDCE FE00 FECE 0300 CE00 00F6 CE00 00FC CE05"
	$"00CE CE00 CE00 FECE 0300 CECE 00FD CE02 00CE 00F8 CE00 00FC CE02 00CE 00F8 CE00"
	$"00FE CE02 00CE 00FE CE00 00FE CE00 00FE CE03 00CE 0000 FCCE 0300 00CE 00FD CEFE"
	$"00FE CE00 00FE CE00 00FE CE00 00FE CEFE 00FC CE00 00EB CEF0 CF00 00FE CF00 00FE"
	$"CF02 00CF CFFE 00FE CF08 00CF 00CF CF00 00CF 00FB CF03 00CF 0000 FECF 0400 CF00"
	$"CFCF FE00 FDCF FE00 FDCF FE00 FDCF FE00 FDCF FE00 FDCF FE00 FECF 0200 CF00 F8CF"
	$"0100 CFFE 00FB CF00 00FE CFFE 00F9 CFFE 0002 CFCF 00FE CF02 00CF CFFE 00FE CF03"
	$"00CF CF00 FECF FE00 FECF 0300 CF00 00FE CF00 00FE CFFE 00FB CFFE 0001 CFCF FE00"
	$"FECF 0200 CF00 FDCF FE00 05CF CF00 CF00 00FD CFFE 00FA CF02 00CF 00FE CF02 00CF"
	$"00FE CFFE 00FD CFFE 00FE CF08 00CF CF00 CF00 00CF CFFE 00FE CFFE 00FD CFFE 00FE"
	$"CF03 00CF 0000 F6CF 0000 FCCF 0500 CFCF 00CF 00FE CF03 00CF CF00 FDCF 0200 CF00"
	$"F8CF 0000 FCCF 0200 CF00 F8CF 0000 FECF 0200 CF00 FECF 0000 FECF 0000 FECF 0300"
	$"CF00 00FC CF03 0000 CF00 FDCF FE00 FECF 0000 FECF 0000 FECF 0000 FECF FE00 FCCF"
	$"0000 EBCF F0CE 0000 FECE 0000 FECE 0200 CECE FE00 FECE 0800 CE00 CECE 0000 CE00"
	$"FBCE 0300 CE00 00FE CE04 00CE 00CE CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE"
	$"00FD CEFE 00FE CE02 00CE 00F8 CE01 00CE FE00 FBCE 0000 FECE FE00 F9CE FE00 02CE"
	$"CE00 FECE 0200 CECE FE00 FECE 0300 CECE 00FE CEFE 00FE CE03 00CE 0000 FECE 0000"
	$"FECE FE00 FBCE FE00 01CE CEFE 00FE CE02 00CE 00FD CEFE 0005 CECE 00CE 0000 FDCE"
	$"FE00 FACE 0200 CE00 FECE 0200 CE00 FECE FE00 FDCE FE00 FECE 0800 CECE 00CE 0000"
	$"CECE FE00 FECE FE00 FDCE FE00 FECE 0300 CE00 00F6 CE00 00FC CE05 00CE CE00 CE00"
	$"FECE 0300 CECE 00FD CE02 00CE 00F8 CE00 00FC CE02 00CE 00F8 CE00 00FE CE02 00CE"
	$"00FE CE00 00FE CE00 00FE CE03 00CE 0000 FCCE 0300 00CE 00FD CEFE 00FE CE00 00FE"
	$"CE00 00FE CE00 00FE CEFE 00FC CE00 00EB CE04 14F0 CE00 00FE CE00 00FE CE02 00CE"
	$"00FE CE0B 00CE CE00 00CE CE00 CECE 0000 FBCE 0B00 00CE CE00 CECE 0000 CECE 00FE"
	$"CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE 0400 CECE 0000 F7CE 0300 CECE 00FA CE03 00CE CE00 FECE 0000 FBCE 0000"
	$"FECE 0200 CE00 FECE 0200 CE00 FECE 0900 CECE 00CE CE00 CECE 00FE CE0D 00CE CE00"
	$"00CE CE00 CECE 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE CE04 00CE CE00 00FB CE00"
	$"00FE CE07 0000 CECE 00CE CE00 FECE 0000 FBCE 0200 CE00 FECE 0500 CE00 CECE 00FE"
	$"CE03 00CE CE00 FECE 0D00 CECE 00CE CE00 00CE CE00 CECE 00FE CE00 00FE CE03 00CE"
	$"CE00 FECE 0700 CECE 0000 CECE 00F7 CE00 00FC CE0C 00CE CE00 CECE 00CE CE00 CECE"
	$"00FC CE00 00F7 CE00 00FB CE00 00F7 CE00 00FE CE02 00CE 00FE CE00 00FE CE00 00FE"
	$"CE04 0000 CECE 00FE CE04 00CE CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0300 CECE 00FE CE00 00FD CE00 00EB CEF0 CF00 00FE CF00 00FE CF02 00CF 00FE CF0B"
	$"00CF CF00 00CF CF00 CFCF 0000 FBCF 0B00 00CF CF00 CFCF 0000 CFCF 00FE CF03 00CF"
	$"CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF"
	$"0400 CFCF 0000 F7CF 0300 CFCF 00FA CF03 00CF CF00 FECF 0000 FBCF 0000 FECF 0200"
	$"CF00 FECF 0200 CF00 FECF 0900 CFCF 00CF CF00 CFCF 00FE CF0D 00CF CF00 00CF CF00"
	$"CFCF 00CF CF00 FECF 0000 FBCF 0300 CFCF 00FE CF04 00CF CF00 00FB CF00 00FE CF07"
	$"0000 CFCF 00CF CF00 FECF 0000 FBCF 0200 CF00 FECF 0500 CF00 CFCF 00FE CF03 00CF"
	$"CF00 FECF 0D00 CFCF 00CF CF00 00CF CF00 CFCF 00FE CF00 00FE CF03 00CF CF00 FECF"
	$"0700 CFCF 0000 CFCF 00F7 CF00 00FC CF0C 00CF CF00 CFCF 00CF CF00 CFCF 00FC CF00"
	$"00F7 CF00 00FB CF00 00F7 CF00 00FE CF02 00CF 00FE CF00 00FE CF00 00FE CF04 0000"
	$"CFCF 00FE CF04 00CF CF00 00FE CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0300 CFCF"
	$"00FE CF00 00FD CF00 00EB CFF0 CE00 00FE CE00 00FE CE02 00CE 00FE CE0B 00CE CE00"
	$"00CE CE00 CECE 0000 FBCE 0B00 00CE CE00 CECE 0000 CECE 00FE CE03 00CE CE00 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0400 CECE"
	$"0000 F7CE 0300 CECE 00FA CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0200 CE00 FECE"
	$"0200 CE00 FECE 0900 CECE 00CE CE00 CECE 00FE CE0D 00CE CE00 00CE CE00 CECE 00CE"
	$"CE00 FECE 0000 FBCE 0300 CECE 00FE CE04 00CE CE00 00FB CE00 00FE CE07 0000 CECE"
	$"00CE CE00 FECE 0000 FBCE 0200 CE00 FECE 0500 CE00 CECE 00FE CE03 00CE CE00 FECE"
	$"0D00 CECE 00CE CE00 00CE CE00 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0700 CECE"
	$"0000 CECE 00F7 CE00 00FC CE0C 00CE CE00 CECE 00CE CE00 CECE 00FC CE00 00F7 CE00"
	$"00FB CE00 00F7 CE00 00FE CE02 00CE 00FE CE00 00FE CE00 00FE CE04 0000 CECE 00FE"
	$"CE04 00CE CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00"
	$"00FD CE00 00EB CE03 99EF CE09 00CE 00CE 00CE 00CE CE00 FECE 0300 CECE 00FE CE00"
	$"00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FB CE00 00FE"
	$"CE03 00CE CE00 FBCE 0000 FBCE 0000 FECE 0300 CECE 00F6 CE03 00CE CE00 FACE 0300"
	$"CECE 00F3 CE05 00CE CE00 CE00 FBCE 0600 CECE 00CE CE00 FBCE 0300 CECE 00FE CE06"
	$"00CE CE00 CECE 00FE CE00 00FB CE03 00CE CE00 FECE 0300 CECE 00FA CE00 00FE CE00"
	$"00FE CE03 00CE CE00 FECE 0000 FBCE 0800 CECE 00CE 00CE CE00 FBCE 0300 CECE 00FB"
	$"CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FBCE 0000 FECE 0000"
	$"F7CE 0000 FCCE 0C00 CECE 00CE CE00 CECE 00CE CE00 FCCE 0000 F7CE 0000 FBCE 0000"
	$"F6CE 0200 CE00 FECE 0200 CE00 FDCE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000"
	$"FECE 0000 FECE 0000 FECE 0600 CE00 CE00 CE00 FECE 0000 F9CE 0000 EBCE EFCF 0900"
	$"CF00 CF00 CF00 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FBCF 0000 FECF 0300"
	$"CFCF 00FE CF00 00FE CF03 00CF CF00 FBCF 0000 FECF 0300 CFCF 00FB CF00 00FB CF00"
	$"00FE CF03 00CF CF00 F6CF 0300 CFCF 00FA CF03 00CF CF00 F3CF 0500 CFCF 00CF 00FB"
	$"CF06 00CF CF00 CFCF 00FB CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0000 FBCF"
	$"0300 CFCF 00FE CF03 00CF CF00 FACF 0000 FECF 0000 FECF 0300 CFCF 00FE CF00 00FB"
	$"CF08 00CF CF00 CF00 CFCF 00FB CF03 00CF CF00 FBCF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0000 FECF 0300 CFCF 00FB CF00 00FE CF00 00F7 CF00 00FC CF0C 00CF CF00 CFCF"
	$"00CF CF00 CFCF 00FC CF00 00F7 CF00 00FB CF00 00F6 CF02 00CF 00FE CF02 00CF 00FD"
	$"CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF06 00CF"
	$"00CF 00CF 00FE CF00 00F9 CF00 00EB CFEF CE09 00CE 00CE 00CE 00CE CE00 FECE 0300"
	$"CECE 00FE CE00 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE"
	$"00FB CE00 00FE CE03 00CE CE00 FBCE 0000 FBCE 0000 FECE 0300 CECE 00F6 CE03 00CE"
	$"CE00 FACE 0300 CECE 00F3 CE05 00CE CE00 CE00 FBCE 0600 CECE 00CE CE00 FBCE 0300"
	$"CECE 00FE CE06 00CE CE00 CECE 00FE CE00 00FB CE03 00CE CE00 FECE 0300 CECE 00FA"
	$"CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FBCE 0800 CECE 00CE 00CE CE00 FBCE"
	$"0300 CECE 00FB CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FBCE"
	$"0000 FECE 0000 F7CE 0000 FCCE 0C00 CECE 00CE CE00 CECE 00CE CE00 FCCE 0000 F7CE"
	$"0000 FBCE 0000 F6CE 0200 CE00 FECE 0200 CE00 FDCE 0000 FECE 0000 FECE 0000 FECE"
	$"0000 FECE 0000 FECE 0000 FECE 0000 FECE 0600 CE00 CE00 CE00 FECE 0000 F9CE 0000"
	$"EBCE 03B1 EFCE 0900 CE00 CE00 CE00 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0100"
	$"CEFE 0002 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FB CEFC 00FE CEFE"
	$"00FD CEFE 00FE CE00 00FE CE03 00CE CE00 F6CE 0300 CECE 00FA CE00 00FE CEFE 00F9"
	$"CEFD 0004 CECE 00CE 00FE CEFD 0005 CECE 00CE CE00 FECE FD00 02CE CE00 FECE 0500"
	$"CECE 00CE CEFC 00FB CE03 00CE CE00 FECE 0300 CECE 00FA CE00 00FE CE00 00FE CE02"
	$"00CE CEFC 00FB CE08 00CE CE00 CE00 CECE 00FE CEFD 0002 CECE 00FB CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE00 00FE CE00 00FE CEFE 00FE CE00 00FE CE00 00F7 CE00 00FC"
	$"CE03 00CE CE00 FECE 0500 CE00 CECE 00FD CE02 00CE 00F8 CE00 00FC CE02 00CE 00FE"
	$"CEFE 00FD CE02 00CE 00FE CE02 00CE 00FD CE00 00FE CE00 00FE CE00 00FE CE00 00FE"
	$"CE00 00FE CE00 00FE CE00 00FE CE06 00CE 00CE 00CE 00FD CEFE 00FC CE00 00EB CEEF"
	$"CF09 00CF 00CF 00CF 00CF CF00 FECF 0300 CFCF 00FE CF00 00FE CF01 00CF FE00 02CF"
	$"CF00 FECF 0300 CFCF 00FE CF00 00FE CF03 00CF CF00 FBCF FC00 FECF FE00 FDCF FE00"
	$"FECF 0000 FECF 0300 CFCF 00F6 CF03 00CF CF00 FACF 0000 FECF FE00 F9CF FD00 04CF"
	$"CF00 CF00 FECF FD00 05CF CF00 CFCF 00FE CFFD 0002 CFCF 00FE CF05 00CF CF00 CFCF"
	$"FC00 FBCF 0300 CFCF 00FE CF03 00CF CF00 FACF 0000 FECF 0000 FECF 0200 CFCF FC00"
	$"FBCF 0800 CFCF 00CF 00CF CF00 FECF FD00 02CF CF00 FBCF 0300 CFCF 00FE CF03 00CF"
	$"CF00 FECF 0000 FECF 0000 FECF FE00 FECF 0000 FECF 0000 F7CF 0000 FCCF 0300 CFCF"
	$"00FE CF05 00CF 00CF CF00 FDCF 0200 CF00 F8CF 0000 FCCF 0200 CF00 FECF FE00 FDCF"
	$"0200 CF00 FECF 0200 CF00 FDCF 0000 FECF 0000 FECF 0000 FECF 0000 FECF 0000 FECF"
	$"0000 FECF 0000 FECF 0600 CF00 CF00 CF00 FDCF FE00 FCCF 0000 EBCF EFCE 0900 CE00"
	$"CE00 CE00 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0100 CEFE 0002 CECE 00FE CE03"
	$"00CE CE00 FECE 0000 FECE 0300 CECE 00FB CEFC 00FE CEFE 00FD CEFE 00FE CE00 00FE"
	$"CE03 00CE CE00 F6CE 0300 CECE 00FA CE00 00FE CEFE 00F9 CEFD 0004 CECE 00CE 00FE"
	$"CEFD 0005 CECE 00CE CE00 FECE FD00 02CE CE00 FECE 0500 CECE 00CE CEFC 00FB CE03"
	$"00CE CE00 FECE 0300 CECE 00FA CE00 00FE CE00 00FE CE02 00CE CEFC 00FB CE08 00CE"
	$"CE00 CE00 CECE 00FE CEFD 0002 CECE 00FB CE03 00CE CE00 FECE 0300 CECE 00FE CE00"
	$"00FE CE00 00FE CEFE 00FE CE00 00FE CE00 00F7 CE00 00FC CE03 00CE CE00 FECE 0500"
	$"CE00 CECE 00FD CE02 00CE 00F8 CE00 00FC CE02 00CE 00FE CEFE 00FD CE02 00CE 00FE"
	$"CE02 00CE 00FD CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00"
	$"00FE CE06 00CE 00CE 00CE 00FD CEFE 00FC CE00 00EB CE03 B7EF CE09 00CE 00CE 00CE"
	$"00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE"
	$"0000 FECE 0300 CECE 00FB CE00 00F7 CE00 00FB CE03 00CE CE00 FECE 0300 CECE 00F6"
	$"CE03 00CE CE00 FACE 0000 FBCE 0000 FBCE 0000 FECE 0800 CECE 00CE 00CE CE00 FECE"
	$"0900 CECE 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 F7CE 0300"
	$"CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00F7 CE0B 00CE CE00"
	$"CE00 CECE 00CE CE00 FECE 0300 CECE 00FB CE03 00CE CE00 FECE 0300 CECE 00FE CE00"
	$"00FE CE00 00FB CE03 00CE CE00 FECE 0000 F7CE 0000 FCCE 0300 CECE 00FE CE05 00CE"
	$"00CE CE00 FECE 0000 FECE 0000 F9CE 0000 FDCE 0000 FECE 0000 F8CE 0200 CE00 FECE"
	$"0200 CE00 FDCE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000"
	$"FECE 0600 CE00 CE00 CE00 FACE 0000 FDCE 0000 EBCE EFCF 0900 CF00 CF00 CF00 CFCF"
	$"00FE CF03 00CF CF00 FECF 0000 FECF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF00 00FE"
	$"CF03 00CF CF00 FBCF 0000 F7CF 0000 FBCF 0300 CFCF 00FE CF03 00CF CF00 F6CF 0300"
	$"CFCF 00FA CF00 00FB CF00 00FB CF00 00FE CF08 00CF CF00 CF00 CFCF 00FE CF09 00CF"
	$"CF00 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF06 00CF CF00 CFCF 00F7 CF03 00CF CF00"
	$"FECF 0300 CFCF 00FA CF00 00FE CF00 00FE CF03 00CF CF00 F7CF 0B00 CFCF 00CF 00CF"
	$"CF00 CFCF 00FE CF03 00CF CF00 FBCF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF"
	$"0000 FBCF 0300 CFCF 00FE CF00 00F7 CF00 00FC CF03 00CF CF00 FECF 0500 CF00 CFCF"
	$"00FE CF00 00FE CF00 00F9 CF00 00FD CF00 00FE CF00 00F8 CF02 00CF 00FE CF02 00CF"
	$"00FD CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF06"
	$"00CF 00CF 00CF 00FA CF00 00FD CF00 00EB CFEF CE09 00CE 00CE 00CE 00CE CE00 FECE"
	$"0300 CECE 00FE CE00 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0300"
	$"CECE 00FB CE00 00F7 CE00 00FB CE03 00CE CE00 FECE 0300 CECE 00F6 CE03 00CE CE00"
	$"FACE 0000 FBCE 0000 FBCE 0000 FECE 0800 CECE 00CE 00CE CE00 FECE 0900 CECE 00CE"
	$"CE00 CECE 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 F7CE 0300 CECE 00FE CE03"
	$"00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00F7 CE0B 00CE CE00 CE00 CECE 00CE"
	$"CE00 FECE 0300 CECE 00FB CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FB"
	$"CE03 00CE CE00 FECE 0000 F7CE 0000 FCCE 0300 CECE 00FE CE05 00CE 00CE CE00 FECE"
	$"0000 FECE 0000 F9CE 0000 FDCE 0000 FECE 0000 F8CE 0200 CE00 FECE 0200 CE00 FDCE"
	$"0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0600 CE00"
	$"CE00 CE00 FACE 0000 FDCE 0000 EBCE 0408 EECE 0000 FECE 0000 FECE 0000 FECE 0300"
	$"CECE 00FE CE00 00FE CE00 00FB CE07 0000 CECE 00CE CE00 FECE 0000 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03"
	$"00CE CE00 F6CE 0300 CECE 00FA CE03 00CE CE00 FECE 0000 FBCE 0400 CECE 0000 FECE"
	$"0000 FECE 1400 CECE 0000 CECE 00CE CE00 CECE 00CE CE00 00CE CE00 FECE 0600 CECE"
	$"00CE CE00 FECE 0000 FBCE 0300 CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0000 FECE"
	$"0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE0A 00CE CE00 CECE 0000 CECE 00FE"
	$"CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE 0000 F6CE 0000 FECE 0000 FECE 0000 FDCE 0400 00CE CE00 FECE 0000 FECE"
	$"0000 F9CE 0000 FDCE 0000 FECE 0000 F7CE 0000 FCCE 0000 FCCE 0000 FECE 0000 FECE"
	$"0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FDCE 0000 FECE 0000 FDCE 0000 FECE"
	$"0000 FDCE 0000 EBCE EECF 0000 FECF 0000 FECF 0000 FECF 0300 CFCF 00FE CF00 00FE"
	$"CF00 00FB CF07 0000 CFCF 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 F6CF 0300"
	$"CFCF 00FA CF03 00CF CF00 FECF 0000 FBCF 0400 CFCF 0000 FECF 0000 FECF 1400 CFCF"
	$"0000 CFCF 00CF CF00 CFCF 00CF CF00 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0000"
	$"FBCF 0300 CFCF 00FE CF03 00CF CF00 FACF 0000 FECF 0000 FECF 0300 CFCF 00FE CF00"
	$"00FB CF00 00FE CF00 00FE CF0A 00CF CF00 CFCF 0000 CFCF 00FE CF06 00CF CF00 CFCF"
	$"00FE CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 F6CF"
	$"0000 FECF 0000 FECF 0000 FDCF 0400 00CF CF00 FECF 0000 FECF 0000 F9CF 0000 FDCF"
	$"0000 FECF 0000 F7CF 0000 FCCF 0000 FCCF 0000 FECF 0000 FECF 0000 FECF 0000 FECF"
	$"0000 FECF 0000 FECF 0000 FDCF 0000 FECF 0000 FDCF 0000 FECF 0000 FDCF 0000 EBCF"
	$"EECE 0000 FECE 0000 FECE 0000 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE07 0000"
	$"CECE 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 F6CE 0300 CECE 00FA CE03 00CE"
	$"CE00 FECE 0000 FBCE 0400 CECE 0000 FECE 0000 FECE 1400 CECE 0000 CECE 00CE CE00"
	$"CECE 00CE CE00 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE"
	$"CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00"
	$"00FE CE0A 00CE CE00 CECE 0000 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00"
	$"FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 F6CE 0000 FECE 0000 FECE"
	$"0000 FDCE 0400 00CE CE00 FECE 0000 FECE 0000 F9CE 0000 FDCE 0000 FECE 0000 F7CE"
	$"0000 FCCE 0000 FCCE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 FECE"
	$"0000 FDCE 0000 FECE 0000 FDCE 0000 FECE 0000 FDCE 0000 EBCE 036C EECE 0000 FECE"
	$"0000 FDCE FE00 FECE 0000 FDCE FD00 FBCE 0300 CE00 00FE CE00 00FD CEFE 00FD CEFE"
	$"00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FE CE00 00FE CE00 00FA CE04 00CE CE00"
	$"00FB CE00 00FE CEFE 00F9 CE03 0000 CE00 FECE 0000 FDCE 0900 00CE 00CE CE00 CECE"
	$"00FE CE05 0000 CE00 CECE FD00 FECE 0000 FECE FE00 FACE 0000 FECE FE00 FECE 0000"
	$"FACE 0400 00CE CE00 FECE 0000 FECE FE00 FACE 0000 FECE 0000 FECE 0000 FECE 0300"
	$"00CE 00FE CEFE 00FE CE03 00CE CE00 FECE 0400 CECE 0000 FECE FE00 FDCE FE00 FECE"
	$"0000 FECE 0000 FECE 0000 F9CE FE00 FDCE 0000 FCCE 0600 CECE 00CE CE00 FCCE 0000"
	$"FACE 0000 FECE 0000 FCCE 0000 F8CE 0000 FCCE 0000 FCCE 0000 FECE 0000 FECE 0000"
	$"FDCE FD00 FDCE FE00 FCCE 0000 FECE 0000 FCCE FE00 FCCE 0000 FDCE 0000 F0CE EECF"
	$"0000 FECF 0000 FDCF FE00 FECF 0000 FDCF FD00 FBCF 0300 CF00 00FE CF00 00FD CFFE"
	$"00FD CFFE 00FD CFFE 00FD CFFE 00FD CFFE 00FD CFFE 00FE CF00 00FE CF00 00FA CF04"
	$"00CF CF00 00FB CF00 00FE CFFE 00F9 CF03 0000 CF00 FECF 0000 FDCF 0900 00CF 00CF"
	$"CF00 CFCF 00FE CF05 0000 CF00 CFCF FD00 FECF 0000 FECF FE00 FACF 0000 FECF FE00"
	$"FECF 0000 FACF 0400 00CF CF00 FECF 0000 FECF FE00 FACF 0000 FECF 0000 FECF 0000"
	$"FECF 0300 00CF 00FE CFFE 00FE CF03 00CF CF00 FECF 0400 CFCF 0000 FECF FE00 FDCF"
	$"FE00 FECF 0000 FECF 0000 FECF 0000 F9CF FE00 FDCF 0000 FCCF 0600 CFCF 00CF CF00"
	$"FCCF 0000 FACF 0000 FECF 0000 FCCF 0000 F8CF 0000 FCCF 0000 FCCF 0000 FECF 0000"
	$"FECF 0000 FDCF FD00 FDCF FE00 FCCF 0000 FECF 0000 FCCF FE00 FCCF 0000 FDCF 0000"
	$"F0CF EECE 0000 FECE 0000 FDCE FE00 FECE 0000 FDCE FD00 FBCE 0300 CE00 00FE CE00"
	$"00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FE CE00 00FE CE00"
	$"00FA CE04 00CE CE00 00FB CE00 00FE CEFE 00F9 CE03 0000 CE00 FECE 0000 FDCE 0900"
	$"00CE 00CE CE00 CECE 00FE CE05 0000 CE00 CECE FD00 FECE 0000 FECE FE00 FACE 0000"
	$"FECE FE00 FECE 0000 FACE 0400 00CE CE00 FECE 0000 FECE FE00 FACE 0000 FECE 0000"
	$"FECE 0000 FECE 0300 00CE 00FE CEFE 00FE CE03 00CE CE00 FECE 0400 CECE 0000 FECE"
	$"FE00 FDCE FE00 FECE 0000 FECE 0000 FECE 0000 F9CE FE00 FDCE 0000 FCCE 0600 CECE"
	$"00CE CE00 FCCE 0000 FACE 0000 FECE 0000 FCCE 0000 F8CE 0000 FCCE 0000 FCCE 0000"
	$"FECE 0000 FECE 0000 FDCE FD00 FDCE FE00 FCCE 0000 FECE 0000 FCCE FE00 FCCE 0000"
	$"FDCE 0000 F0CE 0048 D0CE 0000 81CE 8ECE 0000 D7CE 0000 B5CE 0000 FCCE 0000 F0CE"
	$"D0CF 0000 81CF 8ECF 0000 D7CF 0000 B5CF 0000 FCCF 0000 F0CF D0CE 0000 81CE 8ECE"
	$"0000 D7CE 0000 B5CE 0000 FCCE 0000 F0CE 0048 D0CE 0000 81CE 8ECE 0000 D7CE 0000"
	$"B5CE 0000 FCCE 0000 F0CE D0CF 0000 81CF 8ECF 0000 D7CF 0000 B5CF 0000 FCCF 0000"
	$"F0CF D0CE 0000 81CE 8ECE 0000 D7CE 0000 B5CE 0000 FCCE 0000 F0CE 0036 D0CE 0000"
	$"81CE 81CE E2CE 0000 B7CE 0000 E9CE D0CF 0000 81CF 81CF E2CF 0000 B7CF 0000 E9CF"
	$"D0CE 0000 81CE 81CE E2CE 0000 B7CE 0000 E9CE 0018 81CE 81CE 81CE CCCE 81CF 81CF"
	$"81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE"
	$"81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE"
	$"00EA DDCE 0000 FBCE 0000 FACE 0000 FECE FC00 FBCE 0000 FCCE 0000 FCCE 0200 CE00"
	$"F4CE 0000 E0CE 0000 F0CE 0300 CECE 00FB CE00 00DE CE00 00EF CE01 0000 EFCE 0000"
	$"DBCE 0000 FBCE 0000 C0CE 0200 CE00 A6CE DDCF 0000 FBCF 0000 FACF 0000 FECF FC00"
	$"FBCF 0000 FCCF 0000 FCCF 0200 CF00 F4CF 0000 E0CF 0000 F0CF 0300 CFCF 00FB CF00"
	$"00DE CF00 00EF CF01 0000 EFCF 0000 DBCF 0000 FBCF 0000 C0CF 0200 CF00 A6CF DDCE"
	$"0000 FBCE 0000 FACE 0000 FECE FC00 FBCE 0000 FCCE 0000 FCCE 0200 CE00 F4CE 0000"
	$"E0CE 0000 F0CE 0300 CECE 00FB CE00 00DE CE00 00EF CE01 0000 EFCE 0000 DBCE 0000"
	$"FBCE 0000 C0CE 0200 CE00 A6CE 011A DDCE 0000 FBCE 0100 00FC CE04 0000 CECE 00FC"
	$"CE00 00FC CE00 00FD CE02 00CE 00FD CE00 00F2 CE00 00E0 CE00 00F0 CE06 00CE CE00"
	$"CECE 00FE CE00 00DE CE00 00F0 CE00 00ED CE00 00DB CE00 00FB CE00 00C1 CE03 00CE"
	$"CE00 F4CE 0000 CACE 0000 ECCE DDCF 0000 FBCF 0100 00FC CF04 0000 CFCF 00FC CF00"
	$"00FC CF00 00FD CF02 00CF 00FD CF00 00F2 CF00 00E0 CF00 00F0 CF06 00CF CF00 CFCF"
	$"00FE CF00 00DE CF00 00F0 CF00 00ED CF00 00DB CF00 00FB CF00 00C1 CF03 00CF CF00"
	$"F4CF 0000 CACF 0000 ECCF DDCE 0000 FBCE 0100 00FC CE04 0000 CECE 00FC CE00 00FC"
	$"CE00 00FD CE02 00CE 00FD CE00 00F2 CE00 00E0 CE00 00F0 CE06 00CE CE00 CECE 00FE"
	$"CE00 00DE CE00 00F0 CE00 00ED CE00 00DB CE00 00FB CE00 00C1 CE03 00CE CE00 F4CE"
	$"0000 CACE 0000 ECCE 011A DDCE 0000 FBCE 0100 00FC CE04 0000 CECE 00FC CE00 00FB"
	$"CE00 00FE CE02 00CE 00FE CE00 00F1 CE00 00E0 CE00 00F0 CE06 00CE CE00 CECE 00FE"
	$"CE00 00DE CE00 00F0 CE00 00ED CE00 00DB CE00 00FB CE00 00C1 CE03 00CE CE00 F4CE"
	$"0000 CACE 0000 ECCE DDCF 0000 FBCF 0100 00FC CF04 0000 CFCF 00FC CF00 00FB CF00"
	$"00FE CF02 00CF 00FE CF00 00F1 CF00 00E0 CF00 00F0 CF06 00CF CF00 CFCF 00FE CF00"
	$"00DE CF00 00F0 CF00 00ED CF00 00DB CF00 00FB CF00 00C1 CF03 00CF CF00 F4CF 0000"
	$"CACF 0000 ECCF DDCE 0000 FBCE 0100 00FC CE04 0000 CECE 00FC CE00 00FB CE00 00FE"
	$"CE02 00CE 00FE CE00 00F1 CE00 00E0 CE00 00F0 CE06 00CE CE00 CECE 00FE CE00 00DE"
	$"CE00 00F0 CE00 00ED CE00 00DB CE00 00FB CE00 00C1 CE03 00CE CE00 F4CE 0000 CACE"
	$"0000 ECCE 0390 EECE FE00 FECE 0300 CE00 00FD CE03 0000 CE00 FBCE 0200 CE00 FECE"
	$"0500 CE00 CECE 00F5 CE00 00FE CE02 00CE 00FE CE09 00CE CE00 CECE 00CE 0000 FDCE"
	$"0300 00CE 00FE CEFE 0002 CECE 00FE CE00 00FE CE02 00CE CEFE 00F6 CE00 00FA CEFE"
	$"00FD CE07 0000 CE00 CECE 00CE FE00 02CE CE00 FBCE 0700 CE00 00CE CE00 00FD CEFE"
	$"00FE CE00 00FE CE00 00FB CE03 00CE 0000 FDCE FE00 FBCE FE00 05CE 00CE 00CE CEFE"
	$"00FD CEFE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FECE FE00 FDCE FE00"
	$"FDCE 0300 00CE 00FB CE03 00CE 0000 FECE 0000 FECE 0000 FACE FE00 FECE 0300 CE00"
	$"00FE CE00 00FE CE00 00FE CEFE 00FE CE03 00CE 0000 FDCE FE00 FACE 0000 FECE 0300"
	$"CE00 00FE CE00 00FE CE01 00CE FE00 FBCE 0700 CE00 00CE CE00 00FD CEFE 00FD CE00"
	$"00FE CE00 00F9 CE03 00CE 0000 FCCE FE00 FECE FE00 EDCE EECF FE00 FECF 0300 CF00"
	$"00FD CF03 0000 CF00 FBCF 0200 CF00 FECF 0500 CF00 CFCF 00F5 CF00 00FE CF02 00CF"
	$"00FE CF09 00CF CF00 CFCF 00CF 0000 FDCF 0300 00CF 00FE CFFE 0002 CFCF 00FE CF00"
	$"00FE CF02 00CF CFFE 00F6 CF00 00FA CFFE 00FD CF07 0000 CF00 CFCF 00CF FE00 02CF"
	$"CF00 FBCF 0700 CF00 00CF CF00 00FD CFFE 00FE CF00 00FE CF00 00FB CF03 00CF 0000"
	$"FDCF FE00 FBCF FE00 05CF 00CF 00CF CFFE 00FD CFFE 00FE CF03 00CF CF00 FECF 0000"
	$"FBCF 0000 FECF 0000 FECF FE00 FDCF FE00 FDCF 0300 00CF 00FB CF03 00CF 0000 FECF"
	$"0000 FECF 0000 FACF FE00 FECF 0300 CF00 00FE CF00 00FE CF00 00FE CFFE 00FE CF03"
	$"00CF 0000 FDCF FE00 FACF 0000 FECF 0300 CF00 00FE CF00 00FE CF01 00CF FE00 FBCF"
	$"0700 CF00 00CF CF00 00FD CFFE 00FD CF00 00FE CF00 00F9 CF03 00CF 0000 FCCF FE00"
	$"FECF FE00 EDCF EECE FE00 FECE 0300 CE00 00FD CE03 0000 CE00 FBCE 0200 CE00 FECE"
	$"0500 CE00 CECE 00F5 CE00 00FE CE02 00CE 00FE CE09 00CE CE00 CECE 00CE 0000 FDCE"
	$"0300 00CE 00FE CEFE 0002 CECE 00FE CE00 00FE CE02 00CE CEFE 00F6 CE00 00FA CEFE"
	$"00FD CE07 0000 CE00 CECE 00CE FE00 02CE CE00 FBCE 0700 CE00 00CE CE00 00FD CEFE"
	$"00FE CE00 00FE CE00 00FB CE03 00CE 0000 FDCE FE00 FBCE FE00 05CE 00CE 00CE CEFE"
	$"00FD CEFE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FECE FE00 FDCE FE00"
	$"FDCE 0300 00CE 00FB CE03 00CE 0000 FECE 0000 FECE 0000 FACE FE00 FECE 0300 CE00"
	$"00FE CE00 00FE CE00 00FE CEFE 00FE CE03 00CE 0000 FDCE FE00 FACE 0000 FECE 0300"
	$"CE00 00FE CE00 00FE CE01 00CE FE00 FBCE 0700 CE00 00CE CE00 00FD CEFE 00FD CE00"
	$"00FE CE00 00F9 CE03 00CE 0000 FCCE FE00 FECE FE00 EDCE 0420 EFCE 0000 FECE 0E00"
	$"CECE 0000 CECE 00CE CE00 CECE 0000 FBCE 0200 CE00 FECE 0200 CE00 FECE FE00 F8CE"
	$"0000 FECE 0200 CE00 FECE 1400 CECE 00CE CE00 00CE CE00 CECE 00CE CE00 00CE CE00"
	$"FECE 0200 CE00 FECE 0000 FECE 0200 CE00 FECE 0000 F7CE 0000 FBCE 0000 FECE 0D00"
	$"CECE 00CE CE00 00CE CE00 CECE 00FE CE00 00FB CE0B 0000 CECE 0000 CECE 00CE CE00"
	$"FECE 0300 CECE 00FE CE00 00FB CE07 0000 CECE 00CE CE00 FECE 0000 FBCE 0700 CECE"
	$"0000 CECE 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0000 FBCE 0000 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0700 CECE 00CE CE00 00FB CE07 0000 CECE 00CE"
	$"CE00 FECE 0000 FBCE 0000 FECE 0A00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00FE"
	$"CE0A 00CE CE00 00CE CE00 CECE 00FE CE00 00FB CE00 00FE CE07 0000 CECE 00CE CE00"
	$"FECE 0300 CECE 00FA CE0B 0000 CECE 0000 CECE 00CE CE00 FECE 0000 FECE 0000 FECE"
	$"0000 F9CE 0400 00CE CE00 FECE 0000 FECE 0000 FECE 0000 ECCE EFCF 0000 FECF 0E00"
	$"CFCF 0000 CFCF 00CF CF00 CFCF 0000 FBCF 0200 CF00 FECF 0200 CF00 FECF FE00 F8CF"
	$"0000 FECF 0200 CF00 FECF 1400 CFCF 00CF CF00 00CF CF00 CFCF 00CF CF00 00CF CF00"
	$"FECF 0200 CF00 FECF 0000 FECF 0200 CF00 FECF 0000 F7CF 0000 FBCF 0000 FECF 0D00"
	$"CFCF 00CF CF00 00CF CF00 CFCF 00FE CF00 00FB CF0B 0000 CFCF 0000 CFCF 00CF CF00"
	$"FECF 0300 CFCF 00FE CF00 00FB CF07 0000 CFCF 00CF CF00 FECF 0000 FBCF 0700 CFCF"
	$"0000 CFCF 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0000 FBCF 0000 FECF"
	$"0300 CFCF 00FE CF03 00CF CF00 FECF 0700 CFCF 00CF CF00 00FB CF07 0000 CFCF 00CF"
	$"CF00 FECF 0000 FBCF 0000 FECF 0A00 CFCF 0000 CFCF 00CF CF00 FECF 0300 CFCF 00FE"
	$"CF0A 00CF CF00 00CF CF00 CFCF 00FE CF00 00FB CF00 00FE CF07 0000 CFCF 00CF CF00"
	$"FECF 0300 CFCF 00FA CF0B 0000 CFCF 0000 CFCF 00CF CF00 FECF 0000 FECF 0000 FECF"
	$"0000 F9CF 0400 00CF CF00 FECF 0000 FECF 0000 FECF 0000 ECCF EFCE 0000 FECE 0E00"
	$"CECE 0000 CECE 00CE CE00 CECE 0000 FBCE 0200 CE00 FECE 0200 CE00 FECE FE00 F8CE"
	$"0000 FECE 0200 CE00 FECE 1400 CECE 00CE CE00 00CE CE00 CECE 00CE CE00 00CE CE00"
	$"FECE 0200 CE00 FECE 0000 FECE 0200 CE00 FECE 0000 F7CE 0000 FBCE 0000 FECE 0D00"
	$"CECE 00CE CE00 00CE CE00 CECE 00FE CE00 00FB CE0B 0000 CECE 0000 CECE 00CE CE00"
	$"FECE 0300 CECE 00FE CE00 00FB CE07 0000 CECE 00CE CE00 FECE 0000 FBCE 0700 CECE"
	$"0000 CECE 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0000 FBCE 0000 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0700 CECE 00CE CE00 00FB CE07 0000 CECE 00CE"
	$"CE00 FECE 0000 FBCE 0000 FECE 0A00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00FE"
	$"CE0A 00CE CE00 00CE CE00 CECE 00FE CE00 00FB CE00 00FE CE07 0000 CECE 00CE CE00"
	$"FECE 0300 CECE 00FA CE0B 0000 CECE 0000 CECE 00CE CE00 FECE 0000 FECE 0000 FECE"
	$"0000 F9CE 0400 00CE CE00 FECE 0000 FECE 0000 FECE 0000 ECCE 03D2 EBCE 0300 CECE"
	$"00FE CE03 00CE CE00 FECE 0000 FBCE 0800 CECE 00CE 00CE CE00 FBCE 0100 00F9 CE02"
	$"00CE 00FE CE02 00CE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0C00 CECE 00CE 00CE 00CE 00CE CE00 F3CE 0000 FBCE 0000 FECE 0300 CECE 00FE CE06"
	$"00CE CE00 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE00 00FB CE00 00FE CE02 00CE"
	$"00FA CE00 00FE CE03 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE CE00 00FE CE03 00CE"
	$"CE00 FECE 0300 CECE 00FE CE02 00CE 00FA CE00 00FE CE03 00CE CE00 FBCE 0000 FECE"
	$"0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE02 00CE 00F6 CE03 00CE CE00 FECE"
	$"0000 FECE 0200 CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE"
	$"0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0000"
	$"FBCE 0000 FDCE 0200 CE00 F8CE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 ECCE"
	$"EBCF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0800 CFCF 00CF 00CF CF00 FBCF"
	$"0100 00F9 CF02 00CF 00FE CF02 00CF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03"
	$"00CF CF00 FECF 0C00 CFCF 00CF 00CF 00CF 00CF CF00 F3CF 0000 FBCF 0000 FECF 0300"
	$"CFCF 00FE CF06 00CF CF00 CFCF 00FE CF00 00FB CF00 00FE CF00 00FE CF00 00FB CF00"
	$"00FE CF02 00CF 00FA CF00 00FE CF03 00CF CF00 FECF 0000 FBCF 0300 CFCF 00FE CF00"
	$"00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF02 00CF 00FA CF00 00FE CF03 00CF CF00"
	$"FBCF 0000 FECF 0300 CFCF 00FE CF00 00FB CF00 00FE CF00 00FE CF02 00CF 00F6 CF03"
	$"00CF CF00 FECF 0000 FECF 0200 CF00 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0000 FBCF 0000 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FACF 0000 FECF"
	$"0000 FECF 0000 FBCF 0000 FDCF 0200 CF00 F8CF 0000 FECF 0000 FECF 0000 FECF 0000"
	$"FECF 0000 ECCF EBCE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0800 CECE 00CE"
	$"00CE CE00 FBCE 0100 00F9 CE02 00CE 00FE CE02 00CE 00FE CE03 00CE CE00 FECE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE 0C00 CECE 00CE 00CE 00CE 00CE CE00 F3CE 0000 FBCE"
	$"0000 FECE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE00 00FB CE00 00FE CE00 00FE"
	$"CE00 00FB CE00 00FE CE02 00CE 00FA CE00 00FE CE03 00CE CE00 FECE 0000 FBCE 0300"
	$"CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE02 00CE 00FA CE00 00FE"
	$"CE03 00CE CE00 FBCE 0000 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE02"
	$"00CE 00F6 CE03 00CE CE00 FECE 0000 FECE 0200 CE00 FECE 0000 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FACE 0000 FECE 0000 FECE 0000 FBCE 0000 FDCE 0200 CE00 F8CE 0000 FECE 0000 FECE"
	$"0000 FECE 0000 FECE 0000 ECCE 03A8 EECE FD00 02CE CE00 FECE 0300 CECE 00FE CE00"
	$"00FB CE08 00CE CE00 CE00 CECE 00F9 CE00 00FA CE02 00CE 00FE CE02 00CE 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0900 CECE 00CE 00CE 00CE 00FE"
	$"CEFE 00F6 CE00 00FB CEFC 0002 CECE 00FE CE06 00CE CE00 CECE 00FE CE00 00FB CE00"
	$"00FE CE00 00FE CE00 00FE CEFD 00FE CE02 00CE 00FA CE00 00FE CE02 00CE CEFC 00FB"
	$"CE03 00CE CE00 FECE FC00 01CE CEFC 0002 CECE 00FE CE02 00CE 00FA CE00 00FE CE00"
	$"00FE CEFE 00FE CEFC 0002 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE02 00CE 00F9"
	$"CEFD 0002 CECE 00FE CE00 00FE CE02 00CE 00FE CE00 00FE CE03 00CE CE00 FECE 0200"
	$"CECE FC00 FBCE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FACE 0000 FECE"
	$"0000 FECE 0000 FECE FD00 FDCE 0200 CE00 F8CE 0000 FECE 0000 FECE 0000 FECE 0000"
	$"FECE 0000 ECCE EECF FD00 02CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF08 00CF CF00"
	$"CF00 CFCF 00F9 CF00 00FA CF02 00CF 00FE CF02 00CF 00FE CF03 00CF CF00 FECF 0300"
	$"CFCF 00FE CF03 00CF CF00 FECF 0900 CFCF 00CF 00CF 00CF 00FE CFFE 00F6 CF00 00FB"
	$"CFFC 0002 CFCF 00FE CF06 00CF CF00 CFCF 00FE CF00 00FB CF00 00FE CF00 00FE CF00"
	$"00FE CFFD 00FE CF02 00CF 00FA CF00 00FE CF02 00CF CFFC 00FB CF03 00CF CF00 FECF"
	$"FC00 01CF CFFC 0002 CFCF 00FE CF02 00CF 00FA CF00 00FE CF00 00FE CFFE 00FE CFFC"
	$"0002 CFCF 00FE CF00 00FB CF00 00FE CF00 00FE CF02 00CF 00F9 CFFD 0002 CFCF 00FE"
	$"CF00 00FE CF02 00CF 00FE CF00 00FE CF03 00CF CF00 FECF 0200 CFCF FC00 FBCF 0000"
	$"FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FACF 0000 FECF 0000 FECF 0000 FECF"
	$"FD00 FDCF 0200 CF00 F8CF 0000 FECF 0000 FECF 0000 FECF 0000 FECF 0000 ECCF EECE"
	$"FD00 02CE CE00 FECE 0300 CECE 00FE CE00 00FB CE08 00CE CE00 CE00 CECE 00F9 CE00"
	$"00FA CE02 00CE 00FE CE02 00CE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE 0900 CECE 00CE 00CE 00CE 00FE CEFE 00F6 CE00 00FB CEFC 0002 CECE 00FE"
	$"CE06 00CE CE00 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE00 00FE CEFD 00FE CE02"
	$"00CE 00FA CE00 00FE CE02 00CE CEFC 00FB CE03 00CE CE00 FECE FC00 01CE CEFC 0002"
	$"CECE 00FE CE02 00CE 00FA CE00 00FE CE00 00FE CEFE 00FE CEFC 0002 CECE 00FE CE00"
	$"00FB CE00 00FE CE00 00FE CE02 00CE 00F9 CEFD 0002 CECE 00FE CE00 00FE CE02 00CE"
	$"00FE CE00 00FE CE03 00CE CE00 FECE 0200 CECE FC00 FBCE 0000 FECE 0000 FECE 0300"
	$"CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0000 FECE FD00 FDCE 0200 CE00"
	$"F8CE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000 ECCE 03C9 EFCE 0000 FECE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0B00 CECE 00CE 00CE CE00 CECE 00FC CE00"
	$"00FA CE02 00CE 00FE CE02 00CE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE 0900 CECE 00CE 00CE 00CE 00FB CE00 00F7 CE00 00FB CE00 00FB CE00 00FE"
	$"CE06 00CE CE00 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0200 CE00 FACE 0000 FECE 0300 CECE 00F7 CE03 00CE CE00 FECE 0000 FBCE 0000"
	$"FBCE 0000 FECE 0200 CE00 FACE 0000 FECE 0000 FBCE 0300 CECE 00FB CE00 00FE CE00"
	$"00FB CE00 00FE CE00 00FE CE02 00CE 00FA CE00 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0200 CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 F7CE 0000 FECE 0000 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00FE CE00 00FD"
	$"CE02 00CE 00F8 CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00EC CEEF CF00 00FE"
	$"CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF0B 00CF CF00 CF00 CFCF 00CF CF00"
	$"FCCF 0000 FACF 0200 CF00 FECF 0200 CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF"
	$"0300 CFCF 00FE CF09 00CF CF00 CF00 CF00 CF00 FBCF 0000 F7CF 0000 FBCF 0000 FBCF"
	$"0000 FECF 0600 CFCF 00CF CF00 FECF 0000 FBCF 0000 FECF 0000 FECF 0300 CFCF 00FE"
	$"CF00 00FE CF02 00CF 00FA CF00 00FE CF03 00CF CF00 F7CF 0300 CFCF 00FE CF00 00FB"
	$"CF00 00FB CF00 00FE CF02 00CF 00FA CF00 00FE CF00 00FB CF03 00CF CF00 FBCF 0000"
	$"FECF 0000 FBCF 0000 FECF 0000 FECF 0200 CF00 FACF 0000 FECF 0300 CFCF 00FE CF00"
	$"00FE CF02 00CF 00FE CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00F7 CF00 00FE CF00"
	$"00FE CF03 00CF CF00 FECF 0300 CFCF 00FA CF00 00FE CF00 00FE CF03 00CF CF00 FECF"
	$"0000 FDCF 0200 CF00 F8CF 0000 FECF 0000 FECF 0000 FECF 0000 FECF 0000 ECCF EFCE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0B00 CECE 00CE 00CE CE00"
	$"CECE 00FC CE00 00FA CE02 00CE 00FE CE02 00CE 00FE CE03 00CE CE00 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 FECE 0900 CECE 00CE 00CE 00CE 00FB CE00 00F7 CE00 00FB CE00"
	$"00FB CE00 00FE CE06 00CE CE00 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE"
	$"CE00 FECE 0000 FECE 0200 CE00 FACE 0000 FECE 0300 CECE 00F7 CE03 00CE CE00 FECE"
	$"0000 FBCE 0000 FBCE 0000 FECE 0200 CE00 FACE 0000 FECE 0000 FBCE 0300 CECE 00FB"
	$"CE00 00FE CE00 00FB CE00 00FE CE00 00FE CE02 00CE 00FA CE00 00FE CE03 00CE CE00"
	$"FECE 0000 FECE 0200 CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 F7CE 0000"
	$"FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE"
	$"00FE CE00 00FD CE02 00CE 00F8 CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00EC"
	$"CE03 E1EF CE07 00CE CE00 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00"
	$"00FE CE03 00CE CE00 FCCE 0000 F9CE 0000 FCCE 0000 FDCE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00F7 CE00"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 F7CE 0000 FECE 0000 FECE"
	$"0700 CECE 00CE CE00 00FD CE00 00F9 CE00 00FE CE03 00CE CE00 FECE 0000 FBCE 0300"
	$"CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FD CE00 00F9 CE00 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FDCE"
	$"0000 F9CE 0700 CECE 0000 CECE 00FE CE00 00FD CE00 00FD CE00 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE"
	$"00FA CE00 00FE CE00 00FE CE07 00CE CE00 CECE 0000 FCCE 0000 F7CE 0000 FECE 0000"
	$"FECE 0000 FECE 0000 FECE 0000 ECCE EFCF 0700 CFCF 0000 CFCF 00FE CF03 00CF CF00"
	$"FECF 0000 FBCF 0000 FECF 0000 FECF 0300 CFCF 00FC CF00 00F9 CF00 00FC CF00 00FD"
	$"CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0000"
	$"FECF 0000 FECF 0000 F7CF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF06 00CF CF00 CFCF"
	$"00F7 CF00 00FE CF00 00FE CF07 00CF CF00 CFCF 0000 FDCF 0000 F9CF 0000 FECF 0300"
	$"CFCF 00FE CF00 00FB CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FDCF 0000 F9CF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00"
	$"00FB CF00 00FE CF00 00FD CF00 00F9 CF07 00CF CF00 00CF CF00 FECF 0000 FDCF 0000"
	$"FDCF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF 0000 FECF"
	$"0300 CFCF 00FE CF03 00CF CF00 FACF 0000 FECF 0000 FECF 0700 CFCF 00CF CF00 00FC"
	$"CF00 00F7 CF00 00FE CF00 00FE CF00 00FE CF00 00FE CF00 00EC CFEF CE07 00CE CE00"
	$"00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FCCE"
	$"0000 F9CE 0000 FCCE 0000 FDCE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE"
	$"CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00F7 CE00 00FB CE00 00FE CE03 00CE"
	$"CE00 FECE 0600 CECE 00CE CE00 F7CE 0000 FECE 0000 FECE 0700 CECE 00CE CE00 00FD"
	$"CE00 00F9 CE00 00FE CE03 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE CE00 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FD CE00 00F9 CE00 00FE CE03 00CE CE00 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FDCE 0000 F9CE 0700 CECE 0000"
	$"CECE 00FE CE00 00FD CE00 00FD CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00"
	$"00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FA CE00 00FE CE00 00FE"
	$"CE07 00CE CE00 CECE 0000 FCCE 0000 F7CE 0000 FECE 0000 FECE 0000 FECE 0000 FECE"
	$"0000 ECCE 0330 EECE 0600 00CE 00CE CE00 FECE 0000 FECE FD00 FBCE 0000 FECE 0000"
	$"FECE 0000 FECE FC00 F8CE 0000 FCCE 0000 FDCE 0300 CECE 00FE CE00 00FE CEFD 00FE"
	$"CEFE 00FD CE00 00FE CE00 00FD CEFE 00FE CE00 00FA CEFB 0001 CECE FE00 FDCE FD00"
	$"09CE CE00 CECE 0000 CECE 00FB CE00 00FE CE00 00FE CE00 00FE CE03 0000 CE00 FDCE"
	$"0000 F9CE FD00 FDCE FE00 FACE 0300 CECE 00FD CEFE 00FD CEFE 00FE CE00 00FD CE00"
	$"00F8 CEFD 00FE CEFE 00FD CEFE 00FD CEFD 00FB CEFD 00FC CE00 00F8 CE06 0000 CE00"
	$"CECE 00FE CE00 00FD CE00 00FC CEFE 00FE CE00 00FE CE00 00FE CEFE 00FA CE00 00FE"
	$"CEFD 00FD CEFD 0003 CECE 0000 FBCE 0000 FECE 0000 FECE 0000 FECE 0300 00CE 00FC"
	$"CE00 00F7 CE00 00FE CE00 00FD CEFE 00FD CE01 0000 EDCE EECF 0600 00CF 00CF CF00"
	$"FECF 0000 FECF FD00 FBCF 0000 FECF 0000 FECF 0000 FECF FC00 F8CF 0000 FCCF 0000"
	$"FDCF 0300 CFCF 00FE CF00 00FE CFFD 00FE CFFE 00FD CF00 00FE CF00 00FD CFFE 00FE"
	$"CF00 00FA CFFB 0001 CFCF FE00 FDCF FD00 09CF CF00 CFCF 0000 CFCF 00FB CF00 00FE"
	$"CF00 00FE CF00 00FE CF03 0000 CF00 FDCF 0000 F9CF FD00 FDCF FE00 FACF 0300 CFCF"
	$"00FD CFFE 00FD CFFE 00FE CF00 00FD CF00 00F8 CFFD 00FE CFFE 00FD CFFE 00FD CFFD"
	$"00FB CFFD 00FC CF00 00F8 CF06 0000 CF00 CFCF 00FE CF00 00FD CF00 00FC CFFE 00FE"
	$"CF00 00FE CF00 00FE CFFE 00FA CF00 00FE CFFD 00FD CFFD 0003 CFCF 0000 FBCF 0000"
	$"FECF 0000 FECF 0000 FECF 0300 00CF 00FC CF00 00F7 CF00 00FE CF00 00FD CFFE 00FD"
	$"CF01 0000 EDCF EECE 0600 00CE 00CE CE00 FECE 0000 FECE FD00 FBCE 0000 FECE 0000"
	$"FECE 0000 FECE FC00 F8CE 0000 FCCE 0000 FDCE 0300 CECE 00FE CE00 00FE CEFD 00FE"
	$"CEFE 00FD CE00 00FE CE00 00FD CEFE 00FE CE00 00FA CEFB 0001 CECE FE00 FDCE FD00"
	$"09CE CE00 CECE 0000 CECE 00FB CE00 00FE CE00 00FE CE00 00FE CE03 0000 CE00 FDCE"
	$"0000 F9CE FD00 FDCE FE00 FACE 0300 CECE 00FD CEFE 00FD CEFE 00FE CE00 00FD CE00"
	$"00F8 CEFD 00FE CEFE 00FD CEFE 00FD CEFD 00FB CEFD 00FC CE00 00F8 CE06 0000 CE00"
	$"CECE 00FE CE00 00FD CE00 00FC CEFE 00FE CE00 00FE CE00 00FE CEFE 00FA CE00 00FE"
	$"CEFD 00FD CEFD 0003 CECE 0000 FBCE 0000 FECE 0000 FECE 0000 FECE 0300 00CE 00FC"
	$"CE00 00F7 CE00 00FE CE00 00FD CEFE 00FD CE01 0000 EDCE 0054 81CE CACE 0000 CDCE"
	$"0000 D0CE 0000 E9CE 0000 E3CE 0000 D4CE 0000 D1CE 81CF CACF 0000 CDCF 0000 D0CF"
	$"0000 E9CF 0000 E3CF 0000 D4CF 0000 D1CF 81CE CACE 0000 CDCE 0000 D0CE 0000 E9CE"
	$"0000 E3CE 0000 D4CE 0000 D1CE 0054 81CE CACE 0000 CDCE 0000 D0CE 0000 E9CE 0000"
	$"E3CE 0000 D4CE 0000 D1CE 81CF CACF 0000 CDCF 0000 D0CF 0000 E9CF 0000 E3CF 0000"
	$"D4CF 0000 D1CF 81CE CACE 0000 CDCE 0000 D0CE 0000 E9CE 0000 E3CE 0000 D4CE 0000"
	$"D1CE 0063 81CE CCCE 0100 00CE CE01 0000 D1CE 0100 00EA CE01 0000 E1CE 0000 D7CE"
	$"0100 00D0 CE81 CFCC CF01 0000 CECF 0100 00D1 CF01 0000 EACF 0100 00E1 CF00 00D7"
	$"CF01 0000 D0CF 81CE CCCE 0100 00CE CE01 0000 D1CE 0100 00EA CE01 0000 E1CE 0000"
	$"D7CE 0100 00D0 CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC"
	$"CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81"
	$"CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 F0EF CE00 00E1 CE03 00CE"
	$"CE00 F0CE 0300 CECE 00E5 CE00 00F2 CE00 00FB CE00 00C9 CE00 00FE CEFE 00F4 CE03"
	$"00CE CE00 D7CE 0100 00E6 CEFC 00F0 CE00 00FB CE00 00EF CEFC 00F7 CE00 00F4 CE00"
	$"00E8 CE00 00CB CEEF CF00 00E1 CF03 00CF CF00 F0CF 0300 CFCF 00E5 CF00 00F2 CF00"
	$"00FB CF00 00C9 CF00 00FE CFFE 00F4 CF03 00CF CF00 D7CF 0100 00E6 CFFC 00F0 CF00"
	$"00FB CF00 00EF CFFC 00F7 CF00 00F4 CF00 00E8 CF00 00CB CFEF CE00 00E1 CE03 00CE"
	$"CE00 F0CE 0300 CECE 00E5 CE00 00F2 CE00 00FB CE00 00C9 CE00 00FE CEFE 00F4 CE03"
	$"00CE CE00 D7CE 0100 00E6 CEFC 00F0 CE00 00FB CE00 00EF CEFC 00F7 CE00 00F4 CE00"
	$"00E8 CE00 00CB CE01 02EF CE00 00E1 CE00 00F5 CE00 00F7 CE00 00F4 CE00 00F3 CE00"
	$"00EF CE00 00FE CE00 00ED CE00 00DB CE00 00F1 CE00 00D5 CE00 00E5 CE00 00FC CE00"
	$"00F1 CE00 00F1 CE00 00FA CE00 00FC CE00 00F8 CE00 00F8 CE00 00E3 CE00 00CC CEEF"
	$"CF00 00E1 CF00 00F5 CF00 00F7 CF00 00F4 CF00 00F3 CF00 00EF CF00 00FE CF00 00ED"
	$"CF00 00DB CF00 00F1 CF00 00D5 CF00 00E5 CF00 00FC CF00 00F1 CF00 00F1 CF00 00FA"
	$"CF00 00FC CF00 00F8 CF00 00F8 CF00 00E3 CF00 00CC CFEF CE00 00E1 CE00 00F5 CE00"
	$"00F7 CE00 00F4 CE00 00F3 CE00 00EF CE00 00FE CE00 00ED CE00 00DB CE00 00F1 CE00"
	$"00D5 CE00 00E5 CE00 00FC CE00 00F1 CE00 00F1 CE00 00FA CE00 00FC CE00 00F8 CE00"
	$"00F8 CE00 00E3 CE00 00CC CE01 02EF CE00 00E1 CE00 00F5 CE00 00F7 CE00 00F4 CE00"
	$"00F3 CE00 00EF CE00 00FE CE00 00ED CE00 00DB CE00 00F1 CE00 00D5 CE00 00E5 CE00"
	$"00FC CE00 00F1 CE00 00F1 CE00 00FA CE00 00FC CE00 00F8 CE00 00F8 CE00 00E3 CE00"
	$"00CC CEEF CF00 00E1 CF00 00F5 CF00 00F7 CF00 00F4 CF00 00F3 CF00 00EF CF00 00FE"
	$"CF00 00ED CF00 00DB CF00 00F1 CF00 00D5 CF00 00E5 CF00 00FC CF00 00F1 CF00 00F1"
	$"CF00 00FA CF00 00FC CF00 00F8 CF00 00F8 CF00 00E3 CF00 00CC CFEF CE00 00E1 CE00"
	$"00F5 CE00 00F7 CE00 00F4 CE00 00F3 CE00 00EF CE00 00FE CE00 00ED CE00 00DB CE00"
	$"00F1 CE00 00D5 CE00 00E5 CE00 00FC CE00 00F1 CE00 00F1 CE00 00FA CE00 00FC CE00"
	$"00F8 CE00 00F8 CE00 00E3 CE00 00CC CE03 54EF CE03 00CE 0000 FDCE FE00 FACE 0400"
	$"CE00 CECE FE00 FDCE 0600 00CE 00CE CE00 FECE FE00 01CE CEFE 000C CECE 00CE 00CE"
	$"00CE CE00 CE00 00FE CE00 00FE CE01 00CE FE00 FECE FE00 FDCE 0300 00CE 00FC CE00"
	$"00FE CE00 00FE CE03 00CE 00CE FE00 05CE CE00 CE00 00FD CEFE 00FE CE00 00FE CE01"
	$"00CE FE00 FACE FE00 FECE 0300 CE00 00FD CEFE 00FD CEFE 00FE CE01 00CE FE00 01CE"
	$"00FE CEFE 00FA CE03 00CE CE00 FECE FE00 FDCE FE00 FECE 0300 CE00 00FD CEFE 00FD"
	$"CEFE 00FB CEFE 0005 CE00 CE00 CECE FE00 FECE 0700 CE00 00CE CE00 00FA CE00 00F8"
	$"CEFE 00FE CE03 00CE 0000 FECE 0300 CE00 00FE CE00 00FE CEFE 0001 CECE FE00 FBCE"
	$"0000 F8CE FE00 FECE 0300 CECE 00FE CE01 00CE FE00 02CE CE00 FECE FE00 FDCE 0300"
	$"CE00 00FC CEFE 00FC CE00 00CD CEEF CF03 00CF 0000 FDCF FE00 FACF 0400 CF00 CFCF"
	$"FE00 FDCF 0600 00CF 00CF CF00 FECF FE00 01CF CFFE 000C CFCF 00CF 00CF 00CF CF00"
	$"CF00 00FE CF00 00FE CF01 00CF FE00 FECF FE00 FDCF 0300 00CF 00FC CF00 00FE CF00"
	$"00FE CF03 00CF 00CF FE00 05CF CF00 CF00 00FD CFFE 00FE CF00 00FE CF01 00CF FE00"
	$"FACF FE00 FECF 0300 CF00 00FD CFFE 00FD CFFE 00FE CF01 00CF FE00 01CF 00FE CFFE"
	$"00FA CF03 00CF CF00 FECF FE00 FDCF FE00 FECF 0300 CF00 00FD CFFE 00FD CFFE 00FB"
	$"CFFE 0005 CF00 CF00 CFCF FE00 FECF 0700 CF00 00CF CF00 00FA CF00 00F8 CFFE 00FE"
	$"CF03 00CF 0000 FECF 0300 CF00 00FE CF00 00FE CFFE 0001 CFCF FE00 FBCF 0000 F8CF"
	$"FE00 FECF 0300 CFCF 00FE CF01 00CF FE00 02CF CF00 FECF FE00 FDCF 0300 CF00 00FC"
	$"CFFE 00FC CF00 00CD CFEF CE03 00CE 0000 FDCE FE00 FACE 0400 CE00 CECE FE00 FDCE"
	$"0600 00CE 00CE CE00 FECE FE00 01CE CEFE 000C CECE 00CE 00CE 00CE CE00 CE00 00FE"
	$"CE00 00FE CE01 00CE FE00 FECE FE00 FDCE 0300 00CE 00FC CE00 00FE CE00 00FE CE03"
	$"00CE 00CE FE00 05CE CE00 CE00 00FD CEFE 00FE CE00 00FE CE01 00CE FE00 FACE FE00"
	$"FECE 0300 CE00 00FD CEFE 00FD CEFE 00FE CE01 00CE FE00 01CE 00FE CEFE 00FA CE03"
	$"00CE CE00 FECE FE00 FDCE FE00 FECE 0300 CE00 00FD CEFE 00FD CEFE 00FB CEFE 0005"
	$"CE00 CE00 CECE FE00 FECE 0700 CE00 00CE CE00 00FA CE00 00F8 CEFE 00FE CE03 00CE"
	$"0000 FECE 0300 CE00 00FE CE00 00FE CEFE 0001 CECE FE00 FBCE 0000 F8CE FE00 FECE"
	$"0300 CECE 00FE CE01 00CE FE00 02CE CE00 FECE FE00 FDCE 0300 CE00 00FC CEFE 00FC"
	$"CE00 00CD CE03 F9EF CE07 0000 CECE 00CE CE00 FECE 0000 FBCE 0400 00CE CE00 FECE"
	$"0D00 CECE 00CE CE00 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0E00 00CE CE00 CECE"
	$"0000 CECE 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE07 00CE CE00 CECE 0000 FCCE"
	$"0000 FECE 0000 FECE 0500 CE00 CECE 00FE CE07 0000 CECE 00CE CE00 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 FACE 0000 FECE 0A00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE"
	$"00FE CE0C 00CE CE00 CECE 00CE CE00 CECE 00FE CE00 00FB CE06 00CE CE00 CECE 00FE"
	$"CE03 00CE CE00 FECE 0A00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00FE CE00 00FB"
	$"CE07 00CE CE00 00CE CE00 FECE 0B00 CECE 0000 CECE 0000 CECE 00FA CEFE 00FC CE00"
	$"00FE CE14 00CE CE00 00CE CE00 CECE 0000 CECE 00CE CE00 CECE 00FE CE03 00CE CE00"
	$"F9CE FE00 FCCE 0000 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE 0000 FECE 0400 00CE CE00 FECE 0000 FECE 0000 FDCE 0000 CDCE EFCF 0700 00CF"
	$"CF00 CFCF 00FE CF00 00FB CF04 0000 CFCF 00FE CF0D 00CF CF00 CFCF 0000 CFCF 00CF"
	$"CF00 FECF 0300 CFCF 00FE CF0E 0000 CFCF 00CF CF00 00CF CF00 CFCF 00FE CF03 00CF"
	$"CF00 FECF 0000 FECF 0700 CFCF 00CF CF00 00FC CF00 00FE CF00 00FE CF05 00CF 00CF"
	$"CF00 FECF 0700 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FA CF00 00FE"
	$"CF0A 00CF CF00 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0C00 CFCF 00CF CF00 CFCF"
	$"00CF CF00 FECF 0000 FBCF 0600 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF0A 00CF CF00"
	$"00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0700 CFCF 0000 CFCF 00FE CF0B"
	$"00CF CF00 00CF CF00 00CF CF00 FACF FE00 FCCF 0000 FECF 1400 CFCF 0000 CFCF 00CF"
	$"CF00 00CF CF00 CFCF 00CF CF00 FECF 0300 CFCF 00F9 CFFE 00FC CF00 00FE CF06 00CF"
	$"CF00 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FE CF04 0000 CFCF 00FE"
	$"CF00 00FE CF00 00FD CF00 00CD CFEF CE07 0000 CECE 00CE CE00 FECE 0000 FBCE 0400"
	$"00CE CE00 FECE 0D00 CECE 00CE CE00 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0E00"
	$"00CE CE00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE07 00CE CE00"
	$"CECE 0000 FCCE 0000 FECE 0000 FECE 0500 CE00 CECE 00FE CE07 0000 CECE 00CE CE00"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FACE 0000 FECE 0A00 CECE 0000 CECE 00CE CE00"
	$"FECE 0300 CECE 00FE CE0C 00CE CE00 CECE 00CE CE00 CECE 00FE CE00 00FB CE06 00CE"
	$"CE00 CECE 00FE CE03 00CE CE00 FECE 0A00 CECE 0000 CECE 00CE CE00 FECE 0300 CECE"
	$"00FE CE00 00FB CE07 00CE CE00 00CE CE00 FECE 0B00 CECE 0000 CECE 0000 CECE 00FA"
	$"CEFE 00FC CE00 00FE CE14 00CE CE00 00CE CE00 CECE 0000 CECE 00CE CE00 CECE 00FE"
	$"CE03 00CE CE00 F9CE FE00 FCCE 0000 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 FECE 0400 00CE CE00 FECE 0000 FECE 0000 FDCE 0000 CDCE"
	$"03AE EFCE 0000 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00"
	$"FECE 0600 CECE 00CE CE00 FBCE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FBCE 0C00 CE00 CE00 CE00"
	$"CECE 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FA"
	$"CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FB CE09 00CE CE00 CECE 00CE"
	$"CE00 F7CE 0600 CECE 00CE CE00 FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FBCE"
	$"0000 FECE 0000 FBCE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000"
	$"F7CE 0100 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE06 00CE CE00 CECE"
	$"00FB CE00 00F6 CE01 0000 FECE 0000 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 FECE 0000 FECE 0000 FECE 0000 F9CE 0000 CDCE EFCF 0000"
	$"FECF 0300 CFCF 00FE CF00 00FB CF00 00FE CF00 00FE CF03 00CF CF00 FECF 0600 CFCF"
	$"00CF CF00 FBCF 0000 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF"
	$"00FE CF00 00FE CF03 00CF CF00 FECF 0000 FBCF 0C00 CF00 CF00 CF00 CFCF 00CF CF00"
	$"FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FA CF00 00FB CF00"
	$"00FE CF03 00CF CF00 FECF 0300 CFCF 00FB CF09 00CF CF00 CFCF 00CF CF00 F7CF 0600"
	$"CFCF 00CF CF00 FBCF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FBCF 0000 FECF 0000"
	$"FBCF 0300 CFCF 00FE CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0000 F7CF 0100 00FE"
	$"CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF06 00CF CF00 CFCF 00FB CF00 00F6"
	$"CF01 0000 FECF 0000 FECF 0600 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0000 FECF 0000 FECF 0000 FECF 0000 F9CF 0000 CDCF EFCE 0000 FECE 0300 CECE"
	$"00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE"
	$"0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE"
	$"CE03 00CE CE00 FECE 0000 FBCE 0C00 CE00 CE00 CE00 CECE 00CE CE00 FECE 0000 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FA CE00 00FB CE00 00FE CE03 00CE"
	$"CE00 FECE 0300 CECE 00FB CE09 00CE CE00 CECE 00CE CE00 F7CE 0600 CECE 00CE CE00"
	$"FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FBCE 0000 FECE 0000 FBCE 0300 CECE"
	$"00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000 F7CE 0100 00FE CE00 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CE06 00CE CE00 CECE 00FB CE00 00F6 CE01 0000 FECE"
	$"0000 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0000 FECE 0000 FECE 0000 F9CE 0000 CDCE 0375 EFCE 0000 FECE 0200 CECE FC00 FBCE"
	$"0000 FECE FC00 02CE CE00 FECE 0300 CECE 00FE CEFE 00FE CE00 00FE CE00 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE FC00 02CE CE00 FECE 0000 FBCE"
	$"0C00 CE00 CE00 CE00 CECE 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00F9 CEFE 00FE CE00 00FE CE02 00CE CEFC 0002 CECE 00FB CE09 00CE"
	$"CE00 CECE 00CE CE00 F7CE 0600 CECE 00CE CE00 FBCE FC00 02CE CE00 FECE 0000 FECE"
	$"FE00 FECE FC00 FBCE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000"
	$"F5CE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE FE00"
	$"FECE 0000 F4CE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300"
	$"CECE 00FE CE00 00FE CE00 00FE CE00 00FD CEFE 00FC CE00 00CD CEEF CF00 00FE CF02"
	$"00CF CFFC 00FB CF00 00FE CFFC 0002 CFCF 00FE CF03 00CF CF00 FECF FE00 FECF 0000"
	$"FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CFFC 0002 CFCF"
	$"00FE CF00 00FB CF0C 00CF 00CF 00CF 00CF CF00 CFCF 00FE CF00 00FE CF03 00CF CF00"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 F9CF FE00 FECF 0000 FECF 0200 CFCF FC00 02CF"
	$"CF00 FBCF 0900 CFCF 00CF CF00 CFCF 00F7 CF06 00CF CF00 CFCF 00FB CFFC 0002 CFCF"
	$"00FE CF00 00FE CFFE 00FE CFFC 00FB CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE"
	$"CF00 00FE CF00 00F5 CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300"
	$"CFCF 00FE CFFE 00FE CF00 00F4 CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0300"
	$"CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0000 FDCF FE00 FCCF 0000 CDCF"
	$"EFCE 0000 FECE 0200 CECE FC00 FBCE 0000 FECE FC00 02CE CE00 FECE 0300 CECE 00FE"
	$"CEFE 00FE CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE FC00 02CE CE00 FECE 0000 FBCE 0C00 CE00 CE00 CE00 CECE 00CE CE00 FECE 0000"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00F9 CEFE 00FE CE00 00FE CE02"
	$"00CE CEFC 0002 CECE 00FB CE09 00CE CE00 CECE 00CE CE00 F7CE 0600 CECE 00CE CE00"
	$"FBCE FC00 02CE CE00 FECE 0000 FECE FE00 FECE FC00 FBCE 0300 CECE 00FE CE00 00FE"
	$"CE03 00CE CE00 FECE 0000 FECE 0000 F5CE 0300 CECE 00FE CE03 00CE CE00 FECE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE FE00 FECE 0000 F4CE 0300 CECE 00FE CE06 00CE CE00"
	$"CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FD CEFE"
	$"00FC CE00 00CD CE03 7BEF CE00 00FE CE03 00CE CE00 F7CE 0000 FECE 0000 FBCE 0000"
	$"FECE 0300 CECE 00FB CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FB CE0C 00CE 00CE 00CE 00CE CE00"
	$"CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 F6CE 0300"
	$"CECE 00FE CE03 00CE CE00 FBCE 0000 FBCE 0900 CECE 00CE CE00 CECE 00F7 CE06 00CE"
	$"CE00 CECE 00FB CE00 00FB CE00 00FE CE00 00FB CE03 00CE CE00 F7CE 0300 CECE 00FE"
	$"CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FBCE 0000 FCCE 0300 CECE 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FBCE 0300 CECE 00FA CE00 00FC CE03"
	$"00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 FECE 0000 FACE 0000 FDCE 0000 CDCE EFCF 0000 FECF 0300 CFCF 00F7 CF00"
	$"00FE CF00 00FB CF00 00FE CF03 00CF CF00 FBCF 0300 CFCF 00FE CF00 00FE CF03 00CF"
	$"CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF 0000 FBCF 0C00"
	$"CF00 CF00 CF00 CFCF 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF"
	$"0300 CFCF 00F6 CF03 00CF CF00 FECF 0300 CFCF 00FB CF00 00FB CF09 00CF CF00 CFCF"
	$"00CF CF00 F7CF 0600 CFCF 00CF CF00 FBCF 0000 FBCF 0000 FECF 0000 FBCF 0300 CFCF"
	$"00F7 CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF00 00FE CF00 00FB CF00 00FC"
	$"CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FB CF03 00CF"
	$"CF00 FACF 0000 FCCF 0300 CFCF 00FE CF06 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF"
	$"0300 CFCF 00FE CF00 00FE CF00 00FE CF00 00FA CF00 00FD CF00 00CD CFEF CE00 00FE"
	$"CE03 00CE CE00 F7CE 0000 FECE 0000 FBCE 0000 FECE 0300 CECE 00FB CE03 00CE CE00"
	$"FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00"
	$"00FE CE00 00FB CE0C 00CE 00CE 00CE 00CE CE00 CECE 00FE CE00 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 F6CE 0300 CECE 00FE CE03 00CE CE00 FBCE 0000"
	$"FBCE 0900 CECE 00CE CE00 CECE 00F7 CE06 00CE CE00 CECE 00FB CE00 00FB CE00 00FE"
	$"CE00 00FB CE03 00CE CE00 F7CE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 FBCE 0000 FCCE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03"
	$"00CE CE00 FBCE 0300 CECE 00FA CE00 00FC CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FECE 0000 FACE 0000 FDCE"
	$"0000 CDCE 0405 EFCE 0000 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03"
	$"00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00 00FA CE00"
	$"00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0300 CECE 00FA CE00 00FE CE0A 00CE CE00 00CE CE00 CECE 00FE CE03 00CE CE00 FECE"
	$"0C00 CECE 00CE CE00 CECE 00CE CE00 FECE 0000 FBCE 0600 CECE 00CE CE00 FECE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0300"
	$"CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FBCE 0000 FCCE 0300 CECE"
	$"00FE CE0A 00CE CE00 00CE CE00 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00"
	$"FACE 0000 FCCE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300"
	$"CECE 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FD CE00 00CD CEEF CF00"
	$"00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF 0000 FECF 0300 CFCF 00FE CF06 00CF"
	$"CF00 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF"
	$"0300 CFCF 00FE CF00 00FE CF03 00CF CF00 FECF 0000 FACF 0000 FECF 0000 FECF 0300"
	$"CFCF 00FE CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FACF 0000"
	$"FECF 0A00 CFCF 0000 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF0C 00CF CF00 CFCF 00CF"
	$"CF00 CFCF 00FE CF00 00FB CF06 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF"
	$"00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF03 00CF CF00 FECF 0000 FECF"
	$"0300 CFCF 00FE CF00 00FE CF00 00FB CF00 00FC CF03 00CF CF00 FECF 0A00 CFCF 0000"
	$"CFCF 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0300 CFCF 00FA CF00 00FC CF03 00CF"
	$"CF00 FECF 0600 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF"
	$"0000 FECF 0000 FECF 0000 FECF 0000 FDCF 0000 CDCF EFCE 0000 FECE 0300 CECE 00FE"
	$"CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300"
	$"CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0300 CECE 00FE CE00 00FA CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FA CE00 00FE CE0A 00CE CE00 00CE"
	$"CE00 CECE 00FE CE03 00CE CE00 FECE 0C00 CECE 00CE CE00 CECE 00CE CE00 FECE 0000"
	$"FBCE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 FBCE 0000 FCCE 0300 CECE 00FE CE0A 00CE CE00 00CE CE00 CECE 00FE CE06"
	$"00CE CE00 CECE 00FE CE03 00CE CE00 FACE 0000 FCCE 0300 CECE 00FE CE06 00CE CE00"
	$"CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CE00"
	$"00FE CE00 00FD CE00 00CD CE03 27EF CEFD 00FD CEFE 00FA CE00 00FD CEFE 00FD CEFD"
	$"0002 CECE 00FE CEFE 00FE CE04 0000 CECE 00FE CE02 00CE CEFD 00FD CEFD 0003 CECE"
	$"0000 FECE FE00 FDCE FD00 FACE 0000 FECE 0000 FECE 0700 CECE 0000 CECE 00FE CE00"
	$"00FE CEFE 00FD CEFD 0003 CECE 0000 FACE FE00 FECE 0300 CE00 00FD CEFE 00FD CEFE"
	$"00FE CE06 00CE CE00 CECE 00FE CEFE 00FA CE03 00CE CE00 FECE FE00 FDCE FE00 FECE"
	$"0000 FECE 0000 FECE FE00 FDCE FE00 FACE 0300 CECE 00FD CEFE 00FE CE00 00FE CE00"
	$"00FE CE00 00FA CEFC 00FD CEFE 00FE CE03 00CE 0000 FECE 0000 FECE 0300 CECE 00FE"
	$"CEFE 00FE CE01 0000 FACE FC00 FDCE FE00 FECE 0000 FECE FD00 06CE CE00 00CE CE00"
	$"FECE FE00 FDCE 0000 FECE 0000 FDCE FE00 FCCE 0000 FECE 0000 D1CE EFCF FD00 FDCF"
	$"FE00 FACF 0000 FDCF FE00 FDCF FD00 02CF CF00 FECF FE00 FECF 0400 00CF CF00 FECF"
	$"0200 CFCF FD00 FDCF FD00 03CF CF00 00FE CFFE 00FD CFFD 00FA CF00 00FE CF00 00FE"
	$"CF07 00CF CF00 00CF CF00 FECF 0000 FECF FE00 FDCF FD00 03CF CF00 00FA CFFE 00FE"
	$"CF03 00CF 0000 FDCF FE00 FDCF FE00 FECF 0600 CFCF 00CF CF00 FECF FE00 FACF 0300"
	$"CFCF 00FE CFFE 00FD CFFE 00FE CF00 00FE CF00 00FE CFFE 00FD CFFE 00FA CF03 00CF"
	$"CF00 FDCF FE00 FECF 0000 FECF 0000 FECF 0000 FACF FC00 FDCF FE00 FECF 0300 CF00"
	$"00FE CF00 00FE CF03 00CF CF00 FECF FE00 FECF 0100 00FA CFFC 00FD CFFE 00FE CF00"
	$"00FE CFFD 0006 CFCF 0000 CFCF 00FE CFFE 00FD CF00 00FE CF00 00FD CFFE 00FC CF00"
	$"00FE CF00 00D1 CFEF CEFD 00FD CEFE 00FA CE00 00FD CEFE 00FD CEFD 0002 CECE 00FE"
	$"CEFE 00FE CE04 0000 CECE 00FE CE02 00CE CEFD 00FD CEFD 0003 CECE 0000 FECE FE00"
	$"FDCE FD00 FACE 0000 FECE 0000 FECE 0700 CECE 0000 CECE 00FE CE00 00FE CEFE 00FD"
	$"CEFD 0003 CECE 0000 FACE FE00 FECE 0300 CE00 00FD CEFE 00FD CEFE 00FE CE06 00CE"
	$"CE00 CECE 00FE CEFE 00FA CE03 00CE CE00 FECE FE00 FDCE FE00 FECE 0000 FECE 0000"
	$"FECE FE00 FDCE FE00 FACE 0300 CECE 00FD CEFE 00FE CE00 00FE CE00 00FE CE00 00FA"
	$"CEFC 00FD CEFE 00FE CE03 00CE 0000 FECE 0000 FECE 0300 CECE 00FE CEFE 00FE CE01"
	$"0000 FACE FC00 FDCE FE00 FECE 0000 FECE FD00 06CE CE00 00CE CE00 FECE FE00 FDCE"
	$"0000 FECE 0000 FDCE FE00 FCCE 0000 FECE 0000 D1CE 0036 81CE DECE 0000 81CE 02CE"
	$"CE00 A9CE 0000 CCCE 81CF DECF 0000 81CF 02CF CF00 A9CF 0000 CCCF 81CE DECE 0000"
	$"81CE 02CE CE00 A9CE 0000 CCCE 0036 81CE DECE 0000 81CE 02CE CE00 A9CE 0000 CCCE"
	$"81CF DECF 0000 81CF 02CF CF00 A9CF 0000 CCCF 81CE DECE 0000 81CE 02CE CE00 A9CE"
	$"0000 CCCE 0036 81CE DECE 0000 81CE 02CE CE00 AACE 0000 CBCE 81CF DECF 0000 81CF"
	$"02CF CF00 AACF 0000 CBCF 81CE DECE 0000 81CE 02CE CE00 AACE 0000 CBCE 0018 81CE"
	$"81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE"
	$"81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF"
	$"CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE"
	$"81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018"
	$"81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE"
	$"CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF"
	$"81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE"
	$"81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE"
	$"0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE"
	$"81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF"
	$"81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF"
	$"81CE 81CE 81CE CCCE 00C0 BFCE FB00 CFCE 0000 F7CE 0100 00E0 CE00 00DA CEFC 00F0"
	$"CE00 00FB CE00 00EF CEFC 00F7 CE00 00F4 CE00 00EA CE00 00FB CE01 0000 EFCE 0300"
	$"CECE 00EC CE01 0000 B7CE BFCF FB00 CFCF 0000 F7CF 0100 00E0 CF00 00DA CFFC 00F0"
	$"CF00 00FB CF00 00EF CFFC 00F7 CF00 00F4 CF00 00EA CF00 00FB CF01 0000 EFCF 0300"
	$"CFCF 00EC CF01 0000 B7CF BFCE FB00 CFCE 0000 F7CE 0100 00E0 CE00 00DA CEFC 00F0"
	$"CE00 00FB CE00 00EF CEFC 00F7 CE00 00F4 CE00 00EA CE00 00FB CE01 0000 EFCE 0300"
	$"CECE 00EC CE01 0000 B7CE 00D2 BFCE 0000 C0CE 0000 E2CE 0000 D7CE 0000 FCCE 0000"
	$"F1CE 0000 F1CE 0000 FACE 0000 FCCE 0000 F8CE 0000 F8CE 0000 E6CE 0000 FCCE 0000"
	$"EACE 0000 EDCE 0000 F9CE 0000 EDCE 0000 D3CE BFCF 0000 C0CF 0000 E2CF 0000 D7CF"
	$"0000 FCCF 0000 F1CF 0000 F1CF 0000 FACF 0000 FCCF 0000 F8CF 0000 F8CF 0000 E6CF"
	$"0000 FCCF 0000 EACF 0000 EDCF 0000 F9CF 0000 EDCF 0000 D3CF BFCE 0000 C0CE 0000"
	$"E2CE 0000 D7CE 0000 FCCE 0000 F1CE 0000 F1CE 0000 FACE 0000 FCCE 0000 F8CE 0000"
	$"F8CE 0000 E6CE 0000 FCCE 0000 EACE 0000 EDCE 0000 F9CE 0000 EDCE 0000 D3CE 00D2"
	$"BFCE 0000 C0CE 0000 E2CE 0000 D7CE 0000 FCCE 0000 F1CE 0000 F1CE 0000 FACE 0000"
	$"FCCE 0000 F8CE 0000 F8CE 0000 E6CE 0000 FCCE 0000 EACE 0000 EDCE 0000 F9CE 0000"
	$"EDCE 0000 D3CE BFCF 0000 C0CF 0000 E2CF 0000 D7CF 0000 FCCF 0000 F1CF 0000 F1CF"
	$"0000 FACF 0000 FCCF 0000 F8CF 0000 F8CF 0000 E6CF 0000 FCCF 0000 EACF 0000 EDCF"
	$"0000 F9CF 0000 EDCF 0000 D3CF BFCE 0000 C0CE 0000 E2CE 0000 D7CE 0000 FCCE 0000"
	$"F1CE 0000 F1CE 0000 FACE 0000 FCCE 0000 F8CE 0000 F8CE 0000 E6CE 0000 FCCE 0000"
	$"EACE 0000 EDCE 0000 F9CE 0000 EDCE 0000 D3CE 02EB BFCE 0000 F9CE FE00 FECE 0200"
	$"CE00 FCCE 0700 CE00 00CE CE00 00FD CEFE 00FE CE04 00CE 00CE CEFE 00FA CE08 00CE"
	$"CE00 CE00 00CE CEFE 0001 CECE FE00 FECE 0B00 CE00 CE00 CE00 00CE CE00 00FD CEFE"
	$"0001 CECE FE00 02CE CE00 FECE FE00 FECE 0300 CE00 00F9 CEFE 00FE CE03 00CE 0000"
	$"FACE 0000 F8CE FE00 FECE 0300 CE00 00FE CE03 00CE 0000 FECE 0000 FECE FE00 01CE"
	$"CEFE 00FB CE00 00F8 CEFE 00FE CE03 00CE CE00 FECE 0100 CEFE 0002 CECE 00FE CEFE"
	$"00FE CE03 00CE 0000 FDCE FE00 F9CE FE00 01CE CEFE 00FE CE07 00CE 0000 CECE 0000"
	$"FECE 0600 CECE 00CE CE00 FECE 0000 FACE FE00 01CE CEFE 00FB CEFE 00FD CEFE 00FD"
	$"CE00 00FE CE02 00CE CEFE 00D4 CEBF CF00 00F9 CFFE 00FE CF02 00CF 00FC CF07 00CF"
	$"0000 CFCF 0000 FDCF FE00 FECF 0400 CF00 CFCF FE00 FACF 0800 CFCF 00CF 0000 CFCF"
	$"FE00 01CF CFFE 00FE CF0B 00CF 00CF 00CF 0000 CFCF 0000 FDCF FE00 01CF CFFE 0002"
	$"CFCF 00FE CFFE 00FE CF03 00CF 0000 F9CF FE00 FECF 0300 CF00 00FA CF00 00F8 CFFE"
	$"00FE CF03 00CF 0000 FECF 0300 CF00 00FE CF00 00FE CFFE 0001 CFCF FE00 FBCF 0000"
	$"F8CF FE00 FECF 0300 CFCF 00FE CF01 00CF FE00 02CF CF00 FECF FE00 FECF 0300 CF00"
	$"00FD CFFE 00F9 CFFE 0001 CFCF FE00 FECF 0700 CF00 00CF CF00 00FE CF06 00CF CF00"
	$"CFCF 00FE CF00 00FA CFFE 0001 CFCF FE00 FBCF FE00 FDCF FE00 FDCF 0000 FECF 0200"
	$"CFCF FE00 D4CF BFCE 0000 F9CE FE00 FECE 0200 CE00 FCCE 0700 CE00 00CE CE00 00FD"
	$"CEFE 00FE CE04 00CE 00CE CEFE 00FA CE08 00CE CE00 CE00 00CE CEFE 0001 CECE FE00"
	$"FECE 0B00 CE00 CE00 CE00 00CE CE00 00FD CEFE 0001 CECE FE00 02CE CE00 FECE FE00"
	$"FECE 0300 CE00 00F9 CEFE 00FE CE03 00CE 0000 FACE 0000 F8CE FE00 FECE 0300 CE00"
	$"00FE CE03 00CE 0000 FECE 0000 FECE FE00 01CE CEFE 00FB CE00 00F8 CEFE 00FE CE03"
	$"00CE CE00 FECE 0100 CEFE 0002 CECE 00FE CEFE 00FE CE03 00CE 0000 FDCE FE00 F9CE"
	$"FE00 01CE CEFE 00FE CE07 00CE 0000 CECE 0000 FECE 0600 CECE 00CE CE00 FECE 0000"
	$"FACE FE00 01CE CEFE 00FB CEFE 00FD CEFE 00FD CE00 00FE CE02 00CE CEFE 00D4 CE03"
	$"54BF CEFC 00FE CE00 00FE CE04 00CE CE00 00FB CE0B 0000 CECE 0000 CECE 00CE CE00"
	$"FECE 0700 CECE 0000 CECE 00FE CE00 00FB CE0D 00CE CE00 00CE CE00 CECE 00CE CE00"
	$"FECE 1200 CECE 0000 CECE 0000 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00FE CE03"
	$"00CE CE00 FECE 0700 CECE 0000 CECE 00FB CE00 00FE CE07 00CE CE00 00CE CE00 FACE"
	$"FE00 FCCE 0000 FECE 1400 CECE 0000 CECE 00CE CE00 00CE CE00 CECE 00CE CE00 FECE"
	$"0300 CECE 00F9 CEFE 00FC CE00 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE"
	$"0300 CECE 00FE CE0A 00CE CE00 00CE CE00 CECE 00FE CE00 00F9 CE03 00CE CE00 FECE"
	$"1400 CECE 0000 CECE 0000 CECE 00CE CE00 CECE 00CE CE00 FECE 0000 FBCE 0000 FECE"
	$"0300 CECE 00F9 CE00 00FD CE00 00FE CE00 00FD CE02 00CE 00FD CE00 00D3 CEBF CFFC"
	$"00FE CF00 00FE CF04 00CF CF00 00FB CF0B 0000 CFCF 0000 CFCF 00CF CF00 FECF 0700"
	$"CFCF 0000 CFCF 00FE CF00 00FB CF0D 00CF CF00 00CF CF00 CFCF 00CF CF00 FECF 1200"
	$"CFCF 0000 CFCF 0000 CFCF 0000 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0700 CFCF 0000 CFCF 00FB CF00 00FE CF07 00CF CF00 00CF CF00 FACF FE00 FCCF"
	$"0000 FECF 1400 CFCF 0000 CFCF 00CF CF00 00CF CF00 CFCF 00CF CF00 FECF 0300 CFCF"
	$"00F9 CFFE 00FC CF00 00FE CF06 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF"
	$"00FE CF0A 00CF CF00 00CF CF00 CFCF 00FE CF00 00F9 CF03 00CF CF00 FECF 1400 CFCF"
	$"0000 CFCF 0000 CFCF 00CF CF00 CFCF 00CF CF00 FECF 0000 FBCF 0000 FECF 0300 CFCF"
	$"00F9 CF00 00FD CF00 00FE CF00 00FD CF02 00CF 00FD CF00 00D3 CFBF CEFC 00FE CE00"
	$"00FE CE04 00CE CE00 00FB CE0B 0000 CECE 0000 CECE 00CE CE00 FECE 0700 CECE 0000"
	$"CECE 00FE CE00 00FB CE0D 00CE CE00 00CE CE00 CECE 00CE CE00 FECE 1200 CECE 0000"
	$"CECE 0000 CECE 0000 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0700"
	$"CECE 0000 CECE 00FB CE00 00FE CE07 00CE CE00 00CE CE00 FACE FE00 FCCE 0000 FECE"
	$"1400 CECE 0000 CECE 00CE CE00 00CE CE00 CECE 00CE CE00 FECE 0300 CECE 00F9 CEFE"
	$"00FC CE00 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE0A"
	$"00CE CE00 00CE CE00 CECE 00FE CE00 00F9 CE03 00CE CE00 FECE 1400 CECE 0000 CECE"
	$"0000 CECE 00CE CE00 CECE 00CE CE00 FECE 0000 FBCE 0000 FECE 0300 CECE 00F9 CE00"
	$"00FD CE00 00FE CE00 00FD CE02 00CE 00FD CE00 00D3 CE03 2DBF CE00 00FA CE00 00FE"
	$"CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 FBCE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 FECE 0000 FBCE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0000 F7CE 0100 00FE CE00 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE06 00CE CE00 CECE 00FB CE00 00F6 CE01 0000 FECE 0000 FECE"
	$"0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03"
	$"00CE CE00 F5CE 0000 FBCE 0300 CECE 00FE CE00 00FE CE06 00CE CE00 CECE 00FE CE02"
	$"00CE 00FA CE00 00FE CE03 00CE CE00 F9CE 0000 FDCE 0000 FECE 0000 FDCE 0200 CE00"
	$"FDCE 0000 D3CE BFCF 0000 FACF 0000 FECF 0300 CFCF 00FA CF00 00FE CF00 00FE CF03"
	$"00CF CF00 FECF 0300 CFCF 00FE CF00 00FE CF00 00FB CF03 00CF CF00 FECF 0600 CFCF"
	$"00CF CF00 FECF 0300 CFCF 00FE CF00 00FE CF00 00FE CF00 00FB CF03 00CF CF00 FECF"
	$"0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF00 00F7"
	$"CF01 0000 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00"
	$"FBCF 0000 F6CF 0100 00FE CF00 00FE CF06 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF"
	$"0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00F5 CF00 00FB CF03 00CF CF00 FECF"
	$"0000 FECF 0600 CFCF 00CF CF00 FECF 0200 CF00 FACF 0000 FECF 0300 CFCF 00F9 CF00"
	$"00FD CF00 00FE CF00 00FD CF02 00CF 00FD CF00 00D3 CFBF CE00 00FA CE00 00FE CE03"
	$"00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0000 FBCE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0000 FECE 0000 FBCE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB"
	$"CE00 00FE CE03 00CE CE00 FECE 0000 F7CE 0100 00FE CE00 00FE CE03 00CE CE00 FECE"
	$"0300 CECE 00FE CE06 00CE CE00 CECE 00FB CE00 00F6 CE01 0000 FECE 0000 FECE 0600"
	$"CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 F5CE 0000 FBCE 0300 CECE 00FE CE00 00FE CE06 00CE CE00 CECE 00FE CE02 00CE"
	$"00FA CE00 00FE CE03 00CE CE00 F9CE 0000 FDCE 0000 FECE 0000 FDCE 0200 CE00 FDCE"
	$"0000 D3CE 030F BFCE 0000 FACE 0000 FECE 0300 CECE 00FA CE00 00FE CE00 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CEFC 00FB CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"FECE 0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CEFD 0002 CECE 00FE CE03 00CE"
	$"CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000 F5CE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE FE00 FECE 0000"
	$"F4CE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 FECE FE00 F8CE 0000 FECE FD00 02CE CE00 FECE 0000 FECE"
	$"0600 CECE 00CE CE00 FECE 0200 CE00 FACE 0000 FECE 0300 CECE 00F9 CE00 00FD CEFC"
	$"00FC CE00 00FC CE00 00D3 CEBF CF00 00FA CF00 00FE CF03 00CF CF00 FACF 0000 FECF"
	$"0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF FC00 FBCF 0300 CFCF 00FE CF06 00CF"
	$"CF00 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0000 FECF FD00 02CF CF00"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF00"
	$"00F5 CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CFFE"
	$"00FE CF00 00F4 CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF03"
	$"00CF CF00 FECF 0300 CFCF 00FE CF00 00FE CFFE 00F8 CF00 00FE CFFD 0002 CFCF 00FE"
	$"CF00 00FE CF06 00CF CF00 CFCF 00FE CF02 00CF 00FA CF00 00FE CF03 00CF CF00 F9CF"
	$"0000 FDCF FC00 FCCF 0000 FCCF 0000 D3CF BFCE 0000 FACE 0000 FECE 0300 CECE 00FA"
	$"CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CEFC 00FB CE03 00CE CE00"
	$"FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CEFD"
	$"0002 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE03 00CE"
	$"CE00 FECE 0000 F5CE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE FE00 FECE 0000 F4CE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE"
	$"CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE FE00 F8CE 0000 FECE FD00"
	$"02CE CE00 FECE 0000 FECE 0600 CECE 00CE CE00 FECE 0200 CE00 FACE 0000 FECE 0300"
	$"CECE 00F9 CE00 00FD CEFC 00FC CE00 00FC CE00 00D3 CE03 36BF CE00 00FA CE00 00FE"
	$"CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"F7CE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0000"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"FBCE 0000 FECE 0300 CECE 00FE CE00 00FB CE00 00FC CE03 00CE CE00 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00FB CE03 00CE CE00 FACE 0000 FCCE 0300 CECE"
	$"00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE 0000 FBCE 0000 F9CE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0600 CECE"
	$"00CE CE00 FECE 0200 CE00 FACE 0000 FECE 0300 CECE 00F9 CE00 00FD CE00 00F9 CE02"
	$"00CE 00FD CE00 00D3 CEBF CF00 00FA CF00 00FE CF03 00CF CF00 FACF 0000 FECF 0000"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 F7CF 0300 CFCF 00FE CF06 00CF CF00"
	$"CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF00"
	$"00FB CF00 00FC CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF"
	$"00FB CF03 00CF CF00 FACF 0000 FCCF 0300 CFCF 00FE CF06 00CF CF00 CFCF 00FE CF03"
	$"00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 F9CF 0300 CFCF"
	$"00FE CF03 00CF CF00 FECF 0000 FECF 0600 CFCF 00CF CF00 FECF 0200 CF00 FACF 0000"
	$"FECF 0300 CFCF 00F9 CF00 00FD CF00 00F9 CF02 00CF 00FD CF00 00D3 CFBF CE00 00FA"
	$"CE00 00FE CE03 00CE CE00 FACE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE 0000 F7CE 0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE00 00FB CE00 00FC CE03 00CE CE00 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FB CE03 00CE CE00 FACE 0000 FCCE"
	$"0300 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03"
	$"00CE CE00 FECE 0000 FBCE 0000 F9CE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0600 CECE 00CE CE00 FECE 0200 CE00 FACE 0000 FECE 0300 CECE 00F9 CE00 00FD CE00"
	$"00F9 CE02 00CE 00FD CE00 00D3 CE03 5ABF CE00 00FA CE00 00FE CE03 00CE CE00 FACE"
	$"0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FBCE 0300"
	$"CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FECE 0A00"
	$"CECE 00CE CE00 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000"
	$"FECE 0300 CECE 00FE CE00 00FB CE00 00FC CE03 00CE CE00 FECE 0A00 CECE 0000 CECE"
	$"00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FA CE00 00FC CE03 00CE CE00"
	$"FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 F9CE 0A00 CECE 00CE CE00 00CE CE00 FECE 0000 FECE 0600"
	$"CECE 00CE CE00 FDCE 0000 F9CE 0000 FECE 0300 CECE 00F9 CE00 00FD CE00 00FE CE00"
	$"00FD CE02 00CE 00FD CE00 00D3 CEBF CF00 00FA CF00 00FE CF03 00CF CF00 FACF 0000"
	$"FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FBCF 0300 CFCF"
	$"00FE CF06 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0A00 CFCF"
	$"00CF CF00 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF"
	$"0300 CFCF 00FE CF00 00FB CF00 00FC CF03 00CF CF00 FECF 0A00 CFCF 0000 CFCF 00CF"
	$"CF00 FECF 0600 CFCF 00CF CF00 FECF 0300 CFCF 00FA CF00 00FC CF03 00CF CF00 FECF"
	$"0600 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03"
	$"00CF CF00 FECF 0000 F9CF 0A00 CFCF 00CF CF00 00CF CF00 FECF 0000 FECF 0600 CFCF"
	$"00CF CF00 FDCF 0000 F9CF 0000 FECF 0300 CFCF 00F9 CF00 00FD CF00 00FE CF00 00FD"
	$"CF02 00CF 00FD CF00 00D3 CFBF CE00 00FA CE00 00FE CE03 00CE CE00 FACE 0000 FECE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FBCE 0300 CECE 00FE"
	$"CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FECE 0A00 CECE 00CE"
	$"CE00 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0300"
	$"CECE 00FE CE00 00FB CE00 00FC CE03 00CE CE00 FECE 0A00 CECE 0000 CECE 00CE CE00"
	$"FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FA CE00 00FC CE03 00CE CE00 FECE 0600"
	$"CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE 0000 F9CE 0A00 CECE 00CE CE00 00CE CE00 FECE 0000 FECE 0600 CECE 00CE"
	$"CE00 FDCE 0000 F9CE 0000 FECE 0300 CECE 00F9 CE00 00FD CE00 00FE CE00 00FD CE02"
	$"00CE 00FD CE00 00D3 CE02 E5BF CE00 00F9 CEFE 00FE CE00 00FA CE00 00FE CE00 00FE"
	$"CE00 00FE CEFE 00FE CE00 00FD CEFE 00FA CE03 00CE CE00 FECE 0300 CECE 00FE CEFE"
	$"00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE0A 0000 CE00 CECE 0000 CECE 00FE"
	$"CEFE 00FE CE00 00FE CE00 00FA CEFE 00FE CE00 00FE CE00 00FA CEFC 00FD CEFE 00FE"
	$"CE03 00CE 0000 FECE 0000 FECE 0300 CECE 00FE CEFE 00FE CE01 0000 FACE FC00 FDCE"
	$"FE00 FECE 0000 FECE FD00 06CE CE00 00CE CE00 FECE FE00 FECE 0000 FECE 0000 FECE"
	$"FE00 F8CE 0000 FECE 0600 00CE 00CE CE00 FECE 0000 FECE 0600 CECE 00CE CE00 FDCE"
	$"0000 F8CE FE00 FECE 0000 F9CE 0100 00FD CEFE 00FD CE00 00FE CE00 00FE CE01 0000"
	$"D4CE BFCF 0000 F9CF FE00 FECF 0000 FACF 0000 FECF 0000 FECF 0000 FECF FE00 FECF"
	$"0000 FDCF FE00 FACF 0300 CFCF 00FE CF03 00CF CF00 FECF FE00 FECF 0000 FECF 0000"
	$"FECF 0000 FECF 0000 FECF 0A00 00CF 00CF CF00 00CF CF00 FECF FE00 FECF 0000 FECF"
	$"0000 FACF FE00 FECF 0000 FECF 0000 FACF FC00 FDCF FE00 FECF 0300 CF00 00FE CF00"
	$"00FE CF03 00CF CF00 FECF FE00 FECF 0100 00FA CFFC 00FD CFFE 00FE CF00 00FE CFFD"
	$"0006 CFCF 0000 CFCF 00FE CFFE 00FE CF00 00FE CF00 00FE CFFE 00F8 CF00 00FE CF06"
	$"0000 CF00 CFCF 00FE CF00 00FE CF06 00CF CF00 CFCF 00FD CF00 00F8 CFFE 00FE CF00"
	$"00F9 CF01 0000 FDCF FE00 FDCF 0000 FECF 0000 FECF 0100 00D4 CFBF CE00 00F9 CEFE"
	$"00FE CE00 00FA CE00 00FE CE00 00FE CE00 00FE CEFE 00FE CE00 00FD CEFE 00FA CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CEFE 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FE"
	$"CE0A 0000 CE00 CECE 0000 CECE 00FE CEFE 00FE CE00 00FE CE00 00FA CEFE 00FE CE00"
	$"00FE CE00 00FA CEFC 00FD CEFE 00FE CE03 00CE 0000 FECE 0000 FECE 0300 CECE 00FE"
	$"CEFE 00FE CE01 0000 FACE FC00 FDCE FE00 FECE 0000 FECE FD00 06CE CE00 00CE CE00"
	$"FECE FE00 FECE 0000 FECE 0000 FECE FE00 F8CE 0000 FECE 0600 00CE 00CE CE00 FECE"
	$"0000 FECE 0600 CECE 00CE CE00 FDCE 0000 F8CE FE00 FECE 0000 F9CE 0100 00FD CEFE"
	$"00FD CE00 00FE CE00 00FE CE01 0000 D4CE 0024 81CE A2CE 0000 89CE 0000 A5CE 81CF"
	$"A2CF 0000 89CF 0000 A5CF 81CE A2CE 0000 89CE 0000 A5CE 0024 81CE A2CE 0000 89CE"
	$"0000 A5CE 81CF A2CF 0000 89CF 0000 A5CF 81CE A2CE 0000 89CE 0000 A5CE 0027 81CE"
	$"A2CE 0000 8BCE 0100 00A4 CE81 CFA2 CF00 008B CF01 0000 A4CF 81CE A2CE 0000 8BCE"
	$"0100 00A4 CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00"
	$"1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81"
	$"CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 7BE4 CE03 00CE CE00 FBCE 0000"
	$"DBCE 0000 E3CE 0000 CDCE 0000 DBCE 0000 DECE 0000 D0CE 0000 BECE 0000 B0CE E4CF"
	$"0300 CFCF 00FB CF00 00DB CF00 00E3 CF00 00CD CF00 00DB CF00 00DE CF00 00D0 CF00"
	$"00BE CF00 00B0 CFE4 CE03 00CE CE00 FBCE 0000 DBCE 0000 E3CE 0000 CDCE 0000 DBCE"
	$"0000 DECE 0000 D0CE 0000 BECE 0000 B0CE 0096 E4CE 0000 FCCE 0000 D7CE 0000 E3CE"
	$"0000 B8CE 0000 F0CE 0000 DECE 0000 F8CE 0000 DACE 0000 BECE 0000 D9CE 0000 EDCE"
	$"0000 EECE E4CF 0000 FCCF 0000 D7CF 0000 E3CF 0000 B8CF 0000 F0CF 0000 DECF 0000"
	$"F8CF 0000 DACF 0000 BECF 0000 D9CF 0000 EDCF 0000 EECF E4CE 0000 FCCE 0000 D7CE"
	$"0000 E3CE 0000 B8CE 0000 F0CE 0000 DECE 0000 F8CE 0000 DACE 0000 BECE 0000 D9CE"
	$"0000 EDCE 0000 EECE 0096 E4CE 0000 FCCE 0000 D7CE 0000 E3CE 0000 B8CE 0000 F0CE"
	$"0000 DECE 0000 F8CE 0000 DACE 0000 BECE 0000 D9CE 0000 EDCE 0000 EECE E4CF 0000"
	$"FCCF 0000 D7CF 0000 E3CF 0000 B8CF 0000 F0CF 0000 DECF 0000 F8CF 0000 DACF 0000"
	$"BECF 0000 D9CF 0000 EDCF 0000 EECF E4CE 0000 FCCE 0000 D7CE 0000 E3CE 0000 B8CE"
	$"0000 F0CE 0000 DECE 0000 F8CE 0000 DACE 0000 BECE 0000 D9CE 0000 EDCE 0000 EECE"
	$"035D EECE FE00 FDCE 0700 00CE 00CE CE00 CEFE 0008 CECE 00CE CE00 CE00 00FD CE03"
	$"0000 CE00 FACE FE00 FECE 0300 CE00 00FD CE03 0000 CE00 FCCE 0000 FECE 0000 FECE"
	$"0200 CECE FE00 FECE 0800 CE00 CECE 0000 CE00 FBCE 0300 CE00 00FE CE04 00CE 00CE"
	$"CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FE CE06 00CE CE00 CE00 00FD CE03"
	$"0000 CE00 FCCE FE00 FECE FE00 FDCE FE00 FECE 0000 FECE FE00 F6CE 0000 FECE 0600"
	$"CECE 00CE 0000 FDCE 0300 00CE 00FE CEFE 0001 CECE FE00 FECE FE00 FDCE FE00 F9CE"
	$"FE00 FECE 0300 CE00 00FD CE03 0000 CE00 FACE FE00 FDCE FE00 FECE 0000 FECE 0700"
	$"CECE 00CE 00CE CEFE 00FD CEFE 00F9 CEFE 00FD CEFE 00FD CE03 0000 CE00 FECE FE00"
	$"F5CE FE00 FDCE FE00 FDCE 0300 CE00 00FE CEFE 00FD CEFE 00FC CEFE 00FE CEFE 00EF"
	$"CEEE CFFE 00FD CF07 0000 CF00 CFCF 00CF FE00 08CF CF00 CFCF 00CF 0000 FDCF 0300"
	$"00CF 00FA CFFE 00FE CF03 00CF 0000 FDCF 0300 00CF 00FC CF00 00FE CF00 00FE CF02"
	$"00CF CFFE 00FE CF08 00CF 00CF CF00 00CF 00FB CF03 00CF 0000 FECF 0400 CF00 CFCF"
	$"FE00 FDCF FE00 FDCF FE00 FDCF FE00 FDCF FE00 FECF 0600 CFCF 00CF 0000 FDCF 0300"
	$"00CF 00FC CFFE 00FE CFFE 00FD CFFE 00FE CF00 00FE CFFE 00F6 CF00 00FE CF06 00CF"
	$"CF00 CF00 00FD CF03 0000 CF00 FECF FE00 01CF CFFE 00FE CFFE 00FD CFFE 00F9 CFFE"
	$"00FE CF03 00CF 0000 FDCF 0300 00CF 00FA CFFE 00FD CFFE 00FE CF00 00FE CF07 00CF"
	$"CF00 CF00 CFCF FE00 FDCF FE00 F9CF FE00 FDCF FE00 FDCF 0300 00CF 00FE CFFE 00F5"
	$"CFFE 00FD CFFE 00FD CF03 00CF 0000 FECF FE00 FDCF FE00 FCCF FE00 FECF FE00 EFCF"
	$"EECE FE00 FDCE 0700 00CE 00CE CE00 CEFE 0008 CECE 00CE CE00 CE00 00FD CE03 0000"
	$"CE00 FACE FE00 FECE 0300 CE00 00FD CE03 0000 CE00 FCCE 0000 FECE 0000 FECE 0200"
	$"CECE FE00 FECE 0800 CE00 CECE 0000 CE00 FBCE 0300 CE00 00FE CE04 00CE 00CE CEFE"
	$"00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FE CE06 00CE CE00 CE00 00FD CE03 0000"
	$"CE00 FCCE FE00 FECE FE00 FDCE FE00 FECE 0000 FECE FE00 F6CE 0000 FECE 0600 CECE"
	$"00CE 0000 FDCE 0300 00CE 00FE CEFE 0001 CECE FE00 FECE FE00 FDCE FE00 F9CE FE00"
	$"FECE 0300 CE00 00FD CE03 0000 CE00 FACE FE00 FDCE FE00 FECE 0000 FECE 0700 CECE"
	$"00CE 00CE CEFE 00FD CEFE 00F9 CEFE 00FD CEFE 00FD CE03 0000 CE00 FECE FE00 F5CE"
	$"FE00 FDCE FE00 FDCE 0300 CE00 00FE CEFE 00FD CEFE 00FC CEFE 00FE CEFE 00EF CE04"
	$"56EF CE00 00FE CE0D 00CE CE00 CECE 0000 CECE 00CE CE00 FECE 0E00 CECE 0000 CECE"
	$"00CE CE00 CECE 0000 FBCE 0000 FECE 0E00 CECE 0000 CECE 00CE CE00 CECE 0000 FCCE"
	$"0000 FECE 0000 FECE 0200 CE00 FECE 0B00 CECE 0000 CECE 00CE CE00 00FB CE0B 0000"
	$"CECE 00CE CE00 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 1100 CECE 00CE CE00 00CE CE00 CECE 00CE CE00 00FB CE00 00FE"
	$"CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0000 F7CE 0000 FECE 1100"
	$"CECE 0000 CECE 00CE CE00 CECE 0000 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0300"
	$"CECE 00FE CE00 00FB CE00 00FE CE0E 00CE CE00 00CE CE00 CECE 00CE CE00 00FB CE00"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE07 00CE CE00 00CE CE00 FECE 0300 CECE"
	$"00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0A00 CECE 00CE CE00 00CE CE00 FECE"
	$"0000 F7CE 0000 FECE 0300 CECE 00FE CE00 00FE CE04 0000 CECE 00FE CE00 00FD CE00"
	$"00FE CE00 00FE CE00 00FE CE00 00FE CE00 00EE CEEF CF00 00FE CF0D 00CF CF00 CFCF"
	$"0000 CFCF 00CF CF00 FECF 0E00 CFCF 0000 CFCF 00CF CF00 CFCF 0000 FBCF 0000 FECF"
	$"0E00 CFCF 0000 CFCF 00CF CF00 CFCF 0000 FCCF 0000 FECF 0000 FECF 0200 CF00 FECF"
	$"0B00 CFCF 0000 CFCF 00CF CF00 00FB CF0B 0000 CFCF 00CF CF00 00CF CF00 FECF 0300"
	$"CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 1100 CFCF 00CF"
	$"CF00 00CF CF00 CFCF 00CF CF00 00FB CF00 00FE CF00 00FE CF03 00CF CF00 FECF 0600"
	$"CFCF 00CF CF00 FECF 0000 F7CF 0000 FECF 1100 CFCF 0000 CFCF 00CF CF00 CFCF 0000"
	$"CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF00 00FB CF00 00FE CF0E"
	$"00CF CF00 00CF CF00 CFCF 00CF CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0300 CFCF"
	$"00FE CF07 00CF CF00 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF00 00FE CF03 00CF"
	$"CF00 FECF 0A00 CFCF 00CF CF00 00CF CF00 FECF 0000 F7CF 0000 FECF 0300 CFCF 00FE"
	$"CF00 00FE CF04 0000 CFCF 00FE CF00 00FD CF00 00FE CF00 00FE CF00 00FE CF00 00FE"
	$"CF00 00EE CFEF CE00 00FE CE0D 00CE CE00 CECE 0000 CECE 00CE CE00 FECE 0E00 CECE"
	$"0000 CECE 00CE CE00 CECE 0000 FBCE 0000 FECE 0E00 CECE 0000 CECE 00CE CE00 CECE"
	$"0000 FCCE 0000 FECE 0000 FECE 0200 CE00 FECE 0B00 CECE 0000 CECE 00CE CE00 00FB"
	$"CE0B 0000 CECE 00CE CE00 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE 1100 CECE 00CE CE00 00CE CE00 CECE 00CE CE00 00FB"
	$"CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0000 F7CE 0000"
	$"FECE 1100 CECE 0000 CECE 00CE CE00 CECE 0000 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE0E 00CE CE00 00CE CE00 CECE 00CE CE00"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE07 00CE CE00 00CE CE00 FECE"
	$"0300 CECE 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0A00 CECE 00CE CE00 00CE"
	$"CE00 FECE 0000 F7CE 0000 FECE 0300 CECE 00FE CE00 00FE CE04 0000 CECE 00FE CE00"
	$"00FD CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00EE CE03 C3EF CE00 00FE CE03"
	$"00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"F7CE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0900 CE00 CE00 CE00 CECE 00FE"
	$"CE03 00CE CE00 FECE 0000 FECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE00 00FE CE03"
	$"00CE CE00 FBCE 0000 FECE 0300 CECE 00FB CE00 00FB CE03 00CE CE00 FECE 0300 CECE"
	$"00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 F3CE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE CE00 00FE"
	$"CE03 00CE CE00 F3CE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FBCE 0000"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FBCE 0000 FBCE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 F7CE 0000 FBCE 0000 FECE 0000"
	$"FECE 0000 FECE 0000 FECE 0000 F9CE 0000 FECE 0000 FACE 0000 EECE EFCF 0000 FECF"
	$"0300 CFCF 00FE CF06 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00"
	$"00F7 CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF09 00CF 00CF 00CF 00CF CF00"
	$"FECF 0300 CFCF 00FE CF00 00FE CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0000 FECF"
	$"0300 CFCF 00FB CF00 00FE CF03 00CF CF00 FBCF 0000 FBCF 0300 CFCF 00FE CF03 00CF"
	$"CF00 FECF 0000 FBCF 0000 FECF 0000 FECF 0300 CFCF 00FE CF06 00CF CF00 CFCF 00F3"
	$"CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF03 00CF CF00 FECF 0000"
	$"FECF 0300 CFCF 00F3 CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF00 00FB CF00"
	$"00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF00 00FE CF00 00FB CF00 00FB"
	$"CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00F7 CF00 00FB CF00 00FE CF00"
	$"00FE CF00 00FE CF00 00FE CF00 00F9 CF00 00FE CF00 00FA CF00 00EE CFEF CE00 00FE"
	$"CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0000 F7CE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0900 CE00 CE00 CE00 CECE"
	$"00FE CE03 00CE CE00 FECE 0000 FECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE00 00FE"
	$"CE03 00CE CE00 FBCE 0000 FECE 0300 CECE 00FB CE00 00FB CE03 00CE CE00 FECE 0300"
	$"CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"F3CE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE CE00"
	$"00FE CE03 00CE CE00 F3CE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FBCE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FBCE 0000"
	$"FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 F7CE 0000 FBCE 0000 FECE"
	$"0000 FECE 0000 FECE 0000 FECE 0000 F9CE 0000 FECE 0000 FACE 0000 EECE 039F EFCE"
	$"FC00 02CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0000 FACE FD00 02CE CE00 FECE 0300 CECE 00FE CE00 00FB CE09 00CE 00CE 00CE 00CE"
	$"CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0300 CECE 00FB CEFC 00FE CEFE 00FD CEFE 00FE CE03 00CE CE00 FECE 0300 CECE"
	$"00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CEFE 00F6"
	$"CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CEFD 0002 CECE 00FE CEFC"
	$"00FE CEFE 00F9 CEFD 0002 CECE 00FE CE03 00CE CE00 FECE 0000 FACE FE00 FECE 0000"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE FC00 FBCE 0000 FBCE 0000 FECE"
	$"0300 CECE 00FE CE02 00CE CEFC 00F7 CE00 00FB CE00 00FE CE00 00FE CE00 00FE CE00"
	$"00FE CE00 00FC CEFD 00FE CE00 00FA CE00 00EE CEEF CFFC 0002 CFCF 00FE CF06 00CF"
	$"CF00 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FA CFFD 0002 CFCF 00FE"
	$"CF03 00CF CF00 FECF 0000 FBCF 0900 CF00 CF00 CF00 CFCF 00FE CF03 00CF CF00 FECF"
	$"0000 FECF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF00 00FE CF03 00CF CF00 FBCF FC00"
	$"FECF FE00 FDCF FE00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 FBCF 0000 FECF"
	$"0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF FE00 F6CF 0000 FECF 0300 CFCF 00FE"
	$"CF03 00CF CF00 FECF 0000 FECF FD00 02CF CF00 FECF FC00 FECF FE00 F9CF FD00 02CF"
	$"CF00 FECF 0300 CFCF 00FE CF00 00FA CFFE 00FE CF00 00FE CF03 00CF CF00 FECF 0300"
	$"CFCF 00FE CF00 00FB CFFC 00FB CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0200 CFCF"
	$"FC00 F7CF 0000 FBCF 0000 FECF 0000 FECF 0000 FECF 0000 FECF 0000 FCCF FD00 FECF"
	$"0000 FACF 0000 EECF EFCE FC00 02CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 FECE 0000 FACE FD00 02CE CE00 FECE 0300 CECE 00FE CE00 00FB"
	$"CE09 00CE 00CE 00CE 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE00 00FE"
	$"CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FB CEFC 00FE CEFE 00FD CEFE 00FE CE03"
	$"00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00 FECE"
	$"0300 CECE 00FE CEFE 00F6 CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FE"
	$"CEFD 0002 CECE 00FE CEFC 00FE CEFE 00F9 CEFD 0002 CECE 00FE CE03 00CE CE00 FECE"
	$"0000 FACE FE00 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FBCE FC00"
	$"FBCE 0000 FBCE 0000 FECE 0300 CECE 00FE CE02 00CE CEFC 00F7 CE00 00FB CE00 00FE"
	$"CE00 00FE CE00 00FE CE00 00FE CE00 00FC CEFD 00FE CE00 00FA CE00 00EE CE03 BAEF"
	$"CE00 00FB CE00 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE"
	$"CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE09 00CE 00CE"
	$"00CE 00CE CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE00 00FE CE03 00CE CE00"
	$"FECE 0000 FECE 0300 CECE 00FB CE00 00F7 CE00 00FB CE06 00CE CE00 CECE 00FE CE03"
	$"00CE CE00 FECE 0000 FBCE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FBCE"
	$"0000 F7CE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE 0000 F7CE 0000 FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000"
	$"F7CE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00F7 CE00"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00F3 CE00 00FB CE00 00FE CE00 00FE"
	$"CE00 00FE CE00 00FE CE00 00FD CE00 00FE CE00 00FE CE00 00FA CE00 00EE CEEF CF00"
	$"00FB CF00 00FE CF06 00CF CF00 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00"
	$"00FB CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF09 00CF 00CF 00CF"
	$"00CF CF00 FECF 0300 CFCF 00FE CF00 00FE CF00 00FB CF00 00FE CF03 00CF CF00 FECF"
	$"0000 FECF 0300 CFCF 00FB CF00 00F7 CF00 00FB CF06 00CF CF00 CFCF 00FE CF03 00CF"
	$"CF00 FECF 0000 FBCF 0000 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FBCF 0000"
	$"F7CF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0000 F7CF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0000 F7CF"
	$"0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00 00FB CF00 00F7 CF00 00FB"
	$"CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00F3 CF00 00FB CF00 00FE CF00 00FE CF00"
	$"00FE CF00 00FE CF00 00FD CF00 00FE CF00 00FE CF00 00FA CF00 00EE CFEF CE00 00FB"
	$"CE00 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB"
	$"CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE09 00CE 00CE 00CE 00CE"
	$"CE00 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000"
	$"FECE 0300 CECE 00FB CE00 00F7 CE00 00FB CE06 00CE CE00 CECE 00FE CE03 00CE CE00"
	$"FECE 0000 FBCE 0000 FECE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FBCE 0000 F7CE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0000 F7CE 0000 FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 F7CE 0300"
	$"CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00F7 CE00 00FB CE00"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00F3 CE00 00FB CE00 00FE CE00 00FE CE00 00FE"
	$"CE00 00FE CE00 00FD CE00 00FE CE00 00FE CE00 00FA CE00 00EE CE04 50EF CE00 00FE"
	$"CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE07 00CE CE00 CECE"
	$"0000 FBCE 0700 CECE 0000 CECE 00FE CE03 00CE CE00 FECE 0000 FACE 0000 FECE 0000"
	$"FECE 0000 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE07 0000 CECE 00CE CE00 FECE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0600 CECE 00CE CE00 FECE 0700 CECE 00CE CE00 00FB CE00 00FE CE00 00FE CE03 00CE"
	$"CE00 FECE 0600 CECE 00CE CE00 FECE 0000 F7CE 0000 FECE 0A00 CECE 0000 CECE 00CE"
	$"CE00 FECE 0A00 CECE 00CE CE00 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00 00FB"
	$"CE07 00CE CE00 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00 00FB CE00"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 F7CE 0000 FECE"
	$"0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FD CE04 00CE CE00 00FE CE00"
	$"00FE CE00 00FE CE00 00EE CEEF CF00 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00"
	$"FECF 0300 CFCF 00FE CF07 00CF CF00 CFCF 0000 FBCF 0700 CFCF 0000 CFCF 00FE CF03"
	$"00CF CF00 FECF 0000 FACF 0000 FECF 0000 FECF 0000 FECF 0300 CFCF 00FE CF00 00FE"
	$"CF00 00FB CF07 0000 CFCF 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0700 CFCF 00CF"
	$"CF00 00FB CF00 00FE CF00 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0000"
	$"F7CF 0000 FECF 0A00 CFCF 0000 CFCF 00CF CF00 FECF 0A00 CFCF 00CF CF00 00CF CF00"
	$"FECF 0000 FECF 0300 CFCF 00FE CF00 00FB CF07 00CF CF00 00CF CF00 FECF 0300 CFCF"
	$"00FE CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF"
	$"0000 FECF 0300 CFCF 00FE CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE"
	$"CF03 00CF CF00 FECF 0000 F7CF 0000 FECF 0300 CFCF 00FE CF00 00FE CF00 00FE CF00"
	$"00FE CF00 00FD CF04 00CF CF00 00FE CF00 00FE CF00 00FE CF00 00EE CFEF CE00 00FE"
	$"CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0300 CECE 00FE CE07 00CE CE00 CECE"
	$"0000 FBCE 0700 CECE 0000 CECE 00FE CE03 00CE CE00 FECE 0000 FACE 0000 FECE 0000"
	$"FECE 0000 FECE 0300 CECE 00FE CE00 00FE CE00 00FB CE07 0000 CECE 00CE CE00 FECE"
	$"0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0600 CECE 00CE CE00 FECE 0700 CECE 00CE CE00 00FB CE00 00FE CE00 00FE CE03 00CE"
	$"CE00 FECE 0600 CECE 00CE CE00 FECE 0000 F7CE 0000 FECE 0A00 CECE 0000 CECE 00CE"
	$"CE00 FECE 0A00 CECE 00CE CE00 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00 00FB"
	$"CE07 00CE CE00 00CE CE00 FECE 0300 CECE 00FE CE00 00FB CE00 00FE CE03 00CE CE00"
	$"FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00 00FB CE00"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 F7CE 0000 FECE"
	$"0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00FD CE04 00CE CE00 00FE CE00"
	$"00FE CE00 00FE CE00 00EE CE03 48EE CEFE 00FD CEFD 000C CECE 00CE CE00 00CE CE00"
	$"CECE 00FE CE00 00FE CE03 0000 CE00 FACE 0600 00CE 00CE CE00 FECE 0000 FECE FD00"
	$"FACE 0000 FECE 0000 FDCE FE00 FECE 0000 FDCE FD00 FBCE 0300 CE00 00FE CE00 00FD"
	$"CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FE CE03 00CE CE00 FECE 0000 FECE"
	$"0300 00CE 00FB CE01 0000 FECE FE00 FDCE FE00 FECE 0000 FECE FE00 FDCE 0000 FACE"
	$"FD00 05CE CE00 CE00 00FD CEFD 00FE CE07 0000 CE00 CECE 0000 FECE FE00 FDCE FE00"
	$"F9CE 0600 00CE 00CE CE00 FECE 0000 FECE FD00 FACE FE00 FDCE FE00 FDCE FD00 02CE"
	$"CE00 FDCE FE00 FDCE FE00 F9CE FE00 FDCE FE00 FDCE FD00 FECE FE00 FDCE 0000 FACE"
	$"FE00 FDCE FE00 FDCE 0000 FECE 0000 FECE 0100 00FD CE03 0000 CE00 FDCE FE00 FDCE"
	$"0100 00EF CEEE CFFE 00FD CFFD 000C CFCF 00CF CF00 00CF CF00 CFCF 00FE CF00 00FE"
	$"CF03 0000 CF00 FACF 0600 00CF 00CF CF00 FECF 0000 FECF FD00 FACF 0000 FECF 0000"
	$"FDCF FE00 FECF 0000 FDCF FD00 FBCF 0300 CF00 00FE CF00 00FD CFFE 00FD CFFE 00FD"
	$"CFFE 00FD CFFE 00FD CFFE 00FE CF03 00CF CF00 FECF 0000 FECF 0300 00CF 00FB CF01"
	$"0000 FECF FE00 FDCF FE00 FECF 0000 FECF FE00 FDCF 0000 FACF FD00 05CF CF00 CF00"
	$"00FD CFFD 00FE CF07 0000 CF00 CFCF 0000 FECF FE00 FDCF FE00 F9CF 0600 00CF 00CF"
	$"CF00 FECF 0000 FECF FD00 FACF FE00 FDCF FE00 FDCF FD00 02CF CF00 FDCF FE00 FDCF"
	$"FE00 F9CF FE00 FDCF FE00 FDCF FD00 FECF FE00 FDCF 0000 FACF FE00 FDCF FE00 FDCF"
	$"0000 FECF 0000 FECF 0100 00FD CF03 0000 CF00 FDCF FE00 FDCF 0100 00EF CFEE CEFE"
	$"00FD CEFD 000C CECE 00CE CE00 00CE CE00 CECE 00FE CE00 00FE CE03 0000 CE00 FACE"
	$"0600 00CE 00CE CE00 FECE 0000 FECE FD00 FACE 0000 FECE 0000 FDCE FE00 FECE 0000"
	$"FDCE FD00 FBCE 0300 CE00 00FE CE00 00FD CEFE 00FD CEFE 00FD CEFE 00FD CEFE 00FD"
	$"CEFE 00FE CE03 00CE CE00 FECE 0000 FECE 0300 00CE 00FB CE01 0000 FECE FE00 FDCE"
	$"FE00 FECE 0000 FECE FE00 FDCE 0000 FACE FD00 05CE CE00 CE00 00FD CEFD 00FE CE07"
	$"0000 CE00 CECE 0000 FECE FE00 FDCE FE00 F9CE 0600 00CE 00CE CE00 FECE 0000 FECE"
	$"FD00 FACE FE00 FDCE FE00 FDCE FD00 02CE CE00 FDCE FE00 FDCE FE00 F9CE FE00 FDCE"
	$"FE00 FDCE FD00 FECE FE00 FDCE 0000 FACE FE00 FDCE FE00 FDCE 0000 FECE 0000 FECE"
	$"0100 00FD CE03 0000 CE00 FDCE FE00 FDCE 0100 00EF CE00 54CC CE00 00C3 CE00 00C6"
	$"CE00 00DE CE00 00F4 CE00 0081 CEF6 CE00 00BB CECC CF00 00C3 CF00 00C6 CF00 00DE"
	$"CF00 00F4 CF00 0081 CFF6 CF00 00BB CFCC CE00 00C3 CE00 00C6 CE00 00DE CE00 00F4"
	$"CE00 0081 CEF6 CE00 00BB CE00 6CD0 CE00 00FE CE00 00C3 CE00 00CA CE00 00FE CE00"
	$"00DE CE00 00F4 CE00 0081 CEF6 CE00 00BB CED0 CF00 00FE CF00 00C3 CF00 00CA CF00"
	$"00FE CF00 00DE CF00 00F4 CF00 0081 CFF6 CF00 00BB CFD0 CE00 00FE CE00 00C3 CE00"
	$"00CA CE00 00FE CE00 00DE CE00 00F4 CE00 0081 CEF6 CE00 00BB CE00 3CCF CEFE 00C2"
	$"CE00 00C9 CEFE 00CF CE00 0081 CEAF CECF CFFE 00C2 CF00 00C9 CFFE 00CF CF00 0081"
	$"CFAF CFCF CEFE 00C2 CE00 00C9 CEFE 00CF CE00 0081 CEAF CE00 1881 CE81 CE81 CECC"
	$"CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81"
	$"CFCC CF81 CE81 CE81 CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81"
	$"CE81 CECC CE00 E4EF CE00 00F7 CE01 0000 F6CE 0000 F4CE 0000 FCCE FC00 E7CE 0000"
	$"FBCE 0000 C4CE 0000 DBCE 0300 CECE 00E6 CE00 00E6 CE00 00FE CE00 00CC CE00 00FB"
	$"CE00 00CE CE02 00CE 00F0 CE00 00FD CE00 00DF CEEF CF00 00F7 CF01 0000 F6CF 0000"
	$"F4CF 0000 FCCF FC00 E7CF 0000 FBCF 0000 C4CF 0000 DBCF 0300 CFCF 00E6 CF00 00E6"
	$"CF00 00FE CF00 00CC CF00 00FB CF00 00CE CF02 00CF 00F0 CF00 00FD CF00 00DF CFEF"
	$"CE00 FFF7 CE01 FFFF F6CE 00FF F4CE 00FF FCCE FCFF E7CE 00FF FBCE 00FF C4CE 0000"
	$"DBCE 0300 CECE 00E6 CE00 FFE6 CE00 FFFE CE00 FFCC CE00 FFFB CE00 FFCE CE02 FFCE"
	$"FFF0 CE00 FFFD CE00 FFDF CE00 E7E5 CE00 00F4 CE00 00F4 CE00 00FE CE01 0000 FCCE"
	$"0000 E8CE 0000 F1CE 0000 A4CE 0000 E6CE 0000 FBCE 0000 FECE 0000 F1CE 0000 FECE"
	$"0000 CCCE 0000 F1CE 0000 D8CE 0200 CE00 F0CE 0000 FDCE 0000 DFCE E5CF 0000 F4CF"
	$"0000 F4CF 0000 FECF 0100 00FC CF00 00E8 CF00 00F1 CF00 00A4 CF00 00E6 CF00 00FB"
	$"CF00 00FE CF00 00F1 CF00 00FE CF00 00CC CF00 00F1 CF00 00D8 CF02 00CF 00F0 CF00"
	$"00FD CF00 00DF CFE5 CE00 FFF4 CE00 FFF4 CE00 FFFE CE01 FFFF FCCE 00FF E8CE 00FF"
	$"F1CE 00FF A4CE 0000 E6CE 00FF FBCE 00FF FECE 00FF F1CE 00FF FECE 00FF CCCE 00FF"
	$"F1CE 00FF D8CE 02FF CEFF F0CE 00FF FDCE 00FF DFCE 00E4 E5CE 0000 F4CE 0000 F4CE"
	$"0300 CECE 00F9 CE00 00E9 CE00 00F1 CE00 00A4 CE00 00E6 CE00 00FB CE00 00FE CE00"
	$"00F2 CE00 00FE CE00 00CB CE00 00F1 CE00 00D9 CE03 00CE CE00 F0CE 0000 FECE 0000"
	$"DECE E5CF 0000 F4CF 0000 F4CF 0300 CFCF 00F9 CF00 00E9 CF00 00F1 CF00 00A4 CF00"
	$"00E6 CF00 00FB CF00 00FE CF00 00F2 CF00 00FE CF00 00CB CF00 00F1 CF00 00D9 CF03"
	$"00CF CF00 F0CF 0000 FECF 0000 DECF E5CE 00FF F4CE 00FF F4CE 03FF CECE FFF9 CE00"
	$"FFE9 CE00 FFF1 CE00 FFA4 CE00 00E6 CE00 FFFB CE00 FFFE CE00 FFF2 CE00 FFFE CE00"
	$"FFCB CE00 FFF1 CE00 FFD9 CE03 FFCE CEFF F0CE 00FF FECE 00FF DECE 03A2 EFCE 0800"
	$"CECE 00CE 0000 CECE FE00 01CE CEFE 00FA CE00 00FE CEFE 00FD CE08 0000 CE00 CECE"
	$"00CE CEFE 0004 CE00 CECE 00FE CEFE 00FD CEFE 00FE CE03 00CE 0000 FECE 0300 CE00"
	$"00FE CE00 00FE CEFE 0001 CECE FE00 FECE FE00 F9CE FE00 FDCE FE00 FDCE 0700 CE00"
	$"00CE CE00 00F9 CE00 00FE CE02 00CE 00FE CEFE 00F9 CEFE 00FE CE07 00CE 0000 CECE"
	$"0000 FDCE FE00 FECE 0300 CECE 00F6 CEFE 00FE CE02 00CE 00FA CE05 00CE 0000 CECE"
	$"FE00 00CE FE00 05CE CE00 CE00 00FE CE00 00FD CE00 00FE CE02 00CE 00FE CE00 00FE"
	$"CE01 0000 FECE 0000 FECE 0100 00FE CE00 00FE CE00 00FB CEFE 00FD CEFE 00FE CE03"
	$"00CE 0000 FECE 0300 CE00 00FE CE00 00FE CEFE 0001 CECE FE00 FECE FE00 F9CE FE00"
	$"FDCE FE00 FECE 0700 CE00 00CE CE00 00FD CE03 00CE CE00 FACE FE00 FDCE 0300 00CE"
	$"00FE CE00 00F9 CEFE 00FE CE03 00CE 0000 F0CE EFCF 0800 CFCF 00CF 0000 CFCF FE00"
	$"01CF CFFE 00FA CF00 00FE CFFE 00FD CF08 0000 CF00 CFCF 00CF CFFE 0004 CF00 CFCF"
	$"00FE CFFE 00FD CFFE 00FE CF03 00CF 0000 FECF 0300 CF00 00FE CF00 00FE CFFE 0001"
	$"CFCF FE00 FECF FE00 F9CF FE00 FDCF FE00 FDCF 0700 CF00 00CF CF00 00F9 CF00 00FE"
	$"CF02 00CF 00FE CFFE 00F9 CFFE 00FE CF07 00CF 0000 CFCF 0000 FDCF FE00 FECF 0300"
	$"CFCF 00F6 CFFE 00FE CF02 00CF 00FA CF05 00CF 0000 CFCF FE00 00CF FE00 05CF CF00"
	$"CF00 00FE CF00 00FD CF00 00FE CF02 00CF 00FE CF00 00FE CF01 0000 FECF 0000 FECF"
	$"0100 00FE CF00 00FE CF00 00FB CFFE 00FD CFFE 00FE CF03 00CF 0000 FECF 0300 CF00"
	$"00FE CF00 00FE CFFE 0001 CFCF FE00 FECF FE00 F9CF FE00 FDCF FE00 FECF 0700 CF00"
	$"00CF CF00 00FD CF03 00CF CF00 FACF FE00 FDCF 0300 00CF 00FE CF00 00F9 CFFE 00FE"
	$"CF03 00CF 0000 F0CF EFCE 08FF CECE FFCE FFFF CECE FEFF 01CE CEFE FFFA CE00 FFFE"
	$"CEFE FFFD CE08 FFFF CEFF CECE FFCE CEFE FF04 CEFF CECE FFFE CEFE FFFD CEFE FFFE"
	$"CE03 FFCE FFFF FECE 03FF CEFF FFFE CE00 FFFE CEFE FF01 CECE FEFF FECE FEFF F9CE"
	$"FEFF FDCE FEFF FDCE 07FF CEFF FFCE CEFF FFF9 CE00 00FE CE02 00CE 00FE CEFE 00F9"
	$"CEFE 00FE CE07 00CE 0000 CECE 0000 FDCE FE00 FECE 0300 CECE 00F6 CEFE 00FE CE02"
	$"00CE 00FA CE05 FFCE FFFF CECE FEFF 00CE FEFF 05CE CEFF CEFF FFFE CE00 FFFD CE00"
	$"FFFE CE02 FFCE FFFE CE00 FFFE CE01 FFFF FECE 00FF FECE 01FF FFFE CE00 FFFE CE00"
	$"FFFB CEFE FFFD CEFE FFFE CE03 FFCE FFFF FECE 03FF CEFF FFFE CE00 FFFE CEFE FF01"
	$"CECE FEFF FECE FEFF F9CE FEFF FDCE FEFF FECE 07FF CEFF FFCE CEFF FFFD CE03 FFCE"
	$"CEFF FACE FEFF FDCE 03FF FFCE FFFE CE00 FFF9 CEFE 00FE CE03 00CE 0000 F0CE 044D"
	$"EFCE 0D00 CECE 0000 CECE 00CE CE00 CECE 00FE CE00 00FB CE03 00CE CE00 FECE 0C00"
	$"CECE 00CE CE00 00CE 00CE CE00 FECE 0700 00CE CE00 CECE 00FE CE03 00CE CE00 FECE"
	$"1400 CECE 0000 CECE 00CE CE00 00CE CE00 CECE 00CE CE00 FECE 0300 CECE 00FE CE00"
	$"00FE CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0800 00CE CE00 00CE CE00"
	$"FACE 0000 FECE 0500 CE00 CECE 00FE CE00 00FB CE00 00FE CE0E 00CE CE00 00CE CE00"
	$"00CE CE00 CECE 00FE CE06 00CE CE00 CECE 00F7 CE00 00FE CE04 00CE CE00 00F9 CE07"
	$"0000 CECE 00CE CE00 FECE 0000 FECE 0400 00CE CE00 FACE 0000 FECE 0200 CE00 FECE"
	$"0000 FECE 0100 00FE CE00 00FE CE01 0000 FECE 0000 FECE 0000 FCCE 0000 FECE 0300"
	$"CECE 00FE CE14 00CE CE00 00CE CE00 CECE 0000 CECE 00CE CE00 CECE 00FE CE03 00CE"
	$"CE00 FECE 0000 FECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE0B 00CE CE00 00CE CE00"
	$"00CE CE00 FECE 0300 CECE 00FB CE00 00FE CE07 00CE CE00 CECE 0000 FECE 0000 FACE"
	$"0000 FECE 0700 CECE 0000 CECE 00F1 CEEF CF0D 00CF CF00 00CF CF00 CFCF 00CF CF00"
	$"FECF 0000 FBCF 0300 CFCF 00FE CF0C 00CF CF00 CFCF 0000 CF00 CFCF 00FE CF07 0000"
	$"CFCF 00CF CF00 FECF 0300 CFCF 00FE CF14 00CF CF00 00CF CF00 CFCF 0000 CFCF 00CF"
	$"CF00 CFCF 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FBCF 0000 FECF 0300 CFCF 00FE"
	$"CF00 00FE CF08 0000 CFCF 0000 CFCF 00FA CF00 00FE CF05 00CF 00CF CF00 FECF 0000"
	$"FBCF 0000 FECF 0E00 CFCF 0000 CFCF 0000 CFCF 00CF CF00 FECF 0600 CFCF 00CF CF00"
	$"F7CF 0000 FECF 0400 CFCF 0000 F9CF 0700 00CF CF00 CFCF 00FE CF00 00FE CF04 0000"
	$"CFCF 00FA CF00 00FE CF02 00CF 00FE CF00 00FE CF01 0000 FECF 0000 FECF 0100 00FE"
	$"CF00 00FE CF00 00FC CF00 00FE CF03 00CF CF00 FECF 1400 CFCF 0000 CFCF 00CF CF00"
	$"00CF CF00 CFCF 00CF CF00 FECF 0300 CFCF 00FE CF00 00FE CF00 00FB CF00 00FE CF03"
	$"00CF CF00 FECF 0B00 CFCF 0000 CFCF 0000 CFCF 00FE CF03 00CF CF00 FBCF 0000 FECF"
	$"0700 CFCF 00CF CF00 00FE CF00 00FA CF00 00FE CF07 00CF CF00 00CF CF00 F1CF EFCE"
	$"0DFF CECE FFFF CECE FFCE CEFF CECE FFFE CE00 FFFB CE03 FFCE CEFF FECE 0CFF CECE"
	$"FFCE CEFF FFCE FFCE CEFF FECE 07FF FFCE CEFF CECE FFFE CE03 FFCE CEFF FECE 14FF"
	$"CECE FFFF CECE FFCE CEFF FFCE CEFF CECE FFCE CEFF FECE 03FF CECE FFFE CE00 FFFE"
	$"CE00 FFFB CE00 FFFE CE03 FFCE CEFF FECE 00FF FECE 08FF FFCE CEFF FFCE CEFF FACE"
	$"0000 FECE 0500 CE00 CECE 00FE CE00 00FB CE00 00FE CE0E 00CE CE00 00CE CE00 00CE"
	$"CE00 CECE 00FE CE06 00CE CE00 CECE 00F7 CE00 00FE CE04 00CE CE00 00F9 CE07 FFFF"
	$"CECE FFCE CEFF FECE 00FF FECE 04FF FFCE CEFF FACE 00FF FECE 02FF CEFF FECE 00FF"
	$"FECE 01FF FFFE CE00 FFFE CE01 FFFF FECE 00FF FECE 00FF FCCE 00FF FECE 03FF CECE"
	$"FFFE CE14 FFCE CEFF FFCE CEFF CECE FFFF CECE FFCE CEFF CECE FFFE CE03 FFCE CEFF"
	$"FECE 00FF FECE 00FF FBCE 00FF FECE 03FF CECE FFFE CE0B FFCE CEFF FFCE CEFF FFCE"
	$"CEFF FECE 03FF CECE FFFB CE00 FFFE CE07 FFCE CEFF CECE FFFF FECE 00FF FACE 0000"
	$"FECE 0700 CECE 0000 CECE 00F1 CE03 DEEF CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"FECE 0000 FBCE 0300 CECE 00FE CE03 00CE CE00 FECE 0400 CE00 CE00 FCCE 0600 CECE"
	$"00CE CE00 FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"FBCE 0000 FECE 0000 F7CE 0000 FBCE 0000 FECE 0000 FECE 0000 FECE 0000 FECE 0000"
	$"F9CE 0500 CE00 CECE 00FB CE00 00FB CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000"
	$"FBCE 0600 CECE 00CE CE00 F7CE 0000 FECE 0300 CECE 00F8 CE00 00FE CE03 00CE CE00"
	$"FECE 0000 FECE 0000 FECE 0000 FBCE 0000 FECE 0000 FECE 1800 CE00 CE00 CE00 CECE"
	$"00CE 00CE 00CE 00CE CE00 CE00 CE00 CE00 FBCE 0000 FBCE 0000 FECE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FBCE 0000 FECE 0000 F7CE 0000 FBCE 0000"
	$"FECE 0300 CECE 00FE CE00 00FE CE03 00CE CE00 FECE 0000 FBCE 0000 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 F9CE 0000 FECE 0300 CECE 00FE CE00 00F1 CEEF CF03 00CF CF00"
	$"FECF 0600 CFCF 00CF CF00 FECF 0000 FBCF 0300 CFCF 00FE CF03 00CF CF00 FECF 0400"
	$"CF00 CF00 FCCF 0600 CFCF 00CF CF00 FBCF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FECF 0600 CFCF 00CF CF00 FBCF 0000 FECF 0000 F7CF 0000 FBCF 0000 FECF 0000 FECF"
	$"0000 FECF 0000 FECF 0000 F9CF 0500 CF00 CFCF 00FB CF00 00FB CF00 00FE CF03 00CF"
	$"CF00 FECF 0000 FECF 0000 FBCF 0600 CFCF 00CF CF00 F7CF 0000 FECF 0300 CFCF 00F8"
	$"CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0000 FBCF 0000 FECF 0000 FECF"
	$"1800 CF00 CF00 CF00 CFCF 00CF 00CF 00CF 00CF CF00 CF00 CF00 CF00 FBCF 0000 FBCF"
	$"0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 FBCF 0000 FECF"
	$"0000 F7CF 0000 FBCF 0000 FECF 0300 CFCF 00FE CF00 00FE CF03 00CF CF00 FECF 0000"
	$"FBCF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 F9CF 0000 FECF 0300 CFCF 00FE CF00"
	$"00F1 CFEF CE03 FFCE CEFF FECE 06FF CECE FFCE CEFF FECE 00FF FBCE 03FF CECE FFFE"
	$"CE03 FFCE CEFF FECE 04FF CEFF CEFF FCCE 06FF CECE FFCE CEFF FBCE 00FF FECE 03FF"
	$"CECE FFFE CE03 FFCE CEFF FECE 06FF CECE FFCE CEFF FBCE 00FF FECE 00FF F7CE 00FF"
	$"FBCE 00FF FECE 00FF FECE 00FF FECE 00FF FECE 00FF F9CE 0500 CE00 CECE 00FB CE00"
	$"00FB CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0000 FBCE 0600 CECE 00CE CE00 F7CE"
	$"0000 FECE 0300 CECE 00F8 CE00 FFFE CE03 FFCE CEFF FECE 00FF FECE 00FF FECE 00FF"
	$"FBCE 00FF FECE 00FF FECE 18FF CEFF CEFF CEFF CECE FFCE FFCE FFCE FFCE CEFF CEFF"
	$"CEFF CEFF FBCE 00FF FBCE 00FF FECE 03FF CECE FFFE CE03 FFCE CEFF FECE 06FF CECE"
	$"FFCE CEFF FBCE 00FF FECE 00FF F7CE 00FF FBCE 00FF FECE 03FF CECE FFFE CE00 FFFE"
	$"CE03 FFCE CEFF FECE 00FF FBCE 00FF FECE 03FF CECE FFFE CE03 FFCE CEFF F9CE 0000"
	$"FECE 0300 CECE 00FE CE00 00F1 CE03 DEEF CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"FECE 0100 CEFE 0004 CECE 00CE CEFC 0002 CECE 00FE CE04 00CE 00CE 00FD CE00 00FE"
	$"CE00 00FE CEFE 00FE CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00"
	$"FECE FE00 FECE 0000 FDCE FE00 FACE 0000 FBCE 0000 FECE 0000 FECE 0000 FECE 0000"
	$"FECE 0000 F9CE 0500 CE00 CECE 00FE CEFD 00FB CEFC 0002 CECE 00FE CE00 00FE CE00"
	$"00FE CEFD 0005 CECE 00CE CE00 F7CE 0000 FECE 0300 CECE 00F8 CE00 00FE CE03 00CE"
	$"CE00 FECE 0000 FECE 0000 FECE 0000 FBCE 0000 FECE 0000 FECE 1800 CE00 CE00 CE00"
	$"CECE 00CE 00CE 00CE 00CE CE00 CE00 CE00 CE00 FACE FE00 FECE 0000 FECE 0300 CECE"
	$"00FE CE03 00CE CE00 FECE 0300 CECE 00FE CEFE 00FE CE00 00FD CEFE 00FA CE00 00FB"
	$"CE00 00FE CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00 00FB CEFC 0002 CECE"
	$"00FE CE03 00CE CE00 F9CE 0000 FECE 0300 CECE 00FE CE00 00F1 CEEF CF03 00CF CF00"
	$"FECF 0600 CFCF 00CF CF00 FECF 0100 CFFE 0004 CFCF 00CF CFFC 0002 CFCF 00FE CF04"
	$"00CF 00CF 00FD CF00 00FE CF00 00FE CFFE 00FE CF00 00FE CF03 00CF CF00 FECF 0300"
	$"CFCF 00FE CF03 00CF CF00 FECF FE00 FECF 0000 FDCF FE00 FACF 0000 FBCF 0000 FECF"
	$"0000 FECF 0000 FECF 0000 FECF 0000 F9CF 0500 CF00 CFCF 00FE CFFD 00FB CFFC 0002"
	$"CFCF 00FE CF00 00FE CF00 00FE CFFD 0005 CFCF 00CF CF00 F7CF 0000 FECF 0300 CFCF"
	$"00F8 CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0000 FBCF 0000 FECF 0000"
	$"FECF 1800 CF00 CF00 CF00 CFCF 00CF 00CF 00CF 00CF CF00 CF00 CF00 CF00 FACF FE00"
	$"FECF 0000 FECF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CFFE 00FE CF00"
	$"00FD CFFE 00FA CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE"
	$"CF00 00FB CFFC 0002 CFCF 00FE CF03 00CF CF00 F9CF 0000 FECF 0300 CFCF 00FE CF00"
	$"00F1 CFEF CE03 FFCE CEFF FECE 06FF CECE FFCE CEFF FECE 01FF CEFE FF04 CECE FFCE"
	$"CEFC FF02 CECE FFFE CE04 FFCE FFCE FFFD CE00 FFFE CE00 FFFE CEFE FFFE CE00 FFFE"
	$"CE03 FFCE CEFF FECE 03FF CECE FFFE CE03 FFCE CEFF FECE FEFF FECE 00FF FDCE FEFF"
	$"FACE 00FF FBCE 00FF FECE 00FF FECE 00FF FECE 00FF FECE 00FF F9CE 0500 CE00 CECE"
	$"00FE CEFD 00FB CEFC 0002 CECE 00FE CE00 00FE CE00 00FE CEFD 0005 CECE 00CE CE00"
	$"F7CE 0000 FECE 0300 CECE 00F8 CE00 FFFE CE03 FFCE CEFF FECE 00FF FECE 00FF FECE"
	$"00FF FBCE 00FF FECE 00FF FECE 18FF CEFF CEFF CEFF CECE FFCE FFCE FFCE FFCE CEFF"
	$"CEFF CEFF CEFF FACE FEFF FECE 00FF FECE 03FF CECE FFFE CE03 FFCE CEFF FECE 03FF"
	$"CECE FFFE CEFE FFFE CE00 FFFD CEFE FFFA CE00 FFFB CE00 FFFE CE03 FFCE CEFF FECE"
	$"00FF FECE 03FF CECE FFFE CE00 FFFB CEFC FF02 CECE FFFE CE03 FFCE CEFF F9CE 0000"
	$"FECE 0300 CECE 00FE CE00 00F1 CE03 D2EF CE03 00CE CE00 FECE 0600 CECE 00CE CE00"
	$"FECE 0000 FBCE 0300 CECE 00FB CE00 00FE CE04 00CE 00CE 00FD CE03 00CE CE00 FACE"
	$"0300 CECE 00FE CE03 00CE CE00 FECE 0300 CECE 00FE CE03 00CE CE00 FBCE 0300 CECE"
	$"00FA CE00 00FB CE00 00FB CE00 00FE CE00 00FE CE00 00FE CE00 00FE CE00 00F9 CE08"
	$"00CE 00CE CE00 CECE 00FE CE00 00FB CE00 00FB CE00 00FE CE00 00FE CE03 00CE CE00"
	$"FECE 0600 CECE 00CE CE00 F7CE 0000 FECE 0300 CECE 00F8 CE00 00FE CE03 00CE CE00"
	$"FECE 0000 FECE 0000 FECE 0000 FBCE 0000 FECE 0000 FECE 1800 CE00 CE00 CE00 CECE"
	$"00CE 00CE 00CE 00CE CE00 CE00 CE00 CE00 F7CE 0300 CECE 00FE CE03 00CE CE00 FECE"
	$"0300 CECE 00FE CE03 00CE CE00 FBCE 0300 CECE 00FA CE00 00FB CE00 00FB CE00 00FE"
	$"CE03 00CE CE00 FECE 0000 FECE 0300 CECE 00FE CE00 00FB CE00 00FB CE00 00FE CE03"
	$"00CE CE00 F9CE 0000 FECE 0300 CECE 00FE CE00 00F1 CEEF CF03 00CF CF00 FECF 0600"
	$"CFCF 00CF CF00 FECF 0000 FBCF 0300 CFCF 00FB CF00 00FE CF04 00CF 00CF 00FD CF03"
	$"00CF CF00 FACF 0300 CFCF 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00"
	$"FBCF 0300 CFCF 00FA CF00 00FB CF00 00FB CF00 00FE CF00 00FE CF00 00FE CF00 00FE"
	$"CF00 00F9 CF08 00CF 00CF CF00 CFCF 00FE CF00 00FB CF00 00FB CF00 00FE CF00 00FE"
	$"CF03 00CF CF00 FECF 0600 CFCF 00CF CF00 F7CF 0000 FECF 0300 CFCF 00F8 CF00 00FE"
	$"CF03 00CF CF00 FECF 0000 FECF 0000 FECF 0000 FBCF 0000 FECF 0000 FECF 1800 CF00"
	$"CF00 CF00 CFCF 00CF 00CF 00CF 00CF CF00 CF00 CF00 CF00 F7CF 0300 CFCF 00FE CF03"
	$"00CF CF00 FECF 0300 CFCF 00FE CF03 00CF CF00 FBCF 0300 CFCF 00FA CF00 00FB CF00"
	$"00FB CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0300 CFCF 00FE CF00 00FB CF00 00FB"
	$"CF00 00FE CF03 00CF CF00 F9CF 0000 FECF 0300 CFCF 00FE CF00 00F1 CFEF CE03 FFCE"
	$"CEFF FECE 06FF CECE FFCE CEFF FECE 00FF FBCE 03FF CECE FFFB CE00 FFFE CE04 FFCE"
	$"FFCE FFFD CE03 FFCE CEFF FACE 03FF CECE FFFE CE03 FFCE CEFF FECE 03FF CECE FFFE"
	$"CE03 FFCE CEFF FBCE 03FF CECE FFFA CE00 FFFB CE00 FFFB CE00 FFFE CE00 FFFE CE00"
	$"FFFE CE00 FFFE CE00 FFF9 CE08 00CE 00CE CE00 CECE 00FE CE00 00FB CE00 00FB CE00"
	$"00FE CE00 00FE CE03 00CE CE00 FECE 0600 CECE 00CE CE00 F7CE 0000 FECE 0300 CECE"
	$"00F8 CE00 FFFE CE03 FFCE CEFF FECE 00FF FECE 00FF FECE 00FF FBCE 00FF FECE 00FF"
	$"FECE 18FF CEFF CEFF CEFF CECE FFCE FFCE FFCE FFCE CEFF CEFF CEFF CEFF F7CE 03FF"
	$"CECE FFFE CE03 FFCE CEFF FECE 03FF CECE FFFE CE03 FFCE CEFF FBCE 03FF CECE FFFA"
	$"CE00 FFFB CE00 FFFB CE00 FFFE CE03 FFCE CEFF FECE 00FF FECE 03FF CECE FFFE CE00"
	$"FFFB CE00 FFFB CE00 FFFE CE03 FFCE CEFF F9CE 0000 FECE 0300 CECE 00FE CE00 00F1"
	$"CE04 2FEF CE03 00CE CE00 FECE 0600 CECE 00CE CE00 FECE 0000 FBCE 0300 CECE 00FE"
	$"CE03 00CE CE00 FECE 0400 CE00 CE00 FECE 0400 00CE CE00 FECE 0000 FECE 0300 CECE"
	$"00FE CE0A 00CE CE00 00CE CE00 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00"
	$"FECE 0000 FECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE00 00FE CE00 00FE CE00 00FE"
	$"CE00 00F8 CE00 00FE CE07 00CE CE00 CECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE00"
	$"00FE CE0D 00CE CE00 CECE 0000 CECE 00CE CE00 F7CE 0000 FECE 0300 CECE 00F8 CE00"
	$"00FE CE03 00CE CE00 FECE 0000 FECE 0400 00CE CE00 FCCE 0000 FECE 0000 FCCE 0000"
	$"FECE 0000 FDCE 0000 FECE 0000 FDCE 0000 FECE 0000 FACE 0000 FECE 0300 CECE 00FE"
	$"CE0A 00CE CE00 00CE CE00 CECE 00FE CE06 00CE CE00 CECE 00FE CE03 00CE CE00 FECE"
	$"0000 FECE 0000 FBCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 FECE 0000 FECE 0200"
	$"CE00 FDCE 0000 FBCE 0000 FECE 0300 CECE 00FE CE02 00CE 00F8 CE00 00FE CE03 00CE"
	$"CE00 FECE 0000 F1CE EFCF 0300 CFCF 00FE CF06 00CF CF00 CFCF 00FE CF00 00FB CF03"
	$"00CF CF00 FECF 0300 CFCF 00FE CF04 00CF 00CF 00FE CF04 0000 CFCF 00FE CF00 00FE"
	$"CF03 00CF CF00 FECF 0A00 CFCF 0000 CFCF 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF"
	$"0300 CFCF 00FE CF00 00FE CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0000 FECF 0000"
	$"FECF 0000 FECF 0000 F8CF 0000 FECF 0700 CFCF 00CF CF00 00FB CF00 00FE CF03 00CF"
	$"CF00 FECF 0000 FECF 0D00 CFCF 00CF CF00 00CF CF00 CFCF 00F7 CF00 00FE CF03 00CF"
	$"CF00 F8CF 0000 FECF 0300 CFCF 00FE CF00 00FE CF04 0000 CFCF 00FC CF00 00FE CF00"
	$"00FC CF00 00FE CF00 00FD CF00 00FE CF00 00FD CF00 00FE CF00 00FA CF00 00FE CF03"
	$"00CF CF00 FECF 0A00 CFCF 0000 CFCF 00CF CF00 FECF 0600 CFCF 00CF CF00 FECF 0300"
	$"CFCF 00FE CF00 00FE CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00FE CF00"
	$"00FE CF02 00CF 00FD CF00 00FB CF00 00FE CF03 00CF CF00 FECF 0200 CF00 F8CF 0000"
	$"FECF 0300 CFCF 00FE CF00 00F1 CFEF CE03 FFCE CEFF FECE 06FF CECE FFCE CEFF FECE"
	$"00FF FBCE 03FF CECE FFFE CE03 FFCE CEFF FECE 04FF CEFF CEFF FECE 04FF FFCE CEFF"
	$"FECE 00FF FECE 03FF CECE FFFE CE0A FFCE CEFF FFCE CEFF CECE FFFE CE06 FFCE CEFF"
	$"CECE FFFE CE03 FFCE CEFF FECE 00FF FECE 00FF FBCE 00FF FECE 03FF CECE FFFE CE00"
	$"FFFE CE00 FFFE CE00 FFFE CE00 FFF8 CE00 00FE CE07 00CE CE00 CECE 0000 FBCE 0000"
	$"FECE 0300 CECE 00FE CE00 00FE CE0D 00CE CE00 CECE 0000 CECE 00CE CE00 F7CE 0000"
	$"FECE 0300 CECE 00F8 CE00 FFFE CE03 FFCE CEFF FECE 00FF FECE 04FF FFCE CEFF FCCE"
	$"00FF FECE 00FF FCCE 00FF FECE 00FF FDCE 00FF FECE 00FF FDCE 00FF FECE 00FF FACE"
	$"00FF FECE 03FF CECE FFFE CE0A FFCE CEFF FFCE CEFF CECE FFFE CE06 FFCE CEFF CECE"
	$"FFFE CE03 FFCE CEFF FECE 00FF FECE 00FF FBCE 00FF FECE 03FF CECE FFFE CE03 FFCE"
	$"CEFF FECE 00FF FECE 02FF CEFF FDCE 00FF FBCE 00FF FECE 03FF CECE FFFE CE02 FFCE"
	$"FFF8 CE00 00FE CE03 00CE CE00 FECE 0000 F1CE 03B4 EFCE 0300 CECE 00FE CE03 00CE"
	$"CE00 FECE FE00 FACE 0000 FECE FE00 FDCE FD00 03CE 00CE CEFE 0000 CEFE 00FC CEFE"
	$"00FD CEFE 00FE CE03 00CE 0000 FECE 0000 FECE 0300 CECE 00FE CEFE 00FE CE01 0000"
	$"FECE FE00 FECE 0000 FDCE FE00 FDCE FE00 FDCE 0000 FECE 0000 FECE 0000 F8CE 0000"
	$"FECE 0000 FECE 0300 00CE 00FA CEFE 00FE CE00 00FE CE00 00FE CE00 00FE CE09 0000"
	$"CE00 CECE 00CE CE00 FECE 0000 FACE FE00 FECE 0000 F8CE 0000 FECE 0E00 CECE 0000"
	$"CECE 0000 CECE 00CE 0000 FECE 0300 CECE 00FE CE00 00FC CE00 00FE CE00 00FD CE00"
	$"00FE CE00 00FD CE00 00FE CE00 00FE CE00 00FD CEFE 00FD CEFE 00FE CE03 00CE 0000"
	$"FECE 0000 FECE 0300 CECE 00FE CEFE 00FE CE01 0000 FECE FE00 FECE 0000 FDCE FE00"
	$"FDCE FE00 FECE 0000 FECE 0000 FECE 0200 CE00 FDCE FB00 01CE CEFE 00FD CEFD 0001"
	$"CE00 F7CE FE00 FECE 0000 FECE 0000 F1CE EFCF 0300 CFCF 00FE CF03 00CF CF00 FECF"
	$"FE00 FACF 0000 FECF FE00 FDCF FD00 03CF 00CF CFFE 0000 CFFE 00FC CFFE 00FD CFFE"
	$"00FE CF03 00CF 0000 FECF 0000 FECF 0300 CFCF 00FE CFFE 00FE CF01 0000 FECF FE00"
	$"FECF 0000 FDCF FE00 FDCF FE00 FDCF 0000 FECF 0000 FECF 0000 F8CF 0000 FECF 0000"
	$"FECF 0300 00CF 00FA CFFE 00FE CF00 00FE CF00 00FE CF00 00FE CF09 0000 CF00 CFCF"
	$"00CF CF00 FECF 0000 FACF FE00 FECF 0000 F8CF 0000 FECF 0E00 CFCF 0000 CFCF 0000"
	$"CFCF 00CF 0000 FECF 0300 CFCF 00FE CF00 00FC CF00 00FE CF00 00FD CF00 00FE CF00"
	$"00FD CF00 00FE CF00 00FE CF00 00FD CFFE 00FD CFFE 00FE CF03 00CF 0000 FECF 0000"
	$"FECF 0300 CFCF 00FE CFFE 00FE CF01 0000 FECF FE00 FECF 0000 FDCF FE00 FDCF FE00"
	$"FECF 0000 FECF 0000 FECF 0200 CF00 FDCF FB00 01CF CFFE 00FD CFFD 0001 CF00 F7CF"
	$"FE00 FECF 0000 FECF 0000 F1CF EFCE 03FF CECE FFFE CE03 FFCE CEFF FECE FEFF FACE"
	$"00FF FECE FEFF FDCE FDFF 03CE FFCE CEFE FF00 CEFE FFFC CEFE FFFD CEFE FFFE CE03"
	$"FFCE FFFF FECE 00FF FECE 03FF CECE FFFE CEFE FFFE CE01 FFFF FECE FEFF FECE 00FF"
	$"FDCE FEFF FDCE FEFF FDCE 00FF FECE 00FF FECE 00FF F8CE 0000 FECE 0000 FECE 0300"
	$"00CE 00FA CEFE 00FE CE00 00FE CE00 00FE CE00 00FE CE09 0000 CE00 CECE 00CE CE00"
	$"FECE 0000 FACE FE00 FECE 0000 F8CE 00FF FECE 0EFF CECE FFFF CECE FFFF CECE FFCE"
	$"FFFF FECE 03FF CECE FFFE CE00 FFFC CE00 FFFE CE00 FFFD CE00 FFFE CE00 FFFD CE00"
	$"FFFE CE00 FFFE CE00 FFFD CEFE FFFD CEFE FFFE CE03 FFCE FFFF FECE 00FF FECE 03FF"
	$"CECE FFFE CEFE FFFE CE01 FFFF FECE FEFF FECE 00FF FDCE FEFF FDCE FEFF FECE 00FF"
	$"FECE 00FF FECE 02FF CEFF FDCE FBFF 01CE CEFE FFFD CEFD FF01 CEFF F7CE FE00 FECE"
	$"0000 FECE 0000 F1CE 004E C6CE 0000 F8CE 0000 F1CE 0000 88CE 0000 DBCE 0000 C2CE"
	$"0000 84CE C6CF 0000 F8CF 0000 F1CF 0000 88CF 0000 DBCF 0000 C2CF 0000 84CF C6CE"
	$"00FF F8CE 00FF F1CE 00FF 88CE 0000 DBCE 00FF C2CE 00FF 84CE 0051 C5CE 0000 FBCE"
	$"0100 00F0 CE00 0088 CE00 00DB CE00 00C2 CE00 0084 CEC5 CF00 00FB CF01 0000 F0CF"
	$"0000 88CF 0000 DBCF 0000 C2CF 0000 84CF C5CE 00FF FBCE 01FF FFF0 CE00 FF88 CE00"
	$"00DB CE00 FFC2 CE00 FF84 CE00 3CC4 CEFB 00EE CE00 0081 CEE1 CE00 00C2 CE00 0084"
	$"CEC4 CFFB 00EE CF00 0081 CFE1 CF00 00C2 CF00 0084 CFC4 CEFB FFEE CE00 FF81 CEE1"
	$"CE00 FFC2 CE00 FF84 CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81"
	$"CECC CE00 1881 CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 1881"
	$"CE81 CE81 CECC CE81 CF81 CF81 CFCC CF81 CE81 CE81 CECC CE00 2AEB CE00 00E0 CE00"
	$"0081 CE81 CE85 CEEB CF00 00E0 CF00 0081 CF81 CF85 CFEB CE00 00E0 CE00 0081 CE81"
	$"CE85 CE00 36EF CE00 00FE CE00 00E0 CE00 0081 CE81 CE85 CEEF CF00 00FE CF00 00E0"
	$"CF00 0081 CF81 CF85 CFEF CE00 00FE CE00 00E0 CE00 0081 CE81 CE85 CE00 F6EF CE00"
	$"00FE CE00 00E0 CE00 0081 CE9B CE00 FFF3 CE00 9CF4 CE00 9CFE CE00 FFFB CE00 9CF0"
	$"CE00 9CFC CE00 FFFE CE00 9CEB CE04 9CCE CEFF 9CFD CE00 FFF5 CE00 FFFA CE00 9CFB"
	$"CE00 9CEC CEEF CF00 00FE CF00 00E0 CF00 0081 CF9B CF00 FFFB CF00 FFFE CF00 FFFB"
	$"CF04 FFCF FFCF FFFE CF00 FFFE CF06 FFCF CFFF CFCF FFF9 CFFE FFFE CF02 FFCF FFF7"
	$"CF00 FFFD CF04 FFCF FFCF FFFE CF00 FFFD CF04 FFFF CFCF FFFA CF00 FFFD CF04 FFFF"
	$"CFCF FFFE CF07 FFCF CFFF CFCF FFFF F3CF 00FF EDCF EFCE 0000 FECE 0000 E0CE 0000"
	$"81CE 9BCE 03FF CECE FFE5 CE01 FFFF E3CE 00FF F7CE 01FF FFF7 CE00 FFFB CE00 FFFC"
	$"CE00 FFFC CE02 FFCE FFFD CE00 FFEF CE00 FFF0 CE01 C2F0 CEFE 0005 CECE 00CE 0000"
	$"FDCE FE00 FBCE 0000 FECE 0000 FECE 0200 CECE FE00 FECE 0300 CE00 0081 CE9E CE00"
	$"FFFA CEFE FF05 CECE 9CCE CEFF FBCE 019C FFFE CE10 FFFF 9CFF CECE 9C9C CECE 9C9C"
	$"FF9C 9CCE 9CFE CE0E FFCE 9CFF FFCE FFCE 9CCE FFCE CE9C FFFE CE00 9CFA CEFE 9C03"
	$"FFCE 9C9C FECE 119C CECE FFCE CE9C FF9C CECE FF9C CE9C CECE FFFE CE01 9CFF FECE"
	$"0C9C CEFF CE9C FF9C CE9C CECE FF9C FECE 029C FFCE FEFF 03CE CE9C FFF3 CEF0 CFFE"
	$"0005 CFCF 00CF 0000 FDCF FE00 FBCF 0000 FECF 0000 FECF 0200 CFCF FE00 FECF 0300"
	$"CF00 0081 CF9E CF00 FFFC CF01 FFCF FEFF FCCF 01FF FFFB CF02 FFCF CFFE FF05 CFFF"
	$"CFCF 9A9A FDCF 01FF 9AFB CF06 FFCF CFFF FFCF FFFE CF00 FFFE CF00 FFFA CF00 FFFD"
	$"CFFE FFF8 CF08 FFFF CFCF FFCF FFCF FFFC CF00 FFFD CF02 FFCF FFFE CF03 FFCF 9AFF"
	$"F6CF 01FF CFFE FF03 CFFF CFFF F3CF F0CE FE00 05CE CE00 CE00 00FD CEFE 00FB CE00"
	$"00FE CE00 00FE CE02 00CE CEFE 00FE CE03 00CE 0000 81CE 9ECE 00FF FACE FEFF FCCE"
	$"00FF FDCE 0EFF CECE FFCE FFCE FFFF CEFF CECE 9C9C FDCE 01FF 9CFB CE06 FFCE CEFF"
	$"FFCE FFFE CE00 FFFE CE00 FFF3 CE00 FFF8 CE00 FFFE CE00 FFFE CE00 FFFC CE00 FFFD"
	$"CE00 FFFC CE03 FFCE 9CFF F6CE 01FF CEFE FFFE CE00 FFF3 CE01 9BEF CE00 00FE CE07"
	$"0000 CECE 00CE CE00 FECE 0000 FCCE 0000 FECE 0000 FECE 0200 CE00 FECE 0700 CECE"
	$"0000 CECE 0081 CE9F CE04 FF9C 9CCE 9CFE CEFD 9C04 CE9C CECE 9CFE CE00 9CFE CE00"
	$"9CFE CE04 9CCE CE9C 9CFD CE00 9CFC CE00 9CFE CE01 9C9C FECE FE9C FDCE 089C 9CCE"
	$"9CCE 9C9C CE9C FECE 009C FECE FE9C 01CE CEFD 9CFE CE02 9CCE 9CFE CE03 9CCE 9C9C"
	$"FDCE 059C CECE 9CFF 9CFD CEFE 9CF6 CE03 9CCE 9CCE FE9C FECE 009C F3CE EFCF 0000"
	$"FECF 0700 00CF CF00 CFCF 00FE CF00 00FC CF00 00FE CF00 00FE CF02 00CF 00FE CF07"
	$"00CF CF00 00CF CF00 81CF 9FCF 00FF FACF 059A 9ACF 9ACF 9AF0 CF00 9AF6 CF00 9AFD"
	$"CF00 9AFE CF02 9ACF 9AFC CF00 9AFD CF00 9AF8 CFFE 9A05 CFCF 9ACF 9A9A F8CF 039A"
	$"CF9A 9AFD CF00 9AFE CF00 FFFB CF00 9AF9 CF00 FFFA CF00 9AED CFEF CE00 00FE CE07"
	$"0000 CECE 00CE CE00 FECE 0000 FCCE 0000 FECE 0000 FECE 0200 CE00 FECE 0700 CECE"
	$"0000 CECE 0081 CE9F CE00 FFFA CE05 9C9C CE9C CE9C F0CE 009C F6CE 009C FDCE 009C"
	$"FECE 029C CE9C FCCE 009C FDCE 009C F8CE FE9C 05CE CE9C CE9C 9CFA CE05 9CCE 9CCE"
	$"9C9C FDCE 009C FECE 00FF FBCE 009C F1CE 009C EDCE 01BA EFCE 0000 FECE 0000 FECE"
	$"0300 CECE 00FE CE00 00FB CE09 00CE 00CE 00CE 00CE CE00 FECE 0300 CECE 00FE CE00"
	$"0081 CE9F CE06 FFCE CE9C CE9C CEFD 9C04 CE9C CE9C 9CFE CE04 9C9C CE9C CEFE 9C04"
	$"CE9C 9CCE 9CFC CEFD 9C02 CECE 9CFD CEFA 9C01 CECE FD9C 0BCE 9CCE 9C9C CE9C 9CCE"
	$"CE9C CEFC 9CFE CEFD 9C16 CECE 9CCE 9CCE CE9C 9CCE 9CCE 9CCE 9C9C CECE 9CCE 9C9C"
	$"CEFE 9C06 CE9C CECE 9CCE CEFE 9C00 CEFD 9C02 CE9C CEFC 9C01 CE9C F3CE EFCF 0000"
	$"FECF 0000 FECF 0300 CFCF 00FE CF00 00FB CF09 00CF 00CF 00CF 00CF CF00 FECF 0300"
	$"CFCF 00FE CF00 0081 CF9F CF05 FF9A 9ACF CF9A FACF 149A CFCF 9ACF CF9A CF9A 9ACF"
	$"CF9A CF9A CFCF 9ACF CF9A FBCF 009A FDCF 1D9A 9ACF CF9A CF9A 9ACF 9ACF CF9A CFCF"
	$"9ACF CF9A CF9A CFCF 9ACF CF9A CF9A 9AFC CF01 9ACF FE9A 01CF 9AFC CF02 9ACF 9AFE"
	$"CF0D 9ACF CF9A CFCF 9ACF 9A9A CF9A CF9A FECF 009A FCCF 009A FACF 069A CFCF 9A9A"
	$"CF9A F3CF EFCE 0000 FECE 0000 FECE 0300 CECE 00FE CE00 00FB CE09 00CE 00CE 00CE"
	$"00CE CE00 FECE 0300 CECE 00FE CE00 0081 CE9F CE00 FFFD CE00 9CF4 CE06 9CCE CE9C"
	$"CECE 9CEA CE03 9CCE 9C9C FDCE 039C CECE 9CFD CE00 9CF9 CE00 9CF8 CE00 9CEC CE03"
	$"9CCE CE9C EECE 069C CECE 9CCE CE9C F3CE 01EB EFCE 0000 FECE 0000 FECE 0200 CECE"
	$"FC00 FBCE 0800 CE00 CE00 CE00 CECE FC00 02CE CE00 FECE 0000 81CE 9FCE 00FF FD9C"
	$"01CE 9CFC CE0B 9C9C CECE 9C9C CE9C CE9C CE9C FECE 049C CECE 9CCE FC9C FDCE 029C"
	$"9CCE FD9C 01CE 9CFC CEFE 9C0C CE9C CE9C CE9C 9CCE CE9C CE9C CEFE 9CFD CEFD 9C01"
	$"CECE FE9C 0BCE 9C9C CE9C CE9C 9CCE CE9C CEFD 9C0E CECE 9CCE 9C9C CECE 9CCE 9C9C"
	$"CE9C 9CFE CE01 9CCE FD9C 01CE 9CFC CE00 9CF2 CEEF CF00 00FE CF00 00FE CF02 00CF"
	$"CFFC 00FB CF08 00CF 00CF 00CF 00CF CFFC 0002 CFCF 00FE CF00 0081 CF9F CF1A FFCF"
	$"CF9A 9ACF 9A9A CFCF 9ACF 9ACF 9A9A CF9A CF9A 9ACF CF9A CFCF 9AFE CF03 9ACF 9ACF"
	$"FE9A 09CF 9A9A CF9A 9ACF 9ACF CFFD 9A04 CFCF 9ACF CFFD 9A0E CF9A 9ACF 9ACF CF9A"
	$"CF9A 9ACF 9A9A CFFC 9A01 CF9A FECF 019A CFFE 9A1F CF9A CF9A CF9A CF9A CF9A 9ACF"
	$"9A9A CF9A CF9A 9ACF CF9A CF9A 9ACF 9A9A CF9A 9ACF FC9A 01CF 9AFC CF00 9AF2 CFEF"
	$"CE00 00FE CE00 00FE CE02 00CE CEFC 00FB CE08 00CE 00CE 00CE 00CE CEFC 0002 CECE"
	$"00FE CE00 0081 CE9F CE00 FFFD 9C01 CE9C FECE 019C CEFB 9C0D CE9C 9CCE CE9C CECE"
	$"9C9C CECE 9CCE FC9C 06CE 9C9C CE9C 9CCE FC9C 0BCE 9CCE CE9C CE9C 9CCE 9C9C CEFD"
	$"9C03 CECE 9CCE FC9C 00CE FA9C 01CE CEFD 9C0A CE9C CE9C CECE 9C9C CE9C CEFC 9C11"
	$"CE9C CE9C 9CCE CE9C CE9C 9CCE 9C9C CE9C 9CCE FC9C 01CE 9CFC CE00 9CF2 CE01 C5EF"
	$"CE00 00FE CE00 00FE CE03 00CE CE00 F7CE 0900 CE00 CE00 CE00 CECE 00FB CE00 00FE"
	$"CE00 0081 CE9F CE0B FF9C 9CCE FFFF CEFF CECE FFFF FDCE 009C FDCE FD9C 00CE FEFF"
	$"02CE CEFF F7CE FE9C 01CE CEFE FF02 CECE FFFD CE07 FFCE CE9C CECE FF9C FECE 009C"
	$"FECE 069C CECE 9C9C CECE FCFF 039C CECE FFFE CE02 9CCE FFFD 9C00 CEFD FF0C CEFF"
	$"CE9C FFCE FFCE CE9C CE9C CEFE 9CFD FFF6 CE00 9CF2 CEEF CF00 00FE CF00 00FE CF03"
	$"00CF CF00 F7CF 0900 CF00 CF00 CF00 CFCF 00FB CF00 00FE CF00 0081 CF9F CF00 FFFE"
	$"CF01 FFFF FDCF 01FF FFFB CF00 9AFD CF02 9ACF CFFE FF03 CFCF FF9A FCCF 019A 9AFD"
	$"CF02 9ACF CFFE FF07 CFCF FF9A FFCF CFFF FECF 059A CFFF CFCF FFFE CF00 FFFD CF03"
	$"9A9A CFCF FCFF FECF 00FF FECF 049A CFFF CF9A FECF 0AFF CFFF CFCF FFCF CFFF CFFF"
	$"FBCF 029A CFCF FDFF FECF 019A FFFC CF00 9AF1 CFEF CE00 00FE CE00 00FE CE03 00CE"
	$"CE00 F7CE 0900 CE00 CE00 CE00 CECE 00FB CE00 00FE CE00 0081 CE9F CE00 FFFE CE02"
	$"FFCE FFFE CE01 FFFF FBCE 019C CEFE FF02 CEFF CEFE FF02 CECE FFFB CE05 9C9C CEFF"
	$"CEFF FECE FEFF 02CE CEFF FDCE 05FF CECE 9C9C CEF5 FFFE CEFB FFFE CE00 FFFE CE12"
	$"9C9C FFFF CECE FFCE FFCE FFCE CEFF CECE FFCE FFFE CE04 9CCE FFFF CEFD FFF6 CE01"
	$"9C9C F2CE 01D7 EFCE 0000 FECE 0000 FECE 0300 CECE 00FE CE00 00FA CE00 00FE CE00"
	$"00FE CE00 00FE CE03 00CE CE00 FECE 0000 81CE 9FCE 0BFF 9C9C CEFF FFCE FFCE CEFF"
	$"FFFD CE00 9CFD CEFD 9C00 CEFE FF02 CECE FFF7 CEFE 9C01 CECE FEFF 02CE CEFF FDCE"
	$"07FF CECE 9CCE CEFF 9CFE CE00 9CFE CE06 9CCE CE9C 9CCE CEFC FF03 9CCE CEFF FECE"
	$"029C CEFF FD9C 00CE FDFF 0CCE FFCE 9CFF CEFF CECE 9CCE 9CCE FE9C FDFF F6CE 009C"
	$"F2CE EFCF 0000 FECF 0000 FECF 0300 CFCF 00FE CF00 00FA CF00 00FE CF00 00FE CF00"
	$"00FE CF03 00CF CF00 FECF 0000 81CF 9FCF 00FF FECF 01FF FFFD CF01 FFFF FBCF 009A"
	$"FDCF 029A CFCF FEFF 03CF CFFF 9AFC CF01 9A9A FDCF 029A CFCF FEFF 07CF CFFF 9AFF"
	$"CFCF FFFE CF05 9ACF FFCF CFFF FECF 00FF FDCF 039A 9ACF CFFC FFFE CF00 FFFE CF04"
	$"9ACF FFCF 9AFE CF0A FFCF FFCF CFFF CFCF FFCF FFFB CF02 9ACF CFFD FFFE CF01 9AFF"
	$"FCCF 009A F1CF EFCE 0000 FECE 0000 FECE 0300 CECE 00FE CE00 00FA CE00 00FE CE00"
	$"00FE CE00 00FE CE03 00CE CE00 FECE 0000 81CE 9FCE 00FF FECE 02FF CEFF FECE 01FF"
	$"FFFB CE01 9CCE FEFF 02CE FFCE FEFF 02CE CEFF FBCE 059C 9CCE FFCE FFFE CEFE FF02"
	$"CECE FFFD CE05 FFCE CE9C 9CCE F5FF FECE FBFF FECE 00FF FECE 129C 9CFF FFCE CEFF"
	$"CEFF CEFF CECE FFCE CEFF CEFF FECE 049C CEFF FFCE FDFF F6CE 019C 9CF2 CE01 93EF"
	$"CE04 0000 CECE 00FE CE00 00FE CEFE 00F9 CE00 00FE CE00 00FD CEFE 00FE CEFD 00FE"
	$"CE00 0081 CEA2 CE00 FFFE 9C02 CECE FFFE CEFD 9C00 CEFB 9C00 CEFE 9CFD CE01 9CCE"
	$"FE9C 01CE CEF8 9CFB CEFC 9C02 CE9C CEFB 9C00 CEFE 9C00 CEF9 9CFB CE04 9CCE 9CCE"
	$"CEFC 9C06 FF63 9CCE 9C9C FFFE CE01 9CCE FA9C 00CE FC9C FACE FD9C 01CE CEFD 9CF3"
	$"CEEF CF04 0000 CFCF 00FE CF00 00FE CFFE 00F9 CF00 00FE CF00 00FD CFFE 00FE CFFD"
	$"00FE CF00 0081 CFA2 CF00 FFFC CF00 FFFE CF04 9A9A CF9A CFFE 9AF4 CF00 9AFC CF00"
	$"9AFD CF00 9AF8 CF02 9ACF 9AFD CFFE 9AEB CF0A 9ACF 9ACF CF9A CF9A 9ACF FFFD CF06"
	$"9AFF CFFF CF9A CFFD 9A02 CF9A 9AFB CF01 9A9A FBCF 079A CF9A CFCF 9ACF 9AF2 CFEF"
	$"CE04 0000 CECE 00FE CE00 00FE CEFE 00F9 CE00 00FE CE00 00FD CEFE 00FE CEFD 00FE"
	$"CE00 0081 CEA2 CEFD FF02 CECE FFFE CE02 9C9C CEFB 9C03 FFCE FFCE FEFF FCCE 019C"
	$"9CFE CEFD 9C02 CEFF CEFD FFFC CEFE 9CFD CE05 9C9C CECE FFCE FEFF 05CE FFFF CEFF"
	$"CEFD FFFB CEFD 9C00 CEFD 9CFD FF08 CEFF CEFF FFCE CE9C CEFA 9C04 CECE FFCE FFFD"
	$"CE00 FFFE CE09 9C9C CE9C CECE 9C9C CEFF F3CE 0138 81CE 81CE E2CE 00FF FD9C F7CE"
	$"079C CE9C CECE 9C9C CEFE 9CFB CE00 FFFE CE07 9CCE 9C9C CE9C 9CCE FD9C 08CE CEFF"
	$"CECE FF9C CECE FE9C 0DCE 9CCE 9CCE 9CCE 9C9C CECE 9C9C CEFB 9C01 CE9C FBCE 019C"
	$"CEF7 9CF9 CE06 FF9C 9CCE 9CCE CEFB 9CFC CE08 FF9C CECE 9C9C CE9C 9CF2 CE81 CF81"
	$"CFE2 CF00 FFFC CF03 FFCF FFFF FECF 02FF CF9A F7CF 00FF FECF 02FF CFFF FDCF 009A"
	$"F5CF 04FF CFCF FF9A FECF 009A EECF 009A FECF 01FF FFFD CFFE 9AF9 CF0C 9ACF CFFF"
	$"CFCF FFCF CFFF CF9A 9AFA CF02 9A9A CFFC FF04 9ACF FF9A 9AEF CF81 CE81 CEE2 CE00"
	$"FFFE CE00 FFF7 CEFE 9C08 FFFF CEFF CECE FFCE FFFC CE00 FFFE CE14 9C9C FFFF CEFF"
	$"CEFF FFCE CEFF CECE FFCE CEFF 9CCE CEFE 9CFE FF00 CEFD FF00 CEF7 FFF7 CE0A 9C9C"
	$"FFCE FFCE FFFF CEFF FFFC CE04 FFCE CEFF CEFE 9C01 FFCE FEFF 09CE FFFF CECE FFFF"
	$"CEFF 9CFD CE03 9CFF CEFF F3CE 0114 81CE 81CE E2CE 05FF 9C9C CE9C 9CFD CE07 9CFF"
	$"CEFF CECE 9CCE FA9C 06CE 9C9C FFCE CEFF FCCE F99C 04CE CE9C 9CFF F9CE 039C CE9C"
	$"CEFC 9C11 CE9C CE9C 9CCE 9CCE 9C9C CE9C 9CFF FFCE CEFF FDCE 069C CE9C CE9C 9CCE"
	$"FC9C FCCE 00FF FBCE F89C FACE 00FF FECE 029C CE9C F3CE 81CF 81CF E2CF 00FF F7CF"
	$"FEFF FECF 009A F9CF 059A CFFF FFCF FFF0 CF05 FFCF FFCF CFFF FDCF 009A EDCF 06FF"
	$"FFCF CFFF CFFF F0CF 03FF CFFF FFEE CF02 FFCF FFED CF81 CE81 CEE2 CEFD FFFE CE00"
	$"FFFE CE02 FFCE FFFE CE01 9CCE FCFF 07CE FFCE CEFF CEFF FFFB CEFB FF00 CEFE FF04"
	$"CEFF CECE FFFB CE02 9CFF CEFE FF08 CEFF CEFF FFCE FFCE CEFD FF00 CEFB FFFC CE00"
	$"9CFD FF0B CECE FFFF CECE FFCE CEFF CEFF FACE 04FF CEFF CEFF F7CE 00FF FDCE 00FF"
	$"F2CE 0120 81CE 81CE E2CE 00FF FD9C F4CE 029C 9CCE FB9C FECE 02FF CE9C FCCE 049C"
	$"9CCE 9CCE FC9C F9CE 00FF FECE FE9C 03CE 9CCE CEFE 9C03 CE9C 9CCE FB9C F6CE F89C"
	$"01CE FFF9 CE05 9CCE CE9C 9CCE FC9C 01CE FFF7 CEFE 9CF3 CE81 CF81 CFE2 CF00 FFFE"
	$"CF00 9AF8 CF03 FFCF CFFF FCCF 009A FBCF 00FF FECF 01FF FFF9 CF0C 9ACF CF9A CFCF"
	$"FFCF CFFF CFCF FFF8 CF00 FFFA CF07 FF9A 9ACF CF9A CFFF FCCF 00FF F9CF 009A FDCF"
	$"02FF CFFF F4CF 009A FDCF 00FF E6CF 81CE 81CE E2CE 00FF FACE 01FF FFFD CE00 FFFE"
	$"CE08 FFFF CEFF CEFF CEFF FFFE CE00 FFFC CE00 FFFE CE02 FFCE CEFD FF02 CECE FFFE"
	$"CE12 FFCE CEFF FFCE CEFF FFCE CEFF FFCE FFCE FFFF CEFE FFFE CE03 FFCE CEFF FCCE"
	$"00FF FDCE 01FF CEFE FF05 CECE FFCE CEFF F7CE FEFF FECE 06FF FFCE FFCE CEFF FACE"
	$"FEFF F3CE 015C 81CE 81CE E2CE 00FF FE9C 02FF FFCE FEFF 08CE FFCE FFCE FFFF CECE"
	$"FA9C 07FF FFCE FFCE CEFF FFFE CEFE FFFA 9CFE FF00 CEFD FFFE CE00 FFFE CEFD 9C08"
	$"CE9C CE9C 9CCE 9C9C CEFE 9C02 CEFF FFFE CE08 FFCE CEFF CECE FFCE CEFD 9C09 CE9C"
	$"CEFF FFCE FFFF CEFF FECE 03FF CEFF CEFC 9C07 CECE FFFF CECE FFFF FECE 05FF FFCE"
	$"FFCE 9CF3 CE81 CF81 CFE2 CF00 FFFE CF02 FFFF CFFE FF00 CFFE FF02 CFFF FFFE CF02"
	$"9ACF 9AFE CF04 FFFF CFFF CFFE FF01 CFCF FDFF 01CF 9AFC CFFE FF00 CFFD FF01 CFCF"
	$"FEFF EECF 02FF FFCF FEFF 08CF CFFF CFFF FFCF CF9A FBCF 0CFF FFCF FFFF CFFF CFCF"
	$"FFFF CFFF F9CF 00FF FECF 04FF FFCF FFCF FDFF F1CF 81CE 81CE E2CE FBFF 00CE FAFF"
	$"00CE FEFF 01CE CEFE FF00 CEFB FF00 CEFE FFFE CEFE FF00 CEFE FFFE CEFE FF00 CEFB"
	$"FF07 CEFF FFCE CEFF FFCE F4FF 03CE FFFF CEFB FF02 CEFF FFFE CE08 FFCE CEFF FFCE"
	$"FFFF CEFC FF07 CEFF FFCE FFCE FFCE FEFF 05CE CEFF FFCE CEFE FF00 CEFE FF01 CEFF"
	$"F1CE 0124 81CE 81CE E2CE 05FF 9C9C CE9C FFFD CE00 FFFD CE00 9CFE CEFE 9C0E CE9C"
	$"9CCE 9CFF FFCE CEFF CE9C CECE 9CFE CEFE 9C05 CE9C CECE 9CFF FCCE 13FF CE9C CE9C"
	$"CECE 9CCE 9CCE 9CCE 9C9C CE9C FF9C 9CFD CE0D 9C9C CECE FFFF CECE 9CCE 9C9C CECE"
	$"FB9C 01CE 9CFD CE00 FFFE CE01 9C9C FECE F99C 00FF FACE 009C FDCE 009C F2CE 81CF"
	$"81CF E2CF 00FF FDCF 01FF CFFC FFF2 CF04 FFFF CFCF FFF1 CF01 FFFF FDCF 00FF F6CF"
	$"00FF FDCF 00FF F8CF FEFF 04CF FF9A CF9A F4CF 06FF CFFF FFCF CF9A FDCF 009A FACF"
	$"01FF FFFB CF00 9AED CF81 CE81 CEE2 CEFB FF04 CEFF CECE FFF8 CEFC FF00 CEFE FF02"
	$"CEFF FFF9 CEFD FF00 CEFD FFFE CE02 FFCE FFFB CE02 FFFF CEF8 FF00 CEFE FF03 CEFF"
	$"FFCE FEFF FDCE 009C FECE 0CFF CEFF CEFF FFCE FFCE CEFF CEFF F9CE 049C FFFF CECE"
	$"FDFF F5CE 00FF F2CE 0136 81CE 81CE E2CE 00FF FC9C 00FF FDCE 049C CE9C 9CCE FD9C"
	$"00CE FA9C FDCE 019C CEFA 9C00 CEFA 9CFD CE01 9CCE FE9C 00CE FD9C 05CE 9CCE CE9C"
	$"CEFD 9C00 CEFD 9C01 CE9C FDCE 0A9C CE9C 9CCE 9C9C CE9C 9CCE FD9C FACE 019C CEF3"
	$"9C00 FFFD CE01 9CCE FA9C F3CE 81CF 81CF E2CF 00FF FDCF 019A FFFD CF06 9ACF 9A9A"
	$"CFCF 9AF6 CF00 FFFD CFFD 9AFB CF00 9AFE CF03 9ACF CFFF FDCF 019A 9AF1 CF00 FFF8"
	$"CF05 9ACF 9A9A CF9A FBCF 009A FECF 009A FACF FD9A FACF FE9A FECF 00FF FECF FD9A"
	$"F0CF 81CE 81CE E2CE 00FF FBCE 00FF FECE 0E9C CE9C 9CCE 9C9C FFFF CEFF CEFF CEFF"
	$"FBCE 019C CEFD 9C05 FFFF CEFF CEFF FECE 02FF 9CFF FECE 089C CECE 9C9C CE9C FFCE"
	$"FDFF 04CE FFCE FFCE FAFF 01CE FFFD CE03 9CCE 9CCE FE9C 08FF CEFF CEFF FFCE FFFF"
	$"FDCE 01FF CEFA 9C05 FFFF CEFF FFCE FE9C 06FF CECE FF9C CECE FD9C 02CE FFFF F3CE"
	$"010F 81CE 81CE E2CE 00FF FD9C 01CE 9CFE CE00 9CFC CE02 9C9C CEF8 9CFB CE08 9C9C"
	$"CE9C CECE 9C9C CEFC 9C01 CEFF FACE 079C CE9C CE9C CE9C CEFD 9C04 CE9C CE9C CEFA"
	$"9C00 FFFB CEFE 9C03 CE9C 9CCE FA9C 00FF FBCE 059C CE9C 9CCE CEFB 9C01 CE9C FECE"
	$"02FF CECE FD9C 01CE 9CF2 CE81 CF81 CFE2 CF00 FFEA CF00 9AE7 CF00 FFFC CF01 9A9A"
	$"EBCF FDFF FECF 009A F9CF 009A FDCF 03FF CFCF FFFD CF00 9AFA CF00 9AFA CF00 FFFE"
	$"CF01 9A9A EFCF 81CE 81CE E2CE 06FF CECE FFFF CEFF FACE 029C 9CCE FEFF 07CE FFCE"
	$"CEFF CECE FFF9 CE00 63FA FFFD CE03 FFCE CEFF FCCE 029C 9CCE FCFF 02CE FFCE F6FF"
	$"02CE FFFF FECE 0EFF CECE 9CFF CEFF CEFF CEFF FFCE FFCE FEFF FACE 029C FFCE FCFF"
	$"04CE FFFF CEFF FECE 00FF FACE 01FF FFF3 CE01 0F81 CE81 CEE2 CE00 FFFD 9C01 CE9C"
	$"FECE 009C FCCE 029C 9CCE F89C FBCE 089C 9CCE 9CCE CE9C 9CCE FC9C 01CE FFFA CE07"
	$"9CCE 9CCE 9CCE 9CCE FD9C 04CE 9CCE 9CCE FA9C 00FF FBCE FE9C 03CE 9C9C CEFA 9C00"
	$"FFFB CE05 9CCE 9C9C CECE FB9C 01CE 9CFE CE02 FFCE CEFD 9C01 CE9C F2CE 81CF 81CF"
	$"E2CF 00FF EACF 009A E7CF 00FF FCCF 019A 9AEB CFFD FFFE CF00 9AF9 CF00 9AFD CF03"
	$"FFCF CFFF FDCF 009A FACF 009A FACF 00FF FECF 019A 9AEF CF81 CE81 CEE2 CE06 FFCE"
	$"CEFF FFCE FFFA CE02 9C9C CEFE FF07 CEFF CECE FFCE CEFF F9CE 0063 FAFF FDCE 03FF"
	$"CECE FFFC CE02 9C9C CEFC FF02 CEFF CEF6 FF02 CEFF FFFE CE0E FFCE CE9C FFCE FFCE"
	$"FFCE FFFF CEFF CEFE FFFA CE02 9CFF CEFC FF04 CEFF FFCE FFFE CE00 FFFA CE01 FFFF"
	$"F3CE 0123 81CE 81CE E2CE 06FF 9C9C CECE 9C9C FCCE 049C 9CCE 9CCE FB9C 04CE 9C9C"
	$"CE9C FCCE 009C FECE FB9C 00CE FC9C FBCE 069C CE9C CE9C 9CCE FE9C 08CE CE9C CE9C"
	$"CE9C 9CCE FE9C 04CE 9CCE 9CFF FDCE 029C 9CCE FE9C 00CE FE9C 00CE FC9C FDCE 019C"
	$"CEFE 9C00 CEFC 9C00 CEFC 9CFC CE07 9C9C CECE 9C9C CE9C F3CE 81CF 81CF E2CF 00FF"
	$"F5CF FE9A F3CF 00FF FCCF 009A ECCF 009A F8CF 00FF F6CF 009A FEFF 05CF CF9A CFCF"
	$"9AEF CF00 9AF1 CF00 FFFE CFFD 9AF0 CF81 CE81 CEE2 CE06 FFCE CEFF FFCE FFFB CE03"
	$"9CCE 9CCE FEFF 0ACE FFCE FFCE FFCE FFCE CEFF FCCE 0C9C CEFF FFCE FFCE FFFF CECE"
	$"FFFF F8CE 069C FFCE FFCE FFCE FDFF 04CE FFCE FFCE FBFF 00CE FEFF FCCE 049C FFCE"
	$"FFCE FCFF 02CE CEFF FBCE 079C CE9C CEFF CEFF CEFE FFFE CE03 FFCE CEFF FECE 009C"
	$"FDCE 01FF FFF3 CE01 2681 CE81 CEE2 CE02 FFCE CEFE 9C04 CEFF CECE FFFE CE07 9C9C"
	$"CE9C 9CCE 9CCE FB9C 05FF CEFF FFCE CEFE 9CFE CE02 9C9C CEFB 9C03 FFCE FFFF FECE"
	$"089C 9CCE 9CCE 9C9C CECE FA9C 01CE 9CFE CEFE 9C00 CEFE FFFE CE03 9CCE 9CCE FE9C"
	$"01CE CEFE 9C16 CE9C CEFF CEFF CEFF FF9C 9CCE 9C9C CE9C 9CCE 9C9C CECE 9CFE CE00"
	$"FFFE CE00 9CFD CE01 9C9C F3CE 81CF 81CF E2CF 00FF FBCF FDFF F0CF FCFF F1CF 01FF"
	$"CFFE FF03 CFCF 9A9A EACF FDFF F0CF 01FF CFFD FF03 9ACF CF9A F4CF 01FF FFEA CF81"
	$"CE81 CEE2 CEFD FF00 CEFE FF02 CECE FFFD CE04 9CCE FFCE CEFE FF04 CEFF CEFF CEFD"
	$"FFFD CE01 9CCE FCFF 00CE FEFF 05CE FFFF CEFF FFFE CE03 9CCE 9CCE FBFF 02CE FFCE"
	$"FBFF 03CE CEFF CEFC FFFA CEFC FF02 CEFF CEFD FF00 CEFD FF09 9CCE CE9C CEFF CEFF"
	$"FFCE FCFF 02CE CEFF FACE 01FF FFF2 CE01 4F81 CE81 CEE2 CE0A FF9C 9CCE 9C9C CEFF"
	$"CECE FFFD CE10 9C9C CE9C 9CFF 9CCE 9C9C CE9C CEFF CEFF FFFC CEFD 9C02 CE9C 9CFE"
	$"CE05 9CCE FFFF CEFF FECE FE9C 0DCE 9C9C CE9C 9CCE CE9C CE9C CE9C CEFD 9C03 CECE"
	$"9CCE FEFF FECE FE9C 03CE 9CCE CEFD 9C07 CE9C CE9C FFCE CEFF FECE 069C CE9C CE9C"
	$"9CCE FC9C 01CE 9CFE FFFD CEFD 9C01 CE9C F3CE 81CF 81CF E2CF 00FF FBCF 04FF CFCF"
	$"FFFF FECF 019A 9AFE CF00 FFFA CF03 FFCF FFFF FDCF 009A F5CF 09FF FFCF FFCF FFCF"
	$"CF9A 9AEB CFFE FF03 CFFF CF9A F3CF 08FF FFCF FFCF FFCF 9A9A F5CF FEFF 05CF FFCF"
	$"CF9A 9AEF CF81 CE81 CEE2 CEFE FF02 CEFF CEFC FFFD CE01 9C9C FAFF 07CE FFCE FFFF"
	$"CEFF FFFD CE00 9CFD CEFE FF03 CEFF FFCE FEFF 01CE FFFD CE0A 9C9C FFFF CEFF CEFF"
	$"CEFF CEFB FF00 CEFD FF00 CEFD FF05 CEFF CE9C CECE FEFF 07CE CEFF FFCE FFFF CEFE"
	$"FF01 CEFF FECE 029C 9CCE FDFF 05CE FFCE FFFF CEFD FFFD CE05 9C9C CECE FFFF F3CE"
	$"0117 81CE 81CE E2CE 00FF FD9C 01CE 9CFD FFFD CEFE 9C00 FFFC 9C00 CEFE 9CFD FF01"
	$"CECE F29C 03FF FFCE FFFE CE01 9CCE FE9C 06CE 9CCE 9CCE 9CCE FE9C 03CE 9C9C CEFB"
	$"9CFE FFFE CE04 9CCE CE9C CEFC 9C00 CEFE 9C0B CEFF CEFF CEFF FFCE 9CCE 9CCE FC9C"
	$"00CE FE9C 00CE FEFF FACE FE9C F3CE 81CF 81CF E2CF 00FF FBCF FDFF FDCF 039A CFCF"
	$"FFF8 CFFD FFFD CF00 9AF5 CF03 FFFF CFFF FCCF 009A F4CF 00FF F9CF FDFF F0CF 01FF"
	$"CFFD FF01 CF9A F4CF FEFF 02CF CFFF ECCF 81CE 81CE E2CE FDFF 00CE FBFF FDCE 049C"
	$"CEFF FFCE FEFF 00CE F8FF FECE 019C CEFE FF02 CEFF CEFD FF00 CEFC FFFD CE00 9CFE"
	$"FF02 CEFF CEFD FF09 CEFF CEFF CEFF CECE FFCE FCFF FBCE 01FF CEFE FF01 CECE FBFF"
	$"00CE FDFF FDCE 05FF CEFF CEFF CEF9 FF01 CEFF FCCE 01FF FFF2 CE01 4581 CE81 CEE2"
	$"CE03 FF9C 9CCE FE9C 04FF CECE FFCE FE9C 08CE 9CCE 639C 9CCE 9CCE FD9C 07FF CEFF"
	$"FFCE 9CCE CEFD 9C03 CE9C 9CCE FC9C 0FFF FFCE FFCE CE9C CE9C CECE 9C9C CE9C CEFE"
	$"9C05 CE9C 9CCE 9C9C FECE 039C 9CCE 9CFE FF01 CECE FE9C 04CE CE9C CE9C FECE 049C"
	$"9CCE 9C9C FDFF 10CE 9CCE CE9C CE9C 9CCE 9CCE CE9C CECE 9C9C FEFF FDCE FE9C F0CE"
	$"81CF 81CF E2CF 00FF FBCF 09FF CFCF FFFF CF9A CFCF 9AF6 CF03 FFCF FFFF FDCF 019A"
	$"9AF6 CFFD FFF8 CF00 FFEF CFFE FFFE CF00 9AF3 CFFD FFFD CF02 9A9A FFF5 CF00 FFFB"
	$"CF00 9AF0 CF81 CE81 CEE2 CE02 FFCE CEFE FF0A CEFF CECE FFCE CE9C CECE 9CFE FF0B"
	$"CEFF CEFF FFCE CEFF FFCE FFFF FDCE 039C 9CCE CEFD FFFE CEFD FF01 CEFF FBCE 04FF"
	$"CEFF FFCE FEFF 03CE FFFF CEF9 FF01 CECE FEFF FECE 029C CECE FEFF 00CE FEFF 03CE"
	$"FFCE CEFC FFFD CE01 9CCE FEFF 02CE FFFF FDCE 03FF CECE FFFB CE03 9CCE FFFF F3CE"
	$"0144 81CE 81CE E2CE 02FF CECE FD9C 07FF CECE FFCE CE9C CEFE 9C00 CEFE 9C02 CE9C"
	$"CEFE 9C04 FFCE FFFF CEFE 9C00 CEFE 9C00 CEFE 9C00 CEFD 9C03 FFFF CEFF FDCE 0A9C"
	$"CECE 9C9C CE9C 9CCE CE9C FECE 099C 9CCE 9CCE CE9C CE9C 9CFE FFFE CEFA 9C04 CE9C"
	$"CE9C CEFE 9C03 FFCE FFFF FECE FE9C 05CE 9CCE 9CCE FFFC 9CFD FF01 CECE FB9C F2CE"
	$"81CF 81CF E2CF 00FF FBCF 03FF CFCF FFFD CF01 9A9A F6CF 03FF CFFF FFFD CF00 9AF5"
	$"CF05 FFFF CFFF CFFF F5CF 03FF CFCF FFF7 CFFE FFFE CF02 9ACF 9AF5 CF08 FFCF FFFF"
	$"CFFF CF9A 9AFB CF00 FFFC CFFD FFFC CF00 9AF0 CF81 CE81 CEE2 CEFC FF05 CEFF FFCE"
	$"CEFF FDCE 019C 9CFE FF05 CEFF CEFF FFCE FEFF 02CE FFFF FDCE 009C FDCE 02FF FFCE"
	$"FEFF 07CE FFFF CEFF FFCE FFFE CE02 9CFF CEFC FF00 CEFD FF02 CEFF CEFE FF00 CEFB"
	$"FFFE CE0D 9CCE CEFF FFCE FFCE FFCE FFFF CECE FCFF FECE 029C 9CCE FAFF FECE FCFF"
	$"FACE 00FF F2CE 0137 81CE 81CE E2CE 06FF 9C9C CE9C CE9C FDFF FECE FE9C 03CE 9C9C"
	$"CEFE 9C06 CE9C CECE FFCE FFFC CE00 9CFE CE04 9CCE CE9C CEFE 9C00 CEFE FFFD CE11"
	$"9CCE 9CCE 9CCE 9CCE 9CCE 9CCE CE9C 9CCE CE9C FECE 039C CE9C 9CFE FF05 CE9C CE9C"
	$"CE9C FECE 00FF FE9C 07CE 9CCE CE9C FFCE FFFB CE06 9CFF 9C9C CE9C 9CFD CE00 9CFE"
	$"FF02 CEFF 9CFE CE03 9C9C CE9C F3CE 81CF 81CF E2CF FEFF FDCF FCFF FECF 009A FACF"
	$"00FF FDCF 03FF CFFF FFF5 CF00 FFFD CFFD FFFC CF01 9AFF F8CF 00FF FCCF 01FF FFFD"
	$"CFFD FFFE CF00 9AFD CF00 FFF9 CF03 FFCF FFFF FCCF 019A FFF7 CFFC FFEB CF81 CE81"
	$"CEE2 CEFE FF00 CEFA FFFD CE07 9CCE CEFF CEFF FFCE FDFF 03CE FFCE FFFC CE01 9CCE"
	$"FAFF 01CE CEFB FFFC CE00 9CFC FF00 CEFD FF00 CEF7 FF00 CEFE FFFB CE01 FFCE FBFF"
	$"07CE FFFF CEFF CEFF FFFB CE02 FFFF CEFA FF00 CEFE FF01 CEFF FCCE 01FF FFF2 CE02"
	$"AAEE CEFD 00EC CE00 00FD CE01 0000 F7CE 0000 FDCE 0000 FCCE 0100 00FE CEFE 0001"
	$"CECE FE00 FDCE 0000 FCCE FE00 01CE CEFE 0001 CECE FE00 03CE CE00 00FC CEFE 00F7"
	$"CE01 0000 FDCE 0000 F8CE FE00 FCCE 0100 00F9 CE00 00F0 CEFE 00EF CE00 00FE CEFD"
	$"0001 CECE FC00 02CE CE00 FDCE 0100 00F6 CEFC 00E7 CE01 0000 F1CE 00FF FB9C 03FF"
	$"CECE FFFE CE02 9C9C CEFB 9C00 CEFD 9CFE FFFE CE1E 9C9C CECE 9C9C FF9C CE9C CE9C"
	$"9CCE 9CFF CEFF FFCE FFCE 9CCE 9C9C CE9C CE9C 9CFE CEFE 9C01 FF9C FDCE 039C CE9C"
	$"9CFE FF04 CECE 9C9C CEFE 9C06 FF9C 9CCE 9C9C CEFE 9CFE FF14 CEFF CE9C CECE 9C9C"
	$"CE9C 9CCE 9C9C CECE 9C9C CECE FFFD CE05 9C9C CE9C CE9C F3CE EECF FD00 ECCF 0000"
	$"FDCF 0100 00F7 CF00 00FD CF00 00FC CF01 0000 FECF FE00 01CF CFFE 00FD CF00 00FC"
	$"CFFE 0001 CFCF FE00 01CF CFFE 0003 CFCF 0000 FCCF FE00 F7CF 0100 00FD CF00 00F8"
	$"CFFE 00FC CF01 0000 F9CF 0000 F0CF FE00 EFCF 0000 FECF FD00 01CF CFFC 0002 CFCF"
	$"00FD CF01 0000 F6CF FC00 E7CF 0100 00F1 CF00 FFFB CF03 FFCF CFFF F0CF FEFF FECF"
	$"019A 9AFD CF00 FFF9 CF05 FFCF FFFF CFFF F5CF 00FF FECF 03FF CFCF FFFB CFFE FF0B"
	$"CFCF 9ACF 9A9A CFCF FFCF CFFF FBCF FEFF 06CF FFFF 9A9A CF9A F4CF 02FF CFFF EBCF"
	$"EECE FD00 ECCE 0000 FDCE 0100 00F7 CE00 00FD CE00 00FC CE01 0000 FECE FE00 01CE"
	$"CEFE 00FD CE00 00FC CEFE 0001 CECE FE00 01CE CEFE 0003 CECE 0000 FCCE FE00 F7CE"
	$"0100 00FD CE00 00F8 CEFE 00FC CE01 0000 F9CE 0000 F0CE FE00 EFCE 0000 FECE FD00"
	$"01CE CEFC 0002 CECE 00FD CE01 0000 F6CE FC00 E7CE 0100 00F1 CEFD FF02 CEFF CEFD"
	$"FFFD CE01 9CCE FBFF 03CE FFCE CEFC FF01 CECE FE9C 00CE FCFF 00CE FEFF 07CE FFFF"
	$"CEFF FFCE FFFE CE06 9CCE FFCE FFFF CEF7 FF05 CECE FFCE FFCE FDFF 05CE 9CCE CE9C"
	$"CEFE FF06 CEFF FFCE FFFF CEFD FF09 CEFF CE9C CE9C 9CFF FFCE FEFF 00CE FDFF 03CE"
	$"CEFF FFFB CE02 FFCE FFF3 CE02 E0EF CE00 00FE CE00 00E6 CE00 00FD CE00 00FD CE00"
	$"00FB CE00 00FC CE03 00CE CE00 FECE 0100 00FE CE04 00CE CE00 00FD CE00 00FE CE01"
	$"0000 FECE 0100 00FE CE03 00CE CE00 FDCE 0300 CECE 00F6 CE00 00F8 CE00 00FE CE03"
	$"00CE CE00 FBCE 0000 FCCE 0000 ECCE 0000 EECE 0000 FDCE 0200 CE00 FECE 0000 FECE"
	$"0000 FACE 0000 FDCE 0000 FACE 0000 FECE 0000 E7CE 0000 F1CE 00FF FB9C 03FF CECE"
	$"FFFE CE02 9C9C CEFB 9C00 CEFD 9CFE FFFE CE1E 9C9C CECE 9C9C FF9C CE9C CE9C 9CCE"
	$"9CFF CEFF FFCE FFCE 9CCE 9C9C CE9C CE9C 9CFE CEFE 9C01 FF9C FDCE 039C CE9C 9CFE"
	$"FF04 CECE 9C9C CEFE 9C06 FF9C 9CCE 9C9C CEFE 9CFE FF14 CEFF CE9C CECE 9C9C CE9C"
	$"9CCE 9C9C CECE 9C9C CECE FFFD CE05 9C9C CE9C CE9C F3CE EFCF 0000 FECF 0000 E6CF"
	$"0000 FDCF 0000 FDCF 0000 FBCF 0000 FCCF 0300 CFCF 00FE CF01 0000 FECF 0400 CFCF"
	$"0000 FDCF 0000 FECF 0100 00FE CF01 0000 FECF 0300 CFCF 00FD CF03 00CF CF00 F6CF"
	$"0000 F8CF 0000 FECF 0300 CFCF 00FB CF00 00FC CF00 00EC CF00 00EE CF00 00FD CF02"
	$"00CF 00FE CF00 00FE CF00 00FA CF00 00FD CF00 00FA CF00 00FE CF00 00E7 CF00 00F1"
	$"CF00 FFFB CF03 FFCF CFFF F0CF FEFF FECF 019A 9AFD CF00 FFF9 CF05 FFCF FFFF CFFF"
	$"F5CF 00FF FECF 03FF CFCF FFFB CFFE FF0B CFCF 9ACF 9A9A CFCF FFCF CFFF FBCF FEFF"
	$"06CF FFFF 9A9A CF9A F4CF 02FF CFFF EBCF EFCE 0000 FECE 0000 E6CE 0000 FDCE 0000"
	$"FDCE 0000 FBCE 0000 FCCE 0300 CECE 00FE CE01 0000 FECE 0400 CECE 0000 FDCE 0000"
	$"FECE 0100 00FE CE01 0000 FECE 0300 CECE 00FD CE03 00CE CE00 F6CE 0000 F8CE 0000"
	$"FECE 0300 CECE 00FB CE00 00FC CE00 00EC CE00 00EE CE00 00FD CE02 00CE 00FE CE00"
	$"00FE CE00 00FA CE00 00FD CE00 00FA CE00 00FE CE00 00E7 CE00 00F1 CEFD FF02 CEFF"
	$"CEFD FFFD CE01 9CCE FBFF 03CE FFCE CEFC FF01 CECE FE9C 00CE FCFF 00CE FEFF 07CE"
	$"FFFF CEFF FFCE FFFE CE06 9CCE FFCE FFFF CEF7 FF05 CECE FFCE FFCE FDFF 05CE 9CCE"
	$"CE9C CEFE FF06 CEFF FFCE FFFF CEFD FF09 CEFF CE9C CE9C 9CFF FFCE FEFF 00CE FDFF"
	$"03CE CEFF FFFB CE02 FFCE FFF3 CE02 B7F0 CE00 00E1 CE00 00FD CE00 00FE CE00 00F9"
	$"CE00 00FD CE03 00CE CE00 FECE 0100 00FE CE04 00CE 00CE 00F9 CE01 0000 FECE 0100"
	$"00FE CE03 00CE CE00 FDCE 0000 F3CE 0000 F8CE 0000 FECE 0000 F8CE 0000 FCCE 0000"
	$"ECCE 0000 EFCE 0200 CE00 FECE 0200 CE00 FECE 0000 FECE 0000 FACE 0000 FDCE 0000"
	$"FACE 0000 FECE 0000 E7CE 0000 F1CE 00FF FDCE 019C 9CFE FFFE CE07 9CCE 9CCE 9CCE"
	$"CE9C FDCE 089C CE9C FFCE FFFF CE9C FECE 009C FECE 029C CE9C FECE 129C CEFF FFCE"
	$"FF9C FFCE 9CCE 9CCE 9C9C CE9C 9CCE FE9C 0BCE 9C9C CEFF 9CCE CE9C CE9C CEFE FFFD"
	$"CE05 9CCE 9CCE CE9C FDCE 0A9C 9CCE 9CFF CEFF FF9C FF9C FECE 069C CECE 9CCE 9CCE"
	$"FD9C FEFF 01CE FFFB CE00 9CF2 CEF0 CF00 00E1 CF00 00FD CF00 00FE CF00 00F9 CF00"
	$"00FD CF03 00CF CF00 FECF 0100 00FE CF04 00CF 00CF 00F9 CF01 0000 FECF 0100 00FE"
	$"CF03 00CF CF00 FDCF 0000 F3CF 0000 F8CF 0000 FECF 0000 F8CF 0000 FCCF 0000 ECCF"
	$"0000 EFCF 0200 CF00 FECF 0200 CF00 FECF 0000 FECF 0000 FACF 0000 FDCF 0000 FACF"
	$"0000 FECF 0000 E7CF 0000 F1CF 03FF CFCF FFFE CFFD FFFE CF01 9A9A FACF 00FF FDCF"
	$"FDFF FDCF 009A FDCF 00FF FACF 09FF FFCF FFCF FFCF 9ACF 9AF3 CF03 FFCF FFFF FDCF"
	$"FEFF FDCF 009A FBCF 00FF FBCF 05FF CFFF FFCF FFFB CF00 FFF9 CFFE FF01 CFFF FCCF"
	$"00FF F1CF F0CE 0000 E1CE 0000 FDCE 0000 FECE 0000 F9CE 0000 FDCE 0300 CECE 00FE"
	$"CE01 0000 FECE 0400 CE00 CE00 F9CE 0100 00FE CE01 0000 FECE 0300 CECE 00FD CE00"
	$"00F3 CE00 00F8 CE00 00FE CE00 00F8 CE00 00FC CE00 00EC CE00 00EF CE02 00CE 00FE"
	$"CE02 00CE 00FE CE00 00FE CE00 00FA CE00 00FD CE00 00FA CE00 00FE CE00 00E7 CE00"
	$"00F1 CEFD FF02 CEFF CEFD FFFD CE02 9CCE CEF9 FF00 CEFC FFFD CE00 9CFE CEFA FF0B"
	$"CEFF FFCE FFFF CEFF CE9C CE9C F9FF 00CE FDFF 00CE FAFF 00CE FEFF FDCE 029C CECE"
	$"FDFF 00CE FEFF 01CE CEFC FF01 CEFF FDCE FCFF 05CE FFCE CEFF CEFE FF01 CEFF FCCE"
	$"02FF CEFF F3CE 03A6 F0CE 0000 FACE FE00 01CE CEFD 0003 CE00 00CE FD00 03CE 0000"
	$"CEFC 0000 CEFC 0002 CECE 00FE CEFE 0002 CECE 00FD CE03 00CE CE00 FECE 0100 00FE"
	$"CE04 00CE 00CE 00F9 CE01 0000 FECE 0100 00FE CE03 00CE CE00 FCCE 0000 FECE FE00"
	$"00CE FD00 03CE CE00 CEFD 0000 CEFC 00FE CE00 00FE CEFE 0004 CECE 0000 CEFA 0000"
	$"CEFE 0008 CE00 00CE 0000 CE00 00FC CE07 00CE 0000 CE00 00CE FE00 F9CE 0200 CE00"
	$"FECE 0200 CE00 FECE FD00 03CE 0000 CEFC 0000 CEFC 0002 CE00 00FE CEFD 0011 CECE"
	$"0000 CECE 0000 CE00 00CE 0000 CE00 00CE FC00 01CE CEFE 00F1 CE00 FFFD 9C05 CE9C"
	$"FFCE CEFF FECE 079C CE9C CE9C CE9C CEFB 9C04 FFCE FFFF 9CFE CEFC 9C02 CE9C CEFE"
	$"9C07 CE9C FFFF CEFF CECE FE9C 08CE 9CCE CE9C CECE 9CCE FE9C 00CE FE9C 00CE FD9C"
	$"01CE 9CFE FFFE CE03 9CCE 9CCE FE9C 00CE FD9C 13CE 9CCE FFCE FFFF CE9C CE9C 9CCE"
	$"CE9C 9CCE 9CCE 9CFE CE00 9CFE FF01 CECE FB9C 01CE 9CF3 CEF0 CF00 00FA CFFE 0001"
	$"CFCF FD00 03CF 0000 CFFD 0003 CF00 00CF FC00 00CF FC00 02CF CF00 FECF FE00 02CF"
	$"CF00 FDCF 0300 CFCF 00FE CF01 0000 FECF 0400 CF00 CF00 F9CF 0100 00FE CF01 0000"
	$"FECF 0300 CFCF 00FC CF00 00FE CFFE 0000 CFFD 0003 CFCF 00CF FD00 00CF FC00 FECF"
	$"0000 FECF FE00 04CF CF00 00CF FA00 00CF FE00 08CF 0000 CF00 00CF 0000 FCCF 0700"
	$"CF00 00CF 0000 CFFE 00F9 CF02 00CF 00FE CF02 00CF 00FE CFFD 0003 CF00 00CF FC00"
	$"00CF FC00 02CF 0000 FECF FD00 11CF CF00 00CF CF00 00CF 0000 CF00 00CF 0000 CFFC"
	$"0001 CFCF FE00 F1CF 00FF FBCF 03FF CFCF FFF9 CF00 FFF9 CF03 FFCF FFFF FDCF 019A"
	$"9AF6 CF03 FFFF CFFF FCCF 009A FECF 02FF CFFF F1CF FEFF EFCF 03FF CFFF FFFE CF01"
	$"9A9A F5CF FEFF FECF FE9A EFCF F0CE 0000 FACE FE00 01CE CEFD 0003 CE00 00CE FD00"
	$"03CE 0000 CEFC 0000 CEFC 0002 CECE 00FE CEFE 0002 CECE 00FD CE03 00CE CE00 FECE"
	$"0100 00FE CE04 00CE 00CE 00F9 CE01 0000 FECE 0100 00FE CE03 00CE CE00 FCCE 0000"
	$"FECE FE00 00CE FD00 03CE CE00 CEFD 0000 CEFC 00FE CE00 00FE CEFE 0004 CECE 0000"
	$"CEFA 0000 CEFE 0008 CE00 00CE 0000 CE00 00FC CE07 00CE 0000 CE00 00CE FE00 F9CE"
	$"0200 CE00 FECE 0200 CE00 FECE FD00 03CE 0000 CEFC 0000 CEFC 0002 CE00 00FE CEFD"
	$"0011 CECE 0000 CECE 0000 CE00 00CE 0000 CE00 00CE FC00 01CE CEFE 00F1 CE00 FFFE"
	$"CE07 FFCE FFFF CECE FFFF FCCE FEFF 0BCE FFFF CEFF CEFF CEFF CEFF FFFC CE06 9CFF"
	$"FFCE FFCE FFFE CE05 FFCE FFFF CEFF FCCE 029C FFCE FDFF 03CE FFFF CEFB FFFE CE01"
	$"FFCE FCFF FCCE FEFF 00CE FDFF 00CE FDFF 02CE FFFF FECE 029C 9CCE FEFF 00CE FCFF"
	$"00CE FDFF FECE FE9C 00CE FEFF F3CE 03F1 F0CE 0000 FBCE 0000 FECE 1B00 CECE 00CE"
	$"CE00 CE00 CECE 00CE 0000 CE00 00CE CE00 CE00 00CE 00CE 00FE CE09 00CE CE00 CECE"
	$"00CE CE00 FDCE 0000 FECE FD00 00CE FC00 02CE CE00 FACE 0200 CE00 FECE 0100 00FE"
	$"CE03 00CE CE00 FBCE 0200 CE00 FECE 0D00 CE00 CECE 00CE 0000 CE00 CE00 00FE CE00"
	$"00FC CE02 00CE 00FE CE0C 00CE 0000 CECE 00CE 00CE CE00 00FE CE06 00CE 0000 CE00"
	$"00FA CE0A 00CE CE00 00CE 0000 CECE 00F9 CE02 00CE 00FE CE02 00CE 00FE CE02 00CE"
	$"00FE CE0D 0000 CECE 00CE 0000 CE00 CE00 CE00 FCCE 1F00 CE00 CECE 00CE CE00 00CE"
	$"CE00 CECE 00CE 0000 CE00 CECE 0000 CECE 0000 CECE 00F1 CE00 FFFE CE0C 9CCE 9CFF"
	$"CECE FFCE CE9C CECE 9CFE CE03 9CCE CE9C FDCE 01FF CEFE FF00 CEFD 9CFE CE00 9CFA"
	$"CE03 FFFF CEFF FDCE 009C FDCE 089C CE9C CECE 9CCE 9CCE FD9C FECE 029C CE9C FEFF"
	$"FDCE 0A9C 9CCE CE9C 9CCE 9C9C CE9C FECE 03FF CEFF FFFE CE01 9C9C FECE FE9C 01CE"
	$"9CFE CE00 9CFE FFFE CEFD 9CF0 CEF0 CF00 00FB CF00 00FE CF1B 00CF CF00 CFCF 00CF"
	$"00CF CF00 CF00 00CF 0000 CFCF 00CF 0000 CF00 CF00 FECF 0900 CFCF 00CF CF00 CFCF"
	$"00FD CF00 00FE CFFD 0000 CFFC 0002 CFCF 00FA CF02 00CF 00FE CF01 0000 FECF 0300"
	$"CFCF 00FB CF02 00CF 00FE CF0D 00CF 00CF CF00 CF00 00CF 00CF 0000 FECF 0000 FCCF"
	$"0200 CF00 FECF 0C00 CF00 00CF CF00 CF00 CFCF 0000 FECF 0600 CF00 00CF 0000 FACF"
	$"0A00 CFCF 0000 CF00 00CF CF00 F9CF 0200 CF00 FECF 0200 CF00 FECF 0200 CF00 FECF"
	$"0D00 00CF CF00 CF00 00CF 00CF 00CF 00FC CF1F 00CF 00CF CF00 CFCF 0000 CFCF 00CF"
	$"CF00 CF00 00CF 00CF CF00 00CF CF00 00CF CF00 F1CF 03FF CFCF FFFE CF16 FFCF CFFF"
	$"CFCF 9ACF 9ACF CFFF FFCF FFFF CFCF FFCF FFFF CFFE FFFE CF01 9ACF FEFF 06CF CFFF"
	$"CFFF FFCF FEFF 01CF FFFC CF05 9AFF CFFF CFFF FDCF 00FF F9CF 00FF FECF FEFF FECF"
	$"009A FDCF 0DFF CFFF CFCF FFCF FFCF FFFF CFFF FFFE CF05 9ACF 9AFF CFFF F9CF FEFF"
	$"FDCF FE9A F0CF F0CE 0000 FBCE 0000 FECE 1B00 CECE 00CE CE00 CE00 CECE 00CE 0000"
	$"CE00 00CE CE00 CE00 00CE 00CE 00FE CE09 00CE CE00 CECE 00CE CE00 FDCE 0000 FECE"
	$"FD00 00CE FC00 02CE CE00 FACE 0200 CE00 FECE 0100 00FE CE03 00CE CE00 FBCE 0200"
	$"CE00 FECE 0D00 CE00 CECE 00CE 0000 CE00 CE00 00FE CE00 00FC CE02 00CE 00FE CE0C"
	$"00CE 0000 CECE 00CE 00CE CE00 00FE CE06 00CE 0000 CE00 00FA CE0A 00CE CE00 00CE"
	$"0000 CECE 00F9 CE02 00CE 00FE CE02 00CE 00FE CE02 00CE 00FE CE0D 0000 CECE 00CE"
	$"0000 CE00 CE00 CE00 FCCE 1F00 CE00 CECE 00CE CE00 00CE CE00 CECE 00CE 0000 CE00"
	$"CECE 0000 CECE 0000 CECE 00F1 CEFC FF0B CEFF FFCE CEFF CECE 9CCE 9CCE FEFF 00CE"
	$"F5FF FECE 019C CEFE FF00 CEF8 FF01 CEFF FCCE 009C F7FF 00CE F3FF FBCE FEFF 00CE"
	$"FBFF 05CE FFFF CEFF FFFE CE02 9C9C CEFD FF00 CEFD FF00 CEFD FFFD CEFE 9CFE FFF3"
	$"CE03 D0F0 CE00 00FB CE00 00FE CE1B 00CE CE00 CECE 00CE 00CE 00CE CE00 CECE 00CE"
	$"0000 CECE 00CE CE00 CE00 FECE 0300 CECE 00FC CE00 00FD CE00 00FC CE00 00FD CE01"
	$"00CE F900 05CE CE00 CECE 00FE CE01 0000 FECE 0300 CECE 00FA CE01 0000 FECE 1100"
	$"CE00 CECE 00CE 00CE CE00 CE00 CE00 00CE 00FB CE01 0000 FECE 0C00 CE00 00CE CE00"
	$"CE00 CECE 0000 FECE 0800 CE00 CECE 00CE 0000 FCCE 0700 CECE 00CE CE00 00F7 CEFC"
	$"0004 CECE 00CE 00FE CE15 00CE CE00 CECE 00CE 0000 CECE 00CE CE00 CE00 CECE 0000"
	$"FECE 0400 CECE 00CE FD00 00CE FB00 07CE 00CE CE00 CE00 CEFC 0002 CECE 00F1 CE00"
	$"FFFE CE0C 9CCE 9CFF CECE FFCE CE9C CECE 9CFE CE03 9CCE CE9C FDCE 01FF CEFE FF00"
	$"CEFD 9CFE CE00 9CFA CE03 FFFF CEFF FDCE 009C FDCE 089C CE9C CECE 9CCE 9CCE FD9C"
	$"FECE 029C CE9C FEFF FDCE 0A9C 9CCE CE9C 9CCE 9C9C CE9C FECE 03FF CEFF FFFE CE01"
	$"9C9C FECE FE9C 01CE 9CFE CE00 9CFE FFFE CEFD 9CF0 CEF0 CF00 00FB CF00 00FE CF1B"
	$"00CF CF00 CFCF 00CF 00CF 00CF CF00 CFCF 00CF 0000 CFCF 00CF CF00 CF00 FECF 0300"
	$"CFCF 00FC CF00 00FD CF00 00FC CF00 00FD CF01 00CF F900 05CF CF00 CFCF 00FE CF01"
	$"0000 FECF 0300 CFCF 00FA CF01 0000 FECF 1100 CF00 CFCF 00CF 00CF CF00 CF00 CF00"
	$"00CF 00FB CF01 0000 FECF 0C00 CF00 00CF CF00 CF00 CFCF 0000 FECF 0800 CF00 CFCF"
	$"00CF 0000 FCCF 0700 CFCF 00CF CF00 00F7 CFFC 0004 CFCF 00CF 00FE CF15 00CF CF00"
	$"CFCF 00CF 0000 CFCF 00CF CF00 CF00 CFCF 0000 FECF 0400 CFCF 00CF FD00 00CF FB00"
	$"07CF 00CF CF00 CF00 CFFC 0002 CFCF 00F1 CF03 FFCF CFFF FECF 16FF CFCF FFCF CF9A"
	$"CF9A CFCF FFFF CFFF FFCF CFFF CFFF FFCF FEFF FECF 019A CFFE FF06 CFCF FFCF FFFF"
	$"CFFE FF01 CFFF FCCF 059A FFCF FFCF FFFD CF00 FFF9 CF00 FFFE CFFE FFFE CF00 9AFD"
	$"CF0D FFCF FFCF CFFF CFFF CFFF FFCF FFFF FECF 059A CF9A FFCF FFF9 CFFE FFFD CFFE"
	$"9AF0 CFF0 CE00 00FB CE00 00FE CE1B 00CE CE00 CECE 00CE 00CE 00CE CE00 CECE 00CE"
	$"0000 CECE 00CE CE00 CE00 FECE 0300 CECE 00FC CE00 00FD CE00 00FC CE00 00FD CE01"
	$"00CE F900 05CE CE00 CECE 00FE CE01 0000 FECE 0300 CECE 00FA CE01 0000 FECE 1100"
	$"CE00 CECE 00CE 00CE CE00 CE00 CE00 00CE 00FB CE01 0000 FECE 0C00 CE00 00CE CE00"
	$"CE00 CECE 0000 FECE 0800 CE00 CECE 00CE 0000 FCCE 0700 CECE 00CE CE00 00F7 CEFC"
	$"0004 CECE 00CE 00FE CE15 00CE CE00 CECE 00CE 0000 CECE 00CE CE00 CE00 CECE 0000"
	$"FECE 0400 CECE 00CE FD00 00CE FB00 07CE 00CE CE00 CE00 CEFC 0002 CECE 00F1 CEFC"
	$"FF0B CEFF FFCE CEFF CECE 9CCE 9CCE FEFF 00CE F5FF FECE 019C CEFE FF00 CEF8 FF01"
	$"CEFF FCCE 009C F7FF 00CE F3FF FBCE FEFF 00CE FBFF 05CE FFFF CEFF FFFE CE02 9C9C"
	$"CEFD FF00 CEFD FF00 CEFD FFFD CEFE 9CFE FFF3 CE03 F1EF CE00 00FE CE02 00CE 00FE"
	$"CE11 00CE CE00 CECE 00CE CE00 00CE CE00 CECE 0000 FDCE 0500 CECE 00CE 00FE CE03"
	$"00CE CE00 FCCE 0000 FDCE 0000 FDCE 0100 00FE CE01 0000 FDCE 0000 FCCE 0400 CECE"
	$"0000 FECE 0100 00FE CE03 00CE CE00 FDCE 0400 CECE 0000 FECE 1100 CE00 CECE 00CE"
	$"00CE CE00 CE00 CECE 00CE 00FE CE04 00CE CE00 00FE CE0C 00CE 0000 CECE 00CE 00CE"
	$"CE00 00FE CE08 00CE 00CE CE00 CECE 00FC CE07 00CE CE00 CECE 0000 F7CE 0000 FECE"
	$"0500 CECE 00CE 00FE CE07 00CE CE00 CECE 0000 FDCE 0500 CECE 00CE 00FE CE00 00FE"
	$"CE05 00CE CE00 CE00 FCCE 0100 00FD CE00 00FE CE03 00CE CE00 FECE 0300 CECE 00F1"
	$"CE00 FFFD CE0B 9CCE FFCE CEFF CECE 9CCE 9C9C FECE 009C FECE 029C CE9C FECE 00FF"
	$"FECE FD9C FECE 009C FECE 079C 9CCE 9CFF CECE FFFC CE00 9CFC CEFD 9C06 CE9C 9CCE"
	$"9CCE 9CFD CE01 9CCE FEFF FECE 029C CE9C FECE 039C CECE 9CFC CE03 FFCE FFFF FECE"
	$"019C 9CFD CE03 9CCE CE9C FBCE 01FF 9CFE CEFE 9CF0 CEEF CF00 00FE CF02 00CF 00FE"
	$"CF11 00CF CF00 CFCF 00CF CF00 00CF CF00 CFCF 0000 FDCF 0500 CFCF 00CF 00FE CF03"
	$"00CF CF00 FCCF 0000 FDCF 0000 FDCF 0100 00FE CF01 0000 FDCF 0000 FCCF 0400 CFCF"
	$"0000 FECF 0100 00FE CF03 00CF CF00 FDCF 0400 CFCF 0000 FECF 1100 CF00 CFCF 00CF"
	$"00CF CF00 CF00 CFCF 00CF 00FE CF04 00CF CF00 00FE CF0C 00CF 0000 CFCF 00CF 00CF"
	$"CF00 00FE CF08 00CF 00CF CF00 CFCF 00FC CF07 00CF CF00 CFCF 0000 F7CF 0000 FECF"
	$"0500 CFCF 00CF 00FE CF07 00CF CF00 CFCF 0000 FDCF 0500 CFCF 00CF 00FE CF00 00FE"
	$"CF05 00CF CF00 CF00 FCCF 0100 00FD CF00 00FE CF03 00CF CF00 FECF 0300 CFCF 00F1"
	$"CF0A FFCF CFFF CFFF CFFF CFCF FFFD CF04 9ACF CFFF FFFE CF00 FFFB CF00 FFFC CF00"
	$"9AFC CF01 FFCF FEFF 05CF CFFF CFCF FFFC CF04 9ACF CFFF FFF3 CF00 FFFE CFFE FFF9"
	$"CF0D FFCF CFFF CFFF CFFF FFCF FFCF FFFF FDCF 029A CFFF FECF 01FF FFFD CF06 FFCF"
	$"CFFF CFCF FFFE CF01 9AFF F1CF EFCE 0000 FECE 0200 CE00 FECE 1100 CECE 00CE CE00"
	$"CECE 0000 CECE 00CE CE00 00FD CE05 00CE CE00 CE00 FECE 0300 CECE 00FC CE00 00FD"
	$"CE00 00FD CE01 0000 FECE 0100 00FD CE00 00FC CE04 00CE CE00 00FE CE01 0000 FECE"
	$"0300 CECE 00FD CE04 00CE CE00 00FE CE11 00CE 00CE CE00 CE00 CECE 00CE 00CE CE00"
	$"CE00 FECE 0400 CECE 0000 FECE 0C00 CE00 00CE CE00 CE00 CECE 0000 FECE 0800 CE00"
	$"CECE 00CE CE00 FCCE 0700 CECE 00CE CE00 00F7 CE00 00FE CE05 00CE CE00 CE00 FECE"
	$"0700 CECE 00CE CE00 00FD CE05 00CE CE00 CE00 FECE 0000 FECE 0500 CECE 00CE 00FC"
	$"CE01 0000 FDCE 0000 FECE 0300 CECE 00FE CE03 00CE CE00 F1CE F9FF 02CE CEFF FDCE"
	$"019C CEF6 FF02 CECE FFFC CE01 9CCE F5FF 02CE CEFF FCCE 009C FAFF 05CE FFCE FFFF"
	$"CEF5 FFFB CEFE FF00 CEF8 FF02 CEFF FFFD CE01 9CCE FEFF 00CE F7FF 06CE CEFF 9CCE"
	$"CE9C FEFF F3CE 037C EECE FE00 FECE FE00 FECE FE00 FECE 0200 CECE F500 00CE FD00"
	$"02CE CE00 FECE FE00 02CE CE00 FECE FE00 02CE 0000 FECE 0100 00FB CE00 00FD CEFC"
	$"0000 CEFE 0001 CECE FE00 01CE CEFE 00FE CEFE 0001 CECE FE00 01CE CEFE 0000 CEFE"
	$"0000 CEFC 0005 CECE 0000 CECE FE00 01CE CEFE 0000 CEF2 0000 CEFE 0000 CEFE 0004"
	$"CE00 00CE CEFB 0000 CEFC 0000 CEFE 0001 CECE FE00 00CE F900 00CE FE00 01CE CEF7"
	$"0000 CEFB 00FE CEFE 0001 CECE FA00 01CE CEFB 0002 CECE 00FE CEFE 0000 CEFC 00F3"
	$"CE0A FF9C 9CCE 9CCE CEFF CECE FFFE CE03 9C9C CECE FD9C 01CE 9CFD CE03 FFCE FFFF"
	$"FDCE 009C FECE 049C 9CCE CE9C FDCE 03FF CEFF FFFE CE05 9CCE 9CCE 9CCE FE9C 03CE"
	$"CE9C 9CFE CE02 9CCE 9CFE CE02 9CCE CEFE FFFE CE06 9CCE 9CCE 9CCE 9CFC CE05 9CCE"
	$"CEFF CEFF FECE 049C CE9C 9CCE FC9C 04CE 9C9C CECE FEFF 09CE FFCE CE9C 9CCE CE9C"
	$"9CF3 CEEE CFFE 00FE CFFE 00FE CFFE 00FE CF02 00CF CFF5 0000 CFFD 0002 CFCF 00FE"
	$"CFFE 0002 CFCF 00FE CFFE 0002 CF00 00FE CF01 0000 FBCF 0000 FDCF FC00 00CF FE00"
	$"01CF CFFE 0001 CFCF FE00 FECF FE00 01CF CFFE 0001 CFCF FE00 00CF FE00 00CF FC00"
	$"05CF CF00 00CF CFFE 0001 CFCF FE00 00CF F200 00CF FE00 00CF FE00 04CF 0000 CFCF"
	$"FB00 00CF FC00 00CF FE00 01CF CFFE 0000 CFF9 0000 CFFE 0001 CFCF F700 00CF FB00"
	$"FECF FE00 01CF CFFA 0001 CFCF FB00 02CF CF00 FECF FE00 00CF FC00 F3CF 00FF FECF"
	$"0BFF CFCF FFCF CFFF FFCF CF9A 9AFC CF0E FFFF CFFF FFCF FFFF CFFF FFCF CF9A 9AFA"
	$"CF00 FFFD CF06 FFFF CFFF FFCF FFFE CF01 9AFF F8CF 01FF FFFD CFFE FF01 CFCF FCFF"
	$"09CF CF9A CF9A CFFF CFCF FFFE CF0D FFCF CFFF FFCF FFCF CFFF 9ACF CF9A FBCF 04FF"
	$"CFCF FFCF FEFF 01CF FFEB CFEE CEFE 00FE CEFE 00FE CEFE 00FE CE02 00CE CEF5 0000"
	$"CEFD 0002 CECE 00FE CEFE 0002 CECE 00FE CEFE 0002 CE00 00FE CE01 0000 FBCE 0000"
	$"FDCE FC00 00CE FE00 01CE CEFE 0001 CECE FE00 FECE FE00 01CE CEFE 0001 CECE FE00"
	$"00CE FE00 00CE FC00 05CE CE00 00CE CEFE 0001 CECE FE00 00CE F200 00CE FE00 00CE"
	$"FE00 04CE 0000 CECE FB00 00CE FC00 00CE FE00 01CE CEFE 0000 CEF9 0000 CEFE 0001"
	$"CECE F700 00CE FB00 FECE FE00 01CE CEFA 0001 CECE FB00 02CE CE00 FECE FE00 00CE"
	$"FC00 F3CE FDFF 02CE FFCE FDFF FECE 029C 9CCE FEFF 00CE F6FF FDCE 019C CEFE FF00"
	$"CEFE FF01 CECE FEFF 00CE FEFF FDCE 009C FEFF 02CE FFCE FAFF 02CE FFCE FCFF 00CE"
	$"FEFF FCCE 009C F4FF 0BCE FFCE FFCE 9CCE 9C9C FFFF CEF9 FF04 CECE FFCE FFFC CE01"
	$"FFFF F2CE 01A5 E2CE 0000 FCCE 0000 FACE 0000 FECE 0000 F7CE 0000 FBCE 0000 C7CE"
	$"0000 CDCE 0000 F0CE 0000 EACE 0000 FECE 0000 C4CE 03FF CECE 9CFE CE09 FFCE CEFF"
	$"CECE 9CCE 9C9C FACE 059C CE9C CEFF CEFE FF00 CEFE 9CF7 CE05 9CCE FFFF CEFF FDCE"
	$"069C 9CCE CE9C CECE FE9C 00CE F89C 03CE CE9C CEFE FFFD CE00 9CFE CE05 9CCE 9CCE"
	$"CE9C FDCE 03FF CEFF FFFE CEFE 9CF4 CE00 FFFE CE03 9CCE CE9C F0CE E2CF 0000 FCCF"
	$"0000 FACF 0000 FECF 0000 F7CF 0000 FBCF 0000 C7CF 0000 CDCF 0000 F0CF 0000 EACF"
	$"0000 FECF 0000 C4CF 0AFF CFCF FFCF FFCF FFCF CFFF FDCF 039A CFCF FFF8 CF01 FFCF"
	$"FDFF 03CF CF9A 9AFE FFFE CFFD FF04 CFFF FFCF FFFC CF05 9ACF FFCF CFFF F3CF 02FF"
	$"CFCF FEFF 01CF FFFD CF00 FFFD CF08 FFFF CFCF FFFF CFFF CFFE FFFE CF06 9ACF CFFF"
	$"FFCF FFFC CF03 FFCF CFFF FDCF FE9A 02FF CFFF F3CF E2CE 0000 FCCE 0000 FACE 0000"
	$"FECE 0000 F7CE 0000 FBCE 0000 C7CE 0000 CDCE 0000 F0CE 0000 EACE 0000 FECE 0000"
	$"C4CE F9FF 02CE CEFF FDCE 049C CEFF FFCE F8FF 00CE FEFF FECE 019C CEF4 FF01 CEFF"
	$"FCCE 009C FAFF 02CE FFCE F7FF 00CE FDFF FBCE FAFF 00CE F9FF 05CE FFCE CE9C CEFB"
	$"FF00 CEFA FFFA CEFE FFF3 CE01 A4E3 CEFE 0003 CECE 0000 F8CE FE00 F5CE 0000 FDCE"
	$"0000 C7CE FE00 CFCE 0000 F0CE 0000 E8CE FE00 C3CE 02FF 9C9C FDCE 00FF FBCE 109C"
	$"CE9C CE9C CE9C CE9C CECE 9C9C CEFF CEFF FECE FA9C 02CE 9CCE FE9C 02CE 9CFF FACE"
	$"109C CE9C CE9C CE9C 9CCE CE9C CE9C CE9C CE9C FACE FEFF FECE 099C CE9C CE9C CE9C"
	$"CECE 9CFC CE02 FFCE FFFE CEFD 9CFE CE05 9CCE 9CCE 9C9C FDCE 00FF FBCE 039C 9CCE"
	$"9CF3 CEE3 CFFE 0003 CFCF 0000 F8CF FE00 F5CF 0000 FDCF 0000 C7CF FE00 CFCF 0000"
	$"F0CF 0000 E8CF FE00 C3CF 07FF CFCF FFFF CFCF FFF9 CF0E 9ACF FFCF CFFF CFCF FFCF"
	$"CFFF FFCF FFFC CF0D 9A9A FFFF CFCF FFCF CFFF FFCF CFFF F8CF 00FF FECF 00FF F6CF"
	$"FEFF FECF FEFF FECF 009A FBCF 0AFF CFCF FFCF FFFF CFFF CFFF FDCF 039A 9ACF FFFE"
	$"CF01 FFCF FDFF FECF 04FF CFFF CFCF FE9A F0CF E3CE FE00 03CE CE00 00F8 CEFE 00F5"
	$"CE00 00FD CE00 00C7 CEFE 00CF CE00 00F0 CE00 00E8 CEFE 00C3 CEFB FF01 CEFF F9CE"
	$"009C FCFF 00CE FBFF 01CE FFFC CE01 9CCE FCFF 00CE FBFF FDCE 00FF FDCE FCFF 00CE"
	$"FEFF 05CE CEFF CEFF CEFB FF00 CEFE FFFE CE05 9CCE CEFF FFCE F9FF 03CE FFCE FFFD"
	$"CE02 9C9C CEF7 FFFE CE00 FFFA CEFE FFF3 CE01 4181 CE81 CEE2 CE02 FF9C 9CFD CE00"
	$"FFFB CE10 9CCE 9CCE 9CCE 9CCE 9CCE CE9C 9CCE FFCE FFFE CEFA 9C02 CE9C CEFE 9C02"
	$"CE9C FFFA CE10 9CCE 9CCE 9CCE 9C9C CECE 9CCE 9CCE 9CCE 9CFA CEFE FFFE CE09 9CCE"
	$"9CCE 9CCE 9CCE CE9C FCCE 02FF CEFF FECE FD9C FECE 059C CE9C CE9C 9CFD CE00 FFFB"
	$"CE03 9C9C CE9C F3CE 81CF 81CF E2CF 07FF CFCF FFFF CFCF FFF9 CF0E 9ACF FFCF CFFF"
	$"CFCF FFCF CFFF FFCF FFFC CF0D 9A9A FFFF CFCF FFCF CFFF FFCF CFFF F8CF 00FF FECF"
	$"00FF F6CF FEFF FECF FEFF FECF 009A FBCF 0AFF CFCF FFCF FFFF CFFF CFFF FDCF 039A"
	$"9ACF FFFE CF01 FFCF FDFF FECF 04FF CFFF CFCF FE9A F0CF 81CE 81CE E2CE FBFF 01CE"
	$"FFF9 CE00 9CFC FF00 CEFB FF01 CEFF FCCE 019C CEFC FF00 CEFB FFFD CE00 FFFD CEFC"
	$"FF00 CEFE FF05 CECE FFCE FFCE FBFF 00CE FEFF FECE 059C CECE FFFF CEF9 FF03 CEFF"
	$"CEFF FDCE 029C 9CCE F7FF FECE 00FF FACE FEFF F3CE 0143 81CE 81CE E2CE FEFF 049C"
	$"CE9C CEFF FCCE 029C CE9C FCCE 0C9C 9CCE CE9C 9CCE FFCE FFCE FFCE FD9C FECE 0C9C"
	$"CECE 9CCE CE9C CEFF FFCE CEFF FECE 009C FACE 089C 9CCE 9C9C CE9C CE9C FECE 039C"
	$"CE9C CEFE FFFE CE04 9C9C CECE 9CFA CE05 9CCE CEFF CEFF FDCE FE9C FDCE 009C FBCE"
	$"FDFF 01CE CEFD 9C02 CECE 9CF3 CE81 CF81 CFE2 CFFD FF13 CFFF CFFF CFCF FFCF FF9A"
	$"CFCF 9ACF FFFF CFFF CFFF FECF 11FF FFCF FFFF CFFF CFCF 9ACF FFFF CFFF FFCF FFFE"
	$"CFFE FF02 CFCF FFFD CF05 9AFF CFFF CFFF FBCF 00FF FDCF 03FF FFCF CFFC FFFE CF00"
	$"9AFE CF0D FFCF CFFF CFCF FFCF CFFF CFFF CFFF FBCF 069A FFCF CFFF CFFF FECF FBFF"
	$"FECF FE9A 02FF CFFF F3CF 81CE 81CE E2CE F9FF FECE 05FF CE9C CE9C CEF5 FF02 CEFF"
	$"FFFD CE01 9CCE F8FF 00CE FEFF 02CE CEFF FDCE 009C F8FF 00CE FDFF 00CE F7FF FECE"
	$"029C CECE F4FF 02CE FFFF FDCE 019C CEF2 FFFE CEFE 9CFE FFF3 CE01 3381 CE81 CEE2"
	$"CE07 FFCE CE9C 9CCE CEFF FBCE 069C 9CCE 9CCE CE9C FECE 009C FECE FDFF FDCE 009C"
	$"FBCE 019C CEFE 9C13 CEFF CEFF CECE FFCE 9CCE 9CCE CE9C CE9C CE9C 9CCE FE9C 02CE"
	$"9C9C FCCE 019C CEFD FF1A CECE 9CCE CE9C CECE 9CCE 9C9C CE9C CE9C CEFF CEFF CECE"
	$"FF9C CECE 9CF4 CE02 FF9C FFFD CE00 9CF0 CE81 CF81 CFE2 CFFE FF04 CFCF FFCF FFFA"
	$"CF05 9ACF CFFF CFFF FECF 02FF CFCF FCFF F8CF 03FF CFCF FFFD CF05 FFCF FFCF CFFF"
	$"FECF 069A CFFF CFFF CFFF F8CF 03FF CFCF FFFE CFFD FFFB CF07 FFCF FFCF CFFF CFFF"
	$"FECF 0CFF CFFF CFFF FFCF 9A9A CFCF FFFF F7CF 02FF CFFF EBCF 81CE 81CE E2CE F9FF"
	$"02CE CEFF FDCE 019C CEFA FF00 CEFA FF05 CEFF CECE 9CCE F5FF 04CE FFFF CEFF FECE"
	$"009C FAFF 06CE FFFF CEFF FFCE F5FF FCCE F9FF 00CE FDFF 08CE FFCE CEFF CECE 9CCE"
	$"F6FF 04CE CEFF CEFF FCCE FEFF F3CE 014D 81CE 81CE E2CE 00FF FDCE 059C CEFF CECE"
	$"FFFE CE01 9C9C FECE 039C CECE 9CFC CE05 FFCE FFFF CECE FD9C FCCE 019C CEFE 9C0F"
	$"CEFF CEFF CECE FFCE 9CCE 9CCE CE9C CECE FE9C 00CE FE9C 00CE FE9C 05CE CE9C CE9C"
	$"CEFE FF14 9CCE CE9C CE9C CE9C CECE 9CCE 9CCE CE9C CECE FFCE FFFB CE00 9CFC CE00"
	$"9CFA CE01 FF9C FCCE 039C CECE 9CF3 CE81 CF81 CFE2 CF0E FFCF CFFF CFFF CFFF CFCF"
	$"FFFF CFCF 9AFD CF02 FFCF FFFE CF08 FFCF FFFF CFFF FFCF CFFD 9AFE CF13 FFFF CFCF"
	$"FFFF CFCF FFCF FFFF CFFF CFCF 9A9A CFFF F8CF 00FF FDCF FEFF FECF FEFF FCCF 029A"
	$"FFFF FECF 03FF CFCF FFFE CF02 FFCF FFF9 CF04 FFFF CFFF FFFD CF0B FFCF CFFF CFFF"
	$"CFCF 9A9A CFFF F1CF 81CE 81CE E2CE FDFF 00CE FEFF 02CE CEFF FBCE FCFF 00CE FEFF"
	$"07CE FFFF CEFF FFCE CEFE 9C00 CEF5 FF04 CEFF FFCE FFFE CE00 9CFA FF03 CEFF FFCE"
	$"FDFF 00CE F8FF FBCE F4FF 03CE FFCE FFFC CEF6 FF02 CECE FFFA CEFE FFF3 CE01 4D81"
	$"CE81 CEE2 CE00 FFFD CE05 9CCE FFCE CEFF FECE 019C 9CFE CE03 9CCE CE9C FCCE 05FF"
	$"CEFF FFCE CEFD 9CFC CE01 9CCE FE9C 0FCE FFCE FFCE CEFF CE9C CE9C CECE 9CCE CEFE"
	$"9C00 CEFE 9C00 CEFE 9C05 CECE 9CCE 9CCE FEFF 149C CECE 9CCE 9CCE 9CCE CE9C CE9C"
	$"CECE 9CCE CEFF CEFF FBCE 009C FCCE 009C FACE 01FF 9CFC CE03 9CCE CE9C F3CE 81CF"
	$"81CF E2CF 0EFF CFCF FFCF FFCF FFCF CFFF FFCF CF9A FDCF 02FF CFFF FECF 08FF CFFF"
	$"FFCF FFFF CFCF FD9A FECF 13FF FFCF CFFF FFCF CFFF CFFF FFCF FFCF CF9A 9ACF FFF8"
	$"CF00 FFFD CFFE FFFE CFFE FFFC CF02 9AFF FFFE CF03 FFCF CFFF FECF 02FF CFFF F9CF"
	$"04FF FFCF FFFF FDCF 0BFF CFCF FFCF FFCF CF9A 9ACF FFF1 CF81 CE81 CEE2 CEFD FF00"
	$"CEFE FF02 CECE FFFB CEFC FF00 CEFE FF07 CEFF FFCE FFFF CECE FE9C 00CE F5FF 04CE"
	$"FFFF CEFF FECE 009C FAFF 03CE FFFF CEFD FF00 CEF8 FFFB CEF4 FF03 CEFF CEFF FCCE"
	$"F6FF 02CE CEFF FACE FEFF F3CE 0163 81CE 81CE E2CE 02FF 9C9C FDCE 0CFF CECE FFCE"
	$"9CCE 9C9C CE9C CE9C FECE 009C FDCE 08FF CEFF CECE 9CCE CE9C FECE 009C FECE FE9C"
	$"0BCE 9CFF CEFF FFCE FFCE 9CCE 9CFE CE01 9CCE FD9C 05CE 9C9C CE9C 9CFC CE01 9CCE"
	$"FEFF FDCE 039C CECE 9CFE CE02 9CCE 9CFD CE14 FFCE FFCE FFCE CE9C CE9C CE9C 9CCE"
	$"CE9C FFCE CE9C CEFE FF01 CEFF FDCE 029C CE9C F2CE 81CF 81CF E2CF FEFF 07CF CFFF"
	$"CFFF CFCF FFFD CF05 9ACF CFFF CFFF FECF 00FF FECF 04FF CFFF CFFF FECF 069A CFFF"
	$"FFCF CFFF FBCF 05FF CFFF FFCF FFFE CF03 9AFF CFFF F8CF 03FF CFCF FFFE CF02 FFCF"
	$"CFFD FFFC CF05 FFCF FFFF CFFF FECF 04FF FFCF FFCF FEFF 02CF CF9A FCCF 02FF CFCF"
	$"FEFF 00CF FDFF 01CF FFFD CF02 9ACF FFF2 CF81 CE81 CEE2 CE02 FFCE CEFC FF02 CECE"
	$"FFFD CE04 9CCE FFFF CEFE FF00 CEFC FF02 CEFF FFFD CE01 9CCE F5FF 04CE FFFF CEFF"
	$"FECE 009C FAFF 06CE FFFF CEFF FFCE FDFF 00CE FBFF FBCE F9FF 00CE FDFF 00CE FEFF"
	$"FCCE 02FF FFCE F6FF 01CE FFFC CEFE FFF3 CE01 3481 CE81 CEE2 CE07 FFCE CE9C CECE"
	$"9CFF FCCE 039C CECE 9CFE CE03 9CCE 9CCE FE9C 0ACE FFCE FFCE CEFF CECE 9C9C FECE"
	$"029C CECE FE9C 02CE CEFF FACE 009C FBCE 019C CEFD 9C04 FF9C CE9C CEFE 9CFE CEFE"
	$"FFFE CE02 9CCE 9CFB CE05 9CCE 9CCE CE9C FEFF FECE 029C CE9C FDCE 039C CECE 9CFB"
	$"CE00 FFFE CEFE 9CFE CE00 9CF3 CE81 CF81 CFE2 CF00 FFFE CF03 FFCF FFFF FCCF 009A"
	$"FACF 01FF FFFE CF0B FFCF FFCF FFCF CFFF CFCF 9A9A FECF 02FF CFFF FECF FEFF 01CF"
	$"FFFE CF08 FFCF CF9A CFFF CFFF FFFB CF00 FFF9 CFFC FFFD CF03 9A9A CFFF FECF 01FF"
	$"FFFD CFFD FFFC CF02 9ACF FFFE CF00 FFF9 CF00 FFFA CF02 FFCF FFF3 CF81 CE81 CEE2"
	$"CEFE FF00 CEFD FFFC CE00 9CFE CEF9 FF00 CEFE FF08 CEFF CECE FFCE CE9C 9CFA FF01"
	$"CECE FEFF 01CE FFFA CEFC FF03 CEFF FFCE F1FF FBCE F2FF FCCE 019C CEF6 FF02 CECE"
	$"FFFA CEFE FFF3 CE01 4A81 CE81 CEE2 CE03 FFCE CE9C FECE 0DFF CECE FFCE CE9C CECE"
	$"9CCE 9CCE 9CFD CE07 9CCE CEFF CEFF FF9C FDCE FE9C FCCE 079C 9CCE 9CFF FFCE FFFD"
	$"CE01 9C9C FECE 019C CEFE 9C06 CE9C CE9C 9CCE 9CFE CE03 9CCE CE9C FEFF FECE 029C"
	$"CE9C FBCE 029C FF9C FECE 03FF CEFF FFFE CE06 9C9C CE9C CECE 9CFA CEFE FF00 9CFE"
	$"CEFE 9C02 CECE 9CF3 CE81 CF81 CFE2 CF00 FFFC CF19 FFFF CFCF FFCF FF9A CF9A CFCF"
	$"FFCF FFCF FFFF CFFF CFCF FFCF FFFF FCCF 029A CFCF FEFF 00CF FDFF 04CF FFFF CFFF"
	$"FDCF 069A 9ACF FFCF CFFF F9CF 06FF CFCF FFFF CFCF FCFF FACF 0AFF CFCF FFCF CFFF"
	$"CFFF FFCF FDFF 0BCF FFCF 9A9A CFCF FFCF CFFF CFFE FFFD CF00 FFFD CF05 9A9A CFCF"
	$"FFFF F3CF 81CE 81CE E2CE F9FF 08CE CEFF CECE 9CCE 9CCE F5FF 02CE FFFF FCCE 009C"
	$"F4FF 01CE FFFD CE04 9CCE FFFF CEFD FF02 CEFF CEF2 FFFB CEF4 FF02 CEFF FFFE CE02"
	$"9C9C CEF6 FF02 CECE FFFE CEFE 9C00 CEFE FFF3 CE01 4381 CE81 CEE2 CE03 FFCE CE9C"
	$"FECE 00FF FDCE 039C CE9C 9CFA CE07 9CCE 9CCE CEFF CEFF FCCE 009C FCCE 079C CECE"
	$"9C9C CECE FFFC CEFD 9C08 CECE 9CCE CE9C CE9C CEFE 9C00 CEFE 9C02 CECE 9CFE CEFE"
	$"FFFE CE00 9CFE CE00 9CFB CE03 9C9C CECE FEFF 03CE CE9C CEFE 9CFE CE03 9CCE CE9C"
	$"FBCE 00FF FDCE FE9C 02CE CE9C F3CE 81CF 81CF E2CF FEFF 04CF FFCF FFFF FACF 039A"
	$"CFCF FFFA CF05 FFCF FFCF FFFF FDCF 069A 9ACF CFFF CFFF FDCF 05FF CFFF CFCF FFFD"
	$"CF06 9A9A CFFF CFFF FFF6 CF01 FFFF FDCF FDFF FCCF 03FF CFFF FFFE CF04 FFCF CFFF"
	$"CFFD FF0A CF9A CF9A 9ACF CFFF FFCF FFFB CFFE FF01 CFFF EBCF 81CE 81CE E2CE FEFF"
	$"00CE FDFF FDCE 049C CECE 9CCE FCFF 03CE FFFF CEFE FF02 CEFF FFFD CE01 9CCE FAFF"
	$"01CE CEFE FFFA CE01 9C9C FCFF 00CE FDFF 08CE FFCE FFFF CEFF FFCE FBFF FBCE F9FF"
	$"00CE FBFF 06CE CE9C CECE 9CCE F6FF 02CE CEFF FACE FEFF F3CE 0143 81CE 81CE E2CE"
	$"03FF CECE 9CFE CE00 FFFD CE03 9CCE 9C9C FACE 079C CE9C CECE FFCE FFFC CE00 9CFC"
	$"CE07 9CCE CE9C 9CCE CEFF FCCE FD9C 08CE CE9C CECE 9CCE 9CCE FE9C 00CE FE9C 02CE"
	$"CE9C FECE FEFF FECE 009C FECE 009C FBCE 039C 9CCE CEFE FF03 CECE 9CCE FE9C FECE"
	$"039C CECE 9CFB CE00 FFFD CEFE 9C02 CECE 9CF3 CE81 CF81 CFE2 CFFE FF04 CFFF CFFF"
	$"FFFA CF03 9ACF CFFF FACF 05FF CFFF CFFF FFFD CF06 9A9A CFCF FFCF FFFD CF05 FFCF"
	$"FFCF CFFF FDCF 069A 9ACF FFCF FFFF F6CF 01FF FFFD CFFD FFFC CF03 FFCF FFFF FECF"
	$"04FF CFCF FFCF FDFF 0ACF 9ACF 9A9A CFCF FFFF CFFF FBCF FEFF 01CF FFEB CF81 CE81"
	$"CEE2 CEFE FF00 CEFD FFFD CE04 9CCE CE9C CEFC FF03 CEFF FFCE FEFF 02CE FFFF FDCE"
	$"019C CEFA FF01 CECE FEFF FACE 019C 9CFC FF00 CEFD FF08 CEFF CEFF FFCE FFFF CEFB"
	$"FFFB CEF9 FF00 CEFB FF06 CECE 9CCE CE9C CEF6 FF02 CECE FFFA CEFE FFF3 CE01 3681"
	$"CE81 CEE2 CE00 FFFE CE03 9CCE 9CFF FCCE 069C CE9C 9CCE CE9C FECE 039C CECE 9CFE"
	$"CE00 FFFE CEFD 9CFD CE00 9CFD CE00 9CFC CE08 9CCE 9CCE 9C9C CE9C CEFE 9C03 CECE"
	$"9CCE FB9C 02CE CE9C FECE FEFF FECE 099C CE9C CECE 9CCE CE9C 9CFC CE05 FFCE FFFF"
	$"9CCE FD9C FDCE 059C FF9C CECE 9CFE CE04 FFCE CE9C CEFE 9C02 CECE 9CF3 CE81 CF81"
	$"CFE2 CF07 FFCF CFFF CFCF FFFF F9CF 049A FFCF CFFF FECF 01FF FFFE CF01 FFFF FCCF"
	$"019A 9AFE CF00 FFF8 CF00 FFFB CF02 9ACF FFFA CF00 FFF9 CF00 FFFE CFFE FFFE CF00"
	$"9AFD CF0D FFCF FFCF CFFF CFFF CFCF FFCF FFFF FECF 039A 9ACF FFFE CF01 FFFF FECF"
	$"00FF FECF 00FF FACF 00FF F1CF 81CE 81CE E2CE F9FF FDCE 009C FECE 009C F6FF 02CE"
	$"CEFF FCCE 019C 9CF7 FF02 CECE FFFA CE00 9CFD FF03 CEFF CECE FBFF 00CE F7FF FBCE"
	$"F4FF 08CE FFFF CE9C CE9C 9CCE F3FF FACE 01FF FFF2 CE01 4181 CE81 CEE2 CE0A FFCE"
	$"CE9C 9CCE CEFF CECE FFFE CE01 9C9C FDCE 0B9C CE9C CEFF 9CCE FFFF CEFF FFFC CEFC"
	$"9C02 FF9C 9CFD CE03 FFFF CEFF FECE 079C CE9C CECE 9CCE CEFE 9C07 CE9C 9CCE 9C9C"
	$"CE9C FDCE 019C 9CFE FF03 9CCE CE9C FECE 129C CE9C 9CCE CE9C CE9C CECE FFCE FFFF"
	$"CEFF CE9C FECE FE9C FBCE 009C FEFF 019C FFFD CE02 9CCE 9CF2 CE81 CF81 CFE2 CFFE"
	$"FF03 CFCF FFCF FCFF FECF 009A FACF 08FF FFCF CFFF FFCF FFFF F7CF 02FF CFFF FDCF"
	$"03FF FFCF FFFC CF03 9ACF CFFF F4CF 01FF FFFD CFFE FFFA CF00 FFFB CF09 FFCF FFCF"
	$"FFCF FFFF CFFF F8CF 00FF FECF 00FF FECF 02FF CFFF FDCF 039A CFCF FFF3 CF81 CE81"
	$"CEE2 CEF9 FF02 CECE FFFD CE01 9CCE FEFF 00CE F9FF 02CE FFFF FBCE FEFF 00CE F8FF"
	$"01CE FFFC CE00 9CF7 FF05 CEFF CEFF FFCE F8FF FBCE FEFF 00CE FEFF 00CE FCFF 04CE"
	$"FFFF CEFF FDCE FEFF 00CE FAFF 04CE CEFF CEFF FCCE FEFF F3CE 014A 81CE 81CE E2CE"
	$"06FF CECE 9CCE 9CCE FCFF 02CE 9C9C FECE 009C FECE 019C CEFE 9C09 CEFF CEFF FFCE"
	$"CE9C 9CCE FE9C FECE 009C FCCE 15FF CEFF FFCE FFCE 9C9C CECE 9CCE CE9C CE9C CE9C"
	$"CE9C CEFD 9C05 CECE 9CCE 9CCE FDFF 08CE 9CCE 9C9C CE9C CE9C FECE 0A9C CE9C CECE"
	$"FFCE FFFF CECE FD9C 06CE 9CCE CE9C CE9C FDCE FEFF FECE FC9C F1CE 81CF 81CF E2CF"
	$"06FF CFCF FFCF FFCF FCFF 03CF CF9A 9AFD CF00 FFFD CF04 FFCF CFFF CFFE FFFA CF00"
	$"FFFE CF0D FFCF CFFF CFFF CFFF FFCF FFCF 9A9A FECF 00FF F4CF 01FF FFFD CFFD FFFE"
	$"CF00 9AFE CF03 FFFF CFFF FCCF 07FF FFCF FFFF CFCF 9AFB CF03 FFCF FFCF FEFF 00CF"
	$"FEFF 02CF CFFF FBCF 00FF F3CF 81CE 81CE E2CE F5FF 06CE CE9C 9CCE FFCE FDFF 02CE"
	$"FFCE FBFF FDCE 009C FECE F7FF 0ACE FFFF CEFF CE9C CE9C FFCE FDFF 09CE FFCE FFCE"
	$"FFCE FFFF CEF7 FFFC CE01 FFCE FCFF 00CE F9FF 07CE CE9C CE9C CEFF CEF5 FFF9 CE01"
	$"FFFF F3CE 0139 81CE 81CE E2CE 00FF FECE 009C FCCE 02FF CECE FD9C 04CE CE9C CE9C"
	$"FBCE 03FF CEFF FFFC CEFD 9CFB CE07 9CCE FFFF CEFF FF9C FECE 0F9C CE9C CE9C CE9C"
	$"CE9C CE9C CE9C CE9C 9CFA CEFE FFFE CE00 9CFE CE03 9CCE CE9C FECE 079C FFCE CEFF"
	$"CEFF FFFE CE00 9CFE CE01 9C9C FACE 009C FDFF 01CE CEFE 9CFE CE00 9CF3 CE81 CF81"
	$"CFE2 CFFE FF03 CFFF CFFF FECF 03FF CFCF 9AFA CF02 FFCF FFFE CF04 FFFF CFFF FFFD"
	$"CF00 9AFC CF00 FFFB CF04 FFFF CFFF FFFD CF00 9AFE CF00 FFFC CF00 FFF9 CF00 FFFE"
	$"CFFE FF01 CFFF F7CF 01FF CFFE FF04 CFFF CFFF FFFE CF06 9A9A CFFF CFCF FFFB CFFC"
	$"FF01 CFCF FD9A 01CF FFF2 CF81 CE81 CEE2 CEFA FFFE CE06 FFCE CE9C CE9C CEF5 FF02"
	$"CEFF FFFD CE01 9CCE F4FF 02CE FFFF FDCE 009C FDFF 00CE F9FF 00CE F6FF FBCE FEFF"
	$"00CE F8FF 08CE FFFF CEFF CE9C 9CCE FBFF 00CE F9FF 01CE CEFE 9C00 CEFE FFF3 CE01"
	$"3C81 CE81 CEE2 CE02 FF9C 9CFD CEFE FFFB CE00 9CFE CE07 9CFF CE9C CE9C CE9C FDFF"
	$"01CE CEFE 9CFC CE01 9CCE FD9C 01CE FFFD CE03 FFCE 9C9C FECE 019C CEFD 9C04 CE9C"
	$"9CCE 9CFE CEFE 9C02 CE9C CEFD FFFE CE01 9C9C FECE 129C FF9C CECE 9CCE 9CCE FFCE"
	$"FFCE FFCE CE9C CE9C FDCE 029C CE9C FDCE FEFF FDCE FE9C 01CE 9CF2 CE81 CF81 CFE2"
	$"CF00 FFFD CF01 FFCF FDFF 01CF FFFE CF08 9AFF CFCF FFFF CFCF FFFE CFFC FFFC CF05"
	$"FFFF CFFF CFCF FEFF 07CF FFFF CFFF CFFF FFFD CF01 FFFF F7CF 02FF CFFF FDCF 01FF"
	$"CFFC FFFD CF05 9AFF FFCF CFFF FDCF 08FF CFFF FFCF FFCF FFFF FBCF 00FF FDCF FEFF"
	$"00CF FEFF 07CF CFFF CF9A 9ACF FFF1 CF81 CE81 CEE2 CEFE FF00 CEFA FFFD CE01 9CCE"
	$"F2FF FDCE 019C CEFA FF01 CECE FEFF 04CE FFFF CEFF FECE 009C FCFF 06CE FFCE FFCE"
	$"FFCE FBFF 00CE FAFF FCCE F4FF 00CE FEFF FECE 019C CEF3 FFFA CEFE FFF3 CE01 3B81"
	$"CE81 CEE2 CE00 FFFD CE02 9CCE FFFD CEFE 9C01 CE9C FACE 009C FECE 05FF CEFF FFCE"
	$"9CFE CE00 9CFE CE00 9CFA CE03 FFFF CEFF FCCE 0F9C CECE 9CCE CE9C CECE 9C9C CE9C"
	$"CE9C 9CFA CEFE FF1A 9CCE CE9C 9CCE 9CCE 9CCE 9CCE CE9C CE9C CECE FFCE FFFF CE9C"
	$"CE9C 9CF5 CEFE FFFD CEFE 9C01 CE9C F2CE 81CF 81CF E2CF FEFF 04CF FFCF FFFF FCCF"
	$"099A CF9A CFCF FFCF CFFF FFFD CF04 FFFF CFFF FFFD CF00 9AFB CF00 FFFC CF03 FFFF"
	$"CFFF FDCF 039A CFCF FFFD CF00 FFF8 CF03 FFFF CFCF FCFF FECF 019A 9AFD CF03 FFCF"
	$"CFFF FCCF FDFF 08CF 9ACF 9A9A CFFF CFCF FEFF FDCF FDFF FDCF FE9A F0CF 81CE 81CE"
	$"E2CE F9FF FCCE 039C CE9C CEF9 FF00 CEFE FF00 CEFE FFFE CE01 9CCE F4FF 01CE FFFC"
	$"CE03 9CFF FFCE FAFF 04CE FFFF CECE F7FF FECE 0B9C CECE FFFF CEFF FFCE FFFF CEFD"
	$"FF08 CEFF FFCE 9CCE 9C9C CEF3 FF03 CEFF CECE FE9C 02FF CEFF F3CE 0150 81CE 81CE"
	$"E2CE 0CFF CECE 9CCE 9CCE FFCE CEFF CECE FD9C FBCE 099C CE9C CE9C FFCE FFCE FFFD"
	$"CE00 9CFE CE03 9CCE CE9C FDCE 06FF FFCE FFFF CECE FE9C 04CE CE9C CECE FE9C FDCE"
	$"029C CE9C FACE FEFF FECE 049C 9CCE CE9C FACE 089C CE9C FFCE FFFF CECE FE9C 03CE"
	$"9CCE 9CFE CE04 9CCE CE9C CEFD FFFC CE00 9CF0 CE81 CF81 CFE2 CFFE FF07 CFFF CFFF"
	$"FFCF CFFF FDCF 089A CFCF FFCF CFFF CFFF FDCF 04FF CFFF CFFF FCCF 01FF FFFD CF00"
	$"FFFD CF06 FFFF CFFF FFCF CFFE 9A01 CFFF FBCF 00FF FECF 00FF FBCF 02FF CFCF FEFF"
	$"0DCF FFCF 9ACF CFFF CFCF FFCF FFCF CFFE FF04 CFFF CFFF FFFC CF06 9AFF CFCF FFCF"
	$"FFFD CFFC FFFC CF03 9ACF CFFF F3CF 81CE 81CE E2CE FEFF 00CE FDFF 02CE CEFF FDCE"
	$"019C CEFC FF03 CEFF FFCE FEFF 03CE FFCE FFFE CE01 9CCE F4FF 02CE FFFF FECE 019C"
	$"9CFC FF02 CEFF CEFE FF00 CEF4 FFFE CE02 9CCE CEF9 FF00 CEFD FF02 CEFF FFFD CE01"
	$"9CCE F2FF FCCE 009C FEFF F3CE 013D 81CE 81CE E2CE 00FF FBCE FEFF 0ECE CE9C CECE"
	$"9CCE CE9C CE9C CE9C CE9C FECE 04FF CEFF FFCE FE9C 07CE 9CCE CE9C CECE 9CFD CE12"
	$"9CFF FFCE FF9C FF9C CECE 9CCE 9CCE CE9C 9CCE CEFB 9C01 CE9C FECE 029C CECE FDFF"
	$"FECE 059C 9CCE CE9C 9CFD CE00 9CFE CEFE FF01 CEFF FDCE 009C FECE 009C FECE 039C"
	$"9CCE CEFE FF00 9CFC CE03 9C9C CE9C F3CE 81CF 81CF E2CF 06FF CFCF FFCF FFCF FDFF"
	$"FCCF 049A FFCF CFFF FDCF 08FF FFCF FFCF FFFF CF9A FECF 009A FECF 03FF FFCF CFFB"
	$"FF03 CFFF CFFF FECF 069A FFCF CFFF CFFF F8CF FDFF 00CF FBFF FECF 089A CFCF FFCF"
	$"CFFF CFFF FDCF FDFF 01CF FFFB CF03 FFCF CFFF FDCF 01FF CFFE FF01 CFFF EBCF 81CE"
	$"81CE E2CE F6FF FBCE F2FF 01CE 9CFD CE02 FFFF CEFE FF00 CEF9 FF01 CEFF FECE 039C"
	$"FFFF CEFB FF00 CEFE FF00 CEF5 FFFE CE04 9CCE FFFF CEF3 FFFC CE02 FFFF CEFE FF00"
	$"CEFA FFFA CE02 FFCE FFF3 CE01 4882 CEFE 00CA CEFE 009E CE07 FFCE CE9C CE9C CEFF"
	$"FCCE 089C 9CCE 9CCE CE9C FF9C FECE 059C CE9C FFCE FFFC CEFD 9CFC CE05 9C9C CECE"
	$"FFFF FCCE FE9C 02CE CE9C FECE 029C 9CCE FE9C 01CE 9CFD CE00 9CFE CEFE FFFE CE03"
	$"9CCE CE9C FECE 049C CECE 9C9C FECE 08FF CEFF CE9C 9CCE 9C9C FACE 049C CECE 9CCE"
	$"FEFF 08CE CE9C CE9C 9CCE CE9C F2CE 82CF FE00 CACF FE00 9ECF FEFF 04CF FFCF FFFF"
	$"FCCF 009A FDCF 05FF CFFF FFCF FFFE CFFD FFFB CF02 9AFF FFFD CF00 FFFD CF01 FFFF"
	$"FBCF 029A CFFF F4CF 00FF FECF 029A CFCF FDFF FCCF 089A FFCF FFFF CFFF CFFF FDCF"
	$"FEFF FDCF 069A CFCF FFCF CFFF FBCF FDFF FDCF FE9A 00FF F1CF 82CE FE00 CACE FE00"
	$"9ECE FEFF 00CE FDFF FCCE 009C FECE F9FF 00CE FEFF 02CE FFFF FCCE 009C FAFF 01CE"
	$"CEFD FFFB CE01 9CCE FAFF 04CE FFFF CECE FBFF 00CE FBFF FBCE F9FF 00CE FDFF 01CE"
	$"FFFD CE02 9CCE CEF3 FF06 CEFF CECE 9C9C CEFE FFF3 CE01 5484 CEFC 00CC CEFC 009E"
	$"CE06 FF9C 9CCE 9CCE CEFD FFFE CE00 9CFE CE00 9CFD CE00 9CFD CEFE FFFE CEFE 9C00"
	$"CEFE 9CFE CE00 9CFE CE04 9CFF CEFF FFFE CE03 9C9C CECE FC9C 06CE CE9C 9CCE CE63"
	$"FECE 059C 9CCE CE9C CEFE FF08 CECE 9C9C CE9C CE9C 9CFE CE15 9CCE CE9C 9CCE FFCE"
	$"FFCE FFFF CE9C CE9C CE9C 9CCE CE9C FACE 00FF FDCE FB9C F3CE 84CF FC00 CCCF FC00"
	$"9ECF 00FF FBCF FDFF 03CF FFCF 9AFC CF07 FFCF FFCF FFCF FFCF FDFF 01CF CFFE 9AFE"
	$"CF03 FFCF CFFF FECF 03FF CFFF CFFE FF04 CFFF 9ACF 9AFE CF03 FFCF CFFF F6CF 03FF"
	$"FFCF CFFE FF03 CFCF 9A9A FDCF 009A FDCF 00FF FECF 06FF FFCF FFCF FFFF FECF 069A"
	$"CFCF FFCF FFCF FEFF FDCF 03FF CFCF FFEC CF84 CEFC 00CC CEFC 009E CEF6 FFFE CE02"
	$"9CCE CEF3 FF06 CEFF CE9C 9CCE CEF5 FF00 CEFE FF06 CECE 9CCE CEFF CEFE FF00 CEFE"
	$"FF00 CEFE FF00 CEF5 FF07 CE9C CECE 9CFF FFCE F5FF 02CE FFFF FECE 009C F6FF 02CE"
	$"CEFF FBCE 039C FFCE FFF3 CE01 6685 CE01 0000 F9CE 0100 00D2 CE00 00EA CE01 0000"
	$"B3CE 00FF FDCE 059C CEFF CECE FFFE CEFE 9C02 CE9C 9CFE CE09 FF9C CECE 9CFF CEFF"
	$"FFCE FE9C 06CE 9CCE CE9C CE9C FBCE 03FF FFCE FFFE CEFD 9CFD CE04 9CCE 9C9C CEFC"
	$"9CFA CEFE FFFE CE02 9CCE 9CFE CE00 9CF9 CE0D FFCE FFFF CE9C CE9C CE9C CE9C CE9C"
	$"FECE FE9C 00CE FDFF FECE 019C 9CEF CE85 CF01 0000 F9CF 0100 00D2 CF00 00EA CF01"
	$"0000 B3CF 0AFF CFCF FFFF CFFF FFCF CFFF FDCF 009A FCCF 0AFF CFFF CFFF CFCF FFCF"
	$"FFFF F8CF 03FF FFCF CFFE FF04 CFFF FFCF FFFD CF00 9AFE CF00 FFF4 CF03 FFFF CFCF"
	$"FBFF FDCF 059A FFCF FFCF FFFE CF0C FFFF CFFF FFCF FFFF CF9A CF9A 9AF6 CFFC FFFE"
	$"CFFE 9A01 CFFF F2CF 85CE 0100 00F9 CE01 0000 D2CE 0000 EACE 0100 00B3 CEFC FF05"
	$"CEFF FFCE CEFF FBCE F5FF 02CE FFFF FBCE FCFF 00CE FDFF 0ACE FFFF CEFF CEFF CECE"
	$"9CCE FDFF 00CE FEFF 00CE FEFF 00CE FEFF 01CE CEFA FFFB CEF4 FF08 CEFF FFCE 9CCE"
	$"9CCE CEFE FF00 CEF6 FFFE CE02 9C9C CEFE FFF3 CE01 9AA4 CEFC 00E8 CE01 0000 F8CE"
	$"0100 00E6 CEFC 00F3 CE01 0000 EACE 0100 00D5 CEFB 00E5 CE07 FFCE CE9C CE9C CEFF"
	$"FDCE FC9C FECE 0A9C CECE 9CCE 9CCE 9CFF CEFF FECE 019C 9CFD CE04 9CCE CE9C CEFE"
	$"9C02 CEFF FFFA CE02 9CCE CEFE 9C00 CEFE 9C08 CE9C CECE 9C9C CE9C 9CFD CEFE FFFE"
	$"CE06 9CCE 9CCE CE9C 9CFD CE00 9CFE CE02 FFCE FFFC CE04 9C9C CECE 9CF9 CEFD FFFE"
	$"CEFC 9CF2 CEA4 CFFC 00E8 CF01 0000 F8CF 0100 00E6 CFFC 00F3 CF01 0000 EACF 0100"
	$"00D5 CFFB 00E5 CF00 FFFD CF02 FFCF FFFC CF04 9ACF 9ACF FFFE CF0B FFFF CFCF FFCF"
	$"FFFF CFFF CFFF FCCF 04FF FFCF CFFF FCCF FEFF 02CF CFFF FBCF 00FF FECF 00FF FBCF"
	$"03FF CFCF FFFD CFFC FFFD CF02 9ACF FFFE CF0A FFCF CFFF CFFF CFFF FFCF FFFC CF03"
	$"9ACF CFFF FECF 00FF FDCF FCFF FCCF 019A FFF1 CFA4 CEFC 00E8 CE01 0000 F8CE 0100"
	$"00E6 CEFC 00F3 CE01 0000 EACE 0100 00D5 CEFB 00E5 CE02 FFCE CEFC FF05 CECE FFCE"
	$"CE9C FECE FCFF 00CE FBFF 03CE FFCE FFFC CEF8 FF00 CEFE FF02 CECE FFFC CE02 FFFF"
	$"CEFC FF00 CEFC FF00 CEFC FF00 CEFD FFFB CE02 FFFF CEF7 FF02 CEFF FFFD CE01 9CCE"
	$"F8FF 00CE FCFF FCCE 039C FFCE FFF3 CE01 A4A6 CE01 0000 FECE 0100 00E8 CE01 0000"
	$"E8CE 0000 F7CE 0100 00FE CE01 0000 F3CE 0100 00F0 CE00 00CC CE01 0000 E3CE 0AFF"
	$"9C9C CE9C CECE FFCE CEFF FECE 019C 9CFE CE00 9CFB CE07 9CCE FFCE FFFF 9CCE FE9C"
	$"FACE 009C FDCE FDFF 049C FFCE CE9C FBCE 029C CEFF FB9C FDCE 039C CE9C CEFE FF00"
	$"9CFD CE00 9CFB CE0B 9CCE CE9C CECE FFCE FFFF CECE FE9C 02CE CE9C FECE 059C CE9C"
	$"9CCE CEFE FFFB CE00 9CF0 CEA6 CF01 0000 FECF 0100 00E8 CF01 0000 E8CF 0000 F7CF"
	$"0100 00FE CF01 0000 F3CF 0100 00F0 CF00 00CC CF01 0000 E3CF 05FF CFCF FFCF CFFC"
	$"FFF8 CF00 FFFE CF02 FFCF CFFC FF03 9ACF 9A9A FCCF 03FF CFFF CFFE FF00 CFFD FF09"
	$"9AFF FF9A CFCF FFCF CFFF FECF 00FF F7CF 00FF FECF FEFF 01CF FFFE CF04 9ACF FFCF"
	$"FFFE CF04 FFCF CFFF CFFD FF0B CFFF 9ACF CF9A FFCF CFFF CFCF FDFF 00CF FEFF 08CF"
	$"CFFF CF9A 9ACF CFFF F2CF A6CE 0100 00FE CE01 0000 E8CE 0100 00E8 CE00 00F7 CE01"
	$"0000 FECE 0100 00F3 CE01 0000 F0CE 0000 CCCE 0100 00E3 CEF6 FFFB CEF2 FF00 9CFC"
	$"CEFB FF00 CEF9 FF01 9CFF FDCE FCFF 00CE FEFF 03CE FFFF CEF5 FFFC CE00 9CFB FF00"
	$"CEF8 FF02 CECE 9CFE CEFC FF00 CEF9 FFFA CEFE FFF3 CE01 B9A6 CE00 00FD CE00 00E7"
	$"CE01 0000 EACE 0100 00F6 CE00 00FD CE00 00F3 CEFE 00F2 CE01 0000 CCCE 0100 00E2"
	$"CE00 FFFC CE12 9CFF CECE FFCE CE9C CECE 9CCE 9CCE CE9C 9CCE 9CFE CE03 FFCE FFFF"
	$"FCCE 009C FDCE 009C FCCE 049C FFFF CEFF FECE 089C CE9C CECE 9CCE 9CCE FE9C 06CE"
	$"9CCE 9CCE 9C9C FECE 029C CECE FEFF FECE FE9C 0FCE CE9C CE9C CECE 9CCE 9CCE 9CFF"
	$"CEFF FFFE CEFE 9CFD CE01 9CCE FD9C 00CE FEFF FECE FD9C 02CE CE9C F3CE A6CF 0000"
	$"FDCF 0000 E7CF 0100 00EA CF01 0000 F6CF 0000 FDCF 0000 F3CF FE00 F2CF 0100 00CC"
	$"CF01 0000 E2CF FEFF 10CF CFFF CFFF CFCF FFCF CF9A CF9A CFFF CFFF FECF 0AFF CFFF"
	$"CFCF FFCF FFFF CFFF FECF 079A CFCF FFCF FFCF FFFE CFFE FF01 CFFF FDCF 039A CFCF"
	$"FFF3 CF01 FFFF FECF FDFF FDCF 119A 9AFF CFFF CFFF CFFF CFFF CFCF FFFF CFFF FFFA"
	$"CF03 FFFF CFFF FCCF FDFF FECF 069A CFCF 9AFF CFFF F3CF A6CE 0000 FDCE 0000 E7CE"
	$"0100 00EA CE01 0000 F6CE 0000 FDCE 0000 F3CE FE00 F2CE 0100 00CC CE01 0000 E2CE"
	$"F9FF 05CE CEFF CECE 9CFE CEF5 FF00 CEFE FFFC CEF4 FF01 CEFF FBCE FBFF 00CE FEFF"
	$"04CE CEFF FFCE FEFF 00CE FBFF 01CE FFFD CEF8 FF00 CEFE FF02 CEFF FFFB CEFA FF01"
	$"CECE FCFF 06CE FFCE 9CCE CE9C FEFF F3CE 019E A7CE 0100 00FD CE00 00E8 CE01 0000"
	$"E9CE 0100 00F7 CE01 0000 FDCE 0000 F3CE 0100 00F1 CE01 0000 CCCE 0100 00E2 CE07"
	$"FF9C 9CCE 9CCE CEFF FDCE 019C CEFE 9CFB CE04 9CCE CE9C CEFD FF00 CEFD 9CFA CE04"
	$"9CCE CE9C CEFE FF08 CECE FFCE CE9C CECE 9CFE CE05 9CCE 9CCE 9CCE FE9C 00CE FE9C"
	$"FDCE FDFF FECE 039C CECE 9CFD CE00 9CFC CE08 FFCE FFCE FF9C CECE 9CFB CE00 9CFC"
	$"CEFE FFFD CEFE 9C01 CE9C F2CE A7CF 0100 00FD CF00 00E8 CF01 0000 E9CF 0100 00F7"
	$"CF01 0000 FDCF 0000 F3CF 0100 00F1 CF01 0000 CCCF 0100 00E2 CF00 FFFC CF08 FFFF"
	$"CFCF FFCF CFFF 9AFB CF00 FFFC CFFC FF01 CF9A FDCF 01FF FFF8 CFFD FF01 CFFF FECF"
	$"079A FFCF CFFF FFCF FFF5 CF02 FFCF CFFD FFFE CF05 9ACF FFCF CFFF FBCF 06FF CFFF"
	$"CFFF CFFF FDCF 019A FFFE CF00 FFFD CF01 FFCF FEFF 01CF FFEB CFA7 CE01 0000 FDCE"
	$"0000 E8CE 0100 00E9 CE01 0000 F7CE 0100 00FD CE00 00F3 CE01 0000 F1CE 0100 00CC"
	$"CE01 0000 E2CE 02FF CECE FCFF F8CE FBFF 00CE F9FF 01CE 9CFD CEFB FF00 CEF9 FF01"
	$"CEFF FDCE F9FF 00CE FDFF 04CE FFFF CECE F9FF FECE 019C CEFB FF00 CEFB FF03 CEFF"
	$"CEFF FCCE FCFF 00CE F9FF FACE FEFF F3CE 0295 A7CE 0100 00FD CE00 00FC CEFD 00FD"
	$"CEFE 00FE CEFE 00FE CE01 0000 FECE 0100 00FE CEFE 00FD CEFC 0001 CECE FB00 F9CE"
	$"0100 00FD CE00 00FC CEFD 00FC CE01 0000 FECE FE00 FECE 0100 00FE CEFB 0001 CECE"
	$"FE00 FCCE FD00 FCCE 0100 00FE CE01 0000 FDCE FC00 F1CE 0100 00FE CE01 0000 FECE"
	$"0100 00FC CEFD 00F5 CE00 FFFD CE01 9CCE FDFF FECE 069C CE9C CE9C CE9C FECE 009C"
	$"FECE 04FF CEFF FF9C FDCE FE9C 03FF 9CCE CEFD 9C08 CEFF FFCE FF9C CECE 9CFE CE03"
	$"9C9C CECE FE9C 06CE 9C9C CE9C 9CCE FE9C 03CE CE9C CEFE FF06 9CCE CE9C CE9C CEFE"
	$"9CFE CE00 9CFD CE04 FFCE FFFF 9CFE CE00 FFFE 9C04 CE9C CECE 9CFD CEFE FFFD CEFC"
	$"9CF2 CEA7 CF01 0000 FDCF 0000 FCCF FD00 FDCF FE00 FECF FE00 FECF 0100 00FE CF01"
	$"0000 FECF FE00 FDCF FC00 01CF CFFB 00F9 CF01 0000 FDCF 0000 FCCF FD00 FCCF 0100"
	$"00FE CFFE 00FE CF01 0000 FECF FB00 01CF CFFE 00FC CFFD 00FC CF01 0000 FECF 0100"
	$"00FD CFFC 00F1 CF01 0000 FECF 0100 00FE CF01 0000 FCCF FD00 F5CF 06FF CFCF FFCF"
	$"FFCF FCFF F8CF 00FF FBCF 07FF CFFF FFCF FF9A 9AFD CF00 FFFD CFFE FF0E CFFF FFCF"
	$"FFCF FFCF 9A9A FFFF CFCF FFF2 CF02 FFCF CFFE FF06 CFFF CFCF 9ACF FFFE CF00 FFFE"
	$"CF0E FFCF FFCF FFCF FFFF CFFF CFCF FF9A FFF9 CF01 FFCF FEFF 02CF CFFF FECF 039A"
	$"CFCF FFF3 CFA7 CE01 0000 FDCE 0000 FCCE FD00 FDCE FE00 FECE FE00 FECE 0100 00FE"
	$"CE01 0000 FECE FE00 FDCE FC00 01CE CEFB 00F9 CE01 0000 FDCE 0000 FCCE FD00 FCCE"
	$"0100 00FE CEFE 00FE CE01 0000 FECE FB00 01CE CEFE 00FC CEFD 00FC CE01 0000 FECE"
	$"0100 00FD CEFC 00F1 CE01 0000 FECE 0100 00FE CE01 0000 FCCE FD00 F5CE F6FF FBCE"
	$"01FF CEFD FF03 CEFF FFCE FCFF F9CE F4FF 07CE FFCE 9CCE CEFF CEFD FF06 CECE FFFF"
	$"CEFF CEFE FF01 CECE FAFF FBCE 03FF CEFF CEF8 FF02 CEFF FFFD CE03 FF9C FFCE F5FF"
	$"F9CE 01FF FFF3 CE02 CEA7 CE01 0000 F8CE 0200 CECE FE00 01CE CEFD 0000 CEFC 00FE"
	$"CE02 0000 CEFD 0001 CECE FD00 FECE 0500 00CE CE00 00FD CE01 0000 F7CE 0100 00F8"
	$"CE02 00CE CEFE 00FD CE07 0000 CECE 00CE 0000 FECE 0100 00FC CE01 0000 FECE FD00"
	$"FDCE 0200 CECE FE00 01CE CEFD 0000 CEFD 00FE CE05 0000 CECE 0000 F1CE 0200 CECE"
	$"FD00 00CE FD00 FDCE 0400 CECE 0000 F5CE 07FF CECE 9C9C CE9C FFFC CE03 9CCE 9C9C"
	$"FDCE FE9C 00CE FE9C 00FF FECE 0BFF CE9C 9CCE 9CCE CE9C CECE 9CFE CE06 9CCE FFFF"
	$"CECE FFFE CE00 9CFC CE0A 9C9C CE9C 9CCE 9CCE 9CCE 9CFE CE04 9CCE 9C9C FFFB CE00"
	$"9CFA CE02 9CCE 9CFE CE0F FFCE CEFF CE9C CECE 9C9C CECE 9CCE CE9C FCCE 01FF FFFC"
	$"CEFE 9C02 CECE 9CF3 CEA7 CF01 0000 F8CF 0200 CFCF FE00 01CF CFFD 0000 CFFC 00FE"
	$"CF02 0000 CFFD 0001 CFCF FD00 FECF 0500 00CF CF00 00FD CF01 0000 F7CF 0100 00F8"
	$"CF02 00CF CFFE 00FD CF07 0000 CFCF 00CF 0000 FECF 0100 00FC CF01 0000 FECF FD00"
	$"FDCF 0200 CFCF FE00 01CF CFFD 0000 CFFD 00FE CF05 0000 CFCF 0000 F1CF 0200 CFCF"
	$"FD00 00CF FD00 FDCF 0400 CFCF 0000 F5CF 00FF FCCF 01FF FFFC CF04 9ACF CF9A FFFE"
	$"CF01 FFFF FCCF 00FF FECF 00FF FDCF 009A FCCF 00FF FDCF FEFF 02CF CFFF FBCF 00FF"
	$"F8CF 00FF F8CF 01FF FFFA CF08 9AFF CFFF CFCF FFCF FFFE CF04 FFFF CFCF FFFA CF05"
	$"FFFF CFFF CFFF FECF FEFF 01CF FFFE CF03 9A9A CFFF F1CF A7CE 0100 00F8 CE02 00CE"
	$"CEFE 0001 CECE FD00 00CE FC00 FECE 0200 00CE FD00 01CE CEFD 00FE CE05 0000 CECE"
	$"0000 FDCE 0100 00F7 CE01 0000 F8CE 0200 CECE FE00 FDCE 0700 00CE CE00 CE00 00FE"
	$"CE01 0000 FCCE 0100 00FE CEFD 00FD CE02 00CE CEFE 0001 CECE FD00 00CE FD00 FECE"
	$"0500 00CE CE00 00F1 CE02 00CE CEFD 0000 CEFD 00FD CE04 00CE CE00 00F5 CEFD FF00"
	$"CEFE FF08 CECE FFCE CE9C CEFF 9CFA FF00 CEFD FFFE CE00 FFFE CE01 FF9C F8FF 00CE"
	$"FEFF 02CE CEFF FDCE FCFF 00CE FEFF 00CE F6FF 00CE FDFF FBCE FBFF 00CE FBFF 02CE"
	$"CEFF FDCE 01FF CEFC FF00 CEFA FF02 CECE FFFC CEFE FFF3 CE02 95A6 CE01 0000 FACE"
	$"0100 00FE CE01 0000 FDCE FD00 03CE CE00 00FE CEFE 0009 CECE 0000 CE00 00CE 0000"
	$"FECE 0100 00FA CE01 0000 F5CE 0100 00FA CE01 0000 FECE 0100 00FE CEFE 00FD CE05"
	$"0000 CECE 0000 FCCE 0100 00FE CE04 0000 CE00 00FE CE01 0000 FECE 0100 00FD CEFE"
	$"0003 CECE 0000 FECE 0100 00EE CE01 0000 FDCE FE00 03CE CE00 00FE CE00 00F0 CE07"
	$"FF9C 9CCE 9CCE CEFF FDCE 009C FCCE 019C 9CFD CE00 9CFE CE00 FFF8 CE04 9C9C CECE"
	$"9CFB CE00 FFFA CE0A 9CCE CE9C CECE 9CCE 9C9C CEFE 9C03 CE9C CE9C FBCE 00FF FBCE"
	$"039C 9CCE 9CFE CE00 9CFB CE02 FF9C FFF9 CE01 9C9C FBCE 009C F9CE 039C 9CCE 9CF1"
	$"CEA6 CF01 0000 FACF 0100 00FE CF01 0000 FDCF FD00 03CF CF00 00FE CFFE 0009 CFCF"
	$"0000 CF00 00CF 0000 FECF 0100 00FA CF01 0000 F5CF 0100 00FA CF01 0000 FECF 0100"
	$"00FE CFFE 00FD CF05 0000 CFCF 0000 FCCF 0100 00FE CF04 0000 CF00 00FE CF01 0000"
	$"FECF 0100 00FD CFFE 0003 CFCF 0000 FECF 0100 00EE CF01 0000 FDCF FE00 03CF CF00"
	$"00FE CF00 00F0 CFFE FF07 CFCF FFCF FFCF CFFF F8CF 00FF FECF 04FF CFCF FFFF FDCF"
	$"00FF FACF 01FF FFFB CF00 FFFA CF05 9ACF FFCF CFFF FDCF 00FF FDCF 01FF FFFD CF03"
	$"FFCF CFFF FBCF 009A FDCF 01FF FFFE CF06 FFCF FFCF FFCF FFFA CF05 FF9A CFFF CFCF"
	$"FDFF F6CF 019A FFF2 CFA6 CE01 0000 FACE 0100 00FE CE01 0000 FDCE FD00 03CE CE00"
	$"00FE CEFE 0009 CECE 0000 CE00 00CE 0000 FECE 0100 00FA CE01 0000 F5CE 0100 00FA"
	$"CE01 0000 FECE 0100 00FE CEFE 00FD CE05 0000 CECE 0000 FCCE 0100 00FE CE04 0000"
	$"CE00 00FE CE01 0000 FECE 0100 00FD CEFE 0003 CECE 0000 FECE 0100 00EE CE01 0000"
	$"FDCE FE00 03CE CE00 00FE CE00 00F0 CE02 FFCE CEFC FFF8 CEF5 FFF8 CEFB FF00 CEFC"
	$"FFF8 CEFC FF05 CEFF CEFF FFCE FDFF 00CE FAFF FBCE 019C CEF4 FF01 CEFF FACE F6FF"
	$"FECE 06FF 9CCE CE9C 9CCE FEFF F3CE 02AE A5CE 0100 00FB CE00 00FD CE01 0000 FDCE"
	$"FE00 FECE 0300 00CE CEFE 00FE CE01 0000 FECE FE00 FECE FE00 FBCE 0100 00F4 CE01"
	$"0000 FBCE 0000 FDCE 0100 00FE CE01 0000 FDCE 0100 00FE CE01 0000 FCCE 0100 00FC"
	$"CEFE 00FE CE00 00FD CE01 0000 FDCE 0100 00FE CE01 0000 FECE FE00 EFCE 0100 00FD"
	$"CE01 0000 FECE 0500 00CE CE00 00F0 CE00 FFFA CE04 9C9C CE9C CEFD 9CF5 CE03 9CCE"
	$"9CCE FC9C FCCE 009C FECE 009C FECE F99C 0FCE CE9C CE9C 9CCE CE9C CE9C 9CCE 9CCE"
	$"9CFE CE00 9CFE CEFA 9C02 CECE 9CFA CE00 9CFD CE01 9CCE FB9C 08CE CEFF 9CCE 9CCE"
	$"9C9C FCCE FE9C 00CE FE9C 01CE 9CF2 CEA5 CF01 0000 FBCF 0000 FDCF 0100 00FD CFFE"
	$"00FE CF03 0000 CFCF FE00 FECF 0100 00FE CFFE 00FE CFFE 00FB CF01 0000 F4CF 0100"
	$"00FB CF00 00FD CF01 0000 FECF 0100 00FD CF01 0000 FECF 0100 00FC CF01 0000 FCCF"
	$"FE00 FECF 0000 FDCF 0100 00FD CF01 0000 FECF 0100 00FE CFFE 00EF CF01 0000 FDCF"
	$"0100 00FE CF05 0000 CFCF 0000 F0CF 00FF FECF 0DFF CFFF CF9A 9ACF 9ACF CF9A 9ACF"
	$"FFFE CF0F FFCF FFCF FFFF CFFF 9ACF CF9A 9ACF CF9A FACF FDFF 07CF FFCF 9ACF 9A9A"
	$"CFFE 9A01 CFFF F3CF FEFF 03CF FFFF CFFD 9A0F CF9A 9ACF FFCF FFCF FFCF FFCF CFFF"
	$"CFFF FDCF 029A 9ACF FE9A 05FF CFFF CFFF FFFD CF00 FFFE CF03 9A9A CFCF FE9A 02FF"
	$"CFFF F3CF A5CE 0100 00FB CE00 00FD CE01 0000 FDCE FE00 FECE 0300 00CE CEFE 00FE"
	$"CE01 0000 FECE FE00 FECE FE00 FBCE 0100 00F4 CE01 0000 FBCE 0000 FDCE 0100 00FE"
	$"CE01 0000 FDCE 0100 00FE CE01 0000 FCCE 0100 00FC CEFE 00FE CE00 00FD CE01 0000"
	$"FDCE 0100 00FE CE01 0000 FECE FE00 EFCE 0100 00FD CE01 0000 FECE 0500 00CE CE00"
	$"00F0 CEFB FF06 CECE 9C9C CE9C CEFE 9C03 CEFF FFCE F9FF 05CE 9CCE CE9C CEFE 9C00"
	$"CEF6 FF06 CEFF 9CCE 9C9C CEFE 9CFB FF07 CEFF CEFF FFCE FFCE FAFF 01CE FFFA 9C00"
	$"CEF6 FF01 CEFF FECE FC9C 00CE F7FF 0ACE FFFF CE9C 9CCE 9CCE CE9C FEFF F3CE 02D0"
	$"A5CE FE00 FDCE 0100 00FD CE01 0000 FDCE 0100 00FD CE05 0000 CECE 0000 FECE 0100"
	$"00FD CE01 0000 FCCE FE00 FCCE 0100 00F4 CEFE 00FD CE01 0000 FDCE 0100 00FE CE01"
	$"0000 FDCE 0100 00FE CE01 0000 FCCE 0100 00FC CE01 0000 FECE 0100 00FD CE01 0000"
	$"FECE 0100 00FE CE01 0000 FCCE FE00 F0CE 0100 00FE CE01 0000 FECE 0100 00FE CE00"
	$"00EF CE06 FFCE CE9C CECE FFFE CE0E 9C9C CE9C CE9C 9CCE CE9C CECE 9CCE 9CFB CEFE"
	$"9CFE CEFD 9CFD CE0D 9C9C CEFF CEFF 9C9C CE9C 9CCE 9C9C FECE 089C 9CCE 9CCE 9CCE"
	$"9C9C FECE 0C9C CECE 9CCE CEFF FFCE CE9C 9CCE FE9C FACE 069C 9CCE CEFF CECE FD9C"
	$"00CE FE9C 05CE CE9C CECE 9CFD CEFE FFF9 9C02 CECE 9CF3 CEA5 CFFE 00FD CF01 0000"
	$"FDCF 0100 00FD CF01 0000 FDCF 0500 00CF CF00 00FE CF01 0000 FDCF 0100 00FC CFFE"
	$"00FC CF01 0000 F4CF FE00 FDCF 0100 00FD CF01 0000 FECF 0100 00FD CF01 0000 FECF"
	$"0100 00FC CF01 0000 FCCF 0100 00FE CF01 0000 FDCF 0100 00FE CF01 0000 FECF 0100"
	$"00FC CFFE 00F0 CF01 0000 FECF 0100 00FE CF01 0000 FECF 0000 EFCF 00FF FECF 02FF"
	$"CFFF FECF 059A 9ACF 9ACF 9AFC CF01 FFFF FECF 00FF FDCF FE9A 03CF CF9A 9AFC CF00"
	$"FFFE CF0D FFCF FFFF 9A9A CF9A 9ACF 9A9A CFFF F7CF 00FF FACF FEFF 0CCF CF9A 9ACF"
	$"9A9A CFCF FFCF CFFF FBCF 0EFF CFCF 9ACF 9A9A CF9A 9ACF CFFF CFFF FBCF FEFF 00CF"
	$"FD9A 04CF CF9A CFFF F2CF A5CE FE00 FDCE 0100 00FD CE01 0000 FDCE 0100 00FD CE05"
	$"0000 CECE 0000 FECE 0100 00FD CE01 0000 FCCE FE00 FCCE 0100 00F4 CEFE 00FD CE01"
	$"0000 FDCE 0100 00FE CE01 0000 FDCE 0100 00FE CE01 0000 FCCE 0100 00FC CE01 0000"
	$"FECE 0100 00FD CE01 0000 FECE 0100 00FE CE01 0000 FCCE FE00 F0CE 0100 00FE CE01"
	$"0000 FECE 0100 00FE CE00 00EF CEFE FF00 CEFE FFFE CE09 9C9C CE9C CE9C CEFF FFCE"
	$"FCFF 05CE FFCE CE9C CEFE 9CFE CE00 9CF7 FF0A CEFF FF9C 9CCE 9C9C CE9C 9CFE FF03"
	$"CEFF FFCE FEFF 00CE F5FF 07CE CE9C 9CCE 9C9C CEF9 FF05 CEFF CEFF FFCE FD9C 06CE"
	$"9C9C CEFF FFCE F7FF 00CE FA9C FEFF F3CE 02D4 A4CE FE00 FECE 0100 00FD CE01 0000"
	$"FDCE 0100 00FD CE00 00FE CE01 0000 FECE 0100 00FD CE01 0000 FBCE 0100 00FC CE01"
	$"0000 F3CE FE00 FECE 0100 00FD CE01 0000 FECE 0100 00FD CE01 0000 FECE 0100 00FC"
	$"CE01 0000 FCCE 0100 00FE CE01 0000 FDCE 0100 00FE CE01 0000 FECE 0100 00FB CE01"
	$"0000 F1CE 0100 00FD CE01 0000 FECE 0500 00CE CE00 00EF CE00 FFFE 9C03 CEFF FFCE"
	$"FDFF 01CE 9CFD CE02 9CCE 9CFD CE01 9CCE FEFF 15CE FFCE 9CCE CE9C CEFF FFCE 9CCE"
	$"9CCE 9C9C CEFF CECE FFFB CE02 9CCE CEF4 9C06 FFCE CE9C CECE FFFE CE02 FFCE 9CFC"
	$"CE11 9CCE CE9C CECE 9CCE FFFF CEFF FFCE FFCE 9CFF FBCE 049C CE9C CECE FDFF 03CE"
	$"CEFF 9CFE CE02 FFFF 9CF2 CEA4 CFFE 00FE CF01 0000 FDCF 0100 00FD CF01 0000 FDCF"
	$"0000 FECF 0100 00FE CF01 0000 FDCF 0100 00FB CF01 0000 FCCF 0100 00F3 CFFE 00FE"
	$"CF01 0000 FDCF 0100 00FE CF01 0000 FDCF 0100 00FE CF01 0000 FCCF 0100 00FC CF01"
	$"0000 FECF 0100 00FD CF01 0000 FECF 0100 00FE CF01 0000 FBCF 0100 00F1 CF01 0000"
	$"FDCF 0100 00FE CF05 0000 CFCF 0000 EFCF 00FF FDCF 02FF FFCF FDFF FBCF 00FF FDCF"
	$"00FF FECF FEFF 02CF FFFF FCCF 06FF FFCF FFCF CFFF FECF 06FF CFCF FFCF CFFF FECF"
	$"039A CFCF 9AF5 CFFE FF04 9AFF CFFF CFFE FFFC CF08 FFCF 9ACF CFFF FFCF CFFE FF10"
	$"CFFF FFCF FFCF CFFF CFCF FFCF FFCF CFFF CFFB FF02 CFCF FFFD CF03 FFFF 9AFF F3CF"
	$"A4CE FE00 FECE 0100 00FD CE01 0000 FDCE 0100 00FD CE00 00FE CE01 0000 FECE 0100"
	$"00FD CE01 0000 FBCE 0100 00FC CE01 0000 F3CE FE00 FECE 0100 00FD CE01 0000 FECE"
	$"0100 00FD CE01 0000 FECE 0100 00FC CE01 0000 FCCE 0100 00FE CE01 0000 FDCE 0100"
	$"00FE CE01 0000 FECE 0100 00FB CE01 0000 F1CE 0100 00FD CE01 0000 FECE 0500 00CE"
	$"CE00 00EF CEFD FF03 CEFF FFCE FDFF FACE FAFF 00CE FEFF 01CE FFFB CEFA FFFE CE03"
	$"FFCE CEFF FBCE 0C9C CECE 63FF FFCE FFCE FFCE FFCE FBFF 04CE FFCE FFCE FEFF FACE"
	$"0063 FDFF 00CE FDFF 07CE FFFF CEFF CECE FFFD CEFD FF00 CEFB FF02 CECE FFFD CE03"
	$"FFFF 63FF F3CE 02C4 A3CE 0100 00FE CE01 0000 FDCE 0000 FDCE 0100 00FD CE01 0000"
	$"FECE 0100 00FE CE01 0000 FDCE 0100 00FA CE01 0000 FECE 0100 00F1 CE01 0000 FECE"
	$"0100 00FD CE00 00FE CE01 0000 FECE 0200 CE00 FECE 0100 00FC CE01 0000 FBCE 0100"
	$"00FE CE01 0000 FDCE 0000 FDCE 0100 00FE CE01 0000 FACE 0100 00F2 CE01 0000 FDCE"
	$"0100 00FE CE05 0000 CECE 0000 EFCE 00FF FECE 03FF FFCE CEFD FFFE CE04 FFCE CEFF"
	$"9CFC CE05 9CFF FFCE FFCE FEFF FDCE 02FF FF9C FECE 059C CECE FFFF CEFC FFFE CE02"
	$"FFCE FFFE CE07 9CCE CE9C CECE 9CCE FE9C 04CE CE9C CEFF FDCE 01FF FFFC CE02 FFCE"
	$"9CFB CE06 FFCE CEFF CEFF FFFB CE01 FF9C FBCE FAFF FCCE 02FF CE9C F3CE A3CF 0100"
	$"00FE CF01 0000 FDCF 0000 FDCF 0100 00FD CF01 0000 FECF 0100 00FE CF01 0000 FDCF"
	$"0100 00FA CF01 0000 FECF 0100 00F1 CF01 0000 FECF 0100 00FD CF00 00FE CF01 0000"
	$"FECF 0200 CF00 FECF 0100 00FC CF01 0000 FBCF 0100 00FE CF01 0000 FDCF 0000 FDCF"
	$"0100 00FE CF01 0000 FACF 0100 00F2 CF01 0000 FDCF 0100 00FE CF05 0000 CFCF 0000"
	$"EFCF FEFF 04CF FFFF CFCF FDFF FECF 0DFF CFCF FFCF FFFF CFCF FFCF FFFF CFFC FFFD"
	$"CF04 FFFF CFCF FFFD CF02 FFFF CFFA FF03 CFFF CFFF F9CF 00FF FCCF FEFF 01CF FFFD"
	$"CF09 FFFF CFCF FFCF CFFF CFFF FECF 09FF CFCF FFCF CFFF CFFF FFFB CF07 FFCF CFFF"
	$"CFFF CFCF FAFF FDCF 01FF FFF1 CFA3 CE01 0000 FECE 0100 00FD CE00 00FD CE01 0000"
	$"FDCE 0100 00FE CE01 0000 FECE 0100 00FD CE01 0000 FACE 0100 00FE CE01 0000 F1CE"
	$"0100 00FE CE01 0000 FDCE 0000 FECE 0100 00FE CE02 00CE 00FE CE01 0000 FCCE 0100"
	$"00FB CE01 0000 FECE 0100 00FD CE00 00FD CE01 0000 FECE 0100 00FA CE01 0000 F2CE"
	$"0100 00FD CE01 0000 FECE 0500 00CE CE00 00EF CEFB FF01 CECE FDFF FECE 02FF FFCE"
	$"F7FF 02CE FFCE FEFF FDCE 02FF FFCE F9FF 00CE FBFF 05CE CEFF CEFF CEF8 FF02 CEFF"
	$"CEFD FF01 CEFF FDCE FEFF FDCE 01FF CEFB FF07 CEFF CECE FFCE FFFF FCCE FAFF 01CE"
	$"CEFA FFFD CE03 FFFF CEFF F3CE 02F2 A3CE 0100 00FE CE01 0000 FECE 0100 00FD CE01"
	$"0000 FDCE 0000 FDCE 0500 00CE CE00 00FD CE03 0000 CECE FE00 FECE 0100 00FE CE04"
	$"0000 CE00 00F4 CE01 0000 FECE 0100 00FE CE01 0000 FECE 0900 00CE CE00 CE00 00CE"
	$"CEFE 00FC CE0E 0000 CE00 00CE CE00 00CE CE00 CE00 00FE CE01 0000 FDCE 0500 00CE"
	$"CE00 00FE CE01 0000 FECE 0100 00F2 CE01 0000 FDCE 0500 00CE CE00 00FE CE01 0000"
	$"FDCE 0000 F4CE 04FF CECE 9CCE FEFF 03CE CEFF FFFE CE00 9CFE CE05 9CCE CE9C CE9C"
	$"F8CE 019C 9CFD CE0C 9CCE CE9C CE9C 9CCE CEFF CEFF FFFD CE01 FF9C FECE 089C CECE"
	$"9C9C CE9C 9CCE FE9C F7CE 06FF CECE FFCE CEFF FBCE 029C CE9C FDCE 05FF CEFF 9CCE"
	$"FFFC CE00 9CFC CE00 FFF4 CE00 9CF3 CEA3 CF01 0000 FECF 0100 00FE CF01 0000 FDCF"
	$"0100 00FD CF00 00FD CF05 0000 CFCF 0000 FDCF 0300 00CF CFFE 00FE CF01 0000 FECF"
	$"0400 00CF 0000 F4CF 0100 00FE CF01 0000 FECF 0100 00FE CF09 0000 CFCF 00CF 0000"
	$"CFCF FE00 FCCF 0E00 00CF 0000 CFCF 0000 CFCF 00CF 0000 FECF 0100 00FD CF05 0000"
	$"CFCF 0000 FECF 0100 00FE CF01 0000 F2CF 0100 00FD CF05 0000 CFCF 0000 FECF 0100"
	$"00FD CF00 00F4 CF00 FFFD CFFE FF06 CFCF FFFF CFCF FFFE CF01 FFFF FDCF 04FF CFFF"
	$"CFFF F5CF 0BFF CFCF FFCF CFFF CFFF CFFF FFFD CF07 FFCF FFCF FFCF CFFF F2CF 00FF"
	$"FECF 0BFF CFCF FFCF CFFF CFFF CFCF FFF9 CF08 FFCF FFCF CFFF CFCF FFFE CF05 FFCF"
	$"FFCF CFFF FDCF 00FF FACF 00FF F2CF A3CE 0100 00FE CE01 0000 FECE 0100 00FD CE01"
	$"0000 FDCE 0000 FDCE 0500 00CE CE00 00FD CE03 0000 CECE FE00 FECE 0100 00FE CE04"
	$"0000 CE00 00F4 CE01 0000 FECE 0100 00FE CE01 0000 FECE 0900 00CE CE00 CE00 00CE"
	$"CEFE 00FC CE0E 0000 CE00 00CE CE00 00CE CE00 CE00 00FE CE01 0000 FDCE 0500 00CE"
	$"CE00 00FE CE01 0000 FECE 0100 00F2 CE01 0000 FDCE 0500 00CE CE00 00FE CE01 0000"
	$"FDCE 0000 F4CE FDFF 00CE FEFF 03CE CEFF FFFB CEFC FF07 CEFF FFCE FFCE CEFF FACE"
	$"FCFF 00CE FEFF 00CE FCFF FDCE 02FF CECE FAFF 05CE FFCE FFFF CEFB FF0A CECE FFCE"
	$"CEFF CECE FFCE CEF7 FF0C CEFF CECE FFCE FFCE CEFF CEFF CEF7 FFF7 CE01 FFFF F2CE"
	$"0327 ABCE 0100 00FB CE01 0000 FECE FE00 02CE CE00 FCCE 0100 00FE CE00 00FD CE01"
	$"0000 FECE FD00 08CE CE00 00CE 00CE 0000 FECE 0000 FDCE FD00 FBCE 0100 00FB CE01"
	$"0000 FECE FE00 02CE CE00 FDCE FD00 01CE CEFD 0000 CEFD 00FE CEFD 00FE CE05 0000"
	$"CE00 CECE FE00 02CE CE00 FDCE 0100 00FE CEFD 0002 CE00 00FE CE00 00FE CE01 0000"
	$"F7CE FE00 FECE 0100 00FE CEFD 0002 CE00 00FE CE03 00CE 0000 F6CE 05FF 9C9C CECE"
	$"9CFD CEFE 9C04 CECE 9C9C 63FE CE06 9CCE 9CCE 9CCE 9CFB CE03 FFFF 9C9C FBCE FE9C"
	$"06CE 9CCE FFCE 9C9C FDCE FE9C 03CE CE9C CEFE 9C00 CEFE 9C01 CECE FD9C FECE 09FF"
	$"CECE 9CCE CE9C CE9C 9CFD CE03 9C9C CE9C FECE 05FF CECE 9CCE CEFE 9C07 CE9C 9CCE"
	$"CE9C 9CCE FE9C 0ACE FFFF 9CCE 9CCE 9CCE CE9C F0CE ABCF 0100 00FB CF01 0000 FECF"
	$"FE00 02CF CF00 FCCF 0100 00FE CF00 00FD CF01 0000 FECF FD00 08CF CF00 00CF 00CF"
	$"0000 FECF 0000 FDCF FD00 FBCF 0100 00FB CF01 0000 FECF FE00 02CF CF00 FDCF FD00"
	$"01CF CFFD 0000 CFFD 00FE CFFD 00FE CF05 0000 CF00 CFCF FE00 02CF CF00 FDCF 0100"
	$"00FE CFFD 0002 CF00 00FE CF00 00FE CF01 0000 F7CF FE00 FECF 0100 00FE CFFD 0002"
	$"CF00 00FE CF03 00CF 0000 F6CF 00FF FECF 00FF FECF 03FF FFCF 9AFE CFFE 9A02 CFCF"
	$"FFFB CF02 9ACF FFFD CF03 FFFF 9A9A FEFF 03CF CFFF 9AFE CF02 9AFF FFFA CF07 9A9A"
	$"FFCF FFCF CFFF F9CF 00FF FECF 03FF CFCF FFFA CF00 9AFE CF07 FFCF FFCF FFCF FFCF"
	$"FEFF FCCF 039A 9ACF 9AFE FFFE CF02 FFFF 9AFE FF02 CFCF 9AFD CF03 9AFF CFFF F3CF"
	$"ABCE 0100 00FB CE01 0000 FECE FE00 02CE CE00 FCCE 0100 00FE CE00 00FD CE01 0000"
	$"FECE FD00 08CE CE00 00CE 00CE 0000 FECE 0000 FDCE FD00 FBCE 0100 00FB CE01 0000"
	$"FECE FE00 02CE CE00 FDCE FD00 01CE CEFD 0000 CEFD 00FE CEFD 00FE CE05 0000 CE00"
	$"CECE FE00 02CE CE00 FDCE 0100 00FE CEFD 0002 CE00 00FE CE00 00FE CE01 0000 F7CE"
	$"FE00 FECE 0100 00FE CEFD 0002 CE00 00FE CE03 00CE 0000 F6CE 04FF CECE FFFF FBCE"
	$"009C FECE FE9C FAFF 03CE FF9C FFFC CE03 FFFF 9CCE FBFF 00CE FEFF 059C CEFF CECE"
	$"9CFD CE01 9CCE FDFF 06CE FFFF CEFF FFCE FDFF 01CE CEFC FF02 CECE 9CFC CE00 9CFC"
	$"FF00 CEFE FF02 CECE FFFE CE06 9CCE CE9C 9CCE CEFD FF00 CEFE FF06 9CCE FFFF CECE"
	$"9CFD CE00 9CFE FFF3 CE02 A3AB CE01 0000 FCCE 0100 00FC CEFD 00FB CEFC 00FC CE01"
	$"0000 FECE 0100 00FD CEFE 00FE CEFD 00FC CE01 0000 F9CE 0100 00FC CE01 0000 FCCE"
	$"FD00 FCCE FE00 FECE 0100 00FE CE01 0000 FCCE 0100 00FC CEFE 00FD CEFD 00FC CE01"
	$"0000 FECE 0100 00FD CEFD 00FD CE01 0000 F9CE FB00 03CE CE00 00FE CE01 0000 FDCE"
	$"FD00 03CE CE00 00F6 CE00 FFFD CE00 9CFA CE01 9CCE FE9C 01CE 9CFB CE00 9CFC CE00"
	$"9CFE CE04 9C9C CECE 9CFA CE00 9CFD CE00 9CFE CEFE 9C02 CECE 9CFE CE0B 9CCE 9CCE"
	$"9C9C CECE 9CCE CE9C FBCE 069C CECE 9CCE 9C9C EFCE FD9C F9CE 019C FFFE CE00 9CFE"
	$"CE05 9C9C 63CE FF9C F3CE ABCF 0100 00FC CF01 0000 FCCF FD00 FBCF FC00 FCCF 0100"
	$"00FE CF01 0000 FDCF FE00 FECF FD00 FCCF 0100 00F9 CF01 0000 FCCF 0100 00FC CFFD"
	$"00FC CFFE 00FE CF01 0000 FECF 0100 00FC CF01 0000 FCCF FE00 FDCF FD00 FCCF 0100"
	$"00FE CF01 0000 FDCF FD00 FDCF 0100 00F9 CFFB 0003 CFCF 0000 FECF 0100 00FD CFFD"
	$"0003 CFCF 0000 F6CF 00FF FDCF 019A FFFB CF01 9ACF FE9A 09CF 9AFF CFFF CFFF CFCF"
	$"FFFC CF10 FFCF CF9A 9ACF CF9A CFCF FFCF FFFF CF9A FFFC CF01 FFCF FE9A 02CF CF9A"
	$"FDCF 00FF F7CF 05FF CFFF CFFF FFFD CFFE 9AFD CF04 FFCF FFCF FFFE CF00 FFFC CF08"
	$"9A9A CF9A FFCF FFCF CFFE FF04 9AFF CFCF FFFD CFFE 9A01 CF9A F2CF ABCE 0100 00FC"
	$"CE01 0000 FCCE FD00 FBCE FC00 FCCE 0100 00FE CE01 0000 FDCE FE00 FECE FD00 FCCE"
	$"0100 00F9 CE01 0000 FCCE 0100 00FC CEFD 00FC CEFE 00FE CE01 0000 FECE 0100 00FC"
	$"CE01 0000 FCCE FE00 FDCE FD00 FCCE 0100 00FE CE01 0000 FDCE FD00 FDCE 0100 00F9"
	$"CEFB 0003 CECE 0000 FECE 0100 00FD CEFD 0003 CECE 0000 F6CE FCFF 019C FFFB CE08"
	$"9CCE 9C9C CECE 9CCE CEFC FFF8 CE00 9CFE CE01 9CCE FBFF 009C F9CE FE9C 08CE 9C9C"
	$"CEFF FFCE FFCE FEFF 01CE CEFA FFFA CEFE 9C03 CE9C CECE FCFF F8CE FE9C FDCE FCFF"
	$"009C FEFF FDCE FE9C 02CE CE9C F2CE 01B0 ABCE FE00 FECE 0100 00F2 CEFE 00D5 CEFE"
	$"00FE CE01 0000 B6CE 0000 D2CE 07FF CECE 9CCE 9CCE FFFB CE04 9C9C CE9C 9CFD FF02"
	$"CECE 9CFE CE04 9CCE FFCE CEFE 9CFE CE04 FFFF 9CFF CEFE 9C06 CEFF CE9C CECE FFFE"
	$"CE03 9C9C CE9C FECE 089C CE9C CE9C 9CFF 9C9C FBCE 00FF FECE 04FF CE9C CECE FD9C"
	$"07FF FF9C CECE 9CCE 9CFC CE0C FFCE CE9C CE9C CE9C CEFF 9CCE 9CFD CE01 9C9C F8CE"
	$"019C FFF3 CEAB CFFE 00FE CF01 0000 F2CF FE00 D5CF FE00 FECF 0100 00B6 CF00 00D2"
	$"CFFE FFFD CF00 FFFE CF07 FFCF FF9A 9ACF 9ACF FCFF 01CF 9AFD CF03 FFFF CFCF FE9A"
	$"FECF 04FF FF9A FFFF FE9A 06CF FFCF CFFF CFFF FECF 079A 9ACF 9AFF CFCF FFFC CF00"
	$"FFFE CF01 FFFF FECF 00FF FECF 0CFF CF9A CFCF 9ACF 9A9A FFFF 9AFF FECF 019A FFFD"
	$"CF00 FFFD CF06 9ACF 9ACF FFCF FFFC CF04 9A9A CFCF FFFB CF01 9AFF F3CF ABCE FE00"
	$"FECE 0100 00F2 CEFE 00D5 CEFE 00FE CE01 0000 B6CE 0000 D2CE FEFF 049C CE9C CEFF"
	$"FBCE 049C CECE 9C9C FCFF 0BCE 9CCE CEFF CECE FFCE CE9C 9CFD CE04 FFFF 63FF FFFE"
	$"9C01 CEFF FDCE 00FF FBCE 009C F2FF FECE 00FF FECE 02FF CE9C FECE 089C CE9C FFFF"
	$"63FF CE9C FACE 00FF FBCE 049C CEFF 9CFF FDCE 03FF 9C9C FFFB CE03 9CCE 9CFF F3CE"
	$"0195 A9CE FD00 F0CE 0100 00D2 CEFD 00B4 CE00 00D2 CE00 FFFE CE00 FFF9 CE08 9CCE"
	$"CE9C CE9C 9CFF FFFD CE00 FFFB CE04 9CCE CE9C CEFE 9C01 FFFF FDCE 03FF CECE FFFD"
	$"CE04 9CCE 9C9C CEFE 9C02 FF9C CEFE 9C05 CECE 9C9C CE9C FECE 03FF FFCE FFFB CE01"
	$"9CCE FE9C 06FF FFCE 9CCE CEFF FACE 0F9C CECE 9CCE 9C9C CEFF FFCE CEFF FFCE FFFE"
	$"CE00 FFFE CEFB 9CF3 CEA9 CFFD 00F0 CF01 0000 D2CF FD00 B4CF 0000 D2CF 00FF FECF"
	$"00FF FECF 01FF FFFE CF0D 9AFF 9ACF CF9A 9AFF FFCF FFCF FFFF FCCF 05FF CFFF FF9A"
	$"CFFE 9A01 FFFF FDCF 03FF CFCF FFFE CF05 FFCF FFCF 9ACF FE9A 00FF F7CF 00FF FECF"
	$"03FF FFCF FFFE CF0E FFCF FF9A CF9A 9ACF FFFF CFCF FFCF FFFD CF00 FFFD CF08 FF9A"
	$"CF9A 9ACF FFFF CFFE FF00 CFFE FF01 CFFF FECF FE9A 02CF 9A9A F3CF A9CE FD00 F0CE"
	$"0100 00D2 CEFD 00B4 CE00 00D2 CEFE FF01 CEFF FECE 01FF FFFE CE06 9CCE 9CCE CE9C"
	$"9CFA FFFE CE00 FFFC CE01 9CCE FE9C FDFF 07CE CEFF CECE FFCE FFFC CE01 9CCE FE9C"
	$"FEFF 06CE FFCE FFCE FFCE FDFF 03CE FFFF CEFE FFFB CEFE 9C02 FFFF CEFD FF04 CECE"
	$"FFCE FFFC CE04 9CCE 9C9C CEFB FFFC CE00 FFFC CEFD 9CF3 CE01 2794 CE01 0000 83CE"
	$"0100 00D1 CEFB FF01 CECE FEFF 02CE CEFF FACE 03FF CEFF CEF9 FFF7 CE00 9CF7 FFFD"
	$"CE0D 9CCE CE9C 9CFF CECE 9CCE 9CCE 9CCE FE9C FBFF 00CE FEFF 03CE CEFF 9CFE CE00"
	$"9CFE CE06 FFCE FFCE FFFF CEFD FF02 CECE FFFD CE04 9CCE CEFF CEFE FF00 CEFC FFFD"
	$"CE03 9CCE 9C9C F3CE 94CF 0100 0083 CF01 0000 D1CF FBFF 07CF FFCF CFFF FFCF FFFA"
	$"CFF5 FFF7 CFF6 FFFD CF06 9ACF CF9A CFFF FFFD CF05 FFFF CFCF FF9A F7FF 03CF CFFF"
	$"9AFE CF0A 9ACF FFCF FFCF FFCF FFFF CFFC FF01 CFFF FDCF 049A CFCF FFCF FEFF 00CF"
	$"FBFF FCCF 009A F2CF 94CE 0100 0083 CE01 0000 D1CE FBFF 07CE FFCE CEFF FFCE FFFA"
	$"CEF5 FFF7 CEF5 FFFE CE09 9CCE CE9C 9CFF CEFF FFCE FBFF 00CE FBFF 00CE FEFF 03CE"
	$"CEFF 9CFB CEFD FF03 CEFF FFCE FDFF 02CE CEFF FDCE 029C CECE F6FF FACE 009C F3CE"
	$"0166 94CE 0100 0081 CED1 CE00 FFFB CE0D 9CCE CE9C 9C63 CE9C 9CCE 9CCE CE9C FECE"
	$"00FF FCCE 019C CEFC 9CFD CE01 9C9C FBCE 119C 9CCE 9C9C CE9C CECE 9C9C CE9C CECE"
	$"9CFF CEF9 9C05 CECE FFCE CE9C FDCE FE9C 12CE 9CCE CE9C CE9C 9CCE CEFF CECE 9CCE"
	$"9CCE 9C63 FE9C 06CE 9CCE CE9C CE9C FBCE F79C 01CE 9CF2 CE94 CF01 0000 81CF D1CF"
	$"03FF CFCF FFFA CF01 9A9A FECF 009A FCCF 02FF CFFF FCCF 019A CFFD 9AFC CF02 9A9A"
	$"FFFE CF08 FFCF 9A9A CFCF 9ACF 9AFE CF06 9ACF 9ACF CF9A FFF6 CF01 FFFF FBCF 019A"
	$"9AFA CF04 9A9A CFFF FFFE CF02 9A9A CFFD 9AFC CF04 9ACF 9ACF FFFD CFFA 9AFD CF00"
	$"9AF2 CF94 CE01 0000 81CE D1CE 00FF FBCE 009C FDCE 009C FECE 009C FECE 049C CEFF"
	$"CEFF FCCE 009C FECE 019C 9CFA CE00 FFFC CE0C 9C9C CECE 9CCE 9C9C CECE 9CCE 9CFE"
	$"CE08 FFFF CEFF FFCE FFCE FFFE CE00 FFFE CE00 9CFD CE08 9CCE 9C9C CECE 9CCE 9CFE"
	$"CE00 FFFE CE14 9C9C CE9C CECE 9CCE CE9C CECE 9CCE 9CCE CEFF FFCE CEFD 9C02 CE9C"
	$"CEFE 9C01 CE9C F2CE 0175 95CE FE00 81CE D1CE FEFF 04CE FF9C CECE FE9C 0C63 CE9C"
	$"CE9C 9CCE 9CCE CE9C 9CFF FECE 019C CEFD 9CFE CEFD 9C04 CECE 9CCE CEFE FFFC 9C02"
	$"CE63 CEFB 9C0B CE9C CECE 9CCE 9C9C CE9C CE9C FDCE 00FF FECE FC9C 02CE 9CCE FB9C"
	$"FDCE 049C CECE 9C9C FECE 099C CE9C CE9C 9CCE CE9C FFFE CE01 9CCE FE9C 02CE 63CE"
	$"FB9C F2CE 95CF FE00 81CF D1CF FEFF 01CF FFFE CFFE 9A0E 65CF 9ACF 9A9A CF9A CFCF"
	$"9ACF FFCF FFFD CF05 9A9A CF9A CFCF FD9A 03CF CF9A CFFD FF05 CF9A CF9A 9ACF FC9A"
	$"05CF 9A9A CF9A FFF4 CF03 FFFF CFCF FD9A 00CF FA9A 04CF 9AFF CFFF FDCF 069A 9ACF"
	$"CF9A 9ACF FE9A FECF 019A FFFC CFFE 9A02 CF9A CFFD 9A01 CF9A F2CF 95CE FE00 81CE"
	$"D1CE FEFF 04CE FF9C CECE FE9C 0F63 9C9C CE9C 9CCE 9CCE CE9C FFFF CEFF CEFD 9C04"
	$"CE9C 9CCE CEFD 9C02 CE9C 9CFC FF15 9C9C CE9C 9CCE 9C9C CE9C 9CCE 9C9C CE9C FFFF"
	$"CEFF FFCE FCFF FECE 00FF FECE FE9C 0663 9C9C CECE 9CCE FD9C 0CFF FFCE FF9C CECE"
	$"9C9C CE9C 63CE FC9C 03CE CE9C FFFE CE00 9CFE CE06 9CCE 9C63 9CCE CEFE 9CF2 CE01"
	$"6E96 CEFB 0081 CED3 CEFE FFFC CE08 9C9C CE9C 9CCE 9CCE CEFD 9C00 CEFE FFF9 CEFE"
	$"9C01 CECE FC9C 01FF FFFB CE0A FFCE 9CCE 9C9C CECE 9C9C CEFE 9C06 FFCE 9CFF 9C9C"
	$"CEFE 9C03 FFFF CEFF FCCE FE9C 0BCE 9C9C CE9C CE9C 9CCE FFCE FFFC CE02 FFCE CEFE"
	$"9C06 CE9C CE9C CE63 9CFD FFFC CEFE 9CFD CE02 9CCE 9CF3 CE96 CFFB 0081 CFD3 CFFE"
	$"FFF8 CF09 9ACF 9ACF CF9A CFCF 9ACF FEFF 13CF FFCF FFCF FFCF 9ACF 9A9A CFCF 9A9A"
	$"CF9A 9AFF FFFD CF13 FFCF FFCF 9ACF 9A9A CFCF 9A9A CFCF 9A9A FFCF CFFF FBCF 03FF"
	$"FFCF FFFC CF0E 9ACF 9ACF 9A9A CF9A CFCF 9ACF FFCF FFFC CF00 FFFE CF08 9A9A CF9A"
	$"CF9A CF9A 9AFD FF07 CFCF FFFF CF9A CF9A FDCF 029A CF9A F3CF 96CE FB00 81CE D3CE"
	$"FEFF F9CE 039C CECE 9CFE CE03 9C9C CECE FEFF 06CE FFCE CEFF CECE FD9C FDCE 049C"
	$"CE9C FFFF FBCE 0AFF CE9C CE9C 9CCE CE9C CECE FE9C FBFF 02CE FFCE FEFF 02CE FFFF"
	$"FDCE 0E9C CE9C CE9C 9CCE 9CCE CE9C CEFF CEFF FCCE 00FF FECE 039C 9CCE 9CFE CE01"
	$"9C9C FDFF FCCE 019C 9CFA CE00 9CF3 CE01 3481 CE81 CEE2 CEFE FF02 9CCE FFFC CE00"
	$"9CFE CEFA 9C03 CEFF CE9C FBCE 019C CEFB 9C06 CE9C 9CCE FF9C 9CFA CE02 9CCE CEFC"
	$"9C00 CEFB 9C08 CECE 9CCE CE9C CECE 9CFA CE02 9C9C CEFB 9C06 CE9C CECE 9CCE FFFC"
	$"CE03 9C9C CECE FA9C 03CE CE9C 9CFB CE01 9CCE FB9C F2CE 81CF 81CF E2CF FEFF 039A"
	$"FFCF FFFD CF00 9AFE CF01 9ACF FE9A 03CF 9ACF FFFA CF00 FFFD CFFC 9A03 CF9A CFFF"
	$"F5CF FE9A 00CF FD9A F5CF 049A CFFF CFFF FECF 049A CFCF 9ACF FD9A 09CF 9ACF CF9A"
	$"CFFF CFCF FFFE CF0D 9ACF CF9A CF9A 9ACF 9A9A CFCF 9A9A FBCF 019A CFFB 9AF2 CF81"
	$"CE81 CEE2 CEFE FF03 CECE FFFF F9CE 039C CE9C CEFE 9C01 FFFF F5CE FA9C 00FF FACE"
	$"00FF FCCE FD9C 00CE FE9C 08FF CEFF FFCE FFFF CEFF FECE 039C CECE FFFD CE04 9CCE"
	$"CE9C CEFD 9C09 CE9C CECE 9CCE FFCE CEFF FECE 049C CECE 9CCE FC9C 03CE CE9C 9CF9"
	$"CEFA 9CF3 CE01 3A81 CE81 CEE2 CE03 FFCE CE9C FDCE 079C 9CCE CEFF 9CFF FFFE CEFD"
	$"9C01 CE9C FBCE 049C CECE FFFF FDCE FE9C 00CE FE9C FECE 029C CE9C FECE 03FF CEFF"
	$"FFFE 9C03 CE9C CE9C FBCE 019C CEFE 9C03 CE9C CEFF FDCE 05FF CEFF 9CCE CEFC 9C01"
	$"CE9C FECE 03FF CECE 9CF9 CEF9 9C07 CEFF FFCE 9CCE FF9C FCCE 009C F3CE 81CF 81CF"
	$"E2CF 03FF CFCF 9AF9 CF06 FFCF FFCF FF9A FFFE CF02 FFCF 9AF8 CF01 FFFF F8CF 019A"
	$"9AF8 CF00 FFFE CF00 9AFC CF05 FFCF CFFF CFFF FACF 079A CFFF CFCF FFCF FFF7 CF05"
	$"9A9A CFFF CFFF F4CF 029A CFCF FE9A FEFF FECF 01FF 9AED CF81 CE81 CEE2 CEFE FF00"
	$"9CF9 CE0B FFCE FFCE FFCE FFFF CEFF FFCE FE9C FACE 01FF FFFC CEFE FF02 CE9C 9CF8"
	$"CE06 FFCE CEFF 9CFF CEF7 FF08 CEFF CECE 9CCE 9CCE FFFD CE00 FFFC CE06 FFFF CEFF"
	$"CE9C 9CFE CE00 FFF5 CE03 FFFF CECE FE9C 02CE FFFF FECE 01FF 9CFE CE02 FFCE FFF3"
	$"CE01 0981 CE81 CEE2 CE00 FFFD 9C06 CE9C 9CCE CE9C 9CFE CE01 9C9C FECE 009C FDCE"
	$"FE9C 05CE 9CCE 9CCE 9CFE CEFD 9C03 CECE 9CCE FD9C 0BCE CE9C CE9C CE9C CE9C 9CCE"
	$"9CFE CE03 9C9C CECE FD9C 02CE CE9C FDCE FC9C 0FCE 9CCE CE9C CECE 9CCE CE9C CECE"
	$"9CCE CEFE 9C0F CE9C CE9C 9CCE 9CCE 9CCE 9C9C CE9C 9CCE FE9C 00CE FE9C 02CE CE9C"
	$"FCCE 009C F2CE 81CF 81CF E2CF 03FF CFCF 9AFE CF00 9AF9 CF00 9AFE CF02 9ACF 9AFC"
	$"CF05 9ACF CF9A CF9A FBCF 009A FECF 009A FBCF 069A CFCF 9ACF CF9A FBCF 009A FCCF"
	$"039A CFCF 9AFA CF03 9ACF CF9A F8CF 009A FCCF 019A 9AFE CF03 9ACF CF9A FECF 029A"
	$"CF9A FECF 009A FECF 039A CFCF 9AE9 CF81 CE81 CEE2 CE03 FFCE CE9C E4CE 009C E3CE"
	$"009C FCCE 009C E4CE 009C D0CE 010A 81CE 81CE E2CE 03FF 9C9C CEF6 9C00 CEFD 9C06"
	$"CE9C 9CCE 9C9C CEF2 9C02 CE9C 9CFE CEFA 9C03 CE9C 9CCE FC9C 00CE FE9C 02CE 9CCE"
	$"FE9C 00CE FB9C 00CE FB9C 00CE FC9C 00CE FC9C 00CE F59C 07CE CE9C CECE 9CCE CEFD"
	$"9C03 CE9C 9CCE FA9C F3CE 81CF 81CF E2CF 03FF 9A9A CFFE 9A00 CFF9 9A00 CFFE 9A03"
	$"CF9A 9ACF ED9A 00CF FD9A 00CF FD9A 00CF FE9A 00CF FC9A 00CF FC9A 03CF 9A9A CFFA"
	$"9A00 CFFB 9A00 CFFC 9A00 CFFC 9A00 CFF6 9A02 CF9A CFFE 9A03 CF9A 9ACF FE9A 02CF"
	$"9ACF F99A F3CF 81CE 81CE E2CE 03FF 9C9C CEFD 9C01 CECE FC9C 00CE FD9C 03CE 9C9C"
	$"CEF8 9C00 CEE9 9C00 CEFC 9C00 CEFC 9C00 CEF7 9C00 CEFB 9C00 CEFC 9C00 CEFC 9C00"
	$"CEF4 9C03 CE9C 9CCE FE9C 0063 FE9C 04CE CE9C 9CCE FB9C F3CE 010D 81CE 81CE E2CE"
	$"02FF 9C9C FECE 009C FECE 109C 9CCE 9CCE 9CCE CE9C CE9C CECE 9CCE 9C9C FDCE FC9C"
	$"00CE FE9C 03CE 9C9C CEFD 9C0F CECE 9CCE CE9C CE9C 9CCE 9C9C CECE 9C9C FDCE FE9C"
	$"00CE FA9C 01CE CEFE 9CFE CE0D 9CCE 9CCE 9CCE 9CCE CE9C CECE 9C9C FECE FB9C 05CE"
	$"9CCE 9C9C CEFB 9CFD CE05 9CCE 9CCE 9C9C FECE 009C F3CE 81CF 81CF E2CF 00FF FE9A"
	$"FECF 009A FECF 009A FDCF 0B9A CF9A CFCF 9ACF CF9A CFCF 9AFD CF04 9A9A CFCF 9AFD"
	$"CF03 9ACF CF9A FDCF 049A CF9A CF9A FDCF 009A F3CF 009A FDCF 029A CF9A FCCF 009A"
	$"FECF 009A F3CF 039A CFCF 9AFE CF02 9ACF 9AFE CF00 9AFE CFFE 9A02 CFCF 9AEB CF81"
	$"CE81 CEE2 CE02 FF9C 9CFE CE00 9CE8 CE01 9C9C EECE 009C E9CE 009C E7CE 039C CECE"
	$"9CFC CE00 9CDE CE01 2181 CE81 CEE2 CE00 FFFD 9C00 CEFD 9C01 CECE FC9C FDCE 059C"
	$"9CCE 9CCE CEFE 9C06 CECE 9C9C CECE 9CFE CE03 9CCE CE9C FDCE 0F9C 9CCE 9C9C CE9C"
	$"CECE 9CCE 9CCE 9CCE CEFD 9C08 CE9C CE9C CECE 9CCE CEFD 9CFE CE02 9CCE 9CFE CE06"
	$"9CCE 9C9C CE9C CEFE 9C00 CEFE 9C00 CEFE 9C07 CECE 9CCE 9CCE 9C9C FBCE FD9C 02CE"
	$"9CCE FC9C F1CE 81CF 81CF E2CF 00FF FDCF 009A FDCF 049A CFCF 9A9A FDCF 009A F6CF"
	$"059A CFCF 9A9A CFFD 9AFD CFFE 9A20 CFCF 9ACF CF9A CFCF 9ACF CF9A CFCF 9A9A CF9A"
	$"CFCF 9ACF CF9A CFCF 9ACF CF9A CF9A CFFE 9A03 CF9A CF9A FECF 009A FDCF 049A CF9A"
	$"CF9A FECF 0E9A CF9A 9ACF 9A9A CFCF 9ACF CF9A CFCF FE9A FACF FE9A FECF 009A F3CF"
	$"81CE 81CE E2CE 00FF F5CE 009C E7CE 009C E9CE 009C F6CE 029C CE9C EFCE 009C FACE"
	$"019C 9CEB CE01 9C9C EFCE 00B7 81CE 81CE E2CE 00FF E7CE 019C 9CF6 CE00 9CF6 CE00"
	$"9CF7 CE00 9CFA CE00 9CC7 CE01 9C9C EFCE 81CF 81CF E2CF 00FF FBCF 03FF CFCF FFFA"
	$"CF01 FFFF FDCF 07FF CFCF 9A9A CFCF FFFD CF00 FFF9 CFFE FF1A CFCF FFCF 9ACF CFFF"
	$"FFCF CFFF CFCF FF9A FFCF FFCF FFCF CF9A FFCF FFFA CF01 FFFF FECF 00FF FECF 00FF"
	$"FDCF 03FF CFCF FFFE CF00 FFFC CF02 FFCF FFFD CF00 FFFC CFFC FFFE CF04 9A9A CFCF"
	$"FFF2 CF81 CE81 CEE2 CE00 FFE7 CE01 9C9C EACE 009C F7CE 009C FACE 009C C7CE 019C"
	$"9CEF CE01 4481 CE81 CEE2 CE00 FFFD CE00 FFFD CE06 FFCE CEFF CECE FFFD CE00 FFF2"
	$"CEFE FFF9 CE06 FFFF CEFF CECE FFFC CE02 FFCE FFF3 CE03 FFCE CEFF FBCE 00FF FCCE"
	$"03FF CECE FFFD CE00 FFF9 CE00 FFFD CE00 FFF6 CE08 FFCE FFCE CEFF CECE FFF3 CE81"
	$"CF81 CFE2 CF00 FFFD CF01 FFFF FECF 07FF CFCF FFCF CFFF FFFE CF01 FFFF FDCF 02FF"
	$"CFFF FACF FEFF FDCF 00FF FECF 06FF FFCF FFFF CFFF FCCF 03FF CFFF FFFA CF00 FFFE"
	$"CFFE FF02 CFFF FFFE CF07 FFCF FFFF CFCF FFCF FEFF 01CF FFFD CF04 FFFF CFCF FFFD"
	$"CF0A FFCF FFCF CFFF CFFF CFFF FFFB CF01 FFCF FCFF 01CF FFF3 CF81 CE81 CEE2 CE00"
	$"FFFD CE00 FFFD CE06 FFCE CEFF CECE FFFD CE00 FFFB CE00 FFF9 CEFE FFF9 CE06 FFFF"
	$"CEFF CECE FFFC CE07 FFCE FFCE FFCE CEFF F8CE 06FF CECE FFCE FFFF FECE 00FF FECE"
	$"0CFF CEFF CECE FFCE FFCE CEFF CEFF FBCE 05FF CECE FFCE FFFC CE00 FFFC CE08 FFCE"
	$"FFCE CEFF CECE FFF3 CE01 1781 CE81 CEE2 CE0D FF9C 9CCE FF9C CECE 9C9C CE9C CE9C"
	$"FECE 099C CECE 9CCE CE9C CECE FFFE CE00 9CFE CE0A FFFF CE9C CECE 9CFF 9CCE CEFE"
	$"9C08 CE9C CECE 9CCE CE9C 9CFD CE00 9CFA CE04 9CCE 9CCE 9CFE CE00 9CFE CE09 FFCE"
	$"CE9C CEFF CE9C FF9C F9CE 06FF CECE 9CCE CE9C FECE 0B9C CE9C CECE 9CCE 9CCE CE9C"
	$"9CFA CE00 9CFE CE00 9CF0 CE81 CF81 CFE2 CF00 FFFE CF00 FFEC CF00 FFFB CFFE FFFC"
	$"CF00 FFF1 CF00 FFFC CF00 FFF1 CF0C FFCF CF9A CFFF CFCF FF9A CFCF FFFE CF02 FFCF"
	$"FFFA CF00 FFF0 CF00 FFE9 CF81 CE81 CEE2 CE00 FFFE CE02 FFCE FFF6 CE00 FFFC CE02"
	$"FFCE FFFD CE04 FFCE CEFF FFFC CE02 FFCE FFF4 CE00 FFF3 CE02 FFCE FFFE CE10 FFCE"
	$"CEFF CECE 9CFF FFCE CEFF 9CCE FFCE FFFD CE00 FFF8 CE00 FFF4 CE01 FFFF F9CE 00FF"
	$"F1CE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE"
	$"81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE"
	$"81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF"
	$"CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE"
	$"81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018"
	$"81CE 81CE 81CE CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE"
	$"CCCE 81CF 81CF 81CF CCCF 81CE 81CE 81CE CCCE 0018 81CE 81CE 81CE CCCE 81CF 81CF"
	$"81CF CCCF 81CE 81CE 81CE CCCE 00FF"
};









resource 'MENU' (kOpenDLOGAdditionItems_DialogID) {
	kOpenDLOGAdditionItems_DialogID,
	textMenuProc,
	0x7FFFFFFF,
	enabled,
	"",
	{
		"All Recognized", noIcon, noKey, noMark, plain,
		"All Files", noIcon, noKey, noMark, plain,
		"-", noIcon, noKey, noMark, plain
	}
};
resource 'CNTL' (kOpenDLOGAdditionItems_DialogID, purgeable) {
	{0, 0, 20, 300},
	0,
	visible,
	47,
	kOpenDLOGAdditionItems_DialogID,
	popupMenuCDEFproc,
	0,
	"Show:"
};
resource 'DITL' (kOpenDLOGAdditionItems_DialogID, purgeable) {
	{
		{10, 12, 30, 312},
		Control {
			enabled,
			kOpenDLOGAdditionItems_DialogID
		},
	}
};










resource 'MENU' (kSaveDLOGAdditionItems_DialogID) {
	kSaveDLOGAdditionItems_DialogID,
	textMenuProc,
	0x7FFFFFFF,
	enabled,
	"",
	{
	}
};
resource 'CNTL' (kSaveDLOGAdditionItems_DialogID, purgeable) {
	{0, 0, 20, 320},
	0,
	visible,
	67,
	kSaveDLOGAdditionItems_DialogID,
	popupMenuCDEFproc,
	0,
	"Format:"
};
resource 'DITL' (kSaveDLOGAdditionItems_DialogID, purgeable) {
	{
		{10, 12, 30, 332},
		Control {
			enabled,
			kSaveDLOGAdditionItems_DialogID
		},
	}
};










/// DO #DEFINES HERE TO CONTROL WHICH RESOURCES LOADED
#include	"LedStdDialogs.r"

