/*
 * Copyright(c) Sophist Solutions, Inc. 1990-2024.  All rights reserved
 */
#ifndef __DispIDs_h__
#define __DispIDs_h__ 1

#define DISPID_VersionNumber 1001
#define DISPID_ShortVersionString 1002
#define DISPID_HasVerticalScrollBar 1003
#define DISPID_HasHorizontalScrollBar 1004
#define DISPID_Text 1005
#define DISPID_TextCRLF 1006
#define DISPID_TextRTF 1007
#define DISPID_TextHTML 1008
#define DISPID_TextBitmap 1009
#define DISPID_Length 1010
#define DISPID_MaxLength 1011
#define DISPID_SupportContextMenu 1012
#define DISPID_SmartCutAndPaste 1013
#define DISPID_WrapToWindow 1014
#define DISPID_ShowParagraphGlyphs 1015
#define DISPID_ShowTabGlyphs 1016
#define DISPID_ShowSpaceGlyphs 1017
#define DISPID_ShowHidableText 1018
#define DISPID_HidableTextColor 1019
#define DISPID_HidableTextColored 1020
#define DISPID_SpellChecker 1066
//#define   DISPID_SelStart                     1021
//#define   DISPID_SelLength                    1022
//#define   DISPID_SelText                      1023
#define DISPID_SelTextRTF 1024
#define DISPID_SelTextHTML 1025
#define DISPID_SelColor 1026
#define DISPID_SelFontFace 1027
#define DISPID_SelFontSize 1028
#define DISPID_SelBold 1029
#define DISPID_SelItalic 1030
#define DISPID_SelStrikeThru 1031
#define DISPID_SelUnderline 1032
#define DISPID_SelJustification 1033
#define DISPID_SelListStyle 1065
#define DISPID_SelHidable 1034
#define DISPID_LoadFile 1035
#define DISPID_SaveFile 1036
#define DISPID_SaveFileCRLF 1037
#define DISPID_SaveFileRTF 1038
#define DISPID_SaveFileHTML 1039
//#define   DISPID_Refresh                      1040
#define DISPID_ScrollToSelection 1041
#define DISPID_MaxUndoLevel 1042
#define DISPID_CanUndo 1043
#define DISPID_CanRedo 1044
#define DISPID_Undo 1045
#define DISPID_Redo 1046
#define DISPID_CommitUndo 1047
#define DISPID_Dirty 1048
#define DISPID_ReadOnly 1071
#define DISPID_EnableAutoChangesBackgroundColor 1072

#define DISPID_LaunchFontSettingsDialog 1049
#define DISPID_LaunchParagraphSettingsDialog 1050

#define DISPID_LaunchFindDialog 1051
#define DISPID_Find 1052
#define DISPID_LaunchReplaceDialog 1079
#define DISPID_FindReplace 1080

#define DISPID_PrinterSetupDialog 1053
#define DISPID_PrintDialog 1054
#define DISPID_PrintOnce 1055

#define DISPID_GetHeight 1056

#define DISPID_WindowMarginTop 1057
#define DISPID_WindowMarginLeft 1058
#define DISPID_WindowMarginBottom 1059
#define DISPID_WindowMarginRight 1060

#define DISPID_PrintMarginTop 1061
#define DISPID_PrintMarginLeft 1062
#define DISPID_PrintMarginBottom 1063
#define DISPID_PrintMarginRight 1064

#define DISPID_UseSelectEOLBOLRowHilightStyle 1075

//#define   DISPID_hWnd                             1076
#define DISPID_SmartQuoteMode 1077

#define DISPID_ShowSecondaryHilight 1078

#define DISPID_ContextMenu 1081
#define DISPID_HideDisabledContextMenuItems 1086
#define DISPID_GetDefaultContextMenu 1082
#define DISPID_BuiltinCommands 1083
#define DISPID_MakeNewPopupMenuItem 1084
#define DISPID_MakeNewUserMenuItem 1085

#define DISPID_CurrentEventArguments 1087

#define DISPID_PredefinedMenus 1088
#define DISPID_InvokeCommand 1089
#define DISPID_CommandEnabled 1101
#define DISPID_CommandChecked 1102
#define DISPID_AcceleratorTable 1090
#define DISPID_GetDefaultAcceleratorTable 1091
#define DISPID_MakeNewAcceleratorElement 1092

#define DISPID_ToolbarList 1093
#define DISPID_MakeNewToolbarList 1094
#define DISPID_MakeNewToolbar 1095
#define DISPID_MakeIconButtonToolbarItem 1096
#define DISPID_MakeSeparatorToolbarItem 1097
#define DISPID_MakeBuiltinToolbar 1098
#define DISPID_MakeBuiltinToolbarItem 1099
#define DISPID_InvalidateLayout 1100

//EVENT dispids

#define DISPID_Change 0x01
#define DISPID_SelChange 0x02
#define DISPID_UpdateUserCommand 0x03
#define DISPID_UserCommand 0x04

/*
 ********************************************************************************
 ***************************** Implementation Details ***************************
 ********************************************************************************
 */

#endif /*__DispIDs_h__*/
