/*
 * Copyright(c) Sophist Solutions, Inc. 1990-2024.  All rights reserved
 */

namespace Stroika::Frameworks::Led {

    /*
     ********************************************************************************
     ***************************** SpellCheckEngine ***************************
     ********************************************************************************
     */
    /*
    @METHOD:        SpellCheckEngine::LookupWord
    @DESCRIPTION:   <p>Lookup the given word and see if its found in the system (dictionaries). Return true
                if found and set (optional - can be nullptr) OUT argument 'matchedWordResult'
                to indicate the original word in the dictionary matched
                (due to case mapping, this may not be the same as the 'checkWord').</p>
                    <p>Also note that just because a word doesn't appear in the dictionary, (i.e. isn't returned
                from LookupWord) - doesn't mean it will be found as a missing (misspelled) word. Some words
                are ignored like possibly all upper case words, punctuation, numbers, and others algorithmicly checked
                words.</p>
    */
    inline bool SpellCheckEngine::LookupWord (const Led_tString& checkWord, Led_tString* matchedWordResult)
    {
        return LookupWord_ (checkWord, matchedWordResult);
    }
    inline void SpellCheckEngine::Invariant () const
    {
#if qStroika_Foundation_Debug_AssertionsChecked
        Invariant_ ();
#endif
    }

#if qStroika_Foundation_Debug_AssertionsChecked
    /*
    @METHOD:        SpellCheckEngine::Invariant_
    @DESCRIPTION:   <p>Default implementaiton for calls to @'SpellCheckEngine::Invariant'. Overridden in subclasses
            to check validity of SpellCheck engine.</p>
    */
    inline void SpellCheckEngine::Invariant_ () const
    {
    }
#endif

}
