# Stroika Library Foundation

This folder contains all the Stroika Library Foundation source code.

- [Cache/](Cache/) - Smart storage of partial data structures
- [Characters/](Characters/) - Character and String classes
- [Common/](Common/) - Various building blocks used elsewhere
- [Containers/](Containers/) - Stack, Set, Sequence, etc...
- [Cryptography/](Cryptography/) - Hash<>, Encrypt, etc...
- [Database/](Database/) - SQL, SQLLite, ODBC, etc...
- [DataExchange/](DataExchange/) - VariantValue, Serializers, JSON, XML, etc...
- [Debug/](Debug/) - Assertions, Trace, etc...
- [Execution/](Execution/) - ThreadPool, Logger, Process etc...
- [IO/](IO/) - File and Network input/output etc...
- [Linguistics/](Linguistics/)
- [Math/](Math/) - Math utilities, Statistics, Optimization etc...
- [Memory/](Memory/) - Block Allocation, BLOB, SharedByValue, Buffer, StackBuffer, etc...
- [Streams/](Streams/) - Sequence of data elements made available over time
- [Time/](Time/) - Date/Time related classes
- [Traversal/](Traversal/) - Iterators, Generators, Ranges etc..
