/*
 * Copyright(c) Sophist Solutions, Inc. 1990-2024.  All rights reserved
 */
#include "Stroika/Foundation/Characters/ToString.h"
#include "Stroika/Foundation/Common/Compare.h"

namespace Stroika::Foundation::Execution {

    /*
     ********************************************************************************
     ****************************** Execution::Function *****************************
     ********************************************************************************
     */
#if qCompilerAndStdLib_template_Requires_constraint_not_treated_constexpr_Buggy
    template <typename FUNCTION_SIGNATURE>
    template <typename CTOR_FUNC_SIG, enable_if_t<is_convertible_v<remove_cvref_t<CTOR_FUNC_SIG>, function<FUNCTION_SIGNATURE>> and
                                                  not derived_from<remove_cvref_t<CTOR_FUNC_SIG>, Function<FUNCTION_SIGNATURE>>>*>
    inline Function<FUNCTION_SIGNATURE>::Function (CTOR_FUNC_SIG&& f)
        : fFun_{forward<CTOR_FUNC_SIG> (f)}
        , fOrdering_{fFun_ == nullptr ? OrderingType_{} : ++Private_::sFunctionObjectNextPtrID_}
    {
        Assert ((fOrdering_ == OrderingType_{}) == (fFun_ == nullptr));
    }
#elif !qCompilerAndStdLib_RequiresNotMatchInlineOutOfLineForTemplateClassBeingDefined_Buggy
    template <typename FUNCTION_SIGNATURE>
    template <typename CTOR_FUNC_SIG>
        requires (is_convertible_v<remove_cvref_t<CTOR_FUNC_SIG>, function<FUNCTION_SIGNATURE>> and
                  not derived_from<remove_cvref_t<CTOR_FUNC_SIG>, Function<FUNCTION_SIGNATURE>>)
    inline Function<FUNCTION_SIGNATURE>::Function (CTOR_FUNC_SIG&& f)
        : fFun_{forward<CTOR_FUNC_SIG> (f)}
        , fOrdering_{fFun_ == nullptr ? OrderingType_{} : ++Private_::sFunctionObjectNextPtrID_}
    {
        Assert ((fOrdering_ == OrderingType_{}) == (fFun_ == nullptr));
    }
#endif
    template <typename FUNCTION_SIGNATURE>
    inline Function<FUNCTION_SIGNATURE>::Function (nullptr_t)
        : fFun_{}
    {
        Assert (fOrdering_ == OrderingType_{});
    }
    template <typename FUNCTION_SIGNATURE>
    inline Function<FUNCTION_SIGNATURE>::operator STDFUNCTION () const
    {
        return fFun_;
    }
    template <typename FUNCTION_SIGNATURE>
    template <typename... Args>
    inline typename Function<FUNCTION_SIGNATURE>::result_type Function<FUNCTION_SIGNATURE>::operator() (Args... args) const
    {
        RequireNotNull (fFun_);
        return fFun_ (forward<Args> (args)...);
    }
    template <typename FUNCTION_SIGNATURE>
    inline strong_ordering Function<FUNCTION_SIGNATURE>::operator<=> (const Function& rhs) const
    {
        return fOrdering_ <=> rhs.fOrdering_;
    }
    template <typename FUNCTION_SIGNATURE>
    inline bool Function<FUNCTION_SIGNATURE>::operator== (const Function& rhs) const
    {
        return fOrdering_ == rhs.fOrdering_;
    }
    template <typename FUNCTION_SIGNATURE>
    inline Characters::String Function<FUNCTION_SIGNATURE>::ToString () const
    {
        return Characters::ToString (fOrdering_);
    }

}
