/*
 * Copyright(c) Sophist Solutions, Inc. 1990-2024.  All rights reserved
 */
#include "Stroika/Foundation/StroikaPreComp.h"

#include "Stroika/Foundation/Common/StroikaConfig.h"
#include "Stroika/Foundation/Execution/Thread.h"

#include "AbortableMutex.h"

using namespace Stroika::Foundation;
using namespace Stroika::Foundation::Execution;

/*
 ********************************************************************************
 ******************************** AbortableMutex ********************************
 ********************************************************************************
 */
void AbortableMutex::lock ()
{
    while (not fM_.try_lock_for (chrono::milliseconds{10})) {
        Thread::CheckForInterruption ();
    }
}

void AbortableMutex::unlock ()
{
    fM_.unlock ();
}
