/*
 * Copyright(c) Sophist Solutions, Inc. 1990-2024.  All rights reserved
 */
#ifndef _Stroika_Foundation_DataExchange_Variant_CharacterDelimitedLines_Writer_h_
#define _Stroika_Foundation_DataExchange_Variant_CharacterDelimitedLines_Writer_h_ 1

#include "Stroika/Foundation/StroikaPreComp.h"

#include "Stroika/Foundation/Common/Common.h"
#include "Stroika/Foundation/DataExchange/Variant/Writer.h"
#include "Stroika/Foundation/DataExchange/VariantValue.h"
#include "Stroika/Foundation/Streams/OutputStream.h"

/**
 *  \file
 *
 *  \note Code-Status:  <a href="Code-Status.md#Beta">Beta</a>
 *
 */

namespace Stroika::Foundation::DataExchange::Variant::CharacterDelimitedLines {

    /**
     *  \brief This COULD be easily used to read CSV files, or tab-delimited files, for example.
     * 
     *  \par Example Usage
     *      Source file:
     *           # This file was automatically generated by the
     *           # update-mime-database command. DO NOT EDIT!
     *           3, 4
     *           4, 5
     *...
     *      \code
     *          Sequence<Sequence<int>> results{
     *              Sequence<int>{3,4},
     *              Sequence<int>{4,5},
     *          };
     *          Variant::CharacterDelimitedLines::Write{}.Write (results);
     *      \endcode
     */
    class Writer : public Variant::Writer {
    private:
        using inherited = Variant::Writer;

    private:
        class Rep_;

    public:
        /**
         */
        struct Options {
            Characters::Character fSeparator{','};
            bool                  fSpaceSeparate{false}; // if true, emit space after all separators on a line but the last
        };

    public:
        /**
         */
#if qCompilerAndStdLib_DefaultMemberInitializerNeededEnclosingForDefaultFunArg_Buggy
        Writer (const Options& options);
        Writer ()
            : Writer (Options{})
        {
        }
#else
        Writer (const Options& options = {});
#endif

    public:
        /**
         *  @See Variant::Writer::Write, but overloaded to also take array of array of strings to write.
         * 
         *  \note Could have been called WriteMatrix (additional overloads) - but seemed best to emphasize connection
         *        to other Writers instead of similarity to Reader (where we call it ReadMatrix due to not being
         *        able to overload on return type).
         */
        using inherited::Write;
        nonvirtual void Write (const Traversal::Iterable<Sequence<String>>& m, const Streams::OutputStream::Ptr<byte>& out);
        nonvirtual void Write (const Traversal::Iterable<Sequence<String>>& m, const Streams::OutputStream::Ptr<Characters::Character>& out);
        nonvirtual void Write (const Traversal::Iterable<Sequence<String>>& m, ostream& out);
        nonvirtual void Write (const Traversal::Iterable<Sequence<String>>& m, wostream& out);

    public:
        /**
         *  @See Variant::Writer::WriteAsString, but overloaded to also take array of array of strings to write.
         */
        using inherited::WriteAsString;
        [[nodiscard]] nonvirtual String WriteAsString (const Traversal::Iterable<Sequence<String>>& m);

    public:
        /**
         *  @See Variant::Writer::WriteAsBLOB, but overloaded to also take array of array of strings to write.
         */
        using inherited::WriteAsBLOB;
        [[nodiscard]] nonvirtual Memory::BLOB WriteAsBLOB (const Traversal::Iterable<Sequence<String>>& m);

    private:
        nonvirtual shared_ptr<Rep_> GetRep_ () const;
    };

}

/*
 ********************************************************************************
 ***************************** Implementation Details ***************************
 ********************************************************************************
 */
#include "Writer.inl"

#endif /*_Stroika_Foundation_DataExchange_Variant_CharacterDelimitedLines_Writer_h_*/
