/*
 * Copyright(c) Sophist Solutions, Inc. 1990-2024.  All rights reserved
 */

#include "Stroika/Foundation/Characters/StringBuilder.h"

namespace Stroika::Foundation::DataExchange::StructuredStreamEvents {

    /*
     ********************************************************************************
     *********************** StructuredStreamEvents::Name ***************************
     ********************************************************************************
     */
    inline Name::Name ([[maybe_unused]] NameType type)
        : fType{eValue}
    {
        Require (type == eValue);
    }
    inline Name::Name (const String& localName, NameType type)
        : fLocalName{localName}
        , fType{type}
    {
    }
    inline Name::Name (const String& namespaceURI, const String& localName, NameType type)
        : fNamespaceURI{namespaceURI}
        , fLocalName{localName}
        , fType{type}
    {
    }
    inline String Name::ToString () const
    {
        Characters::StringBuilder result;
        if (fType == NameType::eAttribute) {
            result += "@"sv;
        }
        else if (fType == NameType::eValue) {
            return "{value}"sv;
        }
        if (fNamespaceURI) {
            result += *fNamespaceURI + ":"sv;
        }
        result += fLocalName;
        return result;
    }
    inline strong_ordering Name::operator<=> (const Name& rhs) const
    {
        return TWC_ (*this, rhs);
    }
    inline bool Name::operator== (const Name& rhs) const
    {
        return TWC_ (*this, rhs) == 0;
    }
    inline strong_ordering Name::TWC_ (const Name& lhs, const Name& rhs)
    {
        // Treat EITHER side missing namespace as 'wildcard' matching any namespace
        if (lhs.fNamespaceURI.has_value () and rhs.fNamespaceURI.has_value ()) {
            if (auto cmp = *lhs.fNamespaceURI <=> *rhs.fNamespaceURI; cmp != strong_ordering::equal) {
                return cmp;
            }
        }
        if (auto cmp = lhs.fLocalName <=> rhs.fLocalName; cmp != strong_ordering::equal) {
            return cmp;
        }
        return lhs.fType <=> rhs.fType;
    }

}
