/* Copyright(c) Sophist Solutions Inc. 1990-1992.  All rights reserved */

/*
 * $Header: /fuji/lewis/RCS/tPixelMap.cc,v 1.2 1992/09/01 17:52:15 sterling Exp $
 *
 * TODO:
 *
 * Changes:
 *	$Log: tPixelMap.cc,v $
 *		Revision 1.2  1992/09/01  17:52:15  sterling
 *		*** empty log message ***
 *
 *		Revision 1.7  1992/03/11  23:11:46  lewis
 *		Use cout/cerr instead of gDebugStream since thats not available when debug turned off anyhow, and using
 *		two different streams allows us to differentiate info from actual errors.
 *
 *
 *
 */

/*
 * Has to come before other includes, so that we know this constructor called VERY early in
 * the game.
 */
#pragma	push
#pragma	force_active	on
#include	"GDIInit.hh"
static	GDIInit	sInit	=	GDIInit ();
#pragma	pop

#include	"Stroika-Graphix-Globals.hh"	//	To get them inited real early cuz C++ does not gaurentee
											//	order of init of static objects accross .o files

#include	"Debug.hh"
#include	"StreamUtils.hh"

#include	"PixelMap.hh"

#include	"TestSuite.hh"



static	void	Test1 ();
static	void	Test2 ();
static	void	Test3 ();
static	void	Test_CopyPixelmaps ();


int	main (int /*argc*/, char* /*argv*/[])
{
	cout << "Testing pixelmaps..." << newline;
	Test1 ();
	Test2 ();
	Test3 ();
	Test_CopyPixelmaps ();
	cout << "Tested pixelmaps!" << newline;
	return (0);
}



static	void	Test1 ()
{
	static	const	UInt8	blackPattern[]	=	{ 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, };
	static	const	UInt8	whitePattern[]	=	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
	PixelMap	pmBlack	=	PixelMapFromData (Point (8, 8), blackPattern, sizeof (blackPattern));
	PixelMap	pmWhite	=	PixelMapFromData (Point (8, 8), whitePattern, sizeof (whitePattern));

	for (int r = 0; r < 8; r++) {
		for (int c = 0; c < 8; c++) {
			TestCondition (pmBlack.GetBounds ().Contains (Point (r, c))); 
			TestCondition (pmWhite.GetBounds ().Contains (Point (r, c))); 
			TestCondition (pmBlack.GetPixel (Point (r, c)) == 1);
			TestCondition (pmWhite.GetPixel (Point (r, c)) == 0);
		}
	}

	TestCondition (pmBlack.GetBounds ().GetSize () == Point (8, 8));
	TestCondition (pmWhite.GetBounds ().GetSize () == Point (8, 8));
}



static	void	Test2 ()
{
	PixelMap	grayPixelMap	=	PixelMap (Rect (kZeroPoint, Point (8, 8)));

	for (int r = 0; r < 8; r++) {
		for (int c = 0; c < 8; c++) {
			grayPixelMap.SetPixel (Point (r, c), Odd (r+c));
		}
	}

	PixelMap	grayToo	=	grayPixelMap;
	for (r = 0; r < 8; r++) {
		for (int c = 0; c < 8; c++) {
			TestCondition (grayPixelMap.GetPixel (Point (r, c)) == grayToo.GetPixel (Point (r, c)));
			TestCondition (grayPixelMap.GetPixel (Point (r, c)) == Odd (r+c));
		}
	}
}



static	void	Test3 ()
{
	for (Coordinate size = 1; size <= 500; size++) {
		PixelMap	pm	=	PixelMap (Rect (kZeroPoint, Point (1, size)));
		for (Coordinate whereH = 0; whereH < size; whereH++) {
			pm.SetPixel (Point (0, whereH), Boolean ((whereH % 2) == 0));
		}
		for (whereH = 0; whereH < size; whereH++) {
			TestCondition (pm.GetPixel (Point (0, whereH)) == Boolean ((whereH % 2) == 0));
		}
	}
}


// outside function cuz of hp compiler bug... LGP Jan 27, 1992 - not tracked downyet...
const	Color	kXCLUT_Data [] = {
	kWhiteColor,
	Color (13107, 0, 65535),
	Color (26214, 65535, 13107),
	kBlackColor
};
static	PixelMap	xxx ()
{
	static	UInt8	kX_Data [] = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
		0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
		0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x58, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00,
		0x00, 0x00, 0x40, 0x00, 0x00, 0x01, 0x60, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x05, 0x20, 0x00,
		0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0xA0, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x12, 0x80, 0x00,
		0x00, 0x00, 0x01, 0x40, 0x01, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x2A, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x04, 0x12, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x5A, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x01, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x54, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x52, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x4A, 0x80, 0x40, 0x00, 0x00,
		0x00, 0x00, 0x04, 0xAA, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x16, 0xA0, 0x00, 0x14, 0x00, 0x00,
		0x00, 0x00, 0x4A, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00, 0x01, 0x4A, 0x00, 0x00, 0x00, 0x50, 0x00,
		0x00, 0x06, 0xA8, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x06, 0xA0, 0x00, 0x00, 0x00, 0x04, 0x00,
		0x00, 0x02, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	};
#if		qHPCPlus_StaticConstructorReturnBug
	static	const	PixelMap*	kXIcon  = Nil;
	if (kXIcon == Nil) {
		kXIcon  = new PixelMap (PixelMapFromData (Point (32, 32), kX_Data, sizeof (kX_Data), 2, kXCLUT_Data));
	}
	return (*kXIcon);
#else
	static	const	PixelMap	kXIcon  = PixelMapFromData (Point (32, 32), kX_Data, sizeof (kX_Data), 2, kXCLUT_Data);
	return (kXIcon);
#endif
}
static	void	Test_CopyPixelmaps ()
{
	PixelMap pp = xxx ();
	Rect	r = xxx ().GetBounds ();
}



// For gnuemacs:
// Local Variables: ***
// mode:C++ ***
// tab-width:4 ***
// End: ***


