/* Copyright(c) Sophist Solutions Inc. 1990-1992.  All rights reserved */

/*
 * $Header: /fuji/lewis/RCS/TicTacToeView.cc,v 1.3 1992/09/01 17:58:36 sterling Exp $
 *
 * TODO:
 *
 * Changes:
 *	$Log: TicTacToeView.cc,v $
 *		Revision 1.3  1992/09/01  17:58:36  sterling
 *		*** empty log message ***
 *
 *		Revision 1.19  1992/06/03  16:33:50  lewis
 *		Got rid of old pixelmap code, and instead include files X.cpm and O.cpm which were
 *		generated by the PixelMapEditor.
 *
 *		Revision 1.13  1992/02/11  06:00:00  lewis
 *		Minor cleanups.
 *
 *		Revision 1.12  1992/01/28  10:36:27  lewis
 *		Moved pixmap construction out of draw procedure, and used new PixelMapFromData () routine. Also,
 *		use #define for bug workaround for static return bug with pixmaps. Still didn't document bug
 *		with putting array of Colors in a procedure (static).
 *
 *		Revision 1.9  1992/01/06  02:14:24  lewis
 *		Hacked DrawCell() so that it used depth 1 pixelmaps with X - just
 *		til we get time to support this a a low level in Stroika for X.
 *
 *
 */



#include	"Debug.hh"
#include	"StreamUtils.hh"

#include	"Shape.hh"
#include	"Sound.hh"

#include	"Alert.hh"
#include	"Application.hh"
#include	"Dialog.hh"
#include	"MenuOwner.hh"

#include	"CommandNumbers.hh"
#include	"Expert.hh"

#include	"TicTacToeView.hh"


#include	"O.cpm"
#include	"X.cpm"








/*
 ********************************************************************************
 ************************************ TicTacToeView *****************************
 ********************************************************************************
 */

TicTacToeView::TicTacToeView ():
	View (),
	fLineSize (kZeroPoint),
	fCellSize (kZeroPoint),
	fBoard (),
	fNextOccupant (Board::eX),
	fSoundOn (True),
	fComputerOpponent (False)
{
	ClearBoard (eNoUpdate);
}

void	TicTacToeView::ClearBoard (Panel::UpdateMode updateMode)
{
	fBoard.SetClear ();
	Refresh (updateMode);
}

Board::CellOccupant	TicTacToeView::GetCell (const Cell& c) const
{
	return (fBoard.GetCell (c));
}

void	TicTacToeView::SetCell (const Cell& c, Board::CellOccupant occupant, Panel::UpdateMode updateMode)
{
	if (fBoard.GetCell (c) != occupant) {
		fBoard.SetCell (c, occupant);
		if (updateMode != eNoUpdate) {
			Refresh (GetItemRect (c), updateMode);
		}
	}
}

void	TicTacToeView::Draw (const Region& /*update*/)
{
	DrawLines ();
	DrawCells ();
}

Boolean	TicTacToeView::TrackMovement (const Point& cursorAt, Region& mouseRgn, const KeyBoard& keyBoardState)
{
	static	const	UInt16	kX_Curs_Data [] = {
		0x8001,0x4002,0x2004,0x1008,0x0810,0x0420,0x0240,0x0180,0x0180,0x0240,0x0420,0x0810,0x1008,0x2004,0x4002,0x8001,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0007,0x0007
	  };
#if		qMacGDI
		PixelMapCursor	kXCursor	=	PixelMapCursor ((osCursor*)&kX_Curs_Data);
#else
		PixelMapCursor	kXCursor	=	PixelMapCursor (PixelMap (Rect (kZeroPoint, kZeroPoint)));
#endif

	static	const	UInt16	kY_Curs_Data [] = {
		0x07E0,0x1818,0x300C,0x6006,0x4002,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x4002,0x6006,0x300C,0x1818,0x07E0,
		0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
		0x0007,0x0007
	  };
#if		qMacGDI
	PixelMapCursor	kYCursor	=	PixelMapCursor ((osCursor*)&kY_Curs_Data);
#else
	PixelMapCursor	kYCursor	=	PixelMapCursor (PixelMap (Rect (kZeroPoint, kZeroPoint)));
#endif

	Cell	c	=	kMinCell;
	if (!fBoard.GameDone () and PointToCell (cursorAt, c) and (GetCell (c) == Board::eEmpty)) {
		if (fNextOccupant == Board::eX) {
			kXCursor.Install ();
		}
		else {
			kYCursor.Install ();
		}
	}
	else {
		kArrowCursor.Install ();
	}
	return (True);
}

void	TicTacToeView::AnnounceWinner (Board::CellOccupant winner, Board::CellOccupant player)
{
	if (winner == Board::eEmpty) {
		Alert ("The game is a tie.", "OK").Pose ();
	}
	else if (player == winner) {
		Alert ("You are the winner!", "Hooray").Pose ();
	}
	else if (player != Board::eEmpty) {
		Alert ("You are the loser!", "Sorry").Pose ();
	}
	else if (winner == Board::eX) {
		Alert ("X is the winner!", "OK").Pose ();
	}
	else if (winner == Board::eO) {
		Alert ("O is the winner!", "OK").Pose ();
	}
	else {
		AssertNotReached ();
	}
}

Boolean	TicTacToeView::TrackPress (const MousePressInfo& mouseInfo)
{
	if (fBoard.GameDone ()) {
		Alert ("The game is over. Try a new game.", "OK").Pose ();
		return (True);
	}
	Cell	c	=	kMinCell;
	if (PointToCell (mouseInfo.fPressAt, c)) {
		if (GetCell (c) == Board::eEmpty) {
			SetCell (c, fNextOccupant);
			Board::CellOccupant	winner	=	Board::eEmpty;
			if (fBoard.GameDone (winner)) {
				AnnounceWinner (winner, fNextOccupant);
			}
			else if (fComputerOpponent) {
				Assert (not fBoard.GameDone ());
				fNextOccupant = (fNextOccupant == Board::eX)? Board::eO: Board::eX;
				Cell	bestMove = FindBestMove (fBoard, fNextOccupant);
				Assert (GetCell (bestMove) == Board::eEmpty);
				SetCell (bestMove, fNextOccupant, eImmediateUpdate);
				fNextOccupant = (fNextOccupant == Board::eX)? Board::eO: Board::eX;
				if (fBoard.GameDone (winner)) {
					AnnounceWinner (winner, fNextOccupant);
				}
			}
			else {
				fNextOccupant = (fNextOccupant == Board::eX)? Board::eO: Board::eX;
			}
			
		}
		else {
			Alert ("That cell is occupied", "OK").Pose ();
		}
	}
	return (True);
}

void	TicTacToeView::DoSetupMenus ()
{
	EnableCommand (eSuggestMove, not fBoard.GameDone ());
	EnableCommand (eAutoPilot, not fBoard.GameDone ());
	EnableCommand (eSound);
	SetOn (eSound, fSoundOn);
	EnableCommand (eComputerOpponent);
	SetOn (eComputerOpponent, fComputerOpponent);
}

Boolean	TicTacToeView::DoCommand (const CommandSelection& selection)
{
	switch (selection.GetCommandNumber ()) {
		case eSuggestMove: 
			{
				Assert (not fBoard.GameDone ());
				Cell	bestMove = FindBestMove (fBoard, fNextOccupant);
				Assert (GetCell (bestMove) == Board::eEmpty);
				SetCell (bestMove, fNextOccupant, eImmediateUpdate);
				Application::Get ().WaitFor (0);
				SetCell (bestMove, Board::eEmpty);
			}
			return (True);
		
		case eSound:
			fSoundOn = not fSoundOn;
			MenuOwner::SetMenusOutOfDate ();
			return (True);
		
		case eComputerOpponent:
			fComputerOpponent = not fComputerOpponent;
			MenuOwner::SetMenusOutOfDate ();
			return (True);

		case eAutoPilot:
			{
				Board::CellOccupant	winner	=	Board::eEmpty;
				while (not fBoard.GameDone (winner)) {
					Cell	bestMove = FindBestMove (fBoard, fNextOccupant);
					Assert (GetCell (bestMove) == Board::eEmpty);
					SetCell (bestMove, fNextOccupant, eImmediateUpdate);
					if (fSoundOn) {
						Beep ();
					}
					Application::Get ().WaitFor (1/60);
					fNextOccupant = (fNextOccupant == Board::eX)? Board::eO: Board::eX;
				}
				AnnounceWinner (winner, Board::eEmpty);
			}
			return (True);
	}
	return (False);
}

Boolean	TicTacToeView::HandleKeyStroke (const KeyStroke& /*keyStroke*/)
{
	// why do we override this - why are we a keyhandler at all??? Future extentions I've forgotten???
	// LGP Feb 11, 1992
	return (False);
}

void	TicTacToeView::Layout ()
{
	View::Layout ();
	fLineSize = 0.02 * GetSize ();						// proportional to size of view
	fLineSize.SetV (Max (int (fLineSize.GetV ()), 3));	// at least 3 pixels line size
	fLineSize.SetH (Max (int (fLineSize.GetH ()), 3));	// at least 3 pixels line size

	Point	sizeLeft	=	GetSize () - fLineSize * 2;
	fCellSize = sizeLeft / 3;
}

Boolean	TicTacToeView::PointToCell (const Point& where, Cell& c)
{
	for (CellPosition r = kMinCellPosition; r <= kMaxCellPosition; r++) {
		for (CellPosition col = kMinCellPosition; col <= kMaxCellPosition; col++) {
			if (GetItemRect (Cell (r, col)).Contains (where)) {
				c = Cell (r, col);
				return (True);
			}
		}
	}
	return (False);
}

Rect	TicTacToeView::GetItemRect (const Cell& c)
{
	Point	topLeft	=	(fCellSize + fLineSize) * Point (c.GetRow () - 1, c.GetCol () - 1);
	return (Rect (topLeft, fCellSize));
}

void	TicTacToeView::DrawLines ()
{
	/*
	 * Vertical lines.
	 */
	for (CellPosition i = kMinCellPosition; i < kMaxCellPosition; i++) {
		Point	top		=	Point (0, fCellSize.GetH ()*i + fLineSize.GetH ()*(i-1));
		Point	bottom	=	top + Point (GetSize ().GetV (), 0);
		OutLine (Line (top, bottom), Pen (kBlackTile, eCopyTMode, fLineSize));
	}
	/*
	 * Horizontal lines.
	 */
	for (i = kMinCellPosition; i < kMaxCellPosition; i++) {
		Point	left	=	Point (fCellSize.GetV ()*i + fLineSize.GetV ()*(i-1), 0);
		Point	right	=	left + Point (0, GetSize ().GetH ());
		OutLine (Line (left, right), Pen (kBlackTile, eCopyTMode, fLineSize));
	}
}

void	TicTacToeView::DrawCells ()
{
	for (CellPosition r = kMinCellPosition; r <= kMaxCellPosition; r++) {
		for (CellPosition c = kMinCellPosition; c <= kMaxCellPosition; c++) {
			DrawCell (Cell (r, c));
		}
	}
}

void	TicTacToeView::DrawCell (const Cell& c)
{
	switch (GetCell (c)) {
		case Board::eX:		BitBlit (GetX (), GetX ().GetBounds (), GetItemRect (c));	break;
		case Board::eO:		BitBlit (GetO (), GetO ().GetBounds (), GetItemRect (c));	break;
		case Board::eEmpty:	break;
		default:			AssertNotReached ();
		break;
	}
}





// For gnuemacs:
// Local Variables: ***
// mode:C++ ***
// tab-width:4 ***
// End: ***

