/*
 * SonarQube Java
 * Copyright (C) 2012-2024 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonar.java.model.statement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

import javax.annotation.Nullable;
import java.util.Objects;

public class ForStatementTreeImpl extends JavaTree implements ForStatementTree {
  private final InternalSyntaxToken forKeyword;
  private final InternalSyntaxToken openParenToken;
  private final ListTree<StatementTree> initializer;
  private final InternalSyntaxToken firstSemicolonToken;
  @Nullable
  private final ExpressionTree condition;
  private final InternalSyntaxToken secondSemicolonToken;
  private final ListTree<StatementTree> update;
  private final InternalSyntaxToken closeParenToken;
  private final StatementTree statement;

  public ForStatementTreeImpl(InternalSyntaxToken forKeyword, InternalSyntaxToken openParenToken, ListTree<StatementTree> initializer,
    InternalSyntaxToken firstSemicolonToken, @Nullable ExpressionTree condition, InternalSyntaxToken secondSemicolonToken, ListTree<StatementTree> update,
    InternalSyntaxToken closeParenToken, StatementTree statement) {
    this.forKeyword = forKeyword;
    this.openParenToken = openParenToken;
    this.initializer = Objects.requireNonNull(initializer);
    this.firstSemicolonToken = firstSemicolonToken;
    this.condition = condition;
    this.secondSemicolonToken = secondSemicolonToken;
    this.update = Objects.requireNonNull(update);
    this.closeParenToken = closeParenToken;
    this.statement = Objects.requireNonNull(statement);
  }

  @Override
  public Kind kind() {
    return Kind.FOR_STATEMENT;
  }

  @Override
  public SyntaxToken forKeyword() {
    return forKeyword;
  }

  @Override
  public SyntaxToken openParenToken() {
    return openParenToken;
  }

  @Override
  public ListTree<StatementTree> initializer() {
    return initializer;
  }

  @Override
  public SyntaxToken firstSemicolonToken() {
    return firstSemicolonToken;
  }

  @Nullable
  @Override
  public ExpressionTree condition() {
    return condition;
  }

  @Override
  public SyntaxToken secondSemicolonToken() {
    return secondSemicolonToken;
  }

  @Override
  public ListTree<StatementTree> update() {
    return update;
  }

  @Override
  public SyntaxToken closeParenToken() {
    return closeParenToken;
  }

  @Override
  public StatementTree statement() {
    return statement;
  }

  @Override
  public void accept(TreeVisitor visitor) {
    visitor.visitForStatement(this);
  }

  @Override
  public List<Tree> children() {
    List<Tree> list = new ArrayList<>();
    list.add(forKeyword);
    list.add(openParenToken);
    list.add(initializer);
    list.add(firstSemicolonToken);
    if (condition != null) {
      list.add(condition);
    }
    list.add(secondSemicolonToken);
    list.add(update);
    list.add(closeParenToken);
    list.add(statement);

    return Collections.unmodifiableList(list);
  }

}
